/* erate_evolve.h
 *
 *
 * ER, Fri Feb 29 09:31:10 EST 2008
 */

#define MAXNAME 10

/* define the evolutionary model using a F84 substitution model*/
typedef struct {
  double  ttr;   /* transitions to transversions ratio */
  double  alpha;
  double  beta;
  double  ins;   /* rate of insertions */
  double  del;   /* rate of deletions */
  double  bernoulli; /* probability bernoulli parameter for ancestral length distribution */
  int     isfixlen;

  /* residue frequencies */
  int     dim;
  double *frq;
} ERATE;

typedef struct {
  int    dim;
  double p;   /* bernoulli frequency for ancestral sequences */
  double t;   /* divergence time */
  double xit;
  double gammat;
  ESL_DMATRIX *M; /* substitutions */

} TERATE;

extern ERATE  *Erate_Create(int dim, double ttr, double ins, double del, 
			    double bernoulli, double *freq, int isfixlen, char *errbuff);
extern void    Erate_Destroy(ERATE *erate);
extern void    Erate_Dump(FILE *fp, ERATE *erate);
extern int     Erate_Generate_Alignment(ERATE *erate, ESL_TREE *T, 
				       ESL_MSA **ret_msa, int be_verbose);
extern TERATE *TErate_Create(ERATE *E, double time);
extern void    TErate_Destroy(TERATE *terate);
extern void    TErate_Dump(FILE *fp, TERATE *terate);
extern int     Write_Phylip(FILE *fp, const ESL_MSA *msa);
