/* ER, Thu Oct  5 11:32:07 EDT 2006
 * modification of dnaml.c from phylip 3.66
 *
 * DEV copy
 */
#include "esl_config.h"

#include "phylip-erate.h"
#include "seq-erate.h"

#include <easel.h>
#include <esl_vectorops.h>
#include <esl_minimizer.h>
#include <esl_tree.h>
#include <esl_dmatrix.h>
#include <esl_random.h>
#include <esl_stack.h>
#include <esl_vectorops.h>

/* version 3.6. (c) Copyright 1993-2004 by the University of Washington.
   Written by Joseph Felsenstein, Akiko Fuseki, Sean Lamont, Andrew Keeffe,
   Dan Fineman, and Patrick Colacurcio.
   Permission is granted to copy and use this program provided no fee is
   charged for it and provided that this copyright notice is not removed. */

typedef struct valrec {
  double rat, ratxi, ratxv, orig_zz, z1, y1, z1zz, z1yy, xiz1, xiy1xv;
  double *ww, *zz, *wwzz, *vvzz; 
} valrec;
typedef struct valrec_erate {
  double rat, ratxi, ratxv, orig_zz, z1, y1, z1zz, z1yy, xiz1, xiy1xv;
  double *ww, *zz, *wwzz, *vvzz; 

  /* added parameters for the extended gap model */
  double ratxl;     /* rate of insertions */
  double ratxm;     /* rate of deletions  */
  double gprior;    /* geometric probability prior */

  /* The average rate of change. 
   * We add it here, because it will change as the parameters change
   * when we optimize.
   */
  double ratfracchange;

  double i1, g1, k1;

  double i1l, g1l, k1l;
  double i1r, g1r, k1r;

  double *ii, *gg, *kk;  /* added pointers  */
} valrec_erate;

/* structures for minimization */
enum mstrategy { DEFAULT_BMIN, CG_BMIN, MIX_ALTMIN, CG_ALTMIN, CG_FULLMIN };

struct minimize_erate_data {
  long               endsite_erate; /* total number of unique columns inclusive of the two extra:
				      "allgaps" and "immortal link" columns */
  tree_erate        *tree;
  valrec_erate    ***table_erate;
  int                nrate;       /* number of rate paramters to optimize */
  int                nbranch;     /* number of branch lengths to optimize */
  enum mstrategy     mstrategy;   /* the optimization strategy            */
  int                extrictpos;  /* optimization flag to keep gap param extrictly 
				   * positive for alignments with gaps */
  double             alen;        /* alignment length, remove allgap columns */
  double             slen;        /* average length of sequences */
  double             subsexp;     /* value of rate parameter combination alpha+beta */
  double             indlexpl;    /* min value of rate parameter combination lambda+mu  */
  double             indlexph;    /* max value of rate parameter combination lambda+mu  */
  double             maxbranch;   /* max value of a branch length */
  double             tol;
  int                verbose;
};

typedef long vall[maxcategs];typedef double contribarr[maxcategs]; 
#ifndef OLDC
/* function prototypes */
void   dnamlcopy(tree *, tree *, long, long);
void   dnamlcopy_erate(tree_erate *, tree_erate *, long, long, long);
void   getoptions(void);
void   getoptions_erate(void);
void   allocrest(void);
void   doinit(void);
void   doinit_erate(tree_erate *, tree_erate *, tree_erate *, tree_erate *);
void   inputoptions(void);
void   makeweights(void);
void   makeweights_erate(long *);
void   getinput(void);
void   getinput_erate(long *,tree_erate *, tree_erate *, tree_erate *, tree_erate *,  int *);
void   inittable_for_usertree(FILE *);
void   inittable_for_usertree_erate(FILE *, valrec_erate ***);
void   inittable(void);
void   inittable_erate(long, valrec_erate ****, int);
double evaluate(node *, boolean);
double evaluate_erate(tree_erate *, node_erate *, valrec_erate ***, long, boolean, double, int);
void   alloc_nvd (long, nuview_data *);
void   alloc_nvd_erate (long, nuview_data_erate *);
void   free_nvd (nuview_data *);
void   free_nvd_erate (nuview_data_erate *);
void   nuview(node *); 
void   nuview_erate(node_erate *, valrec_erate ***, long, double);
void   slopecurv(node *, double, double *, double *, double *);
int    slopecurv_erate(long, tree_erate *, node_erate *, 
		       valrec_erate ***, double *, double *, double *, double);
void   makenewv(node *);
void   makenewv_erate(long, tree_erate *, node_erate *, valrec_erate ***, double, int);
void   update(node *);
void   update_erate(tree_erate *, node_erate *, valrec_erate ***, long, boolean, double, int);
void   smooth(node *);
void   smooth_erate(tree_erate *, node_erate *, valrec_erate ***, long, boolean, double, int);
void   insert_(node *, node *, boolean);
void   insert_erate_(tree_erate *, valrec_erate ***, node_erate *, node_erate *, long, boolean, boolean, double, int);
void   dnaml_re_move(node **, node **);
void   dnaml_re_move_erate(tree_erate *, valrec_erate ***, node_erate **, node_erate **, long, boolean, double, int);
void   buildnewtip(long, tree *);
void   buildnewtip_erate(long, long, tree_erate *);
void   buildsimpletree(tree *);
void   buildsimpletree_erate(tree_erate *, valrec_erate ***, long, boolean, double, int);
void   addtraverse(node *, node *, boolean);
void   addtraverse_erate(long, tree_erate *, tree_erate *, tree_erate *, valrec_erate ***, 
			 node_erate *, node_erate *, boolean, boolean, double, int);
void   rearrange(node *, node *);
void   rearrange_erate(long, tree_erate *, tree_erate *, tree_erate *, valrec_erate ***, node_erate *, node_erate *, 
		       boolean, double, int);
void   initdnamlnode(node **, node **, node *, long, long, long *, long *,
		     initops, pointarray, pointarray, Char *, Char *, FILE *);
void   initdnamlnode_erate(node_erate **, node_erate **, node_erate *, long, long, long *, long *,
			   initops, pointarray_erate, pointarray_erate, Char *, Char *, FILE *, 
			   double,long);
void   dnaml_coordinates(node *, double, long *, double *);
void   dnaml_coordinates_erate(tree_erate *, node_erate *, double, long *, double *, double);
void   dnaml_printree(void);
void   dnaml_printree_erate(tree_erate *, valrec_erate ***);
void   sigma(node *, double *, double *, double *);
void   sigma_erate(long, tree_erate *, valrec_erate ***, node_erate *, 
		   double *, double *, double *, double);
void   describe(node *);
void   describe_erate(long, tree_erate *, valrec_erate ***, node_erate *,double);
void   reconstr(node *, long);
void   reconstr_erate(node_erate *, long);
void   rectrav(node *, long, long);
void   rectrav_erate(node_erate *, long, long);
void   summarize(void);
void   summarize_erate(long, tree_erate *, valrec_erate ***, double);
void   dnaml_treeout(node *);
void   dnaml_treeout_erate(tree_erate *, node_erate *, valrec_erate ***);
void   inittravtree(node *);
void   inittravtree_erate(node_erate *);
void   treevaluate(void);
void   treevaluate_erate(tree_erate *, valrec_erate ***, long, boolean, double, int);
void   maketree(void);
void   maketree_erate(long, tree_erate *, tree_erate *, tree_erate *, tree_erate *, 
		      valrec_erate ***, int, enum mstrategy, int, 
		      double, double, double, double, double);
void   clean_up(void);
void   reallocsites(void);
void   globrearrange(void);
void   globrearrange_erate(long, tree_erate *, tree_erate *, tree_erate *, valrec_erate ***, boolean, double, int);
void   dnaml_unroot_here(node *, node **, long);
void   dnaml_unroot(node *, node **, long);
void   dnaml_unroot_erate(long, tree_erate *, node_erate *, node_erate **, long);
void   freetable(void);
void   freetable_erate(valrec_erate ***);
void   alloclrsaves(void);
void   alloclrsaves_erate(long);
void   resetlrsaves(void);
void   resetlrsaves_erate(long,long);
void   freelrsaves(void);
void   freelrsaves_erate(long);
/* function prototypes */

/* ER: function prototypes for dealing with a rooted tree
 *     correspondence in dnaml
 */
void   nuview_onenode_erate(phenotype_erate *p_xx, double **ret_underflows, node_erate *p, 
			    double t, valrec_erate ***table_erate, long endsite_erate, double tol);
double evaluate_rooted_erate(tree_erate *tree, valrec_erate ***table_erate, long endsite_erate, 
			     boolean saveit, double tol, int verbose);

/* ER: function prototypes for minimization without
 *     correspondence in dnaml
 */
static int    addspecies_erate(long p, long spp, long endsite_erate,  
			       tree_erate *tree, tree_erate *besttree, tree_erate *priortree, 
			       valrec_erate ***table_erate, 
			       boolean optimize, double tol, int verbose);
static int    addthreespecies_erate(tree_erate *tree, valrec_erate ***table_erate, long, 
				    boolean optimize, double tol, int verbose);
static double addspecies_erate_alternate_func(double *p, int np, void *dptr);
static double addspecies_erate_joint_func(double *p, int np, void *dptr);
static int    addspecies_erate_cg_bminimizer(long sp, long spp, long endsite_erate,  
					     tree_erate *tree, tree_erate *besttree, tree_erate *priortree,
					     valrec_erate ***table_erate, 
					     double maxbranch, double tol, int verbose);
static int    addspecies_erate_altminimizer(long sp, long spp, long endsite_erate,  
					    tree_erate *tree, 
					    tree_erate *besttree, tree_erate *priortree, 
					    valrec_erate ***table_erate,  
					    int nrateparam, enum mstrategy, int extrictpos, 
					    double subsexp, double indlexpl, double indlexph, 
					    double maxbranch, double tol, int verbose);
static int    addspecies_erate_fullminimizer(long sp, long spp, long endsite_erate,  
					     tree_erate *tree, 
					     tree_erate *besttree, tree_erate *priortree, 
					     valrec_erate ***table_erate,  
					     int nrateparam, enum mstrategy mstrategy, 
					     int extrictpos, int alen, double slen,
					     double subsexp, double indlexpl, double indlexph, 
					     double maxbranch, double tol, int verbose);
static int    addspecies_erate_mstrategy(long sp, long spp, long endsite_erate,  
					 tree_erate *tree, 
					 tree_erate *besttree, tree_erate *priortree, 
					 valrec_erate ***table_erate, 
					 int nrateparam, enum mstrategy, int extrictpos, 
					 double subsexp, double indlexpL, double indlexph,
					 double maxbranch, double tol, int verbose);
static int    buildtree_erate(long spp, long endsite_erate,  
			      tree_erate *tree, 
			      tree_erate *besttree, tree_erate *priortree, 
			      valrec_erate ***table_erate,
			      int nrateparam, enum mstrategy mstrategy, int extrictpos, 
			      double subsexp, double indlexpl, double indlexph, 
			      double maxbranch, double tol, int verbose);
static void   branch_erate_pack_paramvector(double *p, int np, tree_erate *tree, int verbose);
static void   branch_erate_unpack_paramvector(double *p, int np, tree_erate *tree, double maxbranch, int verbose);
static double branch_erate_func(double *p, int np, void *dptr);
static int    branch_erate_minimizer(struct minimize_erate_data *data);
static void   fullparam_erate_pack_paramvector(double *p, int np, struct minimize_erate_data *data);
static void   fullparam_erate_unpack_paramvector(double *p, int np, struct minimize_erate_data *data);
static void   rateparam_erate_pack_paramvector(double *p, long np, struct minimize_erate_data *data);
static void   rateparam_erate_unpack_paramvector(double *p, long np, struct minimize_erate_data *data);
static void   tree_likelihood_erate(long, tree_erate *tree, node_erate *p, valrec_erate ***table_erate, 
				    node_erate **bestnode, double tol, int verbose);
static void   tree_likelihood_descent_erate(long, tree_erate *tree, node_erate *p, valrec_erate ***table_erate, 
					    node_erate **bestnode, double *ret_bestlikelihood, 
					    double tol, int verbose);
static void   smooth_erate_minimizer(struct minimize_erate_data *data);
static double treevaluate_erate_alternate_func(double *p, int np, void *dptr);
static double treevaluate_erate_joint_func(double *p, int np, void *dptr);
static void   treevaluate_erate_cg_bminimizer(long endsite_erate, tree_erate *tree, valrec_erate ***table_erate,
					      double maxbranch, double tol, int verbose);
static int    treevaluate_erate_altminimizer(long endsite_erate,
					     tree_erate *tree, valrec_erate ***table_erate,
					     int nrateparam, enum mstrategy, int extrictpos,
					     double subsexp, double indlexpl, double indlexph, 
					     double maxbranch, double tol, int verbose);
static int    treevaluate_erate_fullminimizer(long endsite_erate,
					      tree_erate *tree, valrec_erate ***table_erate, 
					      int nrateparam, enum mstrategy mstrategy, int extrictpos,
					      long alen, double slen,
					      double subsexp, double indlexpl, double indlexph,
					      double maxbranch, double tol, int verbose);
static int    treevaluate_erate_mstrategy(long endsite_erate,
					  tree_erate *tree, valrec_erate ***table_erate, 
					  int nrateparam, enum mstrategy, int extrictpos, 
					  double subsexp, double indlexpl, double indlexph, 
					  double maxbranch, double tol, int donothing, int verbose);

/* function prototypes for minimization */

#endif

/* local rearrangements need to save views.  created globally so that *
 * reallocation of the same variable is unnecessary                   */
node **lrsaves;
node_erate **lrsaves_erate;

long oldendsite;
double fracchange;
long rcategs;
boolean haslengths;

Char infilename[FNMLNGTH], outfilename[FNMLNGTH], intreename[FNMLNGTH], 
     outtreename[FNMLNGTH], catfilename[FNMLNGTH], weightfilename[FNMLNGTH];
double *rate, *rrate, *probcat;
long nonodes2, sites, weightsum, categs, datasets, ith, njumble, jumb;
long parens;
boolean  freqsfrom, global, jumble, weights, trout, usertree,
  ctgry, rctgry, auto_, hypstate, ttr, progress, mulsets, justwts,
  firstset, improve, smoothit, polishing, lngths, gama, invar,inserting=false;
tree curtree, bestree, bestree2, priortree;
node *qwhere, *grbg, *addwhere;
node_erate *qwhere_erate, *grbg_erate, *addwhere_erate;
boolean  freqofrom;

/* optimization paramters.
 * default is 
 * CG_FULLMIN = conjugate gradient full optimization of branch lengths and gap parameters 
 *
 * other options:
 *                6 = optimize all 4 rate parameters 
 *                7 = optimize only branch lengths using the dnaml method 
 *                8 = optimize only branch lengths using conjugate gradient descent 
 *
 */
boolean optrate;       /* TRUE = optimize all 4 rate parameters */
boolean branchopt;     /* TRUE = optimize only branch lengths using the dnaml method */
boolean cg_branchopt;  /* TRUE = optimize only branch lengths using conjugate gradient decent */

/* the parameter of the F84 model [FelsensteinChurchill96]
 * xi = beta
 * xv = alpha
 * freqa, freqc, freqg, freqt (the stationary probabilities)
 *
 * added parameters for gaps:
 * xl    = lambda (rate of insertions)
 * xl    = mu (rate of deletions)
 * xk    = decay factor for gap marginal probability
 * freqo = gap frequency
 *
 */
double xi, xv, ttratio, ttratio0, freqa, freqc, freqg, freqt, freqr,
  freqy, freqar, freqcy, freqgr, freqty, 
  cv, alpha, lambda, invarfrac, bestyet;
double xl, xm, freqo;
long *enterorder, inseed, inseed0;
steptr aliasweight;
contribarr *contribution, like, nulike, clai; 
double **term, **slopeterm, **curveterm;
longer seed;
Char* progname;
char basechar[16]="acmgrsvtwyhkdbn";

/* Local variables for maketree, propagated globally for c version: */
long k, nextsp, numtrees, maxwhich, mx, mx0, mx1, shimotrees;
double dummy, maxlogl;
boolean succeeded, smoothed;
double **l0gf;
double *l0gl;
valrec ***tbl;
Char ch, ch2;
long col;
vall *mp=NULL;

void dnamlcopy(tree *a, tree *b, long nonodes, long categs)
{
  /* copies tree a to tree b*/
  /* assumes bifurcation (OK) */
  long i, j;
  node *p, *q;

  for (i = 0; i < spp; i++) {
    copynode(a->nodep[i], b->nodep[i], categs);
    if (a->nodep[i]->back) {
      if (a->nodep[i]->back == a->nodep[a->nodep[i]->back->index - 1])
        b->nodep[i]->back = b->nodep[a->nodep[i]->back->index - 1];
      else if (a->nodep[i]->back == 
          a->nodep[a->nodep[i]->back->index - 1]->next)
        b->nodep[i]->back = b->nodep[a->nodep[i]->back->index - 1]->next;
      else
        b->nodep[i]->back = b->nodep[a->nodep[i]->back->index - 1]->next->next;
    }
    else b->nodep[i]->back = NULL;
  }
  for (i = spp; i < nonodes; i++) {
    p = a->nodep[i];
    q = b->nodep[i];
    for (j = 1; j <= 3; j++) {
      copynode(p, q, categs);
      if (p->back) {
        if (p->back == a->nodep[p->back->index - 1])
          q->back = b->nodep[p->back->index - 1];
        else if (p->back == a->nodep[p->back->index - 1]->next)
          q->back = b->nodep[p->back->index - 1]->next;
        else
          q->back = b->nodep[p->back->index - 1]->next->next;
     }
      else
        q->back = NULL;
      p = p->next;
      q = q->next;
    }
  }
  b->likelihood = a->likelihood;
  b->start = a->start;               /* start used in dnaml only */
  b->root = a->root;                 /* root used in dnamlk only */
}  /* dnamlcopy plc*/

void dnamlcopy_erate(tree_erate *a, tree_erate *b, long nonodes, long categs, long endsite_erate)
{
  /* copies tree a to tree b*/
  /* assumes bifurcation (OK) */
  long i, j;
  node_erate *p, *q;

  for (i = 0; i < spp; i++) {
    copynode_erate(a->nodep[i], b->nodep[i], categs);
    if (a->nodep[i]->back) {
      if (a->nodep[i]->back == a->nodep[a->nodep[i]->back->index - 1]) {
        b->nodep[i]->back = b->nodep[a->nodep[i]->back->index - 1];
     }
      else if (a->nodep[i]->back == 
	       a->nodep[a->nodep[i]->back->index - 1]->next) {
        b->nodep[i]->back = b->nodep[a->nodep[i]->back->index - 1]->next;
      }
      else {
        b->nodep[i]->back = b->nodep[a->nodep[i]->back->index - 1]->next->next;
	}
    }
    else b->nodep[i]->back = NULL;

  }
  for (i = spp; i < nonodes; i++) {
    p = a->nodep[i];
    q = b->nodep[i];
    for (j = 1; j <= 3; j++) {
      copynode_erate(p, q, categs);
      if (p->back) {
	if (p->back == a->nodep[p->back->index - 1])
	  q->back = b->nodep[p->back->index - 1];
	else if (p->back == a->nodep[p->back->index - 1]->next)
	  q->back = b->nodep[p->back->index - 1]->next;
	else
	  q->back = b->nodep[p->back->index - 1]->next->next;
      }
      else
	q->back = NULL;
      p = p->next;
      q = q->next;
    }
  }
  b->likelihood = a->likelihood;
  b->start = a->start;               /* start used in dnaml only */
  b->root = a->root;                 /* root used in dnamlk only */

  /* copy the root information */
  /*b->root_data = a->root_data;*/
  
  b->root_data->nl = a->root_data->nl;
  b->root_data->nn = a->root_data->nn;

  b->root_data->taxal = a->root_data->taxal;
  b->root_data->taxar = a->root_data->taxar;

  b->root_data->lca = a->root_data->lca;

  b->root_data->taxa_maxdist = a->root_data->taxa_maxdist;

  b->root_data->rootl = a->root_data->rootl;
  b->root_data->rootr = a->root_data->rootr;

  b->root_data->rchildl = a->root_data->rchildl;
  b->root_data->rchildr = a->root_data->rchildr;

  b->root_data->distrootl = a->root_data->distrootl;
  b->root_data->distrootr = a->root_data->distrootr;

  b->root_data->taxa_avedist_byroot = a->root_data->taxa_avedist_byroot;

  for (i = 0; i <= nonodes; i++) {
    b->root_data->cladesize[i] = a->root_data->cladesize[i];
    b->root_data->parent[i]    = a->root_data->parent[i];
  }

}  /* dnamlcopy_erate plc*/


void getoptions()
{
  /* interactively set options */
  long i, loopcount, loopcount2;
  Char ch;
  boolean didchangecat, didchangercat;
  double probsum;

  fprintf(outfile, "\nNucleic acid sequence Maximum Likelihood");
  fprintf(outfile, " method, version %s\n\n",VERSION);
  putchar('\n');
  ctgry = false;
  didchangecat = false;
  rctgry = false;
  didchangercat = false;
  categs = 1;
  rcategs = 1;
  auto_ = false;
  freqsfrom = true;
  gama = false;
  global = false;
  hypstate = false;
  improve = false;
  invar = false;
  jumble = false;
  njumble = 1;
  lngths = false;
  lambda = 1.0;
  outgrno = 1;
  outgropt = false;
  trout = true;
  ttratio = 2.0;
  ttr = false;
  usertree = false;
  weights = false;
  printdata = false;
  dotdiff = true;
  progress = true;
  treeprint = true;
  interleaved = true;
  loopcount = 0;
  for (;;){
    cleerhome();
    printf("Nucleic acid sequence Maximum Likelihood");
    printf(" method, version %s\n\n",VERSION);
    printf("Settings for this run:\n");
    printf("  U                 Search for best tree?  %s\n",
           (usertree ? "No, use user trees in input file" : "Yes"));
    if (usertree) {
      printf("  L          Use lengths from user trees?  %s\n",
               (lngths ? "Yes" : "No"));
    }
    printf("  T        Transition/transversion ratio:%8.4f\n",
           (ttr ? ttratio : 2.0));
    printf("  F       Use empirical base frequencies?  %s\n",
           (freqsfrom ? "Yes" : "No"));
    printf("  C                One category of sites?");
    if (!ctgry || categs == 1)
      printf("  Yes\n");
    else
      printf("  %ld categories of sites\n", categs);
    printf("  R           Rate variation among sites?");
    if (!rctgry)
      printf("  constant rate\n");
    else {
      if (gama)
        printf("  Gamma distributed rates\n");
      else {
        if (invar)
          printf("  Gamma+Invariant sites\n");
        else
          printf("  user-defined HMM of rates\n");
      }
      printf("  A   Rates at adjacent sites correlated?");
      if (!auto_)
        printf("  No, they are independent\n");
      else
        printf("  Yes, mean block length =%6.1f\n", 1.0 / lambda);
    }
    printf("  W                       Sites weighted?  %s\n",
           (weights ? "Yes" : "No"));
    if (!usertree) {
      printf("  S        Speedier but rougher analysis?  %s\n",
             (improve ? "No, not rough" : "Yes"));
      printf("  G                Global rearrangements?  %s\n",
             (global ? "Yes" : "No"));
    }
    if (!usertree) {
      printf("  J   Randomize input order of sequences?");
      if (jumble)
        printf("  Yes (seed =%8ld,%3ld times)\n", inseed0, njumble);
      else
        printf("  No. Use input order\n");
    }
    printf("  O                        Outgroup root?  %s%3ld\n",
           (outgropt ? "Yes, at sequence number" :
                       "No, use as outgroup species"),outgrno);
    printf("  M           Analyze multiple data sets?");
    if (mulsets)
      printf("  Yes, %2ld %s\n", datasets,
               (justwts ? "sets of weights" : "data sets"));
    else
      printf("  No\n");
    printf("  I          Input sequences interleaved?  %s\n",
           (interleaved ? "Yes" : "No, sequential"));
    printf("  0   Terminal type (IBM PC, ANSI, none)?  %s\n",
           (ibmpc ? "IBM PC" : ansi  ? "ANSI" : "(none)"));
    printf("  1    Print out the data at start of run  %s\n",
           (printdata ? "Yes" : "No"));
    printf("  2  Print indications of progress of run  %s\n",
           (progress ? "Yes" : "No"));
    printf("  3                        Print out tree  %s\n",
           (treeprint ? "Yes" : "No"));
    printf("  4       Write out trees onto tree file?  %s\n",
           (trout ? "Yes" : "No"));
    printf("  5   Reconstruct hypothetical sequences?  %s\n",
           (hypstate ? "Yes" : "No"));
    printf("\n  Y to accept these or type the letter for one to change\n");
#ifdef WIN32
    phyFillScreenColor();
#endif
    scanf("%c%*[^\n]", &ch);
    getchar();
    if (ch == '\n')
      ch = ' ';
    uppercase(&ch);
    if (ch == 'Y')
      break;
    if (((!usertree) && (strchr("UTFCRAWSGJVOMI012345", ch) != NULL))
        || (usertree && ((strchr("ULTFCRAWSVOMI012345", ch) != NULL)))){
      switch (ch) {

      case 'F':
        freqsfrom = !freqsfrom;
        if (!freqsfrom) {
          initfreqs(&freqa, &freqc, &freqg, &freqt);
        }
        break;
        
      case 'C':
        ctgry = !ctgry;
        if (ctgry) {
          printf("\nSitewise user-assigned categories:\n\n");
          initcatn(&categs);
          if (rate){
            free(rate);
          }
          rate    = (double *) Malloc(categs * sizeof(double));
          didchangecat = true;
          initcategs(categs, rate);
        }
        break;

      case 'R':
        if (!rctgry) {
          rctgry = true;
          gama = true;
        } else {
          if (gama) {
            gama = false;
            invar = true;
          } else {
            if (invar)
              invar = false;
            else
              rctgry = false;
          }
        }
        break;
        
      case 'A':
        auto_ = !auto_;
        if (auto_)
          initlambda(&lambda);
        break;
        
      case 'W':
        weights = !weights;
        break;
      case 'S':
        improve = !improve;
        break;

      case 'G':
        global = !global;
        break;
        
      case 'J':
        jumble = !jumble;
        if (jumble)
          initjumble(&inseed, &inseed0, seed, &njumble);
        else njumble = 1;
        break;
        
      case 'L':
        lngths = !lngths;
        break;
        
      case 'O':
        outgropt = !outgropt;
        if (outgropt)
          initoutgroup(&outgrno, spp);
        break;
        
      case 'T':
        ttr = !ttr;
        if (ttr) {
          initratio(&ttratio);
        }
        break;
        
      case 'U':
        usertree = !usertree;
        break;

      case 'M':
        mulsets = !mulsets;
        if (mulsets) {
          printf("Multiple data sets or multiple weights?");
          loopcount2 = 0;
          do {
            printf(" (type D or W)\n");
            scanf("%c%*[^\n]", &ch2);
            getchar();
            if (ch2 == '\n')
              ch2 = ' ';
            uppercase(&ch2);
            countup(&loopcount2, 10);
          } while ((ch2 != 'W') && (ch2 != 'D'));
          justwts = (ch2 == 'W');
          if (justwts)
            justweights(&datasets);
          else
            initdatasets(&datasets);
          if (!jumble) {
            jumble = true;
            initjumble(&inseed, &inseed0, seed, &njumble);
          }
        }
        break;
        
      case 'I':
        interleaved = !interleaved;
        break;
        
      case '0':
        initterminal(&ibmpc, &ansi);
        break;
        
      case '1':
        printdata = !printdata;
        break;
        
      case '2':
        progress = !progress;
        break;
        
      case '3':
        treeprint = !treeprint;
        break;
        
      case '4':
        trout = !trout;
        break;

      case '5':
        hypstate = !hypstate;
        break;
      }
    } else
      printf("Not a possible option!\n");
    countup(&loopcount, 100);
  }
  if (gama || invar) {
    loopcount = 0;
    do {
      printf( "\nCoefficient of variation of substitution rate among sites" 
          " (must be positive)\n");
      printf(
  " In gamma distribution parameters, this is 1/(square root of alpha)\n");
#ifdef WIN32
      phyFillScreenColor();
#endif
      scanf("%lf%*[^\n]", &cv);
      getchar();
      countup(&loopcount, 10);
    } while (cv <= 0.0);
    alpha = 1.0 / (cv * cv);
  }
  if (!rctgry)
    auto_ = false;
  if (rctgry) {
    printf("\nRates in HMM");
    if (invar)
      printf(" (including one for invariant sites)");
    printf(":\n");
    initcatn(&rcategs);
    if (probcat){
      free(probcat);
      free(rrate);
    }
    probcat = (double *) Malloc(rcategs * sizeof(double));
    rrate   = (double *) Malloc(rcategs * sizeof(double));
    didchangercat = true;
    if (gama)
      initgammacat(rcategs, alpha, rrate, probcat); 
    else {
      if (invar) {
        loopcount = 0;
        do {
          printf("Fraction of invariant sites?\n");
          scanf("%lf%*[^\n]", &invarfrac);
          getchar();
          countup (&loopcount, 10);
        } while ((invarfrac <= 0.0) || (invarfrac >= 1.0));
        initgammacat(rcategs-1, alpha, rrate, probcat); 
        for (i = 0; i < rcategs-1; i++)
          probcat[i] = probcat[i]*(1.0-invarfrac);
        probcat[rcategs-1] = invarfrac;
        rrate[rcategs-1] = 0.0;
      } else {
        initcategs(rcategs, rrate);
        initprobcat(rcategs, &probsum, probcat);
      }
    }
  }
  if (!didchangercat){
    rrate      = (double *) Malloc(rcategs*sizeof(double));
    probcat    = (double *) Malloc(rcategs*sizeof(double));
    rrate[0]   = 1.0;
    probcat[0] = 1.0;
  }
  if (!didchangecat){
    rate       = (double *) Malloc(categs*sizeof(double));
    rate[0]    = 1.0;
  }
}  /* getoptions */


void getoptions_erate()
{
  /* interactively set options */
  long i, loopcount, loopcount2;
  Char ch;
  boolean didchangecat, didchangercat;
  double probsum;

  fprintf(outfile, "\nNucleic acid sequence Maximum Likelihood");
  fprintf(outfile, " method, version %s\n",VERSION);
  fprintf(outfile, " **dnaml-erate version %s: dnaml augmented with gaps**\n\n", ERATE_VERSION);
  putchar('\n');
  ctgry = false;
  didchangecat = false;
  rctgry = false;
  didchangercat = false;
  categs = 1;
  rcategs = 1;
  auto_ = false;
  freqsfrom = true;
  freqofrom = true;
  gama = false;
  global = false;
  hypstate = false;
  optrate = false;
  branchopt = false;
  cg_branchopt = false;
  improve = false;
  invar = false;
  jumble = false;
  njumble = 1;
  lngths = false;
  lambda = 1.0;
  outgrno = 1;
  outgropt = false;
  trout = true;
  ttratio = 2.0;
  ttr = false;
  usertree = false;
  weights = false;
  printdata = false;
  dotdiff = true;
  progress = true;
  treeprint = true;
  interleaved = true;
  loopcount = 0;
  for (;;){
    cleerhome();
    printf("Nucleic acid sequence Maximum Likelihood");
    printf(" method, version %s\n",VERSION);
    printf(" **dnaml-erate version %s: dnaml augmented with gaps**\n\n", ERATE_VERSION);
    printf("Settings for this run:\n");
    printf("  U                 Search for best tree?  %s\n",
           (usertree ? "No, use user trees in input file" : "Yes"));
    if (usertree) {
      printf("  L          Use lengths from user trees?  %s\n",
               (lngths ? "Yes" : "No"));
    }
    printf("  T        Transition/transversion ratio:%8.4f\n",
           (ttr ? ttratio : 2.0));
    printf("  F       Use empirical base frequencies?  %s\n",
           (freqsfrom ? "Yes" : "No"));
    printf("  C                One category of sites?");
    if (!ctgry || categs == 1)
      printf("  Yes\n");
    else
      printf("  %ld categories of sites\n", categs);
    printf("  R           Rate variation among sites?");
    if (!rctgry)
      printf("  constant rate\n");
    else {
      if (gama)
        printf("  Gamma distributed rates\n");
      else {
        if (invar)
          printf("  Gamma+Invariant sites\n");
        else
          printf("  user-defined HMM of rates\n");
      }
      printf("  A   Rates at adjacent sites correlated?");
      if (!auto_)
        printf("  No, they are independent\n");
      else
        printf("  Yes, mean block length =%6.1f\n", 1.0 / lambda);
    }
    printf("  W                       Sites weighted?  %s\n",
           (weights ? "Yes" : "No"));
    if (!usertree) {
      printf("  S        Speedier but rougher analysis?  %s\n",
             (improve ? "No, not rough" : "Yes"));
      printf("  G                Global rearrangements?  %s\n",
             (global ? "Yes" : "No"));
    }
    if (!usertree) {
      printf("  J   Randomize input order of sequences?");
      if (jumble)
        printf("  Yes (seed =%8ld,%3ld times)\n", inseed0, njumble);
      else
        printf("  No. Use input order\n");
    }
    printf("  O                        Outgroup root?  %s%3ld\n",
           (outgropt ? "Yes, at sequence number" :
                       "No, use as outgroup species"),outgrno);
    printf("  M           Analyze multiple data sets?");
    if (mulsets)
      printf("  Yes, %2ld %s\n", datasets,
               (justwts ? "sets of weights" : "data sets"));
    else
      printf("  No\n");
    printf("  I          Input sequences interleaved?  %s\n",
           (interleaved ? "Yes" : "No, sequential"));
    printf("  0   Terminal type (IBM PC, ANSI, none)?  %s\n",
           (ibmpc ? "IBM PC" : ansi  ? "ANSI" : "(none)"));
    printf("  1    Print out the data at start of run  %s\n",
           (printdata ? "Yes" : "No"));
    printf("  2  Print indications of progress of run  %s\n",
           (progress ? "Yes" : "No"));
    printf("  3                        Print out tree  %s\n",
           (treeprint ? "Yes" : "No"));
    printf("  4       Write out trees onto tree file?  %s\n",
           (trout ? "Yes" : "No"));
    printf("  5   Reconstruct hypothetical sequences?  %s\n",
           (hypstate ? "Yes" : "No"));
    printf("  6              Optimize branches only ?  %s\n",
           (branchopt ? "Yes" : "No"));
    if (branchopt) {
      printf("  B     Conjugate gradient descent method?  %s\n",
	     (cg_branchopt ? "Yes" : "No. Use standard dnaml method"));
    }
    else {
      printf("  7         Optimize all rate parameters?  %s\n",
	     (optrate ? "Yes" : "No. Only the gap parameters"));
    }
    printf("  8       Use empirical gap frequencies?  %s\n",
           (freqofrom ? "Yes" : "No"));
    printf("\n  Y to accept these or type the letter for one to change\n");
#ifdef WIN32
    phyFillScreenColor();
#endif
    scanf("%c%*[^\n]", &ch);
    getchar();
    if (ch == '\n')
      ch = ' ';
    uppercase(&ch);
    if (ch == 'Y')
      break;
    if (((!usertree) && (strchr("UTFCRAWSGJVOMI0123456B78", ch) != NULL))
        || (usertree && ((strchr("ULTFCRAWSVOMI0123456B78", ch) != NULL)))){
      switch (ch) {

      case 'F':
        freqsfrom = !freqsfrom;
        if (!freqsfrom) {
          initfreqs(&freqa, &freqc, &freqg, &freqt);
        }
        break;
        
      case 'C':
        ctgry = !ctgry;
        if (ctgry) {
          printf("\nSitewise user-assigned categories:\n\n");
          initcatn(&categs);
          if (rate){
            free(rate);
          }
          rate    = (double *) Malloc(categs * sizeof(double));
          didchangecat = true;
          initcategs(categs, rate);
        }
        break;

      case 'R':
        if (!rctgry) {
          rctgry = true;
          gama = true;
        } else {
          if (gama) {
            gama = false;
            invar = true;
          } else {
            if (invar)
              invar = false;
            else
              rctgry = false;
          }
        }
        break;
        
      case 'A':
        auto_ = !auto_;
        if (auto_)
          initlambda(&lambda);
        break;
        
      case 'W':
        weights = !weights;
        break;

      case 'S':
        improve = !improve;
        break;

      case 'G':
        global = !global;
        break;
        
      case 'J':
        jumble = !jumble;
        if (jumble)
          initjumble(&inseed, &inseed0, seed, &njumble);
        else njumble = 1;
        break;
        
      case 'L':
        lngths = !lngths;
        break;
        
      case 'O':
        outgropt = !outgropt;
        if (outgropt)
          initoutgroup(&outgrno, spp);
        break;
        
      case 'T':
        ttr = !ttr;
        if (ttr) {
          initratio(&ttratio);
        }
        break;
        
      case 'U':
        usertree = !usertree;
        break;

      case 'M':
        mulsets = !mulsets;
        if (mulsets) {
          printf("Multiple data sets or multiple weights?");
          loopcount2 = 0;
          do {
            printf(" (type D or W)\n");
            scanf("%c%*[^\n]", &ch2);
            getchar();
            if (ch2 == '\n')
              ch2 = ' ';
            uppercase(&ch2);
            countup(&loopcount2, 10);
          } while ((ch2 != 'W') && (ch2 != 'D'));
          justwts = (ch2 == 'W');
	  if (justwts)
            justweights(&datasets);
          else
            initdatasets(&datasets);
          if (!jumble) {
            jumble = true;
            initjumble(&inseed, &inseed0, seed, &njumble);
          }
        }
        break;
        
      case 'I':
        interleaved = !interleaved;
        break;
        
      case '0':
        initterminal(&ibmpc, &ansi);
        break;
        
      case '1':
        printdata = !printdata;
        break;
        
      case '2':
        progress = !progress;
        break;
        
      case '3':
        treeprint = !treeprint;
        break;
        
      case '4':
        trout = !trout;
        break;

      case '5':
        hypstate = !hypstate;
        break;
	
      case '6':
        branchopt = !branchopt;
        break;
	
      case 'B':
        cg_branchopt = !cg_branchopt;
        break;
	
      case '7':
        optrate = !optrate;
        break;

      case '8':
        freqofrom = !freqofrom;
        if (!freqofrom) {
          initfreqo(&freqo);
        }
        break;
	
      }
    } else
      printf("Not a possible option!\n");
    countup(&loopcount, 100);
  }
  if (gama || invar) {
    loopcount = 0;
    do {
      printf( "\nCoefficient of variation of substitution rate among sites" 
          " (must be positive)\n");
      printf(
  " In gamma distribution parameters, this is 1/(square root of alpha)\n");
#ifdef WIN32
      phyFillScreenColor();
#endif
      scanf("%lf%*[^\n]", &cv);
      getchar();
      countup(&loopcount, 10);
    } while (cv <= 0.0);
    alpha = 1.0 / (cv * cv);
  }
  if (!rctgry)
    auto_ = false;
  if (rctgry) {
    printf("\nRates in HMM");
    if (invar)
      printf(" (including one for invariant sites)");
    printf(":\n");
    initcatn(&rcategs);
    if (probcat){
      free(probcat);
      free(rrate);
    }
    probcat = (double *) Malloc(rcategs * sizeof(double));
    rrate   = (double *) Malloc(rcategs * sizeof(double));
    didchangercat = true;
    if (gama)
      initgammacat(rcategs, alpha, rrate, probcat); 
    else {
      if (invar) {
        loopcount = 0;
        do {
          printf("Fraction of invariant sites?\n");
          scanf("%lf%*[^\n]", &invarfrac);
          getchar();
          countup (&loopcount, 10);
        } while ((invarfrac <= 0.0) || (invarfrac >= 1.0));
        initgammacat(rcategs-1, alpha, rrate, probcat); 
        for (i = 0; i < rcategs-1; i++)
          probcat[i] = probcat[i]*(1.0-invarfrac);
        probcat[rcategs-1] = invarfrac;
        rrate[rcategs-1] = 0.0;
      } else {
        initcategs(rcategs, rrate);
        initprobcat(rcategs, &probsum, probcat);
      }
    }
  }
  if (!didchangercat){
    rrate      = (double *) Malloc(rcategs*sizeof(double));
    probcat    = (double *) Malloc(rcategs*sizeof(double));
    rrate[0]   = 1.0;
    probcat[0] = 1.0;
  }
  if (!didchangecat){
    rate       = (double *) Malloc(categs*sizeof(double));
    rate[0]    = 1.0;
  }
}  /* getoptions_erate */


void reallocsites(void)
{
  long i;

  for (i=0; i < spp; i++) {
    free(y[i]);
    y[i] = (Char *) Malloc(sites*sizeof(Char));
  }
  free(category);
  free(weight);
  free(alias);
  free(ally);
  free(location);
  free(aliasweight);

  category    = (long *) Malloc(sites*sizeof(long));
  weight      = (long *) Malloc(sites*sizeof(long));
  alias       = (long *) Malloc(sites*sizeof(long));
  ally        = (long *) Malloc(sites*sizeof(long));
  location    = (long *) Malloc(sites*sizeof(long));
  aliasweight = (long *) Malloc(sites*sizeof(long));

}


void allocrest()
{
  long i;

  y = (Char **) Malloc(spp*sizeof(Char *));
  for (i = 0; i < spp; i++)
    y[i] = (Char *) Malloc(sites*sizeof(Char));
  nayme       = (naym *) Malloc(spp*sizeof(naym));
  enterorder  = (long *) Malloc(spp*sizeof(long));
  category    = (long *) Malloc(sites*sizeof(long));
  weight      = (long *) Malloc(sites*sizeof(long));
  alias       = (long *) Malloc(sites*sizeof(long));
  ally        = (long *) Malloc(sites*sizeof(long));
  location    = (long *) Malloc(sites*sizeof(long));
  aliasweight = (long *) Malloc(sites*sizeof(long));
}  /* allocrest */


void doinit()
{ /* initializes variables */

  inputnumbers(&spp, &sites, &nonodes2, 1);
  getoptions();
  if (printdata)
    fprintf(outfile, "%2ld species, %3ld  sites\n", spp, sites);
  alloctree(&curtree.nodep, nonodes2, usertree);
  allocrest();
  if (usertree)
    return;
  alloctree(&bestree.nodep, nonodes2, 0);
  alloctree(&priortree.nodep, nonodes2, 0);
  if (njumble <= 1)
    return;
  alloctree(&bestree2.nodep, nonodes2, 0);
}  /* doinit */

void doinit_erate(tree_erate *curtree_erate, tree_erate *besttree_erate, 
		  tree_erate *besttree2_erate, tree_erate *priortree_erate)
{ /* initializes variables */

  inputnumbers(&spp, &sites, &nonodes2, 1);
  getoptions_erate();
  if (printdata)
    fprintf(outfile, "%2ld species, %3ld  sites\n", spp, sites);
  alloctree_erate(curtree_erate, nonodes2, usertree);
  allocrest();
  if (usertree)
    return;
  alloctree_erate(besttree_erate, nonodes2, 0);
  alloctree_erate(priortree_erate, nonodes2, 0);
   if (njumble <= 1)
    return;
  alloctree_erate(besttree2_erate, nonodes2, 0);
}  /* doinit_erate */


void inputoptions()
{
  long i;

  if (!firstset && !justwts) {
    samenumsp(&sites, ith);
    reallocsites();
  }
  for (i = 0; i < sites; i++)
    category[i] = 1;
  for (i = 0; i < sites; i++)
    weight[i] = 1;
  
  if (justwts || weights)
    inputweights(sites, weight, &weights);
  weightsum = 0;
  for (i = 0; i < sites; i++)
    weightsum += weight[i];
  if (ctgry && categs > 1) {
    inputcategs(0, sites, category, categs, "DnaML");
    if (printdata)
      printcategs(outfile, sites, category, "Site categories");
  }
  if (weights && printdata)
    printweights(outfile, 0, sites, weight, "Sites");
}  /* inputoptions */


void makeweights()
{
  /* make up weights vector to avoid duplicate computations */
  long i;

  for (i = 1; i <= sites; i++) {
    alias[i - 1] = i;
    ally[i - 1] = 0;
    aliasweight[i - 1] = weight[i - 1];
    location[i - 1] = 0;
  }

  sitesort2   (sites, aliasweight);
  sitecombine2(sites, aliasweight);
  sitescrunch2(sites, 1, 2, aliasweight);
  for (i = 1; i <= sites; i++) {
    if (aliasweight[i - 1] > 0)
      endsite = i;
  }
  for (i = 1; i <= endsite; i++) {
    location[alias[i - 1] - 1] = i;
    ally[alias[i - 1] - 1] = alias[i - 1];
  }
  term = (double **) Malloc( endsite * sizeof(double *));
  for (i = 0; i < endsite; i++)
     term[i] = (double *) Malloc( rcategs * sizeof(double));
  slopeterm = (double **) Malloc( endsite * sizeof(double *));
  for (i = 0; i < endsite; i++)
     slopeterm[i] = (double *) Malloc( rcategs * sizeof(double));
  curveterm = (double **) Malloc(endsite * sizeof(double *));
  for (i = 0; i < endsite; i++)
     curveterm[i] = (double *) Malloc( rcategs * sizeof(double));
  mp = (vall *) Malloc( sites*sizeof(vall));
  contribution = (contribarr *) Malloc( endsite*sizeof(contribarr));
}  /* makeweights */

void makeweights_erate(long *ret_endsite_erate)
{
  /* make up weights vector to avoid duplicate computations */
  long i;
  long endsite_erate;

  for (i = 1; i <= sites; i++) {
    alias[i - 1] = i;
    ally[i - 1] = 0;
    aliasweight[i - 1] = weight[i - 1];
    location[i - 1] = 0;
  }

  sitesort2   (sites, aliasweight);
  sitecombine2(sites, aliasweight);
  sitescrunch2(sites, 1, 2, aliasweight);

  /* Here it determines endsite == the nonidentical columns 
   * in the alignment.
   */
  for (i = 1; i <= sites; i++) {
    if (aliasweight[i - 1] > 0)
      endsite = i;
  }
  for (i = 1; i <= endsite; i++) {
    location[alias[i - 1] - 1] = i;
    ally[alias[i - 1] - 1] = alias[i - 1];
  }

  /* add two more "unique" sites
   *   endsite   - for the all gaps column
   *   endsite+1 - for the immortal link column
   */
  endsite_erate = endsite + 2;

  term = (double **) Malloc( endsite_erate * sizeof(double *));
  for (i = 0; i < endsite_erate; i++)
     term[i] = (double *) Malloc( rcategs * sizeof(double));

  slopeterm = (double **) Malloc( endsite_erate * sizeof(double *));
  for (i = 0; i < endsite_erate; i++)
     slopeterm[i] = (double *) Malloc( rcategs * sizeof(double));

  curveterm = (double **) Malloc(endsite_erate * sizeof(double *));
  for (i = 0; i < endsite_erate; i++)
     curveterm[i] = (double *) Malloc( rcategs * sizeof(double));

  mp = (vall *) Malloc( sites*sizeof(vall));
  contribution = (contribarr *) Malloc( endsite_erate*sizeof(contribarr));

  *ret_endsite_erate = endsite_erate;
}  /* makeweights_erate */


void getinput()
{
  /* reads the input data */
  inputoptions();
  if (!freqsfrom)
    getbasefreqs(freqa, freqc, freqg, freqt, &freqr, &freqy, &freqar, &freqcy,
                 &freqgr, &freqty, &ttratio, &xi, &xv, &fracchange,
                 freqsfrom, true);
  if (!justwts || firstset)
    inputdata(sites);
  if ( !firstset )
    oldendsite = endsite;
  makeweights();
  if ( firstset ) alloclrsaves();
  else  resetlrsaves(); 
  setuptree2(&curtree);
  if (!usertree) {
    setuptree2(&bestree);
    setuptree2(&priortree);
    if (njumble > 1)
      setuptree2(&bestree2);
  }
  allocx(nonodes2, rcategs, curtree.nodep, usertree);
  if (!usertree) {
    allocx(nonodes2, rcategs, bestree.nodep, 0);
    allocx(nonodes2, rcategs, priortree.nodep, 0);
    if (njumble > 1)
      allocx(nonodes2, rcategs, bestree2.nodep, 0);
  }
  makevalues2(rcategs, curtree.nodep, endsite, spp, y, alias);  

  if (freqsfrom) {
    empiricalfreqs(&freqa, &freqc, &freqg, &freqt, aliasweight,
                    curtree.nodep);
    getbasefreqs(freqa, freqc, freqg, freqt, &freqr, &freqy, &freqar, &freqcy,
		 &freqgr, &freqty, &ttratio, &xi, &xv, &fracchange,
		 freqsfrom, true);
  }
  if (!justwts || firstset) 
    fprintf(outfile, "\nTransition/transversion ratio = %10.6f\n\n", ttratio);
}  /* getinput */


void getinput_erate(long *endsite_erate, 
		    tree_erate *curtree_erate, tree_erate *besttree_erate, 
		    tree_erate *besttree2_erate, tree_erate *priortree_erate,
		    int *extrictpos)
{
  long oldendsite_erate;
  double empfreqa = 0.;
  double empfreqc;
  double empfreqg;
  double empfreqt;
  double empfreqo;

  /* reads the input data */
  inputoptions();

  if (!justwts || firstset)
    inputdata(sites);
  if ( !firstset )
    oldendsite_erate = *endsite_erate;

  /* Here is where endsite is defined.
   *
   * endsite is the number of different columns present 
   * in the alignment. endsite_erate = endsite + 1 since
   * it also includes the "all gaps" column.
   */
  makeweights_erate(endsite_erate); 
  
  if (firstset) alloclrsaves_erate(*endsite_erate);
  else          resetlrsaves_erate(oldendsite_erate, *endsite_erate);

  setuptree2_erate(curtree_erate);
  if (!usertree) {
    setuptree2_erate(besttree_erate);
    setuptree2_erate(priortree_erate);
    if (njumble > 1)
      setuptree2_erate(besttree2_erate);
  }

  allocxe(*endsite_erate, nonodes2, rcategs, curtree_erate->nodep, usertree);
  if (!usertree) {
    allocxe(*endsite_erate, nonodes2, rcategs, besttree_erate->nodep, 0);
    allocxe(*endsite_erate, nonodes2, rcategs, priortree_erate->nodep, 0);
    if (njumble > 1)
      allocxe(*endsite_erate, nonodes2, rcategs, besttree2_erate->nodep, 0);
  }

  /* pass only endsite, and the function takes care of the extra column */
  makevalues2_erate(rcategs, curtree_erate->nodep, endsite, spp, y, alias);  

  empiricalfreqs_erate(&empfreqa, &empfreqc, &empfreqg, &empfreqt, &empfreqo, aliasweight,
		       curtree_erate->nodep);

  if (freqsfrom) { freqa = empfreqa; freqc = empfreqc; freqg = empfreqg; freqt = empfreqt; }
  if (freqofrom) { freqo = empfreqo; }
  
  getbasefreqs_erate(freqa, freqc, freqg, freqt, freqo, &freqr, &freqy, &freqar, &freqcy,
		     &freqgr, &freqty, &ttratio, &xi, &xv, extrictpos, freqsfrom, freqofrom, true);

}  /* getinput_erate */


void inittable_for_usertree(FILE *intree)
{
  /* If there's a user tree, then the ww/zz/wwzz/vvzz elements need
     to be allocated appropriately. */
  long num_comma;
  long i, j;

  /* First, figure out the largest possible furcation, i.e. the number
     of commas plus one */
  countcomma(&intree, &num_comma);
  num_comma++;
  
  for (i = 0; i < rcategs; i++) {
    for (j = 0; j < categs; j++) {
      /* Free the stuff allocated assuming bifurcations */
      free (tbl[i][j]->ww);
      free (tbl[i][j]->zz);
      free (tbl[i][j]->wwzz);
      free (tbl[i][j]->vvzz);

      /* Then allocate for worst-case multifurcations */
      tbl[i][j]->ww   = (double *) Malloc( num_comma * sizeof (double));
      tbl[i][j]->zz   = (double *) Malloc( num_comma * sizeof (double));
      tbl[i][j]->wwzz = (double *) Malloc( num_comma * sizeof (double));
      tbl[i][j]->vvzz = (double *) Malloc( num_comma * sizeof (double));
    }
  }
}  /* inittable_for_usertree */

void inittable_for_usertree_erate(FILE *intree, valrec_erate ***table_erate)
{
  /* If there's a user tree, then the ww/zz/wwzz/vvzz elements need
     to be allocated appropriately. */
  long num_comma;
  long i, j;

  /* First, figure out the largest possible furcation, i.e. the number
     of commas plus one */
  countcomma(&intree, &num_comma);
  num_comma++;
  
  for (i = 0; i < rcategs; i++) {
    for (j = 0; j < categs; j++) {
      /* Free the stuff allocated assuming bifurcations */
      free (table_erate[i][j]->ww);
      free (table_erate[i][j]->zz);
      free (table_erate[i][j]->wwzz);
      free (table_erate[i][j]->vvzz);
      free (table_erate[i][j]->ii);
      free (table_erate[i][j]->gg);
      free (table_erate[i][j]->kk);

      /* Then allocate for worst-case multifurcations */
      table_erate[i][j]->ww    = (double *) Malloc( num_comma * sizeof (double));
      table_erate[i][j]->zz    = (double *) Malloc( num_comma * sizeof (double));
      table_erate[i][j]->wwzz  = (double *) Malloc( num_comma * sizeof (double));
      table_erate[i][j]->vvzz  = (double *) Malloc( num_comma * sizeof (double));
      table_erate[i][j]->ii    = (double *) Malloc( num_comma * sizeof (double));
      table_erate[i][j]->gg    = (double *) Malloc( num_comma * sizeof (double));
      table_erate[i][j]->kk    = (double *) Malloc( num_comma * sizeof (double));
     }
  }
}  /* inittable_for_usertree_erate */


void freetable()
{
  long i, j;
 
  for (i = 0; i < rcategs; i++) {
    for (j = 0; j < categs; j++) {
      free(tbl[i][j]->ww);
      free(tbl[i][j]->zz);
      free(tbl[i][j]->wwzz);
      free(tbl[i][j]->vvzz);
    }
  }
  for (i = 0; i < rcategs; i++)  {
    for (j = 0; j < categs; j++) 
      free(tbl[i][j]);
    free(tbl[i]);
  }
  free(tbl);
}

void freetable_erate(valrec_erate ***table_erate)
{
  long i, j;
 
  for (i = 0; i < rcategs; i++) {
    for (j = 0; j < categs; j++) {
      free(table_erate[i][j]->ww);
      free(table_erate[i][j]->zz);
      free(table_erate[i][j]->wwzz);
      free(table_erate[i][j]->vvzz);
      free(table_erate[i][j]->ii);
      free(table_erate[i][j]->gg);
      free(table_erate[i][j]->kk);
    }
  }
  for (i = 0; i < rcategs; i++)  {
    for (j = 0; j < categs; j++) 
      free(table_erate[i][j]);
    free(table_erate[i]);
  }
  free(table_erate);
}


void inittable()
{
  /* Define a lookup table. Precompute values and print them out in tables */
  long i, j;
  double sumrates;
  
  tbl = (valrec ***) Malloc(rcategs * sizeof(valrec **));
  for (i = 0; i < rcategs; i++) {
    tbl[i] = (valrec **) Malloc(categs*sizeof(valrec *));
    for (j = 0; j < categs; j++)
      tbl[i][j] = (valrec *) Malloc(sizeof(valrec));
  }

  for (i = 0; i < rcategs; i++) {
    for (j = 0; j < categs; j++) {
      tbl[i][j]->rat = rrate[i]*rate[j];
      tbl[i][j]->ratxi = tbl[i][j]->rat * xi;
      tbl[i][j]->ratxv = tbl[i][j]->rat * xv;

      /* Allocate assuming bifurcations, will be changed later if
         necessary (i.e. there's a user tree) */
      tbl[i][j]->ww   = (double *) Malloc( 2 * sizeof (double));
      tbl[i][j]->zz   = (double *) Malloc( 2 * sizeof (double));
      tbl[i][j]->wwzz = (double *) Malloc( 2 * sizeof (double));
      tbl[i][j]->vvzz = (double *) Malloc( 2 * sizeof (double));
    }
  }
  if (!lngths) {            /* restandardize rates */
    sumrates = 0.0;
    for (i = 0; i < endsite; i++) {
      for (j = 0; j < rcategs; j++)
        sumrates += aliasweight[i] * probcat[j] 
          * tbl[j][category[alias[i] - 1] - 1]->rat;
    }
    sumrates /= (double)sites;
    for (i = 0; i < rcategs; i++)
      for (j = 0; j < categs; j++) {
        tbl[i][j]->rat /= sumrates;
        tbl[i][j]->ratxi /= sumrates;
        tbl[i][j]->ratxv /= sumrates;
      }
  }

  if(jumb > 1)
    return;

  if (rcategs > 1) {
    if (gama) {
      fprintf(outfile,"\nDiscrete approximation to gamma distributed rates\n");
      fprintf(outfile,
      " Coefficient of variation of rates = %f  (alpha = %f)\n",
        cv, alpha);
    }
    fprintf(outfile, "\nState in HMM    Rate of change    Probability\n\n");
    for (i = 0; i < rcategs; i++)
      if (probcat[i] < 0.0001)
        fprintf(outfile, "%9ld%16.3f%20.6f\n", i+1, rrate[i], probcat[i]);
      else if (probcat[i] < 0.001)
          fprintf(outfile, "%9ld%16.3f%19.5f\n", i+1, rrate[i], probcat[i]);
        else if (probcat[i] < 0.01)
            fprintf(outfile, "%9ld%16.3f%18.4f\n", i+1, rrate[i], probcat[i]);
          else
            fprintf(outfile, "%9ld%16.3f%17.3f\n", i+1, rrate[i], probcat[i]);
    putc('\n', outfile);
    if (auto_)
      fprintf(outfile,
     "Expected length of a patch of sites having the same rate = %8.3f\n",
             1/lambda);
    putc('\n', outfile);
  }
  if (categs > 1) {
    fprintf(outfile, "\nSite category   Rate of change\n\n");
    for (i = 0; i < categs; i++)
      fprintf(outfile, "%9ld%16.3f\n", i+1, rate[i]);
  }
  if ((rcategs  > 1) || (categs >> 1))
    fprintf(outfile, "\n\n");
}  /* inittable */


void inittable_erate(long endsite_erate, valrec_erate ****ret_table_erate, int verbose)
{
  /* Define a lookup table. Precompute values and print them out in tables */
  valrec_erate ***table_erate;
  long i, j;
  double sumrates;
  
  table_erate = (valrec_erate ***) Malloc(rcategs * sizeof(valrec_erate **));
  for (i = 0; i < rcategs; i++) {
    table_erate[i] = (valrec_erate **) Malloc(categs*sizeof(valrec_erate *));
    for (j = 0; j < categs; j++)
      table_erate[i][j] = (valrec_erate *) Malloc(sizeof(valrec_erate));
  }

  for (i = 0; i < rcategs; i++) {
    for (j = 0; j < categs; j++) {
      table_erate[i][j]->rat = rrate[i]*rate[j];
      table_erate[i][j]->ratxi  = table_erate[i][j]->rat * xi;
      table_erate[i][j]->ratxv  = table_erate[i][j]->rat * xv;
      table_erate[i][j]->ratxl  = table_erate[i][j]->rat * xl;
      table_erate[i][j]->ratxm  = table_erate[i][j]->rat * xm;
 
      if (fracchange_erate(table_erate[i][j]->ratxi, table_erate[i][j]->ratxv, 
			   table_erate[i][j]->ratxl, table_erate[i][j]->ratxm,
			   freqa, freqc, freqg, freqt, freqo, 
			   &table_erate[i][j]->ratfracchange, verbose) != eslOK) 
	esl_fatal("inittable_erate() error calculating fracchange");

      /* Allocate assuming bifurcations, will be changed later if
         necessary (i.e. there's a user tree) */
      table_erate[i][j]->ww    = (double *) Malloc( 2 * sizeof (double));
      table_erate[i][j]->zz    = (double *) Malloc( 2 * sizeof (double));
      table_erate[i][j]->wwzz  = (double *) Malloc( 2 * sizeof (double));
      table_erate[i][j]->vvzz  = (double *) Malloc( 2 * sizeof (double));
      table_erate[i][j]->ii    = (double *) Malloc( 2 * sizeof (double));
      table_erate[i][j]->gg    = (double *) Malloc( 2 * sizeof (double));
      table_erate[i][j]->kk    = (double *) Malloc( 2 * sizeof (double));
     }
  }
  if (!lngths) {            /* restandardize rates */
    sumrates = 0.0;
    for (i = 0; i < endsite; i++) {
      for (j = 0; j < rcategs; j++) {
        sumrates += (double)aliasweight[i] * probcat[j] 
          * table_erate[j][category[alias[i] - 1] - 1]->rat;
      }
    }
    sumrates /= (double)sites;  

    for (i = 0; i < rcategs; i++)
      for (j = 0; j < categs; j++) {
        table_erate[i][j]->rat   /= sumrates;
        table_erate[i][j]->ratxi /= sumrates;
        table_erate[i][j]->ratxv /= sumrates;
        table_erate[i][j]->ratxl /= sumrates;
        table_erate[i][j]->ratxm /= sumrates;
      }
  }

  if(jumb > 1) {
    *ret_table_erate = table_erate;
    return;
  }

  if (rcategs > 1) {
    if (gama) {
      fprintf(outfile,"\nDiscrete approximation to gamma distributed rates\n");
      fprintf(outfile,
      " Coefficient of variation of rates = %f  (alpha = %f)\n",
        cv, alpha);
    }
    fprintf(outfile, "\nState in HMM    Rate of change    Probability\n\n");
    for (i = 0; i < rcategs; i++)
      if (probcat[i] < 0.0001)
        fprintf(outfile, "%9ld%16.3f%20.6f\n", i+1, rrate[i], probcat[i]);
      else if (probcat[i] < 0.001)
          fprintf(outfile, "%9ld%16.3f%19.5f\n", i+1, rrate[i], probcat[i]);
        else if (probcat[i] < 0.01)
            fprintf(outfile, "%9ld%16.3f%18.4f\n", i+1, rrate[i], probcat[i]);
          else
            fprintf(outfile, "%9ld%16.3f%17.3f\n", i+1, rrate[i], probcat[i]);
    putc('\n', outfile);
    if (auto_)
      fprintf(outfile,
     "Expected length of a patch of sites having the same rate = %8.3f\n",
             1/lambda);
    putc('\n', outfile);
  }
  if (categs > 1) {
    fprintf(outfile, "\nSite category   Rate of change\n\n");
    for (i = 0; i < categs; i++)
      fprintf(outfile, "%9ld%16.3f\n", i+1, rate[i]);
  }
  if ((rcategs  > 1) || (categs >> 1))
    fprintf(outfile, "\n\n");

  *ret_table_erate = table_erate;
}  /* inittable_erate */


double evaluate(node *p, boolean saveit)
{
  contribarr tterm;
  double sum, sum2, sumc, y, lz, y1, z1zz, z1yy, prod12, prod1, prod2, prod3,
         sumterm, lterm;
  long i, j, k, lai;
  node *q;
  sitelike x1, x2;

  sum = 0.0;
  q = p->back;
  if ( p->initialized  == false && p->tip == false)  nuview(p);
  if ( q->initialized  == false && q->tip == false)  nuview(q);
  y = p->v;
  lz = -y;
  for (i = 0; i < rcategs; i++)
    for (j = 0; j < categs; j++) {
    tbl[i][j]->orig_zz = exp(tbl[i][j]->ratxi * lz);
    tbl[i][j]->z1 = exp(tbl[i][j]->ratxv * lz);
    tbl[i][j]->z1zz = tbl[i][j]->z1 * tbl[i][j]->orig_zz;
    tbl[i][j]->z1yy = tbl[i][j]->z1 - tbl[i][j]->z1zz;
  }
  for (i = 0; i < endsite; i++) {
    k = category[alias[i]-1] - 1;
    for (j = 0; j < rcategs; j++) {
      if (y > 0.0) {
        y1 = 1.0 - tbl[j][k]->z1;
        z1zz = tbl[j][k]->z1zz;
        z1yy = tbl[j][k]->z1yy;
      } else {
        y1 = 0.0;
        z1zz = 1.0;
        z1yy = 0.0;
      }
      memcpy(x1, p->x[i][j], sizeof(sitelike));
      prod1 = freqa * x1[0] + freqc * x1[(long)C - (long)A] +
             freqg * x1[(long)G - (long)A] + freqt * x1[(long)T - (long)A];
      memcpy(x2, q->x[i][j], sizeof(sitelike));
      prod2 = freqa * x2[0] + freqc * x2[(long)C - (long)A] +
             freqg * x2[(long)G - (long)A] + freqt * x2[(long)T - (long)A];
      prod3 = (x1[0] * freqa + x1[(long)G - (long)A] * freqg) *
              (x2[0] * freqar + x2[(long)G - (long)A] * freqgr) +
          (x1[(long)C - (long)A] * freqc + x1[(long)T - (long)A] * freqt) *
         (x2[(long)C - (long)A] * freqcy + x2[(long)T - (long)A] * freqty);
      prod12 = freqa * x1[0] * x2[0] +
               freqc * x1[(long)C - (long)A] * x2[(long)C - (long)A] +
               freqg * x1[(long)G - (long)A] * x2[(long)G - (long)A] +
               freqt * x1[(long)T - (long)A] * x2[(long)T - (long)A];
      tterm[j] = z1zz * prod12 + z1yy * prod3 + y1 * prod1 * prod2;
    }
    sumterm = 0.0;
    for (j = 0; j < rcategs; j++)
      sumterm += probcat[j] * tterm[j];
    lterm = log(sumterm) + p->underflows[i] + q->underflows[i];
    for (j = 0; j < rcategs; j++)
      clai[j] = tterm[j] / sumterm;
    memcpy(contribution[i], clai, rcategs*sizeof(double));
    if (saveit && !auto_ && usertree && (which <= shimotrees))
      l0gf[which - 1][i] = lterm;
    sum += (double)aliasweight[i] * lterm;
  }
  for (j = 0; j < rcategs; j++)
    like[j] = 1.0;
  for (i = 0; i < sites; i++) {
    sumc = 0.0;
    for (k = 0; k < rcategs; k++)
      sumc += probcat[k] * like[k];
    sumc *= lambda;
    if ((ally[i] > 0) && (location[ally[i]-1] > 0)) {
      lai = location[ally[i] - 1];
      memcpy(clai, contribution[lai - 1], rcategs*sizeof(double));
      for (j = 0; j < rcategs; j++)
        nulike[j] = ((1.0 - lambda) * like[j] + sumc) * clai[j];
    } else {
      for (j = 0; j < rcategs; j++)
        nulike[j] = ((1.0 - lambda) * like[j] + sumc);
    }
    memcpy(like, nulike, rcategs*sizeof(double));
  }
  sum2 = 0.0;
  for (i = 0; i < rcategs; i++)
    sum2 += probcat[i] * like[i];
  sum += log(sum2);
  curtree.likelihood = sum;
  if (!saveit || auto_ || !usertree)
    return sum;
  if(which <= shimotrees)
    l0gl[which - 1] = sum;
  if (which == 1) {
    maxwhich = 1;
    maxlogl = sum;
    return sum;
  }
  if (sum > maxlogl) {
    maxwhich = which;
    maxlogl = sum;
  }
  return sum;
}  /* evaluate */


double evaluate_erate(tree_erate *tree, node_erate *p, 
		      valrec_erate ***table_erate, long endsite_erate, 
		      boolean saveit, double tol, int verbose)
{
  root_erate_data *root_data = tree->root_data;
  contribarr tterm;
  double y, lz;
  double prod12, prod1, prod2, prod3;
  double y1, z1zz, z1yy;
  double sum, sum2, sumc, sumterm, lterm;
  double j1, g1, k1, k1m;
  double pb, pbm;
  double term1, term2, term3, term4, term5, term6, term7, term8;
  long i, j, k, lai;
  node_erate *q;
  sitelike_erate  x1, x2;			
  boolean tree_allgapleaves = FALSE;
  boolean p_allgapleaves = FALSE;
  boolean q_allgapleaves = FALSE;
  boolean addterm;
  int     nl = 0;

  if (p->tip) { printf("There is some error in evaluate_erate()\n"); EOF_error(); }

  if (0) {
    tree_nnodes_erate(p, tree->root_data, verbose);
    nl = (int)tree->root_data->nl;
  }
  
  sum = 0.0;
  q = p->back;

  if (p->initialized == false && p->tip == false)  nuview_erate(p, table_erate, endsite_erate, tol);
  if (q->initialized == false && q->tip == false)  nuview_erate(q, table_erate, endsite_erate, tol);

  y = p->v;
  lz = -y;
  
  for (i = 0; i < rcategs; i++)
    for (j = 0; j < categs; j++) {
      table_erate[i][j]->orig_zz = exp(table_erate[i][j]->ratxi * lz);
      table_erate[i][j]->z1      = exp(table_erate[i][j]->ratxv * lz) * 
	exp(table_erate[i][j]->ratxm * lz);
      table_erate[i][j]->z1zz    = table_erate[i][j]->z1 * table_erate[i][j]->orig_zz;
      table_erate[i][j]->z1yy    = table_erate[i][j]->z1 - table_erate[i][j]->z1zz;
      table_erate[i][j]->i1      = 
	exp(table_erate[i][j]->ratxl * lz) * exp(table_erate[i][j]->ratxm * lz);      
      
    /* set xi_t */
      if (table_erate[i][j]->ratxl < 1.0*tol) 
	table_erate[i][j]->k1 = 0.0;
      else
	table_erate[i][j]->k1 =  
	  ( table_erate[i][j]->ratxl/(table_erate[i][j]->ratxl + table_erate[i][j]->ratxm) ) * 
	  ( 1.0-table_erate[i][j]->i1);

      /* set gammat_t */
      if (table_erate[i][j]->ratxm < 1.0*tol) 
	  table_erate[i][j]->g1 = 0.0;
      else
	table_erate[i][j]->g1 =  
	  ( table_erate[i][j]->ratxm/(table_erate[i][j]->ratxl + table_erate[i][j]->ratxm) ) * 
	  (1.0-table_erate[i][j]->i1);
     }

  
  /* calculate also the extra columns:
     endsite   = allgaps column 
     endsite+1 = immortal link 
  */
  for (i = 0; i < endsite_erate; i++) { 

    p_allgapleaves    = FALSE;
    q_allgapleaves    = FALSE;
    tree_allgapleaves = FALSE;

    if (i < endsite) k = category[alias[i]-1] - 1;
    else             k = 0;
    for (j = 0; j < rcategs; j++) {
      
      if (i <= endsite) {
	tree_allgapleaves = tree_colisallgaps_erate(i, j, p, verbose);
	p_allgapleaves    = node_colisallgaps_erate(i, j, p, verbose);
	q_allgapleaves    = node_colisallgaps_erate(i, j, q, verbose);
	/* paranoia */
	if (p_allgapleaves == FALSE && tree_allgapleaves == TRUE)
	  esl_fatal("evaluate_erate(): node p %d not compatible with whole tree\n", p->index);
	if (q_allgapleaves == FALSE && tree_allgapleaves == TRUE)
	  esl_fatal("evaluate_erate(): node q %d not compatible with whole tree\n", q->index);
	if (i == endsite) { 
	  if (p_allgapleaves == FALSE    ||
	      q_allgapleaves == FALSE    ||
	      tree_allgapleaves == FALSE   )
	    esl_fatal("evaluate_erate(): i=endsite should be an allgaps column\n");
	}
	if (i < endsite && freqo == 0) {
	  if (p_allgapleaves == TRUE ||
	      q_allgapleaves == TRUE   )
	    esl_fatal("evaluate_erate(): this is an alignment without gaps!\n");
	}
      }

      y1    = 1.0 - table_erate[j][k]->z1;
      z1zz  = table_erate[j][k]->z1zz;
      z1yy  = table_erate[j][k]->z1yy;
      j1    = 1.0 - table_erate[j][k]->i1;
      k1    = table_erate[j][k]->k1;
      g1    = table_erate[j][k]->g1;
      k1m   = 1.0 - k1;

      pb    = table_erate[j][k]->gprior;
      pbm   = 1.0 - pb;
      
      term1 =  pb  * k1m * z1zz;
      term2 =  pb  * k1m * z1yy;
      term3 =  pb  * k1m * y1;
      term4 = -pb  * k1m * g1;
      term5 =  pb  * k1m * g1;    /* deletions */
      term6 =        k1;          /* insertions */
      term7 =        1.0;         /* gap/gap */
      term8 = pbm * k1m; /* for the immortal column */

      if (isnan(term1) || isnan(term2) || isnan(term3) || isnan(term4) || 
	  isnan(term5) || isnan(term6) || isnan(term7) || isnan(term8))
	esl_fatal("evaluate_erate(): nan terms. 1 %f 2 %f 3 %f 4 %f 5 %f 6 %f 7 %f 8 %f\n", 
		  term1, term2, term3, term4, term5, term6, term7, term8);

      memcpy(x1, p->xe[i][j], sizeof(sitelike_erate));
      memcpy(x2, q->xe[i][j], sizeof(sitelike_erate));

      prod1 = 
	freqa * x1[0] + 
	freqc * x1[(long)C - (long)A] +
	freqg * x1[(long)G - (long)A] + 
	freqt * x1[(long)T - (long)A];
      prod2 = 
	freqa * x2[0] + 
	freqc * x2[(long)C - (long)A] +
	freqg * x2[(long)G - (long)A] + 
	freqt * x2[(long)T - (long)A];
      prod3 = 
	(x1[0] * freqa  + x1[(long)G - (long)A] * freqg) * 
	(x2[0] * freqar + x2[(long)G - (long)A] * freqgr) +
	(x1[(long)C - (long)A] * freqc  + x1[(long)T - (long)A] * freqt) * 
	(x2[(long)C - (long)A] * freqcy + x2[(long)T - (long)A] * freqty);
       prod12 = 
	freqa * x1[0] * x2[0] +
	freqc * x1[(long)C - (long)A] * x2[(long)C - (long)A] +
	freqg * x1[(long)G - (long)A] * x2[(long)G - (long)A] +
	freqt * x1[(long)T - (long)A] * x2[(long)T - (long)A];
      if (isnan(prod1) || isnan(prod2) || isnan(prod12) || isnan(prod3))
	esl_fatal("evaluate_erate(): nan prods.\n");

      if (i <= endsite) { /* all observed columns plus the allgaps column */
	tterm[j] = 
	  + term1 * prod12
	  + term2 * prod3 
	  + term3 * prod1 * prod2 
	  + term4 * prod1 * prod2;

	if (q_allgapleaves == TRUE) {
	  tterm[j] += 
	    + term5 * prod1
	    + term7 * x1[(long)O - (long)A];
	}
	
	if (p_allgapleaves == TRUE) {
	  tterm[j] += 
	    + term6 * prod2
	    + term7 * x2[(long)O - (long)A];
	}
      }
      else if (i == endsite+1) { /* the immortal column */
	tterm[j] = term7 * x1[(long)O - (long)A] * x2[(long)O - (long)A];
      }
      
       if (isnan(tterm[j]))
	esl_fatal("evaluate_erate(): endsite=%d nan tterm[%d] %d.\n", i, j);
       if (tterm[j] < 0.0 && tterm[j] >= -tol) tterm[j] = 0.0;
       if (tterm[j] < -tol) {
	 printf("\nparam xi %f xv %f xl %f xm %f\n", 
		table_erate[0][0]->ratxi, table_erate[0][0]->ratxv, table_erate[0][0]->ratxl, table_erate[0][0]->ratxm);
	 printf("EVAL unique site %ld y %f\n", i, y);
	 printf("EVAL_TERM 1 %f 2 %f 3 %f 4 %f 5 %f 6 %f 7 %f 8 %f\n", 
		term1, term2, term3, term4, term5, term6, term7, term8);    
	 printf("x1: %f %f %f %f %f x2 %f %f %f %f %f\nprod1 %f prod2 %f prod3 %f prod12 %f\n", 
		x1[0],x1[(long)C - (long)A],x1[(long)G - (long)A],x1[(long)T - (long)A],x1[(long)O - (long)A],
		x2[0],x2[(long)C - (long)A],x2[(long)G - (long)A],x2[(long)T - (long)A],x2[(long)O - (long)A], 
		prod1, prod2, prod3, prod12);
	 esl_fatal("evaluate_erate(): unique site=%d negative tterm[%d] %f.\n", i, j, tterm[j]);
       }
       
    }
    
    /* the score in log format 
     *
     * E_{total} = \prod_{col} E_{col} * E_{immortal} * 1/(1-E_{allgaps})
     *
     * log[ E_{total}] = 
     *                      \sum_{col} log[ E_{col}] 
     *                     + log[ E_{immortal} ] 
     *                     - log[ 1-E_{allgaps} ]
     */
    sumterm = 0.0;
    for (j = 0; j < rcategs; j++) {
      sumterm += probcat[j] * tterm[j];
    }
    if (sumterm < 0.0) {
      sumterm = 0.0;
      for (j = 0; j < rcategs; j++) {
	sumterm += probcat[j] * tterm[j];
      }
      
      if (sumterm > -tol) sumterm = 0.0; 
      else esl_fatal("evaluate_erate() negative probability %f at i=%ld j=%ld\n", sumterm, i, j);      
    }
    if (sumterm > 1.0) 
      esl_fatal("evaluate_erate(): Larger than one probability at i=%ld j=%ld %f\n", i, j, sumterm);
    if      (i <  endsite) lterm =  log(sumterm) + p->underflows[i] + q->underflows[i];
    else if (i == endsite) lterm = -log(1.0-sumterm);
    else                   lterm =  log(sumterm);
    if (isnan(lterm)) esl_fatal("evaluate_erate() endsite %d lterm nan error.", i);

    if (verbose) {
      printf("\nevaluate_erate\n-->pp p %ld q %ld\n", p->index, q->index);
      printf("EVAL l %f m %f i %ld time %f sum %f sumterm %f lterm %f alias %ld\n", 
	     table_erate[0][0]->ratxl, table_erate[0][0]->ratxm, i, y, sum, sumterm, lterm, aliasweight[i]);
      printf("EVAL_TERM 1 %f 2 %f 3 %f 4 %f 5 %f 6 %f 7 %f 8 %f\n", 
	     term1, term2, term3, term4, term5, term6, term7, term8);    
      printf("z1zz %f z1yy %f y1 %f g1 %f\n", z1zz, z1yy, y1, g1);
      printf("x1: %f %f %f %f %f x2 %f %f %f %f %f\n%f %f %f %f\n", 
	     x1[0],x1[(long)C - (long)A],x1[(long)G - (long)A],x1[(long)T - (long)A],x1[(long)O - (long)A],
	     x2[0],x2[(long)C - (long)A],x2[(long)G - (long)A],x2[(long)T - (long)A],x2[(long)O - (long)A], 
	     prod1, prod2, prod3, prod12);
    }

    /* add the log score of this column multiplied by 
     * how many times the column appears in the alignment */
    addterm = FALSE;
    if ((i < endsite && tree_allgapleaves == FALSE) || i >= endsite) 
      addterm = TRUE;
    
    if (addterm <= TRUE) {
      if (lterm <= -HUGE_VAL) {
	sum = -HUGE_VAL;
      }
      else {
	if (i < endsite) sum += (double)aliasweight[i] * lterm;
	else             sum += lterm;
      }
      if (isnan(sum)) esl_fatal("evaluate_erate() endsite %d sum contribution is nan.", i);
    }
    
    for (j = 0; j < rcategs; j++) {
      if (sumterm > 0.) clai[j] = tterm[j] / sumterm;
      else {
	if (rcategs == 1)  clai[j] = 1.0;
	else             { printf("There is some error in evaluate_erate()\n"); EOF_error(); }
      }
    }
    memcpy(contribution[i], clai, rcategs*sizeof(double));
    if (saveit && !auto_ && usertree && (which <= shimotrees))
      l0gf[which - 1][i] = lterm;
    
  } /* for each column */
  
  /* calculate sum2 and add it to sum 
   */
  /* add the allgaps column */
  /* initialize */
  for (j = 0; j < rcategs; j++)
    like[j] = 1.0;
  sumc = 0.0;
  for (k = 0; k < rcategs; k++) 
    sumc += probcat[k] * like[k];
  sumc *= lambda;
  memcpy(clai, contribution[endsite], rcategs*sizeof(double));
  for (j = 0; j < rcategs; j++) 
    nulike[j] = ((1.0 - lambda) * like[j] + sumc) * clai[j];
  memcpy(like, nulike, rcategs*sizeof(double));
  
  
  /* add the immortal-link column */
  /* initialize */
  for (j = 0; j < rcategs; j++)
    like[j] = 1.0;
  sumc = 0.0;
  for (k = 0; k < rcategs; k++) 
    sumc += probcat[k] * like[k];
  sumc *= lambda;
  memcpy(clai, contribution[endsite+1], rcategs*sizeof(double));
  for (j = 0; j < rcategs; j++) 
    nulike[j] = ((1.0 - lambda) * like[j] + sumc) * clai[j];
  memcpy(like, nulike, rcategs*sizeof(double));
  
  /* add the real columns terms */
  /* initialize */
  for (j = 0; j < rcategs; j++)
    like[j] = 1.0;
  for (i = 0; i < sites; i++) {
    sumc = 0.0;
    for (k = 0; k < rcategs; k++)
      sumc += probcat[k] * like[k];
    sumc *= lambda;
    if ((ally[i] > 0) && (location[ally[i]-1] > 0)) {
      lai = location[ally[i] - 1];
      memcpy(clai, contribution[lai - 1], rcategs*sizeof(double));
      for (j = 0; j < rcategs; j++)
        nulike[j] = ((1.0 - lambda) * like[j] + sumc) * clai[j];
    } else {
      for (j = 0; j < rcategs; j++)
        nulike[j] = ((1.0 - lambda) * like[j] + sumc);
    }
    memcpy(like, nulike, rcategs*sizeof(double));

  }
  sum2 = 0.0;
  for (i = 0; i < rcategs; i++) {
    sum2 += probcat[i] * like[i];
  }
  if (sum2 < 0.0 && sum2 > -tol) sum2 = 0.0;
  if (isnan(log(sum2)))
    esl_fatal("evaluate_erate(): nan sum2\n");
  sum += log(sum2);

  /* record the likelihood */
  if (sum > 0.001)  esl_fatal("evaluate_erate() positive lnlikelihood! %f.", sum);
  else if (sum > 0.0) sum = 0.0;
  if (isnan(sum)) esl_fatal("evaluate_erate() nan error sum %f sum2 %f.", sum, sum2);
  if (sum < -HUGE_VAL) sum = -HUGE_VAL;
  tree->likelihood = sum;

  if(0) {
    printf("EVAL_TERM 1 %f 2 %f 3 %f 4 %f 5 %f 6 %f 7 %f 8 %f sum %f\n", 
	   term1, term2, term3, term4, term5, term6, term7, term8, sum);
  }
  if (verbose) {
    dnaml_printree_erate(tree, table_erate);
    fprintf(outfile, "evaluate p %ld back %ld %f\n", p->index, p->back->index, sum);
    fprintf(outfile, "maxdist %f taxal %ld taxar %ld\n", root_data->taxa_maxdist, root_data->taxal, root_data->taxar);
    fprintf(outfile, "rootl %ld (%f) rootr %ld (%f)\n", root_data->rootl, root_data->distrootl, root_data->rootr, root_data->distrootr);
    fprintf(outfile, "taxa_avedist_byroot %f\n", root_data->taxa_avedist_byroot);

    printf("\nevaluate p %ld back %ld %f\n", p->index, p->back->index, sum);
    tree_describe_erate(tree->start, verbose);
    printf("maxdist %f taxal %ld taxar %ld\n", root_data->taxa_maxdist, root_data->taxal, root_data->taxar);
    printf("rootl %ld (%f) rootr %ld (%f)\n", root_data->rootl, root_data->distrootl, root_data->rootr, root_data->distrootr);
    printf("taxa_avedist_byroot %f\n", root_data->taxa_avedist_byroot);
  }

  if (!saveit || auto_ || !usertree)
    return sum;
  if(which <= shimotrees)
    l0gl[which - 1] = sum;
  if (which == 1) {
    maxwhich = 1;
    maxlogl = sum;
    return sum;
  }
  if (sum > maxlogl) {
    maxwhich = which;
    maxlogl = sum;
  }

  return sum;
}  /* evaluate_erate */


/* Function:  evaluate_rooted_erate()
 *
 * Incept:    ER, Wed Apr  4 16:11:20 EDT 2007 [Janelia]
 *
 * Synopsis:  This function is somewhat similar to evaluate_erate().
 *
 *            evaluate_erate() is given a node that it uses as root.
 *
 *            \sum_i p^m_{tmax}(i) L_p(i) \sum_j Q^t_{ij} L_q (j)
 *
 *            evaluate_rooted_erate() calculate the left and rigth
 *            children of the root and calculates the likelihood 
 *            of the rooted tree
 *
 *            \sum_i p^m_{tmax}(i) L_{rootr}(i) L_{rootl} (i)
 *
 *
 * Purpose:   it calculates the likelihood of the rooted tree
 *
 *
 * Args:      
 *
 * Returns:   the likelihood of the rooted tree
 *
 */
double evaluate_rooted_erate(tree_erate *tree, valrec_erate ***table_erate,
			     long endsite_erate,
			     boolean saveit, double tol, int verbose)
{
  root_erate_data *root_data = tree->root_data;
  phenotype_erate  pl, pr;
  sitelike_erate   x1, x2;
  sitelike_erate   y1, y2;			
  double          *underflowsl, *underflowsr;
  long             i, j, k, lai;
  contribarr       tterm;
  double           yl, lzl;
  double           yr, lzr;
  double           sum = 0.0;
  double           sum2, sumc, sumterm, lterm;
  double           prod1, prod2, prod12;
  double           g1l, k1l, k1ml;
  double           g1r, k1r, k1mr;
  double           pb, pbm;
  boolean          pl_allgapleaves   = FALSE;
  boolean          pr_allgapleaves   = FALSE;
  boolean          tree_allgapleaves = FALSE;
  boolean          addterm;

  inittravtree_erate(tree->start);
  
 /* calculate the likelihoods up to the rootl and rootr nodes
   * if they have not been calculated yet
   */
  if (root_data->rchildl->initialized == false && root_data->rchildl->tip == false) 
    nuview_erate(root_data->rchildl, table_erate, endsite_erate, tol);
  if (root_data->rchildr->initialized == false && root_data->rchildr->tip == false) 
    nuview_erate(root_data->rchildr, table_erate, endsite_erate, tol);

  /* Calculate the likelihood of the two branches up to the root 
   */
  nuview_onenode_erate(&pl, &underflowsl, root_data->rchildl, root_data->distrootl, table_erate, endsite_erate, tol);
  nuview_onenode_erate(&pr, &underflowsr, root_data->rchildr, root_data->distrootr, table_erate, endsite_erate, tol);

  yl = root_data->distrootl;
  yr = root_data->distrootr;
  lzl = -yl;
  lzr = -yr;
  
  for (i = 0; i < rcategs; i++)
    for (j = 0; j < categs; j++) {
      table_erate[i][j]->i1l      = 
	exp(table_erate[i][j]->ratxl * lzl) * exp(table_erate[i][j]->ratxm * lzl);      
      table_erate[i][j]->i1r      = 
	exp(table_erate[i][j]->ratxl * lzr) * exp(table_erate[i][j]->ratxm * lzr);      

     
      /* set xi_t */
      if (table_erate[i][j]->ratxl < 1.0*tol) {
	table_erate[i][j]->k1l = 0.0;
	table_erate[i][j]->k1r = 0.0;
      }
      else {
	table_erate[i][j]->k1l =  
	  ( table_erate[i][j]->ratxl/(table_erate[i][j]->ratxl + table_erate[i][j]->ratxm) ) * 
	  ( 1.0-table_erate[i][j]->i1l);
	table_erate[i][j]->k1r =  
	  ( table_erate[i][j]->ratxl/(table_erate[i][j]->ratxl + table_erate[i][j]->ratxm) ) * 
	  ( 1.0-table_erate[i][j]->i1r);
      }

      /* set gammat_t */
      if (table_erate[i][j]->ratxm < 1.0*tol) { 
	  table_erate[i][j]->g1l = 0.0;
	  table_erate[i][j]->g1r = 0.0;
      }
      else {
	table_erate[i][j]->g1l =  
	  ( table_erate[i][j]->ratxm/(table_erate[i][j]->ratxl + table_erate[i][j]->ratxm) ) * 
	  (1.0-table_erate[i][j]->i1l);
	table_erate[i][j]->g1r =  
	  ( table_erate[i][j]->ratxm/(table_erate[i][j]->ratxl + table_erate[i][j]->ratxm) ) * 
	  (1.0-table_erate[i][j]->i1r);
      }
    }

  /* calculate also the extra columns:
     endsite   = allgaps and 
     endsite+1 = immortal link 
  */
  for (i = 0; i < endsite_erate; i++) { 
    pl_allgapleaves   = FALSE;
    pr_allgapleaves   = FALSE;
    tree_allgapleaves = FALSE;

    if (i < endsite) k = category[alias[i]-1] - 1;
    else             k = 0;

    for (j = 0; j < rcategs; j++) {
      
      if (i <= endsite) {
	pl_allgapleaves = node_colisallgaps_erate(i, j, root_data->rchildl, verbose);
	pr_allgapleaves = node_colisallgaps_erate(i, j, root_data->rchildr, verbose);
	/* paranoia */
	if (i == endsite) { 
	  if (pl_allgapleaves == FALSE ||
	      pr_allgapleaves == FALSE   )
	    esl_fatal("evaluate_rooted_erate(): i=endsite should be an allgaps column\n");
	}
	if (i < endsite && freqo == 0) {
	if (pl_allgapleaves == TRUE ||
	    pr_allgapleaves == TRUE   )
	  esl_fatal("evaluate_rooted_erate(): this is an alignment without gaps!\n");
	}

	if (pl_allgapleaves == TRUE && 
	    pr_allgapleaves == TRUE   )
	  tree_allgapleaves = TRUE;
      }
      
      memcpy(x1, pl[i][j], sizeof(sitelike_erate));
      memcpy(x2, pr[i][j], sizeof(sitelike_erate));
      
      memcpy(y1, root_data->rchildl->xe[i][j], sizeof(sitelike_erate));
      memcpy(y2, root_data->rchildr->xe[i][j], sizeof(sitelike_erate));

      k1l  = table_erate[j][k]->k1l;
      k1r  = table_erate[j][k]->k1r;
      g1l  = table_erate[j][k]->g1l;
      g1r  = table_erate[j][k]->g1r;
      k1ml = 1.0 - k1l;
      k1mr = 1.0 - k1r;

      pb = table_erate[j][k]->gprior;
      pbm = 1.0 - pb;
	
      prod1 = 
	freqa * x1[0] +
	freqc * x1[(long)C - (long)A] +
	freqg * x1[(long)G - (long)A] +
	freqt * x1[(long)T - (long)A];
      if (isnan(prod1)) esl_fatal("evaluate_rooted_erate(): nan prods.\n");
      prod2 = 
	freqa * x2[0] +
	freqc * x2[(long)C - (long)A] +
	freqg * x2[(long)G - (long)A] +
	freqt * x2[(long)T - (long)A];
      if (isnan(prod2)) esl_fatal("evaluate_rooted_erate(): nan prods.\n");
       prod12 = 
	freqa * x1[0] * x2[0] +
	freqc * x1[(long)C - (long)A] * x2[(long)C - (long)A] +
	freqg * x1[(long)G - (long)A] * x2[(long)G - (long)A] +
	freqt * x1[(long)T - (long)A] * x2[(long)T - (long)A];
      if (isnan(prod12)) esl_fatal("evaluate_rooted_erate(): nan prods.\n");
      
      if (i <= endsite) { /* observed columns and gap/gap column */
	tterm[j] = 
	  + pb * prod12;

	if (pl_allgapleaves == TRUE &&
	    pr_allgapleaves == TRUE   ) {
	  tterm[j] +=
	    + pb * k1ml * g1l * k1mr * g1r;
	}	
	if (pl_allgapleaves == TRUE) {	
	  tterm[j] +=
	    + pb * k1ml * g1l * prod2
	    + x2[(long)O - (long)A] 
	    + y2[(long)O - (long)A] ;	  
	}
	if (pr_allgapleaves == TRUE) {
	  tterm[j] += 
	    + pb * k1mr * g1r * prod1
	    + x1[(long)O - (long)A] 
	    + y1[(long)O - (long)A] ;
	}
      }
      else if (i == endsite+1) { /* the immortal column */
	tterm[j] = pbm * x1[(long)O - (long)A] * x2[(long)O - (long)A];
      }
      
      if (isnan(tterm[j]))
	esl_fatal("evaluate_rooted_erate(): endsite=%d nan term{%d} %d.\n", i, j);    
      
      if (tterm[j] < 0.0 && tterm[j] >= -tol)    tterm[j] = 0.0;
      if (tterm[j] > 1.0 && tterm[j] <= 1.0+tol) tterm[j] = 1.0;
      if (tterm[j] < -tol || tterm[j] > 1.0+tol) {
	printf("\nparam xi %f xv %f xl %f xm %f\n", 
	       table_erate[0][0]->ratxi, table_erate[0][0]->ratxv, table_erate[0][0]->ratxl, table_erate[0][0]->ratxm);
	printf("evaluate rootl  %ld (%d) time %f rootr  %ld (%d) time %f\n", 
	       root_data->rchildl->index, pl_allgapleaves, lzl,
	       root_data->rchildr->index, pr_allgapleaves, lzr);
	printf("x1: %f %f %f %f %f x2 %f %f %f %f %f\nprod1 %f prod2 %f prod12 %f\n1-xi1 %f 1-xi2 %f gamma1 %f gamma2 %f\n", 
	       x1[0],x1[(long)C - (long)A],x1[(long)G - (long)A],x1[(long)T - (long)A],x1[(long)O - (long)A],
	       x2[0],x2[(long)C - (long)A],x2[(long)G - (long)A],x2[(long)T - (long)A],x2[(long)O - (long)A], 
	       prod1, prod2, prod12, k1ml, k1mr, g1l, g1r);
	printf("pl allgaps %d pr allgaps %d\n", pl_allgapleaves, pr_allgapleaves);    
	esl_fatal("evaluate_rooted_erate(): unique site=%d bad probability tterm[%d] %f.\n", i, j, tterm[j]);
      }
      
    }
   
    /* the score in log format 
     *
     * E_{total} = \prod_{col} E_{col} * E_{immortal} * 1/(1-E_{allgaps})
     *
     * log[ E_{total}] = 
     *                      \sum_{col} log[ E_{col}] 
     *                     + log[ E_{immortal} ] 
     *                     - log[ 1-E_{allgaps} ]
     */
    sumterm = 0.0;
    for (j = 0; j < rcategs; j++) {
      sumterm += probcat[j] * tterm[j];
    }
    if (sumterm < 0.0) {
      if (sumterm > -tol) sumterm = 0.0; 
      else esl_fatal("evaluate_rooted_erate() negative probability %f at i=%ld j=%ld\n", sumterm, i, j);      
    }
    if (sumterm > 1.0) 
      esl_fatal("evaluate_rooted_erate(): Larger than one probability at i=%ld j=%ld %f\n", i, j, sumterm);
    if      (i <  endsite) lterm =  log(sumterm);
    else if (i == endsite) lterm = -log(1.0-sumterm);
    else                   lterm =  log(sumterm);
    if (isnan(lterm)) esl_fatal("evaluate_rooted_erate() endsite %d lterm nan error. sumterm %f lterm %f", i, sumterm, lterm);
    if ((i < endsite || i == endsite+1) && lterm > 0.0)  
      esl_fatal("evaluate_rooted_erate() endsite %d lterm is positive! lterm=%f sumterm %f", 
		i, lterm, sumterm);
    
    if (verbose) {
      printf("\nevaluate_rooted_erate %ld\n-->pp p %ld q %ld\n", i, root_data->rchildl->index, root_data->rchildr->index);
      printf("all gaps? %d %d\n", pl_allgapleaves, pr_allgapleaves);
      printf("EVAL l %f m %f i %ld time %f %f sum %f sumterm %f lterm %f underflow %f %f\n",       
	     table_erate[0][0]->ratxl, table_erate[0][0]->ratxm, i, yl, yr, sum, sumterm, lterm, underflowsl[i], underflowsr[i]);
      printf("g1 %f %f\n", g1l, g1r);
      printf("x1: %f %f %f %f %f x2 %f %f %f %f %f\n%f %f %f\n", 
	     x1[0],x1[(long)C - (long)A],x1[(long)G - (long)A],x1[(long)T - (long)A],x1[(long)O - (long)A],
	     x2[0],x2[(long)C - (long)A],x2[(long)G - (long)A],x2[(long)T - (long)A],x2[(long)O - (long)A], 
	     prod1, prod2, prod12);
    }
    
    /* add the log score of this column multiplied by 
     * how many times the column appears in the alignment */
    addterm = FALSE;
      if ((i < endsite && tree_allgapleaves == FALSE) || i >= endsite) 
	addterm = TRUE;
    
    if (addterm == TRUE) {
      if (lterm <= -HUGE_VAL) {
	sum = -HUGE_VAL;
      }
      else {
	if (i < endsite) sum += (double)aliasweight[i] * lterm;
	else             sum += lterm;
      }
      if (isnan(sum)) esl_fatal("evaluate_rooted_erate() endsite %d sum contribution is nan.", i);
      if (sum > 0.001)  esl_fatal("evaluate_rooted_erate() endsite %d sum is positive! sum %f lterm=%f", 
				  i, sum, lterm);      
    }    
    
    for (j = 0; j < rcategs; j++) {
      if (sumterm > 0.) clai[j] = tterm[j] / sumterm;
      else {
	if (rcategs == 1)  clai[j] = 1.0;
	else             { printf("There is some error in evaluate_erate()\n"); EOF_error(); }
      }
    }
    memcpy(contribution[i], clai, rcategs*sizeof(double));
    if (saveit && !auto_ && usertree && (which <= shimotrees))
      l0gf[which - 1][i] = lterm;
    
  } /* for each column */
  
  /* calculate sum2 and add it to sum 
   */
  /* add the allgaps column */
  /* initialize */
  for (j = 0; j < rcategs; j++)
    like[j] = 1.0;
  sumc = 0.0;
  for (k = 0; k < rcategs; k++) 
    sumc += probcat[k] * like[k];
  sumc *= lambda;
  memcpy(clai, contribution[endsite], rcategs*sizeof(double));
  for (j = 0; j < rcategs; j++) 
    nulike[j] = ((1.0 - lambda) * like[j] + sumc) * clai[j];
  memcpy(like, nulike, rcategs*sizeof(double));

  /* add the immortal-link column */
  /* initialize */
  for (j = 0; j < rcategs; j++)
    like[j] = 1.0;
  sumc = 0.0;
  for (k = 0; k < rcategs; k++) 
    sumc += probcat[k] * like[k];
  sumc *= lambda;
  memcpy(clai, contribution[endsite+1], rcategs*sizeof(double));
  for (j = 0; j < rcategs; j++) 
    nulike[j] = ((1.0 - lambda) * like[j] + sumc) * clai[j];
  memcpy(like, nulike, rcategs*sizeof(double));

  /* add the real columns terms */
  /* initialize */
  for (j = 0; j < rcategs; j++)
    like[j] = 1.0;
  for (i = 0; i < sites; i++) {
    sumc = 0.0;
    for (k = 0; k < rcategs; k++)
      sumc += probcat[k] * like[k];
    sumc *= lambda;
    if ((ally[i] > 0) && (location[ally[i]-1] > 0)) {
      lai = location[ally[i] - 1];
      memcpy(clai, contribution[lai - 1], rcategs*sizeof(double));
      for (j = 0; j < rcategs; j++)
        nulike[j] = ((1.0 - lambda) * like[j] + sumc) * clai[j];
    } else {
      for (j = 0; j < rcategs; j++)
        nulike[j] = ((1.0 - lambda) * like[j] + sumc);
    }
    memcpy(like, nulike, rcategs*sizeof(double));

  }
  sum2 = 0.0;
  for (i = 0; i < rcategs; i++) {
    sum2 += probcat[i] * like[i];
  }
  if (sum2 < 0.0 && sum2 > -tol) sum2 = 0.0;
  if (isnan(log(sum2)))
    esl_fatal("evaluate_rooted_erate(): nan sum2\n");
  sum += log(sum2);

  /* record the likelihood */
  if (sum > 0.0)  esl_fatal("evaluate_rooted_erate() positive lnlikelihood! %f sum2 %f", sum, sum2);
  if (isnan(sum)) esl_fatal("evaluate_rooted_erate() nan error sum %f sum2 %f.", sum, sum2);
  if (sum < -HUGE_VAL) sum = -HUGE_VAL;
  tree->likelihood = sum;

  if (verbose) {
    dnaml_printree_erate(tree, table_erate);
    fprintf(outfile, "evaluate rootl %ld rootr %ld %f\n", root_data->rchildl->index, root_data->rchildr->index, sum);
    fprintf(outfile, "maxdist %f taxal %ld taxar %ld\n", root_data->taxa_maxdist, root_data->taxal, root_data->taxar);
    fprintf(outfile, "rootl %ld (%f) rootr %ld (%f)\n", root_data->rootl, root_data->distrootl, root_data->rootr, root_data->distrootr);
    fprintf(outfile, "taxa_avedist_byroot %f\n", root_data->taxa_avedist_byroot);
  }
  if (verbose) {
    printf("\nevaluate rootl  %ld rootr  %ld %f\n", root_data->rchildl->index, root_data->rchildr->index, sum);
    tree_describe_erate(tree->start, verbose);
    printf("maxdist %f taxal %ld taxar %ld\n", root_data->taxa_maxdist, root_data->taxal, root_data->taxar);
    printf("rootl %ld (%f) rootr %ld (%f)\n", root_data->rootl, root_data->distrootl, root_data->rootr, root_data->distrootr);
    printf("taxa_avedist_byroot %f\n", root_data->taxa_avedist_byroot);
  }

  if (!saveit || auto_ || !usertree) {
    for (i = 0; i < endsite_erate; i++) {
      free(pl[i]);
      free(pr[i]);
    }
    free(pl);
    free(pr);
    free(underflowsl);
    free(underflowsr);
    return sum;
  }

  if(which <= shimotrees)
    l0gl[which - 1] = sum;
  if (which == 1) {
    maxwhich = 1;
    maxlogl = sum;
    for (i = 0; i < endsite_erate; i++) {
      free(pl[i]);
      free(pr[i]);
    }
    free(pl);
    free(pr);
    free(underflowsl);
    free(underflowsr);
    return sum;
  }

  if (sum > maxlogl) {
    maxwhich = which;
    maxlogl = sum;
  }

  for (i = 0; i < endsite_erate; i++) {
    free(pl[i]);
    free(pr[i]);
  }
  free(pl);
  free(pr);
  free(underflowsl);
  free(underflowsr);

  return sum;

} /* evaluate_rooted_erate */


void alloc_nvd (long num_sibs, nuview_data *local_nvd)
{
  /* Allocate blocks of memory appropriate for the number of siblings
     a given node has */
  local_nvd->yy     = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->wwzz   = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->vvzz   = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->vzsumr = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->vzsumy = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->sum    = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->sumr   = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->sumy   = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->xx     = (sitelike *) Malloc( num_sibs * sizeof (sitelike));
}  /* alloc_nvd */

void alloc_nvd_erate (long num_sibs, nuview_data_erate *local_nvd)
{
  /* Allocate blocks of memory appropriate for the number of siblings
     a given node has */
  local_nvd->yy     = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->wwzz   = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->vvzz   = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->jj     = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->gg     = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->kk     = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->vzsumr = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->vzsumy = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->sum    = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->sumr   = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->sumy   = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->sumjj  = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->sumgg  = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->del    = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->ins    = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->kkm    = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->star   = (double *) Malloc( num_sibs * sizeof (double));
  local_nvd->xx     = (sitelike_erate *) Malloc( num_sibs * sizeof (sitelike_erate));
}  /* alloc_nvd_erate */


void free_nvd (nuview_data *local_nvd)
{
  /* The natural complement to the alloc version */
  free (local_nvd->yy);
  free (local_nvd->wwzz);
  free (local_nvd->vvzz);
  free (local_nvd->vzsumr);
  free (local_nvd->vzsumy);
  free (local_nvd->sum);
  free (local_nvd->sumr);
  free (local_nvd->sumy);
  free (local_nvd->xx);
}  /* free_nvd */

void free_nvd_erate (nuview_data_erate *local_nvd)
{
  /* The natural complement to the alloc version */
  if (local_nvd->yy) free (local_nvd->yy);
  if (local_nvd->wwzz) free (local_nvd->wwzz);
  if (local_nvd->vvzz) free (local_nvd->vvzz);
  if (local_nvd->jj) free (local_nvd->jj);
  if (local_nvd->gg) free (local_nvd->gg);
  if (local_nvd->kk)  free (local_nvd->kk);
  if (local_nvd->vzsumr) free (local_nvd->vzsumr);
  if (local_nvd->vzsumy) free (local_nvd->vzsumy);
  if (local_nvd->sum) free (local_nvd->sum);
  if (local_nvd->sumr) free (local_nvd->sumr);
  if (local_nvd->sumy) free (local_nvd->sumy);
  if (local_nvd->sumjj) free (local_nvd->sumjj);
  if (local_nvd->sumgg) free (local_nvd->sumgg);
  if (local_nvd->del) free (local_nvd->del);
  if (local_nvd->ins) free (local_nvd->ins);
  if (local_nvd->kkm) free (local_nvd->kkm);
  if (local_nvd->star) free (local_nvd->star);
  if (local_nvd->xx) free (local_nvd->xx);
}  /* free_nvd_erate */


void nuview(node *p)
{
  long i, j, k, l,num_sibs, sib_index;
  nuview_data *local_nvd = NULL;
  node *sib_ptr, *sib_back_ptr;
  sitelike p_xx;
  double lw;
  double correction;
  double maxx;

  /* Figure out how many siblings the current node has */
  num_sibs    = count_sibs (p);

  /* Recursive calls, should be called for all children */
  sib_ptr = p;
  for (i=0 ; i < num_sibs; i++) {
    sib_ptr      = sib_ptr->next;
    sib_back_ptr = sib_ptr->back;

    if (!sib_back_ptr->tip &&
        !sib_back_ptr->initialized)
      nuview (sib_back_ptr);
  }

  /* Allocate the structure and blocks therein for variables used in
     this function */
  local_nvd = (nuview_data *) Malloc( sizeof (nuview_data));
  alloc_nvd (num_sibs, local_nvd);


  /* Loop 1: makes assignments to tbl based on some combination of
     what's already in tbl and the children's value of v */
  sib_ptr = p; 
  for (sib_index=0; sib_index < num_sibs; sib_index++) {
    sib_ptr      = sib_ptr->next;
    sib_back_ptr = sib_ptr->back;
    
    lw = - (sib_back_ptr->v);

    for (i = 0; i < rcategs; i++)
      for (j = 0; j < categs; j++) {
        tbl[i][j]->ww[sib_index]   = exp(tbl[i][j]->ratxi * lw);
        tbl[i][j]->zz[sib_index]   = exp(tbl[i][j]->ratxv * lw);
        tbl[i][j]->wwzz[sib_index] = tbl[i][j]->ww[sib_index] * 
          tbl[i][j]->zz[sib_index];
        tbl[i][j]->vvzz[sib_index] = (1.0 - tbl[i][j]->ww[sib_index]) *
          tbl[i][j]->zz[sib_index];
      }
  }
  
  /* Loop 2: */
  for (i = 0; i < endsite; i++) {
    correction = 0;
    maxx = 0;
    k = category[alias[i]-1] - 1;
    for (j = 0; j < rcategs; j++) {

      /* Loop 2.1 */
      sib_ptr = p;
      for (sib_index=0; sib_index < num_sibs; sib_index++) {
        sib_ptr         = sib_ptr->next;
        sib_back_ptr    = sib_ptr->back;
        if ( j == 0 )
          correction += sib_back_ptr->underflows[i];

        local_nvd->wwzz[sib_index] = tbl[j][k]->wwzz[sib_index];
        local_nvd->vvzz[sib_index] = tbl[j][k]->vvzz[sib_index];
        local_nvd->yy[sib_index]   = 1.0 - tbl[j][k]->zz[sib_index];
        memcpy(local_nvd->xx[sib_index],
               sib_back_ptr->x[i][j],
               sizeof(sitelike));
      }

      /* Loop 2.2 */
      for (sib_index=0; sib_index < num_sibs; sib_index++) {
        local_nvd->sum[sib_index] =
          local_nvd->yy[sib_index] *
          (freqa * local_nvd->xx[sib_index][(long)A] +
           freqc * local_nvd->xx[sib_index][(long)C] +
           freqg * local_nvd->xx[sib_index][(long)G] +
           freqt * local_nvd->xx[sib_index][(long)T]);
        local_nvd->sumr[sib_index] =
          freqar * local_nvd->xx[sib_index][(long)A] +
          freqgr * local_nvd->xx[sib_index][(long)G];
        local_nvd->sumy[sib_index] =
          freqcy * local_nvd->xx[sib_index][(long)C] +
          freqty * local_nvd->xx[sib_index][(long)T];
        local_nvd->vzsumr[sib_index] =
          local_nvd->vvzz[sib_index] * local_nvd->sumr[sib_index];
        local_nvd->vzsumy[sib_index] =
          local_nvd->vvzz[sib_index] * local_nvd->sumy[sib_index];
      }

      /* Initialize to one, multiply incremental values for every
         sibling a node has */
      p_xx[(long)A] = 1 ;
      p_xx[(long)C] = 1 ; 
      p_xx[(long)G] = 1 ;
      p_xx[(long)T] = 1 ;

      for (sib_index=0; sib_index < num_sibs; sib_index++) {
        p_xx[(long)A] *=
          local_nvd->sum[sib_index] +
          local_nvd->wwzz[sib_index] *
          local_nvd->xx[sib_index][(long)A] +
          local_nvd->vzsumr[sib_index];
        p_xx[(long)C] *=
          local_nvd->sum[sib_index] +
          local_nvd->wwzz[sib_index] *
          local_nvd->xx[sib_index][(long)C] +
          local_nvd->vzsumy[sib_index];
        p_xx[(long)G] *=
          local_nvd->sum[sib_index] +
          local_nvd->wwzz[sib_index] *
          local_nvd->xx[sib_index][(long)G] +
          local_nvd->vzsumr[sib_index];
        p_xx[(long)T] *=
          local_nvd->sum[sib_index] +
          local_nvd->wwzz[sib_index] *
          local_nvd->xx[sib_index][(long)T] +
          local_nvd->vzsumy[sib_index];
      }

      for ( l = 0 ; l < ((long)T - (long)A + 1); l++ ) {
        if ( p_xx[l] > maxx )
          maxx = p_xx[l];
      }
      /* And the final point of this whole function: */
      memcpy(p->x[i][j], p_xx, sizeof(sitelike));
    }
    p->underflows[i] = 0;
    if ( maxx < MIN_DOUBLE)
      fix_x(p,i,maxx,rcategs);
    p->underflows[i] += correction;
  }

  p->initialized = true;
  free_nvd (local_nvd);
  free (local_nvd);
}  /* nuview */



void nuview_erate(node_erate *p, valrec_erate ***table_erate, long endsite_erate, double tol)
{
  long i, j, k, l,num_sibs, sib_index; 
  nuview_data_erate *local_nvd = NULL; 
  node_erate *sib_ptr, *sib_back_ptr; 
  sitelike_erate p_xx; 
  double lw; 
  double correction; 
  double maxx; 
  boolean  p_allgapleaves = FALSE;
  boolean *sib_allgapleaves;
  boolean others_allgapleaves;
  int sidx;
  
  /* Figure out how many siblings the current node has */
  num_sibs = count_sibs_erate (p);
  
  /* Recursive calls, should be called for all children */
  sib_ptr = p;
  for (i=0 ; i < num_sibs; i++) {
    sib_ptr      = sib_ptr->next;
    sib_back_ptr = sib_ptr->back;
    
    if (!sib_back_ptr->tip &&
        !sib_back_ptr->initialized)
      nuview_erate(sib_back_ptr, table_erate, endsite_erate, tol);
  }
  
  /* Allocate the structure and blocks therein for variables used in
     this function */
  local_nvd = (nuview_data_erate *) Malloc( sizeof (nuview_data_erate));
  alloc_nvd_erate (num_sibs, local_nvd);

  /* Loop 1: makes assignments to tbl based on some combination of
     what's already in tbl and the children's value of v */
  sib_ptr = p;
  for (sib_index=0; sib_index < num_sibs; sib_index++) {
    sib_ptr      = sib_ptr->next;
    sib_back_ptr = sib_ptr->back;
    
    lw = -(sib_back_ptr->v);

    if (isnan(lw)) esl_fatal("nuview_erate() error. time is %f", lw);

    for (i = 0; i < rcategs; i++)
      for (j = 0; j < categs; j++) {
        table_erate[i][j]->ww[sib_index]   = 
	  exp(table_erate[i][j]->ratxi * lw);
        table_erate[i][j]->zz[sib_index]   = 
	  exp(table_erate[i][j]->ratxv * lw) * 
	  exp(table_erate[i][j]->ratxm * lw);
        table_erate[i][j]->wwzz[sib_index] = 
	  table_erate[i][j]->ww[sib_index] * 
          table_erate[i][j]->zz[sib_index];
        table_erate[i][j]->vvzz[sib_index] = 
	  (1.0 - table_erate[i][j]->ww[sib_index]) *
          table_erate[i][j]->zz[sib_index];
	
	table_erate[i][j]->ii[sib_index] = 
	  exp(table_erate[i][j]->ratxl * lw) * 
	  exp(table_erate[i][j]->ratxm * lw);
	
	/* set xi_t, set xl=0 limit first */
	if (table_erate[i][j]->ratxl < 1.0*tol) 
	  {
	    table_erate[i][j]->kk[sib_index] = 0.0;
	  }
	else 
	  {
	    table_erate[i][j]->kk[sib_index] =  
	      ( table_erate[i][j]->ratxl/(table_erate[i][j]->ratxl + table_erate[i][j]->ratxm) ) * 
	      ( 1.0-table_erate[i][j]->ii[sib_index] );
	  }
	
	/* set gamma_t, set xm=0 limit first */
	if (table_erate[i][j]->ratxm < 1.0*tol) 
	  {
	    table_erate[i][j]->gg[sib_index] = 0.0;
	  }
	else 
	  {
	    table_erate[i][j]->gg[sib_index] =  
	      ( table_erate[i][j]->ratxm/(table_erate[i][j]->ratxl + table_erate[i][j]->ratxm) ) * 
	      (1.0-table_erate[i][j]->ii[sib_index]);
	  }
      }
  }
  
  /* Loop 2: */
  /* calculate also the extra columns endsite = allgaps and endsite+1=immortal link */
  for (i = 0; i < endsite_erate; i++) { 
    correction = 0;
    maxx = 0;
    if (i < endsite) k = category[alias[i]-1] - 1;
    else             k = 0;
    
    for (j = 0; j < rcategs; j++) {
      
      if (i <= endsite) {
	p_allgapleaves = node_colisallgaps_erate(i, j, p, FALSE);
	/* paranoia */
	if (i == endsite) { 
	  if (p_allgapleaves == FALSE)
	    esl_fatal("nuview_erate(): i=endsite should be an allgaps column\n");
	}
	if (i <endsite && freqo == 0) {
	  if (p_allgapleaves == TRUE)
	    esl_fatal("nuview_erate(): this is an alignment without gaps! endsite %d\n", endsite);
	}
      }
      
      /* siblings gaps */
      sib_allgapleaves = (boolean *) malloc(sizeof(boolean) * num_sibs);
      sib_ptr = p;
      for (sib_index=0; sib_index < num_sibs; sib_index++) {
        sib_ptr         = sib_ptr->next;
        sib_back_ptr    = sib_ptr->back;
	
	sib_allgapleaves[sib_index] = node_colisallgaps_erate(i, j, sib_back_ptr, FALSE);
	/* paranoia */
	if (sib_allgapleaves[sib_index] == FALSE && p_allgapleaves == TRUE)
	  esl_fatal("nuview_erate(): node %d not compatible with parent node p %d\n", 
		    sib_back_ptr->index, p->index);
	if (i < endsite && freqo == 0) {
	  if (sib_allgapleaves[sib_index] == TRUE)
	    esl_fatal("nuview_erate(): this is an alignment without gaps! endsite %d\n", endsite);
	}
      }
      
      /* Loop 2.1 */ 
      sib_ptr = p;
      for (sib_index=0; sib_index < num_sibs; sib_index++) {
        sib_ptr         = sib_ptr->next;
        sib_back_ptr    = sib_ptr->back;
	
      if ( j == 0 && i < endsite)
          correction += sib_back_ptr->underflows[i];

        local_nvd->wwzz[sib_index]  = table_erate[j][k]->wwzz[sib_index];
        local_nvd->vvzz[sib_index]  = table_erate[j][k]->vvzz[sib_index];
        local_nvd->yy[sib_index]    = 1.0 - table_erate[j][k]->zz[sib_index];
        local_nvd->jj[sib_index]    = 1.0 - table_erate[j][k]->ii[sib_index];
        local_nvd->kk[sib_index]    = table_erate[j][k]->kk[sib_index];
        local_nvd->gg[sib_index]    = table_erate[j][k]->gg[sib_index];
        local_nvd->kkm[sib_index]   = 1.0 - table_erate[j][k]->kk[sib_index];
        memcpy(local_nvd->xx[sib_index],
               sib_back_ptr->xe[i][j],
               sizeof(sitelike_erate));
       }
      
      /* Loop 2.2 */
      for (sib_index=0; sib_index < num_sibs; sib_index++) {
        local_nvd->sum[sib_index] =
	  local_nvd->kkm[sib_index] *
          local_nvd->yy[sib_index]    *
          (freqa * local_nvd->xx[sib_index][(long)A] +
           freqc * local_nvd->xx[sib_index][(long)C] +
           freqg * local_nvd->xx[sib_index][(long)G] +
           freqt * local_nvd->xx[sib_index][(long)T]);
        local_nvd->sumr[sib_index] =
          freqar * local_nvd->xx[sib_index][(long)A] +
          freqgr * local_nvd->xx[sib_index][(long)G];
        local_nvd->sumy[sib_index] =
          freqcy * local_nvd->xx[sib_index][(long)C] +
          freqty * local_nvd->xx[sib_index][(long)T];
        local_nvd->vzsumr[sib_index] =
	  local_nvd->kkm[sib_index] *
          local_nvd->vvzz[sib_index]  * 
	  local_nvd->sumr[sib_index];
        local_nvd->vzsumy[sib_index] =
	  local_nvd->kkm[sib_index] *
          local_nvd->vvzz[sib_index]  * 
	  local_nvd->sumy[sib_index];
        local_nvd->sumjj[sib_index] =
	  local_nvd->kkm[sib_index] *
          local_nvd->jj[sib_index]    *
          (freqa * local_nvd->xx[sib_index][(long)A] +
           freqc * local_nvd->xx[sib_index][(long)C] +
           freqg * local_nvd->xx[sib_index][(long)G] +
           freqt * local_nvd->xx[sib_index][(long)T]);
        local_nvd->sumgg[sib_index] =
	  local_nvd->kkm[sib_index] *
          local_nvd->gg[sib_index]    *
          (freqa * local_nvd->xx[sib_index][(long)A] +
           freqc * local_nvd->xx[sib_index][(long)C] +
           freqg * local_nvd->xx[sib_index][(long)G] +
           freqt * local_nvd->xx[sib_index][(long)T]);
	local_nvd->ins[sib_index] = 
	  local_nvd->kk[sib_index] *
	  (freqa * local_nvd->xx[sib_index][(long)A] +
	   freqc * local_nvd->xx[sib_index][(long)C] +
	   freqg * local_nvd->xx[sib_index][(long)G] +
	   freqt * local_nvd->xx[sib_index][(long)T]);
	local_nvd->star[sib_index] =  /* for the immortal column */
	  local_nvd->kkm[sib_index] * 
	  local_nvd->xx[sib_index][(long)O];
      }
      
      /* Initialize to one, multiply incremental values for every
         sibling a node has */
      p_xx[(long)A] = 1 ;
      p_xx[(long)C] = 1 ; 
      p_xx[(long)G] = 1 ;
      p_xx[(long)T] = 1 ;
      if (i <= endsite)
	p_xx[(long)O] = 0 ;
      else 
	p_xx[(long)O] = 1 ;
      
     /* p_xx is the likelihood of tnode p for each residue/gap */
      sib_ptr = p;
      for (sib_index=0; sib_index < num_sibs; sib_index++) {
        sib_ptr         = sib_ptr->next;
        sib_back_ptr    = sib_ptr->back;

 	if (i <= endsite) { /* the observed columns and the allgaps column */


  	  if (sib_allgapleaves[sib_index] == TRUE) {
	    p_xx[(long)A] *=
	      + local_nvd->sum[sib_index] 
	      + local_nvd->kkm[sib_index] *
	        local_nvd->wwzz[sib_index]  *
	        local_nvd->xx[sib_index][(long)A] 
	      + local_nvd->vzsumr[sib_index] 
	      - local_nvd->sumgg[sib_index] 
	      + local_nvd->kkm[sib_index] *
	        local_nvd->gg[sib_index];
	    p_xx[(long)C] *=
	      + local_nvd->sum[sib_index] 
	      + local_nvd->kkm[sib_index] *
	        local_nvd->wwzz[sib_index]  *
	        local_nvd->xx[sib_index][(long)C] 
	      + local_nvd->vzsumy[sib_index] 
	      - local_nvd->sumgg[sib_index] 
	      + local_nvd->kkm[sib_index] *
	        local_nvd->gg[sib_index];
	    p_xx[(long)G] *=
	      + local_nvd->sum[sib_index] 
	      + local_nvd->kkm[sib_index] *
	        local_nvd->wwzz[sib_index]  *
	        local_nvd->xx[sib_index][(long)G] 
	      + local_nvd->vzsumr[sib_index] 
	      - local_nvd->sumgg[sib_index] 
	      + local_nvd->kkm[sib_index] *
	        local_nvd->gg[sib_index];
	    p_xx[(long)T] *=
	      + local_nvd->sum[sib_index] 
	      + local_nvd->kkm[sib_index] *
	        local_nvd->wwzz[sib_index]  *
	        local_nvd->xx[sib_index][(long)T] 
	      + local_nvd->vzsumy[sib_index] 
	      - local_nvd->sumgg[sib_index] 
	      + local_nvd->kkm[sib_index] *
	        local_nvd->gg[sib_index];
	  }
	  else {
	    p_xx[(long)A] *=
	      + local_nvd->sum[sib_index] 
	      + local_nvd->kkm[sib_index] *
	        local_nvd->wwzz[sib_index]  *
	        local_nvd->xx[sib_index][(long)A] 
	      + local_nvd->vzsumr[sib_index] 
	      - local_nvd->sumgg[sib_index] 
	      + local_nvd->del[sib_index];
	    p_xx[(long)C] *=
	      + local_nvd->sum[sib_index] 
	      + local_nvd->kkm[sib_index] *
	        local_nvd->wwzz[sib_index]  *
	        local_nvd->xx[sib_index][(long)C] 
	      + local_nvd->vzsumy[sib_index] 
	      - local_nvd->sumgg[sib_index] 
	      + local_nvd->del[sib_index];
	    p_xx[(long)G] *=
	      + local_nvd->sum[sib_index] 
	      + local_nvd->kkm[sib_index] *
	        local_nvd->wwzz[sib_index]  *
	        local_nvd->xx[sib_index][(long)G] 
	      + local_nvd->vzsumr[sib_index] 
	      - local_nvd->sumgg[sib_index] 
	      + local_nvd->del[sib_index];
	    p_xx[(long)T] *=
	      + local_nvd->sum[sib_index] 
	      + local_nvd->kkm[sib_index] *
	        local_nvd->wwzz[sib_index]  *
	        local_nvd->xx[sib_index][(long)T] 
	      + local_nvd->vzsumy[sib_index] 
	      - local_nvd->sumgg[sib_index] 
	      + local_nvd->del[sib_index];
	  }

	  if (sib_allgapleaves[sib_index] == FALSE) {

	    others_allgapleaves = TRUE;
	    for (sidx=0; sidx < num_sibs; sidx++) {
	      if (sidx != sib_index && 
		  sib_allgapleaves[sidx] == FALSE)
		{
		  others_allgapleaves = FALSE;
		  break;
		}
	    }
	    if (others_allgapleaves == TRUE) 
	      p_xx[(long)O] += 
		+ local_nvd->ins[sib_index] 
		+ local_nvd->xx[sib_index][(long)O];
	  }

	}
	else if (i == endsite+1) { /* the immortal column */
	  p_xx[(long)A] *=
	    local_nvd->xx[sib_index][(long)A];
	  p_xx[(long)C] *=
	    local_nvd->xx[sib_index][(long)C];
	  p_xx[(long)G] *=
	    local_nvd->xx[sib_index][(long)G];
	  p_xx[(long)T] *=
	    local_nvd->xx[sib_index][(long)T];
	  p_xx[(long)O] *= 
	    local_nvd->star[sib_index];
	}
      } /* for all daughter nodes */

     if (0) 
	printf("nuview_erate lw %f idx %ld endsite=%ld (%d) i=%ld j=%ld xe: %f %f %f %f %f\n",
	       lw, p->index,
	       endsite, p_allgapleaves, i, j, 
	       p_xx[(long)A],
	       p_xx[(long)C],
	       p_xx[(long)G],
	       p_xx[(long)T],
	       p_xx[(long)O]);

     for ( l = 0 ; l < ((long)O - (long)A + 1); l++ ) {
       if (isnan(p_xx[l])) esl_fatal("nuview_erate() nan error. i=%ld p_xx[%d]=%f", i, l, p_xx[l]);
	if (p_xx[l] < 0.0) {
	  if (p_xx[l] > -tol)  p_xx[l] = 0.0;
	  else esl_fatal("nuview_erate() error. i=%ld p_xx[%d]=%f", i, l, p_xx[l]);
	}
	if (p_xx[l] > 1.0) {
	  if (p_xx[l] < 1.0+tol)  p_xx[l] = 1.0;
	  else esl_fatal("nuview_erate() error. i =%ld p_xx[%d]=%f", i, l, p_xx[l]);
	}
	
	if ( p_xx[l] > maxx )
          maxx = p_xx[l];
     }
      
      /* And the final point of this whole function: */
      memcpy(p->xe[i][j], p_xx, sizeof(sitelike_erate));
    }
    
    if (i < endsite) {
      p->underflows[i] = 0;
      if ( maxx < MIN_DOUBLE)
	fix_xe(p,i,maxx,rcategs);
      
      p->underflows[i] += correction;  
      if (isnan(p->underflows[i])) esl_fatal("nuview_erate(): unique site=%ld underflow is nan.", i);
    } 

    if (sib_allgapleaves != NULL) free(sib_allgapleaves);
  }
  
  p->initialized = true;
  free_nvd_erate (local_nvd);
  free (local_nvd);
  
}  /* nuview_erate */

/* Function:  nuview_onenode_erate()
 *
 * Incept:    ER, Wed Apr  4 11:09:51 EDT 2007 [Janelia]
 *
 * Synopsis:  This function is somewhat similar to nuview_erate().
 *
 *            nuview_erate() is given one "parent" node and
 *            (possibly) many chidren nodes. It calculates the likelihood
 *            up to the parent node.
 *
 *            nuview_onenode_erate() is given one "child" node and
 *            one branch length. It calculates the likelihood
 *            up the branch length that includes the child node.
 *
 * Purpose:   it calculates an array that corresponds to
 *
 *            array[i] = \sum_j Q_{i,j}^t * L_p(j)
 *
 *            the indices i,j include gaps.
 *
 * Args:      
 *
 * Returns:   sitelike_erate
 *
 */
void nuview_onenode_erate(phenotype_erate *ret_p_xe, double **ret_underflows, node_erate *p, double t, 
			  valrec_erate ***table_erate, long endsite_erate, double tol)
{
  nuview_data_erate *local_nvd = NULL;        
  phenotype_erate    p_xe; 
  sitelike_erate     p_xx; 
  double            *underflows;       
  long               i, j, k, l; 
  long               num_sibs, sib_index;
  double             lw; 
  double             correction; 
  double             maxx; 

  /* only one node in this case */
  num_sibs = 1;

  /* If the likelihood up to node p has not been calculated yet,
   * do it now.
   */
  if (!p->tip && !p->initialized)
    nuview_erate(p, table_erate, endsite_erate, tol);

  /* Allocate the structure and blocks therein for variables used in
   *  this function 
  */
  underflows = (double *) malloc(sizeof(double) * (endsite_erate));
  p_xe       = (phenotype_erate)Malloc(endsite_erate*sizeof(ratelike_erate));
  for (k = 0; k < endsite_erate; k++)
    p_xe[k] = (ratelike_erate)Malloc(rcategs*sizeof(sitelike_erate));

  local_nvd  = (nuview_data_erate *) Malloc( sizeof (nuview_data_erate));
  alloc_nvd_erate (num_sibs, local_nvd);

  /* Loop 1 is similar to nuview_erate.
   *
   * Loop 1: makes assignments to tbl based on some combination of
   * what's already in tbl and the time of the branch we are adding. 
   */    
  sib_index = 0; /* just one node */
  lw = -t;
  if (isnan(lw)) esl_fatal("nuview_onenode_erate() error. time is %f", lw);
  
  for (i = 0; i < rcategs; i++)
    for (j = 0; j < categs; j++) {
        table_erate[i][j]->ww[sib_index]   = 
	  exp(table_erate[i][j]->ratxi * lw);
        table_erate[i][j]->zz[sib_index]   = 
	  exp(table_erate[i][j]->ratxv * lw) * 
	  exp(table_erate[i][j]->ratxm * lw);
        table_erate[i][j]->wwzz[sib_index] = 
	  table_erate[i][j]->ww[sib_index] * 
          table_erate[i][j]->zz[sib_index];
        table_erate[i][j]->vvzz[sib_index] = 
	  (1.0 - table_erate[i][j]->ww[sib_index]) *
          table_erate[i][j]->zz[sib_index];
	
	table_erate[i][j]->ii[sib_index] = 
	  exp(table_erate[i][j]->ratxl * lw) * 
	  exp(table_erate[i][j]->ratxm * lw);
	
	/* set xi_t, set xl=0 limit first */
	if (table_erate[i][j]->ratxl < 1.0*tol) 
	  {
	    table_erate[i][j]->kk[sib_index] = 0.0;
	  }
	else 
	  {
	    table_erate[i][j]->kk[sib_index] =  
	      ( table_erate[i][j]->ratxl/(table_erate[i][j]->ratxl + table_erate[i][j]->ratxm) ) * 
	      ( 1.0-table_erate[i][j]->ii[sib_index] );
	  }
	
	/* set gamma_t, set xm=0 limit first */
	if (table_erate[i][j]->ratxm < 1.0*tol) 
	  {
	    table_erate[i][j]->gg[sib_index] = 0.0;
	  }
	else 
	  {
	    table_erate[i][j]->gg[sib_index] =  
	      ( table_erate[i][j]->ratxm/(table_erate[i][j]->ratxl + table_erate[i][j]->ratxm) ) * 
	      (1.0-table_erate[i][j]->ii[sib_index]);
	  }
    }
  
  /* Loop 2: */
  /* calculate also the extra columns 
     endsite   = allgaps,
     endsite+1 = immortal-link 
  */
  for (i = 0; i < endsite_erate; i++) { 
    correction = 0;
    maxx = 0;
    if (i < endsite) k = category[alias[i]-1] - 1;
    else             k = 0;

    for (j = 0; j < rcategs; j++) {
      
    /* Loop 2.1 */ 
      correction += p->underflows[i];
      
      local_nvd->wwzz[sib_index]  = table_erate[j][k]->wwzz[sib_index];
      local_nvd->vvzz[sib_index]  = table_erate[j][k]->vvzz[sib_index];
      local_nvd->yy[sib_index]    = 1.0 - table_erate[j][k]->zz[sib_index];
      local_nvd->jj[sib_index]    = 1.0 - table_erate[j][k]->ii[sib_index];
      local_nvd->kk[sib_index]    = table_erate[j][k]->kk[sib_index];
      local_nvd->gg[sib_index]    = table_erate[j][k]->gg[sib_index];
      local_nvd->kkm[sib_index]   = 1.0 - table_erate[j][k]->kk[sib_index];
      memcpy(local_nvd->xx[sib_index],
	     p->xe[i][j],
	     sizeof(sitelike_erate));
      
      /* Loop 2.2 */
      local_nvd->sum[sib_index] =
	local_nvd->kkm[sib_index] *
	local_nvd->yy[sib_index]    *
	(freqa * local_nvd->xx[sib_index][(long)A] +
	 freqc * local_nvd->xx[sib_index][(long)C] +
	 freqg * local_nvd->xx[sib_index][(long)G] +
	 freqt * local_nvd->xx[sib_index][(long)T]);
      local_nvd->sumr[sib_index] =
	freqar * local_nvd->xx[sib_index][(long)A] +
	freqgr * local_nvd->xx[sib_index][(long)G];
      local_nvd->sumy[sib_index] =
	freqcy * local_nvd->xx[sib_index][(long)C] +
	freqty * local_nvd->xx[sib_index][(long)T];
      local_nvd->vzsumr[sib_index] =
	local_nvd->kkm[sib_index] *
	local_nvd->vvzz[sib_index]  * 
	local_nvd->sumr[sib_index];
      local_nvd->vzsumy[sib_index] =
	local_nvd->kkm[sib_index] *
	local_nvd->vvzz[sib_index]  *
	local_nvd->sumy[sib_index];
      local_nvd->sumjj[sib_index] =
	local_nvd->kkm[sib_index] *
	local_nvd->jj[sib_index]    *
	(freqa * local_nvd->xx[sib_index][(long)A] +
	 freqc * local_nvd->xx[sib_index][(long)C] +
	 freqg * local_nvd->xx[sib_index][(long)G] +
	 freqt * local_nvd->xx[sib_index][(long)T]);
      local_nvd->sumgg[sib_index] =
	local_nvd->kkm[sib_index] *
	local_nvd->gg[sib_index]    *
	(freqa * local_nvd->xx[sib_index][(long)A] +
	 freqc * local_nvd->xx[sib_index][(long)C] +
	 freqg * local_nvd->xx[sib_index][(long)G] +
	 freqt * local_nvd->xx[sib_index][(long)T]);
      local_nvd->ins[sib_index] = 
	local_nvd->kk[sib_index] *
	(freqa * local_nvd->xx[sib_index][(long)A] +
	 freqc * local_nvd->xx[sib_index][(long)C] +
	 freqg * local_nvd->xx[sib_index][(long)G] +
	 freqt * local_nvd->xx[sib_index][(long)T]);
      local_nvd->star[sib_index] = 
	local_nvd->kkm[sib_index] * 
	local_nvd->xx[sib_index][(long)O];
     
      /* p_xx is the likelihood of the node p for each residue/gap */
      if (i <= endsite) {/* the observed columns and allgaps column */
	p_xx[(long)A] =
	  + local_nvd->sum[sib_index] 
	  + local_nvd->kkm[sib_index] *
	    local_nvd->wwzz[sib_index]  *
	    local_nvd->xx[sib_index][(long)A] 
	  + local_nvd->vzsumr[sib_index] 
	  - local_nvd->sumgg[sib_index];
	p_xx[(long)C] =
	  + local_nvd->sum[sib_index] 
	  + local_nvd->kkm[sib_index] *
	    local_nvd->wwzz[sib_index]  *
	    local_nvd->xx[sib_index][(long)C] 
	  + local_nvd->vzsumy[sib_index] 
	  - local_nvd->sumgg[sib_index];
	p_xx[(long)G] =
	  + local_nvd->sum[sib_index] 
	  + local_nvd->kkm[sib_index] *
	    local_nvd->wwzz[sib_index]  *
	    local_nvd->xx[sib_index][(long)G] 
	  + local_nvd->vzsumr[sib_index] 
	  - local_nvd->sumgg[sib_index];
	p_xx[(long)T] =
	  + local_nvd->sum[sib_index] 
	  + local_nvd->kkm[sib_index] *
	    local_nvd->wwzz[sib_index]  *
	    local_nvd->xx[sib_index][(long)T] 
	  + local_nvd->vzsumy[sib_index] 
	  - local_nvd->sumgg[sib_index]; 
	p_xx[(long)O] = 
	  + local_nvd->ins[sib_index];  
      }
      else if (i == endsite+1) { /* the immortal column */
	  p_xx[(long)A] =
	    local_nvd->xx[sib_index][(long)A];
	  p_xx[(long)C] =
	    local_nvd->xx[sib_index][(long)C];
	  p_xx[(long)G] =
	    local_nvd->xx[sib_index][(long)G];
	  p_xx[(long)T] =
	    local_nvd->xx[sib_index][(long)T];
	  p_xx[(long)O] = 
	    local_nvd->star[sib_index];
      }
      
    for ( l = 0 ; l < ((long)O - (long)A + 1); l++ ) {
	if (isnan(p_xx[l])) esl_fatal("nuview_onenode_erate() nan error. p_xx[%d]=%f", l, p_xx[l]);
	if (p_xx[l] < 0.0) {
	  if (p_xx[l] > -tol)  p_xx[l] = 0.0;
	  else esl_fatal("nuview_onenode_erate() error. i=%ld p_xx[%d]=%f", i, l, p_xx[l]);
	}
	if (p_xx[l] > 1.0) {
	  if (p_xx[l] < 1.0+tol)  p_xx[l] = 1.0;
	  else esl_fatal("nuview_onenode_erate() error. i=%ld p_xx[%d]=%f", i, l, p_xx[l]);
	}
	
	if ( p_xx[l] > maxx )
          maxx = p_xx[l];
      }
      
      /* And the final point of this whole function: */
      memcpy(p_xe[i][j], p_xx, sizeof(sitelike_erate));

      if (0) 
	printf("nuview_onenode_erate idx %ld i=%ld j=%ld xe: %f %f %f %f %f\n",p->index,
	       i, j, 
	       p_xe[i][j][(long)A],
	       p_xe[i][j][(long)C],
	       p_xe[i][j][(long)G],
	       p_xe[i][j][(long)T],
	       p_xe[i][j][(long)O]);
    }

    if (i < endsite) {
      underflows[i] = 0;
      if ( maxx < MIN_DOUBLE) {
	underflows[i] += log(maxx);
	
	if (maxx > 0.0) {
	  for ( j = 0 ; j < rcategs ; j++ ) {
	    for ( k = 0 ; k < ((long)O - (long)A + 1) ; k++)
	      p_xe[i][j][k] /= maxx;
	  }
	}      
      }
      underflows[i] += correction;
      if (isnan(underflows[i])) esl_fatal("nuview_onenode_erate(): unique site=%d underflow is nan.", i);
    }    
  }
  
  free_nvd_erate (local_nvd);
  free (local_nvd);

  *ret_p_xe       = p_xe;
  *ret_underflows = underflows;
  
} /* nuview_onenode_erate */


void slopecurv(node *p,double y,double *like,double *slope,double *curve)
{
   /* compute log likelihood, slope and curvature at node p */
  long i, j, k, lai;
  double sum, sumc, sumterm, lterm, sumcs, sumcc, sum2, slope2, curve2,
        temp;
  double lz, zz, z1, zzs, z1s, zzc, z1c, aa, bb, cc,
         prod1, prod2, prod12, prod3;
  contribarr thelike, nulike, nuslope, nucurve,
    theslope, thecurve, clai, cslai, cclai;
  node *q;
  sitelike x1, x2;

  q = p->back;
  sum = 0.0;
  lz = -y;
  for (i = 0; i < rcategs; i++)
    for (j = 0; j < categs; j++) {
      tbl[i][j]->orig_zz = exp(tbl[i][j]->rat * lz);
      tbl[i][j]->z1 = exp(tbl[i][j]->ratxv * lz);
    }
  for (i = 0; i < endsite; i++) {
    k = category[alias[i]-1] - 1;
    for (j = 0; j < rcategs; j++) {
      if (y > 0.0) {
        zz = tbl[j][k]->orig_zz;
        z1 = tbl[j][k]->z1;
      } else {
        zz = 1.0;
        z1 = 1.0;
      }
      zzs = -tbl[j][k]->rat * zz ;
      z1s = -tbl[j][k]->ratxv * z1 ;
      temp = tbl[j][k]->rat;
      zzc = temp * temp * zz;
      temp = tbl[j][k]->ratxv;
      z1c = temp * temp * z1;
      memcpy(x1, p->x[i][j], sizeof(sitelike));
      prod1 = freqa * x1[0] + freqc * x1[(long)C - (long)A] +
            freqg * x1[(long)G - (long)A] + freqt * x1[(long)T - (long)A];
      memcpy(x2, q->x[i][j], sizeof(sitelike));
      prod2 = freqa * x2[0] + freqc * x2[(long)C - (long)A] +
            freqg * x2[(long)G - (long)A] + freqt * x2[(long)T - (long)A];
      prod3 = (x1[0] * freqa + x1[(long)G - (long)A] * freqg) *
              (x2[0] * freqar + x2[(long)G - (long)A] * freqgr) +
        (x1[(long)C - (long)A] * freqc + x1[(long)T - (long)A] * freqt) *
        (x2[(long)C - (long)A] * freqcy + x2[(long)T - (long)A] * freqty);
      prod12 = freqa * x1[0] * x2[0] +
               freqc * x1[(long)C - (long)A] * x2[(long)C - (long)A] +
               freqg * x1[(long)G - (long)A] * x2[(long)G - (long)A] +
               freqt * x1[(long)T - (long)A] * x2[(long)T - (long)A];
      aa = prod12 - prod3;
      bb = prod3 - prod1*prod2;
      cc = prod1 * prod2;
      term[i][j] = zz * aa + z1 * bb + cc;
      slopeterm[i][j] = zzs * aa + z1s * bb;
      curveterm[i][j] = zzc * aa + z1c * bb;
    }
    sumterm = 0.0;
    for (j = 0; j < rcategs; j++)
      sumterm += probcat[j] * term[i][j];
    lterm = log(sumterm) + p->underflows[i] + q->underflows[i];
    for (j = 0; j < rcategs; j++) {
      term[i][j] = term[i][j] / sumterm;
      slopeterm[i][j] = slopeterm[i][j] / sumterm;
      curveterm[i][j] = curveterm[i][j] / sumterm; 
    }
    sum += (double)aliasweight[i] * lterm;
  }
  for (i = 0; i < rcategs; i++) {
    thelike[i] = 1.0;
    theslope[i] = 0.0;
    thecurve[i] = 0.0;
  }
  for (i = 0; i < sites; i++) {
    sumc = 0.0;
    sumcs = 0.0;
    sumcc = 0.0;
    for (k = 0; k < rcategs; k++) {
      sumc += probcat[k] * thelike[k];
      sumcs += probcat[k] * theslope[k];
      sumcc += probcat[k] * thecurve[k];
    }
    sumc *= lambda;
    sumcs *= lambda;
    sumcc *= lambda;
    if ((ally[i] > 0) && (location[ally[i]-1] > 0)) {
      lai = location[ally[i] - 1];
      memcpy(clai, term[lai - 1], rcategs*sizeof(double));
      memcpy(cslai, slopeterm[lai - 1], rcategs*sizeof(double));
      memcpy(cclai, curveterm[lai - 1], rcategs*sizeof(double));
      if (weight[i] > 1) {
        for (j = 0; j < rcategs; j++) {
          if (clai[j] > 0.0)
            clai[j] = exp(weight[i]*log(clai[j]));
          else clai[j] = 0.0;
          if (cslai[j] > 0.0)
            cslai[j] = exp(weight[i]*log(cslai[j]));
          else cslai[j] = 0.0;
          if (cclai[j] > 0.0)
            cclai[j] = exp(weight[i]*log(cclai[j])); 
          else cclai[j] = 0.0;
      }
    }
      for (j = 0; j < rcategs; j++) {
        nulike[j] = ((1.0 - lambda) * thelike[j] + sumc) * clai[j];
        nuslope[j] = ((1.0 - lambda) * theslope[j] + sumcs) * clai[j]
                   + ((1.0 - lambda) * thelike[j] + sumc) * cslai[j];
        nucurve[j] = ((1.0 - lambda) * thecurve[j] + sumcc) * clai[j]
             + 2.0 * ((1.0 - lambda) * theslope[j] + sumcs) * cslai[j]
                   + ((1.0 - lambda) * thelike[j] + sumc) * cclai[j];
      }
    } else {
      for (j = 0; j < rcategs; j++) {
        nulike[j] = ((1.0 - lambda) * thelike[j] + sumc);
        nuslope[j] = ((1.0 - lambda) * theslope[j] + sumcs);
        nucurve[j] = ((1.0 - lambda) * thecurve[j] + sumcc);
      }
    }
    memcpy(thelike, nulike, rcategs*sizeof(double));
    memcpy(theslope, nuslope, rcategs*sizeof(double));
    memcpy(thecurve, nucurve, rcategs*sizeof(double));
  }
  sum2 = 0.0;
  slope2 = 0.0;
  curve2 = 0.0;
  for (i = 0; i < rcategs; i++) {
    sum2 += probcat[i] * thelike[i];
    slope2 += probcat[i] * theslope[i];
    curve2 += probcat[i] * thecurve[i];
  }
  sum += log(sum2);
  (*like) = sum;
  (*slope) = slope2 / sum2;

  /* Expressed in terms of *slope to prevent overflow */
  (*curve) = curve2 / sum2 - *slope * *slope;
} /* slopecurv */

int 
slopecurv_erate(long endsite_erate, tree_erate *tree, node_erate *p,  
		valrec_erate ***table_erate, 
		double *like, double *slope, double *curve, double tol)
{
  /* compute log likelihood, slope and curvature at node p */
  long i, j, k, lai;
  double sum, sumc, sumterm, lterm, sumcs, sumcc, sum2, slope2, curve2;
  double lz;
  double prod1, prod2, prod12, prod3;
  double aa, bb, cc, dd, ee, ff;
  double eigen1, eigen2, eigen3;
  double xi, xv, xl, xm;
  double insratio, delratio;
  double pb, pbm;
  double z1,  z1zz,  i1,  i1zz,  j1,  g1,  k1,  k1m;
  double z1s, z1zzs, i1s, i1zzs, j1s, g1s, k1s, k1ms;
  double z1c, z1zzc, i1c, i1zzc, j1c, g1c, k1c, k1mc;
  double term1,  term2,  term3,  term4,  term5,  term6,  term7,  term8;
  double term1s, term2s, term3s, term4s, term5s, term6s, term8s;
  double term1c, term2c, term3c, term4c, term5c, term6c, term8c;
  contribarr thelike, nulike, nuslope, nucurve,
    theslope, thecurve, clai, cslai, cclai;
  double *tterm, *sslope, *ccurve;
  node_erate *q;
  sitelike_erate x1, x2;
  boolean tree_allgapleaves = FALSE;
  boolean p_allgapleaves = FALSE;
  boolean q_allgapleaves = FALSE;
  boolean addterm;

  if (p->tip) { return eslOK; } /* this should not happen when doing rearrangements, unless they are 
				 * global rearrangements */
  
  q = p->back;
  sum = 0.0;
  lz = -p->v;

  for (i = 0; i < rcategs; i++)
    for (j = 0; j < categs; j++) {
      table_erate[i][j]->orig_zz = 
	exp(table_erate[i][j]->ratxi * lz);
     table_erate[i][j]->z1       = 
	exp(table_erate[i][j]->ratxv * lz) * 
	exp(table_erate[i][j]->ratxm * lz);
      table_erate[i][j]->z1zz    = 
	table_erate[i][j]->z1 * 
	table_erate[i][j]->orig_zz;
      
      /* set e^{-(xl+xm)t} */
      table_erate[i][j]->i1 = 
	exp(table_erate[i][j]->ratxl * lz) * exp(table_erate[i][j]->ratxm * lz);
            
      /* set xi_t */
      if (table_erate[i][j]->ratxl < 1.0*tol) 
	table_erate[i][j]->k1 = 0.0;
      else
	table_erate[i][j]->k1 =  
	  ( table_erate[i][j]->ratxl/(table_erate[i][j]->ratxl + table_erate[i][j]->ratxm) ) * 
	  ( 1.0-table_erate[i][j]->i1 );
      
      /* set gammat_t */
      if (table_erate[i][j]->ratxm < 1.0*tol) 
	table_erate[i][j]->g1 = 0.0;
      else
	table_erate[i][j]->g1 =  
	  ( table_erate[i][j]->ratxm/(table_erate[i][j]->ratxl + table_erate[i][j]->ratxm) ) * 
	  (1.0-table_erate[i][j]->i1);
    }
                                                        
  /* Go column by column */
  /* calculate also the extra columns:
   *
   * endsite   = allgaps and 
   * endsite+1 = immortal link 
   */
  for (i = 0; i < endsite_erate; i++) { /* calculate also the extra column i = endsite */

    if( i < endsite) k = category[alias[i]-1] - 1;
    else             k = 0;

    for (j = 0; j < rcategs; j++) {
      
      if (i <= endsite) {
	tree_allgapleaves = tree_colisallgaps_erate(i, j, p, FALSE);
	p_allgapleaves    = node_colisallgaps_erate(i, j, p, FALSE);
	q_allgapleaves    = node_colisallgaps_erate(i, j, q, FALSE);
	/* paranoia */
	if (p_allgapleaves == FALSE && tree_allgapleaves == TRUE)
	  esl_fatal("evaluate_erate(): node p %d not compatible with whole tree\n", p->index);
	if (q_allgapleaves == FALSE && tree_allgapleaves == TRUE)
	  esl_fatal("evaluate_erate(): node q %d not compatible with whole tree\n", q->index);
	if (i == endsite) { 
	  if (p_allgapleaves == FALSE    ||
	      q_allgapleaves == FALSE    ||
	      tree_allgapleaves == FALSE   )
	    esl_fatal("evaluate_erate(): i=endsite should be an allgaps column\n");
	}
	if (i < endsite && freqo == 0) {
	  if (tree_allgapleaves == TRUE ||
	      p_allgapleaves    == TRUE ||
	      q_allgapleaves    == TRUE   )
	    esl_fatal("evaluate_erate(): this is an alignment without gaps!\n");
	}
      }

      xi  = table_erate[j][k]->ratxi;
      xv  = table_erate[j][k]->ratxv;
      xl  = table_erate[j][k]->ratxl;
      xm  = table_erate[j][k]->ratxm;
      pb  = table_erate[j][k]->gprior;
      pbm = 1.0 - pb;
 
      /* for these coefficients we need to take
       * the limit xm to zero before the limit xl to zero
       */
      if (xm < tol) delratio = 0.0;
      else          delratio = xm/(xl + xm);
      if (xl < tol) insratio = 1.0;
      else          insratio = xl/(xl + xm);
      
      eigen1 = -(xv + xm);
      eigen2 = -(xi + xv + xm);
      eigen3 = -(xl + xm);

      z1    = table_erate[j][k]->z1;
      z1zz  = table_erate[j][k]->z1zz;
      i1    = table_erate[j][k]->i1;
      i1zz  = i1 * delratio;
      j1    = 1.0 - i1;
      k1    = table_erate[j][k]->k1;
      g1    = table_erate[j][k]->g1;
      k1m   = 1.0 - k1;

       /* the parts that change with t and their derivatives */
      k1s    = xl * i1;
      k1ms  = -k1s;
      z1s    = eigen1 * z1;
      z1zzs  = eigen2 * z1zz;
      i1s    = eigen3 * i1;
      i1zzs  = -xm * i1;
      j1s    = -i1s;
      g1s    = -i1zzs;
      
      k1c   = eigen3 * k1s;
      k1mc  = -k1c;
      z1c   = eigen1 * z1s;
      z1zzc = eigen2 * z1zzs;
      i1c   = eigen3 * i1s;
      i1zzc = eigen3 * i1zzs;
      j1c   = -i1c;
      g1c   = -i1zzc;

      term1 = pb  * k1m * insratio;
      term2 = pb  * k1m * z1;
      term3 = pb  * k1m * z1zz;
      term4 = pb  * k1m * i1zz;
      term5 = pb  * k1m * g1;
      term6 =       k1;
      term7 =       1.0;
      term8 = pbm * k1m;  /* for the immortal column */
      if (isnan(term1) || isnan(term2) || isnan(term3) || isnan(term4) || 
	  isnan(term5) || isnan(term6) || isnan(term8))
	esl_fatal("slopecurv_erate(): bad terms. %f %f %f %f %f %f %\n", 
		  term1, term2, term3, term4, term5, term6, term8);

      /* first derivatives */
      term1s = pb  * k1ms * insratio;
      term2s = pb  * k1ms * z1   + pb * k1m * z1s;
      term3s = pb  * k1ms * z1zz + pb * k1m * z1zzs;
      term4s = pb  * k1ms * i1zz + pb * k1m * i1zzs;
      term5s = pb  * k1ms * g1   + pb * k1m * g1s;
      term6s =       k1s;
      term8s = pbm * k1ms;
       if (isnan(term1s) || isnan(term2s) || isnan(term3s) || isnan(term4s) || 
	   isnan(term5s) || isnan(term6s) || isnan(term8s))
	esl_fatal("slopecurv_erate(): bad first derivatives. %f %f %f %f %f %f %f\n",
		  term1s, term2s, term3s, term4s, term5s, term6s, term8s);

      /* second derivatives */
      term1c = pb  * k1mc * insratio;
      term2c = pb  * k1mc * z1   + 2.0 * pb * k1ms * z1s   + pb * k1m * z1c;
      term3c = pb  * k1mc * z1zz + 2.0 * pb * k1ms * z1zzs + pb * k1m * z1zzc;
      term4c = pb  * k1mc * i1zz + 2.0 * pb * k1ms * i1zzs + pb * k1m * i1zzc;
      term5c = pb  * k1mc * g1   + 2.0 * pb * k1ms * g1s   + pb * k1m * g1c;
      term6c =       k1c;
      term8c = pbm * k1mc;
      if (isnan(term1c) || isnan(term2c) || isnan(term3c) || isnan(term4c) || 
	  isnan(term5c) || isnan(term6c) || isnan(term8c))
	esl_fatal("slopecurv_erate(): bad second derivatives.\n");

      /* the parts that do not change with t */
      /* allocate for the likelihoods up to node p and q */
      memcpy(x1, p->xe[i][j], sizeof(sitelike_erate));
      memcpy(x2, q->xe[i][j], sizeof(sitelike_erate));

      prod1 = 
	+ freqa * x1[0] 
	+ freqc * x1[(long)C - (long)A] 
	+ freqg * x1[(long)G - (long)A] 
	+ freqt * x1[(long)T - (long)A];
      prod2 = 
	+ freqa * x2[0] 
 	+ freqc * x2[(long)C - (long)A] 
	+ freqg * x2[(long)G - (long)A] 
	+ freqt * x2[(long)T - (long)A];
      prod3 = 
	+ (x1[0] * freqa + x1[(long)G - (long)A] * freqg) *
	  (x2[0] * freqar + x2[(long)G - (long)A] * freqgr) 
	+ (x1[(long)C - (long)A] * freqc + x1[(long)T - (long)A] * freqt) *
          (x2[(long)C - (long)A] * freqcy + x2[(long)T - (long)A] * freqty);
      prod12 = 
	+ freqa * x1[0] * x2[0] 
	+ freqc * x1[(long)C - (long)A] * x2[(long)C - (long)A] 
	+ freqg * x1[(long)G - (long)A] * x2[(long)G - (long)A] 
	+ freqt * x1[(long)T - (long)A] * x2[(long)T - (long)A];

      aa = prod1 * prod2;
      bb = prod3 - aa;
      cc = prod12 - prod3;
      dd = prod1 * x2[(long)O - (long)A];
      ee = prod2 * x1[(long)O - (long)A];
      ff = x1[(long)O - (long)A] * x2[(long)O - (long)A];

      /* the actual values */
      if ( i <= endsite) {/* the observed columns plus the allgaps column*/
	term[i][j] = 
	  + term1  * aa 
	  + term2  * bb 
	  + term3  * cc 
	  + term4  * aa;
	slopeterm[i][j] = 
	  + term1s * aa 
	  + term2s * bb 
	  + term3s * cc 
	  + term4s * aa;
	curveterm[i][j] = 
	  + term1c * aa 
	  + term2c * bb 
	  + term3c * cc 
	  + term4c * aa;
 
	if (q_allgapleaves == TRUE) {
	  term[i][j] += 
	    + term5 * prod1
	    + term7 * x1[(long)O - (long)A];
	  slopeterm[i][j] += 
	    + term5s * prod1;
	  curveterm[i][j] += 
	    + term5c * prod1;
	}

	if (p_allgapleaves == TRUE) {
	term[i][j] += 
	  + term6 * prod2
	  + term7 * x2[(long)O - (long)A];
	slopeterm[i][j] += 
	  + term6s * prod2;
	curveterm[i][j] += 
	  + term6c * prod2;
	}
     }
      else if (i == endsite+1) {	/* the immortal column */
	term[i][j]      = term8  * ff;
	slopeterm[i][j] = term8s * ff;
	curveterm[i][j] = term8c * ff;
      }
    }
    sumterm = 0.0;
    for (j = 0; j < rcategs; j++)
      sumterm += probcat[j] * term[i][j];
    
    /* the score in log format 
     *
     * E_{total} = \prod_{col} E_{col} * E_{immortal} * 1/(1-E_{allgaps})
     *
     * log[ E_{total}] = 
     *                      \sum_{col} log[ E_{col}] 
     *                     + log[ E_{immortal} ] 
     *                     - log[ 1-E_{allgaps} ]
     */
    if (0) {
      printf("\nslopecurv_erate: endsite=%ld rcateg %ld i=%ld sumterm %f term %f\n", endsite, rcategs, i, sumterm, term[i][0]);
      printf("p allgaps?%d q %d tree %d\n", p_allgapleaves, q_allgapleaves, tree_allgapleaves);
      printf("term1 %f term2 %f term3 %f term4 %f term5 %f term6 %f term7 %f term8 %f\n", 
	     term1, term2, term3, term4, term5, term6, term7, term8);
      printf("ins %f del %f time %f\n", xl, xm, lz);
    }
    if (sumterm < 0.0) {
      if (sumterm > -tol) sumterm = 0.0;
      else esl_fatal("slopecurv_erate(): negative probability at i=%ld %f\n", i, sumterm);
    }
    if (sumterm > 1.0) 
      esl_fatal("slopecurv_erate(): Larger than one probability at i=%ld (endsite=%ld) %f\n", i, endsite, sumterm);
    if      (i <  endsite) lterm =  log(sumterm) + p->underflows[i] + q->underflows[i];
    else if (i == endsite) lterm = -log(1.0-sumterm);
    else                   lterm =  log(sumterm);
    if (0) {
      printf("\nslopecurv_erate: lterm %f\n", lterm);
    }
    if (isnan(lterm)) esl_fatal("slopecurv_erate() endsite %d lterm nan error.", i);
    
    if (sumterm > 0.) {
      for (j = 0; j < rcategs; j++) {
	term[i][j]      = term[i][j] / sumterm;
	slopeterm[i][j] = slopeterm[i][j] / sumterm;
	curveterm[i][j] = curveterm[i][j] / sumterm; 
      }
    }
    
    addterm = FALSE;
      if ((i < endsite && tree_allgapleaves == FALSE) || i >= endsite) 
	addterm = TRUE;

    if (addterm == TRUE) {
      if (lterm <= -HUGE_VAL) {
	sum = -HUGE_VAL;
      }
      else {
	if (i < endsite) sum += (double)aliasweight[i] * lterm;
	else             sum += lterm;
      }
      if (isnan(sum)) esl_fatal("slopecurv_erate(): infinite sum i=%d lterm %f sum %f\n", i, lterm, sum); 
    }
    
  } /* for all non-identical columns */
  
  /* Calculate sum2, slope2, and curve2 */
 
  /* add the allgap column */
  /* initialize */
  for (k = 0; k < rcategs; k++) {
    thelike[k] = 1.0;
    theslope[k] = 0.0;
    thecurve[k] = 0.0;
  }
  sumc  = 0.0;
  sumcs = 0.0;
  sumcc = 0.0;
  for (k = 0; k < rcategs; k++) {
    sumc  += probcat[k] * thelike[k];
    sumcs += probcat[k] * theslope[k];
    sumcc += probcat[k] * thecurve[k];
  }
  sumc  *= lambda;
  sumcs *= lambda;
  sumcc *= lambda;
  tterm  = (double *) Malloc(rcategs * sizeof(double));
  sslope = (double *) Malloc(rcategs * sizeof(double));
  ccurve = (double *) Malloc(rcategs * sizeof(double));
  for (k = 0; k < rcategs; k++) {
    tterm[k]  = 1.0/(1.0 - term[endsite][k]);
    sslope[k] = slopeterm[endsite][k] * tterm[k] * tterm[k];
    ccurve[k] = 2.0*tterm[k]*sslope[k]*slopeterm[endsite][k] 
      + curveterm[endsite][k] * tterm[k] * tterm[k];
  }
  memcpy(clai,  tterm, rcategs*sizeof(double));
  memcpy(cslai, sslope,  rcategs*sizeof(double));
  memcpy(cclai, ccurve, rcategs*sizeof(double));
  free(tterm);
  free(sslope);
  free(ccurve);
  for (j = 0; j < rcategs; j++) {
    nulike[j]  = ((1.0 - lambda) * thelike[j]  + sumc)  * clai[j];
    nuslope[j] = ((1.0 - lambda) * theslope[j] + sumcs) * clai[j]
      + ((1.0 - lambda) * thelike[j] + sumc) * cslai[j];
    nucurve[j] = ((1.0 - lambda) * thecurve[j] + sumcc) * clai[j]
      + 2.0 * ((1.0 - lambda) * theslope[j] + sumcs) * cslai[j]
      + ((1.0 - lambda) * thelike[j] + sumc) * cclai[j];
  }
  memcpy(thelike,  nulike,  rcategs*sizeof(double));
  memcpy(theslope, nuslope, rcategs*sizeof(double));
  memcpy(thecurve, nucurve, rcategs*sizeof(double));
  
   /* add the immortal-link column */
  /* initialize */
  for (k = 0; k < rcategs; k++) {
    thelike[k] = 1.0;
    theslope[k] = 0.0;
    thecurve[k] = 0.0;
  }
  sumc  = 0.0;
  sumcs = 0.0;
  sumcc = 0.0;
  for (k = 0; k < rcategs; k++) {
    sumc  += probcat[k] * thelike[k];
    sumcs += probcat[k] * theslope[k];
    sumcc += probcat[k] * thecurve[k];
  }
  sumc  *= lambda;
  sumcs *= lambda;
  sumcc *= lambda;
  memcpy(clai,  term[endsite+1],      rcategs*sizeof(double));
  memcpy(cslai, slopeterm[endsite+1], rcategs*sizeof(double));
  memcpy(cclai, curveterm[endsite+1], rcategs*sizeof(double));
  for (j = 0; j < rcategs; j++) {
    nulike[j]  = ((1.0 - lambda) * thelike[j]  + sumc)  * clai[j];
    nuslope[j] = ((1.0 - lambda) * theslope[j] + sumcs) * clai[j]
      + ((1.0 - lambda) * thelike[j] + sumc) * cslai[j];
    nucurve[j] = ((1.0 - lambda) * thecurve[j] + sumcc) * clai[j]
      + 2.0 * ((1.0 - lambda) * theslope[j] + sumcs) * cslai[j]
      + ((1.0 - lambda) * thelike[j] + sumc) * cclai[j];
  }
  memcpy(thelike,  nulike,  rcategs*sizeof(double));
  memcpy(theslope, nuslope, rcategs*sizeof(double));
  memcpy(thecurve, nucurve, rcategs*sizeof(double));

  /* continue with each column */
 /* initialize */
  for (k = 0; k < rcategs; k++) {
    thelike[k] = 1.0;
    theslope[k] = 0.0;
    thecurve[k] = 0.0;
  }

  for (i = 0; i < sites; i++) {
    sumc = 0.0;
    sumcs = 0.0;
    sumcc = 0.0;
    for (k = 0; k < rcategs; k++) {
      sumc  += probcat[k] * thelike[k];
      sumcs += probcat[k] * theslope[k];
      sumcc += probcat[k] * thecurve[k];
    }
    sumc *= lambda;
    sumcs *= lambda;
    sumcc *= lambda;
    if ((ally[i] > 0) && (location[ally[i]-1] > 0)) {
      lai = location[ally[i] - 1];
      memcpy(clai,  term[lai - 1],      rcategs*sizeof(double));
      memcpy(cslai, slopeterm[lai - 1], rcategs*sizeof(double));
      memcpy(cclai, curveterm[lai - 1], rcategs*sizeof(double));
      if (weight[i] > 1) {
        for (j = 0; j < rcategs; j++) {
          if (clai[j] > 0.0)
            clai[j] = exp(weight[i]*log(clai[j]));
          else clai[j] = 0.0;
          if (cslai[j] > 0.0)
            cslai[j] = exp(weight[i]*log(cslai[j]));
          else cslai[j] = 0.0;
          if (cclai[j] > 0.0)
            cclai[j] = exp(weight[i]*log(cclai[j])); 
          else cclai[j] = 0.0;
	}
      }
      for (j = 0; j < rcategs; j++) {
        nulike[j]  = ((1.0 - lambda) * thelike[j]  + sumc)  * clai[j];
        nuslope[j] = ((1.0 - lambda) * theslope[j] + sumcs) * clai[j]
	  + ((1.0 - lambda) * thelike[j] + sumc) * cslai[j];
        nucurve[j] = ((1.0 - lambda) * thecurve[j] + sumcc) * clai[j]
	  + 2.0 * ((1.0 - lambda) * theslope[j] + sumcs) * cslai[j]
	  + ((1.0 - lambda) * thelike[j] + sumc) * cclai[j];
      }
    } else {
      for (j = 0; j < rcategs; j++) {
        nulike[j]  = ((1.0 - lambda) * thelike[j]  + sumc);
        nuslope[j] = ((1.0 - lambda) * theslope[j] + sumcs);
        nucurve[j] = ((1.0 - lambda) * thecurve[j] + sumcc);
      }
    }

    memcpy(thelike,  nulike,  rcategs*sizeof(double));
    memcpy(theslope, nuslope, rcategs*sizeof(double));
    memcpy(thecurve, nucurve, rcategs*sizeof(double));

  }
  sum2   = 0.0;
  slope2 = 0.0;
  curve2 = 0.0;
  for (i = 0; i < rcategs; i++) {
    sum2   += probcat[i] * thelike[i];
    slope2 += probcat[i] * theslope[i];
    curve2 += probcat[i] * thecurve[i];
  }
  if (sum2 < 0.0 && sum2 > -tol) sum2 = 0.0;
  sum += log(sum2);
  if (isnan(sum)) esl_fatal("slopecurv_erate(): bad sum.\n"); 

  /* the likelihood */
  (*like) = sum;

  /* the slope */
  (*slope) = slope2; 
  if (sum2 > 0.) (*slope) /= sum2;

  /* the curvature */
 (*curve) = curve2;
 if (sum2 > 0.) (*curve) /= sum2;
 (*curve) -= (*slope) * (*slope);
  
 if(0) {
   printf("\ntol %f l %f m %f i1 %f k1 %f k1s %f k1m %f\n", tol, xl, xm, i1, k1, k1s, k1m);
    printf("aa %f bb %f cc %f dd %f ee %f ff %f\n", aa, bb, cc, dd, ee, ff);
    printf("TERM 1 %f 2 %f 3 %f 4 %f 5 %f 6 %f 7 %f 8 %f \n", term1, term2, term3, term4, term5, term6, term7, term8);
    printf("STERM 1 %f 2 %f 3 %f 4 %f 5 %f 6 %f 8 %f  \n", term1s, term2s, term3s, term4s, term5s, term6s, term8s);
    printf("CTERM 1 %f 2 %f 3 %f 4 %f 5 %f 6 %f 8 %f  \n", term1c, term2c, term3c, term4c, term5c, term6c, term8c);
    printf("lz %f sum %f sum2 %f like %f slope %f slope2 %f curve2 %f curve %f slope/curve2 %f slope/curve %f \n", 
	   -lz, sum, sum2, *like, *slope, slope2, curve2, *curve, (*slope)*sum2/fabs(curve2), (*slope)/fabs((*curve)));
  }
  if(0) {
    printf("tol %f l %f m %f \n", tol, xl, xm);
    printf("TERM 1 %f 2 %f 3 %f 4 %f 5 %f 6 %f 7 %f 8 %f\n", term1, term2, term3, term4, term5, term6, term7, term8);
    printf("STERM 1 %f 2 %f 3 %f 4 %f 5 %f 6 %f 8 %f\n", term1s, term2s, term3s, term4s, term5s, term6s, term8s);
    printf("CTERM 1 %f 2 %f 3 %f 4 %f 5 %f 6 %f 8 %f\n", term1c, term2c, term3c, term4c, term5c, term6c, term8c);
    esl_fatal("lz %f sum %f sum2 %f like %f slope %f slope2 %f curve2 %f curve %f slope/curve2 %f slope/curve %f \n", 
	   -lz, sum, sum2, *like, *slope, slope2, curve2, *curve, (*slope)*sum2/fabs(curve2), (*slope)/fabs((*curve)));
  }
    
  /* paranoia */
  if (isnan((*like)))  esl_fatal("slopecurv_erate(): bad like\n");  
  if (isnan((*slope))) esl_fatal("slopecurv_erate(): bad slope\n");  
  if (isnan((*curve))) esl_fatal("slopecurv_erate(): bad curvature\n");  

  return eslOK;
  
} /* slopecurv_erate */


void makenewv(node *p)
{
  /* Newton-Raphson algorithm improvement of a branch length */
  long it, ite;
  double y, yold=0, yorig, like, slope, curve, oldlike=0;
  boolean done, firsttime, better;
  node *q;

  q = p->back;
  y = p->v;
  yorig = y;
  done = false;
  firsttime = true;
  it = 1;
  ite = 0;
  while ((it < iterations) && (ite < 20) && (!done)) {
    slopecurv (p, y, &like, &slope, &curve);

    better = false;
    if (firsttime) {    /* if no older value of y to compare with */
      yold = y;
      oldlike = like;
      firsttime = false;
      better = true;
    } else {
      if (like > oldlike) {    /* update the value of yold if it was better */
        yold = y;
        oldlike = like;
        better = true;
        it++;
      }
    }
    if (better) {
      y = y + slope/fabs(curve);   /* Newton-Raphson, forced uphill-wards */
      if (y < epsilon)
        y = epsilon;
    } else {
      if (fabs(y - yold) < epsilon)
        ite = 20;
      y = (y + 19*yold) / 20.0;    /* retract 95% of way back */
    }
    ite++;
    done = fabs(y-yold) < 0.1*epsilon;
  }
  smoothed = (fabs(yold-yorig) < epsilon) && (yorig > 1000.0*epsilon);
  p->v = yold;   /* the last one that had better likelihood */
  q->v = yold;
  curtree.likelihood = oldlike;
}  /*  */

void
makenewv_erate(long endsite_erate, tree_erate *tree, node_erate *p, valrec_erate ***table_erate, double tol, int verbose)
{
  /* Newton-Raphson algorithm improvement of a branch length */
  long it, ite;
  double y, yold=0, yorig, like, slope, curve, oldlike=0;
  boolean done, firsttime, better;
  node_erate *q;
  
  if (0) printf("makenew_erate p %ld-%ld\n", p->index, p->back->index);

  /* initialize */
  q = p->back;
  y = p->v;
  yorig = y;
  done = false;
  firsttime = true;
  it = 1;
  ite = 0;
  done = false;

  while ((it < iterations) && (ite < 20) && (!done)) {
    slopecurv_erate(endsite_erate, tree, (p->tip)?q:p, table_erate, &like, &slope, &curve, tol);

    if (0) printf("\nlz %f ln %f slope %.10f curve %.10f ratio %f\n", p->v, like, slope, curve, slope/fabs(curve));

    better = false;
    if (firsttime) {    /* if no older value of y to compare with */
      yold = y;
      oldlike = like;
      firsttime = false;
      better = true;
    } else {
      if (like > oldlike) {    /* update the value of yold if it was better */
        yold = y;
        oldlike = like;
        better = true;
        it++;
      }
    }
    if (better) {

      if (fabs(slope) < tol*tol*tol && fabs(curve) < tol*tol*tol) ite = 20;
      if (fabs(curve) > 0.0) y = y + slope/fabs(curve); /* Newton-Raphson, forced uphill-wards */

      if (y < epsilon)
        y = epsilon;
    } else {
      if (fabs(y - yold) < epsilon)
        ite = 20;
      y = (y + 19*yold) / 20.0;    /* retract 95% of way back */
    }
    ite++;

    p->v = y;   
    q->v = y;

    done = fabs(y-yold) < epsilon;
  }
  smoothed = (fabs(yold-yorig) < tol) && (yorig > 1000.0*epsilon);
  p->v = yold;   /* the last one that had better likelihood */
  q->v = yold;
  if (isnan(yold)) esl_fatal("makenewv_erate() error.");

  if(0) printf("    end makenew_erate p %ld q %ld > yold %f %f like %f slope %f curve %f\n", 
	       p->index, q->index, p->v, q->v, like, slope,curve);

  tree->likelihood = oldlike;

}  /* makenewv_erate */



void update(node *p)
{
  long num_sibs, i;
  node* sib_ptr;

  if (!p->tip && !p->initialized)
    nuview(p);
  if (!p->back->tip && !p->back->initialized)
    nuview(p->back);
  if ((!usertree) || (usertree && !lngths) || p->iter) {
    makenewv(p);
    if ( smoothit ) {
      inittrav(p);
      inittrav(p->back);
    } else {
      if (inserting) {
        num_sibs = count_sibs (p);
        sib_ptr  = p;
        for (i=0; i < num_sibs; i++) {
          sib_ptr              = sib_ptr->next;
          sib_ptr->initialized = false;
        }
      }
    } 
  }
}  /* update */
 

void update_erate(tree_erate *tree, node_erate *p, 
		  valrec_erate ***table_erate, long endsite_erate,
		  boolean optimize, double tol, int verbose)
{
  long num_sibs, i;
  node_erate* sib_ptr;

  if (!p->tip && !p->initialized)
    nuview_erate(p, table_erate, endsite_erate, tol);
  if (!p->back->tip && !p->back->initialized)
    nuview_erate(p->back, table_erate, endsite_erate, tol);

  if ((!usertree) || (usertree && !lngths) || p->iter) {

    /* use Newton-Raphson to update branch lengths */
    if (optimize) makenewv_erate(endsite_erate, tree, p, table_erate, tol, verbose); 
   
    if ( smoothit ) {
      inittrav_erate(p);
     } else {
      if (inserting) {
        num_sibs = count_sibs_erate (p);
        sib_ptr  = p;
        for (i=0; i < num_sibs; i++) {
          sib_ptr              = sib_ptr->next;
          sib_ptr->initialized = false;
        }
      }
    } 
  }

}  /* update_erate */


void smooth(node *p)
{
  long i, num_sibs;
  node *sib_ptr;
  
  smoothed = false;
  update (p);
  if (p->tip)
    return;

  num_sibs = count_sibs (p);
  sib_ptr  = p;
  
  for (i=0; i < num_sibs; i++) {
    sib_ptr = sib_ptr->next;
    
    if (polishing || (smoothit && !smoothed)) {
      smooth(sib_ptr->back);
    }
  }
}  /* smooth */

void smooth_erate(tree_erate *tree, node_erate *p, 
		  valrec_erate ***table_erate, long endsite_erate,
		  boolean optimize, double tol, int verbose)
{
  long i, num_sibs;
  node_erate *sib_ptr;
  
  smoothed = false;
  update_erate(tree, p, table_erate, endsite_erate, optimize, tol, verbose);
  if (p->tip)
    return;

  num_sibs = count_sibs_erate (p);
  sib_ptr  = p;
  
  for (i=0; i < num_sibs; i++) {
    sib_ptr = sib_ptr->next;
    
    if (polishing || (smoothit && !smoothed)) {
      smooth_erate(tree, sib_ptr->back, table_erate, endsite_erate, optimize, tol, verbose);
    }
  }
}  /* smooth_erate */


void insert_(node *p, node *q, boolean dooinit)
{
  /* Insert q near p */
  /* assumes bifurcation (OK) */
  long i;
  node *r;

  r = p->next->next;
  hookup(r, q->back);
  hookup(p->next, q);
  q->v = 0.5 * q->v;
  q->back->v = q->v;
  r->v = q->v;
  r->back->v = r->v;
  p->initialized = false;
  if (dooinit) {
    inittrav(p);
    inittrav(p->back);
  }
  i = 1;
  inserting = true;
  while (i <= smoothings) {
    smooth (p);
    if ( !p->tip ) {
      smooth(p->next);
      smooth(p->next->next);
    }
    i++;
  }
  inserting = false;
}  /* insert_ */


void insert_erate_(tree_erate *tree, valrec_erate ***table_erate, 
		   node_erate *p, node_erate *q, long endsite_erate,
		   boolean dooinit, boolean optimize, double tol, int verbose)
{
  /* Insert q near p */
  /* assumes bifurcation (OK) */
  long i;
  node_erate *r;


  r = p->next->next;
  hookup_erate(r, q->back);
  hookup_erate(p->next, q);
  q->v = 0.5 * q->v;
  q->back->v = q->v;
  r->v = q->v;
  r->back->v = r->v;
  p->initialized = false;
  if (dooinit) {
    inittrav_erate(p);
   }
  i = 1;
  inserting = true;

  while (i <= smoothings) {
    smooth_erate (tree, p, table_erate, endsite_erate, optimize, tol, verbose);
    if ( !p->tip ) {
      smooth_erate(tree, p->next, table_erate, endsite_erate, optimize, tol, verbose);
      smooth_erate(tree, p->next->next, table_erate, endsite_erate, optimize, tol, verbose);
    }
    i++;
  }
  inserting = false;
}  /* insert_erate_ */


void dnaml_re_move(node **p, node **q)
{
  /* remove p and record in q where it was */
  long i;

  /* assumes bifurcation (OK) */
  *q = (*p)->next->back;
  hookup(*q, (*p)->next->next->back);
  (*p)->next->back = NULL;
  (*p)->next->next->back = NULL;
  (*q)->v += (*q)->back->v;
  (*q)->back->v = (*q)->v;
  if ( smoothit ) {
    inittrav((*q));
    inittrav((*q)->back);
  }
  if ( smoothit ) {
    for ( i = 0 ; i < smoothings ; i++ ) {
      smooth(*q);
      smooth((*q)->back);
    }
  }
  else smooth(*q);
}  /* dnaml_re_move */

void dnaml_re_move_erate(tree_erate *tree, valrec_erate ***table_erate, 
			 node_erate **p, node_erate **q, long endsite_erate,
			 boolean optimize, double tol, int verbose)
{
  /* remove p and record in q where it was */
  long i;

  /* assumes bifurcation (OK) */
  *q = (*p)->next->back;
  hookup_erate(*q, (*p)->next->next->back);
  (*p)->next->back = NULL;
  (*p)->next->next->back = NULL;
  (*q)->v += (*q)->back->v;
  (*q)->back->v = (*q)->v;
  if ( smoothit ) {
    inittrav_erate((*q));
  }
  if ( smoothit ) {
    for ( i = 0 ; i < smoothings ; i++ ) {
      smooth_erate(tree, *q, table_erate, endsite_erate, optimize, tol, verbose);
      smooth_erate(tree, (*q)->back, table_erate, endsite_erate, optimize, tol, verbose);
    }
  }
  else smooth_erate(tree, *q, table_erate,endsite_erate,  optimize, tol, verbose);
}  /* dnaml_re_move_erate */



void buildnewtip(long m, tree *tr)
{
  node *p;

  p = tr->nodep[nextsp + spp - 3];
  hookup(tr->nodep[m - 1], p);
  p->v = initialv;
  p->back->v = initialv;
}  /* buildnewtip */

void buildnewtip_erate(long sp, long m, tree_erate *tr)
{
  node_erate *p;

  p = tr->nodep[sp + spp - 3];
  hookup_erate(tr->nodep[m - 1], p);
  p->v = initialv;
  p->back->v = initialv;
}  /* buildnewtip_erate */


void buildsimpletree(tree *tr)
{
  hookup(tr->nodep[enterorder[0] - 1], tr->nodep[enterorder[1] - 1]);
  tr->nodep[enterorder[0] - 1]->v = 0.1;
  tr->nodep[enterorder[0] - 1]->back->v = 0.1;
  tr->nodep[enterorder[1] - 1]->v = 0.1;
  tr->nodep[enterorder[1] - 1]->back->v = 0.1;  buildnewtip(enterorder[2], tr);
  insert_(tr->nodep[enterorder[2] - 1]->back,
          tr->nodep[enterorder[0] - 1], false);
}  /* buildsimpletree2 */

void buildsimpletree_erate(tree_erate *tr, 
			   valrec_erate ***table_erate, long endsite_erate,
			   boolean optimize, double tol, int verbose)
{
  hookup_erate(tr->nodep[enterorder[0] - 1], tr->nodep[enterorder[1] - 1]);
  tr->nodep[enterorder[0] - 1]->v = 0.1;
  tr->nodep[enterorder[0] - 1]->back->v = 0.1;
  tr->nodep[enterorder[1] - 1]->v = 0.1;
  tr->nodep[enterorder[1] - 1]->back->v = 0.1;
  buildnewtip_erate(3, enterorder[2], tr);
  insert_erate_(tr, table_erate, tr->nodep[enterorder[2] - 1]->back,
		tr->nodep[enterorder[0] - 1], endsite_erate, false, optimize, tol, verbose);
}  /* buildsimpletree_erate */



void addtraverse(node *p, node *q, boolean contin)
{
  /* try adding p at q, proceed recursively through tree */
  long i, num_sibs;
  double like, vsave = 0;
  node *qback = NULL, *sib_ptr;

  if (!smoothit) {
    vsave = q->v;
    qback = q->back;

  }
  insert_(p, q, smoothit);
  like = evaluate(p, false);
  if (like > bestyet || bestyet == UNDEFINED) {
    bestyet = like;
    if (smoothit) {
      dnamlcopy(&curtree, &bestree, nonodes2, rcategs);
      addwhere = q;
    }
    else
      qwhere = q;
    succeeded = true;
  }
  if (smoothit)
    dnamlcopy(&priortree, &curtree, nonodes2, rcategs);
  else {
    hookup (q, qback);
    q->v = vsave;
    q->back->v = vsave;
    curtree.likelihood = bestyet;
  }
  if (!q->tip && contin) {
    num_sibs = count_sibs (q);
    if (q == curtree.start)
      num_sibs++;
    sib_ptr  = q;
    for (i=0; i < num_sibs; i++) {
      addtraverse(p, sib_ptr->next->back, contin);
      sib_ptr = sib_ptr->next;
    }
  }

}  /* addtraverse */

void 
addtraverse_erate(long endsite_erate, tree_erate *tree, tree_erate *besttree, tree_erate *priortree, valrec_erate ***table_erate, 
		  node_erate *p, node_erate *q, boolean contin, boolean optimize, double tol, int verbose)
{
  /* try adding p at q, proceed recursively through tree */
  tree_erate tmptree;
  long i, num_sibs;
  double like, vsave = 0;
  node_erate *qback = NULL, *sib_ptr;

  /* paranoia */
  if (p->index == q->index       || p->back->index == q->index       || 
      p->index == q->back->index || p->back->index == q->back->index   )
    esl_fatal("addtraverse_erate(): bad node to insert %d-%d into %d-%d\n",
	      p->index, p->back->index, q->index, q->back->index);

  /* allocate tmptree*/
  alloctree_erate(&tmptree, nonodes2, 0);
  setuptree2_erate(&tmptree);
  allocxe(endsite_erate, nonodes2, rcategs, tmptree.nodep, 0);
  
  /* copy tree into tmptree */
   dnamlcopy_erate(tree, &tmptree, nonodes2, rcategs, endsite_erate);

  if (!smoothit) {
    vsave = q->v;
    qback = q->back;
  }
  
  insert_erate_(tree, table_erate, p, q, endsite_erate, smoothit, optimize, tol, verbose);
  like = evaluate_erate(tree, p, table_erate, endsite_erate, false, tol, verbose);
   if (like - bestyet > tol*tol || bestyet == UNDEFINED) {
    bestyet = like;
    if (smoothit) {
       dnamlcopy_erate(tree, besttree, nonodes2, rcategs, endsite_erate);
      addwhere_erate = q;
    }
    else
      qwhere_erate = q;
    succeeded = true;
  }

  if (smoothit){
     dnamlcopy_erate(priortree, tree, nonodes2, rcategs, endsite_erate);
  }
  else {
    hookup_erate (q, qback);
    q->v = vsave;
    q->back->v = vsave;
    tree->likelihood = bestyet;
  }
  if (!q->tip && contin) {
    num_sibs = count_sibs_erate (q);
    if (q == tree->start)
      num_sibs++;
    sib_ptr  = q;
    for (i=0; i < num_sibs; i++) {
      addtraverse_erate(endsite_erate, tree, besttree, priortree, table_erate, p, sib_ptr->next->back, contin, optimize, tol, verbose);
      
      sib_ptr = sib_ptr->next;
    }
  }

 /* clean up */
  freexe(endsite_erate, nonodes2, tmptree.nodep);
  freetree2_erate(tmptree, nonodes2, spp);

}  /* addtraverse_erate */


void freelrsaves()
{
  long i,j;
  for ( i = 0 ; i < NLRSAVES ; i++ ) {
    for (j = 0; j < oldendsite; j++)
      free(lrsaves[i]->x[j]);
    free(lrsaves[i]->x);
    free(lrsaves[i]->underflows);
    free(lrsaves[i]);
  }
  free(lrsaves);
}

void freelrsaves_erate(long endsite_erate)
{
  long i,j;
  for ( i = 0 ; i < NLRSAVES ; i++ ) {
    for (j = 0; j < endsite_erate; j++)
      free(lrsaves_erate[i]->xe[j]);
    free(lrsaves_erate[i]->xe);
    free(lrsaves_erate[i]->underflows);
    free(lrsaves_erate[i]);
  }
  free(lrsaves_erate);
}


void resetlrsaves() 
{
  freelrsaves();
  alloclrsaves();
}
void resetlrsaves_erate(long oldendsite_erate, long endsite_erate) 
{
  freelrsaves_erate(oldendsite_erate);
  alloclrsaves_erate(endsite_erate);
}



void alloclrsaves()
{
  long i,j;

  lrsaves = Malloc(NLRSAVES * sizeof(node*));
  for ( i = 0 ; i < NLRSAVES ; i++ ) {
    lrsaves[i] = Malloc(sizeof(node));
    lrsaves[i]->x = (phenotype)Malloc(endsite*sizeof(ratelike));
    lrsaves[i]->underflows = Malloc(endsite * sizeof (double));
    for (j = 0; j < endsite; j++)
      lrsaves[i]->x[j]  = (ratelike)Malloc(rcategs*sizeof(sitelike));
  }
} /* alloclrsaves */

void alloclrsaves_erate(long endsite_erate)
{
  long i,j;

  lrsaves_erate = Malloc(NLRSAVES * sizeof(node_erate*));
  for ( i = 0 ; i < NLRSAVES ; i++ ) {
    lrsaves_erate[i] = Malloc(sizeof(node_erate));
    lrsaves_erate[i]->xe = (phenotype_erate)Malloc(endsite_erate*sizeof(ratelike_erate));
    lrsaves_erate[i]->underflows = Malloc(endsite_erate * sizeof (double));
    for (j = 0; j < endsite_erate; j++)
      lrsaves_erate[i]->xe[j]  = (ratelike_erate)Malloc(rcategs*sizeof(sitelike_erate));
  }
} /* alloclrsaves_erate */


void globrearrange() 
{
  /* does global rearrangements */
  tree globtree;
  tree oldtree;
  int i,j,k,l,num_sibs,num_sibs2;
  node *where,*sib_ptr,*sib_ptr2;
  double oldbestyet = curtree.likelihood;
  int success = false;
 
  alloctree(&globtree.nodep,nonodes2,0);
  alloctree(&oldtree.nodep,nonodes2,0);
  setuptree2(&globtree);
  setuptree2(&oldtree);
  allocx(nonodes2, rcategs, globtree.nodep, 0);
  allocx(nonodes2, rcategs, oldtree.nodep, 0);
  dnamlcopy(&curtree,&globtree,nonodes2,rcategs);
  dnamlcopy(&curtree,&oldtree,nonodes2,rcategs);
  bestyet = curtree.likelihood;
  for ( i = spp ; i < nonodes2 ; i++ ) {
    num_sibs = count_sibs(curtree.nodep[i]);
    sib_ptr  = curtree.nodep[i];
    if ( (i - spp) % (( nonodes2 / 72 ) + 1 ) == 0 )
      putchar('.');
    fflush(stdout);
    for ( j = 0 ; j <= num_sibs ; j++ ) {
      dnaml_re_move(&sib_ptr,&where);
      dnamlcopy(&curtree,&priortree,nonodes2,rcategs);
      qwhere = where;
      
      if (where->tip) {
        dnamlcopy(&oldtree,&curtree,nonodes2,rcategs);
        dnamlcopy(&oldtree,&bestree,nonodes2,rcategs);
        sib_ptr=sib_ptr->next;
        continue;
      }
      else num_sibs2 = count_sibs(where);
      sib_ptr2 = where;
      for ( k = 0 ; k < num_sibs2 ; k++ ) {
        addwhere = NULL;
        addtraverse(sib_ptr,sib_ptr2->back,true);
        if ( !smoothit ) {
          if (succeeded && qwhere != where && qwhere != where->back) {
            insert_(sib_ptr,qwhere,true);
            smoothit = true;
            for (l = 1; l<=smoothings; l++) {
              smooth (where);
              smooth (where->back);
            }
            smoothit = false;
            success = true;
            dnamlcopy(&curtree,&globtree,nonodes2,rcategs);
            dnamlcopy(&priortree,&curtree,nonodes2,rcategs);
          }
        }
        else if ( addwhere && where != addwhere && where->back != addwhere
              && bestyet > globtree.likelihood) {
            dnamlcopy(&bestree,&globtree,nonodes2,rcategs);
            success = true;
        }
        sib_ptr2 = sib_ptr2->next;
      } 
      dnamlcopy(&oldtree,&curtree,nonodes2,rcategs);
      dnamlcopy(&oldtree,&bestree,nonodes2,rcategs);
      sib_ptr = sib_ptr->next;
    }
  }
  dnamlcopy(&globtree,&curtree,nonodes2,rcategs);
  dnamlcopy(&globtree,&bestree,nonodes2,rcategs);
  if (success && globtree.likelihood > oldbestyet)  {
    succeeded = true;
  }
  else  {
    succeeded = false;
  }
  bestyet = globtree.likelihood;
  freex(nonodes2, globtree.nodep);
  freex(nonodes2, oldtree.nodep);
  freetree2(globtree.nodep, nonodes2);
  freetree2(oldtree.nodep, nonodes2);
} /* globrearrange */

void globrearrange_erate(long endsite_erate, tree_erate *tree, 
			 tree_erate *besttree, tree_erate *priortree, 
			 valrec_erate ***table_erate, boolean optimize, double tol, int verbose) 
{
  /* does global rearrangements */
  tree_erate globtree;
  tree_erate oldtree;
  int i,j,k,l,num_sibs,num_sibs2;
  node_erate *where,*sib_ptr,*sib_ptr2;
  double oldbestyet = tree->likelihood;
  int success = false;
 
  alloctree_erate(&globtree,nonodes2,0);
  alloctree_erate(&oldtree,nonodes2,0);
  setuptree2_erate(&globtree);
  setuptree2_erate(&oldtree);
  allocxe(endsite_erate, nonodes2, rcategs, globtree.nodep, 0);
  allocxe(endsite_erate, nonodes2, rcategs, oldtree.nodep, 0);
  dnamlcopy_erate(tree,&globtree,nonodes2,rcategs, endsite_erate);
  dnamlcopy_erate(tree,&oldtree,nonodes2,rcategs, endsite_erate);
  bestyet = tree->likelihood;
  for ( i = spp ; i < nonodes2 ; i++ ) {
    num_sibs = count_sibs_erate(tree->nodep[i]);
    sib_ptr  = tree->nodep[i];
    if ( (i - spp) % (( nonodes2 / 72 ) + 1 ) == 0 )
      putchar('.');
    fflush(stdout);
    for ( j = 0 ; j <= num_sibs ; j++ ) {
      dnaml_re_move_erate(tree, table_erate, &sib_ptr, &where, endsite_erate, optimize, tol, verbose);
      dnamlcopy_erate(tree, priortree, nonodes2, rcategs, endsite_erate);
      qwhere_erate = where;
      
      if (where->tip) {
        dnamlcopy_erate(&oldtree, tree, nonodes2, rcategs, endsite_erate);
        dnamlcopy_erate(&oldtree, besttree, nonodes2, rcategs, endsite_erate);
        sib_ptr = sib_ptr->next;
        continue;
      }
      else num_sibs2 = count_sibs_erate(where);
      sib_ptr2 = where;
      for ( k = 0 ; k < num_sibs2 ; k++ ) {
        addwhere = NULL;
        addtraverse_erate(endsite_erate, tree, besttree, priortree, table_erate, sib_ptr, sib_ptr2->back, true, optimize, tol, verbose);
        if ( !smoothit ) {
          if (succeeded && qwhere_erate != where && qwhere_erate != where->back) {
           insert_erate_(tree, table_erate, sib_ptr, qwhere_erate, endsite_erate, true, optimize, tol, verbose);
            smoothit = true;
            for (l = 1; l <= smoothings; l++) {
              smooth_erate(tree, where, table_erate, endsite_erate, optimize, tol, verbose);
              smooth_erate(tree, where->back, table_erate, endsite_erate, optimize, tol, verbose);
            }
            smoothit = false;
            success = true;
            dnamlcopy_erate(tree, &globtree, nonodes2, rcategs, endsite_erate);
            dnamlcopy_erate(priortree, tree, nonodes2, rcategs, endsite_erate);
          }
        }
        else if ( addwhere_erate && where != addwhere_erate && where->back != addwhere_erate
              && bestyet > globtree.likelihood) {
            dnamlcopy_erate(besttree, &globtree, nonodes2, rcategs, endsite_erate);
            success = true;
        }
        sib_ptr2 = sib_ptr2->next;
      } 
      dnamlcopy_erate(&oldtree,tree,nonodes2,rcategs, endsite_erate);
      dnamlcopy_erate(&oldtree,besttree,nonodes2,rcategs, endsite_erate);
      sib_ptr = sib_ptr->next;
    }
  }
  dnamlcopy_erate(&globtree,tree,nonodes2,rcategs, endsite_erate);
  dnamlcopy_erate(&globtree,besttree,nonodes2,rcategs, endsite_erate);
  if (success && globtree.likelihood > oldbestyet)  {
    succeeded = true;
  }
  else  {
    succeeded = false;
  }
  bestyet = globtree.likelihood;
  freexe(endsite_erate, nonodes2, globtree.nodep);
  freexe(endsite_erate, nonodes2, oldtree.nodep);
  freetree2_erate(globtree, nonodes2, spp);
  freetree2_erate(oldtree, nonodes2, spp);
} /* globrearrange_erate */


void rearrange(node *p, node *pp)
{
  /* rearranges the tree locally moving pp around near p */
  /* assumes bifurcation (OK) */
  long i, num_sibs;
  node *q, *r, *sib_ptr;
  node *rnb, *rnnb;

  if (!p->tip && !p->back->tip) {
    curtree.likelihood = bestyet;
    if (p->back->next != pp)
      r = p->back->next;
    else
      r = p->back->next->next;
    /* assumes bifurcation, that's ok */
    if (!smoothit) {
      rnb = r->next->back;
      rnnb = r->next->next->back;
      copynode(r,lrsaves[0],rcategs);
      copynode(r->next,lrsaves[1],rcategs);
      copynode(r->next->next,lrsaves[2],rcategs);
      copynode(p->next,lrsaves[3],rcategs);
      copynode(p->next->next,lrsaves[4],rcategs);
    }
    else
      dnamlcopy(&curtree, &bestree, nonodes2, rcategs);
    dnaml_re_move(&r, &q);
    nuview(p->next);
    nuview(p->next->next);
    if (smoothit)
      dnamlcopy(&curtree, &priortree, nonodes2, rcategs);
    else
      qwhere = q;
    num_sibs = count_sibs (p);
    sib_ptr  = p;
    for (i=0; i < num_sibs; i++) {
      sib_ptr = sib_ptr->next;
      addtraverse(r, sib_ptr->back, false);
    }
    if (smoothit)
      dnamlcopy(&bestree, &curtree, nonodes2, rcategs);
    else {
      if (qwhere == q) {
        hookup(rnb,r->next);
        hookup(rnnb,r->next->next);
        copynode(lrsaves[0],r,rcategs);
        copynode(lrsaves[1],r->next,rcategs);
        copynode(lrsaves[2],r->next->next,rcategs);
        copynode(lrsaves[3],p->next,rcategs);
        copynode(lrsaves[4],p->next->next,rcategs);
        rnb->v = r->next->v;
        rnnb->v = r->next->next->v;
        r->back->v = r->v;
        curtree.likelihood = bestyet;
      }
      else {
        insert_(r, qwhere, true);
        smoothit = true;
        for (i = 1; i<=smoothings; i++) {
          smooth (r);
          smooth (r->back);
        }
        smoothit = false;
      }
    }
  }
  if (!p->tip) {
    num_sibs = count_sibs (p);
    if (p == curtree.start)
      num_sibs++;
    sib_ptr  = p;
    for (i=0; i < num_sibs; i++) {
      sib_ptr = sib_ptr->next;
      rearrange(sib_ptr->back, p);
    }
  }
}  /* rearrange */

void rearrange_erate(long endsite_erate, tree_erate *tree, tree_erate *besttree, tree_erate *priortree, 
		     valrec_erate ***table_erate, node_erate *p, node_erate *pp, 
		     boolean optimize, double tol, int verbose)
{
  /* rearranges the tree locally moving pp around near p */
  /* assumes bifurcation (OK) */
  long i, num_sibs;
  node_erate *q, *r, *sib_ptr;
  node_erate *rnb, *rnnb;

  if (!p->tip && !p->back->tip) {

    tree->likelihood = bestyet;
    if (p->back->next != pp)
      r = p->back->next;
    else
      r = p->back->next->next;

    /* assumes bifurcation, that's ok */
    if (!smoothit) {
      rnb  = r->next->back;
      rnnb = r->next->next->back;
      copynode_erate(r,            lrsaves_erate[0],rcategs);
      copynode_erate(r->next,      lrsaves_erate[1],rcategs);
      copynode_erate(r->next->next,lrsaves_erate[2],rcategs);
      copynode_erate(p->next,      lrsaves_erate[3],rcategs);
      copynode_erate(p->next->next,lrsaves_erate[4],rcategs);
    }
    else
      dnamlcopy_erate(tree, besttree, nonodes2, rcategs, endsite_erate);

     dnaml_re_move_erate(tree, table_erate, &r, &q, endsite_erate, optimize, tol, verbose);

    nuview_erate(p->next->next, table_erate, endsite_erate, tol);

    if (smoothit)
      dnamlcopy_erate(tree, priortree, nonodes2, rcategs, endsite_erate);
    else
      qwhere_erate = q;

    num_sibs = count_sibs_erate (p);
    sib_ptr  = p;
    for (i=0; i < num_sibs; i++) {
      sib_ptr = sib_ptr->next;
     addtraverse_erate(endsite_erate, tree, besttree, priortree, table_erate, r, sib_ptr->back, false, optimize, tol, verbose);
    }

    if (smoothit)
      dnamlcopy_erate(besttree, tree, nonodes2, rcategs, endsite_erate);
    else {
      if (qwhere_erate == q) {
        hookup_erate(rnb,r->next);
        hookup_erate(rnnb,r->next->next);
        copynode_erate(lrsaves_erate[0],r,rcategs);
        copynode_erate(lrsaves_erate[1],r->next,rcategs);
        copynode_erate(lrsaves_erate[2],r->next->next,rcategs);
        copynode_erate(lrsaves_erate[3],p->next,rcategs);
        copynode_erate(lrsaves_erate[4],p->next->next,rcategs);
        rnb->v = r->next->v;
        rnnb->v = r->next->next->v;
        r->back->v = r->v;
        tree->likelihood = bestyet;	
     }
      else {
        smoothit = true;
        insert_erate_(tree, table_erate, r, qwhere_erate, endsite_erate, true, optimize, tol, verbose);
       for (i = 1; i<=smoothings; i++) { 
          smooth_erate (tree, r, table_erate, endsite_erate, optimize, tol, verbose);
          smooth_erate (tree, r->back, table_erate, endsite_erate, optimize, tol, verbose);
        }
        smoothit = false;
      }
    }
  }

  if (!p->tip) {

    num_sibs = count_sibs_erate (p);
    if (p == tree->start)
      num_sibs++;
    sib_ptr  = p;
    for (i=0; i < num_sibs; i++) {
      sib_ptr = sib_ptr->next;
      rearrange_erate(endsite_erate, tree, besttree, priortree, table_erate, sib_ptr->back, p, optimize, tol, verbose);
    }
  }

}  /* rearrange_erate */


void initdnamlnode(node **p, node **grbg, node *q, long len, long nodei,
		   long *ntips, long *parens, initops whichinit,
		   pointarray treenode, pointarray nodep, Char *str, 
		   Char *ch, FILE *intree)
{
  /* initializes a node */
  boolean minusread;
  double valyew, divisor;

  switch (whichinit) {
  case bottom:
    gnu(grbg, p);
    (*p)->index = nodei;
    (*p)->tip = false;
    malloc_pheno((*p), endsite, rcategs);
    nodep[(*p)->index - 1] = (*p);
    break;
  case nonbottom:
    gnu(grbg, p);
    malloc_pheno(*p, endsite, rcategs);
    (*p)->index = nodei;
    break;
  case tip:
    match_names_to_data (str, nodep, p, spp);
    break;
  case iter:
    (*p)->initialized = false;
    (*p)->v = initialv;
    (*p)->iter = true;
    if ((*p)->back != NULL){
      (*p)->back->iter = true;
      (*p)->back->v = initialv;  
      (*p)->back->initialized = false;
    }
    break;
  case length:
    processlength(&valyew, &divisor, ch, &minusread, intree, parens);
    (*p)->v = valyew / divisor / fracchange;
    (*p)->iter = false;
    if ((*p)->back != NULL) {
      (*p)->back->v = (*p)->v;
      (*p)->back->iter = false;
    }
    break;
  case hsnolength:
    haslengths = false;
    break;
  default:        /* cases hslength, treewt, unittrwt */
    break;        /* should never occur                                */
  }
} /* initdnamlnode */

void initdnamlnode_erate(node_erate **p, node_erate **grbg, node_erate *q, long len, long nodei,
			 long *ntips, long *parens, initops whichinit,
			 pointarray_erate treenode, pointarray_erate nodep, Char *str, 
			 Char *ch, FILE *intree, double ratfracchange, long endsite_erate)
{
  /* initializes a node */
  boolean minusread;
  double valyew, divisor;

  switch (whichinit) {
  case bottom:
    gnu_erate(grbg, p);
    (*p)->index = nodei;
    (*p)->tip = false;
    malloc_pheno_erate((*p), endsite_erate, rcategs);
    nodep[(*p)->index - 1] = (*p);
    break;
  case nonbottom:
    gnu_erate(grbg, p);
    malloc_pheno_erate(*p, endsite_erate, rcategs);
    (*p)->index = nodei;
    break;
  case tip:
    match_names_to_data_erate (str, nodep, p, spp);
    break;
  case iter:
    (*p)->initialized = false;
    (*p)->v = initialv;
    (*p)->iter = true;
    if ((*p)->back != NULL){
      (*p)->back->iter = true;
      (*p)->back->v = initialv;  
      (*p)->back->initialized = false;
    }
    break;
  case length:
    processlength(&valyew, &divisor, ch, &minusread, intree, parens);
    (*p)->v = valyew / divisor / ratfracchange;
    (*p)->iter = false;
    if ((*p)->back != NULL) {
      (*p)->back->v = (*p)->v;
      (*p)->back->iter = false;
    }
    break;
  case hsnolength:
    haslengths = false;
    break;
  default:        /* cases hslength, treewt, unittrwt */
    break;        /* should never occur                                */
  }
} /* initdnamlnode_erate */


void dnaml_coordinates(node *p, double lengthsum, long *tipy,
                        double *tipmax)
{
  /* establishes coordinates of nodes */
  node *q, *first, *last;
  double xx;

  if (p->tip) {
    p->xcoord = (long)(over * lengthsum + 0.5);
    p->ycoord = (*tipy);
    p->ymin = (*tipy);
    p->ymax = (*tipy);
    (*tipy) += down;
    if (lengthsum > (*tipmax))
      (*tipmax) = lengthsum;
    return;
  }
  q = p->next;
  do {
    xx = fracchange * q->v;
    if (xx > 100.0)
      xx = 100.0;
    dnaml_coordinates(q->back, lengthsum + xx, tipy,tipmax);
    q = q->next;
  } while ((p == curtree.start || p != q) &&
           (p != curtree.start || p->next != q));
  first = p->next->back;
  q = p;
  while (q->next != p)
    q = q->next;
  last = q->back;
  p->xcoord = (long)(over * lengthsum + 0.5);
  if (p == curtree.start)
    p->ycoord = p->next->next->back->ycoord;
  else
    p->ycoord = (first->ycoord + last->ycoord) / 2;
  p->ymin = first->ymin;
  p->ymax = last->ymax;
}  /* dnaml_coordinates */

void dnaml_coordinates_erate(tree_erate *tree, node_erate *p, double lengthsum, long *tipy,
			     double *tipmax, double ratfracchange)
{
  /* establishes coordinates of nodes */
  node_erate *q, *first, *last;
  double xx;

  if (p->tip) {
    p->xcoord = (long)(over * lengthsum + 0.5);
    p->ycoord = (*tipy);
    p->ymin = (*tipy);
    p->ymax = (*tipy);
    (*tipy) += down;
    if (lengthsum > (*tipmax))
      (*tipmax) = lengthsum;
    return;
  }
  q = p->next;
  do {
    xx = ratfracchange * q->v;
    if (xx > 100.0)
      xx = 100.0;
    dnaml_coordinates_erate(tree, q->back, lengthsum + xx, tipy, tipmax, ratfracchange);
    q = q->next;
  } while ((p == tree->start || p != q) &&
           (p != tree->start || p->next != q));
  first = p->next->back;
  q = p;
  while (q->next != p)
    q = q->next;
  last = q->back;
  p->xcoord = (long)(over * lengthsum + 0.5);
  if (p == tree->start)
    p->ycoord = p->next->next->back->ycoord;
  else
    p->ycoord = (first->ycoord + last->ycoord) / 2;
  p->ymin = first->ymin;
  p->ymax = last->ymax;
}  /* dnaml_coordinates_erate */


void dnaml_printree()
{
  /* prints out diagram of the tree2 */
  long tipy;
  double scale, tipmax;
  long i;

  if (!treeprint)
    return;
  putc('\n', outfile);
  tipy = 1;
  tipmax = 0.0;
  dnaml_coordinates(curtree.start, 0.0, &tipy, &tipmax);
  scale = 1.0 / (long)(tipmax + 1.000);
  for (i = 1; i <= (tipy - down); i++)
    drawline2(i, scale, curtree);
  putc('\n', outfile);
}  /* dnaml_printree */

void dnaml_printree_erate(tree_erate *tree, valrec_erate ***table_erate)
{
  /* prints out diagram of the tree2 */
  long tipy;
  double scale, tipmax;
  long i;
  double ratfracchange = 1.0;
  
  if (table_erate[0][0]->rat > 0.0) 
    ratfracchange = table_erate[0][0]->ratfracchange/table_erate[0][0]->rat;
  
  if (!treeprint)
    return;
  putc('\n', outfile);
  tipy = 1;
  tipmax = 0.0;
  dnaml_coordinates_erate(tree, tree->start, 0.0, &tipy, &tipmax, ratfracchange);
  scale = 1.0 / (long)(tipmax + 1.000);
  for (i = 1; i <= (tipy - down); i++) 
    drawline2_erate(i, scale, *tree);
  putc('\n', outfile);
}  /* dnaml_printree_erate */

void sigma(node *p, double *sumlr, double *s1, double *s2)
{
  /* compute standard deviation */
  double tt, aa, like, slope, curv;

  slopecurv (p, p->v, &like, &slope, &curv);
  tt = p->v;
  p->v = epsilon;
  p->back->v = epsilon;
  aa = evaluate(p, false);
  p->v = tt;
  p->back->v = tt;
  (*sumlr) = evaluate(p, false) - aa;
  if (curv < -epsilon) {
    (*s1) = p->v + (-slope - sqrt(slope * slope -  3.841 * curv)) / curv;
    (*s2) = p->v + (-slope + sqrt(slope * slope -  3.841 * curv)) / curv;
  }
  else {
    (*s1) = -1.0;
    (*s2) = -1.0;
  }
}  /* sigma */

void
sigma_erate(long endsite_erate, tree_erate *tree, valrec_erate ***table_erate, node_erate *p, 
	    double *sumlr, double *s1, double *s2, double tol)
{
  /* compute standard deviation */
  double tt, aa, like, slope, curv;
  int verbose = 0;

  slopecurv_erate(endsite_erate, tree, (p->tip)?p->back:p, table_erate, &like, &slope, &curv, tol);
  tt = p->v;
  p->v = epsilon;
  p->back->v = epsilon;
  aa = evaluate_erate(tree, p, table_erate, endsite_erate, false, tol, verbose);
  p->v = tt;
  p->back->v = tt;
  (*sumlr) = evaluate_erate(tree, p, table_erate, endsite_erate, false, tol, verbose) - aa;
  if (curv < -epsilon) {
    (*s1) = p->v + (-slope - sqrt(slope * slope -  3.841 * curv)) / curv;
    (*s2) = p->v + (-slope + sqrt(slope * slope -  3.841 * curv)) / curv;
  }
  else {
    (*s1) = -1.0;
    (*s2) = -1.0;
  }

}  /* sigma_erate */


void describe(node *p)
{
  /* print out information for one branch */
  long i, num_sibs;
  node *q, *sib_ptr;
  double sumlr, sigma1, sigma2;

  if (!p->tip && !p->initialized)
    nuview(p);
  if (!p->back->tip && !p->back->initialized)
    nuview(p->back);
  q = p->back;
  if (q->tip) {
    fprintf(outfile, " ");
    for (i = 0; i < nmlngth; i++)
      putc(nayme[q->index-1][i], outfile);
    fprintf(outfile, "    ");
  } else
    fprintf(outfile, "  %4ld          ", q->index - spp);
  if (p->tip) {
    for (i = 0; i < nmlngth; i++)
      putc(nayme[p->index-1][i], outfile);
  } else
    fprintf(outfile, "%4ld      ", p->index - spp);
  fprintf(outfile, "%15.5f", q->v * fracchange);
  if (!usertree || (usertree && !lngths) || p->iter) {
    sigma(q, &sumlr, &sigma1, &sigma2);
    if (sigma1 <= sigma2)
      fprintf(outfile, "     (     zero,    infinity)");
    else {
      fprintf(outfile, "     (");
      if (sigma2 <= 0.0)
        fprintf(outfile, "     zero");
      else
        fprintf(outfile, "%9.5f", sigma2 * fracchange);
      fprintf(outfile, ",%12.5f", sigma1 * fracchange);
      putc(')', outfile);
      }
    if (sumlr > 1.9205)
      fprintf(outfile, " *");
    if (sumlr > 2.995)
      putc('*', outfile);
    }
  putc('\n', outfile);
  if (!p->tip) {
    num_sibs = count_sibs (p);
    sib_ptr  = p;
    for (i=0; i < num_sibs; i++) {
      sib_ptr = sib_ptr->next;
      describe(sib_ptr->back);
    }
  }
}  /* describe */

void describe_erate(long endsite_erate, tree_erate *tree, valrec_erate ***table_erate, node_erate *p, double tol)
{
  /* print out information for one branch */
  long i, num_sibs;
  node_erate *q, *sib_ptr;
  double sumlr, sigma1, sigma2;
  double ratfracchange = 1.0;
  
  if (table_erate[0][0]->rat > 0.0) 
    ratfracchange = table_erate[0][0]->ratfracchange/table_erate[0][0]->rat;
  
  if (!p->tip && !p->initialized)
    nuview_erate(p, table_erate, endsite_erate, tol);
  if (!p->back->tip && !p->back->initialized)
    nuview_erate(p->back, table_erate, endsite_erate, tol);
  q = p->back;
  if (q->tip) {
    fprintf(outfile, " ");
    for (i = 0; i < nmlngth; i++)
      putc(nayme[q->index-1][i], outfile);
    fprintf(outfile, "    ");
  } else
    fprintf(outfile, "  %4ld          ", q->index - spp);
  if (p->tip) {
    for (i = 0; i < nmlngth; i++)
      putc(nayme[p->index-1][i], outfile);
  } else
    fprintf(outfile, "%4ld      ", p->index - spp);
  fprintf(outfile, "%15.5f", q->v * ratfracchange);
  if (!usertree || (usertree && !lngths) || p->iter) {
    sigma_erate(endsite_erate, tree, table_erate, q, &sumlr, &sigma1, &sigma2, tol);
    if (sigma1 <= sigma2)
      fprintf(outfile, "     (     zero,    infinity)");
    else {
      fprintf(outfile, "     (");
      if (sigma2 <= 0.0)
        fprintf(outfile, "     zero");
      else
        fprintf(outfile, "%9.5f", sigma2 * ratfracchange);
      fprintf(outfile, ",%12.5f", sigma1 * ratfracchange);
      putc(')', outfile);
      }
    if (sumlr > 1.9205)
      fprintf(outfile, " *");
    if (sumlr > 2.995)
      putc('*', outfile);
    }
  putc('\n', outfile);
  if (!p->tip) {
    num_sibs = count_sibs_erate (p);
    sib_ptr  = p;
    for (i=0; i < num_sibs; i++) {
      sib_ptr = sib_ptr->next;
      describe_erate(endsite_erate, tree, table_erate, sib_ptr->back, tol);
    }
  }
}  /* describe_erate */


void reconstr(node *p, long n)
{
  /* reconstruct and print out base at site n+1 at node p */
  long i, j, k, m, first, second, num_sibs;
  double f, sum, xx[4];
  node *q;

  if ((ally[n] == 0) || (location[ally[n]-1] == 0))
    putc('.', outfile);
  else {
    j = location[ally[n]-1] - 1;
    for (i = 0; i < 4; i++) {
      f = p->x[j][mx-1][i];
      num_sibs = count_sibs(p);
      q = p;
      for (k = 0; k < num_sibs; k++) {
        q = q->next;
        f *= q->x[j][mx-1][i];
      }
      f = sqrt(f);
      xx[i] = f;
    }
    xx[0] *= freqa;
    xx[1] *= freqc;
    xx[2] *= freqg;
    xx[3] *= freqt;
    sum = xx[0]+xx[1]+xx[2]+xx[3];
    for (i = 0; i < 4; i++)
      xx[i] /= sum;
    first = 0;
    for (i = 1; i < 4; i++)
      if (xx [i] > xx[first])
        first = i;
    if (first == 0)
      second = 1;
    else
      second = 0;
    for (i = 0; i < 4; i++)
      if ((i != first) && (xx[i] > xx[second]))
        second = i;
    m = 1 << first;
    if (xx[first] < 0.4999995)
      m = m + (1 << second);
    if (xx[first] > 0.95)
      putc(toupper(basechar[m - 1]), outfile);
    else
      putc(basechar[m - 1], outfile);
    if (rctgry && rcategs > 1)
      mx = mp[n][mx - 1];    
    else
      mx = 1;
  }
} /* reconstr */


void reconstr_erate(node_erate *p, long n)
{
  /* reconstruct and print out base at site n+1 at node p */
  long i, j, k, m, first, second, num_sibs;
  double f, sum, xx[5];
  node_erate *q;

  if ((ally[n] == 0) || (location[ally[n]-1] == 0))
    putc('.', outfile);
  else {
    j = location[ally[n]-1] - 1;
    for (i = 0; i < 5; i++) {
      f = p->xe[j][mx-1][i];
      num_sibs = count_sibs_erate(p);
      q = p;
      for (k = 0; k < num_sibs; k++) {
        q = q->next;
        f *= q->xe[j][mx-1][i];
      }
      f = sqrt(f);
      xx[i] = f;
    }
    xx[0] *= freqa;
    xx[1] *= freqc;
    xx[2] *= freqg;
    xx[3] *= freqt;
    xx[4] *= freqo;
    sum = xx[0]+xx[1]+xx[2]+xx[3]+xx[4];
    for (i = 0; i < 5; i++)
      xx[i] /= sum;
    first = 0;
    for (i = 1; i < 5; i++)
      if (xx [i] > xx[first])
        first = i;
    if (first == 0)
      second = 1;
    else
      second = 0;
    for (i = 0; i < 5; i++)
      if ((i != first) && (xx[i] > xx[second]))
        second = i;
    m = 1 << first;
    if (xx[first] < 0.4999995)
      m = m + (1 << second);
    if (xx[first] > 0.95)
      putc(toupper(basechar[m - 1]), outfile);
    else
      putc(basechar[m - 1], outfile);
    if (rctgry && rcategs > 1)
      mx = mp[n][mx - 1];    
    else
      mx = 1;
  }
} /* reconstr_erate */


void rectrav(node *p, long m, long n)
{
  /* print out segment of reconstructed sequence for one branch */
  long i;
  node *q;

  putc(' ', outfile);
  if (p->tip) {
    for (i = 0; i < nmlngth; i++)
      putc(nayme[p->index-1][i], outfile);
  } else
    fprintf(outfile, "%4ld      ", p->index - spp);
  fprintf(outfile, "  ");
  mx = mx0;
  for (i = m; i <= n; i++) {
    if ((i % 10 == 0) && (i != m))
      putc(' ', outfile);
    if (p->tip)
      putc(y[p->index-1][i], outfile);
    else
      reconstr(p, i);
  }
  putc('\n', outfile);
  if (!p->tip) {
    for ( q = p->next; q != p; q = q->next )
      rectrav(q->back, m, n);
  }
  mx1 = mx;
}  /* rectrav */


void rectrav_erate(node_erate *p, long m, long n)
{
  /* print out segment of reconstructed sequence for one branch */
  long i;
  node_erate *q;

  putc(' ', outfile);
  if (p->tip) {
    for (i = 0; i < nmlngth; i++)
      putc(nayme[p->index-1][i], outfile);
  } else
    fprintf(outfile, "%4ld      ", p->index - spp);
  fprintf(outfile, "  ");
  mx = mx0;
  for (i = m; i <= n; i++) {
    if ((i % 10 == 0) && (i != m))
      putc(' ', outfile);
    if (p->tip)
      putc(y[p->index-1][i], outfile);
    else
      reconstr_erate(p, i);
  }
  putc('\n', outfile);
  if (!p->tip) {
    for ( q = p->next; q != p; q = q->next )
      rectrav_erate(q->back, m, n);
  }
  mx1 = mx;
}  /* rectrav_erate */


void summarize()
{
  /* print out branch length information and node numbers */
  long i, j, mm, num_sibs;
  double mode, sum;
  double like[maxcategs], nulike[maxcategs];
  double **marginal;
  node   *sib_ptr;

  if (!treeprint)
    return;
  fprintf(outfile, "\nremember: ");
  if (outgropt)
    fprintf(outfile, "(although rooted by outgroup) ");
  fprintf(outfile, "this is an unrooted tree!\n\n");
  fprintf(outfile, "Ln Likelihood = %11.5f\n", curtree.likelihood);
  fprintf(outfile, "\n Between        And            Length");
  if (!(usertree && lngths && haslengths))
    fprintf(outfile, "      Approx. Confidence Limits");
  fprintf(outfile, "\n");
  fprintf(outfile, " -------        ---            ------");
  if (!(usertree && lngths && haslengths))
    fprintf(outfile, "      ------- ---------- ------");
  fprintf(outfile, "\n\n");
  for (i = spp; i < nonodes2; i++) {
    /* So this works with arbitrary multifurcations */
    if (curtree.nodep[i]) {
      num_sibs = count_sibs (curtree.nodep[i]);
      sib_ptr  = curtree.nodep[i];
      for (j = 0; j < num_sibs; j++) {
        sib_ptr->initialized = false;
        sib_ptr              = sib_ptr->next;
      }
    }
  }

  describe(curtree.start->back);

  /* So this works with arbitrary multifurcations */
  num_sibs = count_sibs (curtree.start);
  sib_ptr  = curtree.start;
  for (i=0; i < num_sibs; i++) {
    sib_ptr = sib_ptr->next;
    describe(sib_ptr->back);
  }

  fprintf(outfile, "\n");
  if (!(usertree && lngths && haslengths)) {
    fprintf(outfile, "     *  = significantly positive, P < 0.05\n");
    fprintf(outfile, "     ** = significantly positive, P < 0.01\n\n");
  }
  dummy = evaluate(curtree.start, false);
  if (rctgry && rcategs > 1) {
    for (i = 0; i < rcategs; i++)
      like[i] = 1.0;
    for (i = sites - 1; i >= 0; i--) {
      sum = 0.0;
      for (j = 0; j < rcategs; j++) {
        nulike[j] = (1.0 - lambda + lambda * probcat[j]) * like[j];
        mp[i][j] = j + 1;
        for (k = 1; k <= rcategs; k++) {
          if (k != j + 1) {
            if (lambda * probcat[k - 1] * like[k - 1] > nulike[j]) {
              nulike[j] = lambda * probcat[k - 1] * like[k - 1];
              mp[i][j] = k;
            }
          }
        }
        if ((ally[i] > 0) && (location[ally[i]-1] > 0))
          nulike[j] *= contribution[location[ally[i] - 1] - 1][j];
        sum += nulike[j];
      }
      for (j = 0; j < rcategs; j++)
        nulike[j] /= sum;
      memcpy(like, nulike, rcategs * sizeof(double));
    }
    mode = 0.0;
    mx = 1;
    for (i = 1; i <= rcategs; i++) {
      if (probcat[i - 1] * like[i - 1] > mode) {
        mx = i;
        mode = probcat[i - 1] * like[i - 1];
      }
    }
    mx0 = mx;
    fprintf(outfile,
 "Combination of categories that contributes the most to the likelihood:\n\n");
    for (i = 1; i <= nmlngth + 3; i++)
      putc(' ', outfile);
    for (i = 1; i <= sites; i++) {
      fprintf(outfile, "%ld", mx);
      if (i % 10 == 0)
        putc(' ', outfile);
      if (i % 60 == 0 && i != sites) {
        putc('\n', outfile);
        for (j = 1; j <= nmlngth + 3; j++)
          putc(' ', outfile);
      }
      mx = mp[i - 1][mx - 1];
    }
    fprintf(outfile, "\n\n");
    marginal = (double **) Malloc( sites*sizeof(double *));
    for (i = 0; i < sites; i++)
      marginal[i] = (double *) Malloc( rcategs*sizeof(double));
    for (i = 0; i < rcategs; i++)
      like[i] = 1.0;
    for (i = sites - 1; i >= 0; i--) {
      sum = 0.0;
      for (j = 0; j < rcategs; j++) {
        nulike[j] = (1.0 - lambda + lambda * probcat[j]) * like[j];
        for (k = 1; k <= rcategs; k++) {
          if (k != j + 1)
              nulike[j] += lambda * probcat[k - 1] * like[k - 1];
        }
        if ((ally[i] > 0) && (location[ally[i]-1] > 0))
          nulike[j] *= contribution[location[ally[i] - 1] - 1][j];
        sum += nulike[j];
      }
      for (j = 0; j < rcategs; j++) {
        nulike[j] /= sum;
        marginal[i][j] = nulike[j];
      }
      memcpy(like, nulike, rcategs * sizeof(double));
    }
    for (i = 0; i < rcategs; i++)
      like[i] = 1.0;
    for (i = 0; i < sites; i++) {
      sum = 0.0;
      for (j = 0; j < rcategs; j++) {
        nulike[j] = (1.0 - lambda + lambda * probcat[j]) * like[j];
        for (k = 1; k <= rcategs; k++) {
          if (k != j + 1)
              nulike[j] += lambda * probcat[k - 1] * like[k - 1];
        }
        marginal[i][j] *= like[j] * probcat[j];
        sum += nulike[j];
      }
      for (j = 0; j < rcategs; j++)
        nulike[j] /= sum;
      memcpy(like, nulike, rcategs * sizeof(double));
      sum = 0.0;
      for (j = 0; j < rcategs; j++)
        sum += marginal[i][j];
      for (j = 0; j < rcategs; j++)
        marginal[i][j] /= sum;
    }
    fprintf(outfile, "Most probable category at each site if > 0.95" 
        " probability (\".\" otherwise)\n\n");
    for (i = 1; i <= nmlngth + 3; i++)
      putc(' ', outfile);
    for (i = 0; i < sites; i++) {
      sum = 0.0;
      for (j = 0; j < rcategs; j++)
        if (marginal[i][j] > sum) {
          sum = marginal[i][j];
          mm = j;
        }
      if (sum >= 0.95)
        fprintf(outfile, "%ld", mm+1);
      else
        putc('.', outfile);
      if ((i+1) % 60 == 0) {
        if (i != 0) {
          putc('\n', outfile);
          for (j = 1; j <= nmlngth + 3; j++)
            putc(' ', outfile);
        }
      }
      else if ((i+1) % 10 == 0)
        putc(' ', outfile);
    }
    putc('\n', outfile);
    for (i = 0; i < sites; i++)
      free(marginal[i]);
    free(marginal);
  }
  putc('\n', outfile);
  if (hypstate) {
    fprintf(outfile, "Probable sequences at interior nodes:\n\n");
    fprintf(outfile, "  node       ");
    for (i = 0; (i < 13) && (i < ((sites + (sites-1)/10 - 39) / 2)); i++)
      putc(' ', outfile);
    fprintf(outfile, "Reconstructed sequence (caps if > 0.95)\n\n");
    if (!rctgry || (rcategs == 1))
      mx0 = 1;
    for (i = 0; i < sites; i += 60) {
      k = i + 59;
      if (k >= sites)
        k = sites - 1;
      rectrav(curtree.start, i, k);
      rectrav(curtree.start->back, i, k);
      putc('\n', outfile);
      mx0 = mx1;
    }
  }
}  /* summarize */


void summarize_erate(long endsite_erate, tree_erate *tree, valrec_erate ***table_erate, double tol)
{
  /* print out branch length information and node numbers */
  root_erate_data *root_data = tree->root_data;
  long i, j, mm, num_sibs;
  double mode, sum;
  double like[maxcategs], nulike[maxcategs];
  double **marginal;
  node_erate   *sib_ptr;
  double ratfracchange = 1.0;
  int verbose = 0;
  
  if (table_erate[0][0]->rat > 0.0) 
    ratfracchange = table_erate[0][0]->ratfracchange/table_erate[0][0]->rat;

  if (!treeprint)
    return;
  fprintf(outfile, "\nremember: (although rooted at middle point between leaves [");
  for (j = 0; j < nmlngth; j++)
    putc(nayme[root_data->taxal][j], outfile);
  for (j = 0; j < nmlngth; j++)
    putc(nayme[root_data->taxar][j], outfile);
  fprintf(outfile, "] distance = %f) ", root_data->taxa_maxdist*ratfracchange);
    if (outgropt)
    fprintf(outfile, "(although rooted by outgroup) ");
  fprintf(outfile, "this is an unrooted tree!\n");

  if (root_data->rootl>=spp) 
    fprintf(outfile, "root %ld (%f)\n", 
	    root_data->rootl-spp+1, root_data->distrootl*ratfracchange);
  else
    fprintf(outfile, "root %s (%f)\n", 
	    nayme[root_data->rootl], root_data->distrootl*ratfracchange);
 
  if (root_data->rootr>=spp) 
    fprintf(outfile, "root %ld (%f)\n\n", 
	    root_data->rootr-spp+1, root_data->distrootr*ratfracchange);
  else
    fprintf(outfile, "root %s (%f)\n\n", 
	    nayme[root_data->rootr], root_data->distrootr*ratfracchange);
  
  fprintf(outfile, "Ln Likelihood = %11.5f\n", tree->likelihood);
  fprintf(outfile, "\n Between        And            Length");
  if (!(usertree && lngths && haslengths))
    fprintf(outfile, "      Approx. Confidence Limits");
  fprintf(outfile, "\n");
  fprintf(outfile, " -------        ---            ------");
  if (!(usertree && lngths && haslengths))
    fprintf(outfile, "      ------- ---------- ------");
  fprintf(outfile, "\n\n");
  for (i = spp; i < nonodes2; i++) {
    /* So this works with arbitrary multifurcations */
    if (tree->nodep[i]) {
      num_sibs = count_sibs_erate (tree->nodep[i]);
      sib_ptr  = tree->nodep[i];
      for (j = 0; j < num_sibs; j++) {
        sib_ptr->initialized = false;
        sib_ptr              = sib_ptr->next;
      }
    }
  }

  /* calculate confidence margins for the tree branches */
  describe_erate(endsite_erate, tree, table_erate, tree->start->back, tol);
  /* So this works with arbitrary multifurcations */
  num_sibs = count_sibs_erate (tree->start);
  sib_ptr  = tree->start;
  for (i=0; i < num_sibs; i++) {
    sib_ptr = sib_ptr->next;
    describe_erate(endsite_erate, tree, table_erate, sib_ptr->back, tol);
  }

  fprintf(outfile, "\n");
  if (!(usertree && lngths && haslengths)) {
    fprintf(outfile, "     *  = significantly positive, P < 0.05\n");
    fprintf(outfile, "     ** = significantly positive, P < 0.01\n\n");
  }
  dummy = evaluate_rooted_erate(tree, table_erate, endsite_erate, false, tol, verbose);
  if (rctgry && rcategs > 1) {
    for (i = 0; i < rcategs; i++)
      like[i] = 1.0;
    for (i = sites - 1; i >= 0; i--) {
      sum = 0.0;
      for (j = 0; j < rcategs; j++) {
        nulike[j] = (1.0 - lambda + lambda * probcat[j]) * like[j];
        mp[i][j] = j + 1;
        for (k = 1; k <= rcategs; k++) {
          if (k != j + 1) {
            if (lambda * probcat[k - 1] * like[k - 1] > nulike[j]) {
              nulike[j] = lambda * probcat[k - 1] * like[k - 1];
              mp[i][j] = k;
            }
          }
        }
        if ((ally[i] > 0) && (location[ally[i]-1] > 0))
          nulike[j] *= contribution[location[ally[i] - 1] - 1][j];
        sum += nulike[j];
      }
      for (j = 0; j < rcategs; j++)
        nulike[j] /= sum;
      memcpy(like, nulike, rcategs * sizeof(double));
    }
    mode = 0.0;
    mx = 1;
    for (i = 1; i <= rcategs; i++) {
      if (probcat[i - 1] * like[i - 1] > mode) {
        mx = i;
        mode = probcat[i - 1] * like[i - 1];
      }
    }
    mx0 = mx;
    fprintf(outfile,
 "Combination of categories that contributes the most to the likelihood:\n\n");
    for (i = 1; i <= nmlngth + 3; i++)
      putc(' ', outfile);
    for (i = 1; i <= sites; i++) {
      fprintf(outfile, "%ld", mx);
      if (i % 10 == 0)
        putc(' ', outfile);
      if (i % 60 == 0 && i != sites) {
        putc('\n', outfile);
        for (j = 1; j <= nmlngth + 3; j++)
          putc(' ', outfile);
      }
      mx = mp[i - 1][mx - 1];
    }
    fprintf(outfile, "\n\n");
    marginal = (double **) Malloc( sites*sizeof(double *));
    for (i = 0; i < sites; i++)
      marginal[i] = (double *) Malloc( rcategs*sizeof(double));
    for (i = 0; i < rcategs; i++)
      like[i] = 1.0;
    for (i = sites - 1; i >= 0; i--) {
      sum = 0.0;
      for (j = 0; j < rcategs; j++) {
        nulike[j] = (1.0 - lambda + lambda * probcat[j]) * like[j];
        for (k = 1; k <= rcategs; k++) {
          if (k != j + 1)
              nulike[j] += lambda * probcat[k - 1] * like[k - 1];
        }
        if ((ally[i] > 0) && (location[ally[i]-1] > 0))
          nulike[j] *= contribution[location[ally[i] - 1] - 1][j];
        sum += nulike[j];
      }
      for (j = 0; j < rcategs; j++) {
        nulike[j] /= sum;
        marginal[i][j] = nulike[j];
      }
      memcpy(like, nulike, rcategs * sizeof(double));
    }
    for (i = 0; i < rcategs; i++)
      like[i] = 1.0;
    for (i = 0; i < sites; i++) {
      sum = 0.0;
      for (j = 0; j < rcategs; j++) {
        nulike[j] = (1.0 - lambda + lambda * probcat[j]) * like[j];
        for (k = 1; k <= rcategs; k++) {
          if (k != j + 1)
              nulike[j] += lambda * probcat[k - 1] * like[k - 1];
        }
        marginal[i][j] *= like[j] * probcat[j];
        sum += nulike[j];
      }
      for (j = 0; j < rcategs; j++)
        nulike[j] /= sum;
      memcpy(like, nulike, rcategs * sizeof(double));
      sum = 0.0;
      for (j = 0; j < rcategs; j++)
        sum += marginal[i][j];
      for (j = 0; j < rcategs; j++)
        marginal[i][j] /= sum;
    }
    fprintf(outfile, "Most probable category at each site if > 0.95" 
        " probability (\".\" otherwise)\n\n");
    for (i = 1; i <= nmlngth + 3; i++)
      putc(' ', outfile);
    for (i = 0; i < sites; i++) {
      sum = 0.0;
      for (j = 0; j < rcategs; j++)
        if (marginal[i][j] > sum) {
          sum = marginal[i][j];
          mm = j;
        }
      if (sum >= 0.95)
        fprintf(outfile, "%ld", mm+1);
      else
        putc('.', outfile);
      if ((i+1) % 60 == 0) {
        if (i != 0) {
          putc('\n', outfile);
          for (j = 1; j <= nmlngth + 3; j++)
            putc(' ', outfile);
        }
      }
      else if ((i+1) % 10 == 0)
        putc(' ', outfile);
    }
    putc('\n', outfile);
    for (i = 0; i < sites; i++)
      free(marginal[i]);
    free(marginal);
  }
  putc('\n', outfile);
  if (hypstate) {
    fprintf(outfile, "Probable sequences at interior nodes:\n\n");
    fprintf(outfile, "  node       ");
    for (i = 0; (i < 13) && (i < ((sites + (sites-1)/10 - 39) / 2)); i++)
      putc(' ', outfile);
    fprintf(outfile, "Reconstructed sequence (caps if > 0.95)\n\n");
    if (!rctgry || (rcategs == 1))
      mx0 = 1;
    for (i = 0; i < sites; i += 60) {
      k = i + 59;
      if (k >= sites)
        k = sites - 1;
      rectrav_erate(tree->start, i, k);
      rectrav_erate(tree->start->back, i, k);
      putc('\n', outfile);
      mx0 = mx1;
    }
  }
}  /* summarize_erate */


void dnaml_treeout(node *p)
{
  /* write out file with representation of final tree2 */
  long i, n, w;
  Char c;
  double x;
  node *q;
  boolean inloop;
  
  
  if (p->tip) {
    n = 0;
    for (i = 1; i <= nmlngth; i++) {
      if (nayme[p->index-1][i - 1] != ' ')
        n = i;
    }
    for (i = 0; i < n; i++) {
      c = nayme[p->index-1][i];
      if (c == ' ')
        c = '_';
      putc(c, outtree);
    }
    col += n;
  } else {
    putc('(', outtree);
    col++;

    inloop = false;
    q = p->next;
    do  {
      if (inloop) {
        putc(',', outtree);
        col++;
        if (col > 45) {
          putc('\n', outtree);
          col = 0;
        }
      }
      inloop = true;
      dnaml_treeout(q->back);
      q = q->next;
    } while ((p == curtree.start || p != q) &&
             (p != curtree.start || p->next != q));

    
    putc(')', outtree);
    col++;
  }
  x = p->v * fracchange;
  if (x > 0.0)
    w = (long)(0.43429448222 * log(x));
  else if (x == 0.0)
    w = 0;
  else
    w = (long)(0.43429448222 * log(-x)) + 1;
  if (w < 0)
    w = 0;
  if (p == curtree.start)
    fprintf(outtree, ";\n");
  else {
    fprintf(outtree, ":%*.5f", (int)(w + 7), x);
    col += w + 8;
  }
}  /* dnaml_treeout */

void dnaml_treeout_erate(tree_erate *tree, node_erate *p, valrec_erate ***table_erate)
{
  /* write out file with representation of final tree2 */
  long i, n, w;
  Char c;
  double x;
  node_erate *q;
  boolean inloop;
  double ratfracchange = 1.0;
  
  if (table_erate[0][0]->rat > 0.0) 
    ratfracchange = table_erate[0][0]->ratfracchange/table_erate[0][0]->rat;
  
  if (p->tip) {
    n = 0;
    for (i = 1; i <= nmlngth; i++) {
      if (nayme[p->index-1][i - 1] != ' ')
        n = i;
    }
    for (i = 0; i < n; i++) {
      c = nayme[p->index-1][i];
      if (c == ' ')
        c = '_';
      putc(c, outtree);
    }
    col += n;
  } else {
    putc('(', outtree);
    col++;

    inloop = false;
    q = p->next;
    do  {
      if (inloop) {
        putc(',', outtree);
        col++;
        if (col > 45) {
          putc('\n', outtree);
          col = 0;
        }
      }
      inloop = true;
      dnaml_treeout_erate(tree, q->back, table_erate);
      q = q->next;
    } while ((p == tree->start || p != q) &&
             (p != tree->start || p->next != q));

    
    putc(')', outtree);
    col++;
  }
  x = p->v * ratfracchange;
  if (x > 0.0)
    w = (long)(0.43429448222 * log(x));
  else if (x == 0.0)
    w = 0;
  else
    w = (long)(0.43429448222 * log(-x)) + 1;
  if (w < 0)
    w = 0;
  if (p == tree->start)
    fprintf(outtree, ";\n");
  else {
    fprintf(outtree, ":%*.5f", (int)(w + 7), x);
    col += w + 8;
  }
}  /* dnaml_treeout_erate */


void inittravtree(node *p)
{
  /* traverse tree to set initialized and v to initial values */
  node *q; 

  p->initialized = false;
  p->back->initialized = false;
  if ( usertree && (!lngths || p->iter) ) {
    p->v = initialv;
    p->back->v = initialv;
  }
  
  if ( !p->tip ) {
    q = p->next;
    while ( q != p ) {
      inittravtree(q->back);
      q = q->next;
    }
  }
} /* inittravtree */

void inittravtree_erate(node_erate *p)
{
  /* traverse tree to set initialized and v to initial values */
  node_erate *q; 

  p->initialized = false;
  p->back->initialized = false;
  if ( usertree && (!lngths || p->iter) ) {
    p->v = initialv;
    p->back->v = initialv;
  }
  
  if ( !p->tip ) {
    q = p->next;
    while ( q != p ) {
      inittravtree_erate(q->back);
      q = q->next;
    }
  }
} /* inittravtree_erate */

void treevaluate()
{
  /* evaluate a user tree */
  long i;

  inittravtree(curtree.start);
  polishing = true;
  smoothit = true;
  for (i = 1; i <= smoothings * 4; i++)
    smooth (curtree.start);
  dummy = evaluate(curtree.start, true);
}  /* treevaluate */

void treevaluate_erate(tree_erate *tree, 
		       valrec_erate ***table_erate, long endsite_erate, 
		       boolean optimize, double tol, int verbose)
{
  /* evaluate a user tree */
  long i;

  inittravtree_erate(tree->start);
  polishing = true;
  smoothit = true;
  for (i = 1; i <= smoothings * 4; i++) 
    smooth_erate(tree, tree->start, table_erate, endsite_erate, optimize, tol, verbose);

  dummy = evaluate_erate(tree, tree->start, table_erate, endsite_erate, true,  tol, verbose);
}  /* treevaluate_erate */

void dnaml_unroot(node* root, node** nodep, long nonodes) 
{
  node *p,*r,*q;
  double newl;
  long i;
  long numsibs;
  
  numsibs = count_sibs(root);

  if ( numsibs > 2 ) {
    q = root;
    r = root;
    while (!(q->next == root))
      q = q->next;
    q->next = root->next;

    for(i=0 ; i < endsite ; i++){
      free(r->x[i]);
      r->x[i] = NULL;
    }
    free(r->x);
    r->x = NULL;
    chucktreenode(&grbg, r);
    curtree.nodep[spp] = q;
  } else { /* Bifurcating root - remove entire root fork */
    /* Join oldlen on each side of root */
    newl = root->next->oldlen + root->next->next->oldlen;
    root->next->back->oldlen = newl;
    root->next->next->back->oldlen = newl;

    /* Join v on each side of root */
    newl = root->next->v + root->next->next->v;
    root->next->back->v = newl;
    root->next->next->back->v = newl;

    /* Connect root's children */
    root->next->back->back=root->next->next->back;
    root->next->next->back->back = root->next->back;

    /* Move nodep entries down one and set indices */
    for ( i = spp; i < nonodes-1; i++ ) {
      p = nodep[i+1];
      nodep[i] = p;
      nodep[i+1] = NULL;
      if ( nodep[i] == NULL ) /* This may happen in a
                                 multifurcating intree */
        break;
      do {
        p->index = i+1;
        p = p->next;
      } while (p != nodep[i]);
    }

    /* Free protx arrays from old root */
    for(i=0 ; i < endsite ; i++){
      free(root->x[i]);
      free(root->next->x[i]);
      free(root->next->next->x[i]);
      root->x[i] = NULL;
      root->next->x[i] = NULL;
      root->next->next->x[i] = NULL;
    }
    free(root->x);
    free(root->next->x);
    free(root->next->next->x);

    chucktreenode(&grbg,root->next->next);
    chucktreenode(&grbg,root->next);
    chucktreenode(&grbg,root);
  }
} /* dnaml_unroot */

void dnaml_unroot_erate(long endsite_erate, tree_erate *tree, node_erate *root, node_erate **nodep, long nonodes) 
{
  node_erate *p,*r,*q;
  double newl;
  long i;
  long numsibs;
  
  numsibs = count_sibs_erate(root);

  if ( numsibs > 2 ) {
    q = root;
    r = root;
    while (!(q->next == root))
      q = q->next;
    q->next = root->next;

    for(i=0 ; i < endsite_erate ; i++){
      free(r->x[i]);
      r->x[i] = NULL;
    }
    free(r->x);
    r->x = NULL;
    chucktreenode_erate(&grbg_erate, r);
    tree->nodep[spp] = q;
  } else { /* Bifurcating root - remove entire root fork */
    /* Join oldlen on each side of root */
    newl = root->next->oldlen + root->next->next->oldlen;
    root->next->back->oldlen = newl;
    root->next->next->back->oldlen = newl;

    /* Join v on each side of root */
    newl = root->next->v + root->next->next->v;
    root->next->back->v = newl;
    root->next->next->back->v = newl;

    /* Connect root's children */
    root->next->back->back=root->next->next->back;
    root->next->next->back->back = root->next->back;

    /* Move nodep entries down one and set indices */
    for ( i = spp; i < nonodes-1; i++ ) {
      p = nodep[i+1];
      nodep[i] = p;
      nodep[i+1] = NULL;
      if ( nodep[i] == NULL ) /* This may happen in a
                                 multifurcating intree */
        break;
      do {
        p->index = i+1;
        p = p->next;
      } while (p != nodep[i]);
    }

    /* Free protx arrays from old root */
    for(i=0 ; i < endsite_erate ; i++){
      free(root->x[i]);
      free(root->next->x[i]);
      free(root->next->next->x[i]);
      root->xe[i] = NULL;
      root->next->xe[i] = NULL;
      root->next->next->xe[i] = NULL;
    }
    free(root->x);
    free(root->next->x);
    free(root->next->next->x);

    chucktreenode_erate(&grbg_erate,root->next->next);
    chucktreenode_erate(&grbg_erate,root->next);
    chucktreenode_erate(&grbg_erate,root);
  }
} /* dnaml_unroot_erate */


void maketree()
{
  long i, j;
  boolean dummy_first, goteof;
  pointarray dummy_treenode=NULL;
  long nextnode;
  node *root;

  inittable();

  if (usertree) {
    openfile(&intree,INTREE,"input tree file", "r",progname,intreename);
    inittable_for_usertree (intree);
    numtrees = countsemic(&intree);
    if(numtrees > MAXSHIMOTREES)
      shimotrees = MAXSHIMOTREES;
    else
      shimotrees = numtrees;
    if (numtrees > 2)
      initseed(&inseed, &inseed0, seed);
    l0gl = (double *) Malloc(shimotrees * sizeof(double));
    l0gf = (double **) Malloc(shimotrees * sizeof(double *));
    for (i=0; i < shimotrees; ++i)
      l0gf[i] = (double *) Malloc(endsite * sizeof(double));
    if (treeprint) {
      fprintf(outfile, "User-defined tree");
      if (numtrees > 1)
        putc('s', outfile);
      fprintf(outfile, ":\n\n");
    }
    which = 1;

    /* This taken out of tree read, used to be [spp-1], but referring
       to [0] produces output identical to what the pre-modified dnaml
       produced. */

    while (which <= numtrees) {
      
      /* These initializations required each time through the loop
         since multiple trees require re-initialization */
      haslengths = true;
      nextnode         = 0;
      dummy_first      = true;
      goteof           = false;

      treeread(intree, &root, dummy_treenode, &goteof, &dummy_first, 
                      curtree.nodep, &nextnode, &haslengths, &grbg, 
                      initdnamlnode, false, nonodes2);
      dnaml_unroot(root, curtree.nodep, nonodes2);
      if (goteof && (which <= numtrees)) {
        /* if we hit the end of the file prematurely */
        printf ("\n");
        printf ("ERROR: trees missing at end of file.\n");
        printf ("\tExpected number of trees:\t\t%ld\n", numtrees);
        printf ("\tNumber of trees actually in file:\t%ld.\n\n", which - 1);
        exxit(-1);
      }

      curtree.start = curtree.nodep[0]->back;
      if ( outgropt )
        curtree.start = curtree.nodep[outgrno - 1]->back;
      
      treevaluate();
      dnaml_printree();
      summarize();
      if (trout) {
        col = 0;
        dnaml_treeout(curtree.start);
      }
      if(which < numtrees){
        freex_notip(nextnode, curtree.nodep);
        gdispose(curtree.start, &grbg, curtree.nodep);
      }
      else nonodes2 = nextnode;
      which++;
    }
    FClose(intree);
    putc('\n', outfile);
    if (!auto_ && numtrees > 1 && weightsum > 1 )
      standev2(numtrees, maxwhich, 0, endsite-1, maxlogl,
               l0gl, l0gf, aliasweight, seed);
  } else {
    /* If there's no input user tree, */
    for (i = 1; i <= spp; i++)
      enterorder[i - 1] = i;
    if (jumble)
      randumize(seed, enterorder);
    if (progress) {
      printf("\nAdding species:\n");
      writename(0, 3, enterorder);
#ifdef WIN32
      phyFillScreenColor();
#endif
    }
    nextsp = 3;
    polishing = false;
    smoothit = improve;
    buildsimpletree(&curtree);
    curtree.start = curtree.nodep[enterorder[0] - 1]->back;
    nextsp = 4;
    while (nextsp <= spp) {
      buildnewtip(enterorder[nextsp - 1], &curtree);
      bestyet = UNDEFINED;
      if (smoothit)
        dnamlcopy(&curtree, &priortree, nonodes2, rcategs);
      addtraverse(curtree.nodep[enterorder[nextsp - 1] - 1]->back,
                  curtree.start, true);
      if (smoothit)
        dnamlcopy(&bestree, &curtree, nonodes2, rcategs);
      else {
        insert_(curtree.nodep[enterorder[nextsp - 1] - 1]->back, qwhere, true);
        smoothit = true;
        for (i = 1; i<=smoothings; i++) {
          smooth (curtree.start);
          smooth (curtree.start->back);
        }
        smoothit = false;
        bestyet = curtree.likelihood;
      }
      if (progress) {
        writename(nextsp - 1, 1, enterorder);
#ifdef WIN32
        phyFillScreenColor();
#endif
      }
      if (global && nextsp == spp && progress) {
        printf("Doing global rearrangements\n");
        printf("  !");
        for (j = spp ; j < nonodes2 ; j++)
          if ( (j - spp) % (( nonodes2 / 72 ) + 1 ) == 0 )
            putchar('-');
        printf("!\n");
      }
      succeeded = true;
      while (succeeded) {
        succeeded = false;
        if (global && nextsp == spp && progress) {
          printf("   ");
          fflush(stdout);
        }
        if (global && nextsp == spp)
          globrearrange();
        else 
          rearrange(curtree.start, curtree.start->back);
        if (global && nextsp == spp && progress)
          putchar('\n');
      }
      nextsp++;
    }
    if ( !smoothit)
      dnamlcopy(&curtree, &bestree, nonodes2, rcategs);
    if (global && progress) {
      putchar('\n');
      fflush(stdout);
    }
    if (njumble > 1) {
      if (jumb == 1)
        dnamlcopy(&bestree, &bestree2, nonodes2, rcategs);
      else
        if (bestree2.likelihood < bestree.likelihood)
          dnamlcopy(&bestree, &bestree2, nonodes2, rcategs);
    }
    if (jumb == njumble) {
      if (njumble > 1)
        dnamlcopy(&bestree2, &curtree, nonodes2, rcategs);
      curtree.start = curtree.nodep[outgrno - 1]->back;
      for (i = 0; i < nonodes2; i++) {
        if (i < spp)
          curtree.nodep[i]->initialized = false;
        else {
          curtree.nodep[i]->initialized = false;
          curtree.nodep[i]->next->initialized = false;
          curtree.nodep[i]->next->next->initialized = false;
        } 
      }
      treevaluate();
      dnaml_printree();
      summarize();
      if (trout) {
        col = 0;
        dnaml_treeout(curtree.start);
      }
    }
  }
  if (usertree) {
    free(l0gl);
    for (i=0; i < shimotrees; i++)
      free(l0gf[i]);
    free(l0gf);
  }
  freetable();
  if (jumb < njumble)
    return;
  free(contribution);
  free(mp);
  for (i=0; i < endsite; i++)
     free(term[i]);
  free(term);
  for (i=0; i < endsite; i++)
     free(slopeterm[i]);
  free(slopeterm);
  for (i=0; i < endsite; i++)
     free(curveterm[i]);
  free(curveterm);

  freex(nonodes2, curtree.nodep);
  if (!usertree) {
    freex(nonodes2, bestree.nodep);
    freex(nonodes2, priortree.nodep);
    if (njumble > 1)
      freex(nonodes2, bestree2.nodep);
  }
  if (progress) {
    printf("\n\nOutput written to file \"%s\"\n\n", outfilename);
    if (trout)
      printf("Tree also written onto file \"%s\"\n", outtreename);
    putchar('\n');
  }
}  /* maketree */

void
maketree_erate(long endsite_erate, tree_erate *tree, tree_erate *besttree, tree_erate *besttree2, 
	       tree_erate *priortree, valrec_erate ***table_erate, int nrateparam, 
	       enum mstrategy mstrategy, int extrictpos, 
	       double subsexp, double indlexpl, double indlexph, 
	       double maxbranch, double tol)
{
  long i;
  boolean dummy_first, goteof;
  pointarray_erate dummy_treenode=NULL;
  long nextnode;
  node_erate *root;
  int verbose = 0;

  inittable_erate(endsite_erate, &table_erate, verbose);

  if (usertree) {
    openfile(&intree,INTREE,"input tree file", "r",progname,intreename);
    inittable_for_usertree_erate(intree, table_erate);
    numtrees = countsemic(&intree);
    if(numtrees > MAXSHIMOTREES)
      shimotrees = MAXSHIMOTREES;
    else
      shimotrees = numtrees;
    if (numtrees > 2)
      initseed(&inseed, &inseed0, seed);
    l0gl = (double *) Malloc(shimotrees * sizeof(double));
    l0gf = (double **) Malloc(shimotrees * sizeof(double *));
    for (i=0; i < shimotrees; ++i)
      l0gf[i] = (double *) Malloc(endsite_erate * sizeof(double));
    if (treeprint) {
      fprintf(outfile, "User-defined tree");
      if (numtrees > 1)
        putc('s', outfile);
      fprintf(outfile, ":\n\n");
    }
    which = 1;

    /* This taken out of tree read, used to be [spp-1], but referring
       to [0] produces output identical to what the pre-modified dnaml
       produced. */

    while (which <= numtrees) {
      
      /* These initializations required each time through the loop
         since multiple trees require re-initialization */
      haslengths = true;
      nextnode         = 0;
      dummy_first      = true;
      goteof           = false;

      treeread_erate(intree, &root, dummy_treenode, &goteof, &dummy_first, 
		     tree->nodep, &nextnode, &haslengths, &grbg_erate, 
		     initdnamlnode_erate, false, nonodes2, 
		     table_erate[0][0]->ratfracchange/table_erate[0][0]->rat, endsite_erate);
      dnaml_unroot_erate(endsite_erate, tree, root, tree->nodep, nonodes2);
      if (goteof && (which <= numtrees)) {
        /* if we hit the end of the file prematurely */
        printf ("\n");
        printf ("ERROR: trees missing at end of file.\n");
        printf ("\tExpected number of trees:\t\t%ld\n", numtrees);
        printf ("\tNumber of trees actually in file:\t%ld.\n\n", which - 1);
        exxit(-1);
      }

      tree->start = tree->nodep[0]->back;
      if ( outgropt )
        tree->start = tree->nodep[outgrno - 1]->back;
      
      /* Evaluate the tree using one of the minimization strategies
       */
      treevaluate_erate_mstrategy(endsite_erate, tree, table_erate, nrateparam, mstrategy, 
				  extrictpos, subsexp, indlexpl, indlexph, maxbranch, tol, 0, verbose);

      /* Print the tree */
      dnaml_printree_erate(tree, table_erate);

      /* Calculate confidence limist */
      summarize_erate(endsite_erate, tree, table_erate, tol);

      if (trout) {
        col = 0;
        dnaml_treeout_erate(tree, tree->start, table_erate);
      }
      if(which < numtrees){
        freexe_notip(nextnode, tree->nodep);
        gdispose_erate(tree->start, &grbg_erate, tree->nodep);
      }
      else nonodes2 = nextnode;
      which++;
    }
    FClose(intree);
    putc('\n', outfile);
    if (!auto_ && numtrees > 1 && weightsum > 1 )
      standev2(numtrees, maxwhich, 0, endsite_erate-1, maxlogl,
               l0gl, l0gf, aliasweight, seed);
  } else {
    /* 
     * If there's not input usertree, 
     */
    for (i = 1; i <= spp; i++)
      enterorder[i - 1] = i;
    if (jumble)
      randumize(seed, enterorder);
    if (progress) {
      printf("\nAdding species:\n");
      writename(0, 3, enterorder);
#ifdef WIN32
      phyFillScreenColor();
#endif
    }

    /* build the tree progressively starting with the first three species
     * in the alignment, and using one of the minimization strategies
     */
    buildtree_erate(spp, endsite_erate, tree, besttree, priortree, table_erate, nrateparam, mstrategy, 
		    extrictpos, subsexp, indlexpl, indlexph, maxbranch, tol, verbose);

    if ( !smoothit)
      dnamlcopy_erate(tree, besttree, nonodes2, rcategs, endsite_erate);
    if (global && progress) {
      putchar('\n');
      fflush(stdout);
    }
    if (njumble > 1) {
      if (jumb == 1)
        dnamlcopy_erate(besttree, besttree2, nonodes2, rcategs, endsite_erate);
      else
        if (besttree2->likelihood < besttree->likelihood)
          dnamlcopy_erate(besttree, besttree2, nonodes2, rcategs, endsite_erate);
    }
    if (jumb == njumble) {
      if (njumble > 1)
        dnamlcopy_erate(besttree2, tree, nonodes2, rcategs, endsite_erate);
      tree->start = tree->nodep[outgrno - 1]->back;
      for (i = 0; i < nonodes2; i++) {
        if (i < spp)
          tree->nodep[i]->initialized = false;
        else {
          tree->nodep[i]->initialized = false;
          tree->nodep[i]->next->initialized = false;
          tree->nodep[i]->next->next->initialized = false;
        } 
      }
      
      /* Evaluate the tree using one of the minimization strategies
       */
      /* Don't really need to minimize here anymore, we did it as
       * we added the species
       */
      treevaluate_erate_mstrategy(endsite_erate, tree, table_erate, nrateparam, mstrategy, 
				  extrictpos, subsexp, indlexpl, indlexph, maxbranch, tol, 1, verbose);
      
      /* Print the tree */
      dnaml_printree_erate(tree, table_erate);
      /* Calculate confidence limist */
      summarize_erate(endsite_erate, tree, table_erate, tol);

      if (trout) {
        col = 0;
        dnaml_treeout_erate(tree, tree->start, table_erate);
      }
    }
  } /* end making the tree */

  if (usertree) {
    free(l0gl);
    for (i=0; i < shimotrees; i++)
      free(l0gf[i]);
    free(l0gf);
  }
  freetable_erate(table_erate);
  if (jumb < njumble)
    return;
  free(contribution);
  free(mp);
  for (i=0; i < endsite_erate; i++)
     free(term[i]);
  free(term);
  for (i=0; i < endsite_erate; i++)
     free(slopeterm[i]);
  free(slopeterm);
  for (i=0; i < endsite_erate; i++)
     free(curveterm[i]);
  free(curveterm);
  freexe(endsite_erate, nonodes2, tree->nodep);
  if (!usertree) {
    freexe(endsite_erate, nonodes2, besttree->nodep);
    freexe(endsite_erate, nonodes2, priortree->nodep);
    if (njumble > 1)
      freexe(endsite_erate, nonodes2, besttree2->nodep);
  }
  if (progress) {
    printf("\n\nOutput written to file \"%s\"\n\n", outfilename);
    if (trout)
      printf("Tree also written onto file \"%s\"\n", outtreename);
    putchar('\n');
  }

}  /* maketree_erate */


void clean_up()
{
  /* Free and/or close stuff */
  long i;

  free (rrate);
  free (probcat);
  free (rate);
  /* Seems to require freeing every time... */
  for (i = 0; i < spp; i++) {
    free (y[i]);
  }
  free (y);
  free (nayme);
  free (enterorder);
  free (category);
  free (weight);
  free (alias);
  free (ally);
  free (location);
  free (aliasweight);

  FClose(infile);
  FClose(outfile);
  FClose(outtree);
#ifdef MAC
  fixmacfile(outfilename);
  fixmacfile(outtreename);
#endif
}   /* clean_up */

/***********************************************
 * Added functions: functions without counterpart in dnaml.c
 * minimization code and some wrappers
 * ER  
 ***********************************************/

/* Function: addthreespecies_erate()
 *
 * Date:     ER,  Thu Jan 25 13:33:53 EST 2007 [janelia]
 *
 * Purpose:  Add the first three species.
 *
 * Args:
 *
 * Return: status
 */
static int
addthreespecies_erate(tree_erate *tree, 
		      valrec_erate ***table_erate,  
		      long endsite_erate, 
		      boolean optimize, double tol, int verbose)
{
  int status;
  
  polishing = false;
  smoothit = improve;
  buildsimpletree_erate(tree, table_erate, endsite_erate, optimize, tol, verbose);
  tree->start = tree->nodep[enterorder[0] - 1]->back;

  return status;
}

/* Function: addspecies_erate()
 *
 * Date:     ER,  Thu Jan 25 13:33:53 EST 2007 [janelia]
 *
 * Purpose:  This is a wrapped of all the stuff that dnaml
 *           does each time it adds a species to the growing tree.
 *
 * Args:
 *
 * Return: status
 */
static int
addspecies_erate(long sp, long spp, long endsite_erate,  
		 tree_erate *tree, tree_erate *besttree, tree_erate *priortree, 
		 valrec_erate ***table_erate, 
		 boolean optimize, double tol, int verbose)
{
  long i, j;
  int status;

   if (sp == 3) {
    addthreespecies_erate(tree, table_erate, endsite_erate, optimize, tol, verbose);
    return status;
  }
 
  if (progress) {
    writename(sp - 1, 1, enterorder);
#ifdef WIN32
    phyFillScreenColor();   
#endif
  }
  
  /* buildnewtip_erate()
   *  
   * Create the new branch in the tree structure.
   * The branch still has not been added to the growing tree
   */
  buildnewtip_erate(sp, enterorder[sp - 1], tree);
  bestyet = UNDEFINED;

  if (smoothit) {
    dnamlcopy_erate(tree, priortree, nonodes2, rcategs, endsite_erate);
 }

  /* addtraverse_erate(): 
   *
   * This function checks exhaustively all places where the new branch
   * could be inserted. It does so by inserting the new branch at
   * the mid point of every existing branch and selecting the case
   * that produces the best likelihood. The branch where the insertion
   * is going to occur is defined by nodes qwhere_erate and qwhere_erate->back
   *
   * If the optimize flag is on, this functions also optimizes the
   * value of the new branch using the Newton method on the first derivative
   * by means of the function: makenewv_erate \in update_erate \in smooth_erate
   * 
   */
  addtraverse_erate(endsite_erate, tree, besttree, priortree, table_erate, tree->nodep[enterorder[sp - 1] - 1]->back,
		    tree->start, true, optimize, tol, verbose);

  /* insert_erate_(): 
   * 
   * Here is where we actually insert the new node at the midpoint
   * between nodes qwhere_erate and qwhere_erate->back
   *
   * the flag doinit is set to true so that it recalculates fresh
   * from the last tree of n-1 species.
   *
   */
  if (smoothit) {
    dnamlcopy_erate(besttree, tree, nonodes2, rcategs, endsite_erate);
  }
  else {
    insert_erate_(tree, table_erate, tree->nodep[enterorder[sp - 1] - 1]->back, 
		  qwhere_erate, endsite_erate, true, optimize, tol, verbose);
    smoothit = true;
    for (i = 1; i<=smoothings; i++) {
      smooth_erate(tree, tree->start, table_erate, endsite_erate, optimize, tol, verbose);
      smooth_erate(tree, tree->start->back, table_erate, endsite_erate, optimize, tol, verbose);
    }
    smoothit = false;
    bestyet = tree->likelihood;
  }

  /* something about global rearrangements (?) 
   * 
   */
  if (global && sp == spp && progress) {
    printf("Doing global rearrangements\n");
    printf("  !");
    for (j = spp ; j < nonodes2 ; j++)
      if ( (j - spp) % (( nonodes2 / 72 ) + 1 ) == 0 )
	putchar('-');
    printf("!\n");
  }

  /* rearrange_erate():
   *
   */
  succeeded = true;
  while (succeeded) {
    succeeded = false;
    if (global && sp == spp && progress) {
      printf("   ");
      fflush(stdout);
    }
    if (global && sp == spp) {
      globrearrange_erate(endsite_erate, tree, besttree, priortree, table_erate, optimize, tol, verbose);
    }
    else { 
      rearrange_erate(endsite_erate, tree, besttree, priortree, table_erate, tree->start, tree->start->back, optimize, tol, verbose);
    }
    
    if (global && sp == spp && progress)
      putchar('\n');
  }

  return status;
}


/* Function: addspecies_erate_alternate_func()
 *
 * Date:     ER,  Thu Jan 25 14:11:32 EST 2007 [janelia]
 *
 * Purpose:  
 *
 * Args:
 *
 * Return:   
 */
static double 
addspecies_erate_alternate_func(double *p, int np, void *dptr)
{
  struct minimize_erate_data *data = (struct minimize_erate_data *) dptr;
  struct root_erate_data *root_data = data->tree->root_data;
  double likelihood = -HUGE_VAL;
  
  rateparam_erate_unpack_paramvector(p, np, data);
  
  /* branch length optimization */
  /* Here we reproduce the funtion treevaluate_erate() 
   * either using the dnamle method: smooth_erate() or 
   * conjugate gradient descentL     branch__erate_minimizer()
   */
  if      (data->mstrategy == CG_ALTMIN)  branch_erate_minimizer(data); /* conjugate gradient method to optimize the branch lengths */
  else if (data->mstrategy == MIX_ALTMIN) smooth_erate_minimizer(data); /* the dnaml method to optimize the branch lengths */

  /* This piece calculates the loglikelihood after optimization of the branch lengths */
  inittravtree_erate(data->tree->start);
  likelihood = evaluate_rooted_erate(data->tree, data->table_erate, data->endsite_erate, true, data->tol, data->verbose);
  
  if (data->verbose) {
    if (data->table_erate[0][0]->rat > 0.) {
      printf("rate insertions = %f\n", data->table_erate[0][0]->ratxl/data->table_erate[0][0]->rat);
      printf("rate deletions  = %f\n", data->table_erate[0][0]->ratxm/data->table_erate[0][0]->rat);
      printf("rate alpha = %f\n", data->table_erate[0][0]->ratxi/data->table_erate[0][0]->rat);
      printf("rate beta  = %f\n", data->table_erate[0][0]->ratxv/data->table_erate[0][0]->rat);
    }
    printf("maxdist %f taxal %ld taxar %ld\n", root_data->taxa_maxdist, root_data->taxal, root_data->taxar);
    printf("rootl %ld (%f) rootr %ld (%f)\n", root_data->rootl, root_data->distrootl, root_data->rootr, root_data->distrootr);
    printf("Likelihood = %.10f\n\n", likelihood);
  }
  
  return -likelihood;
}  

/* Function: addspecies_erate_alternate_func()
 *
 * Date:     ER, Thu Feb  1 14:48:04 EST 2007 [janelia]
 *
 * Purpose:  
 *
 * Args:
 *
 * Return:   
 */
static double 
addspecies_erate_joint_func(double *p, int np, void *dptr)
{
  struct minimize_erate_data *data = (struct minimize_erate_data *) dptr;
  struct tree_erate *tree = data->tree;
  struct root_erate_data *root_data = data->tree->root_data;
  double likelihood = -HUGE_VAL;
  
  data->verbose = FALSE;

  if (data->verbose) {
    if (data->table_erate[0][0]->rat > 0.) {
      printf("p = %f\n", data->table_erate[0][0]->gprior/data->table_erate[0][0]->rat);
      printf("alpha = %f\n", data->table_erate[0][0]->ratxi/data->table_erate[0][0]->rat);
      printf("beta  = %f\n", data->table_erate[0][0]->ratxv/data->table_erate[0][0]->rat);
      printf("rate insertions = %f\n", data->table_erate[0][0]->ratxl/data->table_erate[0][0]->rat);
      printf("rate deletions  = %f\n", data->table_erate[0][0]->ratxm/data->table_erate[0][0]->rat);
    }
  }

  fullparam_erate_unpack_paramvector(p, np, data);
    
  /* This piece calculates the loglikelihood after optimization of the branch lengths */ 
  inittravtree_erate(tree->start);
  likelihood = evaluate_rooted_erate(tree, data->table_erate, data->endsite_erate, true, data->tol, data->verbose);
 
  if (data->verbose) {
    tree_describe_erate(tree->start, data->verbose);  
    if (data->table_erate[0][0]->rat > 0.) {
      printf("p = %f\n", data->table_erate[0][0]->gprior/data->table_erate[0][0]->rat);
      printf("alpha = %f\n", data->table_erate[0][0]->ratxi/data->table_erate[0][0]->rat);
      printf("beta  = %f\n", data->table_erate[0][0]->ratxv/data->table_erate[0][0]->rat);
      printf("rate insertions = %f\n", data->table_erate[0][0]->ratxl/data->table_erate[0][0]->rat);
      printf("rate deletions  = %f\n", data->table_erate[0][0]->ratxm/data->table_erate[0][0]->rat);
    }
    printf("maxdist %f taxal %ld taxar %ld\n", 
	   root_data->taxa_maxdist, root_data->taxal, root_data->taxar);
    printf("rootl %ld (%f) rootr %ld (%f)\n", 
	   root_data->rootl, root_data->distrootl, root_data->rootr, root_data->distrootr);
    printf("Likelihood = %.10f\n\n", likelihood);
  }
  
  if (data->verbose) printf("addspecies_erate_joint_func %f\n", likelihood);
  return -likelihood;
}  

/* Function: addspecies_erate_cg_bminimizer()
 *
 * Date:     ER,  Sun Feb  4 15:08:51 EST 2007 [janelia]
 *
 * Purpose:  Add species, one at the time optimizing only
 *           branch lengths using conjugate gradient descent.
 *
 * Args:
 *
 * Return: status
 */
static int
addspecies_erate_cg_bminimizer(long sp, long spp, long endsite_erate,  
      			       tree_erate *tree, tree_erate *besttree, tree_erate *priortree,
			       valrec_erate ***table_erate, 
			       double maxbranch, double tol, int verbose)
{
  struct minimize_erate_data  data;
  boolean optimize;
  int status;

  /* add the species */
  optimize = true; /* we still use dnaml branch optimization, and then do a global branch optimization */
  addspecies_erate(sp, spp, endsite_erate, tree, besttree, priortree, table_erate, optimize, tol, verbose);

  /* Copy shared info into the "data" structure
   */
  data.tree        = tree;
  data.table_erate = table_erate;
  data.maxbranch   = maxbranch;
  data.tol         = tol;
  data.verbose     = verbose;

  branch_erate_minimizer(&data);

  return status;
}

/* Function: addspecies_erate_minimizer()
 *
 * Date:     ER,  Thu Jan 25 13:55:44 EST 2007 [janelia]
 *
 * Purpose:  This function is the counterpart to addspecies_erate()
 *           in addition to optimizing on the branch lengths, it
 *           optimizes on the gap parameters and alternates both
 *           until convergence.
 *
 * Args:
 *
 * Return: status
 */
static int
addspecies_erate_altminimizer(long sp, long spp, long endsite_erate,  
			      tree_erate *tree, 
			      tree_erate *besttree, tree_erate *priortree, 
			      valrec_erate ***table_erate, 
			      int nrateparam, enum mstrategy mstrategy, int extrictpos, 
			      double subsexp, double indlexpl, double indlexph, 
			      double maxbranch, double tol, int verbose)
{
  struct minimize_erate_data  data;
  double                  *p;	        /* parameter vector                  */
  double                  *u;           /* max initial step size vector      */
  double                  *wrk; 	/* 4 tmp vectors of length nbranches */
  double                   fx;
  int                      x;
  int                      status;
  int                      nvariables;
  boolean                  optimize;

  if      (mstrategy == CG_ALTMIN)  optimize = FALSE; /* conjugate gradient method to optimize the branch lengths */
  else if (mstrategy == MIX_ALTMIN) optimize = TRUE;  /* the dnaml method to optimize the branch lengths */

  /* Add the new taxon */
  addspecies_erate(sp, spp, endsite_erate, tree, besttree, priortree, table_erate, optimize, tol, verbose);

   /* root the tree at hand */
  root_tree_erate(tree, tree->start, spp, nonodes2, true, tol, verbose);

  nvariables = nrateparam;

  /* allocate */
  ESL_ALLOC(p,   sizeof(double) * (nvariables+1));
  ESL_ALLOC(u,   sizeof(double) * (nvariables+1));
  ESL_ALLOC(wrk, sizeof(double) * (nvariables+1) * 4);

  /* Copy shared info into the "data" structure
   */
  data.tree        = tree;
  data.table_erate = table_erate;
  data.mstrategy   = mstrategy;
  data.extrictpos  = extrictpos;
  data.subsexp     = subsexp;
  data.indlexpl    = indlexpl;
  data.indlexph    = indlexph;
  data.maxbranch   = maxbranch;
  data.tol         = tol;
  data.verbose     = verbose;
 
  /* Create the parameter vector.
   */
  rateparam_erate_pack_paramvector(p, (long)nvariables, &data);

  /* Define the step size vector u.
   */
  for (x = 0; x < nvariables; x++) u[x] = 20.0;
  u[nvariables] = 10.0;

  /* pass problem to the optimizer
   */
  if ((status = esl_min_ConjugateGradientDescent(p, u, nvariables, 
						 &addspecies_erate_alternate_func,
						 NULL, 
						 (void *) (&data), 
						 tol, wrk, &fx))  != eslOK)
    esl_fatal("addspecies_erate_minimizer(): bad conjugate gradient descent");

  /* Convert the final parameter vector back
   */
  rateparam_erate_unpack_paramvector(p, (long)nvariables, &data);
  tree->likelihood = -fx;

  /* clean up */
  free(u);
  free(p);
  free(wrk);
  return eslOK;

 ERROR:
  if (p   != NULL) free(p);
  if (u   != NULL) free(u);
  if (wrk != NULL) free(wrk);
  return status;
}

/* Function: addspecies_erate_fullminimizer()
 *
 * Date:     ER,  Thu Jan 25 13:55:44 EST 2007 [janelia]
 *
 * Purpose:  This function is the counterpart to addspecies_erate()
 *           in addition to optimizing on the branch lengths, it
 *           optimizes on the gap parameters and alternates both
 *           until convergence.
 *
 * Args:
 *
 * Return: status
 */
static int
addspecies_erate_fullminimizer(long sp, long spp, long endsite_erate,  
			       tree_erate *tree, 
			       tree_erate *besttree, tree_erate *priortree, 
			       valrec_erate ***table_erate, 
			       int nrateparam, enum mstrategy mstrategy, int extrictpos, 
			       int alen, double slen, double subsexp, double indlexpl, double indlexph, 
			       double maxbranch, double tol, int verbose)
{
  struct minimize_erate_data  data;
  double                  *p;	        /* parameter vector                  */
  double                  *u;           /* max initial step size vector      */
  double                  *wrk; 	/* 4 tmp vectors of length nbranches */
  double                   fx;
  int                      x;
  int                      status;
  int                      nbranches;
  int                      nvariables;
  int                      nl;          /* number of leaves used */
  int                      nn;          /* number of total nodes used */
  boolean                  optimize;

  /* Add the new taxon */
  optimize = true; /* we still use dnaml branch optimization, and then do a global branch optimization */
  addspecies_erate(sp, spp, endsite_erate, tree, besttree, priortree, table_erate, optimize, tol, verbose);
  if (verbose) tree_describe_erate(tree->start, verbose);
  if (0) {     
    if (table_erate[0][0]->rat > 0.) {
      printf("p = %f\n", table_erate[0][0]->gprior/table_erate[0][0]->rat);
      printf("alpha = %f\n", table_erate[0][0]->ratxi/table_erate[0][0]->rat);
      printf("beta  = %f\n", table_erate[0][0]->ratxv/table_erate[0][0]->rat);
      printf("rate insertions = %f\n", table_erate[0][0]->ratxl/table_erate[0][0]->rat);
      printf("rate deletions  = %f\n", table_erate[0][0]->ratxm/table_erate[0][0]->rat);
    }
    
    printf("Tree likelihood before optimization %f\n", tree->likelihood); 
  }
 
  /* root the tree at hand */
  root_tree_erate(tree, tree->start, spp, nonodes2, true, tol, verbose);

  /* Calculate the actual number of leaves (nl) and nodes (nn) used.
   */
  nn = (int)tree->root_data->nn;
  nl = (int)tree->root_data->nl;

  /* Calculate the number of branches of the tree
   */
  if      (nn-nl == nl-2) nbranches = 2 * nl - 3; /* binary tree   */
  else if (nn-nl == nl-1) nbranches = 2 * nl - 2; /* unrooted tree */
  else esl_fatal("addspecies_erate_fullminimizer(): wrong tree? nleaves=%d  nnodes=%d", nl, nn);

  /* add all variables together */
  nvariables = nrateparam + nbranches;

  /* allocate */
  ESL_ALLOC(p,   sizeof(double) * (nvariables+1));
  ESL_ALLOC(u,   sizeof(double) * (nvariables+1));
  ESL_ALLOC(wrk, sizeof(double) * (nvariables+1) * 4);

  /* Copy shared info into the "data" structure
   */
  data.endsite_erate = endsite_erate;
  data.tree          = tree;
  data.table_erate   = table_erate;
  data.nrate         = nrateparam;
  data.nbranch       = nbranches;
  data.mstrategy     = mstrategy;
  data.extrictpos    = extrictpos;
  data.alen          = alen;
  data.slen          = slen;
  data.subsexp       = subsexp;
  data.indlexpl      = indlexpl;
  data.indlexph      = indlexph;
  data.maxbranch     = maxbranch;
  data.tol           = tol;
  data.verbose       = verbose;

  /* Create the parameter vector.
   */
  fullparam_erate_pack_paramvector(p, nvariables, &data);

  /* Define the step size vector u.
   */
  for (x = 0; x < nbranches; x++) u[x] = 0.1;
  for (x = nbranches; x < nvariables; x++) u[x] = 1.0;
  u[nvariables] = 1.0;

  /* pass problem to the optimizer
   */
  if ((status = esl_min_ConjugateGradientDescent(p, u, nvariables, 
						 &addspecies_erate_joint_func,
						 NULL, 
						 (void *) (&data), 
						 tol, wrk, &fx))  != eslOK)
    esl_fatal("addspecies_erate_fullminimizer(): bad conjugate gradient descent");
  
  /* Convert the final parameter vector back
   */
  fullparam_erate_unpack_paramvector(p, nvariables, &data);
  tree->likelihood = -fx;
  if (0) tree_describe_erate(tree->start, verbose);
  if (verbose) { printf("Tree likelihood %f\n", tree->likelihood); }

  /* clean up */
  free(u);
  free(p);
  free(wrk);
  return eslOK;

 ERROR:
  if (p   != NULL) free(p);
  if (u   != NULL) free(u);
  if (wrk != NULL) free(wrk);
  return status;

}

/* Function: addspecies_erate_mstrategy()
 *
 * Date:     ER,  Fri Feb  2 10:29:57 EST 2007 [janelia]
 *
 * Purpose:  Add species to the tree following one of
 *           the available minimization strategies.
 *
 * Args:
 *
 * Return: status
 */
static int
addspecies_erate_mstrategy(long sp, long spp, long endsite_erate,  
			   tree_erate *tree, 
			   tree_erate *besttree, tree_erate *priortree, 
			   valrec_erate ***table_erate,
			   int nrateparam, enum mstrategy mstrategy, int extrictpos, 
			   double subsexp, double indlexpl, double indlexph, 
			   double maxbranch, double tol, int verbose)
{
  double pb;          /* geometric probability prior */
  double xl;          /* lambda = rate of insertions */
  double xm;          /* mu     = rate of deletions  */
  double xi;          /* alpha  from F84 rate matrix */
  double xv;          /* beta   from F84 rate matrix */
  long   alen;
  double slen;
  long   i,j;
  int status;
  
  if (alignment_len_erate(endsite, sp, y, alias, aliasweight, &alen, &slen) != eslOK)
    esl_fatal("addspecies_erate_mstrategy(): could not calculate alen slen");
  if (0) printf(" alen %ld slen %f\n", alen, slen);
  
  for (i = 0; i < rcategs; i++) {
    for (j = 0; j < categs; j++) {  
      pb = (slen > 0.0)? slen/(slen+1.0) : 0.5;      
      table_erate[i][j]->gprior = table_erate[i][j]->rat * pb;
    }
  }
  
  
  if (mstrategy == MIX_ALTMIN || 
      mstrategy == CG_ALTMIN    ) {
    if (addspecies_erate_altminimizer(sp, spp, endsite_erate, tree, besttree, priortree, 
				      table_erate, nrateparam, mstrategy, extrictpos, 
				      subsexp, indlexpl, indlexph, maxbranch, tol, verbose) != eslOK) 
      {
	if (table_erate[0][0]->rat > 0.)
	  fprintf(outfile, "ALT Minimization failed while adding species %ld at: xl=%f xm=%f\n", 
		  sp,
		  table_erate[0][0]->ratxl/table_erate[0][0]->rat, 
		  table_erate[0][0]->ratxm/table_erate[0][0]->rat);	  	  
	EOF_error();
      }     
  }
  else if (mstrategy == CG_FULLMIN) {
    if (addspecies_erate_fullminimizer(sp, spp, endsite_erate, tree, besttree, priortree, 
				       table_erate, nrateparam, mstrategy, extrictpos, 
				       alen, slen, subsexp, indlexpl, indlexph, maxbranch, tol, verbose) != eslOK) 
      {
	if (table_erate[0][0]->rat > 0.)
	  fprintf(outfile, "FULL Minimization failed while adding species %ld at: xl=%f xm=%f\n", 
		  sp,
		  table_erate[0][0]->ratxl/table_erate[0][0]->rat, 
		  table_erate[0][0]->ratxm/table_erate[0][0]->rat);	  	  
	EOF_error();
      }     
  }
  else if (mstrategy == CG_BMIN)
    addspecies_erate_cg_bminimizer(sp, spp, endsite_erate, tree, besttree, priortree, 
				   table_erate, maxbranch, tol, verbose);
  else if (mstrategy == DEFAULT_BMIN)
    addspecies_erate(sp, spp, endsite_erate, tree, besttree, priortree, table_erate, true, tol, verbose);
  else
    esl_fatal("addspecies_erate_mstrategy(): check your minimization strategy.");
  
  verbose = FALSE;
  if (verbose) tree_describe_erate(tree->start, verbose);
  if (table_erate[0][0]->rat > 0.) {
    pb = table_erate[0][0]->gprior/table_erate[0][0]->rat;
    xl = table_erate[0][0]->ratxl/table_erate[0][0]->rat;
    xm = table_erate[0][0]->ratxm/table_erate[0][0]->rat;
    xi = table_erate[0][0]->ratxi/table_erate[0][0]->rat;
    xv = table_erate[0][0]->ratxv/table_erate[0][0]->rat;    
    
    printf("\n# species %ld\nOptimal lnlikelihood = %f\n", sp, tree->likelihood);
    printf("geometric prior = %f\n", pb);
    printf("rate insertions = %f\n", xl);
    printf("rate deletions  = %f\n", xm);
    printf("rate alpha      = %f\n", xi);
    printf("rate beta       = %f\n", xv);
  }
  
  return status;
}

/* Function: buildtree_erate()
 *
 * Date:     ER,  Fri Feb  2 15:06:25 EST 2007 [janelia]
 *
 * Purpose:  wrapper of the whole tree building process.
 *
 * Args:
 *
 * Return: status
 */
static int
buildtree_erate(long spp, long endsite_erate,  
		tree_erate *tree, 
		tree_erate *besttree, tree_erate *priortree,
		valrec_erate ***table_erate,
		int nrateparam, enum mstrategy mstrategy, int extrictpos, 
		double subsexp, double indlexpl, double indlexph, 
		double maxbranch, double tol, int verbose)
{
  long sp;
  
  /* Build a tree with the first tree species */
  /* First build a tree with the first tree species
   * Then, add species one at the time until spp.
   * After each species is added we optimize branch lengths
   * and rate paramters using one of the optimization strategies.
   */
  for (sp = 3; sp <= spp; sp ++) 
    addspecies_erate_mstrategy(sp, spp, endsite_erate, tree, besttree, priortree, table_erate, 
			       nrateparam, mstrategy, extrictpos, subsexp, indlexpl, indlexph, 
			       maxbranch, tol, verbose);
    
  return eslOK;}

/* branch optimization */
static void
branch_erate_pack_paramvector(double *p, int np, tree_erate *tree, int verbose)
{
  tree_branches_pack_erate(tree->start, p, (double)np, verbose);
}

/* branch optimization */
static void
branch_erate_unpack_paramvector(double *p, int np, tree_erate *tree, double maxbranch, int verbose)
{
  int idx;

  if (verbose) {
    printf("\nbranches\n");
    for (idx = 0; idx < np; idx++)  
      printf("branch %d p %f expp %f\n", idx, p[idx], exp(p[idx]));
  }
  
   tree_branches_unpack_erate(tree->start, p, (double)np, maxbranch, verbose);
}

/* Function: branch_erate_func()
 *
 * Date:     ER,  Thu Jan 11 09:41:09 EST 2007 [janelia]
 *
 * Purpose:  Calculale the log likelihood of the tree.
 *
 * Args:
 *
 * Return:   
 */
static double 
branch_erate_func(double *p, int np, void *dptr)
{
  struct minimize_erate_data *data = (struct minimize_erate_data *) dptr;
  tree_erate                 *tree = data->tree;
  int                         verbose = data->verbose;
  double                      likelihood;

  branch_erate_unpack_paramvector(p, (double)np, tree, data->maxbranch, verbose);

  likelihood = evaluate_rooted_erate(tree, data->table_erate, data->endsite_erate, true, data->tol, verbose);

  if (verbose) printf("branch_erate_func %f\n", likelihood);
  return -likelihood;
}

/* Function: branch_erate_minimizer()
 *
 * Date:     ER,  Wed Jan 10 15:57:11 EST 2007[janelia]
 *
 * Purpose:  This function optimizes the branch lengths of
 *           the tree using conjugate gradient
 *
 * Args:
 *
 * Return:   
 */
int
branch_erate_minimizer(struct minimize_erate_data *data)
{
  double *p;	      /* parameter vector                  */
  double *u;          /* max initial step size vector      */
  double *wrk; 	      /* 4 tmp vectors of length nbranches */
  double  fx;
  int     nl;          /* number of leaves used */
  int     nn;          /* number of total nodes used */
  int     x;
  int     nvariables;
  int     status;

  /* Calculate the actual number of leaves (nl) and nodes (nn) used.
   */
  nn = (int)data->tree->root_data->nn;
  nl = (int)data->tree->root_data->nl;

  /* Calculate the number of branches of the tree
   */
  if      (nn-nl == nl-2) nvariables = 2 * nl - 3; /* binary tree   */
  else if (nn-nl == nl-1) nvariables = 2 * nl - 2; /* unrooted tree */
  else esl_fatal("branch_erate_minimizer(): wrong tree? nleaves=%d  nnodes=%d", nl, nn);

  ESL_ALLOC(p,   sizeof(double) * (nvariables+1));
  ESL_ALLOC(u,   sizeof(double) * (nvariables+1));
  ESL_ALLOC(wrk, sizeof(double) * (nvariables+1) * 4);

  /* Create the parameter vector.
   */
  branch_erate_pack_paramvector(p, (double)nvariables, data->tree, data->verbose);

  /* Define the step size vector u.
   */
  for (x = 0; x < nvariables; x++) u[x] = 0.1;
  u[nvariables] = 0.1;

  /* pass problem to the optimizer
   */
  if ((status = esl_min_ConjugateGradientDescent(p, u, nvariables, 
						 &branch_erate_func, 
						 NULL, 
						 (void *) (data), 
						 data->tol, wrk, &fx)) != eslOK)
    esl_fatal("branch_erate_minimizer(): bad conjugate gradient descent");

  /* Convert the final parameter vector back
   */
  branch_erate_unpack_paramvector(p, (double)nvariables, data->tree, data->maxbranch, data->verbose);
  data->tree->likelihood = -fx;

  if (data->verbose) printf("branch_erate_minimizer(): likelihood = %f\n", data->tree->likelihood);

  free(u);
  free(p);
  free(wrk);
  return eslOK;

 ERROR:
  if (p   != NULL) free(p);
  if (u   != NULL) free(u);
  if (wrk != NULL) free(wrk);
  return status;
}

/* Given a valrec_erate structure, generate a parameter list with the
 * rate parameters to optimize
 */
static void
fullparam_erate_pack_paramvector(double *p, int np, struct minimize_erate_data *data)
{ 
  tree_erate     *tree = data->tree;
  valrec_erate ***table_erate = data->table_erate;
  int             nrate = data->nrate;
  int             nbranch = data->nbranch;
  double          tol     = data->tol;
  long            i, j;
  double          pb; /* geometric probability prior */
  double          xl; /* lambda = rate of insertions */
  double          xm; /* mu     = rate of deletions  */
  double          xi; /* alpha  from F84 rate matrix */
  double          xv; /* beta   from F84 rate matrix */
  int             idx;

  /* pack the branch lengths */
  tree_branches_pack_erate(tree->start, p, (double)nbranch, data->verbose);

  /* pack the rate parameters */
  idx = nbranch;
  pb = -1.0;
  xi = -1.0;
  xv = -1.0;
  xl = -1.0;
  xm = -1.0;

  if (table_erate[0][0]->rat > 0.) {
    pb = table_erate[0][0]->gprior/table_erate[0][0]->rat;
    xi = table_erate[0][0]->ratxi/table_erate[0][0]->rat;
    xv = table_erate[0][0]->ratxv/table_erate[0][0]->rat;
    xl = table_erate[0][0]->ratxl/table_erate[0][0]->rat;
    xm = table_erate[0][0]->ratxm/table_erate[0][0]->rat;
  }
  
  for (i = 0; i < rcategs; i++) 
    for (j = 1; j < categs; j++) 
      if (table_erate[i][j]->rat > 0. &&
	  (pb != table_erate[i][j]->gprior/table_erate[i][j]->rat ||
	   xi != table_erate[i][j]->ratxi/table_erate[i][j]->rat  ||
	   xv != table_erate[i][j]->ratxv/table_erate[i][j]->rat  ||
	   xl != table_erate[i][j]->ratxl/table_erate[i][j]->rat  ||
	   xm != table_erate[i][j]->ratxm/table_erate[i][j]->rat    )
	  )
	esl_fatal("fullparam_erate_pack_paramvector()"); 
  
  /* assign the variables for optimization.
   * Working in log space, since all parameters have to be positive
   */
  if (xl < tol) xl = tol;
  if (xm < tol) xm = tol;
  
  if (nrate == 3 || nrate == 5) {
    p[idx++] = log(-log(pb)); /* geometric orior is guaranteed to be between zero and 1 */
   }
  
  /* the gap rates */
  p[idx++] = log(xl);       /* log rate of insertions */
  p[idx++] = log(xm);       /* log rate of insertions */

  /* if we are optimzing transition and tranversion rates */
  if (nrate > 3) {
    p[idx++] = log(xi);     /* log alpha */
    p[idx++] = log(xv);     /* log beta  */
  }

  /* paranoia */
  if (idx != np)    
    esl_fatal("fullparam_erate_pack_paramvector(): number of parameters is %d not %d", np, idx);
  
  if (data->verbose) {
    idx = nbranch;    
    if (nrate == 3 || nrate == 5) 
      printf("pb %f %f\n", pb, p[idx++]);
    
    printf("xl %f %f\n", xl, p[idx++]);
    printf("xm %f %f\n", xm, p[idx++]);
    
    if (nrate > 3) {
      printf("xi %f %f\n", xi, p[idx++]);
      printf("xv %f %f\n", xv, p[idx++]);
    }
  }
}

/* Same as above but in reverse: given parameter vector <p>,
 * do appropriate c.o.v. back to desired parameter space, and
 * update the valrec_erate structure <table_erate> with new gap parameters.
 */
static void
fullparam_erate_unpack_paramvector(double *p, int np, struct minimize_erate_data *data)
{
  tree_erate     *tree = data->tree;
  valrec_erate ***table_erate = data->table_erate;
  int             nrate = data->nrate;
  int             nbranch = data->nbranch;
  double          tol = data->tol;
  double          slen = data->slen;
  double          subsexp = data->subsexp;
  double          indlexpl = data->indlexpl;
  double          indlexph = data->indlexph;
  double          maxbranch = data->maxbranch;
  int             verbose = data->verbose;
  long            i, j;
  double          pb = -1; /* geometric bernoulli prior */
  double          xl = -1; /* lambda = rate of insertions */
  double          xm = -1; /* mu     = rate of deletions  */
  double          xi = -1; /* alpha  from F84 rate matrix */
  double          xv = -1; /* beta   from F84 rate matrix */
  double          pxl, pxm;
  double          pxi, pxv;
  double          sum;
  int             idx;
  double          maxexp = 10.;

  if (verbose) {
    printf("\nbranches and params\n");
    for (idx = 0; idx < np; idx++) {
      if (idx < nbranch) 
     	printf("branch %d p %f expp %f\n", idx, p[idx], exp(p[idx]));
      else
	printf("param %d p %f expp %f\n", idx-nbranch, p[idx], exp(p[idx]));
    }
  }
           
  /* unpack the branch lengths */                       
  tree_branches_unpack_erate(tree->start, p, (long)nbranch, maxbranch, verbose);

  /* unpack the rate parameters */
  idx = nbranch;
 
  if (nrate == 3 || nrate == 5) 
    pb = exp(-exp(p[idx++]));
  else 
    pb = (slen > 0.0)? slen/(slen+1.0) : 0.5;

  /* the gap rates */
  pxl = p[idx++];
  pxm = p[idx++];

  if (pxl >= maxexp && pxm >= maxexp) {
    xl = indlexph/2.;
    xm = xl;
  }
  else if (pxl >= maxexp) {
    xl = indlexph;
    xm = 0.0;
  }
  else if (pxm >= maxexp) {
    xl = 0.0;
    xm = indlexph;
  }
  else {
    xl = exp(pxl);
    xm = exp(pxm);
    
  if (data->extrictpos) {
    if (xl < tol) xl = tol; 
    if (xm < tol) xm = tol;
  }
  
  /* normalize  freqo <= lamda + mu <= indlexp */
    sum = xl + xm; 
    if (sum < 0.0) esl_fatal("fullparam_erate_unpack_paramvector(}: negative gap rates");
    if      (sum > indlexph) { xl *= indlexph/sum; xm *= indlexph/sum; }
    else if (sum < indlexpl) { xl *= indlexpl/sum; xm *= indlexpl/sum; }
  }

  /* if we are optimzing transition and tranversion rates */
   if (nrate <= 3) {
    xi = table_erate[0][0]->ratxi/table_erate[0][0]->rat;
    xv = table_erate[0][0]->ratxv/table_erate[0][0]->rat;
  }
  else {
    pxi = p[idx++];
    pxv = p[idx++];

    if (pxi >= maxexp && pxv >= maxexp) {
      xi = subsexp/2.;
      xv = xi;
    }
    else if (pxi + pxv >= maxexp) {
      xi = subsexp/2.;
      xv = xi;
    }
    else if (pxi >= maxexp) {
      xv = 0.0; 
      xi = subsexp; 
    }
    else if (pxv >= maxexp) {
      xi = 0.0;
      xv = subsexp;
    }
    else {
      xi = exp(pxi);
      xv = exp(pxv);
      
      sum = xi + xv;
      if (sum > 0.0) { xi *= subsexp/sum; xv *= subsexp/sum; }
      
      /* paranoia  */
      if (fabs(xi+xv-subsexp) > tol) 
	esl_fatal("fullparam_erate_unpack_paramvector(): subs parameters do not follow the constrain");
    }   
  }

  /* xi=1 and xv = 0 produces ill defined loglikelihoods */
  if (xv < tol) {
    xv = tol; 
  }
  if (data->extrictpos) {
    if (xl < tol) xl = tol; 
    if (xm < tol) xm = tol;
  }
 
  if (xl < 0. || xm < 0.0 || isnan(xl) || isnan(xm)) 
    esl_fatal("fullparam_erate_unpack_paramvector(): bad conjugate gradient descent: xl %f xm %f", xl, xm);
  if (xi < 0.0 || xv < 0.0 || isnan(xi) || isnan(xv)) 
    esl_fatal("fullparam_erate_unpack_paramvector(): bad conjugate gradient descent: xi %f xv %f", xi, xv);

  for (i = 0; i < rcategs; i++) 
    for (j = 0; j < categs; j++) {
      table_erate[i][j]->gprior = table_erate[i][j]->rat * pb;
      table_erate[i][j]->ratxl  = table_erate[i][j]->rat * xl;
      table_erate[i][j]->ratxm  = table_erate[i][j]->rat * xm;
      table_erate[i][j]->ratxi  = table_erate[i][j]->rat * xi;
      table_erate[i][j]->ratxv  = table_erate[i][j]->rat * xv;
      
      if (fracchange_erate(table_erate[i][j]->ratxi, table_erate[i][j]->ratxv, 
			   table_erate[i][j]->ratxl, table_erate[i][j]->ratxm, 
			   freqa, freqc, freqg, freqt, freqo, 
			   &table_erate[i][j]->ratfracchange, verbose) != eslOK) 
	esl_fatal("fullparam_erate_unpack_paramvector() error calculating ratfracchange");
    }
  
  /* paranoia */
  if (idx != np)    
    esl_fatal("fullparam_erate_unpack_paramvector(): number of parameters is %d not %d", np, idx);

  if (FALSE) {
    printf("new parameters: pb %f xl %f xm %f xi %f xv %f frqo %f\n", pb, xl, xm, xi, xv, freqo);
  }

}

/* Given a valrec_erate structure, generate a parameter list with the
 * rate parameters to optimize
 */
static void
rateparam_erate_pack_paramvector(double *p, long nrateparam, struct minimize_erate_data *data)
{
  valrec_erate ***table_erate = data->table_erate;
  double tol     = data->tol;
  long   i, j;
  double xl; /* lambda = rate of insertions */
  double xm; /* mu     = rate of deletions  */
  double xi; /* alpha  from F84 rate matrix */
  double xv; /* beta   from F84 rate matrix */

  xi = -1.0;
  xv = -1.0;
  xl = -1.0;
  xm = -1.0;

  if (table_erate[0][0]->rat > 0.) {
    xi = table_erate[0][0]->ratxi/table_erate[0][0]->rat;
    xv = table_erate[0][0]->ratxv/table_erate[0][0]->rat;
    xl = table_erate[0][0]->ratxl/table_erate[0][0]->rat;
    xm = table_erate[0][0]->ratxm/table_erate[0][0]->rat;
  }
  
  for (i = 0; i < rcategs; i++) 
    for (j = 1; j < categs; j++) 
      if (table_erate[i][j]->rat > 0. &&
	  (xi != table_erate[i][j]->ratxi/table_erate[i][j]->rat ||
	   xv != table_erate[i][j]->ratxv/table_erate[i][j]->rat ||
	   xl != table_erate[i][j]->ratxl/table_erate[i][j]->rat ||
	   xm != table_erate[i][j]->ratxm/table_erate[i][j]->rat   )
	  )
	esl_fatal("rateparam_erate_pack_paramvector()"); 
		  
  /* assign the variables for optimization.
   * Working in log space, since all parameters have to be positive
   */
  if (xl < tol) xl = tol;
  if (xm < tol) xm = tol;
  if (nrateparam == 2) { 
    p[0] = log(xl); /* log rate of insertions */
    p[1] = log(xm); /* log rate of deletions */
  }
  else if (nrateparam == 4) { 
    p[0] = log(xl); /* log rate of insertions */
    p[1] = log(xm); /* log rate of deletions  */
    p[2] = log(xi); /* log alpha              */
    p[3] = log(xv); /* log beta               */
  }
  else 
    esl_fatal("rateparam_erate_pack_paramvector(): number of parameters is either 2 or 4 not %d", nrateparam);
  
}
/* Same as above but in reverse: given parameter vector <p>,
 * do appropriate c.o.v. back to desired parameter space, and
 * update the valrec_erate structure <table_erate> with new gap parameters.
 */
static void
rateparam_erate_unpack_paramvector(double *p, long nrateparam, struct minimize_erate_data *data)
{
  valrec_erate ***table_erate = data->table_erate;
  double subsexp  = data->subsexp;
  double indlexpl = data->indlexpl;
  double indlexph = data->indlexph;
  int    verbose  = data->verbose;
  double tol = data->tol;
  long i, j;
  int  idx;
  double xl = -1; /* lambda = rate of insertions */
  double xm = -1; /* mu     = rate of deletions  */
  double xi = -1; /* alpha  from F84 rate matrix */
  double xv = -1; /* beta   from F84 rate matrix */
  double sump = 0.0;
  double maxp;
  double maxexp = 700.0;

  idx = 0;
  if (nrateparam == 2) {
    if (isnan(p[idx]) || isnan(p[idx+1]))
      esl_fatal("fullparam_erate_unpack_paramvector(): the param vector is ill defined (%f %f)", p[idx], p[idx+1]);

    /* the gap parameters */
    if (p[idx] >= maxexp && p[idx+1] >= maxexp) {
      xl = indlexph/(double)nrateparam;
      xm = indlexph/(double)nrateparam;
    }
    else if (p[idx]   >= maxexp) {
      xl = indlexph;
      xm = 0.0;
    }
    else if (p[idx+1] >= maxexp) {
      xl = 0.0;
      xm = indlexph;
    }
    else {
      xl = exp(p[idx]);
      xm = exp(p[idx+1]);

      sump = xl + xm;
      /* reverse change of variables */
      if (sump > indlexph) {
	xl *= (indlexph/sump);
	xm *= (indlexph/sump);
      }
      else if (sump < indlexpl) {
	xl *= (indlexpl/sump);
	xm *= (indlexpl/sump);
      }
    }

    xi = table_erate[0][0]->ratxi/table_erate[0][0]->rat;
    xv = table_erate[0][0]->ratxv/table_erate[0][0]->rat;

    /* paranoia */
    if (fabs(xl+xm-indlexph) > tol) 
      esl_fatal("fullparam_erate_unpack_paramvector(): gap parameters do not follow the constrain: %f %f", xl+xm, indlexph);
  }
  else if (nrateparam == 4) {
    if (isnan(p[idx]) || isnan(p[idx+1]) || isnan(p[idx+2]) || isnan(p[idx+3]))
      esl_fatal("fullparam_erate_unpack_paramvector(): the param vector is ill defined (%f %f %f %f)", p[idx], p[idx+1], p[idx+2], p[idx+3]);

    maxp = subsexp + indlexph;
    
    if (p[idx] >= maxexp && p[idx+1] >= maxexp && p[idx+2] >= maxexp && p[idx+3] >= maxexp) {
      xl = maxp/(double)nrateparam;
      xm = maxp/(double)nrateparam;
      xi = maxp/(double)nrateparam;
      xv = maxp/(double)nrateparam;
    }
    else if (p[idx+1] >= maxexp && p[idx+2] >= maxexp && p[idx+3] >= maxexp) {
      xl = 0.0;
      xm = maxp/(double)(nrateparam-1);
      xi = maxp/(double)(nrateparam-1);
      xv = maxp/(double)(nrateparam-1);
    }
    else if (p[idx]   >= maxexp && p[idx+2] >= maxexp && p[idx+3] >= maxexp) {
      xl = maxp/(double)(nrateparam-1);
      xm = 0.0;
      xi = maxp/(double)(nrateparam-1);
      xv = maxp/(double)(nrateparam-1);
    }
    else if (p[idx]   >= maxexp && p[idx+1] >= maxexp && p[idx+3] >= maxexp) {
      xl = maxp/(double)(nrateparam-1);
      xm = maxp/(double)(nrateparam-1);
      xi = 0.0;
      xv = maxp/(double)(nrateparam-1);
    }
    else if (p[idx]   >= maxexp && p[idx+1] >= maxexp && p[idx+2] >= maxexp) {
      xl = maxp/(double)(nrateparam-1);
      xm = maxp/(double)(nrateparam-1);
      xi = maxp/(double)(nrateparam-1);
      xv = 0.0;
    }

    else if (p[idx]   >= maxexp && p[idx+1] >= maxexp) {
      xl = maxp/(double)(nrateparam-2);
      xm = maxp/(double)(nrateparam-2);
      xi = 0.0;
      xv = 0.0;
    }
    else if (p[idx]   >= maxexp && p[idx+2] >= maxexp) {
      xl = maxp/(double)(nrateparam-2);
      xm = 0.0;
      xi = maxp/(double)(nrateparam-2);
      xv = 0.0;
    }
    else if (p[idx]   >= maxexp && p[idx+3] >= maxexp) {
      xl = maxp/(double)(nrateparam-2);
      xm = 0.0;
      xi = 0.0;
      xv = maxp/(double)(nrateparam-2);
    }
    else if (p[idx+1] >= maxexp && p[idx+2] >= maxexp) {
      xl = 0.0;
      xm = maxp/(double)(nrateparam-2);
      xi = maxp/(double)(nrateparam-2);
      xv = 0.0;
    }
    else if (p[idx+1] >= maxexp && p[idx+3] >= maxexp) {
      xl = 0.0;
      xm = maxp/(double)(nrateparam-2);
      xi = 0.0;
      xv = maxp/(double)(nrateparam-2);
    }
    else if (p[idx+2] >= maxexp && p[idx+3] >= maxexp) {
      xl = 0.0;
      xm = 0.0;
      xi = maxp/(double)(nrateparam-2);
      xv = maxp/(double)(nrateparam-2);
    }

    else if (p[idx+2] + p[idx+3] >= maxexp) {
      xl = 0.0;
      xm = 0.0;
      xi = maxp/(double)(nrateparam-2);
      xv = maxp/(double)(nrateparam-2);
    }

    else if (p[idx]   >= maxexp) {
      xl = maxp;
      xm = 0.0;
      xi = 0.0;
      xv = 0.0;
    }
    else if (p[idx+1] >= maxexp) {
      xl = 0.0;
      xm = maxp;
      xi = 0.0;
      xv = 0.0;
    }
    else if (p[idx+2] >= maxexp) {
      xl = 0.0;
      xm = 0.0;
      xi = maxp;
      xv = 0.0;
    }
    else if (p[idx+3] >= maxexp) {
      xl = 0.0;
      xm = 0.0;
      xi = 0.0;
      xv = maxp;
    }
    else {
      xl = exp(p[idx]);
      xm = exp(p[idx+1]);
      xi = exp(p[idx+2]);
      xv = exp(p[idx+3]);

      /* reverse change of variables */
      sump = xl + xm + xi + xv;
      if (sump > 0.0) {
	xl *= (maxp/sump);
	xm *= (maxp/sump);
	xi *= (maxp/sump);
	xv *= (maxp/sump);
      }

    }
    /* paranoia */
    if (fabs(xl+xm+xi+xv-maxp) > tol) 
      esl_fatal("fullparam_erate_unpack_paramvector(): rate paramters do not follow the constrain. maxp = %f sum = %f", maxp, xl+xm+xi+xv); 
  }

  if (data->extrictpos) {
    if (xl < tol) xl = tol;
    if (xm < tol) xm = tol;
  }
  if (xl < 0. || xm < 0.0 || isnan(xl) || isnan(xm)) 
    esl_fatal("rateparam_erate_unpack_paramvector(): bad conjugate gradient descent: xl %f xm %f", xl, xm);
  if (xi < 0.0 || xv < 0.0 || isnan(xi) || isnan(xv)) 
    esl_fatal("rateparam_erate_unpack_paramvector(): bad conjugate gradient descent: xi %f xv %f", xi, xv);

  for (i = 0; i < rcategs; i++) 
    for (j = 0; j < categs; j++) {
      table_erate[i][j]->ratxl = table_erate[i][j]->rat * xl;
      table_erate[i][j]->ratxm = table_erate[i][j]->rat * xm;
      table_erate[i][j]->ratxi = table_erate[i][j]->rat * xi;
      table_erate[i][j]->ratxv = table_erate[i][j]->rat * xv;
      
      if (fracchange_erate(table_erate[i][j]->ratxi, table_erate[i][j]->ratxv, 
			   table_erate[i][j]->ratxl, table_erate[i][j]->ratxm,
			   freqa, freqc, freqg, freqt, freqo, 
			   &table_erate[i][j]->ratfracchange, verbose) != eslOK) 
	esl_fatal("rateparam_erate_unpack_paramvector() error calculating ratfracchange");
    }
  
}

/* Function: smooth_erate_minimizer()
 *
 * Date:     ER,  Wed Jan 10 15:57:11 EST 2007[janelia]
 *
 * Purpose:  This function optimizes the branch lengths of
 *           the tree using the dnaml method implemented
 *           in smooth_erate().
 *
 * Args:
 *
 * Return:   
 */
void
smooth_erate_minimizer(struct minimize_erate_data *data)
{
  boolean optimize = true;
  long i;

  /* This piece of code does the maximization of the score by changing the branches.
   * Basically using functions: makenewv_erate() \inc update_erate() \inc smooth_erate().
   * What we do is to alternate the maximization on the branches using dnaml code with
   * the maximization on the gap parameters using conjugate gradient descent code
   */
  inittravtree_erate(data->tree->start);
  polishing = true;
  smoothit = true;
  for (i = 1; i <= smoothings * 4; i++) 
    smooth_erate(data->tree, data->tree->start, data->table_erate, data->endsite_erate, 
		 optimize, data->tol, data->verbose);
}


/* Function:  tree_likelihood_erate()
 *
 * Synopsis:  
 *
 * Incept:    ER, Tue Dec 12 11:56:32 EST 2006 [Janelia]
 *
 * Purpose:   
 *
 * Args:      
 *
 * Returns:   
 *
 */
void
tree_likelihood_erate(long endsite_erate, tree_erate *tree, 
		      node_erate *p, valrec_erate ***table_erate, 
		      node_erate **bestnode, double tol, int verbose)
{
  node_erate *sib_ptr, *sib_back_ptr; 
  long i, num_sibs; 
  double likelihood;
  double bestlikelihood = -eslINFINITY;

  inittravtree_erate(tree->start);

  if (p->tip) return;
  likelihood = evaluate_erate(tree, p, table_erate, endsite_erate, true, tol, verbose);

  if (likelihood > bestlikelihood) {
    bestlikelihood = likelihood;
    *bestnode = p;
  }

  /* Recursive calls, should be called for all children */
  sib_ptr = p;
  num_sibs = count_sibs_erate(sib_ptr);
  for (i=0; i<num_sibs; i++) {
    sib_ptr      = sib_ptr->next;
    sib_back_ptr = sib_ptr->back;

    tree_likelihood_descent_erate(endsite_erate, tree, sib_back_ptr, table_erate, bestnode, &bestlikelihood, tol, verbose);
  }
  
  /* finally look at the back node */
  tree_likelihood_descent_erate(endsite_erate, tree, p->back, table_erate, bestnode, &bestlikelihood, tol, verbose);

}
void
tree_likelihood_descent_erate(long endsite_erate, tree_erate *tree, 
			      node_erate *p, valrec_erate ***table_erate, 
			      node_erate **bestnode, double *ret_bestlikelihood, 
			      double tol, int verbose)
{
  node_erate *sib_ptr, *sib_back_ptr;
  long i, num_sibs;
  double likelihood;

  if (p->tip) return;
  likelihood = evaluate_erate(tree, p, table_erate, endsite_erate, true, tol, verbose);

  if (likelihood > *ret_bestlikelihood) {
    *ret_bestlikelihood = likelihood;
    *bestnode = p;
  }

  /* Recursive calls, should be called for all children */
  sib_ptr = p;
  num_sibs = count_sibs_erate(sib_ptr);
  for (i=0; i<num_sibs; i++) {
    sib_ptr      = sib_ptr->next;
    sib_back_ptr = sib_ptr->back;

    tree_likelihood_descent_erate(endsite_erate, tree, sib_back_ptr, table_erate, bestnode, 
				  ret_bestlikelihood, tol, verbose);
  }

}

/* Function: treevaluate_erate_alternate_func()
 *
 * Date:     ER,  Mon Nov 20 15:19:51 EST 2006 [janelia]
 *
 * Purpose:  Calculale the log likelihood of the tree.
 *
 * Args:
 *
 * Return:   
 */
static double 
treevaluate_erate_alternate_func(double *p, int np, void *dptr)
{
  struct minimize_erate_data *data = (struct minimize_erate_data *) dptr;
  struct tree_erate *tree = data->tree;
  struct root_erate_data *root_data = tree->root_data;

  double likelihood = -HUGE_VAL;

  rateparam_erate_unpack_paramvector(p, np, data);
 
  /* branch length optimization */
  /* Here we reproduce the funtion treevaluate_erate() 
   * either using the dnamle method: smooth_erate() or 
   * conjugate gradient descentL     branch__erate_minimizer()
   */
  if      (data->mstrategy == CG_ALTMIN)  branch_erate_minimizer(data); /* conjugate gradient method to optimize the branch lengths */
  else if (data->mstrategy == MIX_ALTMIN) smooth_erate_minimizer(data); /* the dnaml method to optimize the branch lengths */

  /* This piece calculates the loglikelihood after optimization of the branch lengths */
  likelihood = evaluate_rooted_erate(tree, data->table_erate, data->endsite_erate, true, data->tol, data->verbose);
  
  if (data->verbose) {
    if (data->table_erate[0][0]->rat > 0.) {
      printf("rate insertions = %f\n", data->table_erate[0][0]->ratxl/data->table_erate[0][0]->rat);
      printf("rate deletions  = %f\n", data->table_erate[0][0]->ratxm/data->table_erate[0][0]->rat);
    }
    printf("maxdist %f taxal %ld taxar %ld\n", root_data->taxa_maxdist, root_data->taxal, root_data->taxar);
    printf("rootl %ld (%f) rootr %ld (%f)\n", root_data->rootl, root_data->distrootl, root_data->rootr, root_data->distrootr);
    printf("Likelihood = %.10f\n\n", likelihood);
  }
  
  return -likelihood;
}  

/* Function: treevaluate_erate_joint_func()
 *
 * Date:     ER,  Mon Nov 20 15:19:51 EST 2006 [janelia]
 *
 * Purpose:  Calculale the log likelihood of the tree.
 *
 * Args:
 *
 * Return:   
 */
static double 
treevaluate_erate_joint_func(double *p, int np, void *dptr)
{
  struct minimize_erate_data *data = (struct minimize_erate_data *) dptr;
  struct tree_erate *tree = data->tree;
  struct root_erate_data *root_data = tree->root_data;
  double likelihood = -HUGE_VAL;

  fullparam_erate_unpack_paramvector(p, np, data);
 
  /* This piece calculates the loglikelihood after optimization of the branch lengths */
  likelihood = evaluate_rooted_erate(tree, data->table_erate, data->endsite_erate, true, data->tol, data->verbose);
  
  if (data->verbose) {
    if (data->table_erate[0][0]->rat > 0.) {
      printf("rate insertions = %f\n", data->table_erate[0][0]->ratxl/data->table_erate[0][0]->rat);
      printf("rate deletions  = %f\n", data->table_erate[0][0]->ratxm/data->table_erate[0][0]->rat);
    }
    printf("maxdist %f taxal %ld taxar %ld\n", root_data->taxa_maxdist, root_data->taxal, root_data->taxar);
    printf("rootl %ld (%f) rootr %ld (%f)\n", root_data->rootl, root_data->distrootl, root_data->rootr, root_data->distrootr);
    printf("Likelihood = %.10f\n\n", likelihood);
  }
  
  return -likelihood;
}  

/* Function: treevaluate_erate_cgbminimizer()
 *
 * Date:     ER,  Thu Feb  1 14:33:26 EST 2007 [janelia]
 *
 * Purpose:  Maximizes the likelihood of a tree generated by dnaml-erate
 *           using conjugate gradient descent in the
 *           branch lengths.
 *           Equivalent to treevaluate_erate() but using conjugate
 *           gradient instead of the ralphson-newton method.
 *           
 * Args:    
 *           
 * Return:   eslOK if success.
 */
void treevaluate_erate_cg_bminimizer(long endsite_erate, 
				     tree_erate *tree, valrec_erate ***table_erate, 
				     double maxbranch, double tol, int verbose)
{
  struct minimize_erate_data data;
  boolean                    optimize;

  /* Evaluate the tree */
  optimize = true; /* we still use dnaml branch optimization, and then do a global branch optimization */
  treevaluate_erate(tree, table_erate, endsite_erate, optimize, tol, verbose);

  /* Copy shared info into the "data" structure
   */
  data.tree        = tree;
  data.table_erate = table_erate;
  data.maxbranch   = maxbranch;
  data.tol         = tol;
  data.verbose     = verbose;

  branch_erate_minimizer(&data);
}

/* Function: treevaluate_erate_altminimizer()
 *
 * Date:     ER,  Mon Nov 20 15:19:51 EST 2006 [janelia]
 *
 * Purpose:  Maximizes the likelihood of a tree generated by dnaml-erate
 *           using conjugate gradient descent. The variables are the gap
 *           parameters xl (rate insertions), xm (rate deletions).
 *           The branch lengths are optimized independently 
 *           either using dnaml standard code, [ function smooth_erate_minimizer() ]
 *           or conjugate gradient code        [ function branch_erate_minimizer() ]
 *           
 * Args:    
 *           
 * Return:   eslOK if success.
 */
int
treevaluate_erate_altminimizer(long endsite_erate,
			       tree_erate *tree, valrec_erate ***table_erate, 
			       int nrateparam, enum mstrategy mstrategy, int extrictpos, 
			       double subsexp, double indlexpl, double indlexph, 
			       double maxbranch, double tol, int verbose)
{
  struct minimize_erate_data  data;
  double                  *p;	        /* parameter vector                  */
  double                  *u;           /* max initial step size vector      */
  double                  *wrk; 	/* 4 tmp vectors of length nbranches */
  double                   fx;
  int                      x;
  int                      status;
  int                      nvariables;
  boolean                  optimize;

  if      (mstrategy == CG_ALTMIN)  optimize = FALSE; /* conjugate gradient method to optimize the branch lengths */
  else if (mstrategy == MIX_ALTMIN) optimize = TRUE;  /* the dnaml method to optimize the branch lengths */

  /* Evaluate the tree */
  treevaluate_erate(tree, table_erate, endsite_erate, optimize, tol, verbose);

  /* the rate parameters */
  nvariables = nrateparam;

  ESL_ALLOC(p,   sizeof(double) * (nvariables+1));
  ESL_ALLOC(u,   sizeof(double) * (nvariables+1));
  ESL_ALLOC(wrk, sizeof(double) * (nvariables+1) * 4);

  /* Copy shared info into the "data" structure
   */
  data.tree        = tree;
  data.table_erate = table_erate;
  data.mstrategy   = mstrategy;
  data.extrictpos  = extrictpos;
  data.subsexp     = subsexp;
  data.indlexpl    = indlexpl;
  data.indlexph    = indlexph;
  data.maxbranch   = maxbranch;
  data.tol         = tol;
  data.verbose     = verbose;

  /* Create the parameter vector.
   */
  rateparam_erate_pack_paramvector(p, (long)nvariables, &data);

  /* Define the step size vector u.
   */
  for (x = 0; x < nvariables; x++) u[x] = 0.1;
  u[nvariables] = 0.1;

  /* pass problem to the optimizer
   */
  if ((status = esl_min_ConjugateGradientDescent(p, u, nvariables, 
						 &treevaluate_erate_alternate_func, 
						 NULL, 
						 (void *) (&data), 
						 tol, wrk, &fx))         != eslOK)
    esl_fatal("treevaluate_erate_minimizer(): bad conjugate gradient descent");

  /* Convert the final parameter vector back
   */
  rateparam_erate_unpack_paramvector(p, nvariables, &data);
  tree->likelihood = -fx;

  /* clean up */
  free(u);
  free(p);
  free(wrk);
  return eslOK;

 ERROR:
  if (p   != NULL) free(p);
  if (u   != NULL) free(u);
  if (wrk != NULL) free(wrk);
  return status;
}

/* Function: treevaluate_erate_fullminimizer()
 *
 * Date:     ER,  Thu Feb  1 14:33:26 EST 2007 [janelia]
 *
 * Purpose:  Maximizes the likelihood of a tree generated by dnaml-erate
 *           using conjugate gradient descent in all variables:
 *           branch lengths and gap parameters
 *           xl (rate insertions), xm (rate deletions), and xk (gap marginals).
 *           
 * Args:    
 *           
 * Return:   eslOK if success.
 */
int
treevaluate_erate_fullminimizer(long endsite_erate,
				tree_erate *tree, valrec_erate ***table_erate,  
				int nrateparam, enum mstrategy mstrategy, 
				int extrictpos, long alen, double slen,
				double subsexp, double indlexpl, double indlexph, 
				double maxbranch, double tol, int verbose)
{
  struct minimize_erate_data  data;
  double                  *p;	        /* parameter vector                  */
  double                  *u;           /* max initial step size vector      */
  double                  *wrk; 	/* 4 tmp vectors of length nbranches */
  double                   fx;
  int                      x;
  int                      status;
  int                      nbranches;
  int                      nvariables;
  int                      nl;          /* number of leaves used */
  int                      nn;          /* number of total nodes used */
  boolean                  optimize;

  /* Evaluate the tree */
  optimize = true; /* we still use dnaml branch optimization, and then do a global branch optimization */
  treevaluate_erate(tree, table_erate, endsite_erate,optimize, tol, verbose);

  /* Calculate the actual number of leaves (nl) and nodes (nn) used.
   */
  tree_nnodes_erate(tree->start, tree->root_data, verbose); 
  nn = (int)tree->root_data->nn;
  nl = (int)tree->root_data->nl;

  /* Calculate the number of branches of the tree
   */
  if      (nn-nl == nl-2) nbranches = 2 * nl - 3; /* binary tree   */
  else if (nn-nl == nl-1) nbranches = 2 * nl - 2; /* unrooted tree */
  else esl_fatal("treevaluate_erate_minimizer(): wrong tree? nleaves=%d  nnodes=%d", nl, nn);

  /* add all variables together */
  nvariables = nrateparam + nbranches;

  ESL_ALLOC(p,   sizeof(double) * (nvariables+1));
  ESL_ALLOC(u,   sizeof(double) * (nvariables+1));
  ESL_ALLOC(wrk, sizeof(double) * (nvariables+1) * 4);

  /* Copy shared info into the "data" structure
   */
  data.tree        = tree;
  data.table_erate = table_erate;
  data.nrate       = nrateparam;
  data.nbranch     = nbranches;
  data.mstrategy   = mstrategy;
  data.extrictpos  = extrictpos;
  data.alen        = alen;
  data.slen        = slen;
  data.subsexp     = subsexp;
  data.indlexpl    = indlexpl;
  data.indlexph    = indlexph;
  data.maxbranch   = maxbranch;
  data.tol         = tol;
  data.verbose     = verbose;

  /* Create the parameter vector.
   */
  fullparam_erate_pack_paramvector(p, nvariables, &data);

  /* Define the step size vector u.
   */
  for (x = 0; x < nbranches; x++) u[x] = 0.1;
  for (x = nbranches; x < nvariables; x++) u[x] = 1.0;
  u[nvariables] = 1.0;

  /* pass problem to the optimizer
   */
  if ((status = esl_min_ConjugateGradientDescent(p, u, nvariables, 
						 &treevaluate_erate_joint_func, 
						 NULL, 
						 (void *) (&data), 
						 tol, wrk, &fx))         != eslOK)
    esl_fatal("treevaluate_erate_fullminimizer(): bad conjugate gradient descent");

  /* Convert the final parameter vector back
   */
  if (verbose) { printf("Tree likelihood %f\n", -fx); }
  fullparam_erate_unpack_paramvector(p, nvariables, &data);
  tree->likelihood = -fx;
  if (0) { printf("treevaluate Tree likelihood %f \n", tree->likelihood); }

  /* clean up */
  free(u);
  free(p);
  free(wrk);
  return eslOK;

 ERROR:
  if (p   != NULL) free(p);
  if (u   != NULL) free(u);
  if (wrk != NULL) free(wrk);
  return status;

}
   
/* Function: treevaluate_erate_mstrategy()
 *
 * Date:     ER,  Fri Feb  2 10:19:35 EST 2007 [janelia]
 *
 * Purpose:  Maximizes the likelihood of a tree generated by dnaml-erate
 *           using one of the minimization methods.
 *           
 * Args:    
 *           
 * Return:   eslOK if success.
 */
int   
treevaluate_erate_mstrategy(long endsite_erate,
			    tree_erate *tree, valrec_erate ***table_erate,
			    int nrateparam, enum mstrategy mstrategy, int extrictpos,
			    double subsexp, double indlexpl, double indlexph, 
			    double maxbranch, double tol, int donothing, int verbose)
{
  long   alen;
  double slen;
  double xl;          /* lambda = rate of insertions */
  double xm;          /* mu     = rate of deletions  */
  double xi;          /* alpha  from F84 rate matrix */
  double xv;          /* beta   from F84 rate matrix */
  double pb;          /* bernoulli frequency */
  double ttr;         /* transition/transversion rate */
  double fracchange;  /* average rate of change */
  double fracsubs;    /* average rate of substitutions */
  int    status;
  int    asis = TRUE;    /* true if we dont want to touch the treevaluate function from its original form */

  if (alignment_len_erate(endsite, spp, y, alias, aliasweight, &alen, &slen) != eslOK)
    esl_fatal("addspecies_erate_mstrategy(): could not calculate alen slen");
  if (0) printf("TREE alen %ld slen %f\n", alen, slen);

  if (!donothing) {
    if (asis) {    
      treevaluate_erate(tree, table_erate, endsite_erate, true, tol, verbose);
    }
    else {
      if (mstrategy == MIX_ALTMIN || 
	  mstrategy == CG_ALTMIN    ) {
	if (treevaluate_erate_altminimizer(endsite_erate, tree, table_erate, nrateparam, mstrategy, 
					   extrictpos, subsexp, indlexpl, indlexph, maxbranch, tol, verbose) != eslOK) 
	  {
	    if (table_erate[0][0]->rat > 0.)
	      fprintf(outfile, "ALT Minimization failed at: xl=%f xm=%f \n", 
		      table_erate[0][0]->ratxl/table_erate[0][0]->rat, 
		      table_erate[0][0]->ratxm/table_erate[0][0]->rat);	  	  
	    EOF_error();
	  }     
      }
      else if (mstrategy == CG_FULLMIN) {
	if (treevaluate_erate_fullminimizer(endsite_erate, tree, table_erate, nrateparam, mstrategy, 
					    extrictpos, alen, slen, subsexp, indlexpl, indlexph, maxbranch, tol, verbose) != eslOK) 
	  {
	    if (table_erate[0][0]->rat > 0.)
	      fprintf(outfile, "FULL Minimization failed at: xl=%f xm=%f \n", 
		      table_erate[0][0]->ratxl/table_erate[0][0]->rat, 
		      table_erate[0][0]->ratxm/table_erate[0][0]->rat);	  	  
	    EOF_error();
	  }     
      }
      else if (mstrategy == CG_BMIN) 
	treevaluate_erate_cg_bminimizer(endsite_erate, tree, table_erate, maxbranch, tol, verbose);
      else if (mstrategy == DEFAULT_BMIN) 
	treevaluate_erate(tree, table_erate, endsite_erate, true, tol, verbose);
      else
	esl_fatal("treevaluate_erate_mstrategy(): check your optimization strategy.");
    }
     
  }
  fprintf(outfile, "\nOptimization method:\n");
  if      (mstrategy == DEFAULT_BMIN) fprintf(outfile, "dnaml optimization for branch lengths\n");
  else if (mstrategy == CG_BMIN)      fprintf(outfile, "conjugate gradient optimization for branch lengths\n");
  else if (mstrategy == MIX_ALTMIN)   fprintf(outfile, "dnaml optimization for branch lengths/conjugate gradient for gap parameters\n");
  else if (mstrategy == CG_ALTMIN)   {
    if      (nrateparam <= 3) 
      fprintf(outfile, "alternate optimization of branches and gap parameters (2) using conjugate gradient descent\n");
    else if (nrateparam <= 5) 
      fprintf(outfile, "alternate optimization of branches and all rate parameters (4) using conjugate gradient descent\n");
    else esl_fatal("nrateparam should be 2 or 4, not %d\n", nrateparam);
 }
  else if (mstrategy == CG_FULLMIN)  {
    if      (nrateparam <= 3) 
      fprintf(outfile, "joint optimization of branches and gap parameters (2) using conjugate gradient descent\n");
    else if (nrateparam <= 5) 
      fprintf(outfile, "joint optimization of branches and all rate parameters (4) using conjugate gradient descent\n");
    else esl_fatal("nrateparam should be 2, 3, 4 or 5, not %d\n", nrateparam);
    
    if (nrateparam == 3 || nrateparam == 5)
      fprintf(outfile, "geometric prior optimized\n");
 }

  if (table_erate[0][0]->rat > 0.) {
    pb = table_erate[0][0]->gprior/table_erate[0][0]->rat;
    xl = table_erate[0][0]->ratxl/table_erate[0][0]->rat;
    xm = table_erate[0][0]->ratxm/table_erate[0][0]->rat;
    xi = table_erate[0][0]->ratxi/table_erate[0][0]->rat;
    xv = table_erate[0][0]->ratxv/table_erate[0][0]->rat;
  }
  else {
    pb = -1.;
    xl = -1.;
    xm = -1.;
    xi = -1.;
    xv = -1.;
  }

  if (mstrategy == DEFAULT_BMIN || mstrategy == CG_BMIN)
    fprintf(outfile, "\nGiven parameters:\n");
  else 
    fprintf(outfile, "\nOptimal parameters:\n");
  fprintf(outfile, "Geometric probability = %f\n", pb);
  fprintf(outfile, "Insertions rate = %f\n", xl);
  fprintf(outfile, "Deletions rate = %f\n", xm);
  
  ttr = transtravratio(xi, xv, freqa, freqc, freqg, freqt, tol);
  fracchange_erate(xi, xv, xl, xm,
		   freqa, freqc, freqg, freqt, freqo, 
		   &fracchange, verbose);
  fracsubs_erate(xi, xv, freqa, freqc, freqg, freqt,
		 &fracsubs, verbose);

  fprintf(outfile, "alpha = %f\n", xi);
  fprintf(outfile, "beta = %f\n", xv);
  fprintf(outfile, "Transition/transversion ratio = %f\n", ttr);
  fprintf(outfile, "Average rate of subtitutions = %f\n", fracsubs);
  fprintf(outfile, "Average rate of changes = %f\n", fracchange);
  
  if (verbose) tree_describe_erate(tree->start, verbose);

  /* divide likelihood by the ancestral length probability */
  if (pb > 0.0 && pb < 1.0) {
    printf("\nLIKE %f fac %f\n", tree->likelihood, log(1-pb) + slen*log(pb)); 
    tree->likelihood -= log(1-pb) + slen*log(pb);
  }
  
  if (1) {
    printf("\nTotal tree optimal lnlikelihood = %f\n", tree->likelihood);
    printf("Geometric prior = %f\n", pb);
    printf("Insertions = %f\n", xl);
    printf("Deletions  = %f\n", xm);
    if (nrateparam == 4) {
      printf("alpha = %f\n", xi);
      printf("beta = %f\n", xv);
    }
  }
  
  return status;
}

/***********************************************
 * End additional code 
 ***********************************************/



/***********************************************
 *  main function
 ***********************************************/
int main(int argc, Char *argv[])
{  /* DNA Maximum Likelihood */
  tree_erate curtree_erate, bestree_erate, bestree2_erate, priortree_erate;
  valrec_erate ***tbl_erate;
  long endsite_erate;
  double tol = epsilon; /* it has to be smaller than epsilon = 0.00001 set up in phylyp-erate.h */
  int nrateparam; /* number of paramters to minimize */
  int extrictpos;
  enum mstrategy mstrategy;
  double eigenexp;  /* value of alpha+beta+lamda+mu */
  double subsexp;   /* value of alpha+beta */
  double indlexpl;  /* min value of lambda+mu */
  double indlexph;  /* max value of lambda+mu */
  double maxbranch;
  double sum;
  long   alen;
  double slen;

  /* this is the equivalent to dnaml alpha+beta = 1 conditions 
   * what it is to set the value that the rate eigen values
   * add up to, so that it is the branch lengths that change.
   *
   */
  eigenexp  = 1.0;
  maxbranch = exp(5.0);

  if (0&&tol > EPSILON)
    esl_fatal("Reset your tolerance parameter tol=%f to be smaller than EPSILON=%f\n", 
	      tol, EPSILON); 
  
#ifdef MAC
  argc = 1;                /* macsetup("DnaML","");        */
  argv[0] = "DnaML";
#endif
  init(argc,argv);
  progname = argv[0];
  openfile(&infile,INFILE,"input file","r",argv[0],infilename);
  openfile(&outfile,OUTFILE,"output file","w",argv[0],outfilename);
  mulsets = false;
  datasets = 1;
  firstset = true;
  ibmpc = IBMCRT;
  ansi = ANSICRT;
  grbg = NULL;

  /* INITIALIZE */
  doinit_erate(&curtree_erate, &bestree_erate, &bestree2_erate, &priortree_erate);

  /* nrateparam = 2 if minimizing only the gap parameters (lambda, mu).
   * nrateparam = 4 if minimizing only the gap parameters and pamameters (alpha, beta) from the F84 model.
   */ 
  if (!optrate) nrateparam = 2; /* with the additional constraint:  indlexpl <= lambda+mu <= indlexph                           */
  else          nrateparam = 4; /* with the additional constraints: indlexpl <= lambda+mu <= indlexph  and alpha+beta = subsexp */

  /* MINIMIZATION OPTIONS 
   *
   * DEFAULT_BMIN = branch minimization only, using dnaml's ralph-newton method
   * CG_BMIN      = branch minimization only, using conjugate gradient descent
   *
   * MIX_ALTMIN   = rate paramters/branches alternate minimization
   *                uses DEFAULT_BMIN method for branches and CG for rate paramters
   * CG_ALTMIN    = rate paramters/branches alternate minimization
   *                uses CG for both minimizations
   *
   * CG_FULLMIN   = rate paramters/branches joint minimization by CG
   *
   * I could never make work MIX_ALTMIN, and CG_ALTMIN is very slow, so the
   * actual options are DEFAULT_BMIN, CG_BMIN or FULLMIN
   *
   */
  mstrategy = CG_FULLMIN;
  if (branchopt) {    mstrategy = DEFAULT_BMIN;
    if (cg_branchopt) mstrategy = CG_BMIN;
  }
  
  ttratio0 = ttratio;
  if (ctgry)
    openfile(&catfile,CATFILE,"categories file","r",argv[0],catfilename);
  if (weights || justwts)
    openfile(&weightfile,WEIGHTFILE,"weights file","r",argv[0],weightfilename);
  if (trout)
    openfile(&outtree,OUTTREE,"output tree file","w",argv[0],outtreename);
  if (!usertree) nonodes2--;
  for (ith = 1; ith <= datasets; ith++) {
    if (datasets > 1) {
      fprintf(outfile, "Data set # %ld:\n", ith);
      printf("\nData set # %ld:\n", ith);
    }
    ttratio = ttratio0;

    getinput_erate(&endsite_erate, &curtree_erate, &bestree_erate, &bestree2_erate, &priortree_erate, &extrictpos);
    
    if (alignment_len_erate(endsite, spp, y, alias, aliasweight, &alen, &slen) != eslOK)
      esl_fatal("main(): could not calculate alen slen");

    /* Parameters for indels
     */
    xm = freqo; /* initialization */
    xl = xm; 
    
    /* the frequencies have been obtained in getinput_erate(),
     * now we set the bounds on the exponents for the rate paramters */
    subsexp  = eigenexp;
    indlexpl = 1.0*freqo;
    indlexph = 1.0*eigenexp;

    /* normalize  indlexpl <= lamda + mu <= indlexph */
    sum = xl + xm; 
    if (sum < 0.0) esl_fatal("main(): negative gap rates");
    if      (sum > indlexph) { xl *= indlexph/sum; xm *= indlexph/sum; }
    else if (sum < indlexpl) { xl *= indlexpl/sum; xm *= indlexpl/sum; }  

   /* normalize  xi + xv = subsexp */
    sum = xi + xv; 
    if (sum > 0.0) { xi *= subsexp/sum; xv *= subsexp/sum; }
    else esl_fatal("main(): negative subtitution rates xi=%f xv=%f", xi, xv);
  
    if (ith == 1)
      firstset = false;
    for (jumb = 1; jumb <= njumble; jumb++)
      maketree_erate(endsite_erate, &curtree_erate, &bestree_erate, &bestree2_erate, &priortree_erate, 
		     tbl_erate, nrateparam, mstrategy, extrictpos, subsexp, indlexpl, indlexph, maxbranch, tol);
  }

  /* clean up */
  freelrsaves_erate(endsite_erate);
  if (&curtree_erate   != NULL) freetree2_erate(curtree_erate,   2*spp-1, spp);
  if (&bestree_erate   != NULL) freetree2_erate(bestree_erate,   2*spp-1, spp);
  if (&priortree_erate != NULL) freetree2_erate(priortree_erate, 2*spp-1, spp);
  if (njumble > 1) freetree2_erate(bestree2_erate,  2*spp-1, spp);
  clean_up();

  printf("Done.\n\n");
#ifdef WIN32
  phyRestoreConsoleAttributes();
#endif
  return 0;
}  /* DNA Maximum Likelihood eRATE*/
