/*
 * $Id: defs.h,v 1.20 2000/04/17 16:19:28 dirk Exp $
 */

#ifndef DEFS_H
#define DEFS_H

#define BOLDON "[1m"
#define BOLDOFF "[m"
/* #define VERSION "$Revision: 1.20 $" */

#ifndef FALSE
#define FALSE 0
#endif /*FALSE */

#ifndef TRUE
#define TRUE (! FALSE)
#endif /* TRUE */

#ifndef BOOL
#define BOOL unsigned int
#endif /* BOOL */

/* stolen code ;-)) */
#define MAX(X,Y) (((X) > (Y)) ? (X) : (Y))
#define MIN(X,Y) (((X) < (Y)) ? (X) : (Y))
#define MAX3(X,Y,Z) (MAX(X,MAX(Y,Z)))
#define MIN3(X,Y,Z) (MIN(X,MIN(Y,Z)))
#define ROUND(X) ((int)((X)+0.5))
#define MAX4(A,B,C,D) (MAX(A,MAX(B,MAX(C,D))))

#define MAKEPERCENT(X,Y) (float)((X)*100.f)/(float)(Y)

#define PROTEIN 20
#define DNA 4
#define RNA 44
#define OTHER 15

/* tags for sequence output (GDE format) */
#define PROTEIN_TAG '>'
#define DNA_TAG '>'
#define RNA_TAG '>'
#define OTHER_TAG '>'
#define CHOOSE_TAG(T) (T)==PROTEIN ? PROTEIN_TAG : ((T)==DNA ? DNA_TAG : \
                     ((T)==RNA ? RNA_TAG : OTHER_TAG))

/* Alignment Output Formats */

#define ALI_FASTA 0
#define TAG_FASTA "FASTA"
#define SUF_FASTA ".fa"

#define ALI_PHYLIP 1
#define TAG_PHYLIP "PHYLIP"
#define SUF_PHYLIP ".phy"

/* int SeedVal = -2126880384; this creates dmalloc error in WriteAlignment */
#define NO_SEED -1

/* no distance given for a node */
#define DEFAULT_DIST 1.0

/* sequence output: identifier and line length */
#define SEQUENCE_IDENTIFIER "SEQ"
#define SEQUENCE_ID_LENGTH 20

/* used for aliControl */
#define GAP_BY_INSERTION -1
#define TRUE_INSERTION -2

#define ZUFALL '+'
#define GAP_CHARACTER '-'

/* The maximum ASCII char allowed: Z+1 (zero array offset)*/
#define MAX_ALPH 92
/* Array index for sum totals */
#define TOTAL 0


/* round factor for values between 0 and 10.000*/
#define ROUND_FACTOR 10000
     
/* a maximum gap length */
#define MAX_GAPLEN 10
     
     
#endif /* DEFS_H */
