/*
 * $Id:$
 */

#ifndef GLOBAL_H
#define GLOBAL_H


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif

#include "defs.h"
#include "lslist.h"

/*#include "dmalloc.h"*/

/* for MAX_ALPH see defs.h */
/* the type of a probability */
typedef int prob_t;

/* The type of a matrix: used as a char based lookup matrix */
typedef prob_t matrix_t[MAX_ALPH][MAX_ALPH];

/* The type of an alphabet eg { 'A', 'C', 'G', 'T' } */
typedef char * alphabet_t;

/* The type of a frequency table */
typedef prob_t frequency_t[MAX_ALPH];

/* The type of a probability vector (initialy has length SequenceLen) */
typedef prob_t * probability_t;

/* The indel function type */
typedef struct {
  prob_t prob;      /* initial probability for an indel */
  prob_t max;       /* max len of vector */
  prob_t * distr;   /* quantized probability distribution */
} indel_func_t;

/* this struct contains all the global options we use */
typedef struct {
  int SequenceLen;   /* Length of Sequences to be created,
		        can be omitted only if root sequence is 
		        entered */
  int SequenceNum;   /* number of Sequences to be created */

  int AlphabetSize;  /* either PROTEIN (default) , or DNA or OTHER ==
		        user specified 
		        the value of PROTEIN and DNA is identical to
		        the respective alphabet size 
		        i.e.: PROTEIN 20, DNA 4 (kludge: use DNA for RNA!!!) */

  char *OutputFilename; /* These are obvious */
  FILE *OutputStream;
  char *InputFilename;
  FILE *InputStream;
  
  int InputType;    /* what type of sequence data are we dealing with
		       PROTEIN, DNA, RNA or OTHER 
		       see defs.h
		       */
  int Relatedness;  /* avg. distance between the output sequences */
  BOOL ChooseFromLeaves; /* choose sequences only from leaves of the tree */

} tOptions;


/* data type for the list of edit operations separating two nodes */
typedef struct editop_s {
  struct LSlist_s *next;        /* this !MUST! be the first element in struct */
 /*type definition*/
  int type; /* must be 2nd element of struct!!!, 
               must be either E_OP,I_OP,D_OP */
  
  int position;
  char new_value;

} editop_t;

typedef struct delop_s {
  struct LSlist_s *next;        /* this !MUST! be the first element in struct */
  /*type definition*/
  int type; /* must be 2nd element of struct!!!, 
               must be either E_OP,I_OP,D_OP */
  
  int position;
  int length;
} delop_t;

typedef struct insop_s {
  struct LSlist_s *next;        /* this !MUST! be the first element in struct */
  /*type definition*/
  int type; /* must be 2nd element of struct!!!,
               must be either E_OP,I_OP,D_OP */
  
  int position;
  char *insert_sequence;
} insop_t;

/* unions */

typedef union editop_u_s {
  LSlist_t LS_LIST;
  editop_t editop;
  delop_t delop;
  insop_t insop;
} editop_u;

#define E_OP 1
#define D_OP 2
#define I_OP 3


/* the tree we are using for all our computation*/
typedef struct tTree_s {

  /* pointers to other leaves */
  struct tTree_s* father;       /* pointer to predecessor */
  struct tTree_s* brother;      /* pointer to brother nodes */
  struct tTree_s* childs;       /* pointer to child nodes */
  editop_u *edits;       /* we store the edit ops that create this node
			    from it's predecessor here */

  int number;            /* a uniq identifier for each node in the
			    given tree */
  double distance;       /* distance of this node from it's predecessor */

  char* Name;            /* optional name if one is entered */
  BOOL selected;         /* flag: this node is selected */
  BOOL relevant;         /* flag: this node is above a selected */

  char* sequence;        /* we decided to put the sequence for
			    each node here */
  int SequenceLen;       /* sequence length */
  char* alignment;       /* aligned sequence */

  double InsertThreshold; /* insertion Threshold */
  double DeleteThreshold; /* deletion Threshold */


  double *InsertionFunction;   /* Vector with cumulated probabilities for */
  double *DeletionFunction;      /* insertion and deletion lengths*/

  double *MutationProbability; /* sitespecific mutation probabilities 
				  for Patterns */
  int MutProbAlloc;       /* has node allocated MutationProbability itself? */
  /* have to know, to free. MutationProbability is implemented copy on write */

} node;


/* The Global Datastructure for global variables and command line args */

typedef union {
  int             i;
  int *           iv;
  int **          im;
  float           f;
  float  *        fv;
  float  **       fm;
  double          d;
  double *        dv;
  double **       dm;
  char *          s;
  node *          t; 
} value_t;

typedef struct {
  const char * tag;
  int typ;
  int dim[2];
  value_t value;
} tagvalue_t;


/* this is a list of dirks new tag value unions ... 
   substituting the old global variables */

extern tagvalue_t
  * SeedVal,
  * SequenceLen,
  * SequenceNum,
  * StdOut,           
  * OutputFilename,   
  * OutputFilebase,   
  * SequenceSuffix,   
  * AlignmentSuffix,  
  * AlignmentFormat,  
  * AlignmentWithAncestors,  
  * TreeSuffix,       
  * SequenceOutputLen,
  * SequenceOutputLen,
  * InputFilename,
  * InputStream,
  * InputType,
  * Relatedness,
  * ChooseFromLeaves,
  * TreeWithSequences,
  * TreeSequencesWithGaps,
  * TreeWithAncestors,
  * TheTree,
  * TheSequence,
  * ThePAMMatrix,
  * TheMatrix,
  * TheAlphabet,
  * TheFrequencies,
  * TheFreq,
  * TheInsFunc,
  * TheDelFunc,
  * TheInsertionFunction,
  * TheDeletionFunction,
  * TheInsertThreshold,
  * TheDeleteThreshold,
  * TheMutationProbability,
  * TheDNAmodel,
  * MeanSubstitution,
  * TransitionBias,
  * TTratio,
  * NumberOfRuns,
  * SimCoding;

#endif /* GLOBAL_H */
