/*
 * $Id: lslist.c,v 1.5 1999/05/06 08:34:35 dirk Exp $
 */

/* includes */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_STDIO_H
#include<stdio.h>
#endif
#ifdef HAVE_ERRNO_H
#include<errno.h>
#endif

#include "lslist.h"

/* functions */

/* Insert a list-element into a list
 * 
 * by allocating size memory and placing it after elem
 *
 * returns a void pointer to the new element
 */

void *
lsInsert(LSlist_t *elem, size_t size) {
  
  LSlist_t* ptr;

  ptr = (LSlist_t *)malloc(size); /* allocate memory of size */
  if(ptr == NULL) {		  /* check success */
    perror("lsInsert");	
    exit(1);
  }

  if(elem == NULL)	       	/* if no elem */
    ptr->next = NULL;		/* first elem, so next is null */
  else {
    ptr->next = elem->next;	/* swap the pointers */
    elem->next = ptr;
  }

  return (void *)ptr;		/* return the pointer to new elem */
}

/* Append a list-element to a list
 * 
 * by allocating size memory and 
 * placing it at the end of the list pointed to by elem
 *
 * returns a void pointer to the new element
 */

void *
lsAppend(LSlist_t *elem, size_t size) {

  if(elem != NULL)              /* if the element is not a NULL pointer */
    while(elem->next)		/* find the last element in the list */
      elem = elem->next;
  
  return lsInsert(elem, size);	/* insert a new element */
}

/* Delete the next list-element in a list
 * 
 * by freeing the pointer next and
 * rearranging the pointer to point to the element after next
 *
 * returns nothing
 */

void
lsDelNext(LSlist_t *elem) {
  
  LSlist_t *ptr;

  if(!elem)     		/* if there is no element return */
    return;

  if(!elem->next)	      /* if there is no next element to delete return */
    return;

  ptr = elem->next;		/* store the next pointer so we can free it */
  elem->next = elem->next->next; /* skip to next element in list */
  free(ptr);			/* delete element*/

  return;
}

/* Delete all list elements including elem
 * 
 * by traversing the list and
 * freeing all pointers
 * does not set next pointer of previous listelement to NULL!
 *
 * returns nothing
 */

void
lsDelList(LSlist_t *elem) {

  LSlist_t* ptr = NULL;

  if(!elem)			/* if there is no element return */
    return;

  while(elem->next) {		/* while there is a next element */
    ptr = elem;			/* store the elem pointer so we can free it */
    elem = elem->next;		/* move to next element */
    free(ptr);			/* free the previous element */
  }
  free(elem);			/* free the last remaining element */
  
  return;
}
