/*
 * $Id: mxerror.c,v 1.7 1999/05/06 08:33:23 dirk Exp $
 */


/* The idea for this was stolen from dirk evers dirk@Techfak.uni-bielefeld.de,
   some of the lines too. ;-) Thanks.*/
/* Added a few lines ...  Dirk */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif
#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_STDARG_H
#include <stdarg.h>
#endif

#include "mxerror.h"


/* local to file */
FILE *mxDebugOut = NULL;              /* where to print debug info */
FILE *mxErrorOut = NULL;              /* where to print error info */
                                      /* init to NULL, some systems don't */
                                      /* have constant stderr */

/* declared extern in header */
int unsigned mxDebugLevel = DB_NON;     /* any level smaller is output */
int mxDebugInfo = 1;                    /* output source and line number */
int mxErrNo = 0;                        /* output errno and string */
unsigned int mxLineNo;                  /* the stored line number */
char *mxFileName;                       /* the stored source filename */


/* functions */

void
mxSetDebugOut(FILE *strm) {

  mxDebugOut = strm;
  return;
}

void
mxSetErrorOut(FILE *strm) {

  mxErrorOut = strm;
  return;
}


int   /* Write standardized debug message to Error Channel */
mxPrintDebug(const unsigned int level, const char *fmt, ...) {
  
  va_list args;
  
  if(level <= mxDebugLevel) {
    va_start(args, fmt);
    if (mxDebugOut == NULL)
      mxDebugOut = stderr;
    if(mxDebugOut == stderr)
      fflush(stdout);
    if(mxDebugInfo)
      fprintf(mxDebugOut, "DEBUG[%d] %s [%d]:", level, mxFileName, mxLineNo);
    vfprintf(stderr, fmt, args);
    if(errno && mxErrNo) {
      fprintf(mxDebugOut, "\nERRNO[%d]: %s", errno, strerror(errno));
      errno = 0;
    }
    /* newline not useful for matrix debug output */
    /*    fprintf(mxDebugOut, "\n");  */
    va_end(args);
  }

  return 0;
}

int   /* Write standardized debug message to Error Channel */
mxPrintError(const unsigned int exitflag, const char *fmt, ...) {

  va_list args;
  
  va_start(args, fmt);
  if (mxErrorOut == NULL)
      mxErrorOut = stderr;
  if(mxErrorOut == stderr)
    fflush(stdout);
  if(mxDebugInfo)
    fprintf(mxErrorOut, "ERROR[%d] %s [%d]:", exitflag, mxFileName, mxLineNo);
  vfprintf(mxErrorOut, fmt, args);
  if(errno && mxErrNo) {
    fprintf(mxErrorOut, "\nERRNO[%d]: %s", errno, strerror(errno));
    errno = 0;
  }
  fprintf(mxErrorOut, "\n");
  va_end(args);
  
  if(exitflag)
    exit(exitflag);
  else
    return 0;
}

