/*
 * $Id: mxerror.h,v 1.4 1999/05/06 08:40:58 dirk Exp $
 */

#ifndef MX_ERRORH_H_
#define MX_ERRORH_H_


#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE (! FALSE)
#endif

/* Debug Levels */

#define DB_ALL 100000
#define DB_DEBUG 100
#define DB_USER 10
#define DB_NON 0

#define DO_EXIT 1
#define DONT_EXIT 0
#define NO_EXIT 0

/* Macros */

#ifdef DEBUG

#define MXDELIM ,

#define MXDEBUG(args) mxFileName = __FILE__, mxLineNo = __LINE__, \
mxPrintDebug(args)

#else

#define MXDEBUG(args)

#endif /* DEBUG */

#define mxDebug mxFileName = __FILE__, mxLineNo = __LINE__, mxPrintDebug
#define mxError mxFileName = __FILE__, mxLineNo = __LINE__, mxPrintError

/* Variables */
extern unsigned int mxDebugLevel;  /* any level smaller is output */
extern int mxErrNo;                /* output errno and string */
extern int mxDebugInfo;            /* output source and line number */
extern unsigned int mxLineNo;      /* don't touch this, used by macro */
extern char *mxFileName;           /* don't touch this, used by macro */

/* function prototypes */
void mxSetDebugOut(FILE *strm);
void mxSetErrorOut(FILE *strm);

/* don't use these, used by macro */
int mxPrintDebug(const unsigned int debuglevel, const char *fmt, ...);
int mxPrintError(const unsigned int exitflag, const char *fmt, ...);

#endif /* MX_ERROR_H_ */

