/*
 * $Id: mxparser.h,v 1.5 2000/04/17 16:20:46 dirk Exp $
 */

#ifndef MXPARSER_H_
#define MXPARSER_H_

#include <stdio.h>

/* types */
#define T_INT 0
#define T_BOOL 1
#define T_INT_V 2
#define T_INT_M 3
#define T_FLOAT 4
#define T_FLOAT_V 5
#define T_FLOAT_M 6
#define T_DOUBLE 7
#define T_DOUBLE_V 8
#define T_DOUBLE_M 9
#define T_STRING 10
#define T_TREE 11

/* stack depth of include mechanism in scanner */
#define MAX_INCLUDE_DEPTH 10

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE (! FALSE)
#endif


/* extern vars */
extern int line_num[MAX_INCLUDE_DEPTH];
extern char *filenames[MAX_INCLUDE_DEPTH];
extern int include_stack_ptr;
extern char *include_path;

/* prototypes */
int ParseCmd(int, char *[]);
int ParseFile(const char *);

tagvalue_t *AddParmInt(const char *, int);
tagvalue_t *AddParmBool(const char *, int);
tagvalue_t *AddParmIntVec(const char *, int *, int);
tagvalue_t *AddParmIntMat(const char *, int **, int, int);
tagvalue_t *AddParmFloat(const char *, float);

/* Sorry not here yet...
tagvalue_t *AddParmFloatVec(const char *, float *, int);
tagvalue_t *AddParmFloatMat(const char *, float **, int, int);
*/
tagvalue_t *AddParmDouble(const char *, double);
tagvalue_t *AddParmDoubleVec(const char *, double *, int);
tagvalue_t *AddParmDoubleMat(const char *, double **, int, int);
tagvalue_t *AddParmString(const char *, char *);
tagvalue_t *AddParmTree(const char *, node *);

tagvalue_t *  PrintParm(FILE *, tagvalue_t *);
int  PrintAllParms(FILE *);
void ListParm(tagvalue_t *);
void ListAllParms(void);

#endif /* MXPARSER.H */
