/*
 * $Id: mygen.c,v 1.3 1999/05/25 10:12:24 dirk Exp $
 */


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif

/* mypathfind works like libgens pathfind with one minor exception: */
/* empty tokens i.e. "::" are not interpreted as CWD */
/* CWD is used when no path is given ro if it is explicitely provided */
/* .i.e. "." */

char *
mypathfind(const char *path,
	 const char *name,
	 const char *mode)
{
  char * dir;
  static char * tpath = NULL;
  static size_t tpathlen = 0;
  char * tmode;
  static char * result = NULL;
  static size_t resultlen = 0;
  size_t newlen;
  int amode = 0;
  int aflag = 0;
  int stmode = 0;
  int stsize = 0;
  int sflag = 0;
  size_t namelen;
  struct stat buf;


  /* empty name */
  namelen = strlen(name);
  if(namelen < 1)
    return NULL;

  /* Setup setup tpath */
  /* watch out: order of tests is important! */
  if((path == NULL) || (path[0] == '\0')) {
    if(2 > tpathlen) {
      /* need to realloc */
      tpath = (char *) realloc(tpath, 2);
      /* realloc failed? */
      if(tpath == NULL) {
	return NULL;
      }
    }
    sprintf(tpath, ".");
    tpathlen = 2; 
  }
  else {
    newlen = strlen(path)+1;
    if(newlen > tpathlen) {
      /* need to realloc */
      tpath = (char *) realloc(tpath, newlen);
      /* realloc failed? */
      if(tpath == NULL) {
	return NULL;
      }
    }
    strcpy(tpath, path);
    tpathlen = newlen; 
  }

  /* parse mode to find out what needs to be checked */
  if(mode != NULL) {
    for(tmode = (char *)mode; *tmode!= '\0'; tmode++) {
      switch(*tmode) {
      case 'r':
	aflag = 1;
	amode |= R_OK;
	break;
      case 'w':
	aflag = 1;
	amode |= W_OK;
	break;      
      case 'x':
	aflag = 1;
	amode |= X_OK;
	break;      
      case 'f':
	sflag = 1;
	stmode |= S_IFREG;
	break;
      case 'b':
	sflag = 1;
	stmode |= S_IFBLK;
	break;
      case 'c':
	sflag = 1;
	stmode |= S_IFCHR;
	break;
      case 'd':
	sflag = 1;
	stmode |= S_IFDIR;
	break;
      case 'p':
	sflag = 1;
	stmode |= S_IFIFO;
	break;
      case 'u':
	sflag = 1;
	stmode |= S_ISUID;
	break;
      case 'g':
	sflag = 1;
	stmode |= S_ISGID;
	break;
      case 'k':
	sflag = 1;
	stmode |= S_ISVTX;
	break;
      case 's':
	sflag = 1;
	stsize = 1;
	break;
      default:
	break; /* nothing */
      }
    } 
  }

  /* iterate until a file is found matching modes */
  dir = strtok(tpath,":");

  while(dir != NULL) {

    newlen = strlen(dir)+ namelen + 2;
    if(newlen > resultlen) {
      /* need to realloc */
      result = (char *) realloc(result, newlen);
      /* realloc failed? */
      if(result == NULL) {
	/* return NULL */
	break;
      }
      resultlen = newlen; 
    }
 
    /* concatenate path and name */
    sprintf(result, "%s/%s", dir, name);

    if(aflag) {
      if(-1 == access(result, amode)) {
	/* no access or error */
	if(errno == EINTR) /* if signal was caught try again */
	  continue;
	else
	  goto NEXT; /* everything else is either a not recoverable error
			or no permission */
      }
    }
    if(sflag) {
      if(-1 == stat(result, &buf)) {
	/* no access or error */
	if(errno == EINTR) /* if signal was caught try again */
	  continue;
	else
	  goto NEXT; /* everything else is either a not recoverable error
			or no permission */
      }
      else {
	/* stat success */
	if((stmode & buf.st_mode) != stmode) {
	  /* mode failure */
	  goto NEXT;
	}
	if(stsize) {
	  /* check nonzero file size */
	  if(buf.st_size == (off_t)0) {
	    goto NEXT;
	  }
	}
      }
    }

    /* success! Return the result */
    /* truncate possibly leading "./" */
    if((result[0] == '.') && (result[1] == '/'))
      return &(result[2]);
    else
      return result;
    
  NEXT:
    dir = strtok(NULL, ":");
  }
  
  return NULL;
}
