%{

/*
 * $Id: parser.b,v 1.6 2000/04/14 19:43:45 dirk Exp $
 */

/* #define DEBUG */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include "mxerror.h"
#include "global.h"
#include "mxparser.h"

/* Be verbose in the error string */
#define YYERROR_VERBOSE 1

/* defines */  

#define size(ptr,size,type) \
if(((ptr) = (type *)malloc((size) * sizeof(type))) == NULL) \
mxError(DO_EXIT, "malloc failed");

#define resize(ptr,size,type) \
if((ptr) == NULL) { \
if(((ptr) = (type *)malloc((size) * sizeof(type))) == NULL) \
mxError(DO_EXIT, "malloc failed"); \
} else { \
if(((ptr) = (type *)realloc((ptr), (size) * sizeof(type))) == NULL) \
mxError(DO_EXIT, "realloc failed"); }

/* external variables */
extern char yytext[];
extern FILE * yyin;

/* prototypes */
tagvalue_t *find_tag(const char *str);
void repointer(node *father, node *son);

int yylex(void);
int yyerror (char * s);

/* global variables */
size_t   counter = 0;
size_t  mcounter = 0;
size_t  tcounter = 0;
int     i = 0;
int     j = 0;

int pc = 0;

/*********************************************************/
tagvalue_t pp[100]; /* Big hack for the moment only !!!! */
/*********************************************************/

%}

%expect 0 /* expect 0 shift/reduce conflicts in the tree grammar */

/* BISON Declarations */

%union {
  double    dval;  /* For returning numbers.          */
  int       ival;  /* For returning integers.         */
  char      cval;  /* For returning characters.       */
  char   *  sval;  /* For returning strings.          */
  int    *  iptr;  /* For returning integer vectors.  */
  double *  dptr;  /* For returning double vectors.   */
  int    ** ihdl;  /* For returning integer matrices. */
  double ** dhdl;  /* For returning integer matrices. */
  node   *  nptr;  /* For returning tree nodes.       */
} 


%token <dval> DNUM
%token <ival> INUM
%token <sval> STRING
%token <cval> EQ
%token        END
%token <sval> ID
%token <ival> BOOLEAN
%token <cval> ROBRACE
%token <cval> RCBRACE
%token <cval> OBRACE
%token <cval> CBRACE

%type <iptr> ivector
%type <iptr> iseq
%type <ihdl> imat
%type <ihdl> imatrix
%type <dptr> dvector
%type <dptr> dseq
%type <dhdl> dmat
%type <dhdl> dmatrix
%type <nptr> node
%type <nptr> nodevector
%type <nptr> tree

%%

input:
  /* empty */
| input statement
;

statement:

END
{
  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: END aka EOF");
  line_num[include_stack_ptr+1] = 1;
  free(filenames[include_stack_ptr+1]);
  filenames[include_stack_ptr+1] = NULL;
}

| ID EQ STRING
{
  tagvalue_t *t;

  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: ID: %s String: <%s>" MXDELIM $1 MXDELIM $3);

   if((t = find_tag($1))) {
     if(t->typ==T_STRING) {
      t->value.s = $3;
      t->dim[0] = strlen($3);
     }
    else
      mxError(DO_EXIT, "parser:type mismatch for tag:<%s>", $1);
  }
  else
    mxError(DO_EXIT, "parser:tag not found:<%s>", $1);

  free($1);
}

| ID EQ DNUM
{
  tagvalue_t *t;

  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: ID: %s Float: %f" MXDELIM $1 MXDELIM $3);

  if((t = find_tag($1)))
    switch(t->typ) {
    case T_FLOAT:
      t->value.f = (float) $3;
      break;
    case T_DOUBLE:
      t->value.d = $3;
	break;
    default:
      mxError(DO_EXIT, "parser:type mismatch for tag:<%s>", $1);
    }
  /*    if(t->typ==T_FLOAT)
	t->value.f = $3;
	else
	mxError(DO_EXIT, "parser:type mismatch for tag:<%s>", $1); */
  else
    mxError(DO_EXIT, "parser:tag not found:<%s>", $1);

  free($1);
}

| ID EQ INUM
{
  tagvalue_t *t;

  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: ID: %s Int: %d" MXDELIM $1 MXDELIM $3);

  if((t = find_tag($1))) {
    if(t->typ==T_INT)
      t->value.i = $3;
    else
      mxError(DO_EXIT, "parser:type mismatch for tag:<%s>", $1);
  }
  else
    mxError(DO_EXIT, "parser:tag not found:<%s>", $1);

  free($1);
}

| ID EQ BOOLEAN
{
  tagvalue_t *t;

  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: ID: %s Bool: %d" MXDELIM $1 MXDELIM $3);

  if((t = find_tag($1))) {
    if(t->typ==T_BOOL)
      t->value.i = $3;
    else
      mxError(DO_EXIT, "parser:type mismatch for tag:<%s>", $1);
  }
  else
    mxError(DO_EXIT, "parser:tag not found:<%s>", $1);

  free($1);
}

| ID OBRACE INUM CBRACE EQ ivector
{ 
  tagvalue_t *t;

  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: ID: %s Ivector" MXDELIM $1);
  /* for(i=0;i<counter;i++)
    fprintf(stderr, "[%d] %d\n", i, $3[i]); */
  if(counter == $3) {
    if((t = find_tag($1))) {
      if(t->typ==T_INT_V) {
	t->value.iv = $6;
	t->dim[0] = counter;
      }
      else
	mxError(DO_EXIT, "parser:type mismatch for tag:<%s>", $1);
    }
    else
      mxError(DO_EXIT, "parser:tag not found:<%s>", $1);
  }
  else
    mxError(DO_EXIT, "parser:wrong dimension for tag:<%s>", $1);

  free($1);
}

| ID EQ ivector
{
  tagvalue_t *t;

  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: ID: %s Ivector" MXDELIM $1);
  /* for(i=0;i<counter;i++)
    fprintf(stderr, "[%d] %d\n", i, $3[i]); */

  if((t = find_tag($1))) {
    if(t->typ==T_INT_V) {
      t->value.iv = $3;
      t->dim[0] = counter;
    }
    else
      mxError(DO_EXIT, "parser:type mismatch for tag:<%s>", $1);
  }
  else
    mxError(DO_EXIT, "parser:tag not found:<%s>", $1);


  free($1);
}

| ID EQ dvector
{
  tagvalue_t *t;

  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: ID: %s Dvector" MXDELIM $1);
  /*  for(i=0;i<counter;i++)
    fprintf(stderr, "[%d] %f\n", i, $3[i]); */

  if((t = find_tag($1))) {
    if(t->typ==T_DOUBLE_V) {
      t->value.dv = $3;
      t->dim[0] = counter;
    }
    else
      mxError(DO_EXIT, "parser:type mismatch for tag:<%s>", $1);
  }
  else
    mxError(DO_EXIT, "parser:tag not found:<%s>", $1);

  free($1);
}

| ID EQ imatrix
{
  tagvalue_t *t;

  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: ID: %s Imatrix" MXDELIM $1);
  /*for(i=0;i<counter;i++)
    fprintf(stderr, "[%d] %f\n", i, dptr[i]);*/

  if((t = find_tag($1))) {
    if(t->typ==T_INT_M) {
      t->value.im = $3;
      t->dim[0] = mcounter;
      t->dim[1] = counter;
    }
    else
      mxError(DO_EXIT, "parser:type mismatch for tag:<%s>", $1);
  }
  else
    mxError(DO_EXIT, "parser:tag not found:<%s>", $1);

  free($1);
}

| ID EQ dmatrix
{
  tagvalue_t *t;

  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: ID: %s Dmatrix" MXDELIM $1);
  /*for(i=0;i<mcounter;i++)
    for(j=0;j<counter;j++)    
      fprintf(stderr, "[%d][%d] %f\n", i, j, $3[i][j]); */

  if((t = find_tag($1))) {
    if(t->typ==T_DOUBLE_M) {
      t->value.dm = $3;
      t->dim[0] = mcounter;
      t->dim[1] = counter;
    }
    else
      mxError(DO_EXIT, "parser:type mismatch for tag:<%s>", $1);
  }
  else
    mxError(DO_EXIT, "parser:tag not found:<%s>", $1);

  free($1);
}

| ID EQ tree
{
  tagvalue_t *t;
  node *n;

  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: Tree");

  size(n, 1, node);

  memset(n, 0, sizeof(node));

  n->father = NULL;
  n->brother = NULL;
  n->childs = $3;
  n->distance = 0.0; /* null node */
  n->number = ++tcounter;
  n->Name = $1;

  repointer(NULL, n);

  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: Node ID: %s Dist: %f" MXDELIM
	  n->Name MXDELIM n->distance);
  
  /*print_tree(n, 0);*/

  if((t = find_tag($1))) {
    if(t->typ==T_TREE)
      t->value.t = n;
    else
      mxError(DO_EXIT, "parser:type mismatch for tag:<%s>", $1);
  }
  else
    mxError(DO_EXIT, "parser:tag not found:<%s>", $1);

  tcounter = 0;

}
;

tree:

ROBRACE nodevector RCBRACE
{
  /*node *n;*/
  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: ( vector )");

  /*
  for(n=$2;n!=NULL;n=n->brother)
    fprintf(stderr, "node: %s\n", n->Name);
    */
  $$ = $2;
 
}
;


nodevector:

node
{
    MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: node");
    $$ = $1;
    MXDEBUG(DB_DEBUG-1 MXDELIM "->Bison: node");
}

| nodevector node
{
    MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: vector node");
    $2->brother = $1;
    $$ = $2;
}
;

node:

tree
{
  size($$, 1, node);

  memset($$, 0, sizeof(node));

  $$->father = NULL;
  $$->brother = NULL;
  $$->childs = $1;

  $$->distance = DEFAULT_DIST;
  $$->number = ++tcounter;
  size($$->Name, SEQUENCE_ID_LENGTH, char);
  sprintf($$->Name, "%s%d", SEQUENCE_IDENTIFIER, (int)tcounter);

  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: Node ID: %s Dist: %f" MXDELIM
	  $$->Name MXDELIM $$->distance);
}

| tree EQ DNUM
{
  size($$, 1, node);

  memset($$, 0, sizeof(node));

  $$->father = NULL;
  $$->brother = NULL;
  $$->childs = $1;


  $$->distance = $3;
  $$->number = ++tcounter;
  size($$->Name, SEQUENCE_ID_LENGTH, char);
  sprintf($$->Name, "%s%d", SEQUENCE_IDENTIFIER, (int)tcounter);

  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: Node ID: %s Dist: %f" MXDELIM
	  $$->Name MXDELIM $$->distance);
}

| tree EQ INUM
{
  size($$, 1, node);

  memset($$, 0, sizeof(node));

  $$->father = NULL;
  $$->brother = NULL;
  $$->childs = $1;

  $$->distance = (double)$3;
  $$->number = ++tcounter;
  size($$->Name, SEQUENCE_ID_LENGTH, char);
  sprintf($$->Name, "%s%d", SEQUENCE_IDENTIFIER, (int)tcounter);

  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: Node ID: %s Dist: %f" MXDELIM
	  $$->Name MXDELIM $$->distance);
}


| ID
{
  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: Node ID: %s" MXDELIM $1);

  size($$, 1, node);

  memset($$, 0, sizeof(node));

  $$->father = NULL;
  $$->brother = NULL;
  $$->childs = NULL;

  $$->Name = $1;
  $$->distance = DEFAULT_DIST;
  $$->number = ++tcounter;

}

| ID EQ DNUM
{
  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: Node ID: %s Dist: %f" MXDELIM
	  $1 MXDELIM $3);

  size($$, 1, node);

  memset($$, 0, sizeof(node));

  $$->father = NULL;
  $$->brother = NULL;
  $$->childs = NULL;


  $$->Name = $1;
  $$->distance = $3;
  $$->number = ++tcounter;
}

| ID EQ INUM
{
  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: Node ID: %s Dist: %d" MXDELIM
	  $1 MXDELIM $3);

  size($$, 1, node);

  memset($$, 0, sizeof(node));

  $$->father = NULL;
  $$->brother = NULL;
  $$->childs = NULL;

  $$->Name = $1;
  $$->distance = (double)$3;
  $$->number = ++tcounter;
}
;

dmatrix: OBRACE dmat CBRACE { $$ = $2; };

dmat:

dmat dvector
{
  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: DM:");
  resize($$, ++mcounter, double *);
  $$[mcounter-1] = $2;
}

| dvector
{
  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: DM:");
  $$=NULL;
  mcounter=1;
  resize($$, mcounter, double *);
  $$[0] = $1;  
}
;

imatrix: OBRACE imat CBRACE { $$ = $2; };

imat:

imat ivector
{
  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: M:");
  resize($$, ++mcounter, int *);
  $$[mcounter-1] = $2;
}

| ivector
{
  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: M:");
  $$=NULL;
  mcounter=1;
  resize($$, mcounter, int *);
  $$[0] = $1;  
}
;

ivector: OBRACE iseq CBRACE {$$ = $2;};

dvector: OBRACE dseq CBRACE {$$ = $2;};

dseq:

dseq DNUM
{
  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: V: %f" MXDELIM $2);
  resize($$, ++counter, double);
  $$[counter-1] = $2;
}

| dseq INUM
{
  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: V: %f" MXDELIM $2);
  resize($$, ++counter, double);
  $$[counter-1] = (double)$2;
} 

| DNUM
{
  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: V: %f" MXDELIM $1);
  $$=NULL;
  counter=1;
  resize($$, counter, double);
  $$[0] = $1;
}
;

iseq:

iseq INUM
{
  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: V: %d" MXDELIM $2);
  resize($$, ++counter, int);
  $$[counter-1] = $2;
}

| INUM {
  MXDEBUG(DB_DEBUG-1 MXDELIM "Bison: V: %d" MXDELIM $1);
  $$=NULL;
  counter = 1;
  resize($$, counter, int);
  $$[0] = $1;
}
;

%%
