#!/usr/bin/perl -w
#extract_phylipmsa.pl

use strict;
use Class::Struct;

use vars qw ();  # required if strict used
use Getopt::Std;

getopts ('');


# Print a helpful message if the user provides no input file.
if (!@ARGV) {
        print "usage:  extract_phylipmsa.pl [options] num msafile\n\n";
        print "options:\n";
       exit;
}
my $num = shift;
my $msafile = shift;

parse_phylipmsa($num, $msafile);


# subroutines
sub parse_phylipmsa {
    my ($num, $phylipmsafile) = @_;

    my $aseq;
    my $alen;
    my $nali = 0;

    my $isfirstblock = 1;

    open(MSA, $phylipmsafile);
    while(<MSA>) {
	if (/\s*(\d+)\s+(\d+)/) {
	    $nali ++;

	    $aseq = $1;
	    $alen = $2;

	    if ($nali == $num) { print $_; }
	}
	else {
	    if ($nali == $num) { print $_; }
	}
   }
    close (MSA);

    if ($nali < $num) { print "this file contains only $nali alignments\n"; die; }

}
