#!/usr/bin/perl -w
#permute_msa.pl

use strict;
use Class::Struct;

use vars qw ($opt_p);  # required if strict used
use Getopt::Std;

getopts ('p');


# Print a helpful message if the user provides no input file.
if (!@ARGV) {
        print "usage:  permute_msa.pl [options] msafile\n\n";
        print "options:\n";
        print "-p :  print the alignment\n";
       exit;
}
my $msafile = shift;
my $permutation = "1,8,3,2,4,5,6,7";

permute_msa($msafile, $permutation);

# subroutines
sub permute_msa {
    my ($phylipmsafile, $permutation) = @_;
    
    my @msa;
    my @name;

    my $aseq;
    my $alen;

    my $n = 0;
    my $name;

    my $isfirstblock;

    open(MSA, $phylipmsafile);
    while(<MSA>) {
	if (/\s*(\d+)\s+(\d+)/) {
	    $isfirstblock = 1;
	    $aseq = $1;
	    $alen = $2;

	    #initialize
	    for (my $s = 0; $s < $aseq; $s ++) { $msa[$s] = ""; }
	}
	elsif (/\s*\S+/) {
	    my $line = $_;

	    if ($isfirstblock) {
		$line =~ s/^(.{10})//; $name = $1;
		$name[$n] = $name; 
	    }
	     
	    $line =~ s/ //g;
	    $line =~ s/\n//g;

	    $msa[$n++] .= $line; 
	   
	}
	elsif (/^\s+$/) {
	    $isfirstblock = 0;
	    if ($n != $aseq) { print "bad alignment $aseq $n\n"; die; }
	    $n = 0;
	}
    }

    close (MSA);

    my @perm = split(",", $permutation);
    if ($#perm+1 != $aseq) { print "bad permutation\n"; die; }

    my @permsa;
    my @pername;
     for (my $s = 0; $s < $aseq; $s ++) { $permsa[$s] = $msa[$perm[$s]-1] ; $pername[$s] = $name[$perm[$s]-1] ; }

    print_phylip_msa(\@permsa, \@pername, $alen, $aseq);
}
   
sub print_phylip_msa {
    my ($msa_ref, $name_ref, $alen, $aseq) = @_;

    my $line;

    print "\t$aseq\t$alen\n";

    for (my $s = 0; $s < $aseq; $s ++) {
	print "$name_ref->[$s]";
	$msa_ref->[$s] =~ s/^(.{60})//; $line = $1;
	print "$line\n";
    }
    print "\n";

    while (length($msa_ref->[0]) >= 60) {
	for (my $s = 0; $s < $aseq; $s ++) {
	    $msa_ref->[$s] =~ s/^(.{60})//; $line = $1;
	    print "$line\n";
	}
	print "\n";
    }
    for (my $s = 0; $s < $aseq; $s++) {
	print "$msa_ref->[$s]\n";
    }
   
}
