#!/usr/bin/perl -w
#plot_boostrap_averages.pl

use strict;
use Class::Struct;

use vars qw ($opt_b $opt_s);  # required if strict used
use Getopt::Std;
use constant GNUPLOT => '/usr/bin/gnuplot';
getopts ('b:s');


# Print a helpful message if the user provides no input file.
if (!@ARGV) {
        print "usage:  plot_boostrap_averages.pl [options] N msa trial boot which\n\n";
        print "options:\n";
	print "-b <num> :  number of boostraps [ default given in the filename]\n";
	print "-s       :  see the plots\n";
	exit;
}

my $N     = shift;
my $root  = shift;
my $trial = shift;
my $boot  = shift;
my $which = shift;
my @avefile;
my @savefile;

for (my $n = 0; $n < $N; $n ++) {
    if ($N == 1) { 
	$avefile[$n]  = "$trial/$root.$which.$trial.boot$boot.averages";  
	$savefile[$n] = "$trial/$root.$which.$trial.boot$boot.consense.consense.averages"; 
    }
    else {
	if    ($n == 0) { 
	    $avefile[$n]  = "$trial/$root.dnaml.$trial.boot$boot.averages"; 
	    $savefile[$n] = "$trial/$root.dnaml.$trial.boot$boot.consense.consense.averages"; 
	}
	elsif ($n == 1) { 
	    $avefile[$n]  = "$trial/$root.dnaml-erate.$trial.boot$boot.averages"; 
	    $savefile[$n] = "$trial/$root.dnaml-erate.$trial.boot$boot.consense.consense.averages"; 
	}
	elsif ($n == 2) { 
	    $avefile[$n]  = "$trial/$root.dnaml-erate.C.$trial.boot$boot.averages"; 
	    $savefile[$n] = "$trial/$root.dnaml-erate.C.$trial.boot$boot.consense.consense.averages"; 
	}
    }
}

my $seeplots = 0;
if ($opt_s) { $seeplots = 1; }

my @nboot;
my @key1;
my @key2;
my @title1;
my @title2;
my $xlabel;

my @boothistofile;
my @sboothistofile;

#plots respect to frequency of indels
my @bootfofile;
my @sbootfofile;
my @likefofile;
my @slikefofile;
my @ablfofile;
my @sablfofile;
my @alpfofile;
my @salpfofile;
my @betfofile;
my @sbetfofile;
my @insfofile;
my @sinsfofile;
my @delfofile;
my @sdelfofile;
my @ipfofile;
my @sipfofile;
my @apbfofile;
my @sapbfofile;
my @lpmfofile;
my @slpmfofile;
my @lomfofile;
my @slomfofile;
my @frsfofile;
my @sfrsfofile;
my @frcfofile;
my @sfrcfofile;
my @ttrfofile;
my @sttrfofile;
my @timefofile;
my @stimefofile;
my @mutfofile;
my @smutfofile;

#plots respect to geometric mean of sequences lengths
my @bootsqlgfile;
my @sbootsqlgfile;
my @likesqlgfile;
my @slikesqlgfile;
my @ablsqlgfile;
my @sablsqlgfile;
my @alpsqlgfile;
my @salpsqlgfile;
my @betsqlgfile;
my @sbetsqlgfile;
my @inssqlgfile;
my @sinssqlgfile;
my @delsqlgfile;
my @sdelsqlgfile;
my @ipsqlgfile;
my @sipsqlgfile;
my @apbsqlgfile;
my @sapbsqlgfile;
my @lpmsqlgfile;
my @slpmsqlgfile;
my @lomsqlgfile;
my @slomsqlgfile;
my @frssqlgfile;
my @sfrssqlgfile;
my @frcsqlgfile;
my @sfrcsqlgfile;
my @ttrsqlgfile;
my @sttrsqlgfile;
my @timesqlgfile;
my @stimesqlgfile;
my @mutsqlgfile;
my @smutsqlgfile;

my $Nb = 1;
my $kb = 100;
my $Nf = 1;
my $kf = 300;
my $Nl = 5000;
my $kl = 1/5;

for (my $n = 0; $n < $N; $n ++) {
    parse_averagesfile($avefile[$n], \$title1[$n], \$key1[$n],
		       $Nb, $kb, $Nf, $kf, $Nl, $kl,
		       \$boothistofile[$n],  
		       \$bootfofile[$n],   \$likefofile[$n], 
		       \$ablfofile[$n],    \$alpfofile[$n],  
		       \$betfofile[$n],    \$insfofile[$n],  
		       \$delfofile[$n],    \$ipfofile[$n],   
		       \$apbfofile[$n],    \$lpmfofile[$n],  
		       \$lomfofile[$n],    \$frsfofile[$n],  
		       \$frcfofile[$n],    \$ttrfofile[$n], 
		       \$timefofile[$n],   \$mutfofile[$n], 
		       \$bootsqlgfile[$n], \$likesqlgfile[$n], 
		       \$ablsqlgfile[$n],  \$alpsqlgfile[$n],  
		       \$betsqlgfile[$n],  \$inssqlgfile[$n],  
		       \$delsqlgfile[$n],  \$ipsqlgfile[$n],   
		       \$apbsqlgfile[$n],  \$lpmsqlgfile[$n],  
		       \$lomsqlgfile[$n],  \$frssqlgfile[$n],  
		       \$frcsqlgfile[$n],  \$ttrsqlgfile[$n], 
		       \$timesqlgfile[$n], \$mutsqlgfile[$n]);
    parse_averagesfile($savefile[$n], \$title2[$n], \$key2[$n],
		       $Nb, $kb, $Nf, $kf, $Nl, $kl,
		       \$sboothistofile[$n],  
		       \$sbootfofile[$n],   \$slikefofile[$n], 
		       \$sablfofile[$n],    \$salpfofile[$n],  
		       \$sbetfofile[$n],    \$sinsfofile[$n],  
		       \$sdelfofile[$n],    \$sipfofile[$n],   
		       \$sapbfofile[$n],    \$slpmfofile[$n],  
		       \$slomfofile[$n],    \$sfrsfofile[$n],  
		       \$sfrcfofile[$n],    \$sttrfofile[$n], 
		       \$stimefofile[$n],   \$smutfofile[$n], 
		       \$sbootsqlgfile[$n], \$slikesqlgfile[$n], 
		       \$sablsqlgfile[$n],  \$salpsqlgfile[$n],  
		       \$sbetsqlgfile[$n],  \$sinssqlgfile[$n],  
		       \$sdelsqlgfile[$n],  \$sipsqlgfile[$n],   
		       \$sapbsqlgfile[$n],  \$slpmsqlgfile[$n],  
		       \$slomsqlgfile[$n],  \$sfrssqlgfile[$n],  
		       \$sfrcsqlgfile[$n],  \$sttrsqlgfile[$n], 
		       \$stimesqlgfile[$n], \$smutsqlgfile[$n]);
}

my $bootfofilediff;
my $key2_diff;
my $key3_diff;
create_diff_histo($Nf, $kf, \$bootfofilediff, "$trial//bootfo", $N, \@avefile, \$key2_diff, \$key3_diff);


############
# plotting
#############
gnuplot_histo($N, $Nb/$kb, \@boothistofile,  $root, $title1[0], \@key1, "$trial/boothisto",     1);
gnuplot_histo($N, $Nb/$kb, \@sboothistofile, $root, $title2[0], \@key2, "$trial/consboothisto", 1);

$xlabel = "AVERAGE FRACTION TOTAL INDELS";
my $seefoplot = 1;
gnuplot_fo_histo($N, 1/$kf, \@bootfofile,      $root, $title1[0], \@key1, "$trial/bootfo",       $xlabel,    "AVERAGE BOOSTRAP FRACTION",             $seefoplot, $seefoplot);
gnuplot_fo_histo($N, 1/$kf, \@sbootfofile,     $root, $title2[0], \@key2, "$trial/consbootfo",   $xlabel,    "AVERAGE BOOSTRAP FRACTION",             0, 0);
gnuplot_fo_histo($N, 1/$kf, \@likefofile,      $root, $title1[0], \@key1, "$trial/likefo",       $xlabel,    "AVERAGE LIKELIHOOD",                    $seefoplot, 0);
gnuplot_fo_histo($N, 1/$kf, \@slikefofile,     $root, $title2[0], \@key2, "$trial/conslikefo",   $xlabel,    "AVERAGE LIKELIHOOD",                    0, 0);
gnuplot_fo_histo($N, 1/$kf, \@ablfofile,       $root, $title1[0], \@key1, "$trial/ablfo",        $xlabel,    "AVERAGE BRANCH LENGTH",                 $seefoplot, 0);
gnuplot_fo_histo($N, 1/$kf, \@sablfofile,      $root, $title2[0], \@key2, "$trial/consablfo",    $xlabel,    "AVERAGE BRANCH LENGTH",                 0, 0);
gnuplot_fo_histo($N, 1/$kf, \@alpfofile,       $root, $title1[0], \@key1, "$trial/alpfo",        $xlabel,    "AVERAGE ALPHA",                         $seefoplot, 0);
gnuplot_fo_histo($N, 1/$kf, \@salpfofile,      $root, $title2[0], \@key2, "$trial/consalpfo",    $xlabel,    "AVERAGE ALPHA",                         0, 0);
gnuplot_fo_histo($N, 1/$kf, \@betfofile,       $root, $title1[0], \@key1, "$trial/betfo",        $xlabel,    "AVERAGE BETA",                          $seefoplot, 0);
gnuplot_fo_histo($N, 1/$kf, \@sbetfofile,      $root, $title2[0], \@key2, "$trial/consbetfo",    $xlabel,    "AVERAGE BETA",                          0, 0);
gnuplot_fo_histo($N, 1/$kf, \@insfofile,       $root, $title1[0], \@key1, "$trial/insfo",        $xlabel,    "AVERAGE INSERTIONS RATE",               $seefoplot, 0);
gnuplot_fo_histo($N, 1/$kf, \@sinsfofile,      $root, $title2[0], \@key2, "$trial/consinsfo",    $xlabel,    "AVERAGE INSERTIONS RATE",               0, 0);
gnuplot_fo_histo($N, 1/$kf, \@delfofile,       $root, $title1[0], \@key1, "$trial/delfo",        $xlabel,    "AVERAGE DELETIONS RATE",                $seefoplot, 0);
gnuplot_fo_histo($N, 1/$kf, \@sdelfofile,      $root, $title2[0], \@key2, "$trial/consdelfo",    $xlabel,    "AVERAGE DELETIONS RATE",                0, 0);
gnuplot_fo_histo($N, 1/$kf, \@ipfofile,        $root, $title1[0], \@key1, "$trial/ipfo",         $xlabel,    "AVERAGE INDEL PRIOR",                   0, 0, "x");
gnuplot_fo_histo($N, 1/$kf, \@sipfofile,       $root, $title2[0], \@key2, "$trial/consipfo",     $xlabel,    "AVERAGE INDEL PRIOR",                   0, 0, "x");
gnuplot_fo_histo($N, 1/$kf, \@apbfofile,       $root, $title1[0], \@key1, "$trial/apbfo",        $xlabel,    "AVERAGE ALPHA + BETA",                  0, 0, "1");
gnuplot_fo_histo($N, 1/$kf, \@sapbfofile,      $root, $title2[0], \@key2, "$trial/consapbfo",    $xlabel,    "AVERAGE ALPHA + BETA",                  0, 0, "1");
gnuplot_fo_histo($N, 1/$kf, \@lpmfofile,       $root, $title1[0], \@key1, "$trial/lpmfo",        $xlabel,    "AVERAGE INS + DEL",                     $seefoplot, 0, "x");
gnuplot_fo_histo($N, 1/$kf, \@slpmfofile,      $root, $title2[0], \@key2, "$trial/conslpmfo",    $xlabel,    "AVERAGE INS + DEL",                     0, 0, "x");
gnuplot_fo_histo($N, 1/$kf, \@lomfofile,       $root, $title1[0], \@key1, "$trial/lomfo",        $xlabel,    "AVERAGE DEL over INS",                  0, 0);
gnuplot_fo_histo($N, 1/$kf, \@slomfofile,      $root, $title2[0], \@key2, "$trial/conslomfo",    $xlabel,    "AVERAGE DEL over INS",                  0, 0);
gnuplot_fo_histo($N, 1/$kf, \@frsfofile,       $root, $title1[0], \@key1, "$trial/frsfo",        $xlabel,    "AVERAGE SUBS CHANGE",                   0, 0);
gnuplot_fo_histo($N, 1/$kf, \@sfrsfofile,      $root, $title2[0], \@key2, "$trial/consfrsfo",    $xlabel,    "AVERAGE SUBS CHANGE",                   0, 0);
gnuplot_fo_histo($N, 1/$kf, \@frcfofile,       $root, $title1[0], \@key1, "$trial/frcfo",        $xlabel,    "AVERAGE TOTAL CHANGE",                  0, 0);
gnuplot_fo_histo($N, 1/$kf, \@sfrcfofile,      $root, $title2[0], \@key2, "$trial/consfrcfo",    $xlabel,    "AVERAGE TOTAL CHANGE",                  0, 0);
gnuplot_fo_histo($N, 1/$kf, \@ttrfofile,       $root, $title1[0], \@key1, "$trial/ttrfo",        $xlabel,    "AVERAGE TRANSITION-TRANSVERSION RATIO", $seefoplot, 0);
gnuplot_fo_histo($N, 1/$kf, \@sttrfofile,      $root, $title2[0], \@key2, "$trial/consttrfo",    $xlabel,    "AVERAGE TRANSITION-TRANSVERSION RATIO", 0, 0);
gnuplot_fo_histo($N, 1/$kf, \@timefofile,      $root, $title1[0], \@key1, "$trial/timefo",       $xlabel,    "AVERAGE TIME (secs)",                   $seefoplot, 0);
gnuplot_fo_histo($N, 1/$kf, \@stimefofile,     $root, $title2[0], \@key2, "$trial/constimefo",   $xlabel,    "AVERAGE TIME (secs)",                   0, 0);
gnuplot_fo_histo($N, 1/$kf, \@mutfofile,       $root, $title1[0], \@key1, "$trial/mutfo",        $xlabel,    "AVERAGE % PAIRWISE MUTATIONS",          0, 0);
gnuplot_fo_histo($N, 1/$kf, \@smutfofile,      $root, $title2[0], \@key2, "$trial/consmutfo",    $xlabel,    "AVERAGE % PAIRWISE MUTATIONS",          0, 0);

# the difference histograms
gnuplot_diff_histo   (1/$kf, $bootfofilediff,  $root, $title1[0], $key2_diff, $key3_diff, $xlabel,    "AVERAGE BOOSTRAP DIFFERENCE FRACTION",  $seefoplot, "0");

$xlabel = "AVERAGE GEOMETRIC MEAN SEQS LENGTH";
my $seesqlgplot = 0;
gnuplot_fo_histo($N, 1/$kl, \@bootsqlgfile,    $root, $title1[0], \@key1, "$trial/bootsqlg",       $xlabel,    "AVERAGE BOOSTRAP FRACTION",             $seesqlgplot, 0);
gnuplot_fo_histo($N, 1/$kl, \@sbootsqlgfile,   $root, $title2[0], \@key2, "$trial/consbootsqlg",   $xlabel,    "AVERAGE BOOSTRAP FRACTION",             0,            0);
gnuplot_fo_histo($N, 1/$kl, \@likesqlgfile,    $root, $title1[0], \@key1, "$trial/likesqlg",       $xlabel,    "AVERAGE LIKELIHOOD",                    $seesqlgplot, 0);
gnuplot_fo_histo($N, 1/$kl, \@slikesqlgfile,   $root, $title2[0], \@key2, "$trial/conslikesqlg",   $xlabel,    "AVERAGE LIKELIHOOD",                    0,            0);
gnuplot_fo_histo($N, 1/$kl, \@ablsqlgfile,     $root, $title1[0], \@key1, "$trial/ablsqlg",        $xlabel,    "AVERAGE BRANCH LENGTH",                 $seesqlgplot, 0);
gnuplot_fo_histo($N, 1/$kl, \@sablsqlgfile,    $root, $title2[0], \@key2, "$trial/consablsqlg",    $xlabel,    "AVERAGE BRANCH LENGTH",                 0,            0);
gnuplot_fo_histo($N, 1/$kl, \@alpsqlgfile,     $root, $title1[0], \@key1, "$trial/alpsqlg",        $xlabel,    "AVERAGE ALPHA",                         $seesqlgplot, 0);
gnuplot_fo_histo($N, 1/$kl, \@salpsqlgfile,    $root, $title2[0], \@key2, "$trial/consalpsqlg",    $xlabel,    "AVERAGE ALPHA",                         0,            0);
gnuplot_fo_histo($N, 1/$kl, \@betsqlgfile,     $root, $title1[0], \@key1, "$trial/betsqlg",        $xlabel,    "AVERAGE BETA",                          $seesqlgplot, 0);
gnuplot_fo_histo($N, 1/$kl, \@sbetsqlgfile,    $root, $title2[0], \@key2, "$trial/consbetsqlg",    $xlabel,    "AVERAGE BETA",                          0,            0);
gnuplot_fo_histo($N, 1/$kl, \@inssqlgfile,     $root, $title1[0], \@key1, "$trial/inssqlg",        $xlabel,    "AVERAGE INSERTIONS RATE",               $seesqlgplot, 0);
gnuplot_fo_histo($N, 1/$kl, \@sinssqlgfile,    $root, $title2[0], \@key2, "$trial/consinssqlg",    $xlabel,    "AVERAGE INSERTIONS RATE",               0,            0);
gnuplot_fo_histo($N, 1/$kl, \@delsqlgfile,     $root, $title1[0], \@key1, "$trial/delsqlg",        $xlabel,    "AVERAGE DELETIONS RATE",                $seesqlgplot, 0);
gnuplot_fo_histo($N, 1/$kl, \@sdelsqlgfile,    $root, $title2[0], \@key2, "$trial/consdelsqlg",    $xlabel,    "AVERAGE DELETIONS RATE",                0,            0);
gnuplot_fo_histo($N, 1/$kl, \@ipsqlgfile,      $root, $title1[0], \@key1, "$trial/ipsqlg",         $xlabel,    "AVERAGE INDEL PRIOR",                   $seesqlgplot, 0);
gnuplot_fo_histo($N, 1/$kl, \@sipsqlgfile,     $root, $title2[0], \@key2, "$trial/consipsqlg",     $xlabel,    "AVERAGE INDEL PRIOR",                   0,            0);
gnuplot_fo_histo($N, 1/$kl, \@apbsqlgfile,     $root, $title1[0], \@key1, "$trial/apbsqlg",        $xlabel,    "AVERAGE ALPHA + BETA",                  $seesqlgplot, 0, "1");
gnuplot_fo_histo($N, 1/$kl, \@sapbsqlgfile,    $root, $title2[0], \@key2, "$trial/consapbsqlg",    $xlabel,    "AVERAGE ALPHA + BETA",                  0,            0, "1");
gnuplot_fo_histo($N, 1/$kl, \@lpmsqlgfile,     $root, $title1[0], \@key1, "$trial/lpmsqlg",        $xlabel,    "AVERAGE INS + DEL",                     $seesqlgplot, 0, "1");
gnuplot_fo_histo($N, 1/$kl, \@slpmsqlgfile,    $root, $title2[0], \@key2, "$trial/conslpmsqlg",    $xlabel,    "AVERAGE INS + DEL",                     0,            0, "1");
gnuplot_fo_histo($N, 1/$kl, \@lomsqlgfile,     $root, $title1[0], \@key1, "$trial/lomsqlg",        $xlabel,    "AVERAGE DEL over INS",                  $seesqlgplot, 0);
gnuplot_fo_histo($N, 1/$kl, \@slomsqlgfile,    $root, $title2[0], \@key2, "$trial/conslomsqlg",    $xlabel,    "AVERAGE DEL over INS",                  0,            0);
gnuplot_fo_histo($N, 1/$kl, \@frssqlgfile,     $root, $title1[0], \@key1, "$trial/frssqlg",        $xlabel,    "AVERAGE SUBS CHANGE",                   0,            0);
gnuplot_fo_histo($N, 1/$kl, \@sfrssqlgfile,    $root, $title2[0], \@key2, "$trial/consfrssqlg",    $xlabel,    "AVERAGE SUBS CHANGE",                   0,            0);
gnuplot_fo_histo($N, 1/$kl, \@frcsqlgfile,     $root, $title1[0], \@key1, "$trial/frcsqlg",        $xlabel,    "AVERAGE TOTAL CHANGE",                  0,            0);
gnuplot_fo_histo($N, 1/$kl, \@sfrcsqlgfile,    $root, $title2[0], \@key2, "$trial/consfrcsqlg",    $xlabel,    "AVERAGE TOTAL CHANGE",                  0,            0);
gnuplot_fo_histo($N, 1/$kl, \@ttrsqlgfile,     $root, $title1[0], \@key1, "$trial/ttrsqlg",        $xlabel,    "AVERAGE TRANSITION-TRANSVERSION RATIO", $seesqlgplot, 0);
gnuplot_fo_histo($N, 1/$kl, \@sttrsqlgfile,    $root, $title2[0], \@key2, "$trial/consttrsqlg",    $xlabel,    "AVERAGE TRANSITION-TRANSVERSION RATIO", 0,            0);
gnuplot_fo_histo($N, 1/$kl, \@timesqlgfile,    $root, $title1[0], \@key1, "$trial/timesqlg",       $xlabel,    "AVERAGE TIME (secs)",                   $seesqlgplot, 0);
gnuplot_fo_histo($N, 1/$kl, \@stimesqlgfile,   $root, $title2[0], \@key2, "$trial/constimesqlg",   $xlabel,    "AVERAGE TIME (secs)",                   0,            0);
gnuplot_fo_histo($N, 1/$kl, \@mutsqlgfile,     $root, $title1[0], \@key1, "$trial/mutsqlg",        $xlabel,    "AVERAGE % PAIRWISE MUTATIONS",          0,            0);
gnuplot_fo_histo($N, 1/$kl, \@smutsqlgfile,    $root, $title2[0], \@key2, "$trial/consmutsqlg",    $xlabel,    "AVERAGE % PAIRWISE MUTATIONS",          0,            0);


######################################################################
sub accumulate_averages {
    my ($val, $meanval_ref, $meansquareval_ref) = @_;

    $$meanval_ref       += $val;
    $$meansquareval_ref += $val*$val;
}

sub calculate_averages {
    my ($meanval_ref, $stdval_ref, $number) = @_;

    my $mean = $$meanval_ref;
    my $std  = $$stdval_ref;

    if ($number > 1) {
	$mean /= $number;
	
	$std -= $mean*$mean*$number;
	$std /= ($number-1);
	if ($std < 0. && $std> -0.00001) { $std = 0.0; }
	$std  = sqrt($std);
    }
    elsif ($number == 1) {
	$mean /= $number;
	$std   = 0.0;
    }
    else {
	$mean = 0.0;
	$std  = 0.0;
    }

    $$meanval_ref = $mean;
    $$stdval_ref  = $std;

}

sub create_diff_histo {
    my ($N, $k, $diffhis_ref, $name, $Nfiles, $avefile_ref, $key2_diff_ref, $key3_diff_ref) = @_;

    if ($Nfiles != 3) { print "create_diff_histo() is not ready for you\n"; die; }

    $$diffhis_ref = "$name.diff";
    system("rm $$diffhis_ref\n");

    my $tave_bootfo_diff2 = 0.;
    my $tstd_bootfo_diff2 = 0.;
    my $tave_bootfo_diff3 = 0.;
    my $tstd_bootfo_diff3 = 0.;

    my @fohisto;

    my @ave_bootfo_diff2;
    my @std_bootfo_diff2;
    my @ave_bootfo_diff3;
    my @std_bootfo_diff3;

    init_histo_array($N, $k, \@fohisto);
    init_histo_array($N, $k, \@ave_bootfo_diff2);
    init_histo_array($N, $k, \@std_bootfo_diff2);
    init_histo_array($N, $k, \@ave_bootfo_diff3);
    init_histo_array($N, $k, \@std_bootfo_diff3);


    my $c1 = 0;
    my $c2 = 0;
    my $c3 = 0;
    my $c;

    my @fo1;
    my @fo2;
    my @fo3;

    my @boot1;
    my @boot2;
    my @boot3;

    parse_avefile_bootfo($avefile_ref->[0], \$c1, \@fo1, \@boot1);
    parse_avefile_bootfo($avefile_ref->[1], \$c2, \@fo2, \@boot2);
    parse_avefile_bootfo($avefile_ref->[2], \$c3, \@fo3, \@boot3);

    $c = $c1;
    if ($c2 < $c) { $c = $c2; }
    if ($c3 < $c) { $c = $c3; }

    for (my $x = 0; $x < $c; $x++) {
	my $diff2 = $boot2[$x] - $boot1[$x];
	my $diff3 = $boot3[$x] - $boot1[$x];

	my $fo = $fo1[$x];
	if ($fo2[$x] != $fo || $fo3[$x] != $fo) {
	    print " cases do not correspond to each other\n"; die;}

	accumulate_averages($diff2, \$tave_bootfo_diff2, \$tstd_bootfo_diff2);
	accumulate_averages($diff3, \$tave_bootfo_diff3, \$tstd_bootfo_diff3);

	fill_histo_array(1,             $fo, $N, $k, \@fohisto);
	fill_histo_array($diff2,        $fo, $N, $k, \@ave_bootfo_diff2);
	fill_histo_array($diff2*$diff2, $fo, $N, $k, \@std_bootfo_diff2);
	fill_histo_array($diff3,        $fo, $N, $k, \@ave_bootfo_diff3);
	fill_histo_array($diff3*$diff3, $fo, $N, $k, \@std_bootfo_diff3);
    }

    calculate_averages(\$tave_bootfo_diff2, \$tstd_bootfo_diff2, $c);
    calculate_averages(\$tave_bootfo_diff3, \$tstd_bootfo_diff3, $c);


    $tave_bootfo_diff2 = int($tave_bootfo_diff2*10000)/100;
    $tstd_bootfo_diff2 = int($tstd_bootfo_diff2*10000)/100;
    $tave_bootfo_diff3 = int($tave_bootfo_diff3*10000)/100;
    $tstd_bootfo_diff3 = int($tstd_bootfo_diff3*10000)/100;

    write_bootfo_difffile($N, $k, $$diffhis_ref,
			  \@fohisto, 
			  \@ave_bootfo_diff2, \@std_bootfo_diff2, 
			  \@ave_bootfo_diff3, \@std_bootfo_diff3);

    $$key2_diff_ref = "DNAML-ERATE bootstrap DIFF  $tave_bootfo_diff2 +\- $tstd_bootfo_diff2";
    $$key3_diff_ref = "DNAML-ERATE.4 bootstrap DIFF$tave_bootfo_diff3 +\- $tstd_bootfo_diff3";    
}

sub create_sconsavefile {
    my ($sconsfile, $sconsavefile) = @_;

    my $nali = 0;
    my $nb;
    my $nboot;
    my $bootstrap;
    my $ave_bootstrap;
    my $std_bootstrap;
    my $included;
    
    open(AVE, ">$sconsavefile");

    open(FILE, "$sconsfile");
    while(<FILE>) {
	if (/^Sets included in the consensus tree/) {
	    $nali ++;

	    if ($nali > 1) { 
		calculate_averages(\$ave_bootstrap, \$std_bootstrap, $nb); 
		print AVE "$ave_bootstrap\t$std_bootstrap\n";
	    }

	    $ave_bootstrap = 0.0;
	    $std_bootstrap = 0.0;
	    $nb = 0;
	    $included = 1;
	}
	elsif (/How many times out of\s+(\S+)/) {
	    $nboot = $1;
	}
	elsif ($included == 1                                      &&
	       (/^[\.\*]+\s+(\d+\.00)/ || /^[\.\*\s]+\s+(\d+\.00)/)   ) {
	    $nb ++;
	    $bootstrap = $1;
	    if ($nboot > 0) { $bootstrap /= $nboot; }
	    print "boot $bootstrap\n";
	    if ($bootstrap > 1.0) { print "create_sconsavefile(): error bootstrap = $bootstrap\n"; die; }
	    accumulate_averages($bootstrap, \$ave_bootstrap, \$std_bootstrap);
	}
	elsif (/^Sets NOT included in consensus tree/) {
	    $included = 0;
	}
    }
    close (FILE);
    
    calculate_averages(\$ave_bootstrap, \$std_bootstrap, $nb); 
    print AVE "$ave_bootstrap\t$std_bootstrap\n";

    close (AVE);
}

sub fill_histo_array {
    my ($val, $len, $N, $k, $his_ref) = @_;
    my $dim = $N * $k;
    
    if ($len >=  $N) { $his_ref->[$dim] += 1; return; }

    for (my $i=0; $i<=$dim; $i++) { 
	if ( $i/$k <= $len && $len < ($i+1)/$k) { 
	    $his_ref->[$i] += $val; 
	    last; 
	} 
    }
}

sub gnuplot_diff_histo {

    my ($frac, $diffhis, $root, $title, $key1_ref, $key2_ref, $xlabel, $ylabel, $view, $func) = @_;

    my $outplot = "$diffhis.ps";

    my $n;
    my $m;
    my $cmd;

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";

    print GP "set terminal postscript color solid 14\n";
    print GP "set style line 1 lt 1 lw 4\n";
    print GP "set style line 2 lt 2 lw 4\n";
    print GP "set style line 3  lt 3 lw 4\n";
    print GP "set style line 4 lt 4 lw 4\n";+
    print GP "set style line 5 lt 5 lw 4\n";
    print GP "set style line 6 lt 6 lw 4\n";
    print GP "set style line 7 lt 7 lw 4\n";
    print GP "set style line 8 lt 8 lw 4\n";
    print GP "set style line 9 lt 9 lw 4\n";
    print GP "set style line 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set style line 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set style line 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set style line 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set style line 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set style line 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set style line 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set style line 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set style line 99 lt 9 lw 2 pt 9 ps 1.2\n";
 
    print GP "set output '$outplot'\n";
    #print GP "set nokey\n";
    print GP "set xlabel '$xlabel'\n";
    print GP "set title \"$root\\n\\n$title\"\n";
    print GP "set ylabel '$ylabel'\n";

    # plot dnaml-erate
    $n = 1;
    $m = $n+1;
    $cmd = "";
    if ($func) {
	$cmd .= "$func ls 9, ";
    }
    $cmd .= "'$diffhis' using 1:3  with points title '$key1_ref' ls $m";
    print GP "plot $cmd\n";

    $cmd = "";
    if ($func) {
	$cmd .= "$func ls 9, ";
    }
    $cmd .= "'$diffhis' using 1:3:4  with yerrorbars title '$key1_ref' ls $m";
    print GP "plot $cmd\n";

    # plot dnaml-erate.C
    $n = 1;
    $m = $n+1;
    $cmd = "";
    if ($func) {
	$cmd .= "$func ls 9, ";
    }
    $cmd .= "'$diffhis' using 1:5  with points title '$key2_ref' ls $m";
    print GP "plot $cmd\n";

    $cmd = "";
    if ($func) {
	$cmd .= "$func ls 9, ";
    }
    $cmd .= "'$diffhis' using 1:5:6  with yerrorbars title '$key2_ref' ls $m";
    print GP "plot $cmd\n";

    close (GP);

    if ($view) { 
	system ("ggv -landscape -magstep -2 $outplot&\n"); 
    }

}

sub gnuplot_fo_histo {

    my ($N, $frac, $filehisto_ref, $root, $title, $key_ref, $name, $xlabel, $ylabel, $view1, $view2, $func) = @_;

    my $outplot1 = "$name.ps";
    my $outplot2 = "$name.histo.ps";

    my $n;
    my $m;
    my $cmd;

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";

    print GP "set terminal postscript color solid 14\n";
    print GP "set style line 1 lt 1 lw 4\n";
    print GP "set style line 2 lt 2 lw 4\n";
    print GP "set style line 3  lt 3 lw 4\n";
    print GP "set style line 4 lt 4 lw 4\n";+
    print GP "set style line 5 lt 5 lw 4\n";
    print GP "set style line 6 lt 6 lw 4\n";
    print GP "set style line 7 lt 7 lw 4\n";
    print GP "set style line 8 lt 8 lw 4\n";
    print GP "set style line 9 lt 9 lw 4\n";
    print GP "set style line 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set style line 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set style line 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set style line 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set style line 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set style line 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set style line 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set style line 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set style line 99 lt 9 lw 2 pt 9 ps 1.2\n";
 
    print GP "set output '$outplot1'\n";
    #print GP "set nokey\n";
    print GP "set xlabel '$xlabel'\n";
    print GP "set title \"$root\\n\\n$title\"\n";
    print GP "set ylabel '$ylabel'\n";

    # plot dnaml/dnaml-erate.C
    $cmd = "";
    if ($func) {
	$cmd .= "$func ls 9, ";
    }
    $n = 0;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key_ref->[$n]' ls $m, ";
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3  with points title '$key_ref->[$N-1]' ls $N";
    print GP "plot $cmd\n";

    $cmd = "";
    $n = 0;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3:4  with yerrorbars title '$key_ref->[$n]' ls $m, ";
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3:4  with yerrorbars title '$key_ref->[$N-1]' ls $N";
    print GP "plot $cmd\n";
    
    # plot dnaml/dnaml-erate/dnaml-erate.C
    $cmd = "";
    if ($func) {
	$cmd .= "$func ls 9, ";
    }
    for ($n = 0; $n < $N-1; $n ++) {
	$m = $n+1;
	$cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key_ref->[$n]' ls $m, ";
    }
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3  with points title '$key_ref->[$N-1]' ls $N";
    #print "$cmd\n";
    print GP "plot $cmd\n";

    $cmd = "";
    if ($func) {
	$cmd .= "$func ls 9, ";
    }
    for ($n = 0; $n < $N-1; $n ++) {
	$m = $n+1;
	$cmd .= "'$filehisto_ref->[$n]' using 1:3:4  with yerrorbars title '$key_ref->[$n]' ls $m, ";
    }
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3:4  with yerrorbars title '$key_ref->[$N-1]' ls $N";
    #print "$cmd\n";
    print GP "plot $cmd\n";

    # histogram
    #
    print GP "set output '$outplot2'\n";
    print GP "set nokey\n";
    print GP "set xlabel '$xlabel'\n";
    print GP "set title \"$root\\n\\n$title\"\n";
    print GP "set ylabel '\#'\n";
    print GP "set boxwidth $frac\n";
    $cmd = "'$filehisto_ref->[$N-1]' using 1:2  with boxes ls $N";
    print GP "plot $cmd\n";

    close (GP);

    if ($view1) { 
	system ("ggv -landscape -magstep -2 $outplot1&\n"); 
    }
    if ($view2) { 
	system ("ggv -landscape -magstep -2 $outplot2&\n"); 
    }

}

sub gnuplot_histo {

    my ($N, $frac, $filehisto_ref, $root, $title, $key_ref, $name, $view) = @_;

    my $outplot = "$name.ps";
    my $ylabel;
    my $xlabel = "AVERAGE BOOSTRAP FRACTION";

    my $n;
    my $m;
    my $cmd;

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";

    print GP "set terminal postscript color solid 14\n";
    print GP "set style line 1 lt 1 lw 4\n";
    print GP "set style line 2 lt 2 lw 4\n";
    print GP "set style line 3  lt 3 lw 4\n";
    print GP "set style line 4 lt 4 lw 4\n";+
    print GP "set style line 5 lt 5 lw 4\n";
    print GP "set style line 6 lt 6 lw 4\n";
    print GP "set style line 7 lt 7 lw 4\n";
    print GP "set style line 8 lt 8 lw 4\n";
    print GP "set style line 9 lt 9 lw 4\n";
    print GP "set style line 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set style line 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set style line 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set style line 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set style line 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set style line 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set style line 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set style line 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set style line 99 lt 9 lw 2 pt 9 ps 1.2\n";
 
    print GP "set output '$outplot'\n";
    #print GP "set nokey\n";
    print GP "set xlabel '$xlabel'\n";

    print GP "set title \"$root\\n\\n$title\"\n";

    $ylabel = "\# TRIALS";
    print GP "set ylabel '$ylabel'\n";
    print GP "set boxwidth $frac\n";

    $n = 0;
    $m = $n+1;
    $cmd = "'$filehisto_ref->[$n]' using 1:2  with boxes title '$key_ref->[$n]' ls $m, ";
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:2  with boxes title '$key_ref->[$N-1]' ls $N";
    #print "$cmd\n";
    print GP "plot $cmd\n";

    $cmd = "";
    for ($n = 0; $n < $N-1; $n ++) {
	$m = $n+1;
	$cmd .= "'$filehisto_ref->[$n]' using 1:2  with boxes title '$key_ref->[$n]' ls $m, ";
    }
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:2  with boxes title '$key_ref->[$N-1]' ls $N";
    #print "$cmd\n";
    print GP "plot $cmd\n";

    close (GP);

    if ($view) { system ("ggv -landscape -magstep -2 $outplot&\n"); }

}

sub init_histo_array {
    my ($N, $k, $his_ref) = @_;
    my $dim = $N * $k;
    for (my $i=0; $i<=$dim; $i++) { $his_ref->[$i] = 0; }    
}


sub parse_avefile_bootfo {
    my ($avefile, $c_ref, $fo_ref, $boot_ref) = @_;

    my $n = 0;

    open(FILE, "$avefile");
    while(<FILE>) {
	if (/^(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s*/) {
	    my $alen      = $1;
	    my $sqlg      = $2;
	    my $id        = $3;
	    my $mut       = $4;
	    my $indl      = $5;
	    my $fo        = $6;
	    my $time      = $7;
	    my $abl       = $8;
	    my $alpha     = $9;
	    my $beta      = $10;
	    my $lambda    = $11;
	    my $mu        = $12;
	    my $ip        = $13;
	    my $like      = $14;
	    my $ttr       = $15;
	    my $apb       = $16;
	    my $frs       = $17;
	    my $frc       = $18;
	    my $bootstrap = $19;

	    $fo_ref->[$n]   = $fo;
	    $boot_ref->[$n] = $bootstrap;

	    $n ++;
	}
    }
    close (FILE);
    
    $$c_ref = $n;
}

sub parse_averagesfile { 
    my ($avefile, $title_ref, $key_ref,
	$Nb, $kb, $Nf, $kf, $Nl, $kl, 
	$boothistofile_ref, 
	$bootfofile_ref,   $likefofile_ref, 
	$ablfofile_ref,    $alpfofile_ref,  
	$betfofile_ref,    $insfofile_ref,  
	$delfofile_ref,    $ipfofile_ref,   
	$apbfofile_ref,    $lpmfofile_ref,  
	$lomfofile_ref,    $frsfofile_ref,  
	$frcfofile_ref,    $ttrfofile_ref,  
	$timefofile_ref,   $mutfofile_ref, 
	$bootsqlgfile_ref, $likesqlgfile_ref, 
	$ablsqlgfile_ref,  $alpsqlgfile_ref,  
	$betsqlgfile_ref,  $inssqlgfile_ref,  
	$delsqlgfile_ref,  $ipsqlgfile_ref,   
	$apbsqlgfile_ref,  $lpmsqlgfile_ref,  
	$lomsqlgfile_ref,  $frssqlgfile_ref,  
	$frcsqlgfile_ref,  $ttrsqlgfile_ref,  
	$timesqlgfile_ref, $mutsqlgfile_ref) = @_;

    my $aveavefile       = "$avefile.ave";
    $$boothistofile_ref  = "$avefile.histo";

    $$bootfofile_ref     = "$avefile.bootfo";
    $$likefofile_ref     = "$avefile.likefo";
    $$ablfofile_ref      = "$avefile.ablfo";
    $$alpfofile_ref      = "$avefile.alpfo";
    $$betfofile_ref      = "$avefile.betfo";
    $$insfofile_ref      = "$avefile.insfo";
    $$delfofile_ref      = "$avefile.delfo";
    $$ipfofile_ref       = "$avefile.ipfo";
    $$apbfofile_ref      = "$avefile.apbfo";
    $$lpmfofile_ref      = "$avefile.lpmfo";
    $$lomfofile_ref      = "$avefile.lomfo";
    $$frsfofile_ref      = "$avefile.frsfo";
    $$frcfofile_ref      = "$avefile.frcfo";
    $$ttrfofile_ref      = "$avefile.ttrfo";
    $$timefofile_ref     = "$avefile.timefo";
    $$mutfofile_ref      = "$avefile.mutfo";

    $$bootsqlgfile_ref   = "$avefile.bootsqlg";
    $$likesqlgfile_ref   = "$avefile.likesqlg";
    $$ablsqlgfile_ref    = "$avefile.ablsqlg";
    $$alpsqlgfile_ref    = "$avefile.alpsqlg";
    $$betsqlgfile_ref    = "$avefile.betsqlg";
    $$inssqlgfile_ref    = "$avefile.inssqlg";
    $$delsqlgfile_ref    = "$avefile.delsqlg";
    $$ipsqlgfile_ref     = "$avefile.ipsqlg";
    $$apbsqlgfile_ref    = "$avefile.apbsqlg";
    $$lpmsqlgfile_ref    = "$avefile.lpmsqlg";
    $$lomsqlgfile_ref    = "$avefile.lomsqlg";
    $$frssqlgfile_ref    = "$avefile.frssqlg";
    $$frcsqlgfile_ref    = "$avefile.frcsqlg";
    $$ttrsqlgfile_ref    = "$avefile.ttrsqlg";
    $$timesqlgfile_ref   = "$avefile.timesqlg";
    $$mutsqlgfile_ref    = "$avefile.mutsqlg";

    system("rm $aveavefile\n");
    system("rm $$boothistofile_ref\n");

    system("rm $$bootfofile_ref\n");
    system("rm $$likefofile_ref\n");
    system("rm $$ablfofile_ref\n");
    system("rm $$alpfofile_ref\n");
    system("rm $$betfofile_ref\n");
    system("rm $$insfofile_ref\n");
    system("rm $$delfofile_ref\n");
    system("rm $$ipfofile_ref\n");
    system("rm $$apbfofile_ref\n");
    system("rm $$lpmfofile_ref\n");
    system("rm $$lomfofile_ref\n");
    system("rm $$frsfofile_ref\n");
    system("rm $$frcfofile_ref\n");
    system("rm $$ttrfofile_ref\n");
    system("rm $$timefofile_ref\n");
    system("rm $$mutfofile_ref\n");

    system("rm $$bootsqlgfile_ref\n");
    system("rm $$likesqlgfile_ref\n");
    system("rm $$ablsqlgfile_ref\n");
    system("rm $$alpsqlgfile_ref\n");
    system("rm $$betsqlgfile_ref\n");
    system("rm $$inssqlgfile_ref\n");
    system("rm $$delsqlgfile_ref\n");
    system("rm $$ipsqlgfile_ref\n");
    system("rm $$apbsqlgfile_ref\n");
    system("rm $$lpmsqlgfile_ref\n");
    system("rm $$lomsqlgfile_ref\n");
    system("rm $$frssqlgfile_ref\n");
    system("rm $$frcsqlgfile_ref\n");
    system("rm $$ttrsqlgfile_ref\n");
    system("rm $$timesqlgfile_ref\n");
    system("rm $$mutsqlgfile_ref\n");

    my $tave_alen = 0.;
    my $tstd_alen = 0.;
    my $tave_sqlg = 0.;
    my $tstd_sqlg = 0.;
    my $tave_id = 0.;
    my $tstd_id = 0.;
    my $tave_mut = 0.;
    my $tstd_mut = 0.;
    my $tave_indl = 0.;
    my $tstd_indl = 0.;
    my $tave_fo = 0.;
    my $tstd_fo = 0.;
    my $tave_time = 0.;
    my $tstd_time = 0.;
    my $tave_abl = 0.;
    my $tstd_abl = 0.;
    my $tave_alpha = 0.;
    my $tstd_alpha = 0.;
    my $tave_beta = 0.;
    my $tstd_beta = 0.;
    my $tave_lambda = 0.;
    my $tstd_lambda = 0.;
    my $tave_mu = 0.;
    my $tstd_mu = 0.;
    my $tave_ip = 0.;
    my $tstd_ip = 0.;
    my $tave_like = 0.;
    my $tstd_like = 0.;
    my $tave_apb = 0.;
    my $tstd_apb = 0.;
    my $tave_lpm = 0.;
    my $tstd_lpm = 0.;
    my $tave_lom = 0.;
    my $tstd_lom = 0.;
    my $tave_frs = 0.;
    my $tstd_frs = 0.;
    my $tave_frc = 0.;
    my $tstd_frc = 0.;
    my $tave_ttr = 0.;
    my $tstd_ttr = 0.;
    my $tave_bootstrap = 0.;
    my $tstd_bootstrap = 0.;

    my $nboot = 0;
    my $key = "";
    my $title;
    my $NB;
    my $NS;
    my $TB;
    my $TS;

    if    ($avefile =~ /\.(dnaml)\./)          { $key = $1; }
    elsif ($avefile =~ /\.(dnaml-erate\.C)\./) { $key = $1; }
    elsif ($avefile =~ /\.(dnaml-erate)\./)    { $key = $1; }
    
    if ($avefile =~ /^(16S\_[^\_]+)\_/) { $title .= $1; }

    if ($avefile =~ /\.NB(\S+)\.TB(\S+)\.NS(\S+)\.TS(\S+)\.boot([^\.]+)\./) { 
	$NB    = $1; 
	$TB    = $2; 
	$NS    = $3; 
	$TS    = $4; 
	$nboot = $5;
    }

    my $nt = 0;

    my @boothisto;
    my @fohisto;
    my @sqlghisto;

    my @ave_bootfo;
    my @ave_likefo;
    my @ave_ablfo;
    my @ave_alpfo;
    my @ave_betfo;
    my @ave_insfo;
    my @ave_delfo;
    my @ave_ipfo;
    my @ave_apbfo;
    my @ave_lpmfo;
    my @ave_lomfo;
    my @ave_frsfo;
    my @ave_frcfo;
    my @ave_ttrfo;
    my @ave_timefo;
    my @ave_mutfo;

    my @std_bootfo;
    my @std_likefo;
    my @std_ablfo;
    my @std_alpfo;
    my @std_betfo;
    my @std_insfo;
    my @std_delfo;
    my @std_ipfo;
    my @std_apbfo;
    my @std_lpmfo;
    my @std_lomfo;
    my @std_frsfo;
    my @std_frcfo;
    my @std_ttrfo;
    my @std_timefo;
    my @std_mutfo;

    my @ave_bootsqlg;
    my @ave_likesqlg;
    my @ave_ablsqlg;
    my @ave_alpsqlg;
    my @ave_betsqlg;
    my @ave_inssqlg;
    my @ave_delsqlg;
    my @ave_ipsqlg;
    my @ave_apbsqlg;
    my @ave_lpmsqlg;
    my @ave_lomsqlg;
    my @ave_frssqlg;
    my @ave_frcsqlg;
    my @ave_ttrsqlg;
    my @ave_timesqlg;
    my @ave_mutsqlg;

    my @std_bootsqlg;
    my @std_likesqlg;
    my @std_ablsqlg;
    my @std_alpsqlg;
    my @std_betsqlg;
    my @std_inssqlg;
    my @std_delsqlg;
    my @std_ipsqlg;
    my @std_apbsqlg;
    my @std_lpmsqlg;
    my @std_lomsqlg;
    my @std_frssqlg;
    my @std_frcsqlg;
    my @std_ttrsqlg;
    my @std_timesqlg;
    my @std_mutsqlg;

    init_histo_array($Nb, $kb, \@boothisto);
    init_histo_array($Nf, $kf, \@fohisto);
    init_histo_array($Nl, $kl, \@sqlghisto);
    init_histo_array($Nf, $kf, \@ave_bootfo);
    init_histo_array($Nf, $kf, \@std_bootfo);
    init_histo_array($Nf, $kf, \@ave_likefo);
    init_histo_array($Nf, $kf, \@std_likefo);
    init_histo_array($Nf, $kf, \@ave_ablfo);
    init_histo_array($Nf, $kf, \@std_ablfo);
    init_histo_array($Nf, $kf, \@ave_alpfo);
    init_histo_array($Nf, $kf, \@std_alpfo);
    init_histo_array($Nf, $kf, \@ave_betfo);
    init_histo_array($Nf, $kf, \@std_betfo);
    init_histo_array($Nf, $kf, \@ave_insfo);
    init_histo_array($Nf, $kf, \@std_insfo);
    init_histo_array($Nf, $kf, \@ave_delfo);
    init_histo_array($Nf, $kf, \@std_delfo);
    init_histo_array($Nf, $kf, \@ave_ipfo);
    init_histo_array($Nf, $kf, \@std_ipfo);
    init_histo_array($Nf, $kf, \@ave_apbfo);
    init_histo_array($Nf, $kf, \@std_apbfo);
    init_histo_array($Nf, $kf, \@ave_lpmfo);
    init_histo_array($Nf, $kf, \@std_lpmfo);
    init_histo_array($Nf, $kf, \@ave_lomfo);
    init_histo_array($Nf, $kf, \@std_lomfo);
    init_histo_array($Nf, $kf, \@ave_frsfo);
    init_histo_array($Nf, $kf, \@std_frsfo);
    init_histo_array($Nf, $kf, \@ave_frcfo);
    init_histo_array($Nf, $kf, \@std_frcfo);
    init_histo_array($Nf, $kf, \@ave_ttrfo);
    init_histo_array($Nf, $kf, \@std_ttrfo);
    init_histo_array($Nf, $kf, \@ave_timefo);
    init_histo_array($Nf, $kf, \@std_timefo);
    init_histo_array($Nf, $kf, \@ave_mutfo);
    init_histo_array($Nf, $kf, \@std_mutfo);

    init_histo_array($Nl, $kl, \@ave_bootsqlg);
    init_histo_array($Nl, $kl, \@std_bootsqlg);
    init_histo_array($Nl, $kl, \@ave_likesqlg);
    init_histo_array($Nl, $kl, \@std_likesqlg);
    init_histo_array($Nl, $kl, \@ave_ablsqlg);
    init_histo_array($Nl, $kl, \@std_ablsqlg);
    init_histo_array($Nl, $kl, \@ave_alpsqlg);
    init_histo_array($Nl, $kl, \@std_alpsqlg);
    init_histo_array($Nl, $kl, \@ave_betsqlg);
    init_histo_array($Nl, $kl, \@std_betsqlg);
    init_histo_array($Nl, $kl, \@ave_inssqlg);
    init_histo_array($Nl, $kl, \@std_inssqlg);
    init_histo_array($Nl, $kl, \@ave_delsqlg);
    init_histo_array($Nl, $kl, \@std_delsqlg);
    init_histo_array($Nl, $kl, \@ave_ipsqlg);
    init_histo_array($Nl, $kl, \@std_ipsqlg);
    init_histo_array($Nl, $kl, \@ave_apbsqlg);
    init_histo_array($Nl, $kl, \@std_apbsqlg);
    init_histo_array($Nl, $kl, \@ave_lpmsqlg);
    init_histo_array($Nl, $kl, \@std_lpmsqlg);
    init_histo_array($Nl, $kl, \@ave_lomsqlg);
    init_histo_array($Nl, $kl, \@std_lomsqlg);
    init_histo_array($Nl, $kl, \@ave_frssqlg);
    init_histo_array($Nl, $kl, \@std_frssqlg);
    init_histo_array($Nl, $kl, \@ave_frcsqlg);
    init_histo_array($Nl, $kl, \@std_frcsqlg);
    init_histo_array($Nl, $kl, \@ave_ttrsqlg);
    init_histo_array($Nl, $kl, \@std_ttrsqlg);
    init_histo_array($Nl, $kl, \@ave_timesqlg);
    init_histo_array($Nl, $kl, \@std_timesqlg);
    init_histo_array($Nl, $kl, \@ave_mutsqlg);
    init_histo_array($Nl, $kl, \@std_mutsqlg);

    print "avefile\n$avefile\n";
    open(FILE, "$avefile");
    while(<FILE>) {
	if (/^(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s*/) {
	    my $alen      = $1;
	    my $sqlg      = $2;
	    my $id        = $3;
	    my $mut       = $4;
	    my $indl      = $5;
	    my $fo        = $6;
	    my $time      = $7;
	    my $abl       = $8;
	    my $alpha     = $9;
	    my $beta      = $10;
	    my $lambda    = $11;
	    my $mu        = $12;
	    my $ip        = $13;
	    my $like      = $14;
	    my $ttr       = $15;
	    my $apb       = $16;
	    my $frs       = $17;
	    my $frc       = $18;
	    my $bootstrap = $19;
	    
	    my $lpm = $lambda + $mu;
	    my $lom = ($lambda > 0)? ($mu)/$lambda : 0;

	    if (0) {
		print "\naverage of averages\n";
		print "ave_alen $alen\n";
		print "ave_sqlg $sqlg\n";
		print "ave_id $id\n";
		print "ave_mut $mut\n";
		print "ave_indl $indl\n";
		print "ave_fo $fo\n";
		print "ave_time $time \n";
		print "ave_abl $abl \n";
		print "ave_alpha $alpha\n";
		print "ave_beta $beta\n";
		print "ave_lambda $lambda\n";
		print "ave_mu $mu\n";
		print "ave_ip $ip\n";
		print "ave_like $like\n";
		print "ave_apb $apb\n";
		print "ave_lpm $lpm\n";
		print "ave_lom $lom\n";
		print "ave_frs $frs\n";
		print "ave_frc $frc\n";
		print "ave_ttr $ttr\n";
		print "ave_boot $bootstrap\n";
	    }
	    
	    if ($fo <= 1.0) {
		accumulate_averages($alen,      \$tave_alen,      \$tstd_alen);
		accumulate_averages($sqlg,      \$tave_sqlg,      \$tstd_sqlg);
		accumulate_averages($id,        \$tave_id,        \$tstd_id);
		accumulate_averages($mut,       \$tave_mut,       \$tstd_mut);
		accumulate_averages($indl,      \$tave_indl,      \$tstd_indl);
		accumulate_averages($fo,        \$tave_fo,        \$tstd_fo);
		accumulate_averages($time,      \$tave_time,      \$tstd_time);
		accumulate_averages($abl,       \$tave_abl,       \$tstd_abl);
		accumulate_averages($alpha,     \$tave_alpha,     \$tstd_alpha);
		accumulate_averages($beta,      \$tave_beta,      \$tstd_beta);
		accumulate_averages($lambda,    \$tave_lambda,    \$tstd_lambda);
		accumulate_averages($mu,        \$tave_mu,        \$tstd_mu);
		accumulate_averages($ip,        \$tave_ip,        \$tstd_ip);
		accumulate_averages($like,      \$tave_like,      \$tstd_like);
		accumulate_averages($apb,       \$tave_apb,       \$tstd_apb);
		accumulate_averages($lpm,       \$tave_lpm,       \$tstd_lpm);
		accumulate_averages($lom,       \$tave_lom,       \$tstd_lom);
		accumulate_averages($frs,       \$tave_frs,       \$tstd_frs);
		accumulate_averages($frc,       \$tave_frc,       \$tstd_frc);
		accumulate_averages($ttr,       \$tave_ttr,       \$tstd_ttr);
		accumulate_averages($bootstrap, \$tave_bootstrap, \$tstd_bootstrap);
		
		fill_histo_array(1,                         $bootstrap, $Nb, $kb, \@boothisto);
		fill_histo_array(1,                         $fo,        $Nf, $kf, \@fohisto);
		fill_histo_array(1,                         $sqlg,      $Nl, $kl, \@sqlghisto);

		fill_histo_array($bootstrap,                $fo,        $Nf, $kf, \@ave_bootfo);
		fill_histo_array($bootstrap*$bootstrap,     $fo,        $Nf, $kf, \@std_bootfo);
		fill_histo_array($like,                     $fo,        $Nf, $kf, \@ave_likefo);
		fill_histo_array($like*$like,               $fo,        $Nf, $kf, \@std_likefo);
		fill_histo_array($abl,                      $fo,        $Nf, $kf, \@ave_ablfo);
		fill_histo_array($abl*$abl,                 $fo,        $Nf, $kf, \@std_ablfo);
		fill_histo_array($alpha,                    $fo,        $Nf, $kf, \@ave_alpfo);
		fill_histo_array($alpha*$alpha,             $fo,        $Nf, $kf, \@std_alpfo);
		fill_histo_array($beta,                     $fo,        $Nf, $kf, \@ave_betfo);
		fill_histo_array($beta*$beta,               $fo,        $Nf, $kf, \@std_betfo);
		fill_histo_array($lambda,                   $fo,        $Nf, $kf, \@ave_insfo);
		fill_histo_array($lambda*$lambda,           $fo,        $Nf, $kf, \@std_insfo);
		fill_histo_array($mu,                       $fo,        $Nf, $kf, \@ave_delfo);
		fill_histo_array($mu*$mu,                   $fo,        $Nf, $kf, \@std_delfo);
		fill_histo_array($ip,                       $fo,        $Nf, $kf, \@ave_ipfo);
		fill_histo_array($ip*$ip,                   $fo,        $Nf, $kf, \@std_ipfo);
		fill_histo_array($apb,                      $fo,        $Nf, $kf, \@ave_apbfo);
		fill_histo_array($apb*$apb,                 $fo,        $Nf, $kf, \@std_apbfo);
		fill_histo_array($lpm,                      $fo,        $Nf, $kf, \@ave_lpmfo);
		fill_histo_array($lpm*$lpm,                 $fo,        $Nf, $kf, \@std_lpmfo);
		fill_histo_array($lom,                      $fo,        $Nf, $kf, \@ave_lomfo);
		fill_histo_array($lom*$lom,                 $fo,        $Nf, $kf, \@std_lomfo);
		fill_histo_array($frs,                      $fo,        $Nf, $kf, \@ave_frsfo);
		fill_histo_array($frs*$frs,                 $fo,        $Nf, $kf, \@std_frsfo);
		fill_histo_array($frc,                      $fo,        $Nf, $kf, \@ave_frcfo);
		fill_histo_array($frc*$frc,                 $fo,        $Nf, $kf, \@std_frcfo);
		fill_histo_array($ttr,                      $fo,        $Nf, $kf, \@ave_ttrfo);
		fill_histo_array($ttr*$ttr,                 $fo,        $Nf, $kf, \@std_ttrfo);
		fill_histo_array($time,                     $fo,        $Nf, $kf, \@ave_timefo);
		fill_histo_array($time*$time,               $fo,        $Nf, $kf, \@std_timefo);
		fill_histo_array($mut,                      $fo,        $Nf, $kf, \@ave_mutfo);
		fill_histo_array($mut*$mut,                 $fo,        $Nf, $kf, \@std_mutfo);

		fill_histo_array($bootstrap,                $sqlg,      $Nl, $kl, \@ave_bootsqlg);
		fill_histo_array($bootstrap*$bootstrap,     $sqlg,      $Nl, $kl, \@std_bootsqlg);
		fill_histo_array($like,                     $sqlg,      $Nl, $kl, \@ave_likesqlg);
		fill_histo_array($like*$like,               $sqlg,      $Nl, $kl, \@std_likesqlg);
		fill_histo_array($abl,                      $sqlg,      $Nl, $kl, \@ave_ablsqlg);
		fill_histo_array($abl*$abl,                 $sqlg,      $Nl, $kl, \@std_ablsqlg);
		fill_histo_array($alpha,                    $sqlg,      $Nl, $kl, \@ave_alpsqlg);
		fill_histo_array($alpha*$alpha,             $sqlg,      $Nl, $kl, \@std_alpsqlg);
		fill_histo_array($beta,                     $sqlg,      $Nl, $kl, \@ave_betsqlg);
		fill_histo_array($beta*$beta,               $sqlg,      $Nl, $kl, \@std_betsqlg);
		fill_histo_array($lambda,                   $sqlg,      $Nl, $kl, \@ave_inssqlg);
		fill_histo_array($lambda*$lambda,           $sqlg,      $Nl, $kl, \@std_inssqlg);
		fill_histo_array($mu,                       $sqlg,      $Nl, $kl, \@ave_delsqlg);
		fill_histo_array($mu*$mu,                   $sqlg,      $Nl, $kl, \@std_delsqlg);
		fill_histo_array($ip,                       $sqlg,      $Nl, $kl, \@ave_ipsqlg);
		fill_histo_array($ip*$ip,                   $sqlg,      $Nl, $kl, \@std_ipsqlg);
		fill_histo_array($apb,                      $sqlg,      $Nl, $kl, \@ave_apbsqlg);
		fill_histo_array($apb*$apb,                 $sqlg,      $Nl, $kl, \@std_apbsqlg);
		fill_histo_array($lpm,                      $sqlg,      $Nl, $kl, \@ave_lpmsqlg);
		fill_histo_array($lpm*$lpm,                 $sqlg,      $Nl, $kl, \@std_lpmsqlg);
		fill_histo_array($lom,                      $sqlg,      $Nl, $kl, \@ave_lomsqlg);
		fill_histo_array($lom*$lom,                 $sqlg,      $Nl, $kl, \@std_lomsqlg);
		fill_histo_array($frs,                      $sqlg,      $Nl, $kl, \@ave_frssqlg);
		fill_histo_array($frs*$frs,                 $sqlg,      $Nl, $kl, \@std_frssqlg);
		fill_histo_array($frc,                      $sqlg,      $Nl, $kl, \@ave_frcsqlg);
		fill_histo_array($frc*$frc,                 $sqlg,      $Nl, $kl, \@std_frcsqlg);
		fill_histo_array($ttr,                      $sqlg,      $Nl, $kl, \@ave_ttrsqlg);
		fill_histo_array($ttr*$ttr,                 $sqlg,      $Nl, $kl, \@std_ttrsqlg);
		fill_histo_array($time,                     $sqlg,      $Nl, $kl, \@ave_timesqlg);
		fill_histo_array($time*$time,               $sqlg,      $Nl, $kl, \@std_timesqlg);
		fill_histo_array($mut,                      $sqlg,      $Nl, $kl, \@ave_mutsqlg);
		fill_histo_array($mut*$mut,                 $sqlg,      $Nl, $kl, \@std_mutsqlg);

		$nt ++;
	    }
	}
    }
    close (FILE);
    
    calculate_averages(\$tave_alen,      \$tstd_alen,      $nt);
    calculate_averages(\$tave_sqlg,      \$tstd_sqlg,      $nt);
    calculate_averages(\$tave_id,        \$tstd_id,        $nt);
    calculate_averages(\$tave_mut,       \$tstd_mut,       $nt);
    calculate_averages(\$tave_indl,      \$tstd_indl,      $nt);
    calculate_averages(\$tave_fo,        \$tstd_fo,        $nt);
    calculate_averages(\$tave_abl,       \$tstd_abl,       $nt);
    calculate_averages(\$tave_alpha,     \$tstd_alpha,     $nt);
    calculate_averages(\$tave_beta,      \$tstd_beta,      $nt);
    calculate_averages(\$tave_lambda,    \$tstd_lambda,    $nt);
    calculate_averages(\$tave_mu,        \$tstd_mu,        $nt);
    calculate_averages(\$tave_ip,        \$tstd_ip,        $nt);
    calculate_averages(\$tave_like,      \$tstd_like,      $nt);
    calculate_averages(\$tave_apb,       \$tstd_apb,       $nt);
    calculate_averages(\$tave_lpm,       \$tstd_lpm,       $nt);
    calculate_averages(\$tave_lom,       \$tstd_lom,       $nt);
    calculate_averages(\$tave_frs,       \$tstd_frs,       $nt);
    calculate_averages(\$tave_frc,       \$tstd_frc,       $nt);
    calculate_averages(\$tave_ttr,       \$tstd_ttr,       $nt);
    calculate_averages(\$tave_time,      \$tstd_time,      $nt);
    calculate_averages(\$tave_bootstrap, \$tstd_bootstrap, $nt);

    write_to_average_averagesfile($aveavefile, 
				  $tave_alen, $tstd_alen, 
				  $tave_sqlg, $tstd_sqlg, 
				  $tave_id, $tstd_id, 
				  $tave_mut, $tstd_mut, 
				  $tave_indl, $tstd_indl, 
				  $tave_fo, $tstd_fo, 
				  $tave_time, $tstd_time, 
				  $tave_abl, $tstd_abl, 
				  $tave_alpha, $tstd_alpha, 
				  $tave_beta, $tstd_beta, 
				  $tave_lambda, $tstd_lambda, 
				  $tave_mu, $tstd_mu, 
				  $tave_ip, $tstd_ip, 
				  $tave_like, $tstd_like, 
				  $tave_ttr, $tstd_ttr, 
				  $tave_apb, $tstd_apb, 
				  $tave_frs, $tstd_frs, 
				  $tave_frc, $tstd_frc, 
				  $tave_bootstrap, $tstd_bootstrap);
    
    write_histogram($Nb, $kb, \@boothisto, $$boothistofile_ref, $nt);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_bootfo,   \@std_bootfo,   $$bootfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_likefo,   \@std_likefo,   $$likefofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_ablfo,    \@std_ablfo,    $$ablfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_alpfo,    \@std_alpfo,    $$alpfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_betfo,    \@std_betfo,    $$betfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_insfo,    \@std_insfo,    $$insfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_delfo,    \@std_delfo,    $$delfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_ipfo,     \@std_ipfo,     $$ipfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_apbfo,    \@std_apbfo,    $$apbfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_lpmfo,    \@std_lpmfo,    $$lpmfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_lomfo,    \@std_lomfo,    $$lomfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_frsfo,    \@std_frsfo,    $$frsfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_frcfo,    \@std_frcfo,    $$frcfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_ttrfo,    \@std_ttrfo,    $$ttrfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_timefo,   \@std_timefo,   $$timefofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_mutfo,    \@std_mutfo,    $$mutfofile_ref);

    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_bootsqlg, \@std_bootsqlg, $$bootsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_likesqlg, \@std_likesqlg, $$likesqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_ablsqlg,  \@std_ablsqlg,  $$ablsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_alpsqlg,  \@std_alpsqlg,  $$alpsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_betsqlg,  \@std_betsqlg,  $$betsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_inssqlg,  \@std_inssqlg,  $$inssqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_delsqlg,  \@std_delsqlg,  $$delsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_ipsqlg,   \@std_ipsqlg,   $$ipsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_apbsqlg,  \@std_apbsqlg,  $$apbsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_lpmsqlg,  \@std_lpmsqlg,  $$lpmsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_lomsqlg,  \@std_lomsqlg,  $$lomsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_frssqlg,  \@std_frssqlg,  $$frssqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_frcsqlg,  \@std_frcsqlg,  $$frcsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_ttrsqlg,  \@std_ttrsqlg,  $$ttrsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_timesqlg, \@std_timesqlg, $$timesqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_mutsqlg,  \@std_mutsqlg,  $$mutsqlgfile_ref);

    $tave_bootstrap = int($tave_bootstrap*10000)/100;
    $tstd_bootstrap = int($tstd_bootstrap*10000)/100;

    $tave_alen = int($tave_alen);
    $tstd_alen = int($tstd_alen);

    $tave_sqlg = int($tave_sqlg);
    $tstd_sqlg = int($tstd_sqlg);

    $title .= "N=$nt / Nb=$NB TB=$TB NS=$NS TS=$TS / len ali $tave_alen +/- $tstd_alen / geomean seqs $tave_sqlg +/- $tstd_sqlg / $nboot boostrap";
    $key   .= " ** ave bootstrap $tave_bootstrap +\- $tstd_bootstrap";
  
    $$key_ref = $key;
    $$title_ref = $title;
}

sub parse_sconsavefile { 
    my ($sconsavefile, $sboothistofile_ref, $title_ref, $key_ref) = @_;

    my $sconsaveavefile     = "$sconsavefile.ave";
    $$sboothistofile_ref = "$sconsavefile.histo";
    system("rm $$sboothistofile_ref\n");

    my $tave_bootstrap = 0.;
    my $tstd_bootstrap = 0.;

    my $nboot = 0;
    my $key = "";
    my $title;
    my $NB;
    my $NS;
    my $TB;
    my $TS;

    if    ($sconsavefile =~ /\.(dnaml)\./)          { $key = $1; }
    elsif ($sconsavefile =~ /\.(dnaml-erate\.C)\./) { $key = $1; }
    elsif ($sconsavefile =~ /\.(dnaml-erate)\./)    { $key = $1; }
    
    if ($sconsavefile =~ /^(16S\_[^\_]+)\_/) { $title .= $1; }

    if ($sconsavefile =~ /\.NB(\S+)\.TB(\S+)\.NS(\S+)\.TS(\S+)\.boot([^\.]+)\./) { 
	$NB    = $1; 
	$TB    = $2; 
	$NS    = $3; 
	$TS    = $4; 
	$nboot = $5;
    }

    my $nt = 0;

    my $N = 1;
    my $k = 100;
    my @sconsavehisto;
    init_histo_array($N, $k, \@sconsavehisto);
    
    open(FILE, "$sconsavefile");
    while(<FILE>) {
	if (/^(\S+)\s+\S+\s*$/) {
	    my $bootstrap = $1;
	    $nt ++;
	    accumulate_averages($bootstrap, \$tave_bootstrap, \$tstd_bootstrap);
	    fill_histo_array(1, $bootstrap, $N, $k, \@sconsavehisto);
	}
    }
    close (FILE);

    calculate_averages(\$tave_bootstrap, \$tstd_bootstrap, $nt);
    write_histogram($N, $k, \@sconsavehisto, $$sboothistofile_ref, $nt);

    $tave_bootstrap = int($tave_bootstrap*10000)/100;
    $tstd_bootstrap = int($tstd_bootstrap*10000)/100;

    $title .= " ** N=$nt / Nb=$NB TB=$TB NS=$NS TS=$TS / $nboot boostrap each";
    $key   .= " ** ave bootstrap $tave_bootstrap +\- $tstd_bootstrap";

    $$key_ref = $key;
    $$title_ref = $title;

}

sub parse_sconsfile { 
    my ($sconsfile, $sboothistofile_ref, $title_ref, $key_ref) = @_;

    my $sconsavefile     = "$sconsfile.ave";
    my $sconsaveavefile  = "$sconsavefile.ave";
    $$sboothistofile_ref = "$sconsavefile.histo";
    system("rm $sconsavefile\n");
    system("rm $sconsaveavefile\n");
    system("rm $$sboothistofile_ref\n");

    my $tave_bootstrap = 0.;
    my $tstd_bootstrap = 0.;

    my $nboot = 0;
    my $key = "";
    my $title;
    my $NB;
    my $NS;
    my $TB;
    my $TS;

    if    ($sconsfile =~ /\.(dnaml)\./)          { $key = $1; }
    elsif ($sconsfile =~ /\.(dnaml-erate\.C)\./) { $key = $1; }
    elsif ($sconsfile =~ /\.(dnaml-erate)\./)    { $key = $1; }
    
    if ($sconsfile =~ /^(16S\_[^\_]+)\_/) { $title .= $1; }

    if ($sconsfile =~ /\.NB(\S+)\.TB(\S+)\.NS(\S+)\.TS(\S+)\.boot([^\.]+)\./) { 
	$NB    = $1; 
	$TB    = $2; 
	$NS    = $3; 
	$TS    = $4; 
	$nboot = $5;
    }

    my $nt = 0;

    my $N = 1;
    my $k = 100;
    my @sconsavehisto;
    init_histo_array($N, $k, \@sconsavehisto);
    
    # extract average boostraps for each consense.consense tree
    create_sconsavefile($sconsfile, $sconsavefile);
    
    open(FILE, "$sconsavefile");
    while(<FILE>) {
	if (/^(\S+)\s+\S+\s*$/) {
	    my $bootstrap = $1;
	    $nt ++;
	    accumulate_averages($bootstrap, \$tave_bootstrap, \$tstd_bootstrap);
	    fill_histo_array(1, $bootstrap, $N, $k, \@sconsavehisto);
	}
    }
    close (FILE);

    calculate_averages(\$tave_bootstrap, \$tstd_bootstrap, $nt);
    write_histogram($N, $k, \@sconsavehisto, $$sboothistofile_ref, $nt);

    $tave_bootstrap = int($tave_bootstrap*10000)/100;
    $tstd_bootstrap = int($tstd_bootstrap*10000)/100;

    $title .= " ** N=$nt / Nb=$NB TB=$TB NS=$NS TS=$TS / $nboot boostrap each";
    $key   .= " ** ave bootstrap $tave_bootstrap +\- $tstd_bootstrap";

    $$key_ref = $key;
    $$title_ref = $title;

}
    
sub write_histogram {

    my ($N, $k, $histo_ref, $hfile, $NT) = @_;
    
    my $dim = $N * $k;

    open(HIS, ">$hfile");

    for (my $i=0; $i<=$dim; $i++) { 
	my $len = $i/$k;
	print HIS "$len\t$histo_ref->[$i]\n";
    }
    
    close (HIS);

    my $title = "N=$NT";
    my $xlabel = "AVERAGE BOOSTRAP FRACTION";
    my $key= "";
    #gnuplot_histo($hfile, $title, $xlabel, $key);

}

sub write_fo_histogram {
    my ($N, $k, $fohisto_ref, $ave_bootfo_ref, $std_bootfo_ref, $hfile) = @_;

    my $dim = $N * $k;

    open(HIS, ">$hfile");

    for (my $i=0; $i<=$dim; $i++) { 
	my $len = $i/$k;

	my $total    = $fohisto_ref->[$i];
	my $ave_boot = $ave_bootfo_ref->[$i];
	my $std_boot = $std_bootfo_ref->[$i];
	calculate_averages(\$ave_boot, \$std_boot, $total);

	if ($total > 0) {
	    my $cmd = "$total\t$ave_boot\t$std_boot";
	    print HIS "$len\t$cmd\n";
	}
    }
    close(HIS);
}

sub write_scattered_plot {
    my ($nt, $boot_ref, $fo_ref, $sfile) = @_;

    open(FILE, ">$sfile");

    for (my $n = 0; $n < $nt; $n++) { 
	print FILE "$fo_ref->[$n]\t$boot_ref->[$n]\n";
    }
    
    close (FILE);

}

sub write_to_average_averagesfile {
    my ($averages_file,
	$ave_alen, $std_alen, 
	$ave_sqlg, $std_sqlg, 
	$ave_id, $std_id, 
	$ave_mut, $std_mut, 
	$ave_indl, $std_indl, 
	$ave_fo, $std_fo, 
	$ave_time, $std_time, $ave_abl, $std_abl, 
	$ave_alpha, $std_alpha, $ave_beta, $std_beta, 
	$ave_lambda, $std_lambda, $ave_mu, $std_mu, 
	$ave_ip, $std_ip, 
	$ave_like, $std_like, $ave_ttr, $std_ttr, 
	$ave_apb, $std_apb, $ave_frs, $std_frs, $ave_frc, $std_frc, 
	$ave_bootstrap, $std_bootstrap) = @_;

    open(FILE, ">>$averages_file");
    print "\nave_alen $ave_alen $std_alen\n";
    print "ave_sqlg $ave_sqlg $std_sqlg\n";
    print "ave_id $ave_id $std_id\n";
    print "ave_MUT $ave_mut $std_mut\n";
    print "ave_INDL $ave_indl $std_indl\n";
    print "ave_indlfreq $ave_fo $std_fo\n";
    print "ave_time $ave_time $std_time\n";
    print "ave_abl $ave_abl $std_abl \n";
    print "ave_alpha $ave_alpha $std_alpha\n";
    print "ave_beta $ave_beta $std_beta\n";
    print "ave_lambda $ave_lambda $std_lambda\n";
    print "ave_mu $ave_mu $std_mu \n";
    print "ave_ip $ave_ip $std_ip \n";
    print "ave_like $ave_like $std_like \n";
    print "ave_ttr $ave_ttr $std_ttr \n";
    print "ave_apb $ave_apb $std_apb \n";
    print "ave_frs $ave_frs $std_frs \n";
    print "ave_frc $ave_frc $std_frc \n";
    print "ave_boot $ave_bootstrap $std_bootstrap\n";
    print "$ave_alen\t$std_alen\t$ave_sqlg\t$std_sqlg\t$ave_id\t$std_id\t$ave_mut\t$std_mut\t$ave_indl\t$std_indl\t$ave_fo\t$std_fo\t$ave_time\t$std_time\t$ave_abl\t$std_abl\t$ave_alpha\t$std_alpha\t$ave_beta\t$std_beta\t$ave_lambda\t$std_lambda\t$ave_mu\t$std_mu\t$ave_ip\t$std_ip\t$ave_like\t$std_like\t$ave_ttr\t$std_ttr\t$ave_apb\t$std_apb\t$ave_frs\t$std_frs\t$ave_frc\t$std_frc\t$ave_bootstrap\t$std_bootstrap\n";
    print FILE "$ave_alen\t$std_alen\t$ave_sqlg\t$std_sqlg\t$ave_id\t$std_id\t$ave_mut\t$std_mut\t$ave_indl\t$std_indl\t$ave_fo\t$std_fo\t$ave_time\t$std_time\t$ave_abl\t$std_abl\t$ave_alpha\t$std_alpha\t$ave_beta\t$std_beta\t$ave_lambda\t$std_lambda\t$ave_mu\t$std_mu\t$ave_ip\t$std_ip\t$ave_like\t$std_like\t$ave_ttr\t$std_ttr\t$ave_apb\t$std_apb\t$ave_frs\t$std_frs\t$ave_frc\t$std_frc\t$ave_bootstrap\t$std_bootstrap\n";
    close(FILE);
}

sub write_bootfo_difffile {
    my ($N, $k, $difffile,
	$fohisto_ref, 
	$ave_bootfo_diff2_ref, $std_bootfo_diff2_ref, 
	$ave_bootfo_diff3_ref, $std_bootfo_diff3_ref) = @_;
    
    my $dim = $N * $k;

    open(HIS, ">$difffile");

    for (my $i=0; $i<=$dim; $i++) { 
	my $len = $i/$k;

	my $total          = $fohisto_ref->[$i];
	my $ave_boot_diff2 = $ave_bootfo_diff2_ref->[$i];
	my $std_boot_diff2 = $std_bootfo_diff2_ref->[$i];
	my $ave_boot_diff3 = $ave_bootfo_diff3_ref->[$i];
	my $std_boot_diff3 = $std_bootfo_diff3_ref->[$i];

	calculate_averages(\$ave_boot_diff2, \$std_boot_diff2, $total);
	calculate_averages(\$ave_boot_diff3, \$std_boot_diff3, $total);

	if ($total > 0) {
	    my $cmd = "$total\t$ave_boot_diff2\t$std_boot_diff2\t$ave_boot_diff3\t$std_boot_diff3";
	    print HIS "$len\t$cmd\n";
	}
    }
    close(HIS);
}
