#!/usr/bin/perl -w
#plot_bootstrap_dom.pl

use strict;
use Class::Struct;

use vars qw ($opt_c $opt_x);  # required if strict used
use Getopt::Std;
use constant GNUPLOT => '/usr/bin/gnuplot';
getopts ('cx:');

# Print a helpful message if the user provides no input file.
if (!@ARGV) {
        print "usage:  plot_bootstrap_dom.pl [options] dom\n\n";
        print "options:\n";
	print "-c           : do not concatenate files\n";
	print "-x <name>    : add suffix to directory\n";
	exit;
}
my $dom = shift;
my $root;
my $trialdir;
my $npt;
my $ptrial;
my $ptrialdir;
my $boot;

#SSU
if ($dom =~ /^s\_arc1$/) {
    $root      = "16S_arc_ua_ae2_cons_struct.85.phylip";
    $npt       = 1;
    $boot      = 500;    
    $ptrial    = "NB1.0.TB1.NS0.TS1";
    $ptrialdir = "NB1.0.TB1.NS8.TS1";
    $trialdir  = "NB1.0.TB1.NS8.TS1";
}
elsif ($dom =~ /^s\_arc2$/) {
    $root      = "16S_arc_ua_ae2_cons_struct.85.phylip";
    $npt       = 10;
    $boot      = 100;    
    $ptrial    = "NB0.7.TB100.NS0.TS1";
    $ptrialdir = "NB0.7.TB100.NS8.TS1";
    $trialdir  = "NB0.7.TB1000.NS8.TS1";
}
elsif ($dom =~ /^s\_bac1$/) {
    $root      = "16S_bac_ua_ae2_cons_struct.85.phylip";
    $npt       = 40;
    $boot      = 100;    
    $ptrial    = "NB1.0.TB1.NS8.TS25";
    $ptrialdir = "$ptrial";
    $trialdir  = "NB1.0.TB1.NS8.TS1000";
}
elsif ($dom =~ /^s\_bac2$/) {
    $root      = "16S_bac_ua_ae2_cons_struct.85.phylip";
    $npt       = 40;
    $boot      = 100;    
    $ptrial    = "NB0.7.TB20.NS8.TS5";
    $ptrialdir = "Nb0.7.TB20.NS8.TS5"; # change in another run
    $trialdir  = "NB0.7.TB20.NS8.TS200";
}
elsif ($dom =~ /^s\_euk$/) {
    $root      = "16S_euk_ua_ae2_cons_struct.85.phylip";
    $npt       = 40;
    $boot      = 100;    
    $ptrial    = "NB0.55.TB20.NS8.TS5";
    $ptrialdir = "$ptrial";
    $trialdir  = "NB0.55.TB20.NS8.TS200";
}
elsif ($dom =~ /^s\_mit$/) {
    $root      = "16S_mito_ua_ae2_cons_struct.85.phylip";
    $npt       = 40;
    $boot      = 100;    
    $ptrial    = "NB1.0.TB1.NS8.TS5";
    $ptrialdir = "NB1.0.TB10.NS8.TS5"; # change in another run
    $trialdir  = "NB1.0.TB1.NS8.TS200";
}
elsif ($dom =~ /^s\_chl$/) {
    $root      = "16S_chl_ua_ae2_cons_struct.85.phylip";
    $npt       = 40;
    $boot      = 100;    
    $ptrial    = "NB0.7.TB20.NS8.TS5";
    $ptrialdir = "$ptrial";
    $trialdir  = "NB0.7.TB20.NS8.TS200";
}
#LSU
elsif ($dom =~ /^l\_arc$/) {
    $root      = "23S_arc_ae2_refcons_rf.85.phylip";
    $npt       = 50;
    $boot      = 100;    
    $ptrial    = "NB0.35.TB40.NS8.TS2";
    $ptrialdir = "NB0.35.TB40.NS8.TS2";
    $trialdir  = "NB0.35.TB40.NS8.TS100";
}
elsif ($dom =~ /^l\_bac$/) {
    $root      = "23S_bac_ae2_refcons_rf.85.phylip";
    $npt       = 20;
    $boot      = 100;    
    $ptrial    = "NB0.35.TB20.NS8.TS10";
    $ptrialdir = "NB0.35.TB20.NS8.TS10";
    $trialdir  = "NB0.35.TB20.NS8.TS200";
}
elsif ($dom =~ /^l\_chl$/) {
    $root      = "23S_chl_ae2_refcons_rf.85.phylip";
    $npt       = 50;
    $boot      = 100;    
    $ptrial    = "NB0.35.TB40.NS8.TS2";
    $ptrialdir = "NB0.35.TB40.NS8.TS2";
    $trialdir  = "NB0.35.TB40.NS8.TS100";
}
elsif ($dom =~ /^l\_euk$/) {
    $root      = "23S_euk_ae2_refcons_rf.85.phylip";
    $npt       = 20;
    $boot      = 100;    
    $ptrial    = "NB0.27.TB20.NS8.TS10";
    $ptrialdir = "NB0.27.TB20.NS8.TS10";
    $trialdir  = "NB0.27.TB20.NS8.TS200";
}
else {
    print "bad dom $dom\n";
    die;
}

my $N    = 3;

# run split in npt trials
my @ptrialdir;
for (my $t = 0; $t < $npt; $t ++) {
    my $num = $t+1;
    if ($npt == 1) { $ptrialdir[$t] = "$ptrialdir";      }
    else           { $ptrialdir[$t] = "$ptrialdir.$num"; }
}

# $ERATEDIR (shell env variable)
my $eratedir =  $ENV{'ERATEDIR'};
my $plotscript = "$eratedir/scripts/plot_bootstrap_averages.pl";

my @cavefile;
my @csconsfile;
my @csconsnhfile;
my @csconsavefile;

my @avefile;
my @sconsfile;
my @sconsnhfile;
my @sconsavefile;

# cat the files from the different partial directories
cat_files ($N, $npt, $ptrial, $trialdir, \@ptrialdir, \@avefile, \@sconsfile, \@sconsnhfile, \@sconsavefile, \@cavefile, \@csconsfile, \@csconsnhfile, \@csconsavefile);

# calculate averages
run_plot_bootstrap_averages($N, $root, $trialdir, $boot, \@cavefile, \@csconsfile, \@csconsnhfile, \@csconsavefile);

########################################################################################################
sub cat_files {
    my ($N, $npt, $ptrial, $trialdir, $ptrialdir_ref, 
	$avefile_ref, $sconsfile_ref, $sconsnhfile_ref, $sconsavefile_ref, 
	$cavefile_ref, $csconsfile_ref, $csconsnhfile_ref, $csconsavefile_ref) = @_;

    my $path = $trialdir;
    if ($opt_x) {
	$trialdir .= ".$opt_x";
    }
    
    # cleanup the directory
    if ($npt > 1 && !$opt_x) {
	system("rm -rf $trialdir\n");
	system("mkdir $trialdir\n");
    }
    
    for (my $n = 0; $n < $N; $n ++) {
	for (my $t = 0; $t < $npt; $t ++) {
	    my $m = $n*$npt+$t;
	    
	    if    ($n == 0) { 
		$avefile_ref->[$m]      = "$ptrialdir_ref->[$t]/$root.dnaml.$ptrial.boot$boot.averages"; 
		$sconsfile_ref->[$m]    = "$ptrialdir_ref->[$t]/$root.dnaml.$ptrial.boot$boot.consense.consense"; 
		$sconsnhfile_ref->[$m]  = "$ptrialdir_ref->[$t]/$root.dnaml.$ptrial.boot$boot.consense.consense.nh"; 
		$sconsavefile_ref->[$m] = "$ptrialdir_ref->[$t]/$root.dnaml.$ptrial.boot$boot.consense.consense.averages"; 
	    }
	    elsif ($n == 1) { 
		$avefile_ref->[$m]      = "$ptrialdir_ref->[$t]/$root.dnaml-erate.$ptrial.boot$boot.averages"; 
		$sconsfile_ref->[$m]    = "$ptrialdir_ref->[$t]/$root.dnaml-erate.$ptrial.boot$boot.consense.consense"; 
		$sconsnhfile_ref->[$m]  = "$ptrialdir_ref->[$t]/$root.dnaml-erate.$ptrial.boot$boot.consense.consense.nh"; 
		$sconsavefile_ref->[$m] = "$ptrialdir_ref->[$t]/$root.dnaml-erate.$ptrial.boot$boot.consense.consense.averages"; 
	    }
	    elsif ($n == 2) { 
		$avefile_ref->[$m]      = "$ptrialdir_ref->[$t]/$root.dnaml-erate.C.$ptrial.boot$boot.averages"; 
		$sconsfile_ref->[$m]    = "$ptrialdir_ref->[$t]/$root.dnaml-erate.C.$ptrial.boot$boot.consense.consense"; 
		$sconsnhfile_ref->[$m]  = "$ptrialdir_ref->[$t]/$root.dnaml-erate.C.$ptrial.boot$boot.consense.consense.nh"; 
		$sconsavefile_ref->[$m] = "$ptrialdir_ref->[$t]/$root.dnaml-erate.C.$ptrial.boot$boot.consense.consense.averages"; 
	    }
	}   
    }
    
    # the concatenated files
    for (my $n = 0; $n < $N; $n ++) {
	if    ($n == 0) { 
	    $cavefile_ref->[$n]      = "$trialdir/$root.dnaml.$path.boot$boot.averages"; 
	    $csconsfile_ref->[$n]    = "$trialdir/$root.dnaml.$path.boot$boot.consense.consense"; 
	    $csconsnhfile_ref->[$n]  = "$trialdir/$root.dnaml.$path.boot$boot.consense.consense.nh"; 
	    $csconsavefile_ref->[$n] = "$trialdir/$root.dnaml.$path.boot$boot.consense.consense.averages";
	}
	elsif ($n == 1) { 
	    $cavefile_ref->[$n]      = "$trialdir/$root.dnaml-erate.$path.boot$boot.averages"; 
	    $csconsfile_ref->[$n]    = "$trialdir/$root.dnaml-erate.$path.boot$boot.consense.consense"; 
	    $csconsnhfile_ref->[$n]  = "$trialdir/$root.dnaml-erate.$path.boot$boot.consense.consense.nh"; 
	    $csconsavefile_ref->[$n] = "$trialdir/$root.dnaml-erate.$path.boot$boot.consense.consense.averages";
	}
	elsif ($n == 2) { 
	    $cavefile_ref->[$n]      = "$trialdir/$root.dnaml-erate.C.$path.boot$boot.averages"; 
	    $csconsfile_ref->[$n]    = "$trialdir/$root.dnaml-erate.C.$path.boot$boot.consense.consense"; 
	    $csconsnhfile_ref->[$n]  = "$trialdir/$root.dnaml-erate.C.$path.boot$boot.consense.consense.nh"; 
	    $csconsavefile_ref->[$n] = "$trialdir/$root.dnaml-erate.C.$path.boot$boot.consense.consense.averages";
	}

	system("rm $cavefile_ref->[$n]\n");
	system("rm $csconsfile_ref->[$n]\n");
	system("rm $csconsnhfile_ref->[$n]\n");
	system("rm $csconsavefile_ref->[$n]\n");
    } 
    
    if (!$opt_c) {
	for (my $n = 0; $n < $N; $n ++) {
	    my $cmd1 = "";
	    my $cmd2 = "";
	    my $cmd3 = "";
	    my $cmd4 = "";
	    
	    for (my $t = 0; $t < $npt; $t ++) {
		my $m = $n*$npt+$t;
		
		$cmd1 .= "$avefile_ref->[$m] ";
		$cmd2 .= "$sconsfile_ref->[$m] ";
		$cmd3 .= "$sconsnhfile_ref->[$m] ";
		$cmd4 .= "$sconsavefile_ref->[$m] ";
		
	    }
	    
	    system ("cat $cmd1 > $cavefile_ref->[$n]\n");
	    system ("cat $cmd2 > $csconsfile_ref->[$n]\n");
	    system ("cat $cmd3 > $csconsnhfile_ref->[$n]\n");
	    system ("cat $cmd4 > $csconsavefile_ref->[$n]\n");
	}
    }
}

sub run_plot_bootstrap_averages {
    my ($N, $root, $trialdir, $boot, $cavefile_ref, $csconsfile_ref, $csconsnhfile_ref, $csconsavefile_ref) = @_;

    my $cmd = "-s $N $root $trialdir $boot";
    system ("$plotscript $cmd\n");

}
