#!/usr/bin/perl -w
#plot_concordance_averages.pl

use strict;
use Class::Struct;

use vars qw ($opt_s $opt_D);  # required if strict used
use Getopt::Std;
use constant GNUPLOT => '/usr/bin/gnuplot';
getopts ('sD');


# Print a helpful message if the user provides no input file.
if (!@ARGV) {
        print "usage:  plot_concordance_averages.pl [options] N msa trial which\n\n";
        print "options:\n";
	print "-s       :  see the plots\n";
	print "-D       :  use dnaml-erate-dev [ default dnaml-erate]\n";
	exit;
}

my $N     = shift;
my $root  = shift;
my $trial = shift;
my $which = shift;
my @avefile;

my $which_dnamle = "dnaml-erate";
if ($opt_D) { $which_dnamle .= "-dev"; }

for (my $n = 0; $n < $N; $n ++) {
    if ($N == 1) { 
	$avefile[$n]  = "$trial/$root.$which.$trial.averages";  
    }
    else {
	if    ($n == 0) { 
	    $avefile[$n]  = "$trial/$root.dnaml.$trial.averages"; 
	}
	elsif ($n == 1) { 
	    $avefile[$n]  = "$trial/$root.$which_dnamle.$trial.averages"; 
	}
	elsif ($n == 2) { 
	    $avefile[$n]  = "$trial/$root.$which_dnamle.C.$trial.averages"; 
	}
    }
}

my $seeplots = 0;
if ($opt_s) { $seeplots = 1; }

my @key1;
my @key2;
my @title1;
my @title2;
my $xlabel;

my @tphistofile;
my @d1histofile;
my @d2histofile;

#plots respect to frequency of indels
my @tpfracfofile;
my @tpfofile;
my @d1fofile;
my @d2fofile;
my @likefofile;
my @ablfofile;
my @alpfofile;
my @betfofile;
my @insfofile;
my @delfofile;
my @ipfofile;
my @apbfofile;
my @lpmfofile;
my @lomfofile;
my @frsfofile;
my @frcfofile;
my @ttrfofile;
my @timefofile;
my @mutfofile;

#plots respect to geometric mean of sequences lengths
my @tpfracsqlgfile;
my @tpsqlgfile;
my @d1sqlgfile;
my @d2sqlgfile;
my @likesqlgfile;
my @ablsqlgfile;
my @alpsqlgfile;
my @betsqlgfile;
my @inssqlgfile;
my @delsqlgfile;
my @ipsqlgfile;

my @apbsqlgfile;
my @lpmsqlgfile;
my @lomsqlgfile;
my @frssqlgfile;
my @frcsqlgfile;
my @ttrsqlgfile;
my @timesqlgfile;
my @mutsqlgfile;

#plots respect to average branch length
my @tpfracablfile;
my @tpablfile;
my @d1ablfile;
my @d2ablfile;
my @likeablfile;
my @ablablfile;
my @alpablfile;
my @betablfile;
my @insablfile;
my @delablfile;
my @ipablfile;
my @apbablfile;
my @lpmablfile;
my @lomablfile;
my @frsablfile;
my @frcablfile;
my @ttrablfile;
my @timeablfile;
my @mutablfile;


my $Nb = 1;
my $kb = 100;
my $Nf = 1;
my $kf = 300;
my $Nl = 5000;
my $kl = 1/5;
my $Nd = 20;
my $kd = 10;
my $Na = 20;
my $ka = 100;

for (my $n = 0; $n < $N; $n ++) {
    parse_averagesfile($avefile[$n], \$title1[$n], \$key1[$n],
		       $Nb, $kb, $Nf, $kf, $Nl, $kl, $Nd, $kd, $Na, $ka,
		       \$tphistofile[$n],   \$d1histofile[$n], \$d2histofile[$n],  
		       \$tpfracfofile[$n],  \$tpfofile[$n],    \$d1fofile[$n],   
		       \$d2fofile[$n],      \$likefofile[$n], 
		       \$ablfofile[$n],     \$alpfofile[$n],  
		       \$betfofile[$n],     \$insfofile[$n],  
		       \$delfofile[$n],     \$ipfofile[$n],   
		       \$apbfofile[$n],     \$lpmfofile[$n],  
		       \$lomfofile[$n],     \$frsfofile[$n],  
		       \$frcfofile[$n],     \$ttrfofile[$n], 
		       \$timefofile[$n],    \$mutfofile[$n], 
  		       \$tpfracsqlgfile[$n],\$tpsqlgfile[$n],   \$d1sqlgfile[$n], 
		       \$d2sqlgfile[$n],    \$likesqlgfile[$n], 
		       \$ablsqlgfile[$n],   \$alpsqlgfile[$n],  
		       \$betsqlgfile[$n],   \$inssqlgfile[$n],  
		       \$delsqlgfile[$n],   \$ipsqlgfile[$n],   
		       \$apbsqlgfile[$n],   \$lpmsqlgfile[$n],  
		       \$lomsqlgfile[$n],   \$frssqlgfile[$n],  
		       \$frcsqlgfile[$n],   \$ttrsqlgfile[$n], 
		       \$timesqlgfile[$n],  \$mutsqlgfile[$n], 
  		       \$tpfracablfile[$n], \$tpablfile[$n],     \$d1ablfile[$n], 
		       \$d2ablfile[$n],     \$likeablfile[$n], 
		       \$ablablfile[$n],    \$alpablfile[$n],  
		       \$betablfile[$n],    \$insablfile[$n],  
		       \$delablfile[$n],    \$ipablfile[$n],   
		       \$apbablfile[$n],    \$lpmablfile[$n],  
		       \$lomablfile[$n],    \$frsablfile[$n],  
		       \$frcablfile[$n],    \$ttrablfile[$n], 
		       \$timeablfile[$n],   \$mutablfile[$n]);
}


############
# plotting
#############
$xlabel = "FRACTION OF TREE CONCORDANCES";
gnuplot_histo($N, 1/$kf, \@tphistofile,  $root, $title1[0], $xlabel, \@key1, "$trial/tp_histo",     0);

$xlabel = "NORMALIZED BRANCH SCORE DISTANCE";
gnuplot_histo($N, 1/$kd, \@d1histofile,  $root, $title1[0], $xlabel, \@key1, "$trial/d1_histo",     1);

$xlabel = "SYMMETRIC DIFFERENCE DISTANCE";
gnuplot_histo($N, 1, \@d2histofile,  $root, $title1[0], $xlabel, \@key1, "$trial/d2_histo",     1);

$xlabel = "AVERAGE FRACTION TOTAL INDELS";
my $seefoplot = 1;
gnuplot_fo_unnormalized_setxrange_setyrange_histo($N, 1/$kf, \@tpfofile,        $root, $title1[0], \@key1, "$trial/tpfo",         $xlabel,    "NUMBER OF TREE CONCORDANCES", 0, 0.65, 0, 900, $seefoplot);

gnuplot_fo_setxrange_setyrange_histo($N, 1/$kf, \@tpfracfofile,    $root, $title1[0], \@key1, "$trial/tpfracfo",     $xlabel,    "FRACTION OF TREE CONCORDANCES",         0, 0.65, 0, 1,  $seefoplot, 0);
gnuplot_fo_setxrange_setyrange_histo($N, 1/$kf, \@d1fofile,        $root, $title1[0], \@key1, "$trial/d1fo",         $xlabel,    "NORMALIZED BRANCH SCORE DISTANCE",      0, 0.65, 0, 3,  $seefoplot, 0);
gnuplot_fo_setxrange_setyrange_histo($N, 1/$kf, \@d2fofile,        $root, $title1[0], \@key1, "$trial/d2fo",         $xlabel,    "SYMMETRIC DIFFERENCE DISTANCE",         0, 0.65, 0, 10, $seefoplot, 0);
gnuplot_fo_setxrange_setyrange_histo($N, 1/$kf, \@timefofile,      $root, $title1[0], \@key1, "$trial/timefo",       $xlabel,    "AVERAGE TIME (secs)",                   0, 0.65, 0, 60, $seefoplot, 0);

gnuplot_fo_histo($N, 1/$kf, \@likefofile,      $root, $title1[0], \@key1, "$trial/likefo",       $xlabel,    "AVERAGE LIKELIHOOD",                    $seefoplot, 0);
gnuplot_fo_histo($N, 1/$kf, \@ablfofile,       $root, $title1[0], \@key1, "$trial/ablfo",        $xlabel,    "AVERAGE BRANCH LENGTH",                 $seefoplot, 0);
gnuplot_fo_histo($N, 1/$kf, \@alpfofile,       $root, $title1[0], \@key1, "$trial/alpfo",        $xlabel,    "AVERAGE ALPHA",                         $seefoplot, 0);
gnuplot_fo_histo($N, 1/$kf, \@betfofile,       $root, $title1[0], \@key1, "$trial/betfo",        $xlabel,    "AVERAGE BETA",                          $seefoplot, 0);
gnuplot_fo_histo($N, 1/$kf, \@insfofile,       $root, $title1[0], \@key1, "$trial/insfo",        $xlabel,    "AVERAGE INSERTIONS RATE",               $seefoplot, 0);
gnuplot_fo_histo($N, 1/$kf, \@delfofile,       $root, $title1[0], \@key1, "$trial/delfo",        $xlabel,    "AVERAGE DELETIONS RATE",                $seefoplot, 0);
gnuplot_fo_histo($N, 1/$kf, \@ipfofile,        $root, $title1[0], \@key1, "$trial/ipfo",         $xlabel,    "AVERAGE INDEL PRIOR",                   0, 0, "x");
gnuplot_fo_histo($N, 1/$kf, \@apbfofile,       $root, $title1[0], \@key1, "$trial/apbfo",        $xlabel,    "AVERAGE ALPHA + BETA",                  0, 0, "1");
gnuplot_fo_histo($N, 1/$kf, \@lpmfofile,       $root, $title1[0], \@key1, "$trial/lpmfo",        $xlabel,    "AVERAGE INS + DEL",                     $seefoplot, 0, "x");
gnuplot_fo_histo($N, 1/$kf, \@lomfofile,       $root, $title1[0], \@key1, "$trial/lomfo",        $xlabel,    "AVERAGE DEL over INS",                  0, 0);
gnuplot_fo_histo($N, 1/$kf, \@frsfofile,       $root, $title1[0], \@key1, "$trial/frsfo",        $xlabel,    "AVERAGE SUBS CHANGE",                   0, 0);
gnuplot_fo_histo($N, 1/$kf, \@frcfofile,       $root, $title1[0], \@key1, "$trial/frcfo",        $xlabel,    "AVERAGE TOTAL CHANGE",                  0, 0);
gnuplot_fo_histo($N, 1/$kf, \@ttrfofile,       $root, $title1[0], \@key1, "$trial/ttrfo",        $xlabel,    "AVERAGE TRANSITION-TRANSVERSION RATIO", $seefoplot, 0);
gnuplot_fo_histo($N, 1/$kf, \@mutfofile,       $root, $title1[0], \@key1, "$trial/mutfo",        $xlabel,    "AVERAGE % PAIRWISE MUTATIONS",          0, 0);

$xlabel = "AVERAGE GEOMETRIC MEAN SEQS LENGTH";
my $seesqlgplot = 0;
gnuplot_fo_unnormalized_histo($N, 1/$kl, \@tpsqlgfile,      $root, $title1[0], \@key1, "$trial/tpsqlg",         $xlabel,    "NUMBER OF TREE CONCORDANCES", $seesqlgplot);

gnuplot_fo_setyrange_histo($N, 1/$kl, \@tpfracsqlgfile,  $root, $title1[0], \@key1, "$trial/tpfracsqlg",     $xlabel,    "FRACTION OF TREE CONCORDANCES",         0, 1,  $seesqlgplot, 0);
gnuplot_fo_setyrange_histo($N, 1/$kl, \@d1sqlgfile,      $root, $title1[0], \@key1, "$trial/d1sqlg",         $xlabel,    "NORMALIZED BRANCH SCORE DISTANCE",      0, 3,  $seesqlgplot, 0);
gnuplot_fo_setyrange_histo($N, 1/$kl, \@d2sqlgfile,      $root, $title1[0], \@key1, "$trial/d2sqlg",         $xlabel,    "SYMMETRIC DIFFERENCE DISTANCE",         0, 10, $seesqlgplot, 0);

gnuplot_fo_histo($N, 1/$kl, \@likesqlgfile,    $root, $title1[0], \@key1, "$trial/likesqlg",       $xlabel,    "AVERAGE LIKELIHOOD",                    $seesqlgplot, 0);
gnuplot_fo_histo($N, 1/$kl, \@ablsqlgfile,     $root, $title1[0], \@key1, "$trial/ablsqlg",        $xlabel,    "AVERAGE BRANCH LENGTH",                 $seesqlgplot, 0);
gnuplot_fo_histo($N, 1/$kl, \@alpsqlgfile,     $root, $title1[0], \@key1, "$trial/alpsqlg",        $xlabel,    "AVERAGE ALPHA",                         $seesqlgplot, 0);
gnuplot_fo_histo($N, 1/$kl, \@betsqlgfile,     $root, $title1[0], \@key1, "$trial/betsqlg",        $xlabel,    "AVERAGE BETA",                          $seesqlgplot, 0);
gnuplot_fo_histo($N, 1/$kl, \@inssqlgfile,     $root, $title1[0], \@key1, "$trial/inssqlg",        $xlabel,    "AVERAGE INSERTIONS RATE",               $seesqlgplot, 0);
gnuplot_fo_histo($N, 1/$kl, \@delsqlgfile,     $root, $title1[0], \@key1, "$trial/delsqlg",        $xlabel,    "AVERAGE DELETIONS RATE",                $seesqlgplot, 0);
gnuplot_fo_histo($N, 1/$kl, \@ipsqlgfile,      $root, $title1[0], \@key1, "$trial/ipsqlg",         $xlabel,    "AVERAGE INDEL PRIOR",                   $seesqlgplot, 0);
gnuplot_fo_histo($N, 1/$kl, \@apbsqlgfile,     $root, $title1[0], \@key1, "$trial/apbsqlg",        $xlabel,    "AVERAGE ALPHA + BETA",                  $seesqlgplot, 0, "1");
gnuplot_fo_histo($N, 1/$kl, \@lpmsqlgfile,     $root, $title1[0], \@key1, "$trial/lpmsqlg",        $xlabel,    "AVERAGE INS + DEL",                     $seesqlgplot, 0, "1");
gnuplot_fo_histo($N, 1/$kl, \@lomsqlgfile,     $root, $title1[0], \@key1, "$trial/lomsqlg",        $xlabel,    "AVERAGE DEL over INS",                  $seesqlgplot, 0);
gnuplot_fo_histo($N, 1/$kl, \@frssqlgfile,     $root, $title1[0], \@key1, "$trial/frssqlg",        $xlabel,    "AVERAGE SUBS CHANGE",                   0,            0);
gnuplot_fo_histo($N, 1/$kl, \@frcsqlgfile,     $root, $title1[0], \@key1, "$trial/frcsqlg",        $xlabel,    "AVERAGE TOTAL CHANGE",                  0,            0);
gnuplot_fo_histo($N, 1/$kl, \@ttrsqlgfile,     $root, $title1[0], \@key1, "$trial/ttrsqlg",        $xlabel,    "AVERAGE TRANSITION-TRANSVERSION RATIO", $seesqlgplot, 0);
gnuplot_fo_histo($N, 1/$kl, \@timesqlgfile,    $root, $title1[0], \@key1, "$trial/timesqlg",       $xlabel,    "AVERAGE TIME (secs)",                   $seesqlgplot, 0);
gnuplot_fo_histo($N, 1/$kl, \@mutsqlgfile,     $root, $title1[0], \@key1, "$trial/mutsqlg",        $xlabel,    "AVERAGE % PAIRWISE MUTATIONS",          0,            0);

$xlabel = "AVERAGE BRANCH LENGTH";
my $seeablplot = 0;
gnuplot_fo_unnormalized_histo($N, 1/$ka, \@tpablfile,      $root, $title1[0], \@key1, "$trial/tpabl",         $xlabel,    "NUMBER OF TREE CONCORDANCES", 0);

gnuplot_fo_setyrange_histo($N, 1/$ka, \@tpfracablfile,  $root, $title1[0], \@key1, "$trial/tpfracabl",     $xlabel,    "FRACTION OF TREE CONCORDANCES",        0, 1,  0, 0);
gnuplot_fo_setyrange_histo($N, 1/$ka, \@d1ablfile,      $root, $title1[0], \@key1, "$trial/d1abl",         $xlabel,    "NORMALIZED BRANCH SCORE DISTANCE",     0, 3,  0, 0);
gnuplot_fo_setyrange_histo($N, 1/$ka, \@d2ablfile,      $root, $title1[0], \@key1, "$trial/d2abl",         $xlabel,    "SYMMETRIC DIFFERENCE DISTANCE",        0, 10, 0, 0);

gnuplot_fo_histo($N, 1/$ka, \@likeablfile,    $root, $title1[0], \@key1, "$trial/likeabl",       $xlabel,    "AVERAGE LIKELIHOOD",                    $seeablplot, 0);
gnuplot_fo_histo($N, 1/$ka, \@ablablfile,     $root, $title1[0], \@key1, "$trial/ablabl",        $xlabel,    "AVERAGE BRANCH LENGTH",                 $seeablplot, 0);
gnuplot_fo_histo($N, 1/$ka, \@alpablfile,     $root, $title1[0], \@key1, "$trial/alpabl",        $xlabel,    "AVERAGE ALPHA",                         $seeablplot, 0);
gnuplot_fo_histo($N, 1/$ka, \@betablfile,     $root, $title1[0], \@key1, "$trial/betabl",        $xlabel,    "AVERAGE BETA",                          $seeablplot, 0);
gnuplot_fo_histo($N, 1/$ka, \@insablfile,     $root, $title1[0], \@key1, "$trial/insabl",        $xlabel,    "AVERAGE INSERTIONS RATE",               $seeablplot, 0);
gnuplot_fo_histo($N, 1/$ka, \@delablfile,     $root, $title1[0], \@key1, "$trial/delabl",        $xlabel,    "AVERAGE DELETIONS RATE",                $seeablplot, 0);
gnuplot_fo_histo($N, 1/$ka, \@ipablfile,      $root, $title1[0], \@key1, "$trial/ipabl",         $xlabel,    "AVERAGE INDEL PRIOR",                   $seeablplot, 0);
gnuplot_fo_histo($N, 1/$ka, \@apbablfile,     $root, $title1[0], \@key1, "$trial/apbabl",        $xlabel,    "AVERAGE ALPHA + BETA",                  $seeablplot, 0, "1");
gnuplot_fo_histo($N, 1/$ka, \@lpmablfile,     $root, $title1[0], \@key1, "$trial/lpmabl",        $xlabel,    "AVERAGE INS + DEL",                     $seeablplot, 0, "1");
gnuplot_fo_histo($N, 1/$ka, \@lomablfile,     $root, $title1[0], \@key1, "$trial/lomabl",        $xlabel,    "AVERAGE DEL over INS",                  $seeablplot, 0);
gnuplot_fo_histo($N, 1/$ka, \@frsablfile,     $root, $title1[0], \@key1, "$trial/frsabl",        $xlabel,    "AVERAGE SUBS CHANGE",                   0,            0);
gnuplot_fo_histo($N, 1/$ka, \@frcablfile,     $root, $title1[0], \@key1, "$trial/frcabl",        $xlabel,    "AVERAGE TOTAL CHANGE",                  0,            0);
gnuplot_fo_histo($N, 1/$ka, \@ttrablfile,     $root, $title1[0], \@key1, "$trial/ttrabl",        $xlabel,    "AVERAGE TRANSITION-TRANSVERSION RATIO", $seeablplot, 0);
gnuplot_fo_histo($N, 1/$ka, \@timeablfile,    $root, $title1[0], \@key1, "$trial/timeabl",       $xlabel,    "AVERAGE TIME (secs)",                   $seeablplot, 0);
gnuplot_fo_histo($N, 1/$ka, \@mutablfile,     $root, $title1[0], \@key1, "$trial/mutabl",        $xlabel,    "AVERAGE % PAIRWISE MUTATIONS",          0,            0);


######################################################################
sub accumulate_averages {
    my ($val, $meanval_ref, $meansquareval_ref) = @_;

    $$meanval_ref       += $val;
    $$meansquareval_ref += $val*$val;
}

sub calculate_averages {
    my ($meanval_ref, $stdval_ref, $number) = @_;

    my $mean = $$meanval_ref;
    my $std  = $$stdval_ref;

    if ($number > 1) {
	$mean /= $number;
	
	$std -= $mean*$mean*$number;
	$std /= ($number-1);
	if ($std < 0. && $std> -0.00001) { $std = 0.0; }
	$std  = sqrt($std);
    }
    elsif ($number == 1) {
	$mean /= $number;
	$std   = 0.0;
    }
    else {
	$mean = 0.0;
	$std  = 0.0;
    }

    $$meanval_ref = $mean;
    $$stdval_ref  = $std;

}

sub fill_histo_array {
    my ($val, $len, $N, $k, $his_ref) = @_;
    my $dim = $N * $k;
    
    if ($len >=  $N) { $his_ref->[$dim] += 1; return; }

    for (my $i=0; $i<=$dim; $i++) { 
	if ( $i/$k <= $len && $len < ($i+1)/$k) { 
	    $his_ref->[$i] += $val; 
	    last; 
	} 
    }
}

sub gnuplot_fo_histo {

    my ($N, $frac, $filehisto_ref, $root, $title, $key_ref, $name, $xlabel, $ylabel, $view1, $view2, $func) = @_;

    my $outplot1 = "$name.ps";
    my $outplot2 = "$name.histo.ps";

    my $n;
    my $m;
    my $cmd;

    my $name2 = $root;
    if ($name2 =~ /^(\S+).phylip/) { $name2 = $1; }
  
    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";

    print GP "set terminal postscript color solid 14\n";
    print GP "set style line 1 lt 1 lw 4\n";
    print GP "set style line 2 lt 2 lw 4\n";
    print GP "set style line 3  lt 3 lw 4\n";
    print GP "set style line 4 lt 4 lw 4\n";+
    print GP "set style line 5 lt 5 lw 4\n";
    print GP "set style line 6 lt 6 lw 4\n";
    print GP "set style line 7 lt 7 lw 4\n";
    print GP "set style line 8 lt 8 lw 4\n";
    print GP "set style line 9 lt 9 lw 4\n";
    print GP "set style line 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set style line 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set style line 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set style line 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set style line 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set style line 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set style line 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set style line 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set style line 99 lt 9 lw 2 pt 9 ps 1.2\n";
 
    print GP "set output '$outplot1'\n";
    #print GP "set nokey\n";
    print GP "set xlabel '$xlabel'\n";
    print GP "set title \"$name2\\n\\n$title\"\n";
    print GP "set ylabel '$ylabel'\n";

    # plot dnaml/dnaml-erate.C
    $cmd = "";
    if ($func) {
	$cmd .= "$func ls 9, ";
    }
    $n = 0;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key_ref->[$n]' ls $m, ";
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3  with points title '$key_ref->[$N-1]' ls $N";
    print GP "plot $cmd\n";

    $cmd = "";
    $n = 0;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3:4  with yerrorbars title '$key_ref->[$n]' ls $m, ";
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3:4  with yerrorbars title '$key_ref->[$N-1]' ls $N";
    print GP "plot $cmd\n";
    
    # plot dnaml/dnaml-erate/dnaml-erate.C
    $cmd = "";
    if ($func) {
	$cmd .= "$func ls 9, ";
    }
    for ($n = 0; $n < $N-1; $n ++) {
	$m = $n+1;
	$cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key_ref->[$n]' ls $m, ";
    }
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3  with points title '$key_ref->[$N-1]' ls $N";
    #print "$cmd\n";
    print GP "plot $cmd\n";

    $cmd = "";
    if ($func) {
	$cmd .= "$func ls 9, ";
    }
    for ($n = 0; $n < $N-1; $n ++) {
	$m = $n+1;
	$cmd .= "'$filehisto_ref->[$n]' using 1:3:4  with yerrorbars title '$key_ref->[$n]' ls $m, ";
    }
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3:4  with yerrorbars title '$key_ref->[$N-1]' ls $N";
    #print "$cmd\n";
    print GP "plot $cmd\n";

    # histogram
    #
    print GP "set output '$outplot2'\n";
    print GP "set nokey\n";
    print GP "set xlabel '$xlabel'\n";
    print GP "set title \"$name2\\n\\n$title\"\n";
    print GP "set ylabel '\#'\n";
    print GP "set boxwidth $frac\n";
    $cmd = "'$filehisto_ref->[$N-1]' using 1:2  with boxes ls $N";
    print GP "plot $cmd\n";

    close (GP);

    if ($view1) { 
	system ("ggv -landscape -magstep -2 $outplot1&\n"); 
    }
    if ($view2) { 
	system ("ggv -landscape -magstep -2 $outplot2&\n"); 
    }

}

sub gnuplot_fo_setxrange_histo {

    my ($N, $frac, $filehisto_ref, $root, $title, $key_ref, $name, $xlabel, $ylabel, $xmin, $xmax, $view1, $view2, $func) = @_;

    my $outplot1 = "$name.ps";
    my $outplot2 = "$name.histo.ps";

    my $n;
    my $m;
    my $cmd;

    my $name2 = $root;
    if ($name2 =~ /^(\S+).phylip/) { $name2 = $1; }

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";

    print GP "set terminal postscript color solid 14\n";
    print GP "set style line 1 lt 1 lw 4\n";
    print GP "set style line 2 lt 2 lw 4\n";
    print GP "set style line 3  lt 3 lw 4\n";
    print GP "set style line 4 lt 4 lw 4\n";+
    print GP "set style line 5 lt 5 lw 4\n";
    print GP "set style line 6 lt 6 lw 4\n";
    print GP "set style line 7 lt 7 lw 4\n";
    print GP "set style line 8 lt 8 lw 4\n";
    print GP "set style line 9 lt 9 lw 4\n";
    print GP "set style line 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set style line 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set style line 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set style line 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set style line 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set style line 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set style line 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set style line 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set style line 99 lt 9 lw 2 pt 9 ps 1.2\n";
 
    print GP "set output '$outplot1'\n";
    #print GP "set nokey\n";
    print GP "set xlabel '$xlabel'\n";
    print GP "set title \"$name2\\n\\n$title\"\n";
    print GP "set ylabel '$ylabel'\n";
    print GP "set xrange [$xmin:$xmax]\n";

    # plot dnaml/dnaml-erate.C
    $cmd = "";
    if ($func) {
	$cmd .= "$func ls 9, ";
    }
    $n = 0;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key_ref->[$n]' ls $m, ";
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3  with points title '$key_ref->[$N-1]' ls $N";
    print GP "plot $cmd\n";

    $cmd = "";
    $n = 0;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3:4  with yerrorbars title '$key_ref->[$n]' ls $m, ";
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3:4  with yerrorbars title '$key_ref->[$N-1]' ls $N";
    print GP "plot $cmd\n";
    
    # plot dnaml/dnaml-erate/dnaml-erate.C
    $cmd = "";
    if ($func) {
	$cmd .= "$func ls 9, ";
    }
    for ($n = 0; $n < $N-1; $n ++) {
	$m = $n+1;
	$cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key_ref->[$n]' ls $m, ";
    }
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3  with points title '$key_ref->[$N-1]' ls $N";
    #print "$cmd\n";
    print GP "plot $cmd\n";

    $cmd = "";
    if ($func) {
	$cmd .= "$func ls 9, ";
    }
    for ($n = 0; $n < $N-1; $n ++) {
	$m = $n+1;
	$cmd .= "'$filehisto_ref->[$n]' using 1:3:4  with yerrorbars title '$key_ref->[$n]' ls $m, ";
    }
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3:4  with yerrorbars title '$key_ref->[$N-1]' ls $N";
    #print "$cmd\n";
    print GP "plot $cmd\n";

    # histogram
    #
    print GP "set output '$outplot2'\n";
    print GP "set nokey\n";
    print GP "set xlabel '$xlabel'\n";
    print GP "set title \"$name2\\n\\n$title\"\n";
    print GP "set ylabel '\#'\n";
    print GP "set boxwidth $frac\n";
    $cmd = "'$filehisto_ref->[$N-1]' using 1:2  with boxes ls $N";
    print GP "plot $cmd\n";

    close (GP);

    if ($view1) { 
	system ("ggv -landscape -magstep -2 $outplot1&\n"); 
    }
    if ($view2) { 
	system ("ggv -landscape -magstep -2 $outplot2&\n"); 
    }

}

sub gnuplot_fo_setyrange_histo {

    my ($N, $frac, $filehisto_ref, $root, $title, $key_ref, $name, $xlabel, $ylabel, $ymin, $ymax, $view1, $view2, $func) = @_;

    my $outplot1 = "$name.ps";
    my $outplot2 = "$name.histo.ps";

    my $n;
    my $m;
    my $cmd;

    my $name2 = $root;
    if ($name2 =~ /^(\S+).phylip/) { $name2 = $1; }

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";

    print GP "set terminal postscript color solid 14\n";
    print GP "set style line 1 lt 1 lw 4\n";
    print GP "set style line 2 lt 2 lw 4\n";
    print GP "set style line 3  lt 3 lw 4\n";
    print GP "set style line 4 lt 4 lw 4\n";+
    print GP "set style line 5 lt 5 lw 4\n";
    print GP "set style line 6 lt 6 lw 4\n";
    print GP "set style line 7 lt 7 lw 4\n";
    print GP "set style line 8 lt 8 lw 4\n";
    print GP "set style line 9 lt 9 lw 4\n";
    print GP "set style line 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set style line 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set style line 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set style line 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set style line 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set style line 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set style line 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set style line 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set style line 99 lt 9 lw 2 pt 9 ps 1.2\n";
 
    print GP "set output '$outplot1'\n";
    #print GP "set nokey\n";
    print GP "set xlabel '$xlabel'\n";
    print GP "set title \"$name2\\n\\n$title\"\n";
    print GP "set ylabel '$ylabel'\n";
    print GP "set yrange [$ymin:$ymax]\n";

    # plot dnaml/dnaml-erate
    $cmd = "";
    if ($func) {
	$cmd .= "$func ls 9, ";
    }
    $n = 0;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key_ref->[$n]' ls $m, ";
    $n = 1;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key_ref->[$n]' ls $m";
    print GP "plot $cmd\n";

    $cmd = "";
    $n = 0;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3:4  with yerrorbars title '$key_ref->[$n]' ls $m, ";
    $n = 1;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3:4  with yerrorbars title '$key_ref->[$n]' ls $m";
    print GP "plot $cmd\n";
    
    # plot dnaml/dnaml-erate.C
    $cmd = "";
    if ($func) {
	$cmd .= "$func ls 9, ";
    }
    $n = 0;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key_ref->[$n]' ls $m, ";
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3  with points title '$key_ref->[$N-1]' ls $N";
    print GP "plot $cmd\n";

    $cmd = "";
    $n = 0;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3:4  with yerrorbars title '$key_ref->[$n]' ls $m, ";
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3:4  with yerrorbars title '$key_ref->[$N-1]' ls $N";
    print GP "plot $cmd\n";
    
    # plot dnaml/dnaml-erate/dnaml-erate.C
    $cmd = "";
    if ($func) {
	$cmd .= "$func ls 9, ";
    }
    for ($n = 0; $n < $N-1; $n ++) {
	$m = $n+1;
	$cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key_ref->[$n]' ls $m, ";
    }
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3  with points title '$key_ref->[$N-1]' ls $N";
    #print "$cmd\n";
    print GP "plot $cmd\n";

    $cmd = "";
    if ($func) {
	$cmd .= "$func ls 9, ";
    }
    for ($n = 0; $n < $N-1; $n ++) {
	$m = $n+1;
	$cmd .= "'$filehisto_ref->[$n]' using 1:3:4  with yerrorbars title '$key_ref->[$n]' ls $m, ";
    }
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3:4  with yerrorbars title '$key_ref->[$N-1]' ls $N";
    #print "$cmd\n";
    print GP "plot $cmd\n";

    # histogram
    #
    print GP "set output '$outplot2'\n";
    print GP "set nokey\n";
    print GP "set xlabel '$xlabel'\n";
    print GP "set title \"$name2\\n\\n$title\"\n";
    print GP "set ylabel '\#'\n";
    print GP "set boxwidth $frac\n";
    $cmd = "'$filehisto_ref->[$N-1]' using 1:2  with boxes ls $N";
    print GP "plot $cmd\n";

    close (GP);

    if ($view1) { 
	system ("ggv -landscape -magstep -2 $outplot1&\n"); 
    }
    if ($view2) { 
	system ("ggv -landscape -magstep -2 $outplot2&\n"); 
    }

}

sub gnuplot_fo_setxrange_setyrange_histo {

    my ($N, $frac, $filehisto_ref, $root, $title, $key_ref, $name, $xlabel, $ylabel, $xmin, $xmax, $ymin, $ymax, $view1, $view2, $func) = @_;

    my $outplot1 = "$name.ps";
    my $outplot2 = "$name.histo.ps";

    my $n;
    my $m;
    my $cmd;

    my $name2 = $root;
    if ($name2 =~ /^(\S+).phylip/) { $name2 = $1; }

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";

    print GP "set terminal postscript color solid 14\n";
    print GP "set style line 1 lt 1 lw 4\n";
    print GP "set style line 2 lt 2 lw 4\n";
    print GP "set style line 3  lt 3 lw 4\n";
    print GP "set style line 4 lt 4 lw 4\n";+
    print GP "set style line 5 lt 5 lw 4\n";
    print GP "set style line 6 lt 6 lw 4\n";
    print GP "set style line 7 lt 7 lw 4\n";
    print GP "set style line 8 lt 8 lw 4\n";
    print GP "set style line 9 lt 9 lw 4\n";
    print GP "set style line 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set style line 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set style line 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set style line 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set style line 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set style line 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set style line 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set style line 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set style line 99 lt 9 lw 2 pt 9 ps 1.2\n";
 
    print GP "set output '$outplot1'\n";
    #print GP "set nokey\n";
    print GP "set xlabel '$xlabel'\n";
    print GP "set title \"$name2\\n\\n$title\"\n";
    print GP "set ylabel '$ylabel'\n";
    print GP "set xrange [$xmin:$xmax]\n";
    print GP "set yrange [$ymin:$ymax]\n";

    # plot dnaml/dnaml-erate
    $cmd = "";
    if ($func) {
	$cmd .= "$func ls 9, ";
    }
    $n = 0;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key_ref->[$n]' ls $m, ";
    $n = 1;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key_ref->[$n]' ls $m";
    print GP "plot $cmd\n";

    $cmd = "";
    $n = 0;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3:4  with yerrorbars title '$key_ref->[$n]' ls $m, ";
    $n = 1;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3:4  with yerrorbars title '$key_ref->[$n]' ls $m";
    print GP "plot $cmd\n";
    
    # plot dnaml/dnaml-erate.C
    $cmd = "";
    if ($func) {
	$cmd .= "$func ls 9, ";
    }
    $n = 0;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key_ref->[$n]' ls $m, ";
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3  with points title '$key_ref->[$N-1]' ls $N";
    print GP "plot $cmd\n";

    $cmd = "";
    $n = 0;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3:4  with yerrorbars title '$key_ref->[$n]' ls $m, ";
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3:4  with yerrorbars title '$key_ref->[$N-1]' ls $N";
    print GP "plot $cmd\n";
    
    # plot dnaml/dnaml-erate/dnaml-erate.C
    $cmd = "";
    if ($func) {
	$cmd .= "$func ls 9, ";
    }
    for ($n = 0; $n < $N-1; $n ++) {
	$m = $n+1;
	$cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key_ref->[$n]' ls $m, ";
    }
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3  with points title '$key_ref->[$N-1]' ls $N";
    #print "$cmd\n";
    print GP "plot $cmd\n";

    $cmd = "";
    if ($func) {
	$cmd .= "$func ls 9, ";
    }
    for ($n = 0; $n < $N-1; $n ++) {
	$m = $n+1;
	$cmd .= "'$filehisto_ref->[$n]' using 1:3:4  with yerrorbars title '$key_ref->[$n]' ls $m, ";
    }
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3:4  with yerrorbars title '$key_ref->[$N-1]' ls $N";
    #print "$cmd\n";
    print GP "plot $cmd\n";

    # histogram
    #
    print GP "set output '$outplot2'\n";
    print GP "set nokey\n";
    print GP "set xlabel '$xlabel'\n";
    print GP "set title \"$name2\\n\\n$title\"\n";
    print GP "set ylabel '\#'\n";
    print GP "set boxwidth $frac\n";
    $cmd = "'$filehisto_ref->[$N-1]' using 1:2  with boxes ls $N";
    print GP "plot $cmd\n";

    close (GP);

    if ($view1) { 
	system ("ggv -landscape -magstep -2 $outplot1&\n"); 
    }
    if ($view2) { 
	system ("ggv -landscape -magstep -2 $outplot2&\n"); 
    }

}

sub gnuplot_fo_unnormalized_histo {

    my ($N, $frac, $filehisto_ref, $root, $title, $key_ref, $name, $xlabel, $ylabel, $view) = @_;

    my $outplot = "$name.ps";

    my $n;
    my $m;
    my $cmd;

    my $name2 = $root;
    if ($name2 =~ /^(\S+).phylip/) { $name2 = $1; }

    my $ntrial;
    if ($title =~ /N\s*=\s*(\S+)\s+\/\s+(.+)$/) { $ntrial = $1; $title = $2; }

    my @key;
    for (my $n = 0; $n < $N; $n ++) {
	$key[$n] = $key_ref->[$n];
	if ($key[$n] =~ /^(.+TP\s+\S+)\s+\*\*\s+(.+)$/) {
	    $key[$n] = $1;
	}
    }

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";

    print GP "set terminal postscript color solid 14\n";
    print GP "set style line 1 lt 1 lw 4\n";
    print GP "set style line 2 lt 2 lw 4\n";
    print GP "set style line 3  lt 3 lw 4\n";
    print GP "set style line 4 lt 4 lw 4\n";+
    print GP "set style line 5 lt 5 lw 4\n";
    print GP "set style line 6 lt 6 lw 4\n";
    print GP "set style line 7 lt 7 lw 4\n";
    print GP "set style line 8 lt 8 lw 4\n";
    print GP "set style line 9 lt 9 lw 4\n";
    print GP "set style line 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set style line 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set style line 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set style line 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set style line 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set style line 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set style line 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set style line 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set style line 99 lt 9 lw 2 pt 9 ps 1.2\n";
 
    print GP "set output '$outplot'\n";
    #print GP "set nokey\n";
    print GP "set xlabel '$xlabel'\n";
    print GP "set title \"$name2\\n\\n$title\"\n";
    print GP "set ylabel '$ylabel'\n";
    print GP "set boxwidth $frac\n";

    my $key0 = "$ntrial total";

    # plot dnaml/dnaml-erate
    $n = 0;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key[$n]' ls $m, ";
    $n = 1;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key[$n]' ls $m";
    print GP "plot $cmd\n";

    # plot dnaml/dnaml-erate.C
    $n = 0;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key[$n]' ls $m, ";
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3  with points title '$key[$N-1]' ls $N";
    print GP "plot $cmd\n";

    # plot dnaml/dnaml-erate.C with histo
    $cmd = "'$filehisto_ref->[$N-1]' using 1:2  with steps title '$key0' ls 9, ";
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key[$n]' ls $m, ";
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3  with points title '$key[$N-1]' ls $N";
    print GP "plot $cmd\n";

    close (GP);

    if ($view) { 
	system ("ggv -landscape -magstep -2 $outplot&\n"); 
    }

}

sub gnuplot_fo_unnormalized_setxrange_histo {

    my ($N, $frac, $filehisto_ref, $root, $title, $key_ref, $name, $xlabel, $ylabel, $xmin, $xmax, $view) = @_;

    my $outplot = "$name.ps";

    my $n;
    my $m;
    my $cmd;

    my $name2 = $root;
    if ($name2 =~ /^(\S+).phylip/) { $name2 = $1; }

    my $ntrial;
    if ($title =~ /N\s*=\s*(\S+)\s+\/\s+(.+)$/) { $ntrial = $1; $title = $2; }

    my @key;
    for (my $n = 0; $n < $N; $n ++) {
	$key[$n] = $key_ref->[$n];
	if ($key[$n] =~ /^(.+TP\s+\S+)\s+\*\*\s+(.+)$/) {
	    $key[$n] = $1;
	}
    }

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";

    print GP "set terminal postscript color solid 14\n";
    print GP "set style line 1 lt 1 lw 4\n";
    print GP "set style line 2 lt 2 lw 4\n";
    print GP "set style line 3  lt 3 lw 4\n";
    print GP "set style line 4 lt 4 lw 4\n";+
    print GP "set style line 5 lt 5 lw 4\n";
    print GP "set style line 6 lt 6 lw 4\n";
    print GP "set style line 7 lt 7 lw 4\n";
    print GP "set style line 8 lt 8 lw 4\n";
    print GP "set style line 9 lt 9 lw 4\n";
    print GP "set style line 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set style line 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set style line 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set style line 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set style line 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set style line 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set style line 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set style line 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set style line 99 lt 9 lw 2 pt 9 ps 1.2\n";
 
    print GP "set output '$outplot'\n";
    #print GP "set nokey\n";
    print GP "set xlabel '$xlabel'\n";
    print GP "set title \"$name2\\n\\n$title\"\n";
    print GP "set ylabel '$ylabel'\n";
    print GP "set boxwidth $frac\n";
    print GP "set xrange [$xmin:$xmax]\n";

    my $key0 = "$ntrial total";

    # plot dnaml/dnaml-erate
    $n = 0;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key[$n]' ls $m, ";
    $n = 1;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key[$n]' ls $m";
    print GP "plot $cmd\n";

    # plot dnaml/dnaml-erate.C
    $n = 0;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key[$n]' ls $m, ";
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3  with points title '$key[$N-1]' ls $N";
    print GP "plot $cmd\n";

    # plot dnaml/dnaml-erate.C with histo
    $cmd = "'$filehisto_ref->[$N-1]' using 1:2  with steps title '$key0' ls 9, ";
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key[$n]' ls $m, ";
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3  with points title '$key[$N-1]' ls $N";
    print GP "plot $cmd\n";

    close (GP);

    if ($view) { 
	system ("ggv -landscape -magstep -2 $outplot&\n"); 
    }

}

sub gnuplot_fo_unnormalized_setxrange_setyrange_histo {

    my ($N, $frac, $filehisto_ref, $root, $title, $key_ref, $name, $xlabel, $ylabel, $xmin, $xmax, $ymin, $ymax, $view) = @_;

    my $outplot = "$name.ps";

    my $n;
    my $m;
    my $cmd;

    my $name2 = $root;
    if ($name2 =~ /^(\S+).phylip/) { $name2 = $1; }

    my $ntrial;
    if ($title =~ /N\s*=\s*(\S+)\s+\/\s+(.+)$/) { $ntrial = $1; $title = $2; }

    my @key;
    for (my $n = 0; $n < $N; $n ++) {
	$key[$n] = $key_ref->[$n];
	if ($key[$n] =~ /^(.+TP\s+\S+)\s+\*\*\s+(.+)$/) {
	    $key[$n] = $1;
	}
    }

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";

    print GP "set terminal postscript color solid 14\n";
    print GP "set style line 1 lt 1 lw 4\n";
    print GP "set style line 2 lt 2 lw 4\n";
    print GP "set style line 3  lt 3 lw 4\n";
    print GP "set style line 4 lt 4 lw 4\n";+
    print GP "set style line 5 lt 5 lw 4\n";
    print GP "set style line 6 lt 6 lw 4\n";
    print GP "set style line 7 lt 7 lw 4\n";
    print GP "set style line 8 lt 8 lw 4\n";
    print GP "set style line 9 lt 9 lw 4\n";
    print GP "set style line 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set style line 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set style line 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set style line 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set style line 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set style line 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set style line 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set style line 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set style line 99 lt 9 lw 2 pt 9 ps 1.2\n";
 
    print GP "set output '$outplot'\n";
    #print GP "set nokey\n";
    print GP "set xlabel '$xlabel'\n";
    print GP "set title \"$name2\\n\\n$title\"\n";
    print GP "set ylabel '$ylabel'\n";
    print GP "set boxwidth $frac\n";
    print GP "set xrange [$xmin:$xmax]\n";
    print GP "set yrange [$ymin:$ymax]\n";

    my $key0 = "$ntrial total";

    # plot dnaml/dnaml-erate
    $n = 0;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key[$n]' ls $m, ";
    $n = 1;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key[$n]' ls $m";
    print GP "plot $cmd\n";

    # plot dnaml/dnaml-erate with histo
    $n = 1;
    $m = $n+1;
    $cmd = "'$filehisto_ref->[$n]' using 1:2  with steps title '$key0' ls 9, ";
    $n = 0;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key[$n]' ls $m, ";
    $n = 1;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key[$n]' ls $m";
    print GP "plot $cmd\n";

    # plot dnaml/dnaml-erate.C
    $n = 0;
    $m = $n+1;
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key[$n]' ls $m, ";
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3  with points title '$key[$N-1]' ls $N";
    print GP "plot $cmd\n";

    # plot dnaml/dnaml-erate.C with histo
    $cmd = "'$filehisto_ref->[$N-1]' using 1:2  with steps title '$key0' ls 9, ";
    $cmd .= "'$filehisto_ref->[$n]' using 1:3  with points title '$key[$n]' ls $m, ";
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:3  with points title '$key[$N-1]' ls $N";
    print GP "plot $cmd\n";

    close (GP);

    if ($view) { 
	system ("ggv -landscape -magstep -2 $outplot&\n"); 
    }

}

sub gnuplot_histo {

    my ($N, $frac, $filehisto_ref, $root, $title, $xlabel, $key_ref, $name, $view) = @_;

    my $outplot = "$name.ps";
    my $ylabel;

    my $n;
    my $m;
    my $cmd;

    my $name2 = $root;
    if ($name2 =~ /^(\S+).phylip/) { $name2 = $1; }

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";

    print GP "set terminal postscript color solid 14\n";
    print GP "set style line 1 lt 1 lw 4\n";
    print GP "set style line 2 lt 2 lw 4\n";
    print GP "set style line 3  lt 3 lw 4\n";
    print GP "set style line 4 lt 4 lw 4\n";+
    print GP "set style line 5 lt 5 lw 4\n";
    print GP "set style line 6 lt 6 lw 4\n";
    print GP "set style line 7 lt 7 lw 4\n";
    print GP "set style line 8 lt 8 lw 4\n";
    print GP "set style line 9 lt 9 lw 4\n";
    print GP "set style line 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set style line 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set style line 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set style line 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set style line 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set style line 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set style line 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set style line 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set style line 99 lt 9 lw 2 pt 9 ps 1.2\n";
 
    print GP "set output '$outplot'\n";
    #print GP "set nokey\n";
    print GP "set xlabel '$xlabel'\n";

    print GP "set title \"$name2\\n\\n$title\"\n";

    $ylabel = "\# TRIALS";
    print GP "set ylabel '$ylabel'\n";
    print GP "set boxwidth $frac\n";

    $n = 0;
    $m = $n+1;
    $cmd = "'$filehisto_ref->[$n]' using 1:2  with boxes title '$key_ref->[$n]' ls $m, ";
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:2  with boxes title '$key_ref->[$N-1]' ls $N";
    #print "$cmd\n";
    print GP "plot $cmd\n";

    $cmd = "";
    for ($n = 0; $n < $N-1; $n ++) {
	$m = $n+1;
	$cmd .= "'$filehisto_ref->[$n]' using 1:2  with boxes title '$key_ref->[$n]' ls $m, ";
    }
    $cmd .= "'$filehisto_ref->[$N-1]' using 1:2  with boxes title '$key_ref->[$N-1]' ls $N";
    #print "$cmd\n";
    print GP "plot $cmd\n";

    close (GP);

    if ($view) { system ("ggv -landscape -magstep -2 $outplot&\n"); }

}

sub init_histo_array {
    my ($N, $k, $his_ref) = @_;
    my $dim = $N * $k;
    for (my $i=0; $i<=$dim; $i++) { $his_ref->[$i] = 0; }    
}


sub parse_avefile_bootfo {
    my ($avefile, $c_ref, $fo_ref, $tp_ref, $d1_ref, $d2_ref) = @_;

    my $n = 0;

    open(FILE, "$avefile");
    while(<FILE>) {
	if (/^(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+(\S+)\s+(\S+)/) {
	    my $alen      = $1;
	    my $sqlg      = $2;
	    my $id        = $3;
	    my $mut       = $4;
	    my $indl      = $5;
	    my $fo        = $6;
	    my $time      = $7;
	    my $abl       = $8;
	    my $alpha     = $9;
	    my $beta      = $10;
	    my $lambda    = $11;
	    my $mu        = $12;
	    my $ip        = $13;
	    my $like      = $14;
	    my $ttr       = $15;
	    my $apb       = $16;
	    my $frs       = $17;
	    my $frc       = $18;
	    my $tp        = $19;
	    my $d1        = $20;
	    my $d2        = $21;

	    $fo_ref->[$n] = $fo;
	    $tp_ref->[$n] = $tp;
	    $d1_ref->[$n] = $d1;
	    $d2_ref->[$n] = $d2;

	    $n ++;
	}
    }
    close (FILE);
    
    $$c_ref = $n;
}

sub parse_averagesfile { 
    my ($avefile, $title_ref, $key_ref,
	$Nb, $kb, $Nf, $kf, $Nl, $kl, $Nd, $kd, $Na, $ka,
	$tphistofile_ref,    $d1histofile_ref, $d2histofile_ref, 
	$tpfracfofile_ref,   $tpfofile_ref,     $d1fofile_ref, 
	$d2fofile_ref,       $likefofile_ref, 
	$ablfofile_ref,      $alpfofile_ref,  
	$betfofile_ref,      $insfofile_ref,  
	$delfofile_ref,      $ipfofile_ref,   
	$apbfofile_ref,      $lpmfofile_ref,  
	$lomfofile_ref,      $frsfofile_ref,  
	$frcfofile_ref,      $ttrfofile_ref,  
	$timefofile_ref,     $mutfofile_ref, 
	$tpfracsqlgfile_ref, $tpsqlgfile_ref,   $d1sqlgfile_ref, 
	$d2sqlgfile_ref,     $likesqlgfile_ref, 
	$ablsqlgfile_ref,    $alpsqlgfile_ref,  
	$betsqlgfile_ref,    $inssqlgfile_ref,  
	$delsqlgfile_ref,    $ipsqlgfile_ref,   
	$apbsqlgfile_ref,    $lpmsqlgfile_ref,  
	$lomsqlgfile_ref,    $frssqlgfile_ref,  
	$frcsqlgfile_ref,    $ttrsqlgfile_ref,  
	$timesqlgfile_ref,   $mutsqlgfile_ref, 
	$tpfracablfile_ref,  $tpablfile_ref,   $d1ablfile_ref, 
	$d2ablfile_ref,      $likeablfile_ref, 
	$ablablfile_ref,     $alpablfile_ref,  
	$betablfile_ref,     $insablfile_ref,  
	$delablfile_ref,     $ipablfile_ref,   
	$apbablfile_ref,     $lpmablfile_ref,  
	$lomablfile_ref,     $frsablfile_ref,  
	$frcablfile_ref,     $ttrablfile_ref,  
	$timeablfile_ref,    $mutablfile_ref) = @_;

    my $aveavefile       = "$avefile.ave";
    $$tphistofile_ref    = "$avefile.tp_histo";
    $$d1histofile_ref    = "$avefile.d1_histo";
    $$d2histofile_ref    = "$avefile.d2_histo";

    $$tpfracfofile_ref   = "$avefile.tpfracfo";
    $$tpfofile_ref       = "$avefile.tpfo";
    $$d1fofile_ref       = "$avefile.d1fo";
    $$d2fofile_ref       = "$avefile.d2fo";
    $$likefofile_ref     = "$avefile.likefo";
    $$ablfofile_ref      = "$avefile.ablfo";
    $$alpfofile_ref      = "$avefile.alpfo";
    $$betfofile_ref      = "$avefile.betfo";
    $$insfofile_ref      = "$avefile.insfo";
    $$delfofile_ref      = "$avefile.delfo";
    $$ipfofile_ref       = "$avefile.ipfo";
    $$apbfofile_ref      = "$avefile.apbfo";
    $$lpmfofile_ref      = "$avefile.lpmfo";
    $$lomfofile_ref      = "$avefile.lomfo";
    $$frsfofile_ref      = "$avefile.frsfo";
    $$frcfofile_ref      = "$avefile.frcfo";
    $$ttrfofile_ref      = "$avefile.ttrfo";
    $$timefofile_ref     = "$avefile.timefo";
    $$mutfofile_ref      = "$avefile.mutfo";

    $$tpfracsqlgfile_ref = "$avefile.tpfracsqlg";
    $$tpsqlgfile_ref     = "$avefile.tpsqlg";
    $$d1sqlgfile_ref     = "$avefile.d1sqlg";
    $$d2sqlgfile_ref     = "$avefile.d2sqlg";
    $$likesqlgfile_ref   = "$avefile.likesqlg";
    $$ablsqlgfile_ref    = "$avefile.ablsqlg";
    $$alpsqlgfile_ref    = "$avefile.alpsqlg";
    $$betsqlgfile_ref    = "$avefile.betsqlg";
    $$inssqlgfile_ref    = "$avefile.inssqlg";
    $$delsqlgfile_ref    = "$avefile.delsqlg";
    $$ipsqlgfile_ref     = "$avefile.ipsqlg";
    $$apbsqlgfile_ref    = "$avefile.apbsqlg";
    $$lpmsqlgfile_ref    = "$avefile.lpmsqlg";
    $$lomsqlgfile_ref    = "$avefile.lomsqlg";
    $$frssqlgfile_ref    = "$avefile.frssqlg";
    $$frcsqlgfile_ref    = "$avefile.frcsqlg";
    $$ttrsqlgfile_ref    = "$avefile.ttrsqlg";
    $$timesqlgfile_ref   = "$avefile.timesqlg";
    $$mutsqlgfile_ref    = "$avefile.mutsqlg";

    $$tpfracablfile_ref = "$avefile.tpfracabl";
    $$tpablfile_ref     = "$avefile.tpabl";
    $$d1ablfile_ref     = "$avefile.d1abl";
    $$d2ablfile_ref     = "$avefile.d2abl";
    $$likeablfile_ref   = "$avefile.likeabl";
    $$ablablfile_ref    = "$avefile.ablabl";
    $$alpablfile_ref    = "$avefile.alpabl";
    $$betablfile_ref    = "$avefile.betabl";
    $$insablfile_ref    = "$avefile.insabl";
    $$delablfile_ref    = "$avefile.delabl";
    $$ipablfile_ref     = "$avefile.ipabl";
    $$apbablfile_ref    = "$avefile.apbabl";
    $$lpmablfile_ref    = "$avefile.lpmabl";
    $$lomablfile_ref    = "$avefile.lomabl";
    $$frsablfile_ref    = "$avefile.frsabl";
    $$frcablfile_ref    = "$avefile.frcabl";
    $$ttrablfile_ref    = "$avefile.ttrabl";
    $$timeablfile_ref   = "$avefile.timeabl";
    $$mutablfile_ref    = "$avefile.mutabl";

    system("rm $aveavefile\n");
    system("rm $$tphistofile_ref\n");
    system("rm $$d1histofile_ref\n");
    system("rm $$d2histofile_ref\n");

    system("rm $$tpfracfofile_ref\n");
    system("rm $$tpfofile_ref\n");
    system("rm $$d1fofile_ref\n");
    system("rm $$d2fofile_ref\n");
    system("rm $$likefofile_ref\n");
    system("rm $$ablfofile_ref\n");
    system("rm $$alpfofile_ref\n");
    system("rm $$betfofile_ref\n");
    system("rm $$insfofile_ref\n");
    system("rm $$delfofile_ref\n");
    system("rm $$ipfofile_ref\n");
    system("rm $$apbfofile_ref\n");
    system("rm $$lpmfofile_ref\n");
    system("rm $$lomfofile_ref\n");
    system("rm $$frsfofile_ref\n");
    system("rm $$frcfofile_ref\n");
    system("rm $$ttrfofile_ref\n");
    system("rm $$timefofile_ref\n");
    system("rm $$mutfofile_ref\n");

    system("rm $$tpfracsqlgfile_ref\n");
    system("rm $$tpsqlgfile_ref\n");
    system("rm $$d1sqlgfile_ref\n");
    system("rm $$d2sqlgfile_ref\n");
    system("rm $$likesqlgfile_ref\n");
    system("rm $$ablsqlgfile_ref\n");
    system("rm $$alpsqlgfile_ref\n");
    system("rm $$betsqlgfile_ref\n");
    system("rm $$inssqlgfile_ref\n");
    system("rm $$delsqlgfile_ref\n");
    system("rm $$ipsqlgfile_ref\n");
    system("rm $$apbsqlgfile_ref\n");
    system("rm $$lpmsqlgfile_ref\n");
    system("rm $$lomsqlgfile_ref\n");
    system("rm $$frssqlgfile_ref\n");
    system("rm $$frcsqlgfile_ref\n");
    system("rm $$ttrsqlgfile_ref\n");
    system("rm $$timesqlgfile_ref\n");
    system("rm $$mutsqlgfile_ref\n");

    system("rm $$tpfracablfile_ref\n");
    system("rm $$tpablfile_ref\n");
    system("rm $$d1ablfile_ref\n");
    system("rm $$d2ablfile_ref\n");
    system("rm $$likeablfile_ref\n");
    system("rm $$ablablfile_ref\n");
    system("rm $$alpablfile_ref\n");
    system("rm $$betablfile_ref\n");
    system("rm $$insablfile_ref\n");
    system("rm $$delablfile_ref\n");
    system("rm $$ipablfile_ref\n");
    system("rm $$apbablfile_ref\n");
    system("rm $$lpmablfile_ref\n");
    system("rm $$lomablfile_ref\n");
    system("rm $$frsablfile_ref\n");
    system("rm $$frcablfile_ref\n");
    system("rm $$ttrablfile_ref\n");
    system("rm $$timeablfile_ref\n");
    system("rm $$mutablfile_ref\n");

    my $tave_alen = 0.;
    my $tstd_alen = 0.;
    my $tave_sqlg = 0.;
    my $tstd_sqlg = 0.;
    my $tave_id = 0.;
    my $tstd_id = 0.;
    my $tave_mut = 0.;
    my $tstd_mut = 0.;
    my $tave_indl = 0.;
    my $tstd_indl = 0.;
    my $tave_fo = 0.;
    my $tstd_fo = 0.;
    my $tave_time = 0.;
    my $tstd_time = 0.;
    my $tave_abl = 0.;
    my $tstd_abl = 0.;
    my $tave_alpha = 0.;
    my $tstd_alpha = 0.;
    my $tave_beta = 0.;
    my $tstd_beta = 0.;
    my $tave_lambda = 0.;
    my $tstd_lambda = 0.;
    my $tave_mu = 0.;
    my $tstd_mu = 0.;
    my $tave_ip = 0.;
    my $tstd_ip = 0.;
    my $tave_like = 0.;
    my $tstd_like = 0.;
    my $tave_apb = 0.;
    my $tstd_apb = 0.;
    my $tave_lpm = 0.;
    my $tstd_lpm = 0.;
    my $tave_lom = 0.;
    my $tstd_lom = 0.;
    my $tave_frs = 0.;
    my $tstd_frs = 0.;
    my $tave_frc = 0.;
    my $tstd_frc = 0.;
    my $tave_ttr = 0.;
    my $tstd_ttr = 0.;
    my $tave_tp  = 0.;
    my $tstd_tp  = 0.;
    my $tave_d1  = 0.;
    my $tstd_d1  = 0.;
    my $tave_d2  = 0.;
    my $tstd_d2  = 0.;

    my $key = "";
    my $title;
    my $NS;
    my $TS;

    if    ($avefile =~ /\.(dnaml)\./)            { $key = $1; }
    elsif ($avefile =~ /\.($which_dnamle\.C)\./) { $key = $1; }
    elsif ($avefile =~ /\.($which_dnamle)\./)    { $key = $1; }
    
    if ($avefile =~ /^(16S\_[^\_]+)\_/) { $title .= $1; }
    if ($avefile =~ /^(23S\_[^\_]+)\_/) { $title .= $1; }

    if ($avefile =~ /\.NS(\S+)\.TS(\S+)\./) { 
	$NS    = $1; 
	$TS    = $2; 
    }

    my $nt = 0;

    my $total_tp = 0;

    my @tphisto;
    my @d1histo;
    my @d2histo;
    my @fohisto;
    my @sqlghisto;
    my @ablhisto;

    my @ave_tpfo;
    my @ave_d1fo;
    my @ave_d2fo;
    my @ave_likefo;
    my @ave_ablfo;
    my @ave_alpfo;
    my @ave_betfo;
    my @ave_insfo;
    my @ave_delfo;
    my @ave_ipfo;
    my @ave_apbfo;
    my @ave_lpmfo;
    my @ave_lomfo;
    my @ave_frsfo;
    my @ave_frcfo;
    my @ave_ttrfo;
    my @ave_timefo;
    my @ave_mutfo;

    my @std_tpfo;
    my @std_d1fo;
    my @std_d2fo;
    my @std_likefo;
    my @std_ablfo;
    my @std_alpfo;
    my @std_betfo;
    my @std_insfo;
    my @std_delfo;
    my @std_ipfo;
    my @std_apbfo;
    my @std_lpmfo;
    my @std_lomfo;
    my @std_frsfo;
    my @std_frcfo;
    my @std_ttrfo;
    my @std_timefo;
    my @std_mutfo;

    my @ave_tpsqlg;
    my @ave_d1sqlg;
    my @ave_d2sqlg;
    my @ave_likesqlg;
    my @ave_ablsqlg;
    my @ave_alpsqlg;
    my @ave_betsqlg;
    my @ave_inssqlg;
    my @ave_delsqlg;
    my @ave_ipsqlg;
    my @ave_apbsqlg;
    my @ave_lpmsqlg;
    my @ave_lomsqlg;
    my @ave_frssqlg;
    my @ave_frcsqlg;
    my @ave_ttrsqlg;
    my @ave_timesqlg;
    my @ave_mutsqlg;

    my @std_tpsqlg;
    my @std_d1sqlg;
    my @std_d2sqlg;
    my @std_likesqlg;
    my @std_ablsqlg;
    my @std_alpsqlg;
    my @std_betsqlg;
    my @std_inssqlg;
    my @std_delsqlg;
    my @std_ipsqlg;
    my @std_apbsqlg;
    my @std_lpmsqlg;
    my @std_lomsqlg;
    my @std_frssqlg;
    my @std_frcsqlg;
    my @std_ttrsqlg;
    my @std_timesqlg;
    my @std_mutsqlg;

    my @ave_tpabl;
    my @ave_d1abl;
    my @ave_d2abl;
    my @ave_likeabl;
    my @ave_ablabl;
    my @ave_alpabl;
    my @ave_betabl;
    my @ave_insabl;
    my @ave_delabl;
    my @ave_ipabl;
    my @ave_apbabl;
    my @ave_lpmabl;
    my @ave_lomabl;
    my @ave_frsabl;
    my @ave_frcabl;
    my @ave_ttrabl;
    my @ave_timeabl;
    my @ave_mutabl;

    my @std_tpabl;
    my @std_d1abl;
    my @std_d2abl;
    my @std_likeabl;
    my @std_ablabl;
    my @std_alpabl;
    my @std_betabl;
    my @std_insabl;
    my @std_delabl;
    my @std_ipabl;
    my @std_apbabl;
    my @std_lpmabl;
    my @std_lomabl;
    my @std_frsabl;
    my @std_frcabl;
    my @std_ttrabl;
    my @std_timeabl;
    my @std_mutabl;

    init_histo_array($Nf, $kf, \@tphisto);
    init_histo_array($Nd, $kd, \@d1histo);
    init_histo_array($Nd, $kd, \@d2histo);
    init_histo_array($Nf, $kf, \@fohisto);
    init_histo_array($Nl, $kl, \@sqlghisto);
    init_histo_array($Na, $ka, \@ablhisto);

    init_histo_array($Nf, $kf, \@ave_tpfo);
    init_histo_array($Nf, $kf, \@std_tpfo);
    init_histo_array($Nf, $kf, \@ave_d1fo);
    init_histo_array($Nf, $kf, \@std_d1fo);
    init_histo_array($Nf, $kf, \@ave_d2fo);
    init_histo_array($Nf, $kf, \@std_d2fo);
    init_histo_array($Nf, $kf, \@ave_likefo);
    init_histo_array($Nf, $kf, \@std_likefo);
    init_histo_array($Nf, $kf, \@ave_ablfo);
    init_histo_array($Nf, $kf, \@std_ablfo);
    init_histo_array($Nf, $kf, \@ave_alpfo);
    init_histo_array($Nf, $kf, \@std_alpfo);
    init_histo_array($Nf, $kf, \@ave_betfo);
    init_histo_array($Nf, $kf, \@std_betfo);
    init_histo_array($Nf, $kf, \@ave_insfo);
    init_histo_array($Nf, $kf, \@std_insfo);
    init_histo_array($Nf, $kf, \@ave_delfo);
    init_histo_array($Nf, $kf, \@std_delfo);
    init_histo_array($Nf, $kf, \@ave_ipfo);
    init_histo_array($Nf, $kf, \@std_ipfo);
    init_histo_array($Nf, $kf, \@ave_apbfo);
    init_histo_array($Nf, $kf, \@std_apbfo);
    init_histo_array($Nf, $kf, \@ave_lpmfo);
    init_histo_array($Nf, $kf, \@std_lpmfo);
    init_histo_array($Nf, $kf, \@ave_lomfo);
    init_histo_array($Nf, $kf, \@std_lomfo);
    init_histo_array($Nf, $kf, \@ave_frsfo);
    init_histo_array($Nf, $kf, \@std_frsfo);
    init_histo_array($Nf, $kf, \@ave_frcfo);
    init_histo_array($Nf, $kf, \@std_frcfo);
    init_histo_array($Nf, $kf, \@ave_ttrfo);
    init_histo_array($Nf, $kf, \@std_ttrfo);
    init_histo_array($Nf, $kf, \@ave_timefo);
    init_histo_array($Nf, $kf, \@std_timefo);
    init_histo_array($Nf, $kf, \@ave_mutfo);
    init_histo_array($Nf, $kf, \@std_mutfo);

    init_histo_array($Nl, $kl, \@ave_tpsqlg);
    init_histo_array($Nl, $kl, \@std_tpsqlg);
    init_histo_array($Nl, $kl, \@ave_d1sqlg);
    init_histo_array($Nl, $kl, \@std_d1sqlg);
    init_histo_array($Nl, $kl, \@ave_d2sqlg);
    init_histo_array($Nl, $kl, \@std_d2sqlg);
    init_histo_array($Nl, $kl, \@ave_likesqlg);
    init_histo_array($Nl, $kl, \@std_likesqlg);
    init_histo_array($Nl, $kl, \@ave_ablsqlg);
    init_histo_array($Nl, $kl, \@std_ablsqlg);
    init_histo_array($Nl, $kl, \@ave_alpsqlg);
    init_histo_array($Nl, $kl, \@std_alpsqlg);
    init_histo_array($Nl, $kl, \@ave_betsqlg);
    init_histo_array($Nl, $kl, \@std_betsqlg);
    init_histo_array($Nl, $kl, \@ave_inssqlg);
    init_histo_array($Nl, $kl, \@std_inssqlg);
    init_histo_array($Nl, $kl, \@ave_delsqlg);
    init_histo_array($Nl, $kl, \@std_delsqlg);
    init_histo_array($Nl, $kl, \@ave_ipsqlg);
    init_histo_array($Nl, $kl, \@std_ipsqlg);
    init_histo_array($Nl, $kl, \@ave_apbsqlg);
    init_histo_array($Nl, $kl, \@std_apbsqlg);
    init_histo_array($Nl, $kl, \@ave_lpmsqlg);
    init_histo_array($Nl, $kl, \@std_lpmsqlg);
    init_histo_array($Nl, $kl, \@ave_lomsqlg);
    init_histo_array($Nl, $kl, \@std_lomsqlg);
    init_histo_array($Nl, $kl, \@ave_frssqlg);
    init_histo_array($Nl, $kl, \@std_frssqlg);
    init_histo_array($Nl, $kl, \@ave_frcsqlg);
    init_histo_array($Nl, $kl, \@std_frcsqlg);
    init_histo_array($Nl, $kl, \@ave_ttrsqlg);
    init_histo_array($Nl, $kl, \@std_ttrsqlg);
    init_histo_array($Nl, $kl, \@ave_timesqlg);
    init_histo_array($Nl, $kl, \@std_timesqlg);
    init_histo_array($Nl, $kl, \@ave_mutsqlg);
    init_histo_array($Nl, $kl, \@std_mutsqlg);

    init_histo_array($Na, $ka, \@ave_tpabl);
    init_histo_array($Na, $ka, \@std_tpabl);
    init_histo_array($Na, $ka, \@ave_d1abl);
    init_histo_array($Na, $ka, \@std_d1abl);
    init_histo_array($Na, $ka, \@ave_d2abl);
    init_histo_array($Na, $ka, \@std_d2abl);
    init_histo_array($Na, $ka, \@ave_likeabl);
    init_histo_array($Na, $ka, \@std_likeabl);
    init_histo_array($Na, $ka, \@ave_ablabl);
    init_histo_array($Na, $ka, \@std_ablabl);
    init_histo_array($Na, $ka, \@ave_alpabl);
    init_histo_array($Na, $ka, \@std_alpabl);
    init_histo_array($Na, $ka, \@ave_betabl);
    init_histo_array($Na, $ka, \@std_betabl);
    init_histo_array($Na, $ka, \@ave_insabl);
    init_histo_array($Na, $ka, \@std_insabl);
    init_histo_array($Na, $ka, \@ave_delabl);
    init_histo_array($Na, $ka, \@std_delabl);
    init_histo_array($Na, $ka, \@ave_ipabl);
    init_histo_array($Na, $ka, \@std_ipabl);
    init_histo_array($Na, $ka, \@ave_apbabl);
    init_histo_array($Na, $ka, \@std_apbabl);
    init_histo_array($Na, $ka, \@ave_lpmabl);
    init_histo_array($Na, $ka, \@std_lpmabl);
    init_histo_array($Na, $ka, \@ave_lomabl);
    init_histo_array($Na, $ka, \@std_lomabl);
    init_histo_array($Na, $ka, \@ave_frsabl);
    init_histo_array($Na, $ka, \@std_frsabl);
    init_histo_array($Na, $ka, \@ave_frcabl);
    init_histo_array($Na, $ka, \@std_frcabl);
    init_histo_array($Na, $ka, \@ave_ttrabl);
    init_histo_array($Na, $ka, \@std_ttrabl);
    init_histo_array($Na, $ka, \@ave_timeabl);
    init_histo_array($Na, $ka, \@std_timeabl);
    init_histo_array($Na, $ka, \@ave_mutabl);
    init_histo_array($Na, $ka, \@std_mutabl);

    print "avefile\n$avefile\n";
    open(FILE, "$avefile");
    while(<FILE>) {
	if (/^(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+\S+\s+(\S+)\s+(\S+)\s+(\S+)\s*/) {
	    my $alen      = $1;
	    my $sqlg      = $2;
	    my $id        = $3;
	    my $mut       = $4;
	    my $indl      = $5;
	    my $fo        = $6;
	    my $time      = $7;
	    my $abl       = $8;
	    my $alpha     = $9;
	    my $beta      = $10;
	    my $lambda    = $11;
	    my $mu        = $12;
	    my $ip        = $13;
	    my $like      = $14;
	    my $ttr       = $15;
	    my $apb       = $16;
	    my $frs       = $17;
	    my $frc       = $18;
	    my $tp        = $19;
	    my $d1        = $20;
	    my $d2        = $21;
	    
	    my $lpm = $lambda + $mu;
	    my $lom = ($lambda > 0)? ($mu)/$lambda : 0;

	    if (0) {
		print "\naverage of averages\n";
		print "ave_alen $alen\n";
		print "ave_sqlg $sqlg\n";
		print "ave_id $id\n";
		print "ave_mut $mut\n";
		print "ave_indl $indl\n";
		print "ave_fo $fo\n";
		print "ave_time $time \n";
		print "ave_abl $abl \n";
		print "ave_alpha $alpha\n";
		print "ave_beta $beta\n";
		print "ave_lambda $lambda\n";
		print "ave_mu $mu\n";
		print "ave_ip $ip\n";
		print "ave_like $like\n";
		print "ave_apb $apb\n";
		print "ave_lpm $lpm\n";
		print "ave_lom $lom\n";
		print "ave_frs $frs\n";
		print "ave_frc $frc\n";
		print "ave_ttr $ttr\n";
		print "tp      $tp\n";
		print "d1      $d1\n";
		print "d2      $d2\n";
	    }
	    
	    if ($d1 < 0) { print "bad BSD $d1\n$_\n"; die; }
	    if ($d2 < 0) { print "bad SDD $d2\n$_\n"; die; }

	    if ($fo <= 1.0) {
		accumulate_averages($alen,      \$tave_alen,      \$tstd_alen);
		accumulate_averages($sqlg,      \$tave_sqlg,      \$tstd_sqlg);
		accumulate_averages($id,        \$tave_id,        \$tstd_id);
		accumulate_averages($mut,       \$tave_mut,       \$tstd_mut);
		accumulate_averages($indl,      \$tave_indl,      \$tstd_indl);
		accumulate_averages($fo,        \$tave_fo,        \$tstd_fo);
		accumulate_averages($time,      \$tave_time,      \$tstd_time);
		accumulate_averages($abl,       \$tave_abl,       \$tstd_abl);
		accumulate_averages($alpha,     \$tave_alpha,     \$tstd_alpha);
		accumulate_averages($beta,      \$tave_beta,      \$tstd_beta);
		accumulate_averages($lambda,    \$tave_lambda,    \$tstd_lambda);
		accumulate_averages($mu,        \$tave_mu,        \$tstd_mu);
		accumulate_averages($ip,        \$tave_ip,        \$tstd_ip);
		accumulate_averages($like,      \$tave_like,      \$tstd_like);
		accumulate_averages($apb,       \$tave_apb,       \$tstd_apb);
		accumulate_averages($lpm,       \$tave_lpm,       \$tstd_lpm);
		accumulate_averages($lom,       \$tave_lom,       \$tstd_lom);
		accumulate_averages($frs,       \$tave_frs,       \$tstd_frs);
		accumulate_averages($frc,       \$tave_frc,       \$tstd_frc);
		accumulate_averages($ttr,       \$tave_ttr,       \$tstd_ttr);
		accumulate_averages($tp,        \$tave_tp,        \$tstd_tp);
		accumulate_averages($d1,        \$tave_d1,        \$tstd_d1);
		accumulate_averages($d2,        \$tave_d2,        \$tstd_d2);
		
		$total_tp += $tp;

		fill_histo_array(1,                         $tp,        $Nf, $kf, \@tphisto);
		fill_histo_array(1,                         $d1,        $Nd, $kd, \@d1histo);
		fill_histo_array(1,                         $d2,        $Nd, $kd, \@d2histo);
		fill_histo_array(1,                         $fo,        $Nf, $kf, \@fohisto);
		fill_histo_array(1,                         $sqlg,      $Nl, $kl, \@sqlghisto);
		fill_histo_array(1,                         $abl,       $Na, $ka, \@ablhisto);

		fill_histo_array($tp,                       $fo,        $Nf, $kf, \@ave_tpfo);
		fill_histo_array($tp*$tp,                   $fo,        $Nf, $kf, \@std_tpfo);
		fill_histo_array($d1,                       $fo,        $Nf, $kf, \@ave_d1fo);
		fill_histo_array($d1*$d1,                   $fo,        $Nf, $kf, \@std_d1fo);
		fill_histo_array($d2,                       $fo,        $Nf, $kf, \@ave_d2fo);
		fill_histo_array($d2*$d2,                   $fo,        $Nf, $kf, \@std_d2fo);
		fill_histo_array($like,                     $fo,        $Nf, $kf, \@ave_likefo);
		fill_histo_array($like*$like,               $fo,        $Nf, $kf, \@std_likefo);
		fill_histo_array($abl,                      $fo,        $Nf, $kf, \@ave_ablfo);
		fill_histo_array($abl*$abl,                 $fo,        $Nf, $kf, \@std_ablfo);
		fill_histo_array($alpha,                    $fo,        $Nf, $kf, \@ave_alpfo);
		fill_histo_array($alpha*$alpha,             $fo,        $Nf, $kf, \@std_alpfo);
		fill_histo_array($beta,                     $fo,        $Nf, $kf, \@ave_betfo);
		fill_histo_array($beta*$beta,               $fo,        $Nf, $kf, \@std_betfo);
		fill_histo_array($lambda,                   $fo,        $Nf, $kf, \@ave_insfo);
		fill_histo_array($lambda*$lambda,           $fo,        $Nf, $kf, \@std_insfo);
		fill_histo_array($mu,                       $fo,        $Nf, $kf, \@ave_delfo);
		fill_histo_array($mu*$mu,                   $fo,        $Nf, $kf, \@std_delfo);
		fill_histo_array($ip,                       $fo,        $Nf, $kf, \@ave_ipfo);
		fill_histo_array($ip*$ip,                   $fo,        $Nf, $kf, \@std_ipfo);
		fill_histo_array($apb,                      $fo,        $Nf, $kf, \@ave_apbfo);
		fill_histo_array($apb*$apb,                 $fo,        $Nf, $kf, \@std_apbfo);
		fill_histo_array($lpm,                      $fo,        $Nf, $kf, \@ave_lpmfo);
		fill_histo_array($lpm*$lpm,                 $fo,        $Nf, $kf, \@std_lpmfo);
		fill_histo_array($lom,                      $fo,        $Nf, $kf, \@ave_lomfo);
		fill_histo_array($lom*$lom,                 $fo,        $Nf, $kf, \@std_lomfo);
		fill_histo_array($frs,                      $fo,        $Nf, $kf, \@ave_frsfo);
		fill_histo_array($frs*$frs,                 $fo,        $Nf, $kf, \@std_frsfo);
		fill_histo_array($frc,                      $fo,        $Nf, $kf, \@ave_frcfo);
		fill_histo_array($frc*$frc,                 $fo,        $Nf, $kf, \@std_frcfo);
		fill_histo_array($ttr,                      $fo,        $Nf, $kf, \@ave_ttrfo);
		fill_histo_array($ttr*$ttr,                 $fo,        $Nf, $kf, \@std_ttrfo);
		fill_histo_array($time,                     $fo,        $Nf, $kf, \@ave_timefo);
		fill_histo_array($time*$time,               $fo,        $Nf, $kf, \@std_timefo);
		fill_histo_array($mut,                      $fo,        $Nf, $kf, \@ave_mutfo);
		fill_histo_array($mut*$mut,                 $fo,        $Nf, $kf, \@std_mutfo);

		fill_histo_array($tp,                       $sqlg,      $Nl, $kl, \@ave_tpsqlg);
		fill_histo_array($tp*$tp,                   $sqlg,      $Nl, $kl, \@std_tpsqlg);
		fill_histo_array($d1,                       $sqlg,      $Nl, $kl, \@ave_d1sqlg);
		fill_histo_array($d1*$d1,                   $sqlg,      $Nl, $kl, \@std_d1sqlg);
		fill_histo_array($d2,                       $sqlg,      $Nl, $kl, \@ave_d2sqlg);
		fill_histo_array($d2*$d2,                   $sqlg,      $Nl, $kl, \@std_d2sqlg);
		fill_histo_array($like,                     $sqlg,      $Nl, $kl, \@ave_likesqlg);
		fill_histo_array($like*$like,               $sqlg,      $Nl, $kl, \@std_likesqlg);
		fill_histo_array($abl,                      $sqlg,      $Nl, $kl, \@ave_ablsqlg);
		fill_histo_array($abl*$abl,                 $sqlg,      $Nl, $kl, \@std_ablsqlg);
		fill_histo_array($alpha,                    $sqlg,      $Nl, $kl, \@ave_alpsqlg);
		fill_histo_array($alpha*$alpha,             $sqlg,      $Nl, $kl, \@std_alpsqlg);
		fill_histo_array($beta,                     $sqlg,      $Nl, $kl, \@ave_betsqlg);
		fill_histo_array($beta*$beta,               $sqlg,      $Nl, $kl, \@std_betsqlg);
		fill_histo_array($lambda,                   $sqlg,      $Nl, $kl, \@ave_inssqlg);
		fill_histo_array($lambda*$lambda,           $sqlg,      $Nl, $kl, \@std_inssqlg);
		fill_histo_array($mu,                       $sqlg,      $Nl, $kl, \@ave_delsqlg);
		fill_histo_array($mu*$mu,                   $sqlg,      $Nl, $kl, \@std_delsqlg);
		fill_histo_array($ip,                       $sqlg,      $Nl, $kl, \@ave_ipsqlg);
		fill_histo_array($ip*$ip,                   $sqlg,      $Nl, $kl, \@std_ipsqlg);
		fill_histo_array($apb,                      $sqlg,      $Nl, $kl, \@ave_apbsqlg);
		fill_histo_array($apb*$apb,                 $sqlg,      $Nl, $kl, \@std_apbsqlg);
		fill_histo_array($lpm,                      $sqlg,      $Nl, $kl, \@ave_lpmsqlg);
		fill_histo_array($lpm*$lpm,                 $sqlg,      $Nl, $kl, \@std_lpmsqlg);
		fill_histo_array($lom,                      $sqlg,      $Nl, $kl, \@ave_lomsqlg);
		fill_histo_array($lom*$lom,                 $sqlg,      $Nl, $kl, \@std_lomsqlg);
		fill_histo_array($frs,                      $sqlg,      $Nl, $kl, \@ave_frssqlg);
		fill_histo_array($frs*$frs,                 $sqlg,      $Nl, $kl, \@std_frssqlg);
		fill_histo_array($frc,                      $sqlg,      $Nl, $kl, \@ave_frcsqlg);
		fill_histo_array($frc*$frc,                 $sqlg,      $Nl, $kl, \@std_frcsqlg);
		fill_histo_array($ttr,                      $sqlg,      $Nl, $kl, \@ave_ttrsqlg);
		fill_histo_array($ttr*$ttr,                 $sqlg,      $Nl, $kl, \@std_ttrsqlg);
		fill_histo_array($time,                     $sqlg,      $Nl, $kl, \@ave_timesqlg);
		fill_histo_array($time*$time,               $sqlg,      $Nl, $kl, \@std_timesqlg);
		fill_histo_array($mut,                      $sqlg,      $Nl, $kl, \@ave_mutsqlg);
		fill_histo_array($mut*$mut,                 $sqlg,      $Nl, $kl, \@std_mutsqlg);

		fill_histo_array($tp,                       $abl,      $Na, $ka, \@ave_tpabl);
		fill_histo_array($tp*$tp,                   $abl,      $Na, $ka, \@std_tpabl);
		fill_histo_array($d1,                       $abl,      $Na, $ka, \@ave_d1abl);
		fill_histo_array($d1*$d1,                   $abl,      $Na, $ka, \@std_d1abl);
		fill_histo_array($d2,                       $abl,      $Na, $ka, \@ave_d2abl);
		fill_histo_array($d2*$d2,                   $abl,      $Na, $ka, \@std_d2abl);
		fill_histo_array($like,                     $abl,      $Na, $ka, \@ave_likeabl);
		fill_histo_array($like*$like,               $abl,      $Na, $ka, \@std_likeabl);
		fill_histo_array($abl,                      $abl,      $Na, $ka, \@ave_ablabl);
		fill_histo_array($abl*$abl,                 $abl,      $Na, $ka, \@std_ablabl);
		fill_histo_array($alpha,                    $abl,      $Na, $ka, \@ave_alpabl);
		fill_histo_array($alpha*$alpha,             $abl,      $Na, $ka, \@std_alpabl);
		fill_histo_array($beta,                     $abl,      $Na, $ka, \@ave_betabl);
		fill_histo_array($beta*$beta,               $abl,      $Na, $ka, \@std_betabl);
		fill_histo_array($lambda,                   $abl,      $Na, $ka, \@ave_insabl);
		fill_histo_array($lambda*$lambda,           $abl,      $Na, $ka, \@std_insabl);
		fill_histo_array($mu,                       $abl,      $Na, $ka, \@ave_delabl);
		fill_histo_array($mu*$mu,                   $abl,      $Na, $ka, \@std_delabl);
		fill_histo_array($ip,                       $abl,      $Na, $ka, \@ave_ipabl);
		fill_histo_array($ip*$ip,                   $abl,      $Na, $ka, \@std_ipabl);
		fill_histo_array($apb,                      $abl,      $Na, $ka, \@ave_apbabl);
		fill_histo_array($apb*$apb,                 $abl,      $Na, $ka, \@std_apbabl);
		fill_histo_array($lpm,                      $abl,      $Na, $ka, \@ave_lpmabl);
		fill_histo_array($lpm*$lpm,                 $abl,      $Na, $ka, \@std_lpmabl);
		fill_histo_array($lom,                      $abl,      $Na, $ka, \@ave_lomabl);
		fill_histo_array($lom*$lom,                 $abl,      $Na, $ka, \@std_lomabl);
		fill_histo_array($frs,                      $abl,      $Na, $ka, \@ave_frsabl);
		fill_histo_array($frs*$frs,                 $abl,      $Na, $ka, \@std_frsabl);
		fill_histo_array($frc,                      $abl,      $Na, $ka, \@ave_frcabl);
		fill_histo_array($frc*$frc,                 $abl,      $Na, $ka, \@std_frcabl);
		fill_histo_array($ttr,                      $abl,      $Na, $ka, \@ave_ttrabl);
		fill_histo_array($ttr*$ttr,                 $abl,      $Na, $ka, \@std_ttrabl);
		fill_histo_array($time,                     $abl,      $Na, $ka, \@ave_timeabl);
		fill_histo_array($time*$time,               $abl,      $Na, $ka, \@std_timeabl);
		fill_histo_array($mut,                      $abl,      $Na, $ka, \@ave_mutabl);
		fill_histo_array($mut*$mut,                 $abl,      $Na, $ka, \@std_mutabl);

		$nt ++;
	    }
	}
    }
    close (FILE);
    
    calculate_averages(\$tave_alen,      \$tstd_alen,      $nt);
    calculate_averages(\$tave_sqlg,      \$tstd_sqlg,      $nt);
    calculate_averages(\$tave_id,        \$tstd_id,        $nt);
    calculate_averages(\$tave_mut,       \$tstd_mut,       $nt);
    calculate_averages(\$tave_indl,      \$tstd_indl,      $nt);
    calculate_averages(\$tave_fo,        \$tstd_fo,        $nt);
    calculate_averages(\$tave_abl,       \$tstd_abl,       $nt);
    calculate_averages(\$tave_alpha,     \$tstd_alpha,     $nt);
    calculate_averages(\$tave_beta,      \$tstd_beta,      $nt);
    calculate_averages(\$tave_lambda,    \$tstd_lambda,    $nt);
    calculate_averages(\$tave_mu,        \$tstd_mu,        $nt);
    calculate_averages(\$tave_ip,        \$tstd_ip,        $nt);
    calculate_averages(\$tave_like,      \$tstd_like,      $nt);
    calculate_averages(\$tave_apb,       \$tstd_apb,       $nt);
    calculate_averages(\$tave_lpm,       \$tstd_lpm,       $nt);
    calculate_averages(\$tave_lom,       \$tstd_lom,       $nt);
    calculate_averages(\$tave_frs,       \$tstd_frs,       $nt);
    calculate_averages(\$tave_frc,       \$tstd_frc,       $nt);
    calculate_averages(\$tave_ttr,       \$tstd_ttr,       $nt);
    calculate_averages(\$tave_time,      \$tstd_time,      $nt);
    calculate_averages(\$tave_tp,        \$tstd_tp,        $nt);
    calculate_averages(\$tave_d1,        \$tstd_d1,        $nt);
    calculate_averages(\$tave_d2,        \$tstd_d2,        $nt);

    if ($total_tp > $nt) { print " this is impossible! total_tp = $total_tp ntrial = $nt\n"; die; }

    write_to_average_averagesfile($aveavefile, 
				  $tave_alen, $tstd_alen, 
				  $tave_sqlg, $tstd_sqlg, 
				  $tave_id, $tstd_id, 
				  $tave_mut, $tstd_mut, 
				  $tave_indl, $tstd_indl, 
				  $tave_fo, $tstd_fo, 
				  $tave_time, $tstd_time, 
				  $tave_abl, $tstd_abl, 
				  $tave_alpha, $tstd_alpha, 
				  $tave_beta, $tstd_beta, 
				  $tave_lambda, $tstd_lambda, 
				  $tave_mu, $tstd_mu, 
				  $tave_ip, $tstd_ip, 
				  $tave_like, $tstd_like, 
				  $tave_ttr, $tstd_ttr, 
				  $tave_apb, $tstd_apb, 
				  $tave_frs, $tstd_frs, 
				  $tave_frc, $tstd_frc, 
				  $tave_tp, $tstd_tp,
				  $tave_d1, $tstd_d1,
				  $tave_d2, $tstd_d2);
    
    write_histogram($Nf, $kf, \@tphisto, $$tphistofile_ref, $nt);
    write_histogram($Nd, $kd, \@d1histo, $$d1histofile_ref, $nt);
    write_histogram($Nd, $kd, \@d2histo, $$d2histofile_ref, $nt);

    write_fo_unnormalized_histogram($Nf, $kf, \@fohisto,   \@ave_tpfo,     \@std_tpfo,     $$tpfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_tpfo,     \@std_tpfo,     $$tpfracfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_d1fo,     \@std_d1fo,     $$d1fofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_d2fo,     \@std_d2fo,     $$d2fofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_likefo,   \@std_likefo,   $$likefofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_ablfo,    \@std_ablfo,    $$ablfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_alpfo,    \@std_alpfo,    $$alpfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_betfo,    \@std_betfo,    $$betfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_insfo,    \@std_insfo,    $$insfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_delfo,    \@std_delfo,    $$delfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_ipfo,     \@std_ipfo,     $$ipfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_apbfo,    \@std_apbfo,    $$apbfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_lpmfo,    \@std_lpmfo,    $$lpmfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_lomfo,    \@std_lomfo,    $$lomfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_frsfo,    \@std_frsfo,    $$frsfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_frcfo,    \@std_frcfo,    $$frcfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_ttrfo,    \@std_ttrfo,    $$ttrfofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_timefo,   \@std_timefo,   $$timefofile_ref);
    write_fo_histogram($Nf, $kf, \@fohisto,   \@ave_mutfo,    \@std_mutfo,    $$mutfofile_ref);

    write_fo_unnormalized_histogram($Nl, $kl, \@sqlghisto, \@ave_tpsqlg,   \@std_tpsqlg,   $$tpsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_tpsqlg,   \@std_tpsqlg,   $$tpfracsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_d1sqlg,   \@std_d1sqlg,   $$d1sqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_d2sqlg,   \@std_d2sqlg,   $$d2sqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_likesqlg, \@std_likesqlg, $$likesqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_ablsqlg,  \@std_ablsqlg,  $$ablsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_alpsqlg,  \@std_alpsqlg,  $$alpsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_betsqlg,  \@std_betsqlg,  $$betsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_inssqlg,  \@std_inssqlg,  $$inssqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_delsqlg,  \@std_delsqlg,  $$delsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_ipsqlg,   \@std_ipsqlg,   $$ipsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_apbsqlg,  \@std_apbsqlg,  $$apbsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_lpmsqlg,  \@std_lpmsqlg,  $$lpmsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_lomsqlg,  \@std_lomsqlg,  $$lomsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_frssqlg,  \@std_frssqlg,  $$frssqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_frcsqlg,  \@std_frcsqlg,  $$frcsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_ttrsqlg,  \@std_ttrsqlg,  $$ttrsqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_timesqlg, \@std_timesqlg, $$timesqlgfile_ref);
    write_fo_histogram($Nl, $kl, \@sqlghisto, \@ave_mutsqlg,  \@std_mutsqlg,  $$mutsqlgfile_ref);

    write_fo_unnormalized_histogram($Na, $ka, \@ablhisto, \@ave_tpabl,   \@std_tpabl,   $$tpablfile_ref);
    write_fo_histogram($Na, $ka, \@ablhisto, \@ave_tpabl,   \@std_tpabl,   $$tpablfile_ref);
    write_fo_histogram($Na, $ka, \@ablhisto, \@ave_d1abl,   \@std_d1abl,   $$d1ablfile_ref);
    write_fo_histogram($Na, $ka, \@ablhisto, \@ave_d2abl,   \@std_d2abl,   $$d2ablfile_ref);
    write_fo_histogram($Na, $ka, \@ablhisto, \@ave_likeabl, \@std_likeabl, $$likeablfile_ref);
    write_fo_histogram($Na, $ka, \@ablhisto, \@ave_ablabl,  \@std_ablabl,  $$ablablfile_ref);
    write_fo_histogram($Na, $ka, \@ablhisto, \@ave_alpabl,  \@std_alpabl,  $$alpablfile_ref);
    write_fo_histogram($Na, $ka, \@ablhisto, \@ave_betabl,  \@std_betabl,  $$betablfile_ref);
    write_fo_histogram($Na, $ka, \@ablhisto, \@ave_insabl,  \@std_insabl,  $$insablfile_ref);
    write_fo_histogram($Na, $ka, \@ablhisto, \@ave_delabl,  \@std_delabl,  $$delablfile_ref);
    write_fo_histogram($Na, $ka, \@ablhisto, \@ave_ipabl,   \@std_ipabl,   $$ipablfile_ref);
    write_fo_histogram($Na, $ka, \@ablhisto, \@ave_apbabl,  \@std_apbabl,  $$apbablfile_ref);
    write_fo_histogram($Na, $ka, \@ablhisto, \@ave_lpmabl,  \@std_lpmabl,  $$lpmablfile_ref);
    write_fo_histogram($Na, $ka, \@ablhisto, \@ave_lomabl,  \@std_lomabl,  $$lomablfile_ref);
    write_fo_histogram($Na, $ka, \@ablhisto, \@ave_frsabl,  \@std_frsabl,  $$frsablfile_ref);
    write_fo_histogram($Na, $ka, \@ablhisto, \@ave_frcabl,  \@std_frcabl,  $$frcablfile_ref);
    write_fo_histogram($Na, $ka, \@ablhisto, \@ave_ttrabl,  \@std_ttrabl,  $$ttrablfile_ref);
    write_fo_histogram($Na, $ka, \@ablhisto, \@ave_timeabl, \@std_timeabl, $$timeablfile_ref);
    write_fo_histogram($Na, $ka, \@ablhisto, \@ave_mutabl,  \@std_mutabl,  $$mutablfile_ref);

    $tave_tp = int($tave_tp*100)/100;
    $tstd_tp = int($tstd_tp*100)/100;

    $tave_d1 = int($tave_d1*100)/100;
    $tstd_d1 = int($tstd_d1*100)/100;

    $tave_d2 = int($tave_d2*100)/100;
    $tstd_d2 = int($tstd_d2*100)/100;

    $tave_alen = int($tave_alen);
    $tstd_alen = int($tstd_alen);

    $tave_sqlg = int($tave_sqlg);
    $tstd_sqlg = int($tstd_sqlg);

    $title .= "N=$nt / NS=$NS TS=$TS / len ali $tave_alen +/- $tstd_alen / geomean seqs $tave_sqlg +/- $tstd_sqlg";
    $key   .= " ** TP $total_tp ";
    $key   .= " ** SDD $tave_d2 +\- $tstd_d2";
    $key   .= " ** BSD $tave_d1 +\- $tstd_d1";
  
    $$key_ref = $key;
    $$title_ref = $title;
}

sub write_histogram {

    my ($N, $k, $histo_ref, $hfile, $NT) = @_;
    
    my $dim = $N * $k;

    open(HIS, ">$hfile");

    for (my $i=0; $i<=$dim; $i++) { 
	my $len = $i/$k;
	print HIS "$len\t$histo_ref->[$i]\n";
    }
    
    close (HIS);

    my $title = "N=$NT";
    my $xlabel = "AVERAGE BOOSTRAP FRACTION";
    my $key= "";
    #gnuplot_histo($hfile, $title, $xlabel, $key);

}

sub write_fo_histogram {
    my ($N, $k, $fohisto_ref, $ave_bootfo_ref, $std_bootfo_ref, $hfile) = @_;

    my $dim = $N * $k;

    open(HIS, ">$hfile");

    for (my $i=0; $i<=$dim; $i++) { 
	my $len = $i/$k;

	my $total    = $fohisto_ref->[$i];
	my $ave_boot = $ave_bootfo_ref->[$i];
	my $std_boot = $std_bootfo_ref->[$i];
	calculate_averages(\$ave_boot, \$std_boot, $total);

	if ($total > 0) {
	    my $cmd = "$total\t$ave_boot\t$std_boot";
	    print HIS "$len\t$cmd\n";
	}
    }
    close(HIS);
}

sub write_fo_unnormalized_histogram {
    my ($N, $k, $fohisto_ref, $ave_bootfo_ref, $std_bootfo_ref, $hfile) = @_;

    my $dim = $N * $k;

    open(HIS, ">$hfile");

    for (my $i=0; $i<=$dim; $i++) { 
	my $len = $i/$k;

	my $total    = $fohisto_ref->[$i];
	my $ave_boot = $ave_bootfo_ref->[$i];
	my $std_boot = $std_bootfo_ref->[$i];
	calculate_averages(\$ave_boot, \$std_boot, 1.0);

	if ($total > 0) {
	    my $cmd = "$total\t$ave_boot\t$std_boot";
	    print HIS "$len\t$cmd\n";
	}
    }
    close(HIS);
}

sub write_to_average_averagesfile {
    my ($averages_file,
	$ave_alen, $std_alen, 
	$ave_sqlg, $std_sqlg, 
	$ave_id, $std_id, 
	$ave_mut, $std_mut, 
	$ave_indl, $std_indl, 
	$ave_fo, $std_fo, 
	$ave_time, $std_time, $ave_abl, $std_abl, 
	$ave_alpha, $std_alpha, $ave_beta, $std_beta, 
	$ave_lambda, $std_lambda, $ave_mu, $std_mu, 
	$ave_ip, $std_ip, 
	$ave_like, $std_like, $ave_ttr, $std_ttr, 
	$ave_apb, $std_apb, $ave_frs, $std_frs, $ave_frc, $std_frc, 
	$ave_tp, $std_tp,
	$ave_d1, $std_d1,
	$ave_d2, $std_d2) = @_;

    open(FILE, ">>$averages_file");
    print "\nave_alen $ave_alen $std_alen\n";
    print "ave_sqlg $ave_sqlg $std_sqlg\n";
    print "ave_id $ave_id $std_id\n";
    print "ave_MUT $ave_mut $std_mut\n";
    print "ave_INDL $ave_indl $std_indl\n";
    print "ave_indlfreq $ave_fo $std_fo\n";
    print "ave_time $ave_time $std_time\n";
    print "ave_abl $ave_abl $std_abl \n";
    print "ave_alpha $ave_alpha $std_alpha\n";
    print "ave_beta $ave_beta $std_beta\n";
    print "ave_lambda $ave_lambda $std_lambda\n";
    print "ave_mu $ave_mu $std_mu \n";
    print "ave_ip $ave_ip $std_ip \n";
    print "ave_like $ave_like $std_like \n";
    print "ave_ttr $ave_ttr $std_ttr \n";
    print "ave_apb $ave_apb $std_apb \n";
    print "ave_frs $ave_frs $std_frs \n";
    print "ave_frc $ave_frc $std_frc \n";
    print "ave_TP  $ave_tp $std_tp\n";
    print "ave_BSD $ave_d1 $std_d1\n";
    print "ave_SDD $ave_d2 $std_d2\n";
    print "$ave_alen\t$std_alen\t$ave_sqlg\t$std_sqlg\t$ave_id\t$std_id\t$ave_mut\t$std_mut\t$ave_indl\t$std_indl\t$ave_fo\t$std_fo\t$ave_time\t$std_time\t$ave_abl\t$std_abl\t$ave_alpha\t$std_alpha\t$ave_beta\t$std_beta\t$ave_lambda\t$std_lambda\t$ave_mu\t$std_mu\t$ave_ip\t$std_ip\t$ave_like\t$std_like\t$ave_ttr\t$std_ttr\t$ave_apb\t$std_apb\t$ave_frs\t$std_frs\t$ave_frc\t$std_frc\t$ave_tp\t$std_tp\t$ave_d1\t$std_d1\t$ave_d2\t$std_d2\n";
    print FILE "$ave_alen\t$std_alen\t$ave_sqlg\t$std_sqlg\t$ave_id\t$std_id\t$ave_mut\t$std_mut\t$ave_indl\t$std_indl\t$ave_fo\t$std_fo\t$ave_time\t$std_time\t$ave_abl\t$std_abl\t$ave_alpha\t$std_alpha\t$ave_beta\t$std_beta\t$ave_lambda\t$std_lambda\t$ave_mu\t$std_mu\t$ave_ip\t$std_ip\t$ave_like\t$std_like\t$ave_ttr\t$std_ttr\t$ave_apb\t$std_apb\t$ave_frs\t$std_frs\t$ave_frc\t$std_frc\t$ave_tp\t$std_tp\t$ave_d1\t$std_d1\t$ave_d2\t$std_d2\n";
    close(FILE);
}

