#!/usr/bin/perl -w
#plot_concordance_dom.pl

use strict;
use Class::Struct;

use vars qw ($opt_c $opt_C $opt_D $opt_x);  # required if strict used
use Getopt::Std;
use constant GNUPLOT => '/usr/bin/gnuplot';
getopts ('cCDx:');

# Print a helpful message if the user provides no input file.
if (!@ARGV) {
        print "usage:  plot_concordance_dom.pl [options] dom\n\n";
        print "options:\n";
	print "-c           : do not concatenate files\n";
	print "-C           : only conactenate\n";
	print "-D           : use dnaml-erate-dev [ default dnaml-erate]\n";
	print "-x <name>    : add suffix to directory\n";
	exit;
}
my $dom = shift;
my $root;
my $trialdir;
my $npt;
my $ptrial;
my $ptrialdir;

my $all_dir;

#SSU
if ($dom =~ /^s\_arc$/) {
    $root      = "16S_arc_ae2_refcons_rf.95.phylip";
    $npt       = 20;
    $ptrial    = "NS8.TS200";
    $ptrialdir = "$ptrial";
    $trialdir  = "NS8.TS4000";
    $all_dir   = "16S_all/NS8.1";
}
elsif ($dom =~ /^s\_bac$/) {
    $root      = "16S_bac_ae2_refcons_rf.95.phylip";
    $npt       = 50;
    $ptrial    = "NS8.TS200";
    $ptrialdir = "$ptrial";
    $trialdir  = "NS8.TS10000";
    $all_dir   = "16S_all/NS8.2";
}
elsif ($dom =~ /^s\_chl$/) {
    $root      = "16S_chl_ae2_refcons_rf.95.phylip";
    $npt       = 20;
    $ptrial    = "NS8.TS200";
    $ptrialdir = "$ptrial";
    $trialdir  = "NS8.TS4000";
    $all_dir   = "16S_all/NS8.3";
}
elsif ($dom =~ /^s\_euk$/) {
    $root      = "16S_euk_ae2_refcons_rf.95.phylip";
    $npt       = 50;
    $ptrial    = "NS8.TS200";
    $ptrialdir = "$ptrial";
    $trialdir  = "NS8.TS10000";
    $all_dir   = "16S_all/NS8.4";
}
elsif ($dom =~ /^s\_mit$/) {
    $root      = "16S_mito_ae2_refcons_rf.95.phylip";
    $npt       = 50;
    $ptrial    = "NS8.TS200";
    $ptrialdir = "$ptrial"; 
    $trialdir  = "NS8.TS10000";
    $all_dir   = "16S_all/NS8.5";
}
elsif ($dom =~ /^s\_all$/) {
    $root      = "16S_ae2_refcons_rf.95.phylip";
    $npt       = 5;
    $ptrial    = "NS8";
    $ptrialdir = "$ptrial"; 
    $trialdir  = "NS8";
}
#LSU
elsif ($dom =~ /^l\_arc$/) {
    $root      = "23S_arc_ae2_refcons_rf.95.phylip";
    $npt       = 20;
    $ptrial    = "NS8.TS200";
    $ptrialdir = "$ptrial";
    $trialdir  = "NS8.TS4000";
    $all_dir   = "23S_all/NS8.1";
}
elsif ($dom =~ /^l\_bac$/) {
    $root      = "23S_bac_ae2_refcons_rf.95.phylip";
    $npt       = 50;
    $ptrial    = "NS8.TS200";
    $ptrialdir = "$ptrial";
    $trialdir  = "NS8.TS10000";
    $all_dir   = "23S_all/NS8.2";
}
elsif ($dom =~ /^l\_chl$/) {
    $root      = "23S_chl_ae2_refcons_rf.95.phylip";
    $npt       = 20;
    $ptrial    = "NS8.TS200";
    $ptrialdir = "$ptrial";
    $trialdir  = "NS8.TS4000";
    $all_dir   = "23S_all/NS8.3";
}
elsif ($dom =~ /^l\_euk$/) {
    $root      = "23S_euk_ae2_refcons_rf.95.phylip";
    $npt       = 50;
    $ptrial    = "NS8.TS200";
    $ptrialdir = "$ptrial";
    $trialdir  = "NS8.TS10000";
    $all_dir   = "23S_all/NS8.4";
}
elsif ($dom =~ /^l\_all$/) {
    $root      = "23S_ae2_refcons_rf.95.phylip";
    $npt       = 4;
    $ptrial    = "NS8";
    $ptrialdir = "$ptrial"; 
    $trialdir  = "NS8";
}
else {
    print "bad dom $dom\n";
    die;
}

my $N = 3;

# run split in npt trials
my @ptrialdir;
for (my $t = 0; $t < $npt; $t ++) {
    my $num = $t+1;
    if ($npt == 1) { $ptrialdir[$t] = "$ptrialdir";      }
    else           { $ptrialdir[$t] = "$ptrialdir.$num"; }
}

# $ERATEDIR (shell env variable)
my $eratedir =  $ENV{'ERATEDIR'};
my $plotscript = "$eratedir/scripts/plot_concordance_averages.pl";

my @avefile;
my @cavefile;

# cat the files from the different partial directories
cat_files ($N, $npt, $ptrial, $trialdir, \@ptrialdir, \@avefile, \@cavefile);

# calculate averages
if (!$opt_C) { run_plot_concordance_averages($N, $root, $trialdir, \@cavefile); }

########################################################################################################
sub cat_files {
    my ($N, $npt, $ptrial, $trialdir, $ptrialdir_ref, $avefile_ref, $cavefile_ref) = @_;

    my $which_dnamle = "dnaml-erate";
    if ($opt_D) { $which_dnamle .= "-dev"; }

    my $path = $trialdir;
    if ($opt_x) {
	$trialdir .= ".$opt_x";
    }
    
    # cleanup the directory
    if ($npt > 1 && !$opt_x) {
	system("rm -rf $trialdir\n");
	system("mkdir $trialdir\n");
    }
    
    for (my $n = 0; $n < $N; $n ++) {
	for (my $t = 0; $t < $npt; $t ++) {
	    my $m = $n*$npt+$t;
	    
	    if    ($n == 0) { 
		$avefile_ref->[$m] = "$ptrialdir_ref->[$t]/$root.dnaml.$ptrial.averages"; 
	    }
	    elsif ($n == 1) { 
		$avefile_ref->[$m] = "$ptrialdir_ref->[$t]/$root.$which_dnamle.$ptrial.averages"; 
	    }
	    elsif ($n == 2) { 
		$avefile_ref->[$m] = "$ptrialdir_ref->[$t]/$root.$which_dnamle.C.$ptrial.averages"; 
	    }
	}   
    }
    
    # the concatenated files
    my @cavefile_name;
    for (my $n = 0; $n < $N; $n ++) {
	if    ($n == 0) { 
	    $cavefile_name[$n] = "$root.dnaml.$path.averages"; 
	}
	elsif ($n == 1) { 
	    $cavefile_name[$n] = "$root.$which_dnamle.$path.averages"; 
	}
	elsif ($n == 2) { 
	    $cavefile_name[$n] = "$root.$which_dnamle.C.$path.averages"; 
	}

	$cavefile_ref->[$n] = "$trialdir/$cavefile_name[$n]";
	system("rm $cavefile_ref->[$n]\n");
    } 
        if (!$opt_c) {
	for (my $n = 0; $n < $N; $n ++) {
	    my $cmd = "";
	    
	    for (my $t = 0; $t < $npt; $t ++) {
		my $m = $n*$npt+$t;
		$cmd .= "$avefile_ref->[$m] ";
	    }
	    
	    system ("cat $cmd > $cavefile_ref->[$n]\n");
	}
    }

    # copy the concatenated files to the "all" directory
    my $newpath  = $path;
    if ($newpath =~ /(NS\d+)\./) { $newpath = $1; }
    my $name = $root;
    if ($name =~ /^(\d+S\_)\S+\_(ae2.+)$/) { $name = $1.$2; }
    my @name;
    for (my $n = 0; $n < $N; $n ++) {
	if    ($n == 0) { 
	    $name[$n] = "$name.dnaml.$newpath.averages"; 
	}
	elsif ($n == 1) { 
	    $name[$n] = "$name.$which_dnamle.$newpath.averages"; 
	}
	elsif ($n == 2) { 
	    $name[$n] = "$name.$which_dnamle.C.$newpath.averages"; 
	}
    }
    if ($all_dir) {
	system("rm -rf ../$all_dir\n");
	system("mkdir ../$all_dir\n");
	for (my $n = 0; $n < $N; $n ++) {
	    system("cp $cavefile_ref->[$n] ../$all_dir/$name[$n]\n");
	}
    }
}

sub run_plot_concordance_averages {
    my ($N, $root, $trialdir, $cavefile_ref) = @_;

    my $cmd = "-s ";
    if ($opt_D) { $cmd .= "-D "; }
    $cmd .= "$N $root $trialdir";
    system ("$plotscript $cmd\n");

}
