#!/usr/bin/perl -w
#plot_histograms.pl

use strict;
use Class::Struct;

use vars qw ($opt_A $opt_B $opt_C $opt_b $opt_e $opt_o $opt_s $opt_w);  # required if strict used
use Getopt::Std;
use constant GNUPLOT => '/usr/bin/gnuplot';

getopts ('ABCbosw');

# Print a helpful message if the user provides no input file.
if (!@ARGV) {
        print "usage:  plot_histograms.pl [options] dir\n\n";
        print "options:\n";
	print "-A           :  branch opt only a la dnaml\n";
	print "-B           :  branch opt only using cg\n";
        print "-C           :  optimize alpha y beta\n";
	print "-b           :  uses 2 programs in the same msa\n";
        print "-e           :  use dnaml-erate    [ default dnaml]\n";
        print "-o           :  use s3 programs: dnaml and dnaml-erate and dnaml-erate optimizing all rate paramters in the same msa\n";
        print "-s           :  seeplots    [ default do not]\n";
        print "-w           :  use working copy for the histogram [ default use definite copy]\n";
       exit;
}

my $dir = shift;

my $seeplots = 0;
if ($opt_s) { $seeplots = 1; }

my $dnamlx = "dnaml";
my $dnamle = "";
my $dnamlo = "";

if ($opt_e) { $dnamlx = "dnaml-erate"; }

if ($opt_b || $opt_o) {
    $dnamle = "dnaml-erate";
    if    ($opt_A) { $dnamle .= "-default_bopt"; } # branch opt only a la dnaml
    elsif ($opt_B) { $dnamle .= "-cg_bopt"; }      # branch opt only using cg
}

if ($opt_o ) {
    $dnamlo = "dnaml-erate";
    if (!$opt_C) { $dnamlo .= "-4";}
}

my $hh_msalen;
my $hh_sqleng;
my $hh_sqlena;
my $hp_msalen;
my $hp_sqleng;
my $hp_sqlena;

if ($opt_w) {
    $hh_msalen = "$dir/wc_histogram_msalen";
    $hh_sqleng = "$dir/wc_histogram_sqleng";
    $hh_sqlena = "$dir/wc_histogram_sqlena";
    $hp_msalen = "$dir/wc_paramhisto_msalen";
    $hp_sqleng = "$dir/wc_paramhisto_sqleng";
    $hp_sqlena = "$dir/wc_paramhisto_sqlena";
}
else {
    $hh_msalen = "$dir/histogram_msalen";
    $hh_sqleng = "$dir/histogram_sqleng";
    $hh_sqlena = "$dir/histogram_sqlena";
    $hp_msalen = "$dir/paramhisto_msalen";
    $hp_sqleng = "$dir/paramhisto_sqleng";
    $hp_sqlena = "$dir/paramhisto_sqlena";
}

my $xlabel_sqleng = "GEOMETRIC MEAN SEQUENCES LENTGH";
plot_hh($hh_sqleng, $xlabel_sqleng, $seeplots);
plot_hp($hp_sqleng, $xlabel_sqleng, $seeplots);

$seeplots = 0;
my $xlabel_msalen = "ALIGNMENT LENTGH";
plot_hh($hh_msalen, $xlabel_msalen, $seeplots);
plot_hp($hp_msalen, $xlabel_msalen, $seeplots);

my $xlabel_sqlena = "ARITHMETIC MEAN SEQUENCES LENTGH";
plot_hh($hh_sqlena, $xlabel_sqlena, $seeplots);
plot_hp($hp_sqlena, $xlabel_sqlena, $seeplots);



################
#### subroutines
################

sub gnuplot_hhhisto {

    my ($filehisto, $title, $xlabel, $key, $seeplots) = @_;

    my $outplot = "$filehisto.ps";
   
    # Itemized plots
    plot_tp($filehisto, $title, $xlabel, $key, $seeplots);
    plot_d1($filehisto, $title, $xlabel, $key, $seeplots);
    plot_d2($filehisto, $title, $xlabel, $key, $seeplots);
    plot_time($filehisto, $title, $xlabel, $key, $seeplots);
    
    # A file with all the plots
    $seeplots = 0;
    my $ylabel;

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";

    print GP "set terminal postscript color solid 14\n";
    print GP "set style line 1 lt 1 lw 4\n";
    print GP "set style line 2 lt 2 lw 4\n";
    print GP "set style line 3  lt 3 lw 4\n";
    print GP "set style line 4 lt 4 lw 4\n";
    print GP "set style line 5 lt 5 lw 4\n";
    print GP "set style line 6 lt 6 lw 4\n";
    print GP "set style line 7 lt 7 lw 4\n";
    print GP "set style line 8 lt 8 lw 4\n";
    print GP "set style line 9 lt 9 lw 4\n";
    print GP "set style line 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set style line 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set style line 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set style line 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set style line 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set style line 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set style line 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set style line 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set style line 99 lt 9 lw 2 pt 9 ps 1.2\n";

    print GP "set output '$outplot'\n";
    #print GP "set nokey\n";
    print GP "set xlabel '$xlabel'\n";

    print GP "set title \"$title\\n\\n$key\"\n";
    my $newkeyx = "$dnamlx";
    my $newkeye = "$dnamle";
    my $newkeyo = "$dnamlo";

    my $lsx = "3";
    my $lse = "2";
    my $lso = "1";

    if ($opt_b || $opt_o) {
	$ylabel = "fraction TRUE POSITIVE TREES  (TOPOLOGY)";
	print GP "set ylabel '$ylabel'\n";
	print GP "plot '$filehisto' using 1:4 title '$newkeyx' ls $lsx, '$filehisto' using 1:13 title '$newkeye' ls $lse \n";

	$ylabel = "TREE  DISTANCE (Branch Score Distance)";
	print GP "set ylabel '$ylabel'\n";
	print GP "plot '$filehisto' using 1:5:6 with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:14:15  with yerrorbars title '$newkeye' ls $lse\n";

	$ylabel = "TREE  DISTANCE (Symmetric Difference Distance)";
	print GP "set ylabel '$ylabel'\n";
	print GP "plot '$filehisto' using 1:7:8 with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:16:17  with yerrorbars title '$newkeye' ls $lse\n";

	$ylabel = "RUN TIME (sec)";
	print GP "set ylabel '$ylabel'\n";
	print GP "plot '$filehisto' using 1:9:10 with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:18:19  with yerrorbars title '$newkeye' ls $lse\n";
    
	if ($opt_o) {
	    $ylabel = "fraction TRUE POSITIVE TREES  (TOPOLOGY)";
	    print GP "set ylabel '$ylabel'\n";
	    print GP "plot '$filehisto' using 1:4 title '$newkeyx' ls $lsx, '$filehisto' using 1:22 title '$newkeyo' ls $lso\n";
	    
	    $ylabel = "TREE  DISTANCE (Branch Score Distance)";
	    print GP "set ylabel '$ylabel'\n";
	    print GP "plot '$filehisto' using 1:5:6 with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:23:24  with yerrorbars title '$newkeyo' ls $lso\n";
	    
	    $ylabel = "TREE  DISTANCE (Symmetric Difference Distance)";
	    print GP "set ylabel '$ylabel'\n";
	    print GP "plot '$filehisto' using 1:7:8 with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:25:26  with yerrorbars title '$newkeyo' ls $lso\n";
	    
	    $ylabel = "RUN TIME (sec)";
	    print GP "set ylabel '$ylabel'\n";
	    print GP "plot '$filehisto' using 1:9:10 with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:27:28  with yerrorbars title '$newkeyo' ls $lso\n";
	    
	    $ylabel = "fraction TRUE POSITIVE TREES  (TOPOLOGY)";
	    print GP "set ylabel '$ylabel'\n";
	    print GP "plot '$filehisto' using 1:4 title '$newkeyx' ls $lsx, '$filehisto' using 1:13 title '$newkeye' ls $lse, '$filehisto' using 1:22 title '$newkeyo' ls $lso\n";
	    
	    $ylabel = "TREE  DISTANCE  (Branch Score Distance)";
	    print GP "set ylabel '$ylabel'\n";
	    print GP "plot '$filehisto' using 1:5:6 with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:14:15  with yerrorbars title '$newkeye' ls $lse, '$filehisto' using 1:23:24  with yerrorbars title '$newkeyo' ls $lso\n";
	    
	    $ylabel = "TREE  DISTANCE  (Symmetric Difference Distance)";
	    print GP "set ylabel '$ylabel'\n";
	    print GP "plot '$filehisto' using 1:7:8 with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:16:17  with yerrorbars title '$newkeye' ls $lse, '$filehisto' using 1:25:26  with yerrorbars title '$newkeyo' ls $lso\n";
	    
	    $ylabel = "RUN TIME (sec)";
	    print GP "set ylabel '$ylabel'\n";
	    print GP "plot '$filehisto' using 1:9:10 with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:18:19  with yerrorbars title '$newkeye' ls $lse, '$filehisto' using 1:27:28  with yerrorbars title '$newkeyo' ls $lso\n";
	}
    }
    else {
	my $singlekey = "$dnamlx";

	my $ls = $lsx;
	if ($opt_e) { $ls = $lse; }

	$ylabel = "fraction TRUE POSITIVE TREES  (TOPOLOGY)";
	print GP "set ylabel '$ylabel'\n";
	print GP "plot '$filehisto' using 1:4 title '$singlekey' ls $ls\n";

	$ylabel = "TREE  DISTANCE  (Branch Score Distance)";
	print GP "set ylabel '$ylabel'\n";
	print GP "plot '$filehisto' using 1:5:6  with yerrorbars title '$singlekey' ls $ls\n";

	$ylabel = "TREE  DISTANCE  (Symmetric Difference  Distance)";
	print GP "set ylabel '$ylabel'\n";
	print GP "plot '$filehisto' using 1:7:8  with yerrorbars title '$singlekey' ls $ls\n";
	
	$ylabel = "RUN TIME (sec)";
	print GP "set ylabel '$ylabel'\n";
	print GP "plot '$filehisto' using 1:9:10  with yerrorbars title '$singlekey' ls $ls\n";
    }
    
    close (GP);

    if ($seeplots) { system ("ggv -landscape -magstep -2 $outplot&\n"); }
}

sub gnuplot_hphisto {

    my ($filehisto, $title, $xlabel, $key, $seeplots) = @_;

    my $outplot = "$filehisto.ps";
    my $ylabel;

    my $lsx = "3";
    my $lse = "2";
    my $lso = "1";

    # Itemized plots
    plot_like($filehisto, $title, $xlabel, $key, $seeplots);
    plot_abl($filehisto, $title, $xlabel, $key, $seeplots);
    plot_param($filehisto, $title, $xlabel, $key, $seeplots);
    plot_ttr($filehisto, $title, $xlabel, $key, $seeplots);
    
    # A file with all the plots
    $seeplots = 0;
    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";

    print GP "set terminal postscript color solid 14\n";
    print GP "set style line 1 lt 1 lw 4\n";
    print GP "set style line 2 lt 2 lw 4\n";
    print GP "set style line 3  lt 3 lw 4\n";
    print GP "set style line 4 lt 4 lw 4\n";
    print GP "set style line 5 lt 5 lw 4\n";
    print GP "set style line 6 lt 6 lw 4\n";
    print GP "set style line 7 lt 7 lw 4\n";
    print GP "set style line 8 lt 8 lw 4\n";
    print GP "set style line 9 lt 9 lw 4\n";
    print GP "set style line 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set style line 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set style line 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set style line 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set style line 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set style line 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set style line 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set style line 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set style line 99 lt 9 lw 2 pt 9 ps 1.2\n";

    print GP "set output '$outplot'\n";
    print GP "set xlabel '$xlabel'\n";

    print GP "set title \"$title\\n\\n$key\"\n";
    my $newkeyx = "$dnamlx";
    my $newkeye = "$dnamle";
    my $newkeyo = "$dnamlo";

    if ($opt_b || $opt_o) {
	$ylabel = "LN LIKELIHOOD";
	print GP "set ylabel '$ylabel'\n";
	print GP "plot '$filehisto' using 1:3:4  with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:20:21  with yerrorbars title '$newkeye' ls $lse\n";

	$ylabel = "AVERAGE BRANCH LENGTH";
	print GP "set ylabel '$ylabel'\n";
	print GP "plot '$filehisto' using 1:5:6  with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:22:23  with yerrorbars title '$newkeye' ls $lse\n";

	$ylabel = "RATE PARAMETERS ** $newkeye";
	print GP "set ylabel '$ylabel'\n";
	print GP "plot '$filehisto' using 1:24:25  with yerrorbars title 'ALPHA' ls 1, '$filehisto' using 1:26:27  with yerrorbars title 'BETA' ls 2, '$filehisto' using 1:28:29  with yerrorbars title 'INS' ls 3, '$filehisto' using 1:30:31  with yerrorbars title 'DEL' ls 4\n";

	#print GP "set yrange [-2:10]\n";
	print GP "plot '$filehisto' using 1:32:33  with yerrorbars title 'TTR' ls 1, '$filehisto' using 1:34:35  with yerrorbars title 'ALPHA + BETA' ls 2\n";
	print GP "unset yrange\n";

    }
    if ($opt_o) {
	
	$ylabel = "LN LIKELIHOOD";
	print GP "set ylabel '$ylabel'\n";
	print GP "plot '$filehisto' using 1:3:4  with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:20:21  with yerrorbars title '$newkeye' ls $lse, '$filehisto' using 1:37:38  with yerrorbars title '$newkeyo' ls $lso\n";

	$ylabel = "AVERAGE BRANCH LENGTH";
	print GP "set ylabel '$ylabel'\n";
	print GP "plot '$filehisto' using 1:5:6  with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:22:23  with yerrorbars title '$newkeye' ls $lse, '$filehisto' using 1:39:40  with yerrorbars title '$newkeyo' ls $lso\n";

	$ylabel = "RATE PARAMETERS ** $newkeyo";
	print GP "set ylabel '$ylabel'\n";
	print GP "plot '$filehisto' using 1:41:42  with yerrorbars title 'ALPHA' ls 1, '$filehisto' using 1:43:44  with yerrorbars title 'BETA' ls 2, '$filehisto' using 1:45:46  with yerrorbars title 'INS' ls 3, '$filehisto' using 1:47:48  with yerrorbars title 'DEL' ls 4\n";

	#print GP "set yrange [-2:10]\n";
	print GP "plot '$filehisto' using 1:49:50  with yerrorbars title 'TTR' ls 1, '$filehisto' using 1:51:52  with yerrorbars title 'ALPHA + BETA' ls 2\n";
	print GP "unset yrange\n";
    }
    
    if ($opt_e) { 
	my $singlekey .= "$dnamlx"; 

	my $ls = $lsx;
	if ($opt_e) { $ls = $lse; }
	
	$ylabel = "LN LIKELIHOOD";
	print GP "set ylabel '$ylabel'\n";
	print GP "plot '$filehisto' using 1:3:4  with yerrorbars title '$singlekey' ls $ls\n";

	$ylabel = "AVERAGE BRANCH LENGTH";
	print GP "set ylabel '$ylabel'\n";
	print GP "plot '$filehisto' using 1:5:6  with yerrorbars title '$singlekey' ls $ls\n";

	$ylabel = "RATE PARAMETERS ** $singlekey";
	print GP "set ylabel '$ylabel'\n";
	print GP "plot '$filehisto' using 1:7:8  with yerrorbars title 'ALPHA' ls 1, '$filehisto' using 1:9:10  with yerrorbars title 'BETA' ls 2, '$filehisto' using 1:11:12  with yerrorbars title 'INS' ls 3, '$filehisto' using 1:13:14  with yerrorbars title 'DEL' ls 4\n";

	#print GP "set yrange [-2:10]\n";
	print GP "plot '$filehisto' using 1:15:16  with yerrorbars title 'TTR' ls 1, '$filehisto' using 1:17:18  with yerrorbars title 'ALPHA + BETA' ls 2\n";
	print GP "unset yrange\n";
    }
    
    close (GP);
    
    if ($seeplots) { system ("ggv -landscape -magstep -2 $outplot&\n"); }
}

sub parse_histo_header{
    my ($filehisto, $title_ref, $key_ref) = @_;

    my $omag = 1000;

    my $title;
    my $key;

    my $ntaxa                 = -1;
    my $target_abl            = -1;
    my $ntree                 = -1;
    my $ntreesofar            = -1;
    my $nsamples_per_len_tree = -1;
    my $nsamples_per_tree     = -1;
    my $meanindelfrq          = -1;
    my $stdindelfrq           = -1;
    my $meanpairid            = -1;
    my $stdpairid             = -1;
    my $meanpairmut           = -1;
    my $stdpairmut            = -1;
    my $meanpairindl          = -1;
    my $stdpairindl           = -1;

    open(HIS, "$filehisto");
    while(<HIS>) {
	if    (/\#\s+Taxa:\s+(\S+)/)                         { $ntaxa = $1; }
	elsif (/\#\s+Trees:\s+(\S+)/)                        { $ntree = $1; }
	elsif (/Average branch length:\s+(\S+)/)             { $target_abl = $1; }
	elsif (/\# Alignments per length and tree:\s+(\S+)/) { $nsamples_per_len_tree = $1; }
	elsif (/Total \# tests per tree:\s+(\S+)/)           { $nsamples_per_tree = $1; }
	elsif (/\#\s+trees\s+so\s+far:\s+(\S+)/)                    { $ntreesofar = $1; }
	elsif (/pairwise id:\s+(\S+)\s+\+\/\-\s+(\S+)/)      { $meanpairid = $1; $stdpairid = $2;}
	elsif (/pairwise mut:\s+(\S+)\s+\+\/\-\s+(\S+)/)     { $meanpairmut = $1; $stdpairmut = $2;}
	elsif (/pairwise indl:\s+(\S+)\s+\+\/\-\s+(\S+)/)    { $meanpairindl = $1; $stdpairindl = $2;}
	elsif (/indel freq:\s+(\S+)\s+\+\/\-\s+(\S+)/)       { $meanindelfrq = $1; $stdindelfrq = $2;}
    }
    close(HIS);

    $meanpairid   = int($meanpairid*$omag)/$omag;
    $stdpairid    = int($stdpairid*$omag)/$omag;
    $meanpairmut  = int($meanpairmut*$omag)/$omag;
    $stdpairmut   = int($stdpairmut*$omag)/$omag;
    $meanpairindl = int($meanpairindl*$omag)/$omag;
    $stdpairindl  = int($stdpairindl*$omag)/$omag;
    $meanindelfrq = int($meanindelfrq*$omag)*100/$omag;
    $stdindelfrq  = int($stdindelfrq*$omag)*100/$omag;
    $target_abl   = int($target_abl*$omag)/$omag;

    $title  = "Ntaxa: $ntaxa ** <branch len> $target_abl ** Ntrees $ntreesofar ** Nsamples/len_and_tree $nsamples_per_len_tree ** ";
    $title .= "\% indels: $meanindelfrq +/- $stdindelfrq";
    $key  = "pairwise \% ID: $meanpairid +/- $stdpairid ** ";
    $key .= "pairwise \% MUT: $meanpairmut +/- $stdpairmut ** ";
    $key .= "pairwise \% INDL: $meanpairindl +/- $stdpairindl";

    $$title_ref = $title;
    $$key_ref = $key;
}

sub plot_hh {
    my ($filehisto, $xlabel, $seeplots) = @_;

    my $title;
    my $key;

    parse_histo_header($filehisto, \$title, \$key);
    gnuplot_hhhisto($filehisto, $title, $xlabel, $key, $seeplots);
}

sub plot_hp {
    my ($filehisto, $xlabel, $seeplots) = @_;

    my $title;
    my $key;
    
    parse_histo_header($filehisto, \$title, \$key);
    gnuplot_hphisto($filehisto, $title, $xlabel, $key, $seeplots);
}

sub plot_tp {
    my ($filehisto, $title, $xlabel, $key, $seeplots) = @_;

    my $outplot = "$filehisto.tp.ps";
    my $ylabel  = "fraction TRUE POSITIVE TREES  (TOPOLOGY)";

    my $newkeyx = "$dnamlx";
    my $newkeye = "$dnamle";
    my $newkeyo = "$dnamlo";

    my $lsx = "3";
    my $lse = "2";
    my $lso = "1";

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";

    print GP "set terminal postscript color solid 14\n";
    print GP "set style line 1 lt 1 lw 4\n";
    print GP "set style line 2 lt 2 lw 4\n";
    print GP "set style line 3  lt 3 lw 4\n";
    print GP "set style line 4 lt 4 lw 4\n";
    print GP "set style line 5 lt 5 lw 4\n";
    print GP "set style line 6 lt 6 lw 4\n";
    print GP "set style line 7 lt 7 lw 4\n";
    print GP "set style line 8 lt 8 lw 4\n";
    print GP "set style line 9 lt 9 lw 4\n";
    print GP "set style line 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set style line 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set style line 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set style line 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set style line 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set style line 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set style line 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set style line 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set style line 99 lt 9 lw 2 pt 9 ps 1.2\n";

    print GP "set output '$outplot'\n";
    print GP "set xlabel '$xlabel'\n";
    print GP "set ylabel '$ylabel'\n";
    print GP "set title \"$title\\n\\n$key\"\n";

    if ($opt_b || $opt_o) {
	print GP "plot '$filehisto' using 1:4 title '$newkeyx' ls $lsx, '$filehisto' using 1:13 title '$newkeye' ls $lse \n";
	if ($opt_o) {
	    print GP "plot '$filehisto' using 1:4 title '$newkeyx' ls $lsx, '$filehisto' using 1:22 title '$newkeyo' ls $lso\n";
	    print GP "plot '$filehisto' using 1:4 title '$newkeyx' ls $lsx, '$filehisto' using 1:13 title '$newkeye' ls $lse, '$filehisto' using 1:22 title '$newkeyo' ls $lso\n";
	}
    }
    else {
	my $singlekey = "$dnamlx";
	my $ls = $lsx; if ($opt_e) { $ls = $lse; }
	print GP "plot '$filehisto' using 1:4 title '$singlekey' ls $ls\n";
    }
    
    close (GP);

    if ($seeplots) { system ("ggv -landscape -magstep -2 $outplot&\n"); }

}

sub plot_d1 {
    my ($filehisto, $title, $xlabel, $key, $seeplots) = @_;

    my $outplot = "$filehisto.d1.ps";
    my $ylabel  = "TREE  DISTANCE (Branch Score Distance)";

    my $newkeyx = "$dnamlx";
    my $newkeye = "$dnamle";
    my $newkeyo = "$dnamlo";

    my $lsx = "3";
    my $lse = "2";
    my $lso = "1";

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";

    print GP "set terminal postscript color solid 14\n";
    print GP "set style line 1 lt 1 lw 4\n";
    print GP "set style line 2 lt 2 lw 4\n";
    print GP "set style line 3  lt 3 lw 4\n";
    print GP "set style line 4 lt 4 lw 4\n";
    print GP "set style line 5 lt 5 lw 4\n";
    print GP "set style line 6 lt 6 lw 4\n";
    print GP "set style line 7 lt 7 lw 4\n";
    print GP "set style line 8 lt 8 lw 4\n";
    print GP "set style line 9 lt 9 lw 4\n";
    print GP "set style line 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set style line 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set style line 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set style line 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set style line 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set style line 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set style line 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set style line 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set style line 99 lt 9 lw 2 pt 9 ps 1.2\n";

    print GP "set output '$outplot'\n";
    print GP "set xlabel '$xlabel'\n";
    print GP "set ylabel '$ylabel'\n";
    print GP "set title \"$title\\n\\n$key\"\n";

    if ($opt_b || $opt_o) {
	print GP "plot '$filehisto' using 1:5 title '$newkeyx' ls $lsx, '$filehisto' using 1:14 title '$newkeye' ls $lse\n";
	print GP "plot '$filehisto' using 1:5:6 with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:14:15  with yerrorbars title '$newkeye' ls $lse\n";
   
	if ($opt_o) {
	    print GP "plot '$filehisto' using 1:5 title '$newkeyx' ls $lsx, '$filehisto' using 1:23  title '$newkeyo' ls $lso\n";
	    print GP "plot '$filehisto' using 1:5:6 with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:23:24  with yerrorbars title '$newkeyo' ls $lso\n";
	    print GP "plot '$filehisto' using 1:5 title '$newkeyx' ls $lsx, '$filehisto' using 1:14 title '$newkeye' ls $lse, '$filehisto' using 1:23 title '$newkeyo' ls $lso\n";
	    print GP "plot '$filehisto' using 1:5:6 with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:14:15  with yerrorbars title '$newkeye' ls $lse, '$filehisto' using 1:23:24  with yerrorbars title '$newkeyo' ls $lso\n";
	    
	}
    }
    else {
	my $singlekey = "$dnamlx";
	my $ls = $lsx; if ($opt_e) { $ls = $lse; }

	print GP "plot '$filehisto' using 1:5 title '$singlekey' ls $ls\n";
	print GP "plot '$filehisto' using 1:5:6  with yerrorbars title '$singlekey' ls $ls\n";
    }

    close (GP);
    if ($seeplots) { system ("ggv -landscape -magstep -2 $outplot&\n"); }

}

sub plot_d2 {
    my ($filehisto, $title, $xlabel, $key, $seeplots) = @_;

    my $outplot = "$filehisto.d2.ps";
    my $ylabel  = "TREE  DISTANCE (Symmetric Difference Distance)";

    my $newkeyx = "$dnamlx";
    my $newkeye = "$dnamle";
    my $newkeyo = "$dnamlo";

    my $lsx = "3";
    my $lse = "2";
    my $lso = "1";

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";

    print GP "set terminal postscript color solid 14\n";
    print GP "set style line 1 lt 1 lw 4\n";
    print GP "set style line 2 lt 2 lw 4\n";
    print GP "set style line 3  lt 3 lw 4\n";
    print GP "set style line 4 lt 4 lw 4\n";
    print GP "set style line 5 lt 5 lw 4\n";
    print GP "set style line 6 lt 6 lw 4\n";
    print GP "set style line 7 lt 7 lw 4\n";
    print GP "set style line 8 lt 8 lw 4\n";
    print GP "set style line 9 lt 9 lw 4\n";
    print GP "set style line 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set style line 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set style line 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set style line 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set style line 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set style line 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set style line 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set style line 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set style line 99 lt 9 lw 2 pt 9 ps 1.2\n";

    print GP "set output '$outplot'\n";
    print GP "set xlabel '$xlabel'\n";
    print GP "set ylabel '$ylabel'\n";
    print GP "set title \"$title\\n\\n$key\"\n";

   if ($opt_b || $opt_o) {
	print GP "plot '$filehisto' using 1:7 title '$newkeyx' ls $lsx, '$filehisto' using 1:16 title '$newkeye' ls $lse\n";
	print GP "plot '$filehisto' using 1:7:8 with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:16:17  with yerrorbars title '$newkeye' ls $lse\n";

	if ($opt_o) {
	    print GP "plot '$filehisto' using 1:7 title '$newkeyx' ls $lsx, '$filehisto' using 1:25 title '$newkeyo' ls $lso\n";
	    print GP "plot '$filehisto' using 1:7:8 with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:25:26  with yerrorbars title '$newkeyo' ls $lso\n";
	    print GP "plot '$filehisto' using 1:7 title '$newkeyx' ls $lsx, '$filehisto' using 1:16 title '$newkeye' ls $lse, '$filehisto' using 1:25 title '$newkeyo' ls $lso\n";
	    print GP "plot '$filehisto' using 1:7:8 with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:16:17  with yerrorbars title '$newkeye' ls $lse, '$filehisto' using 1:25:26  with yerrorbars title '$newkeyo' ls $lso\n";
	}
    }
    else {
	my $singlekey = "$dnamlx";
	my $ls = $lsx; if ($opt_e) { $ls = $lse; }

	print GP "plot '$filehisto' using 1:7:8  with yerrorbars title '$singlekey' ls $ls\n";
    }
 
    close (GP);
    if ($seeplots) { system ("ggv -landscape -magstep -2 $outplot&\n"); }

}

sub plot_time {
    my ($filehisto, $title, $xlabel, $key, $seeplots) = @_;

    my $outplot = "$filehisto.time.ps";
    my $ylabel  = "RUN TIME (sec)";

    my $newkeyx = "$dnamlx";
    my $newkeye = "$dnamle";
    my $newkeyo = "$dnamlo";

    my $lsx = "3";
    my $lse = "2";
    my $lso = "1";

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";

    print GP "set terminal postscript color solid 14\n";
    print GP "set style line 1 lt 1 lw 4\n";
    print GP "set style line 2 lt 2 lw 4\n";
    print GP "set style line 3  lt 3 lw 4\n";
    print GP "set style line 4 lt 4 lw 4\n";
    print GP "set style line 5 lt 5 lw 4\n";
    print GP "set style line 6 lt 6 lw 4\n";
    print GP "set style line 7 lt 7 lw 4\n";
    print GP "set style line 8 lt 8 lw 4\n";
    print GP "set style line 9 lt 9 lw 4\n";
    print GP "set style line 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set style line 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set style line 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set style line 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set style line 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set style line 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set style line 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set style line 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set style line 99 lt 9 lw 2 pt 9 ps 1.2\n";

    print GP "set output '$outplot'\n";
    print GP "set xlabel '$xlabel'\n";
    print GP "set ylabel '$ylabel'\n";
    print GP "set title \"$title\\n\\n$key\"\n";

    if ($opt_b || $opt_o) {
	print GP "plot '$filehisto' using 1:9:10 with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:18:19  with yerrorbars title '$newkeye' ls $lse\n";
    
	if ($opt_o) {
	    print GP "plot '$filehisto' using 1:9:10 with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:27:28  with yerrorbars title '$newkeyo' ls $lso\n";
	    print GP "plot '$filehisto' using 1:9:10 with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:18:19  with yerrorbars title '$newkeye' ls $lse, '$filehisto' using 1:27:28  with yerrorbars title '$newkeyo' ls $lso\n";
	}
    }
    else {
	my $singlekey = "$dnamlx";

	my $ls = $lsx;
	if ($opt_e) { $ls = $lse; }

	print GP "plot '$filehisto' using 1:9:10  with yerrorbars title '$singlekey' ls $ls\n";
    }
 
   close (GP);
    if ($seeplots) { system ("ggv -landscape -magstep -2 $outplot&\n"); }

}

sub plot_like {

    my ($filehisto, $title, $xlabel, $key, $seeplots) = @_;

    my $outplot = "$filehisto.like.ps";
    my $ylabel  = "LN LIKELIHOOD";

    my $newkeyx = "$dnamlx";
    my $newkeye = "$dnamle";
    my $newkeyo = "$dnamlo";
    
    my $lsx = "3";
    my $lse = "2";
    my $lso = "1";

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";

    print GP "set terminal postscript color solid 14\n";
    print GP "set style line 1 lt 1 lw 4\n";
    print GP "set style line 2 lt 2 lw 4\n";
    print GP "set style line 3  lt 3 lw 4\n";
    print GP "set style line 4 lt 4 lw 4\n";
    print GP "set style line 5 lt 5 lw 4\n";
    print GP "set style line 6 lt 6 lw 4\n";
    print GP "set style line 7 lt 7 lw 4\n";
    print GP "set style line 8 lt 8 lw 4\n";
    print GP "set style line 9 lt 9 lw 4\n";
    print GP "set style line 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set style line 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set style line 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set style line 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set style line 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set style line 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set style line 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set style line 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set style line 99 lt 9 lw 2 pt 9 ps 1.2\n";

    print GP "set output '$outplot'\n";
    print GP "set xlabel '$xlabel'\n";
    print GP "set ylabel '$ylabel'\n";
    print GP "set title \"$title\\n\\n$key\"\n";
    
     if ($opt_b || $opt_o) {
	 print GP "plot '$filehisto' using 1:3:4  with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:20:21  with yerrorbars title '$newkeye' ls $lse\n";
     }
    if ($opt_o) {
	print GP "plot '$filehisto' using 1:3:4  with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:20:21  with yerrorbars title '$newkeye' ls $lse, '$filehisto' using 1:37:38  with yerrorbars title '$newkeyo' ls $lso\n";
    }
    
    if ($opt_e) { 
	my $singlekey .= "$dnamlx"; 
	my $ls = $lsx; if ($opt_e) { $ls = $lse; }
	
	print GP "plot '$filehisto' using 1:3:4  with yerrorbars title '$singlekey' ls $ls\n";
    }
    
    close (GP);
    
    if ($seeplots) { system ("ggv -landscape -magstep -2 $outplot&\n"); }
}

sub plot_abl {

    my ($filehisto, $title, $xlabel, $key, $seeplots) = @_;

    my $outplot = "$filehisto.abl.ps";
    my $ylabel  = "AVERAGE BRANCH LENGTH";

    my $newkeyx = "$dnamlx";
    my $newkeye = "$dnamle";
    my $newkeyo = "$dnamlo";
    
    my $lsx = "3";
    my $lse = "2";
    my $lso = "1";

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";

    print GP "set terminal postscript color solid 14\n";
    print GP "set style line 1 lt 1 lw 4\n";
    print GP "set style line 2 lt 2 lw 4\n";
    print GP "set style line 3  lt 3 lw 4\n";
    print GP "set style line 4 lt 4 lw 4\n";
    print GP "set style line 5 lt 5 lw 4\n";
    print GP "set style line 6 lt 6 lw 4\n";
    print GP "set style line 7 lt 7 lw 4\n";
    print GP "set style line 8 lt 8 lw 4\n";
    print GP "set style line 9 lt 9 lw 4\n";
    print GP "set style line 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set style line 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set style line 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set style line 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set style line 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set style line 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set style line 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set style line 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set style line 99 lt 9 lw 2 pt 9 ps 1.2\n";

    print GP "set output '$outplot'\n";
    print GP "set xlabel '$xlabel'\n";
    print GP "set ylabel '$ylabel'\n";
    print GP "set title \"$title\\n\\n$key\"\n";
    
     if ($opt_b || $opt_o) {
	print GP "plot '$filehisto' using 1:5:6  with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:22:23  with yerrorbars title '$newkeye' ls $lse\n";
    }
    if ($opt_o) {
	print GP "plot '$filehisto' using 1:5:6  with yerrorbars title '$newkeyx' ls $lsx, '$filehisto' using 1:22:23  with yerrorbars title '$newkeye' ls $lse, '$filehisto' using 1:39:40  with yerrorbars title '$newkeyo' ls $lso\n";
    }
    
    if ($opt_e) { 
	my $singlekey .= "$dnamlx"; 
	my $ls = $lsx; if ($opt_e) { $ls = $lse; }
	
	print GP "plot '$filehisto' using 1:5:6  with yerrorbars title '$singlekey' ls $ls\n";
    }
    
    close (GP);
    
    if ($seeplots) { system ("ggv -landscape -magstep -2 $outplot&\n"); }
}

sub plot_param {

    my ($filehisto, $title, $xlabel, $key, $seeplots) = @_;

    my $outplot = "$filehisto.param.ps";
    my $ylabel  = "RATE PARAMETERS";

    my $newkeyx = "$dnamlx";
    my $newkeye = "$dnamle";
    my $newkeyo = "$dnamlo";
    
    my $lsx = "3";
    my $lse = "2";
    my $lso = "1";

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";

    print GP "set terminal postscript color solid 14\n";
    print GP "set style line 1 lt 1 lw 4\n";
    print GP "set style line 2 lt 2 lw 4\n";
    print GP "set style line 3  lt 3 lw 4\n";
    print GP "set style line 4 lt 4 lw 4\n";
    print GP "set style line 5 lt 5 lw 4\n";
    print GP "set style line 6 lt 6 lw 4\n";
    print GP "set style line 7 lt 7 lw 4\n";
    print GP "set style line 8 lt 8 lw 4\n";
    print GP "set style line 9 lt 9 lw 4\n";
    print GP "set style line 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set style line 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set style line 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set style line 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set style line 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set style line 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set style line 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set style line 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set style line 99 lt 9 lw 2 pt 9 ps 1.2\n";

    print GP "set output '$outplot'\n";
    print GP "set xlabel '$xlabel'\n";
    print GP "set title \"$title\\n\\n$key\"\n";
    
     if ($opt_b || $opt_o) {
	$ylabel = "RATE PARAMETERS  ** $newkeye";
	print GP "set ylabel '$ylabel'\n";
	print GP "plot '$filehisto' using 1:24:25  with yerrorbars title 'ALPHA' ls 1, '$filehisto' using 1:26:27  with yerrorbars title 'BETA' ls 2, '$filehisto' using 1:28:29  with yerrorbars title 'INS' ls 3, '$filehisto' using 1:30:31  with yerrorbars title 'DEL' ls 4\n";
    }
    if ($opt_o) {
	$ylabel = "RATE PARAMETERS ** $newkeyo";
	print GP "set ylabel '$ylabel'\n";
	print GP "plot '$filehisto' using 1:41:42  with yerrorbars title 'ALPHA' ls 1, '$filehisto' using 1:43:44  with yerrorbars title 'BETA' ls 2, '$filehisto' using 1:45:46  with yerrorbars title 'INS' ls 3, '$filehisto' using 1:47:48  with yerrorbars title 'DEL' ls 4\n";
    }
    
    if ($opt_e) { 
	my $singlekey .= "$dnamlx"; 
	my $ls = $lsx; if ($opt_e) { $ls = $lse; }
	
	$ylabel = "RATE PARAMETERS ** $singlekey";
	print GP "set ylabel '$ylabel'\n";
	print GP "plot '$filehisto' using 1:7:8  with yerrorbars title 'ALPHA' ls 1, '$filehisto' using 1:9:10  with yerrorbars title 'BETA' ls 2, '$filehisto' using 1:11:12  with yerrorbars title 'INS' ls 3, '$filehisto' using 1:13:14  with yerrorbars title 'DEL' ls 4\n";
    }
    
    close (GP);
    
    if ($seeplots) { system ("ggv -landscape -magstep -2 $outplot&\n"); }
}

sub plot_ttr {

    my ($filehisto, $title, $xlabel, $key, $seeplots) = @_;

    my $outplot = "$filehisto.ttr.ps";
    my $ylabel  = "RATE PARAMETERS";

    my $newkeyx = "$dnamlx";
    my $newkeye = "$dnamle";
    my $newkeyo = "$dnamlo";
    
    my $ymin = -2;
    my $ymax = 10;

    my $lsx = "3";
    my $lse = "2";
    my $lso = "1";

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";

    print GP "set terminal postscript color solid 14\n";
    print GP "set style line 1 lt 1 lw 4\n";
    print GP "set style line 2 lt 2 lw 4\n";
    print GP "set style line 3  lt 3 lw 4\n";
    print GP "set style line 4 lt 4 lw 4\n";
    print GP "set style line 5 lt 5 lw 4\n";
    print GP "set style line 6 lt 6 lw 4\n";
    print GP "set style line 7 lt 7 lw 4\n";
    print GP "set style line 8 lt 8 lw 4\n";
    print GP "set style line 9 lt 9 lw 4\n";
    print GP "set style line 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set style line 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set style line 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set style line 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set style line 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set style line 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set style line 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set style line 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set style line 99 lt 9 lw 2 pt 9 ps 1.2\n";

    print GP "set output '$outplot'\n";
    print GP "set xlabel '$xlabel'\n";
    print GP "set title \"$title\\n\\n$key\"\n";
    
    print GP "set yrange [$ymin:$ymax]\n";

     if ($opt_b || $opt_o) {
	$ylabel = "RATE PARAMETERS  ** $newkeye";
	print GP "plot '$filehisto' using 1:32:33  with yerrorbars title 'TTR' ls 1, '$filehisto' using 1:34:35  with yerrorbars title 'ALPHA + BETA' ls 2\n";

    }
    if ($opt_o) {
	$ylabel = "RATE PARAMETERS  ** $newkeyo";
	print GP "plot '$filehisto' using 1:49:50  with yerrorbars title 'TTR' ls 1, '$filehisto' using 1:51:52  with yerrorbars title 'ALPHA + BETA' ls 2\n";
    }
    
    if ($opt_e) { 
	my $singlekey .= "$dnamlx"; 
	my $ls = $lsx; if ($opt_e) { $ls = $lse; }
	
	$ylabel = "RATE PARAMETERS ** $singlekey";
	print GP "plot '$filehisto' using 1:15:16  with yerrorbars title 'TTR' ls 1, '$filehisto' using 1:17:18  with yerrorbars title 'ALPHA + BETA' ls 2\n";
    }
    
    close (GP);
    
    if ($seeplots) { system ("ggv -landscape -magstep -2 $outplot&\n"); }
}

