#!/usr/bin/perl -w
#plot_tkf.pl

use strict; 
use Class::Struct;

use vars qw ($opt_l $opt_m $opt_v);  # required if strict used
use Getopt::Std;
use constant GNUPLOT => '/usr/bin/gnuplot';
getopts ('l:m:v');


# Print a helpful message if the user provides no input file.
if (!@ARGV) {
    print "usage:  plot_tkf.pl [options] file\n\n";
    print "-l <num>     :  insertion rate [ l=0]\n";
    print "-m <num>     :  deletion rate [ m=0]\n";
    print "-v           :  verbose\n";
    exit;
}
my $file = shift;

my $lambda = 0.5;
my $mu     = 50.05;
if ($opt_l) { $lambda = $opt_l; }
if ($opt_m) { $mu     = $opt_m; }

my $verbose = 0;
if ($opt_v) { $verbose = $opt_v; }

my $plotfile = "$file.ps";
plot_tkf($lambda, $mu, $plotfile);


sub plot_tkf {
    
    my ($ins, $del, $plotfile) = @_;
    
    my $xlabel = "";
    my $ylabel = "";
    my $title  = "insertion rate = $ins,  deletion rate = $del";
    my $key    = "";
    

    open(GP,'|'.GNUPLOT) || die "Gnuplot: $!";

    print GP "set terminal postscript color solid 14\n";
    print GP "set style line 1 lt 1 lw 4\n";
    print GP "set style line 2 lt 2 lw 4\n";
    print GP "set style line 3  lt 3 lw 4\n";
    print GP "set style line 4 lt 4 lw 4\n";+
    print GP "set style line 5 lt 5 lw 4\n";
    print GP "set style line 6 lt 6 lw 4\n";
    print GP "set style line 7 lt 7 lw 4\n";
    print GP "set style line 8 lt 8 lw 4\n";
    print GP "set style line 9 lt 9 lw 4\n";
    print GP "set style line 11 lt 1 lw 2 pt 1 ps 1.2\n";
    print GP "set style line 22 lt 2 lw 2 pt 2 ps 1.2\n";
    print GP "set style line 33 lt 3 lw 2 pt 3 ps 1.2\n";
    print GP "set style line 44 lt 4 lw 2 pt 4 ps 1.2\n";
    print GP "set style line 55 lt 5 lw 2 pt 5 ps 1.2\n";
    print GP "set style line 66 lt 6 lw 2 pt 6 ps 1.2\n";
    print GP "set style line 77 lt 7 lw 2 pt 7 ps 1.2\n";
    print GP "set style line 88 lt 8 lw 2 pt 8 ps 1.2\n";
    print GP "set style line 99 lt 9 lw 2 pt 9 ps 1.2\n";

    print GP "set output '$plotfile'\n";
    #print GP "set nokey\n";
    print GP "set xlabel '$xlabel'\n";

    print GP "set title \"$title\\n\\n$key\"\n";
  
    print GP "expterm(x)=exp(($ins-$del)*x)\n";
    print GP "beta(x)= ($ins - $ins*expterm(x))/($del - $ins*expterm(x))\n";
    
    print GP "plot [0:40] beta(x) ls 2\n";

    close (GP);

    system ("evince $plotfile&\n"); 
}
