#!/usr/bin/perl -w
#run compare_histograms.pl

use strict;
use Class::Struct;

use vars qw ($opt_f $opt_s $opt_w);  # required if strict used
use Getopt::Std;
use constant GNUPLOT => '/usr/bin/gnuplot';

getopts ('fsw');

# Print a helpful message if the user provides no input file.
if (!@ARGV) {
        print "usage:  rn compare_histograms.pl [options] N \n\n";
        print "options:\n";
        print "-f           :  fixtree    [ default simtree]\n";
        print "-s           :  seeplots    [ default do not]\n";
       exit;
}
my $ndir = shift;

#eratedir = ERATEDIR (shell env variable)
my $eratedir =  $ENV{'ERATEDIR'};

my $compare_histograms = "$eratedir/scripts/compare_histograms.pl";

my $cmd = "";
if ($opt_s) { $cmd .= "-s "; }
if ($opt_w) { $cmd .= "-w "; }

$cmd .= "$ndir ";

my $dir = "$eratedir/test/eighttaxa/";
if ($opt_f) { $dir .= "fixtree"; }
else        { $dir .= "simtree"; }

my $tag = "_o";

for (my $n = 0; $n < $ndir; $n ++) { 
    $cmd .= "$dir/test$n$tag "; 
}

print "$cmd\n";

system ("$compare_histograms $cmd\n");
