#!/usr/bin/perl -w
#run_phylip.pl

use strict;
use vars qw ($opt_A $opt_b $opt_B $opt_C $opt_D $opt_G $opt_I $opt_j $opt_J $opt_c $opt_e $opt_f $opt_F $opt_m  $opt_M $opt_o $opt_O $opt_r $opt_R $opt_T $opt_v);  # required if strict used
use Getopt::Std;
use constant GNUPLOT => '/usr/bin/gnuplot';

getopts ('Ab:BCDcef:F:GIj:JmM:oO:r:R:T:v');


# Print a helpful message if the user provides no input file.
if (!@ARGV) {
        print "usage:  run_phylip.pl [options] file\n\n";
        print "options:\n";
        print "-A           :  branch opt only a la dnaml\n";
	print "-b <s>       :  use base frequencies for A, C, G, T/U (use blanks to separate) given in <s>\n";
	print "-B           :  branch opt only using cg\n";
        print "-C           :  optimize alpha y beta\n";
        print "-c           :  clean up\n";
	print "-D           :  use dnaml-erate-dev [ default dnaml]\n";
	print "-e           :  use dnaml-erate [ default dnaml]\n";
	print "-f <val>     :  run phylip using a given indel prior\n";
	print "-F <val>     :  run phylip using a time dependent indel prior\n";
	print "-G           :  randomize input sequences\n";
	print "-I           :  improve [ default not]\n";
	print "-j <val>     :  njumble [default 1]\n";
	print "-J           :  randomize input sequences\n";
	print "-m           :  make the executable\n";
	print "-M <num>     :  run phylip in multiple alignments mode\n";
	print "-o           :  use dnamle v0.6\n";
	print "-O <num>     :  Outgroup root is <num> [default no outgroup] \n";
	print "-r <val>     :  oddran\n";
	print "-R <val>      :  rate variation amongst rates is gamma distributed, and <val> is the coefficient of variation of subs rate amongst sites [default is constant rate]\n";
	print "-T <val>     :  transition/transversion ratio [default 2.0]\n";
        print "-v           :  verbose\n";
	exit;
}
 
my $file = shift;

# $ERATEDIR (shell env variable)
my $eratedir =  $ENV{'ERATEDIR'};

# PHYLIP version 3.66
#
my $phylipdir = "$eratedir/src/phylip3.66-erate/src";
if ($opt_o) 
{ $phylipdir = "$eratedir/versions/erate-v.0.7/phylip3.66-erate/src"; }

my $phylip;
if    ($opt_e) { $phylip = "dnaml-erate";     }
elsif ($opt_D) { $phylip = "dnaml-erate-dev"; }
else           { $phylip = "dnaml";           }

my $phylipmode = 0;
if ($opt_e || $opt_D) {
    if ($opt_A) { $phylipmode = 1; } # branch opt only a la dnaml
    if ($opt_B) { $phylipmode = 2; } # branch opt only using cg
    if ($opt_C) { $phylipmode = 3; } # optimize alpha y beta
}

my $clean = 0;   if ($opt_c) { $clean = 1; }
my $verbose = 0; if ($opt_v) { $verbose = 1; }

if ($opt_m) { make_phylip($phylipdir, $phylip); }

srand;
run_phylip($file, $phylipdir, $phylip, $phylipmode);

########################################################################
sub make_phylip {
    my ($phylipdir, $phylip) = @_;

    #system("cd $phylipdir\n");
    system("make $phylip\n");
}

sub run_phylip {
    my ($msafile, $phylipdir, $phylip, $phylipmode) = @_;

    my $phylipinputfile     = "$msafile.$phylip.phylipinput";
    my $phylipscreenputfile = "$msafile.$phylip.phylipscreenput";
    my $phylipoutputfile    = "$msafile.$phylip.phylipoutput";
    my $phylipouttreefile   = "$msafile.$phylip.phylipouttree";
    my $phyliptimefile      = "$msafile.$phylip.phyliptime";
    print "outfile: $phylipouttreefile\n";

    my $oddran = int(rand()*100)*2 + 1;
    if ($opt_r) { $oddran = $opt_r; }

    my $njumble = 1;
    if ($opt_j) { $njumble = $opt_j; }

    system("rm outfile\n");
    system("rm outtree\n");

    # run PHYLIP
    #
    # with default parameters: 
    # F84, ttratio = 2.0, a+b = 1
    # get distribution from the alignment
    #

    # make phylip inputfile
    open(IN, ">$phylipinputfile");
    print IN "$msafile\n";

    # options 
    if ($opt_I) { print IN "S\n"; }
    if ($opt_M) { print IN "M\nD\n$opt_M\n$oddran\n$njumble\n"; }
    if ($opt_f) { print IN "9\n$opt_f\n"; }
    if ($opt_F) { print IN "8\n$opt_F\n"; }
    if ($opt_G) { print IN "G\n"; }
    if ($opt_J) { print IN "J\n12345\n10\n"; }
    if ($opt_O) { print IN "o\n$opt_O\n"; }
    if ($opt_R) { print IN "R\n"; }
    if ($opt_T) { print IN "T\n$opt_T\n"; }

    if ($opt_b) {
	my $s = $opt_b;
	my $fa;
	my $fc;
	my $fg;
	my $ft;
	if ($s =~ /^\s*(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s*$/) {
	    $fa = $1;
	    $fc = $2;
	    $fg = $3;
	    $ft = $4;
	}
	else { print "bad option for base frequencies $opt_b\n"; }
	print IN "F\n$fa $fc $fg $ft\n";
    }

    if    ($phylipmode == 1) { # branch opt only a la dnaml
	print IN "6\n";
    }
    elsif ($phylipmode == 2) { # branch opt only using cg
	print IN "6\n"; 
	print IN "B\n"; 
    }
    elsif ($phylipmode == 3) { # dnaml-erate option to optimize alpha y beta
	print IN "7\n"; 
    }
    print IN "Y\n";

    if ($opt_R) {
	my $s = $opt_R;
	my $a;
	my $b;
	if ($s =~ /^\s*(\S+)\s+(\S+)\s*$/) {
	    $a = $1;
	    $b = $2;
	}
	else { print "bad option for gamma distribution $opt_R\n"; }
	print IN "$a\n";
	print IN "$b\n";
    }
    close (IN);
    if ($verbose) {system ("more $phylipinputfile\n"); }

    # run PHYLIP
    # 
    my $cmd = "$phylipdir/$phylip < $phylipinputfile > $phylipscreenputfile";
    system("time -p $cmd\n"); 
    system("mv outfile $phylipoutputfile\n");
    system("mv outtree $phylipouttreefile\n");
    
    system ("more $phylipscreenputfile\n"); 
    system ("more $phylipoutputfile\n"); 

    if ($clean) {
	system("rm $phylipinputfile\n");
	system("rm $phylipscreenputfile\n");
	system("rm $phylipoutputfile\n");
	system("rm $phylipouttreefile\n");
    }
}
