/*
 * Decompiled with CFR 0.152.
 */
package forester.atv;

import forester.atv.ATVmouseListener;
import forester.atv.ATVnodeFrame;
import forester.atv.ATVpanel;
import forester.tree.Node;
import forester.tree.Tree;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.NumberFormat;
import javax.swing.JPanel;

class ATVgraphic
extends JPanel {
    Tree tree;
    ATVpanel atvpanel;
    boolean editable = false;
    boolean use_real_br_lenghts = true;
    boolean seq_name_internal_nodes = true;
    boolean species_internal_nodes = false;
    boolean ec_internal_nodes = false;
    boolean seq_name_ext_nodes = true;
    boolean species_ext_nodes = true;
    boolean ec_ext_nodes = false;
    boolean write_lnL_values = false;
    boolean write_br_length_values = false;
    boolean write_bootstrap_values = false;
    boolean write_dup_spec = false;
    boolean color_branches_acc_to_lnL = false;
    boolean draw_bl_of_seq_on_parent = false;
    boolean write_bl_of_seq_on_parent = false;
    static final int MAX_SUBTREES = 50;
    Tree[] trees = new Tree[50];
    int j;
    static final int BOX_SIZE = 6;
    static final int HALF_BOX_SIZE = 3;
    static final int MOVE = 30;
    int longest_ext_node_info;
    int x_current;
    int y_current;
    int x1;
    int y1;
    int x2;
    int y2;
    int factor;
    int xx;
    int xxd;
    int xxdd;
    int yyd;
    int green;
    int red;
    int x;
    double x_correction_factor;
    double x_distance;
    double y_distance;
    int action_when_node_clicked;
    static final int SHOW_INFO = 0;
    static final int COLLAPSE = 1;
    static final int REROOT = 3;
    static final int SUBTREE = 4;
    static final int SWAP = 5;
    final int MAX_NODEJFRAMES = 50;
    int i;
    ATVnodeFrame[] atvnodeframes = new ATVnodeFrame[50];
    boolean done;
    int color_scheme;
    Color ext_node_seq_name_color;
    Color int_node_seq_name_color;
    Color species_color;
    Color bootstrap_color;
    Color ec_color;
    Color dub_spec_color;
    Color lnL_color;
    Color branch_length_color;
    Color branch_color;
    Color box_color;
    Color branch_p_color;
    Color background_color;
    Color duplication_box_color;
    Font small_font;
    Font large_font;
    Font small_italic_font;
    Font large_italic_font;
    FontMetrics fm_small;
    FontMetrics fm_large;
    FontMetrics fm_small_italic;
    FontMetrics fm_large_italic;
    int small_maxDescent;
    int small_maxAscent;
    NumberFormat lnL_nf = NumberFormat.getNumberInstance();

    ATVgraphic() {
    }

    ATVgraphic(Tree tree, ATVpanel aTVpanel) {
        this.tree = tree;
        this.atvpanel = aTVpanel;
        this.color_scheme = 1;
        this.setColors1();
        this.mediumFonts();
        this.setBackground(this.background_color);
        this.calculateLongestExtNodeInfo();
        this.addMouseListener(new ATVmouseListener(this));
        this.lnL_nf.setMaximumFractionDigits(2);
        this.lnL_nf.setMinimumFractionDigits(2);
        if (this.tree != null && !this.tree.isEmpty()) {
            if (this.tree.getHighestLnL() != this.tree.getLowestLnL()) {
                this.setColorBranchesAccToLnL(true);
            }
            if (this.tree.getExtNode0() != null) {
                if (this.tree.getExtNode0().getDistanceToParent() == -99.0) {
                    this.setUseRealBranchLenghts(false);
                } else {
                    this.setUseRealBranchLenghts(true);
                }
                if (this.tree.getExtNode0().getParent() != null) {
                    if (this.tree.getExtNode0().getParent().getBootstrap() == -99) {
                        this.setWriteBootstrapValues(false);
                        return;
                    }
                    this.setWriteBootstrapValues(true);
                }
            }
        }
    }

    boolean ECExtNodes() {
        return this.ec_ext_nodes;
    }

    boolean ECInternalNodes() {
        return this.ec_internal_nodes;
    }

    public void MouseClicked(int n, int n2) {
        Node node = this.findNode(n, n2);
        if (node != null) {
            if (this.action_when_node_clicked == 1) {
                this.collapse(node);
                return;
            }
            if (this.action_when_node_clicked == 3) {
                this.reRoot(node);
                return;
            }
            if (this.action_when_node_clicked == 4) {
                this.subTree(node);
                return;
            }
            if (this.action_when_node_clicked == 5) {
                this.swap(node);
                return;
            }
            this.i = 0;
            while (this.atvnodeframes[this.i] != null) {
                ++this.i;
            }
            this.atvnodeframes[this.i] = new ATVnodeFrame(node, this, this.i);
        }
    }

    void calculateLongestExtNodeInfo() {
        if (this.tree == null || this.tree.isEmpty()) {
            return;
        }
        int n = 0;
        int n2 = 0;
        Node node = this.tree.getExtNode0();
        while (node != null) {
            n2 = this.fm_large_italic.stringWidth(String.valueOf(node.getSpecies()) + " ") + this.fm_large.stringWidth(String.valueOf(node.getSeqName()) + " ") + this.fm_large.stringWidth(node.getECnumber());
            node = node.getNextExtNode();
            if (n2 > n) {
                n = n2;
            }
            n2 = 0;
        }
        this.setLongestExtNodeInfo(n);
    }

    void collapse(Node node) {
        if (!node.isExternal()) {
            node.setCollapse(!node.collapse());
            this.tree.adjustNodeCount();
            this.tree.recalculateAndReset();
            this.resetPreferredSize();
            this.atvpanel.adjustJScrollPane();
            this.repaint();
        }
    }

    boolean colorBranchesAccToLnL() {
        return this.color_branches_acc_to_lnL;
    }

    boolean drawBlOfSeqOnParent() {
        return this.draw_bl_of_seq_on_parent;
    }

    void drawBranchOfSeqOnParent(Node node, Graphics graphics) {
        if (!this.colorBranchesAccToLnL()) {
            graphics.setColor(this.branch_p_color);
        }
        this.xx = (this.x1 + this.x2) / 2;
        this.xxd = (int)((double)((this.x1 + this.x2) / 2) + this.y_distance * 0.7000000000000001);
        this.yyd = (int)((double)this.y2 - this.y_distance * 0.7000000000000001);
        this.xxdd = this.xxd + (int)(node.getBlOfSeqOnParentBranch() * this.x_correction_factor);
        graphics.drawLine(this.xx, this.y2, this.xxd, this.yyd);
        graphics.drawLine(this.xxd, this.yyd, this.xxdd, this.yyd);
        graphics.drawLine(this.xxdd + 2, this.yyd - 2, this.xxdd - 2, this.yyd + 2);
    }

    void drawCollapsedNode(int n, int n2, Graphics graphics, Node node) {
        int n3 = 0;
        graphics.setColor(this.branch_color);
        graphics.drawRect(n - 3, n2 - 3, 6, 6);
        graphics.setColor(this.background_color);
        graphics.fillRect(n - 3 + 1, n2 - 3 + 1, 4, 4);
        if (this.speciesExtNodes() && !node.getSpecies().equals("")) {
            graphics.setFont(this.large_italic_font);
            graphics.setColor(this.species_color);
            graphics.drawString(String.valueOf(node.getSpecies()) + ": ", n + 3 + 3, n2 + this.fm_large_italic.getAscent() / 2);
            n3 = this.fm_large_italic.stringWidth(String.valueOf(node.getSpecies()) + ": ");
        }
        if (this.seqNameExtNodes() && !node.getSeqName().equals("")) {
            graphics.setFont(this.large_font);
            graphics.setColor(this.int_node_seq_name_color);
            graphics.drawString(String.valueOf(node.getSeqName()) + ": ", n + 3 + 3 + n3, n2 + this.fm_large.getAscent() / 2);
            n3 += this.fm_large.stringWidth(String.valueOf(node.getSeqName()) + ": ");
        }
        graphics.setColor(this.branch_color);
        graphics.setFont(this.large_font);
        graphics.drawString("collapsed", n + n3 + 3 + 3, n2 + this.fm_large.getAscent() / 2);
    }

    Node findNode(int n, int n2) {
        if (this.tree == null || this.tree.isEmpty()) {
            return null;
        }
        Node node = this.tree.getExtNode0();
        while (node != null) {
            Node node2 = node;
            while (node2 != null) {
                if (!(node2.isPseudoNode() || !this.tree.isRooted() && node2.isRoot() || node2.getXcoord() - 3 > n || node2.getXcoord() + 3 < n || node2.getYcoord() - 3 > n2 || node2.getYcoord() + 3 < n2)) {
                    return node2;
                }
                node2 = node2.getParent();
            }
            node = node.getNextExtNode();
        }
        return null;
    }

    ATVpanel getATVpanel() {
        return this.atvpanel;
    }

    int getActionWhenNodeClicked() {
        return this.action_when_node_clicked;
    }

    int getLengthOfRootSpecies() {
        if (this.tree == null || this.tree.isEmpty()) {
            return 0;
        }
        return this.fm_small_italic.stringWidth(this.tree.getRoot().getSpecies());
    }

    int getLongestExtNodeInfo() {
        return this.longest_ext_node_info;
    }

    Tree getTree() {
        return this.tree;
    }

    double getXcorrectionFactor() {
        return this.x_correction_factor;
    }

    double getXdistance() {
        return this.x_distance;
    }

    double getYdistance() {
        return this.y_distance;
    }

    boolean isEditable() {
        return this.editable;
    }

    void largeFonts() {
        this.small_font = new Font("Helvetica", 0, 13);
        this.large_font = new Font("Helvetica", 0, 13);
        this.small_italic_font = new Font("Helvetica", 2, 13);
        this.large_italic_font = new Font("Helvetica", 2, 13);
        this.fm_small = ((Component)this).getFontMetrics(this.small_font);
        this.fm_large = ((Component)this).getFontMetrics(this.large_font);
        this.fm_small_italic = ((Component)this).getFontMetrics(this.small_italic_font);
        this.fm_large_italic = ((Component)this).getFontMetrics(this.large_italic_font);
        this.small_maxDescent = this.fm_small.getMaxDescent();
        this.small_maxAscent = this.fm_small.getMaxAscent() + 2;
    }

    void mediumFonts() {
        this.small_font = new Font("Helvetica", 0, 10);
        this.large_font = new Font("Helvetica", 0, 11);
        this.small_italic_font = new Font("Helvetica", 2, 10);
        this.large_italic_font = new Font("Helvetica", 2, 11);
        this.fm_small = ((Component)this).getFontMetrics(this.small_font);
        this.fm_large = ((Component)this).getFontMetrics(this.large_font);
        this.fm_small_italic = ((Component)this).getFontMetrics(this.small_italic_font);
        this.fm_large_italic = ((Component)this).getFontMetrics(this.large_italic_font);
        this.small_maxDescent = this.fm_small.getMaxDescent();
        this.small_maxAscent = this.fm_small.getMaxAscent() + 2;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.tree == null || this.tree.isEmpty()) {
            return;
        }
        this.done = false;
        Node node = this.tree.getRoot();
        this.tree.setIndicatorsToZero();
        this.x_current = !this.tree.isRooted() ? 30 : (this.tree.getRoot().getDistanceToParent() > 0.0 && this.useRealBranchLenghts() ? (int)(this.tree.getRoot().getDistanceToParent() * this.x_correction_factor + 30.0) : (int)(this.getXdistance() + 30.0));
        this.y_current = (int)(this.getYdistance() * (double)this.tree.getNumberOfExtNodes() + 15.0);
        this.setBackground(this.background_color);
        do {
            if (!node.isPseudoNode()) {
                if (this.writeBranchLengthValues() && node.getIndicator() == 0 && node.getDistanceToParent() >= 0.0) {
                    graphics.setFont(this.small_font);
                    graphics.setColor(this.branch_length_color);
                    if (!node.isRoot()) {
                        graphics.drawString(Double.toString(node.getDistanceToParent()), node.getParent().getXcoord() + 3, this.y_current - this.small_maxDescent);
                    } else {
                        graphics.drawString(Double.toString(node.getDistanceToParent()), 3, this.y_current - this.small_maxDescent);
                    }
                }
                if (this.writeLnLValues() && node.getIndicator() == 0 && node.isLnLonParentBranchAssigned()) {
                    graphics.setFont(this.small_font);
                    graphics.setColor(this.lnL_color);
                    if (!node.isRoot()) {
                        graphics.drawString(String.valueOf(this.lnL_nf.format(this.tree.getHighestLnL() - node.getLnLonParentBranch())) + " (" + this.lnL_nf.format(node.getLnLonParentBranch()) + ")", node.getParent().getXcoord() + 3, this.y_current + this.small_maxAscent);
                    } else if (this.tree.getNumberOfExtNodes() >= 2) {
                        graphics.drawString(String.valueOf(this.lnL_nf.format(this.tree.getHighestLnL() - node.getLnLonParentBranch())) + " (" + this.lnL_nf.format(node.getLnLonParentBranch()) + ")", 3, this.y_current + this.small_maxAscent);
                    } else {
                        graphics.drawString(" (" + this.lnL_nf.format(node.getLnLonParentBranch()) + ")", 3, this.y_current + this.small_maxAscent);
                    }
                }
                if (this.writeBootstrapValues() && node.getIndicator() == 0 && node.getBootstrap() > 0 && this.tree.getNumberOfExtNodes() >= 2 && !node.collapse()) {
                    graphics.setFont(this.small_font);
                    graphics.setColor(this.bootstrap_color);
                    graphics.drawString(Integer.toString(node.getBootstrap()), this.x_current - this.fm_small.stringWidth(Integer.toString(node.getBootstrap())) - 2 - 3, this.y_current + this.small_maxAscent - 1);
                }
            }
            if (node.isRoot() && this.tree.isRooted() && node.getIndicator() == 0) {
                if (!this.colorBranchesAccToLnL() || !node.isLnLonParentBranchAssigned()) {
                    graphics.setColor(this.branch_color);
                } else {
                    this.green = (int)((node.getLnLonParentBranch() - this.tree.getLowestLnL()) * 254.0 / Math.abs(this.tree.getHighestLnL() - this.tree.getLowestLnL()));
                    this.red = 255 - this.green;
                    graphics.setColor(new Color(this.red, this.green, 0));
                }
                if (this.useRealBranchLenghts() && this.tree.getRoot().getDistanceToParent() > 0.0) {
                    graphics.drawLine(this.x_current, this.y_current, this.x_current - (int)(this.x_correction_factor * this.tree.getRoot().getDistanceToParent()), this.y_current);
                } else {
                    graphics.drawLine(this.x_current, this.y_current, (int)((double)this.x_current - this.x_distance), this.y_current);
                    if (this.colorBranchesAccToLnL() && !node.significantlyWorse()) {
                        graphics.drawLine(this.x_current, this.y_current - 1, (int)((double)this.x_current - this.x_distance), this.y_current - 1);
                        graphics.drawLine(this.x_current, this.y_current + 1, (int)((double)this.x_current - this.x_distance), this.y_current + 1);
                    }
                }
                if (!node.collapse()) {
                    if (!this.writeDupSpec() && node.isDuplicationOrSpecAssigned() && node.isDuplication()) {
                        graphics.setColor(this.duplication_box_color);
                    } else {
                        graphics.setColor(this.box_color);
                    }
                    graphics.fillRect(this.x_current - 3, this.y_current - 3, 6, 6);
                } else {
                    this.drawCollapsedNode(this.x_current, this.y_current, graphics, node);
                }
            }
            if (node.getIndicator() == 0 && !node.isExternal()) {
                this.factor = node.getSumExtNodes() - node.getChild1().getSumExtNodes();
                this.x1 = this.x_current;
                node.setXcoord(this.x1);
                this.y1 = this.y_current;
                node.setYcoord(this.y1);
                this.y2 = (int)((double)this.y_current - this.y_distance * (double)this.factor);
                if (!node.isPseudoNode()) {
                    if (this.speciesInternalNodes() && !node.collapse() && !node.getSpecies().equals("")) {
                        graphics.setFont(this.small_italic_font);
                        graphics.setColor(this.species_color);
                        graphics.drawString(node.getSpecies(), this.x_current + 3 + 3, this.y_current + this.fm_small_italic.getAscent() / 2);
                    }
                    if (this.seqNameInternalNodes() && !node.getSeqName().equals("") && !node.collapse()) {
                        graphics.setColor(this.int_node_seq_name_color);
                        graphics.setFont(this.large_font);
                        graphics.drawString(node.getSeqName(), this.x_current - this.fm_large.stringWidth(node.getSeqName()) - 3 - 3, this.y_current - this.fm_large.getMaxDescent());
                    }
                    if (this.ECInternalNodes() && !node.getECnumber().equals("") && !node.collapse()) {
                        graphics.setColor(this.ec_color);
                        graphics.setFont(this.large_font);
                        this.x = this.seqNameInternalNodes() && !node.getSeqName().equals("") ? this.fm_large.stringWidth(String.valueOf(node.getSeqName()) + " ") : 0;
                        graphics.drawString(node.getECnumber(), this.x_current - this.x - this.fm_large.stringWidth(node.getECnumber()) - 4 - 3, this.y_current - this.fm_large.getMaxDescent());
                    }
                    if (this.writeDupSpec() && node.isDuplicationOrSpecAssigned() && !node.collapse()) {
                        graphics.setColor(this.dub_spec_color);
                        graphics.setFont(this.large_font);
                        this.x = this.speciesInternalNodes() ? this.fm_large.getMaxAscent() : 0;
                        if (node.isDuplication()) {
                            graphics.drawString("D", this.x_current + 3 + 3, this.y_current + this.fm_large.getAscent() / 2 + this.x);
                        } else {
                            graphics.drawString("S", this.x_current + 3 + 3, this.y_current + this.fm_large.getAscent() / 2 + this.x);
                        }
                    }
                }
                if (!node.collapse()) {
                    this.x2 = this.useRealBranchLenghts() ? this.x_current + (int)(this.x_correction_factor * (node.getChild1().getDistanceToParent() >= 0.0 ? node.getChild1().getDistanceToParent() : 0.0)) : (node.getChild1().isPseudoNode() ? this.x_current : (node.getChild1().isExternal() ? (int)(this.getXdistance() + 30.0 + this.x_distance * (double)this.tree.getMostBranchesPerExtNode()) : (int)((double)this.x_current + this.x_distance * (double)this.factor)));
                    graphics.setColor(this.branch_color);
                    if (!(node.isPseudoNode() || node.isRoot() && !this.tree.isRooted())) {
                        graphics.drawLine(this.x1, this.y1 - 3, this.x1, this.y2);
                    } else {
                        graphics.drawLine(this.x1, this.y1, this.x1, this.y2);
                    }
                    if (!this.colorBranchesAccToLnL() || !node.getChild1().isLnLonParentBranchAssigned() || this.tree.getHighestLnL() == this.tree.getLowestLnL()) {
                        graphics.setColor(this.branch_color);
                        graphics.drawLine(this.x1, this.y2, this.x2, this.y2);
                    } else {
                        this.green = (int)((node.getChild1().getLnLonParentBranch() - this.tree.getLowestLnL()) * 254.0 / Math.abs(this.tree.getHighestLnL() - this.tree.getLowestLnL()));
                        this.red = 255 - this.green;
                        graphics.setColor(new Color(this.red, this.green, 0));
                        graphics.drawLine(this.x1, this.y2, this.x2, this.y2);
                        if (!node.getChild1().significantlyWorse()) {
                            graphics.drawLine(this.x1, this.y2 - 1, this.x2, this.y2 - 1);
                            graphics.drawLine(this.x1, this.y2 + 1, this.x2, this.y2 + 1);
                        }
                    }
                    if (this.drawBlOfSeqOnParent() && node.getChild1().getBlOfSeqOnParentBranch() >= 0.0) {
                        this.drawBranchOfSeqOnParent(node.getChild1(), graphics);
                    }
                    if (this.writeBlOfSeqOnParent() && node.getChild1().getBlOfSeqOnParentBranch() >= 0.0) {
                        this.writeBranchLengthOfSeqOnParent(node.getChild1(), graphics);
                    }
                    if (!node.getChild1().isPseudoNode()) {
                        if (!node.getChild1().collapse()) {
                            if (!this.writeDupSpec() && node.getChild1().isDuplicationOrSpecAssigned() && node.getChild1().isDuplication()) {
                                graphics.setColor(this.duplication_box_color);
                            } else {
                                graphics.setColor(this.box_color);
                            }
                            graphics.fillRect(this.x2 - 3, this.y2 - 3, 6, 6);
                        } else {
                            this.drawCollapsedNode(this.x2, this.y2, graphics, node.getChild1());
                        }
                    }
                    this.x_current = this.x2;
                    this.y_current = this.y2;
                    node.setIndicator(1);
                    node = node.getChild1();
                } else {
                    node.setIndicator(1);
                }
            }
            if (node.getIndicator() == 1 && !node.isExternal()) {
                if (!node.collapse()) {
                    this.factor = node.getSumExtNodes() - node.getChild2().getSumExtNodes();
                    this.x1 = this.x_current;
                    this.y1 = this.y_current;
                    this.y2 = (int)((double)this.y_current + this.y_distance * (double)this.factor);
                    this.x2 = this.useRealBranchLenghts() ? (int)((double)this.x_current + this.x_correction_factor * (node.getChild2().getDistanceToParent() >= 0.0 ? node.getChild2().getDistanceToParent() : 0.0)) : (node.getChild2().isPseudoNode() ? this.x_current : (node.getChild2().isExternal() ? (int)(this.getXdistance() + 30.0 + this.x_distance * (double)this.tree.getMostBranchesPerExtNode()) : (int)((double)this.x_current + this.x_distance * (double)this.factor)));
                    graphics.setColor(this.branch_color);
                    if (!(node.isPseudoNode() || node.isRoot() && !this.tree.isRooted())) {
                        graphics.drawLine(this.x1, this.y1 + 3, this.x1, this.y2);
                    } else {
                        graphics.drawLine(this.x1, this.y1, this.x1, this.y2);
                    }
                    if (!this.colorBranchesAccToLnL() || !node.getChild2().isLnLonParentBranchAssigned() || this.tree.getHighestLnL() == this.tree.getLowestLnL()) {
                        graphics.setColor(this.branch_color);
                        graphics.drawLine(this.x1, this.y2, this.x2, this.y2);
                    } else {
                        this.green = (int)((node.getChild2().getLnLonParentBranch() - this.tree.getLowestLnL()) * 254.0 / Math.abs(this.tree.getHighestLnL() - this.tree.getLowestLnL()));
                        this.red = 255 - this.green;
                        graphics.setColor(new Color(this.red, this.green, 0));
                        graphics.drawLine(this.x1, this.y2, this.x2, this.y2);
                        if (!node.getChild2().significantlyWorse()) {
                            graphics.drawLine(this.x1, this.y2 - 1, this.x2, this.y2 - 1);
                            graphics.drawLine(this.x1, this.y2 + 1, this.x2, this.y2 + 1);
                        }
                    }
                    if (this.drawBlOfSeqOnParent() && node.getChild2().getBlOfSeqOnParentBranch() >= 0.0) {
                        this.drawBranchOfSeqOnParent(node.getChild2(), graphics);
                    }
                    if (this.writeBlOfSeqOnParent() && node.getChild2().getBlOfSeqOnParentBranch() >= 0.0) {
                        this.writeBranchLengthOfSeqOnParent(node.getChild2(), graphics);
                    }
                    if (!node.getChild2().isPseudoNode()) {
                        if (!node.getChild2().collapse()) {
                            if (!this.writeDupSpec() && node.getChild2().isDuplicationOrSpecAssigned() && node.getChild2().isDuplication()) {
                                graphics.setColor(this.duplication_box_color);
                            } else {
                                graphics.setColor(this.box_color);
                            }
                            graphics.fillRect(this.x2 - 3, this.y2 - 3, 6, 6);
                        } else {
                            this.drawCollapsedNode(this.x2, this.y2, graphics, node.getChild2());
                        }
                    }
                    this.x_current = this.x2;
                    this.y_current = this.y2;
                    node.setIndicator(2);
                    node = node.getChild2();
                } else {
                    node.setIndicator(2);
                }
            }
            if (node.isRoot()) {
                this.done = true;
            } else if (node.getIndicator() == 2 && !node.isExternal()) {
                node = node.getParent();
                this.x_current = node.getXcoord();
                this.y_current = node.getYcoord();
            }
            if (!node.isExternal()) continue;
            if (this.speciesExtNodes() && !node.getSpecies().equals("")) {
                graphics.setFont(this.large_italic_font);
                graphics.setColor(this.species_color);
                graphics.drawString(String.valueOf(node.getSpecies()) + " ", this.x_current + 3 + 3, this.y_current + this.fm_large.getAscent() / 2);
            }
            if (this.seqNameExtNodes() && !node.getSeqName().equals("")) {
                graphics.setFont(this.large_font);
                graphics.setColor(this.ext_node_seq_name_color);
                this.x = this.speciesExtNodes() && !node.getSpecies().equals("") ? this.fm_large_italic.stringWidth(String.valueOf(node.getSpecies()) + " ") : 0;
                graphics.drawString(node.getSeqName(), this.x_current + this.x + 3 + 3, this.y_current + this.fm_large.getAscent() / 2);
            }
            if (this.ECExtNodes() && !node.getECnumber().equals("")) {
                graphics.setFont(this.large_font);
                graphics.setColor(this.ec_color);
                this.x = this.speciesExtNodes() && !node.getSpecies().equals("") ? this.fm_large_italic.stringWidth(String.valueOf(node.getSpecies()) + " ") : 0;
                if (this.seqNameExtNodes() && !node.getSeqName().equals("")) {
                    this.x += this.fm_large.stringWidth(String.valueOf(node.getSeqName()) + " ");
                }
                graphics.drawString(node.getECnumber(), this.x_current + this.x + 3 + 3, this.y_current + this.fm_large.getAscent() / 2);
            }
            if (this.writeBranchLengthValues() && !node.isRoot() && node.getDistanceToParent() >= 0.0) {
                graphics.setFont(this.small_font);
                graphics.setColor(this.branch_length_color);
                graphics.drawString(Double.toString(node.getDistanceToParent()), node.getParent().getXcoord() + 3, this.y_current - this.small_maxDescent);
            }
            if (this.writeLnLValues() && !node.isRoot() && node.isLnLonParentBranchAssigned()) {
                graphics.setFont(this.small_font);
                graphics.setColor(this.lnL_color);
                graphics.drawString(String.valueOf(this.lnL_nf.format(this.tree.getHighestLnL() - node.getLnLonParentBranch())) + " (" + this.lnL_nf.format(node.getLnLonParentBranch()) + ")", node.getParent().getXcoord() + 3, this.y_current + this.small_maxAscent);
            }
            node.setXcoord(this.x_current);
            node.setYcoord(this.y_current);
            if (node.getNextExtNode() == null) {
                this.done = true;
            }
            if (!node.isRoot()) {
                node = node.getParent();
            }
            this.x_current = node.getXcoord();
            this.y_current = node.getYcoord();
        } while (!this.done);
        this.tree.setIndicatorsToZero();
    }

    void reRoot(Node node) {
        try {
            this.tree.reRoot(node);
            this.tree.adjustNodeCount();
            this.tree.recalculateAndReset();
        }
        catch (Exception exception) {
            System.err.println("ATVgraphic: reRoot( node ): " + exception);
        }
        this.resetPreferredSize();
        this.atvpanel.adjustJScrollPane();
        this.repaint();
    }

    void removeAllNodeJFrames() {
        this.i = 0;
        while (this.i <= 49) {
            if (this.atvnodeframes[this.i] != null) {
                this.atvnodeframes[this.i].dispose();
                this.atvnodeframes[this.i] = null;
            }
            ++this.i;
        }
        this.i = 0;
    }

    void removeNodeJFrame(int n) {
        this.atvnodeframes[n] = null;
    }

    void removeRoot() {
        if (this.tree == null) {
            return;
        }
        if (this.tree.isEmpty()) {
            return;
        }
        this.tree.unRoot();
        this.repaint();
    }

    void removeRootTri() {
        if (this.tree == null) {
            return;
        }
        if (this.tree.isEmpty()) {
            return;
        }
        this.tree.unRootAndTrifurcate();
        this.repaint();
    }

    void resetPreferredSize() {
        if (this.tree == null || this.tree.isEmpty()) {
            return;
        }
        int n = 0;
        int n2 = (int)(30.0 + this.getYdistance() * (double)(this.tree.getNumberOfExtNodes() * 2));
        n = this.useRealBranchLenghts() ? (int)(this.getXcorrectionFactor() * this.tree.getLongestDistance() + (double)this.getLongestExtNodeInfo() + 30.0 + this.getXdistance() + (double)this.getLengthOfRootSpecies()) : (int)(this.getXdistance() * (double)(this.tree.getMostBranchesPerExtNode() + 1) + (double)this.getLongestExtNodeInfo() + 30.0 + (double)this.getLengthOfRootSpecies());
        this.setPreferredSize(new Dimension(n, n2));
    }

    boolean seqNameExtNodes() {
        return this.seq_name_ext_nodes;
    }

    boolean seqNameInternalNodes() {
        return this.seq_name_internal_nodes;
    }

    void setActionWhenNodeClicked(int n) {
        this.action_when_node_clicked = n;
    }

    void setColorBranchesAccToLnL(boolean bl) {
        this.color_branches_acc_to_lnL = bl;
    }

    void setColors1() {
        this.ext_node_seq_name_color = new Color(0, 0, 0);
        this.int_node_seq_name_color = new Color(255, 0, 0);
        this.species_color = new Color(40, 40, 40);
        this.bootstrap_color = new Color(0, 125, 0);
        this.ec_color = new Color(255, 100, 0);
        this.dub_spec_color = new Color(255, 0, 0);
        this.lnL_color = new Color(40, 40, 40);
        this.branch_length_color = new Color(70, 70, 0);
        this.branch_color = new Color(0, 20, 200);
        this.box_color = new Color(0, 20, 200);
        this.branch_p_color = new Color(140, 140, 140);
        this.background_color = new Color(250, 250, 250);
        this.duplication_box_color = new Color(255, 0, 0);
    }

    void setColors2() {
        this.ext_node_seq_name_color = new Color(0, 0, 0);
        this.int_node_seq_name_color = new Color(0, 0, 0);
        this.species_color = new Color(0, 0, 150);
        this.bootstrap_color = new Color(0, 0, 0);
        this.ec_color = new Color(150, 0, 0);
        this.dub_spec_color = new Color(150, 0, 150);
        this.lnL_color = new Color(255, 255, 255);
        this.branch_length_color = new Color(150, 0, 0);
        this.branch_color = new Color(255, 255, 0);
        this.box_color = new Color(255, 255, 0);
        this.branch_p_color = new Color(255, 100, 0);
        this.background_color = new Color(180, 180, 180);
        this.duplication_box_color = new Color(255, 0, 0);
    }

    void setColors3() {
        this.ext_node_seq_name_color = new Color(0, 0, 0);
        this.int_node_seq_name_color = new Color(0, 0, 0);
        this.species_color = new Color(50, 50, 50);
        this.bootstrap_color = new Color(100, 100, 100);
        this.ec_color = new Color(0, 0, 0);
        this.dub_spec_color = new Color(0, 0, 0);
        this.lnL_color = new Color(100, 100, 100);
        this.branch_length_color = new Color(50, 50, 50);
        this.branch_color = new Color(0, 0, 0);
        this.box_color = new Color(0, 0, 0);
        this.branch_p_color = new Color(100, 100, 100);
        this.background_color = new Color(255, 255, 255);
        this.duplication_box_color = new Color(255, 0, 0);
    }

    void setColors4() {
        this.ext_node_seq_name_color = new Color(255, 255, 255);
        this.int_node_seq_name_color = new Color(255, 255, 255);
        this.species_color = new Color(200, 200, 200);
        this.bootstrap_color = new Color(255, 255, 255);
        this.ec_color = new Color(200, 200, 200);
        this.dub_spec_color = new Color(255, 255, 255);
        this.lnL_color = new Color(200, 200, 200);
        this.branch_length_color = new Color(200, 200, 200);
        this.branch_color = new Color(0, 255, 255);
        this.box_color = new Color(0, 255, 255);
        this.branch_p_color = new Color(200, 200, 200);
        this.background_color = new Color(0, 0, 70);
        this.duplication_box_color = new Color(255, 0, 0);
    }

    void setDrawBlOfSeqOnParent(boolean bl) {
        this.draw_bl_of_seq_on_parent = bl;
    }

    void setECExtNodes(boolean bl) {
        this.ec_ext_nodes = bl;
    }

    void setECInternalNodes(boolean bl) {
        this.ec_internal_nodes = bl;
    }

    void setEditable(boolean bl) {
        this.editable = bl;
    }

    void setLongestExtNodeInfo(int n) {
        this.longest_ext_node_info = n;
    }

    void setParametersForPainting(int n, int n2) {
        if (this.tree != null && !this.tree.isEmpty()) {
            double d = (double)(n - this.getLongestExtNodeInfo() - 30 - this.getLengthOfRootSpecies()) / (double)(this.tree.getMostBranchesPerExtNode() + 1);
            double d2 = (double)(n2 - 30) / (double)(this.tree.getNumberOfExtNodes() * 2);
            if (d < 0.0) {
                d = 0.0;
            }
            if (d2 < 0.0) {
                d2 = 0.0;
            }
            if (d2 > 2.0) {
                d2 = (int)d2;
            }
            this.setXdistance(d);
            this.setYdistance(d2);
            if (this.tree.getLongestDistance() > 0.0) {
                double d3 = ((double)(n - this.getLongestExtNodeInfo() - 30) - this.getXdistance() - (double)this.getLengthOfRootSpecies()) / this.tree.getLongestDistance();
                if (d3 < 0.0) {
                    d3 = 0.0;
                }
                this.setXcorrectionFactor(d3);
                return;
            }
            this.setXcorrectionFactor(0.0);
        }
    }

    void setSeqNameExtNodes(boolean bl) {
        this.seq_name_ext_nodes = bl;
    }

    void setSeqNameInternalNodes(boolean bl) {
        this.seq_name_internal_nodes = bl;
    }

    void setSpeciesExtNodes(boolean bl) {
        this.species_ext_nodes = bl;
    }

    void setSpeciesInternalNodes(boolean bl) {
        this.species_internal_nodes = bl;
    }

    void setTree(Tree tree) {
        this.tree = tree;
    }

    void setUseRealBranchLenghts(boolean bl) {
        this.use_real_br_lenghts = bl;
    }

    void setWriteBlOfSeqOnParent(boolean bl) {
        this.write_bl_of_seq_on_parent = bl;
    }

    void setWriteBootstrapValues(boolean bl) {
        this.write_bootstrap_values = bl;
    }

    void setWriteBranchLengthValues(boolean bl) {
        this.write_br_length_values = bl;
    }

    void setWriteDupSpec(boolean bl) {
        this.write_dup_spec = bl;
    }

    void setWriteLnLValues(boolean bl) {
        this.write_lnL_values = bl;
    }

    void setXcorrectionFactor(double d) {
        this.x_correction_factor = d;
    }

    void setXdistance(double d) {
        this.x_distance = d;
    }

    void setYdistance(double d) {
        this.y_distance = d;
    }

    void smallFonts() {
        this.small_font = new Font("Helvetica", 0, 10);
        this.large_font = new Font("Helvetica", 0, 10);
        this.small_italic_font = new Font("Helvetica", 2, 10);
        this.large_italic_font = new Font("Helvetica", 2, 10);
        this.fm_small = ((Component)this).getFontMetrics(this.small_font);
        this.fm_large = ((Component)this).getFontMetrics(this.large_font);
        this.fm_small_italic = ((Component)this).getFontMetrics(this.small_italic_font);
        this.fm_large_italic = ((Component)this).getFontMetrics(this.large_italic_font);
        this.small_maxDescent = this.fm_small.getMaxDescent();
        this.small_maxAscent = this.fm_small.getMaxAscent() + 1;
    }

    boolean speciesExtNodes() {
        return this.species_ext_nodes;
    }

    boolean speciesInternalNodes() {
        return this.species_internal_nodes;
    }

    void subTree(Node node) {
        if (!node.isExternal() && !node.isRoot() && this.j <= 49) {
            try {
                this.trees[this.j++] = this.tree;
                this.tree = this.tree.subTree(node.getID());
            }
            catch (Exception exception) {
                System.err.println("ATVgraphic: subTree( Node ): " + exception);
            }
        } else if (node.isRoot() && this.j >= 1) {
            try {
                this.trees[this.j] = null;
                this.tree = this.trees[--this.j];
            }
            catch (Exception exception) {
                System.err.println("ATVgraphic: subTree( Node ): " + exception);
            }
        }
        this.atvpanel.getATVcontrol().setCheckBoxes();
        this.atvpanel.getATVcontrol().showWhole();
    }

    void swap(Node node) {
        if (!node.isExternal()) {
            this.tree.swapChildren(node);
        }
        this.repaint();
    }

    void switchColors() {
        switch (this.color_scheme) {
            case 1: {
                this.color_scheme = 2;
                this.setColors2();
                break;
            }
            case 2: {
                this.color_scheme = 3;
                this.setColors3();
                break;
            }
            case 3: {
                this.color_scheme = 4;
                this.setColors4();
                break;
            }
            case 4: {
                this.color_scheme = 1;
                this.setColors1();
            }
        }
        this.repaint();
    }

    void tinyFonts() {
        this.small_font = new Font("Helvetica", 0, 8);
        this.large_font = new Font("Helvetica", 0, 8);
        this.small_italic_font = new Font("Helvetica", 2, 8);
        this.large_italic_font = new Font("Helvetica", 2, 8);
        this.fm_small = ((Component)this).getFontMetrics(this.small_font);
        this.fm_large = ((Component)this).getFontMetrics(this.large_font);
        this.fm_small_italic = ((Component)this).getFontMetrics(this.small_italic_font);
        this.fm_large_italic = ((Component)this).getFontMetrics(this.large_italic_font);
        this.small_maxDescent = this.fm_small.getMaxDescent();
        this.small_maxAscent = this.fm_small.getMaxAscent() + 1;
    }

    boolean useRealBranchLenghts() {
        return this.use_real_br_lenghts;
    }

    boolean writeBlOfSeqOnParent() {
        return this.write_bl_of_seq_on_parent;
    }

    boolean writeBootstrapValues() {
        return this.write_bootstrap_values;
    }

    void writeBranchLengthOfSeqOnParent(Node node, Graphics graphics) {
        graphics.setFont(this.small_font);
        graphics.setColor(this.branch_p_color);
        graphics.drawString(Double.toString(node.getBlOfSeqOnParentBranch()), (this.x1 + this.x2) / 2, this.y2 + this.small_maxAscent);
    }

    boolean writeBranchLengthValues() {
        return this.write_br_length_values;
    }

    boolean writeDupSpec() {
        return this.write_dup_spec;
    }

    boolean writeLnLValues() {
        return this.write_lnL_values;
    }
}

