/*
 * Decompiled with CFR 0.152.
 */
package forester.atv;

import forester.atv.ATVpanel;
import forester.atv.ATVprinter;
import forester.atv.ATVtextframe;
import forester.atv.NHFilter;
import forester.atv.NHXFilter;
import forester.tree.Tree;
import forester.tree.TreeHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSlider;

public class ATVjframe
extends JFrame
implements ActionListener {
    private File treefile;
    private JMenuBar jmenubar;
    private JMenu file_jmenu;
    private JMenu edit_jmenu;
    private JMenu view_jmenu;
    private JMenu options_jmenu;
    private JMenu help_jmenu;
    private JMenu print_size_jmenu;
    private JMenuItem open_item;
    private JMenuItem open_url_item;
    private JMenuItem save_item;
    private JMenuItem saveas_item;
    private JMenuItem print_item;
    private JMenuItem close_item;
    private JMenuItem exit_item;
    private JMenuItem remove_root_item;
    private JMenuItem remove_root_tri_item;
    private JMenuItem tiny_fonts_item;
    private JMenuItem small_fonts_item;
    private JMenuItem medium_fonts_item;
    private JMenuItem large_fonts_item;
    private JMenuItem switch_colors_item;
    private JMenuItem view_as_NH_item;
    private JMenuItem view_as_NHX_item;
    private JMenuItem about_item;
    private JMenuItem help_item;
    private ATVpanel atvpanel;
    private Container contentpane;
    private ATVtextframe atvtextframe = null;
    private JFileChooser open_jfilechooser;
    private JFileChooser saveas_jfilechooser;
    private JSlider x_slider;
    private JSlider y_slider;
    private JLabel xs_label;
    private JLabel ys_label;
    private JCheckBox print_in_color;
    private static final int SLIDER_MIN = 0;
    private static final int SLIDER_MAX = 200;
    private static final int SLIDER_VAL = 100;
    private static final int SLIDER_MAJS = 50;
    private static final int SLIDER_MINS = 10;
    private static final Color menu_background_color = new Color(215, 215, 215);
    private static final Color menu_text_color = new Color(0, 0, 0);
    private static final Font menu_font = new Font("Helvetica", 0, 10);
    private static final int FRAME_X_SIZE = 640;
    private static final int FRAME_Y_SIZE = 580;
    private static final int PRINT_X_SIZE = 380;
    private static final int PRINT_Y_SIZE = 700;
    private static final NHXFilter nhxfilter = new NHXFilter();
    private static final NHFilter nhfilter = new NHFilter();

    public ATVjframe(Tree tree) {
        this.setTitle("ATV");
        this.open_jfilechooser = new JFileChooser();
        this.open_jfilechooser.setCurrentDirectory(new File("."));
        this.open_jfilechooser.setMultiSelectionEnabled(false);
        this.open_jfilechooser.setFileFilter(nhxfilter);
        this.open_jfilechooser.addChoosableFileFilter(nhfilter);
        this.open_jfilechooser.addChoosableFileFilter(this.open_jfilechooser.getAcceptAllFileFilter());
        this.saveas_jfilechooser = new JFileChooser();
        this.saveas_jfilechooser.setCurrentDirectory(new File("."));
        this.saveas_jfilechooser.setMultiSelectionEnabled(false);
        this.saveas_jfilechooser.setFileFilter(nhxfilter);
        this.saveas_jfilechooser.addChoosableFileFilter(nhfilter);
        this.saveas_jfilechooser.addChoosableFileFilter(this.saveas_jfilechooser.getAcceptAllFileFilter());
        this.atvpanel = new ATVpanel(tree);
        this.jmenubar = new JMenuBar();
        this.jmenubar.setBackground(menu_background_color);
        this.file_jmenu = new JMenu("File");
        this.edit_jmenu = new JMenu("Edit");
        this.view_jmenu = new JMenu("View");
        this.options_jmenu = new JMenu("Options");
        this.help_jmenu = new JMenu("Help");
        this.print_size_jmenu = new JMenu("Print Options");
        this.file_jmenu.setFont(menu_font);
        this.file_jmenu.setBackground(menu_background_color);
        this.file_jmenu.setForeground(menu_text_color);
        this.edit_jmenu.setFont(menu_font);
        this.edit_jmenu.setBackground(menu_background_color);
        this.edit_jmenu.setForeground(menu_text_color);
        this.view_jmenu.setFont(menu_font);
        this.view_jmenu.setBackground(menu_background_color);
        this.view_jmenu.setForeground(menu_text_color);
        this.options_jmenu.setFont(menu_font);
        this.options_jmenu.setBackground(menu_background_color);
        this.options_jmenu.setForeground(menu_text_color);
        this.help_jmenu.setFont(menu_font);
        this.help_jmenu.setBackground(menu_background_color);
        this.help_jmenu.setForeground(menu_text_color);
        this.print_size_jmenu.setFont(menu_font);
        this.print_size_jmenu.setBackground(menu_background_color);
        this.print_size_jmenu.setForeground(menu_text_color);
        this.open_item = new JMenuItem("Open");
        this.file_jmenu.add(this.open_item);
        this.open_url_item = new JMenuItem("Open URL to read a NH/NHX tree");
        this.file_jmenu.add(this.open_url_item);
        this.saveas_item = new JMenuItem("Save As");
        this.file_jmenu.add(this.saveas_item);
        this.save_item = new JMenuItem("Save");
        this.file_jmenu.add(this.save_item);
        this.file_jmenu.addSeparator();
        this.file_jmenu.add(this.print_size_jmenu);
        this.print_item = new JMenuItem("Print");
        this.file_jmenu.add(this.print_item);
        this.file_jmenu.addSeparator();
        this.close_item = new JMenuItem("Close");
        this.file_jmenu.add(this.close_item);
        this.file_jmenu.addSeparator();
        this.exit_item = new JMenuItem("Exit");
        this.file_jmenu.add(this.exit_item);
        this.x_slider = new JSlider(0, 200, 100);
        this.y_slider = new JSlider(0, 200, 100);
        this.xs_label = new JLabel("X size:");
        this.ys_label = new JLabel("Y size:");
        this.xs_label.setFont(menu_font);
        this.xs_label.setForeground(menu_text_color);
        this.ys_label.setFont(menu_font);
        this.ys_label.setForeground(menu_text_color);
        ((JComponent)this.x_slider).setFont(menu_font);
        ((JComponent)this.y_slider).setFont(menu_font);
        this.print_in_color = new JCheckBox("Print in color");
        this.print_in_color.setFont(menu_font);
        this.print_in_color.setForeground(menu_text_color);
        this.print_size_jmenu.add(this.print_in_color);
        this.x_slider.setMajorTickSpacing(50);
        this.x_slider.setMinorTickSpacing(10);
        this.x_slider.setPaintTicks(true);
        this.x_slider.setPaintLabels(true);
        this.x_slider.setSnapToTicks(true);
        this.print_size_jmenu.add(this.xs_label);
        this.print_size_jmenu.add(this.x_slider);
        this.y_slider.setMajorTickSpacing(50);
        this.y_slider.setMinorTickSpacing(10);
        this.y_slider.setPaintTicks(true);
        this.y_slider.setPaintLabels(true);
        this.y_slider.setSnapToTicks(true);
        this.print_size_jmenu.add(this.ys_label);
        this.print_size_jmenu.add(this.y_slider);
        this.remove_root_item = new JMenuItem("Remove root");
        this.edit_jmenu.add(this.remove_root_item);
        this.remove_root_tri_item = new JMenuItem("Remove root and trifurcate");
        this.edit_jmenu.add(this.remove_root_tri_item);
        this.view_as_NH_item = new JMenuItem("View as NH");
        this.view_jmenu.add(this.view_as_NH_item);
        this.view_as_NHX_item = new JMenuItem("View as NHX");
        this.view_jmenu.add(this.view_as_NHX_item);
        this.switch_colors_item = new JMenuItem("Switch colors");
        this.options_jmenu.add(this.switch_colors_item);
        this.options_jmenu.addSeparator();
        this.tiny_fonts_item = new JMenuItem("Tiny fonts");
        this.options_jmenu.add(this.tiny_fonts_item);
        this.small_fonts_item = new JMenuItem("Small fonts");
        this.options_jmenu.add(this.small_fonts_item);
        this.medium_fonts_item = new JMenuItem("Medium fonts");
        this.options_jmenu.add(this.medium_fonts_item);
        this.large_fonts_item = new JMenuItem("Large fonts");
        this.options_jmenu.add(this.large_fonts_item);
        this.help_item = new JMenuItem("Help");
        this.help_jmenu.add(this.help_item);
        this.about_item = new JMenuItem("About");
        this.help_jmenu.add(this.about_item);
        JMenuItem jMenuItem = this.open_item;
        jMenuItem.setFont(menu_font);
        jMenuItem.setBackground(menu_background_color);
        jMenuItem.setForeground(menu_text_color);
        jMenuItem.addActionListener(this);
        jMenuItem = this.open_url_item;
        jMenuItem.setFont(menu_font);
        jMenuItem.setBackground(menu_background_color);
        jMenuItem.setForeground(menu_text_color);
        jMenuItem.addActionListener(this);
        jMenuItem = this.save_item;
        jMenuItem.setFont(menu_font);
        jMenuItem.setBackground(menu_background_color);
        jMenuItem.setForeground(menu_text_color);
        jMenuItem.addActionListener(this);
        jMenuItem = this.saveas_item;
        jMenuItem.setFont(menu_font);
        jMenuItem.setBackground(menu_background_color);
        jMenuItem.setForeground(menu_text_color);
        jMenuItem.addActionListener(this);
        jMenuItem = this.print_item;
        jMenuItem.setFont(menu_font);
        jMenuItem.setBackground(menu_background_color);
        jMenuItem.setForeground(menu_text_color);
        jMenuItem.addActionListener(this);
        jMenuItem = this.close_item;
        jMenuItem.setFont(menu_font);
        jMenuItem.setBackground(menu_background_color);
        jMenuItem.setForeground(menu_text_color);
        jMenuItem.addActionListener(this);
        jMenuItem = this.exit_item;
        jMenuItem.setFont(menu_font);
        jMenuItem.setBackground(menu_background_color);
        jMenuItem.setForeground(menu_text_color);
        jMenuItem.addActionListener(this);
        jMenuItem = this.remove_root_item;
        jMenuItem.setFont(menu_font);
        jMenuItem.setBackground(menu_background_color);
        jMenuItem.setForeground(menu_text_color);
        jMenuItem.addActionListener(this);
        jMenuItem = this.remove_root_tri_item;
        jMenuItem.setFont(menu_font);
        jMenuItem.setBackground(menu_background_color);
        jMenuItem.setForeground(menu_text_color);
        jMenuItem.addActionListener(this);
        jMenuItem = this.tiny_fonts_item;
        jMenuItem.setFont(menu_font);
        jMenuItem.setBackground(menu_background_color);
        jMenuItem.setForeground(menu_text_color);
        jMenuItem.addActionListener(this);
        jMenuItem = this.small_fonts_item;
        jMenuItem.setFont(menu_font);
        jMenuItem.setBackground(menu_background_color);
        jMenuItem.setForeground(menu_text_color);
        jMenuItem.addActionListener(this);
        jMenuItem = this.medium_fonts_item;
        jMenuItem.setFont(menu_font);
        jMenuItem.setBackground(menu_background_color);
        jMenuItem.setForeground(menu_text_color);
        jMenuItem.addActionListener(this);
        jMenuItem = this.large_fonts_item;
        jMenuItem.setFont(menu_font);
        jMenuItem.setBackground(menu_background_color);
        jMenuItem.setForeground(menu_text_color);
        jMenuItem.addActionListener(this);
        jMenuItem = this.switch_colors_item;
        jMenuItem.setFont(menu_font);
        jMenuItem.setBackground(menu_background_color);
        jMenuItem.setForeground(menu_text_color);
        jMenuItem.addActionListener(this);
        jMenuItem = this.view_as_NH_item;
        jMenuItem.setFont(menu_font);
        jMenuItem.setBackground(menu_background_color);
        jMenuItem.setForeground(menu_text_color);
        jMenuItem.addActionListener(this);
        jMenuItem = this.view_as_NHX_item;
        jMenuItem.setFont(menu_font);
        jMenuItem.setBackground(menu_background_color);
        jMenuItem.setForeground(menu_text_color);
        jMenuItem.addActionListener(this);
        jMenuItem = this.about_item;
        jMenuItem.setFont(menu_font);
        jMenuItem.setBackground(menu_background_color);
        jMenuItem.setForeground(menu_text_color);
        jMenuItem.addActionListener(this);
        jMenuItem = this.help_item;
        jMenuItem.setFont(menu_font);
        jMenuItem.setBackground(menu_background_color);
        jMenuItem.setForeground(menu_text_color);
        jMenuItem.addActionListener(this);
        this.jmenubar.add(this.file_jmenu);
        this.jmenubar.add(this.edit_jmenu);
        this.jmenubar.add(this.view_jmenu);
        this.jmenubar.add(this.options_jmenu);
        this.jmenubar.add(this.help_jmenu);
        this.setJMenuBar(this.jmenubar);
        this.contentpane = this.getContentPane();
        this.contentpane.setLayout(new BorderLayout());
        this.contentpane.add((Component)this.atvpanel, "Center");
        ((Component)this).setSize(640, 580);
        this.addWindowListener(new 1());
        this.addComponentListener(new 2());
        ((Component)this).setVisible(true);
    }

    private void about() {
        String string = "ATV (A Tree Viewer)\nVersion 1.3\n";
        string = String.valueOf(string) + "Copyright (C) 1999-2001 Washington University School of Medicine\n";
        string = String.valueOf(string) + "and Howard Hughes Medical Institute\n";
        string = String.valueOf(string) + "All Rights Reserved\n";
        string = String.valueOf(string) + "Author: Christian M. Zmasek\n";
        string = String.valueOf(string) + "Last modified: 10/31/00\n";
        string = String.valueOf(string) + "For more information & download:\n";
        string = String.valueOf(string) + "http://www.genetics.wustl.edu/eddy/atv/\n";
        string = String.valueOf(string) + "Comments: zmasek@genetics.wustl.edu";
        JOptionPane.showMessageDialog(this, string, "ATV application (Swing/JFC Version)", -1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.open_item) {
            this.openFile();
            return;
        }
        if (object == this.open_url_item) {
            this.openURL();
            return;
        }
        if (object == this.save_item) {
            this.save(this.atvpanel.getATVgraphic().getTree());
            return;
        }
        if (object == this.saveas_item) {
            this.saveAs(this.atvpanel.getATVgraphic().getTree());
            return;
        }
        if (object == this.print_item) {
            this.printTree();
            return;
        }
        if (object == this.close_item) {
            if (this.atvtextframe != null) {
                this.atvtextframe.close();
                this.atvtextframe = null;
            }
            this.atvpanel.terminate();
            this.contentpane.removeAll();
            ((Component)this).setVisible(false);
            this.dispose();
            return;
        }
        if (object == this.exit_item) {
            System.exit(0);
            return;
        }
        if (object == this.remove_root_item) {
            this.atvpanel.getATVgraphic().removeRoot();
            return;
        }
        if (object == this.remove_root_tri_item) {
            this.atvpanel.getATVgraphic().removeRootTri();
            return;
        }
        if (object == this.switch_colors_item) {
            this.atvpanel.getATVgraphic().switchColors();
            return;
        }
        if (object == this.tiny_fonts_item) {
            this.atvpanel.getATVgraphic().tinyFonts();
            this.atvpanel.getATVgraphic().repaint();
            return;
        }
        if (object == this.small_fonts_item) {
            this.atvpanel.getATVgraphic().smallFonts();
            this.atvpanel.getATVgraphic().repaint();
            return;
        }
        if (object == this.medium_fonts_item) {
            this.atvpanel.getATVgraphic().mediumFonts();
            this.atvpanel.getATVgraphic().repaint();
            return;
        }
        if (object == this.large_fonts_item) {
            this.atvpanel.getATVgraphic().largeFonts();
            this.atvpanel.getATVgraphic().repaint();
            return;
        }
        if (object == this.view_as_NH_item) {
            this.viewAsNH();
            return;
        }
        if (object == this.view_as_NHX_item) {
            this.viewAsNHX();
            return;
        }
        if (object == this.about_item) {
            this.about();
            return;
        }
        if (object == this.help_item) {
            this.help();
        }
    }

    private void close() {
        if (this.atvtextframe != null) {
            this.atvtextframe.close();
            this.atvtextframe = null;
        }
        this.atvpanel.terminate();
        this.contentpane.removeAll();
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void customizeJMenuItem(JMenuItem jMenuItem) {
        jMenuItem.setFont(menu_font);
        jMenuItem.setBackground(menu_background_color);
        jMenuItem.setForeground(menu_text_color);
        jMenuItem.addActionListener(this);
    }

    private void exceptionOccuredDuringOpenFile(Exception exception) {
        JOptionPane.showMessageDialog(this, "Exception: " + exception, "Error during File|Open", 0);
    }

    private void exceptionOccuredDuringSaveAs(Exception exception) {
        JOptionPane.showMessageDialog(this, "Exception" + exception, "Error during File|SaveAs", 0);
    }

    private void exit() {
        System.exit(0);
    }

    private void help() {
        String string = "Click on nodes of the tree to:\n";
        string = String.valueOf(string) + "- Display and edit information of a node.\n";
        string = String.valueOf(string) + "   To edit information, box \"Editable\" needs to be checked.\n";
        string = String.valueOf(string) + "- Collapse and uncollapse subtrees.\n";
        string = String.valueOf(string) + "- Go to SWISS-PROT and display its entry for the corresponding sequence.\n";
        string = String.valueOf(string) + "   Only available in JApplet version.\n";
        string = String.valueOf(string) + "   Seq names need to be proper SWISS-PROT names for this to work.\n";
        string = String.valueOf(string) + "- Place a root in the middle of the parent branch.\n";
        string = String.valueOf(string) + "- Display a subtree.\n";
        string = String.valueOf(string) + "   To go back to the parent tree, click on the root node of the subtree.\n";
        string = String.valueOf(string) + "- Swap the children of a node (a pure cosmetic operation).\n\n";
        string = String.valueOf(string) + "\"SaveAs\" \"Save\" save the (sub)tree which is currently shown in the frame.\n";
        string = String.valueOf(string) + "\"Print\" prints the (sub)tree which is currently shown in the frame.\n\n";
        string = String.valueOf(string) + "For more information: http://www.genetics.wustl.edu/eddy/atv/\n";
        string = String.valueOf(string) + "Email: zmasek@genetics.wustl.edu\n\n";
        string = String.valueOf(string) + "Remarks:\n";
        string = String.valueOf(string) + "- This software can deal with trees with an arbitrary number of \n";
        string = String.valueOf(string) + "   children per parent.\n";
        string = String.valueOf(string) + "- The application version allows to copy to the clipboard (either by \n";
        string = String.valueOf(string) + "   control-c or button press) in the \"View\"|\"View as ...\" frame. \n";
        string = String.valueOf(string) + "   For security reasons, the JApplet is not allowed to do so.\n";
        string = String.valueOf(string) + "- The JApplet can only connect to network ports on the server.\n";
        string = String.valueOf(string) + "   E.g. \"http://www.genetics.wustl.edu/\".\n";
        string = String.valueOf(string) + "   The application can connect to any host.\n";
        string = String.valueOf(string) + "- \"Save\", \"SaveAs\", \"Print\", and \"Open\" are only available in the \n";
        string = String.valueOf(string) + "   application version.\n";
        string = String.valueOf(string) + "- Changes made to a subtree affect this subtree and its subtrees,\n";
        string = String.valueOf(string) + "   but not any of its parent tree(s).\n";
        string = String.valueOf(string) + "- This software is able to detect whether the numerical values in a NH tree \n";
        string = String.valueOf(string) + "   are likely to be bootstrap values instead of branch length values.\n";
        JOptionPane.showMessageDialog(this, string, "Help", -1);
    }

    private void openFile() {
        boolean bl = false;
        Tree tree = null;
        int n = this.open_jfilechooser.showOpenDialog(this.contentpane);
        File file = this.open_jfilechooser.getSelectedFile();
        if (file != null && n == 0) {
            if (this.open_jfilechooser.getFileFilter() == nhfilter || this.open_jfilechooser.getFileFilter() == nhxfilter) {
                try {
                    tree = TreeHelper.readNHtree(file, false);
                }
                catch (Exception exception) {
                    bl = true;
                    JOptionPane.showMessageDialog(this, "Exception: " + exception, "Error during File|Open", 0);
                }
            } else {
                try {
                    tree = TreeHelper.readNHtree(file, false);
                }
                catch (Exception exception) {
                    bl = true;
                    JOptionPane.showMessageDialog(this, "Exception: " + exception, "Error during File|Open", 0);
                }
            }
            if (!bl && tree != null) {
                if (this.atvtextframe != null) {
                    this.atvtextframe.close();
                    this.atvtextframe = null;
                }
                this.atvpanel.terminate();
                this.contentpane.removeAll();
                this.atvpanel = new ATVpanel(tree);
                this.contentpane.add((Component)this.atvpanel, "Center");
                ((Component)this).setVisible(true);
                this.treefile = file;
                this.setTitle("ATV: " + this.treefile);
                this.atvpanel.getATVgraphic().setParametersForPainting(this.atvpanel.getATVgraphic().getWidth(), this.atvpanel.getATVgraphic().getHeight());
                this.atvpanel.getATVcontrol().showWhole();
            }
            this.contentpane.repaint();
        }
    }

    private void openURL() {
        URL uRL = null;
        Tree tree = null;
        String string = JOptionPane.showInputDialog(this, "Please enter a complete URL", "Open URL to read a NH/NHX tree", 3);
        if (string != null && string.length() > 4) {
            try {
                uRL = new URL(string);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "TreeJAppletJFrame: openURL(): Exception: " + exception, "Malformed URL", 0);
            }
            if (uRL != null) {
                try {
                    tree = TreeHelper.readNHtree(uRL, false);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(this, "TreeJAppletJFrame: openURL(): \nException: " + exception, "Could not read Tree", 0);
                }
                if (tree != null) {
                    if (this.atvtextframe != null) {
                        this.atvtextframe.close();
                        this.atvtextframe = null;
                    }
                    this.atvpanel.terminate();
                    this.contentpane.removeAll();
                    this.atvpanel = new ATVpanel(tree);
                    this.contentpane.add((Component)this.atvpanel, "Center");
                    ((Component)this).setVisible(true);
                    this.contentpane.repaint();
                    this.setTitle("ATV: " + uRL);
                    this.treefile = null;
                    this.atvpanel.getATVgraphic().setParametersForPainting(this.atvpanel.getATVgraphic().getWidth(), this.atvpanel.getATVgraphic().getHeight());
                }
            }
            this.contentpane.repaint();
        }
    }

    private void printTree() {
        ATVprinter aTVprinter = null;
        this.atvpanel.getATVgraphic().setParametersForPainting(380 * this.x_slider.getValue() / 100, 700 * this.y_slider.getValue() / 100);
        aTVprinter = this.treefile != null ? new ATVprinter(this.atvpanel.getATVgraphic(), this.treefile.toString(), this.print_in_color.isSelected()) : new ATVprinter(this.atvpanel.getATVgraphic(), "ATVprinter", this.print_in_color.isSelected());
        this.atvpanel.getATVgraphic().setParametersForPainting(this.atvpanel.getATVgraphic().getWidth(), this.atvpanel.getATVgraphic().getHeight());
        this.contentpane.repaint();
    }

    private void removeRoot() {
        this.atvpanel.getATVgraphic().removeRoot();
    }

    private void removeRootTri() {
        this.atvpanel.getATVgraphic().removeRootTri();
    }

    private void removeatvtextframe() {
        if (this.atvtextframe != null) {
            this.atvtextframe.close();
            this.atvtextframe = null;
        }
    }

    void save(Tree tree) {
        int n;
        if (this.treefile == null) {
            if (tree != null) {
                this.saveAs(tree);
            }
            return;
        }
        if (this.treefile.exists() && (n = JOptionPane.showConfirmDialog(this, String.valueOf(this.treefile) + " already exists. Overwrite?", "File|Save", 2, 2)) != 0) {
            return;
        }
        try {
            TreeHelper.writeNHtree(tree, this.treefile, true, true, true);
            return;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Exception: " + exception, "Error during File|Save", 0);
            return;
        }
    }

    void saveAs(Tree tree) {
        if (tree == null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = this.saveas_jfilechooser.showSaveDialog(this.contentpane);
        File file = this.saveas_jfilechooser.getSelectedFile();
        if (file != null && n == 0) {
            if (file.exists()) {
                int n2 = JOptionPane.showConfirmDialog(this, String.valueOf(file) + " already exists. Overwrite?", "File|SaveAs", 2, 2);
                if (n2 == 0) {
                    bl2 = true;
                    bl = true;
                } else {
                    return;
                }
            }
            if (this.saveas_jfilechooser.getFileFilter() == nhfilter) {
                try {
                    TreeHelper.writeNHtree(tree, file, false, bl, bl2);
                }
                catch (Exception exception) {
                    bl3 = true;
                    JOptionPane.showMessageDialog(this, "Exception" + exception, "Error during File|SaveAs", 0);
                }
            } else if (this.saveas_jfilechooser.getFileFilter() == nhxfilter) {
                try {
                    TreeHelper.writeNHtree(tree, file, true, bl, bl2);
                }
                catch (Exception exception) {
                    bl3 = true;
                    JOptionPane.showMessageDialog(this, "Exception" + exception, "Error during File|SaveAs", 0);
                }
            } else if (file.getName().trim().toLowerCase().endsWith(".nh")) {
                try {
                    TreeHelper.writeNHtree(tree, file, false, bl, bl2);
                }
                catch (Exception exception) {
                    bl3 = true;
                    JOptionPane.showMessageDialog(this, "Exception" + exception, "Error during File|SaveAs", 0);
                }
            } else {
                try {
                    TreeHelper.writeNHtree(tree, file, true, bl, bl2);
                }
                catch (Exception exception) {
                    bl3 = true;
                    JOptionPane.showMessageDialog(this, "Exception" + exception, "Error during File|SaveAs", 0);
                }
            }
            if (!bl3) {
                this.treefile = file;
                this.setTitle("ATV: " + this.treefile);
            }
        }
    }

    public void showWhole() {
        this.atvpanel.getATVcontrol().showWhole();
    }

    private void switchColors() {
        this.atvpanel.getATVgraphic().switchColors();
    }

    private void viewAsNH() {
        if (this.atvtextframe != null) {
            this.atvtextframe.close();
            this.atvtextframe = null;
        }
        if (this.atvpanel.getATVgraphic().getTree() == null) {
            return;
        }
        if (this.atvpanel.getATVgraphic().getTree().isEmpty()) {
            return;
        }
        this.atvtextframe = new ATVtextframe(this.atvpanel.getATVgraphic().getTree().toNewHampshire(false));
    }

    private void viewAsNHX() {
        if (this.atvtextframe != null) {
            this.atvtextframe.close();
            this.atvtextframe = null;
        }
        if (this.atvpanel.getATVgraphic().getTree() == null) {
            return;
        }
        if (this.atvpanel.getATVgraphic().getTree().isEmpty()) {
            return;
        }
        this.atvtextframe = new ATVtextframe(this.atvpanel.getATVgraphic().getTree().toNewHampshireX());
    }

    static /* synthetic */ void access$0(ATVjframe aTVjframe) {
        if (aTVjframe.atvtextframe != null) {
            aTVjframe.atvtextframe.close();
            aTVjframe.atvtextframe = null;
        }
        aTVjframe.atvpanel.terminate();
        aTVjframe.contentpane.removeAll();
        ((Component)aTVjframe).setVisible(false);
        aTVjframe.dispose();
    }

    static /* synthetic */ ATVpanel access$1(ATVjframe aTVjframe) {
        return aTVjframe.atvpanel;
    }

    private final class 1
    extends WindowAdapter {
        /* synthetic */ 1() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            ATVjframe aTVjframe = ATVjframe.this;
            if (aTVjframe.atvtextframe != null) {
                aTVjframe.atvtextframe.close();
                aTVjframe.atvtextframe = null;
            }
            aTVjframe.atvpanel.terminate();
            aTVjframe.contentpane.removeAll();
            ((Component)aTVjframe).setVisible(false);
            aTVjframe.dispose();
        }
    }

    private final class 2
    extends ComponentAdapter {
        /* synthetic */ 2() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            ATVjframe aTVjframe = ATVjframe.this;
            aTVjframe = ATVjframe.this;
            aTVjframe = ATVjframe.this;
            aTVjframe.atvpanel.getATVgraphic().setParametersForPainting(aTVjframe.atvpanel.getATVgraphic().getWidth(), aTVjframe.atvpanel.getATVgraphic().getHeight());
        }
    }
}

