/*
 * Decompiled with CFR 0.152.
 */
package forester.tree;

import forester.tree.Iterator;
import forester.tree.Node;
import forester.tree.StackItem;
import forester.tree.Tree;
import java.util.Stack;

public class PreorderTreeIterator
implements Iterator {
    private Tree tree;
    private Node node;
    private StackItem si;
    private boolean is_done;
    private Stack stack;

    public PreorderTreeIterator(Tree tree) throws Exception {
        if (tree.isEmpty()) {
            throw new Exception("PreorderTreeIterator: Tree is empty.");
        }
        this.tree = tree;
        this.first();
    }

    public Node currentNode() {
        if (this.is_done) {
            return null;
        }
        return this.node;
    }

    public void first() {
        this.is_done = false;
        this.stack = new Stack();
        this.stack.push(new StackItem(this.tree.getRoot(), 1));
        this.next();
    }

    public boolean isDone() {
        return this.is_done;
    }

    public void next() {
        if (this.node != null && this.node.isExternal() && this.node.getNextExtNode() == null) {
            this.is_done = true;
            return;
        }
        block5: while (true) {
            StackItem stackItem;
            if ((stackItem = (StackItem)this.stack.pop()).getNode() == null) {
                continue;
            }
            switch (stackItem.getPhase()) {
                default: {
                    continue block5;
                }
                case 1: {
                    this.stack.push(new StackItem(stackItem.getNode(), 2));
                    this.node = stackItem.getNode();
                    return;
                }
                case 2: {
                    this.stack.push(new StackItem(stackItem.getNode(), 3));
                    this.stack.push(new StackItem(stackItem.getNode().getChild1(), 1));
                    continue block5;
                }
                case 3: 
            }
            this.stack.push(new StackItem(stackItem.getNode().getChild2(), 1));
        }
    }
}

