/*
 * Decompiled with CFR 0.152.
 */
package forester.atv_awt;

import forester.atv_awt.ATVgraphic;
import forester.tree.Node;
import forester.tree.Tree;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.text.NumberFormat;

class ATVprinter
extends Frame {
    private Tree tree;
    private String title;
    private ATVgraphic ag;
    private static final double FACTOR_TO_FILL_SHEET = 1.7000000000000002;
    private static final int BOX_SIZE = 3;
    private static final int half_box_size = 1;
    private static final int MOVE = 30;
    private static final int TITLE = 60;
    private int longest_ext_node_info;
    private int x_current;
    private int y_current;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private int factor;
    private int xx;
    private int xxd;
    private int xxdd;
    private int yyd;
    private int x;
    private double x_correction_factor;
    private double x_distance;
    private double y_distance;
    private boolean done;
    private static final Color ext_node_seq_name_color = new Color(0, 0, 0);
    private static final Color int_node_seq_name_color = new Color(0, 0, 0);
    private static final Color species_color = new Color(0, 0, 0);
    private static final Color bootstrap_color = new Color(0, 0, 0);
    private static final Color ec_color = new Color(0, 0, 0);
    private static final Color dub_spec_color = new Color(0, 0, 0);
    private static final Color lnL_color = new Color(0, 0, 0);
    private static final Color branch_length_color = new Color(0, 0, 0);
    private static final Color branch_color = new Color(0, 0, 0);
    private static final Color box_color = new Color(0, 0, 0);
    private static final Color branch_p_color = new Color(140, 140, 140);
    private static final Color bl_p_color = new Color(0, 0, 0);
    private static final Color collapsed_node_color = new Color(0, 0, 0);
    private static final Color background_color = new Color(255, 255, 255);
    private static final Font small_font = new Font("Helvetica", 0, 5);
    private static final Font large_font = new Font("Helvetica", 0, 6);
    private static final Font small_italic_font = new Font("Helvetica", 2, 5);
    private static final Font large_italic_font = new Font("Helvetica", 2, 6);
    private final FontMetrics fm_small = this.getFontMetrics(small_font);
    private final FontMetrics fm_large = this.getFontMetrics(large_font);
    private final FontMetrics fm_small_italic = this.getFontMetrics(small_italic_font);
    private final FontMetrics fm_large_italic = this.getFontMetrics(large_italic_font);
    private final int small_maxDescent = this.fm_small.getMaxDescent();
    private final int small_maxAscent = this.fm_small.getMaxAscent() + 2;
    private NumberFormat lnL_nf = NumberFormat.getNumberInstance();

    ATVprinter(ATVgraphic aTVgraphic, String string) {
        this.ag = aTVgraphic;
        this.tree = this.ag.getTree();
        this.title = string;
        this.x_distance = this.ag.getXdistance() * 1.7000000000000002;
        this.y_distance = this.ag.getYdistance();
        this.x_correction_factor = this.ag.getXcorrectionFactor() * 1.7000000000000002;
        ((Component)this).setBackground(background_color);
        ((Component)this).setVisible(true);
        this.printTree();
        this.ag = null;
        this.tree = null;
        this.dispose();
    }

    private void drawBranchOfSeqOnParent(Node node, Graphics graphics) {
        graphics.setColor(branch_p_color);
        this.xx = (this.x1 + this.x2) / 2;
        this.xxd = (int)((double)((this.x1 + this.x2) / 2) + this.y_distance * 0.7000000000000001);
        this.yyd = (int)((double)this.y2 - this.y_distance * 0.7000000000000001);
        this.xxdd = this.xxd + (int)(node.getBlOfSeqOnParentBranch() * this.x_correction_factor);
        graphics.drawLine(this.xx, this.y2, this.xxd, this.yyd);
        graphics.drawLine(this.xxd, this.yyd, this.xxdd, this.yyd);
        graphics.drawLine(this.xxdd + 1, this.yyd - 1, this.xxdd - 1, this.yyd + 1);
    }

    private void drawCollapsedNode(int n, int n2, Graphics graphics, Node node) {
        int n3 = 0;
        graphics.setColor(collapsed_node_color);
        graphics.fillRect(n - 1, n2 - 1, 3, 3);
        if (this.ag.speciesExtNodes() && !node.getSpecies().equals("")) {
            graphics.setFont(large_italic_font);
            graphics.setColor(species_color);
            graphics.drawString(String.valueOf(node.getSpecies()) + ": ", n + 3 + 1, n2 + this.fm_large.getAscent() / 2);
            n3 = this.fm_large_italic.stringWidth(String.valueOf(node.getSpecies()) + ": ");
        }
        if (this.ag.seqNameExtNodes() && !node.getSeqName().equals("")) {
            graphics.setFont(large_font);
            graphics.setColor(ext_node_seq_name_color);
            graphics.drawString(String.valueOf(node.getSeqName()) + ": ", n + 3 + 1 + n3, n2 + this.fm_large.getAscent() / 2);
            n3 += this.fm_large.stringWidth(String.valueOf(node.getSeqName()) + ": ");
        }
        graphics.setColor(collapsed_node_color);
        graphics.setFont(large_font);
        graphics.drawString("collapsed", n + n3 + 3 + 1, n2 + this.fm_large.getAscent() / 2);
    }

    private void drawDuplicationNode(int n, int n2, Graphics graphics) {
        graphics.setColor(branch_color);
        graphics.fillOval(n - 3, n2 - 3, 6, 6);
    }

    private void printTree() {
        PrintJob printJob;
        if (this.tree == null) {
            return;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit != null && (printJob = toolkit.getPrintJob(this, "ATVprinter", null)) != null) {
            Graphics graphics = printJob.getGraphics();
            if (graphics != null) {
                this.done = false;
                this.lnL_nf.setMaximumFractionDigits(2);
                this.lnL_nf.setMinimumFractionDigits(2);
                Node node = this.tree.getRoot();
                this.tree.setIndicatorsToZero();
                this.x_current = this.tree.getRoot().getDistanceToParent() > 0.0 && this.ag.useRealBranchLenghts() ? (int)(this.tree.getRoot().getDistanceToParent() * this.x_correction_factor + 30.0) : (int)this.x_distance + 30;
                graphics.setFont(large_font);
                graphics.drawString(this.title, 30, 30);
                this.y_current = (int)(this.y_distance * (double)this.tree.getNumberOfExtNodes() + 60.0 + 15.0);
                ((Component)this).setBackground(background_color);
                do {
                    int n;
                    int n2;
                    if (node.getDistanceToParent() != -100.0) {
                        if (this.ag.writeBranchLengthValues() && node.getIndicator() == 0 && node.getDistanceToParent() >= 0.0) {
                            graphics.setFont(small_font);
                            graphics.setColor(branch_length_color);
                            if (node.getParent() != null) {
                                graphics.drawString(Double.toString(node.getDistanceToParent()), node.getParent().getXcoord() + 3, this.y_current - this.small_maxDescent);
                            } else {
                                graphics.drawString(Double.toString(node.getDistanceToParent()), 3, this.y_current - this.small_maxDescent);
                            }
                        }
                        if (this.ag.writeLnLValues() && node.getIndicator() == 0 && node.isLnLonParentBranchAssigned()) {
                            graphics.setFont(small_font);
                            graphics.setColor(lnL_color);
                            if (node.getParent() != null) {
                                graphics.drawString(String.valueOf(this.lnL_nf.format(this.tree.getHighestLnL() - node.getLnLonParentBranch())) + " (" + this.lnL_nf.format(node.getLnLonParentBranch()) + ")", node.getParent().getXcoord() + 3, this.y_current + this.small_maxAscent);
                            } else if (this.tree.getNumberOfExtNodes() >= 2) {
                                graphics.drawString(String.valueOf(this.lnL_nf.format(this.tree.getHighestLnL() - node.getLnLonParentBranch())) + " (" + this.lnL_nf.format(node.getLnLonParentBranch()) + ")", 3, this.y_current + this.small_maxAscent);
                            } else {
                                graphics.drawString(" (" + this.lnL_nf.format(node.getLnLonParentBranch()) + ")", 3, this.y_current + this.small_maxAscent);
                            }
                        }
                        if (this.ag.writeBootstrapValues() && node.getBootstrap() > 0 && this.tree.getNumberOfExtNodes() >= 2 && !node.collapse()) {
                            graphics.setFont(small_font);
                            graphics.setColor(bootstrap_color);
                            graphics.drawString(Integer.toString(node.getBootstrap()), this.x_current - this.fm_small.stringWidth(Integer.toString(node.getBootstrap())) - 3 - 1, this.y_current + this.small_maxAscent);
                        }
                    }
                    if (node.getParent() == null && this.tree.isRooted() && node.getIndicator() == 0) {
                        graphics.setColor(branch_color);
                        if (this.ag.useRealBranchLenghts() && this.tree.getRoot().getDistanceToParent() > 0.0) {
                            graphics.drawLine(this.x_current, this.y_current, this.x_current - (int)(this.x_correction_factor * this.tree.getRoot().getDistanceToParent()), this.y_current);
                        } else {
                            graphics.drawLine(this.x_current, this.y_current, this.x_current - (int)this.x_distance, this.y_current);
                            if (this.ag.colorBranchesAccToLnL() && !node.significantlyWorse()) {
                                graphics.drawLine(this.x_current, this.y_current - 1, this.x_current - (int)this.x_distance, this.y_current - 1);
                                graphics.drawLine(this.x_current, this.y_current + 1, this.x_current - (int)this.x_distance, this.y_current + 1);
                            }
                        }
                        if (!node.collapse()) {
                            if (!this.ag.writeDupSpec() && node.isDuplicationOrSpecAssigned() && node.isDuplication()) {
                                n2 = this.x_current;
                                n = this.y_current;
                                graphics.setColor(branch_color);
                                graphics.fillOval(n2 - 3, n - 3, 6, 6);
                            } else {
                                graphics.setColor(box_color);
                                graphics.fillRect(this.x_current - 1, this.y_current - 1, 3, 3);
                            }
                        } else {
                            this.drawCollapsedNode(this.x_current, this.y_current, graphics, node);
                        }
                    }
                    if (node.getIndicator() == 0 && !node.isExternal()) {
                        this.factor = node.getSumExtNodes() - node.getChild1().getSumExtNodes();
                        this.x1 = this.x_current;
                        node.setXcoord(this.x1);
                        this.y1 = this.y_current;
                        node.setYcoord(this.y1);
                        this.y2 = (int)((double)this.y_current - this.y_distance * (double)this.factor);
                        if (node.getDistanceToParent() != -100.0) {
                            if (this.ag.speciesInternalNodes() && !node.collapse() && !node.getSpecies().equals("")) {
                                graphics.setFont(small_italic_font);
                                graphics.setColor(species_color);
                                graphics.drawString(node.getSpecies(), this.x_current + 3 + 1, this.y_current + this.fm_small_italic.getAscent() / 2);
                            }
                            if (this.ag.seqNameInternalNodes() && !node.getSeqName().equals("") && !node.collapse()) {
                                graphics.setColor(int_node_seq_name_color);
                                graphics.setFont(large_font);
                                graphics.drawString(node.getSeqName(), this.x_current - this.fm_large.stringWidth(node.getSeqName()) - 3 - 1, this.y_current - this.fm_large.getMaxDescent());
                            }
                            if (this.ag.ECInternalNodes() && !node.getECnumber().equals("") && !node.collapse()) {
                                graphics.setColor(ec_color);
                                graphics.setFont(large_font);
                                this.x = this.ag.seqNameInternalNodes() && !node.getSeqName().equals("") ? this.fm_large.stringWidth(String.valueOf(node.getSeqName()) + " ") : 0;
                                graphics.drawString(node.getECnumber(), this.x_current - this.x - this.fm_large.stringWidth(node.getECnumber()) - 4 - 1, this.y_current - this.fm_large.getMaxDescent());
                            }
                            if (this.ag.writeDupSpec() && node.isDuplicationOrSpecAssigned() && !node.collapse()) {
                                graphics.setColor(dub_spec_color);
                                graphics.setFont(large_font);
                                this.x = this.ag.speciesInternalNodes() ? this.fm_large.getMaxAscent() : 0;
                                if (node.isDuplication()) {
                                    graphics.drawString("D", this.x_current + 3 + 1, this.y_current + this.fm_large.getAscent() / 2 + this.x);
                                } else {
                                    graphics.drawString("S", this.x_current + 3 + 1, this.y_current + this.fm_large.getAscent() / 2 + this.x);
                                }
                            }
                        }
                        if (!node.collapse()) {
                            this.x2 = this.ag.useRealBranchLenghts() ? this.x_current + (int)(this.x_correction_factor * (node.getChild1().getDistanceToParent() >= 0.0 ? node.getChild1().getDistanceToParent() : 0.0)) : (node.getChild1().getDistanceToParent() == -100.0 ? this.x_current : (node.getChild1().getChild1() == null ? (int)(this.x_distance + 30.0 + this.x_distance * (double)this.tree.getMostBranchesPerExtNode()) : (int)((double)this.x_current + this.x_distance * (double)this.factor)));
                            graphics.setColor(branch_color);
                            graphics.drawLine(this.x1, this.y1, this.x1, this.y2);
                            graphics.drawLine(this.x1, this.y2, this.x2, this.y2);
                            if (this.ag.colorBranchesAccToLnL() && !node.getChild1().significantlyWorse()) {
                                graphics.drawLine(this.x1, this.y2 - 1, this.x2, this.y2 - 1);
                                graphics.drawLine(this.x1, this.y2 + 1, this.x2, this.y2 + 1);
                            }
                            if (this.ag.drawBlOfSeqOnParent() && node.getChild1().getBlOfSeqOnParentBranch() >= 0.0) {
                                this.drawBranchOfSeqOnParent(node.getChild1(), graphics);
                            }
                            if (this.ag.writeBlOfSeqOnParent() && node.getChild1().getBlOfSeqOnParentBranch() >= 0.0) {
                                this.writeBranchLengthOfSeqOnParent(node.getChild1(), graphics);
                            }
                            if (node.getChild1().getDistanceToParent() != -100.0) {
                                if (!node.getChild1().collapse()) {
                                    if (!this.ag.writeDupSpec() && node.getChild1().isDuplicationOrSpecAssigned() && node.getChild1().isDuplication()) {
                                        n2 = this.x2;
                                        n = this.y2;
                                        graphics.setColor(branch_color);
                                        graphics.fillOval(n2 - 3, n - 3, 6, 6);
                                    } else {
                                        graphics.setColor(box_color);
                                        graphics.fillRect(this.x2 - 1, this.y2 - 1, 3, 3);
                                    }
                                } else {
                                    this.drawCollapsedNode(this.x2, this.y2, graphics, node.getChild1());
                                }
                            }
                            this.x_current = this.x2;
                            this.y_current = this.y2;
                            node.setIndicator(1);
                            node = node.getChild1();
                        } else {
                            node.setIndicator(1);
                        }
                    }
                    if (node.getIndicator() == 1 && !node.isExternal()) {
                        if (!node.collapse()) {
                            this.factor = node.getSumExtNodes() - node.getChild2().getSumExtNodes();
                            this.x1 = this.x_current;
                            this.y1 = this.y_current;
                            this.y2 = (int)((double)this.y_current + this.y_distance * (double)this.factor);
                            this.x2 = this.ag.useRealBranchLenghts() ? this.x_current + (int)(this.x_correction_factor * (node.getChild2().getDistanceToParent() >= 0.0 ? node.getChild2().getDistanceToParent() : 0.0)) : (node.getChild2().getDistanceToParent() == -100.0 ? this.x_current : (node.getChild2().getChild1() == null ? (int)(this.x_distance + 30.0 + this.x_distance * (double)this.tree.getMostBranchesPerExtNode()) : (int)((double)this.x_current + this.x_distance * (double)this.factor)));
                            graphics.setColor(branch_color);
                            graphics.drawLine(this.x1, this.y1, this.x1, this.y2);
                            graphics.drawLine(this.x1, this.y2, this.x2, this.y2);
                            if (this.ag.colorBranchesAccToLnL() && !node.getChild2().significantlyWorse()) {
                                graphics.drawLine(this.x1, this.y2 - 1, this.x2, this.y2 - 1);
                                graphics.drawLine(this.x1, this.y2 + 1, this.x2, this.y2 + 1);
                            }
                            if (this.ag.drawBlOfSeqOnParent() && node.getChild2().getBlOfSeqOnParentBranch() >= 0.0) {
                                this.drawBranchOfSeqOnParent(node.getChild2(), graphics);
                            }
                            if (this.ag.writeBlOfSeqOnParent() && node.getChild2().getBlOfSeqOnParentBranch() >= 0.0) {
                                this.writeBranchLengthOfSeqOnParent(node.getChild2(), graphics);
                            }
                            if (node.getChild2().getDistanceToParent() != -100.0) {
                                if (!node.getChild2().collapse()) {
                                    if (!this.ag.writeDupSpec() && node.getChild2().isDuplicationOrSpecAssigned() && node.getChild2().isDuplication()) {
                                        n2 = this.x2;
                                        n = this.y2;
                                        graphics.setColor(branch_color);
                                        graphics.fillOval(n2 - 3, n - 3, 6, 6);
                                    } else {
                                        graphics.setColor(box_color);
                                        graphics.fillRect(this.x2 - 1, this.y2 - 1, 3, 3);
                                    }
                                } else {
                                    this.drawCollapsedNode(this.x2, this.y2, graphics, node.getChild2());
                                }
                            }
                            this.x_current = this.x2;
                            this.y_current = this.y2;
                            node.setIndicator(2);
                            node = node.getChild2();
                        } else {
                            node.setIndicator(2);
                        }
                    }
                    if (node.getParent() == null) {
                        this.done = true;
                    } else if (node.getIndicator() == 2 && node.getChild1() != null) {
                        node = node.getParent();
                        this.x_current = node.getXcoord();
                        this.y_current = node.getYcoord();
                    }
                    if (node.getChild1() != null) continue;
                    if (this.ag.speciesExtNodes() && !node.getSpecies().equals("")) {
                        graphics.setFont(large_italic_font);
                        graphics.setColor(species_color);
                        graphics.drawString(String.valueOf(node.getSpecies()) + " ", this.x_current + 3 + 1, this.y_current + this.fm_large.getAscent() / 2);
                    }
                    if (this.ag.seqNameExtNodes() && !node.getSeqName().equals("")) {
                        graphics.setFont(large_font);
                        graphics.setColor(ext_node_seq_name_color);
                        this.x = this.ag.speciesExtNodes() && !node.getSpecies().equals("") ? this.fm_large_italic.stringWidth(String.valueOf(node.getSpecies()) + " ") : 0;
                        graphics.drawString(node.getSeqName(), this.x_current + this.x + 3 + 1, this.y_current + this.fm_large.getAscent() / 2);
                    }
                    if (this.ag.ECExtNodes() && !node.getECnumber().equals("")) {
                        graphics.setFont(large_font);
                        graphics.setColor(ec_color);
                        this.x = this.ag.speciesExtNodes() && !node.getSpecies().equals("") ? this.fm_large_italic.stringWidth(String.valueOf(node.getSpecies()) + " ") : 0;
                        if (this.ag.seqNameExtNodes() && !node.getSeqName().equals("")) {
                            this.x += this.fm_large.stringWidth(String.valueOf(node.getSeqName()) + " ");
                        }
                        graphics.drawString(node.getECnumber(), this.x_current + this.x + 3 + 1, this.y_current + this.fm_large.getAscent() / 2);
                    }
                    if (this.ag.writeBranchLengthValues() && node.getParent() != null && node.getDistanceToParent() >= 0.0) {
                        graphics.setFont(small_font);
                        graphics.setColor(branch_length_color);
                        graphics.drawString(Double.toString(node.getDistanceToParent()), node.getParent().getXcoord() + 3, this.y_current - this.small_maxDescent);
                    }
                    if (this.ag.writeLnLValues() && node.getParent() != null && node.isLnLonParentBranchAssigned()) {
                        graphics.setFont(small_font);
                        graphics.setColor(lnL_color);
                        graphics.drawString(String.valueOf(this.lnL_nf.format(this.tree.getHighestLnL() - node.getLnLonParentBranch())) + " (" + this.lnL_nf.format(node.getLnLonParentBranch()) + ")", node.getParent().getXcoord() + 3, this.y_current + this.small_maxAscent);
                    }
                    node.setXcoord(this.x_current);
                    node.setYcoord(this.y_current);
                    if (node.getNextExtNode() == null) {
                        this.done = true;
                    }
                    if (node.getParent() != null) {
                        node = node.getParent();
                    }
                    this.x_current = node.getXcoord();
                    this.y_current = node.getYcoord();
                } while (!this.done);
                this.tree.setIndicatorsToZero();
                graphics.dispose();
            }
            printJob.end();
        }
    }

    private void writeBranchLengthOfSeqOnParent(Node node, Graphics graphics) {
        graphics.setFont(small_font);
        graphics.setColor(bl_p_color);
        graphics.drawString(Double.toString(node.getBlOfSeqOnParentBranch()), (this.x1 + this.x2) / 2, this.y2 + this.small_maxAscent);
    }
}

