/*
 * Decompiled with CFR 0.152.
 */
package forester.atv_awt;

import forester.atv_awt.ATVapplet;
import forester.atv_awt.ATVpanel;
import forester.atv_awt.ATVpanel_applet;
import forester.atv_awt.Message;
import forester.tree.Tree;
import forester.tree.TreeHelper;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;

class ATVappletFrame
extends Frame
implements ActionListener {
    private MenuBar menubar;
    private Menu file_jmenu;
    private Menu edit_jmenu;
    private Menu view_jmenu;
    private Menu options_jmenu;
    private Menu help_jmenu;
    private MenuItem close_item;
    private MenuItem open_url_item;
    private MenuItem remove_root_item;
    private MenuItem remove_root_tri_item;
    private MenuItem tiny_fonts_item;
    private MenuItem small_fonts_item;
    private MenuItem medium_fonts_item;
    private MenuItem large_fonts_item;
    private MenuItem switch_colors_item;
    private MenuItem view_as_NH_item;
    private MenuItem view_as_NHX_item;
    private MenuItem about_item;
    private MenuItem help_item;
    private ATVapplet atvapplet;
    ATVpanel_applet atvpanel;
    Dialog d;
    TextField url_tf;
    private String url_string = "http://";
    private static final Color menu_background_color = new Color(215, 215, 215);
    private static final Color menu_text_color = new Color(0, 0, 0);
    private static final Font menu_font = new Font("SansSerif", 0, 10);
    private static final int FRAME_X_SIZE = 640;
    private static final int FRAME_Y_SIZE = 580;

    ATVappletFrame(ATVapplet aTVapplet) {
        this.atvapplet = aTVapplet;
        URL uRL = null;
        Tree tree = null;
        if (this.atvapplet.getURLstring() != null) {
            try {
                uRL = new URL(this.atvapplet.getURLstring());
            }
            catch (Exception exception) {
                new Message((Frame)this, "Exception while trying to create URL", String.valueOf(exception) + "\nCould not create URL from:\n" + uRL);
                this.close();
            }
        }
        if (uRL != null) {
            try {
                tree = TreeHelper.readNHtree(uRL, false);
            }
            catch (Exception exception) {
                new Message((Frame)this, "Exception while trying to read Tree from URL", String.valueOf(exception) + "\nCould not read Tree from:\n" + uRL);
                this.close();
            }
        }
        this.setTitle("ATV");
        this.atvpanel = new ATVpanel_applet(tree, this);
        this.menubar = new MenuBar();
        this.file_jmenu = new Menu("File");
        this.edit_jmenu = new Menu("Edit");
        this.view_jmenu = new Menu("View");
        this.options_jmenu = new Menu("Options");
        this.help_jmenu = new Menu("Help");
        this.file_jmenu.setFont(menu_font);
        this.edit_jmenu.setFont(menu_font);
        this.view_jmenu.setFont(menu_font);
        this.options_jmenu.setFont(menu_font);
        this.help_jmenu.setFont(menu_font);
        this.open_url_item = new MenuItem("Open URL to read a NH/NHX tree");
        this.file_jmenu.add(this.open_url_item);
        this.file_jmenu.addSeparator();
        this.close_item = new MenuItem("Close");
        this.file_jmenu.add(this.close_item);
        this.remove_root_item = new MenuItem("Remove root");
        this.edit_jmenu.add(this.remove_root_item);
        this.remove_root_tri_item = new MenuItem("Remove root and trifurcate");
        this.edit_jmenu.add(this.remove_root_tri_item);
        this.switch_colors_item = new MenuItem("Switch colors");
        this.options_jmenu.add(this.switch_colors_item);
        this.options_jmenu.addSeparator();
        this.tiny_fonts_item = new MenuItem("Tiny fonts");
        this.options_jmenu.add(this.tiny_fonts_item);
        this.small_fonts_item = new MenuItem("Small fonts");
        this.options_jmenu.add(this.small_fonts_item);
        this.medium_fonts_item = new MenuItem("Medium fonts");
        this.options_jmenu.add(this.medium_fonts_item);
        this.large_fonts_item = new MenuItem("Large fonts");
        this.options_jmenu.add(this.large_fonts_item);
        this.view_as_NH_item = new MenuItem("View as NH");
        this.view_jmenu.add(this.view_as_NH_item);
        this.view_as_NHX_item = new MenuItem("View as NHX");
        this.view_jmenu.add(this.view_as_NHX_item);
        this.help_item = new MenuItem("Help");
        this.help_jmenu.add(this.help_item);
        this.about_item = new MenuItem("About");
        this.help_jmenu.add(this.about_item);
        this.customizeMenuItem(this.open_url_item);
        this.customizeMenuItem(this.close_item);
        this.customizeMenuItem(this.remove_root_item);
        this.customizeMenuItem(this.remove_root_tri_item);
        this.customizeMenuItem(this.tiny_fonts_item);
        this.customizeMenuItem(this.small_fonts_item);
        this.customizeMenuItem(this.medium_fonts_item);
        this.customizeMenuItem(this.large_fonts_item);
        this.customizeMenuItem(this.switch_colors_item);
        this.customizeMenuItem(this.view_as_NH_item);
        this.customizeMenuItem(this.view_as_NHX_item);
        this.customizeMenuItem(this.about_item);
        this.customizeMenuItem(this.help_item);
        this.menubar.add(this.file_jmenu);
        this.menubar.add(this.edit_jmenu);
        this.menubar.add(this.view_jmenu);
        this.menubar.add(this.options_jmenu);
        this.menubar.add(this.help_jmenu);
        this.setMenuBar(this.menubar);
        this.setLayout(new BorderLayout());
        this.add((Component)this.atvpanel, "Center");
        ((Component)this).setSize(640, 580);
        this.addWindowListener(new 1());
        this.addComponentListener(new 2());
        ((Component)this).setVisible(true);
    }

    private void about() {
        this.d = new Dialog(this, "ATV Applet (AWT Version)", true);
        this.d.setLayout(new BorderLayout());
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        panel.setLayout(new GridLayout(9, 1));
        panel2.setLayout(new FlowLayout(1));
        panel.add(new Label("ATV (A Tree Viewer) Version AWT 1.3", 1));
        panel.add(new Label("Copyright (C) 1999-2001 Washington University School of Medicine", 1));
        panel.add(new Label("and Howard Hughes Medical Institute", 1));
        panel.add(new Label("All Rights Reserved", 1));
        panel.add(new Label("Author: Christian M. Zmasek", 1));
        panel.add(new Label("Last modified: 10/31/00", 1));
        panel.add(new Label("For more information & download:", 1));
        panel.add(new Label("http://www.genetics.wustl.edu/eddy/atv/", 1));
        panel.add(new Label("Comments: zmasek@genetics.wustl.edu", 1));
        Button button = new Button("OK");
        panel2.add(button);
        this.d.add((Component)panel, "Center");
        this.d.add((Component)panel2, "South");
        ((Component)this.d).setSize(430, 300);
        this.d.addWindowListener(new 7());
        button.addActionListener(new 8());
        this.d.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.open_url_item) {
            this.openURL();
            return;
        }
        if (object == this.close_item) {
            this.close();
            return;
        }
        if (object == this.remove_root_item) {
            this.atvpanel.getATVgraphic().removeRoot();
            return;
        }
        if (object == this.remove_root_tri_item) {
            this.atvpanel.getATVgraphic().removeRootTri();
            return;
        }
        if (object == this.switch_colors_item) {
            this.atvpanel.getATVgraphic().switchColors();
            return;
        }
        if (object == this.tiny_fonts_item) {
            this.atvpanel.getATVgraphic().tinyFonts();
            this.atvpanel.getATVgraphic().repaint();
            return;
        }
        if (object == this.small_fonts_item) {
            this.atvpanel.getATVgraphic().smallFonts();
            this.atvpanel.getATVgraphic().repaint();
            return;
        }
        if (object == this.medium_fonts_item) {
            this.atvpanel.getATVgraphic().mediumFonts();
            this.atvpanel.getATVgraphic().repaint();
            return;
        }
        if (object == this.large_fonts_item) {
            this.atvpanel.getATVgraphic().largeFonts();
            this.atvpanel.getATVgraphic().repaint();
            return;
        }
        if (object == this.view_as_NH_item) {
            this.viewAsNH();
            return;
        }
        if (object == this.view_as_NHX_item) {
            this.viewAsNHX();
            return;
        }
        if (object == this.about_item) {
            this.about();
            return;
        }
        if (object == this.help_item) {
            this.help();
        }
    }

    void close() {
        this.atvpanel.terminate();
        ((Component)this).setVisible(false);
        this.dispose();
    }

    protected void customizeMenuItem(MenuItem menuItem) {
        menuItem.setFont(menu_font);
        menuItem.addActionListener(this);
    }

    void doOpenURL(String string) {
        this.url_string = string;
        boolean bl = false;
        URL uRL = null;
        Tree tree = null;
        if (this.url_string != null && this.url_string.length() > 4) {
            try {
                uRL = new URL(this.url_string);
            }
            catch (Exception exception) {
                new Message((Frame)this, "Exception during File|Open URL", String.valueOf(exception) + "\nCould not create URL from:\n" + this.url_string);
            }
            if (uRL != null) {
                try {
                    tree = TreeHelper.readNHtree(uRL, false);
                }
                catch (Exception exception) {
                    bl = true;
                    new Message((Frame)this, "Exception during File|Open URL", String.valueOf(exception) + "\nCould not read from URL:\n" + uRL);
                }
                if (!bl && tree != null) {
                    this.atvpanel.terminate();
                    this.setTitle("ATV: " + uRL);
                    this.atvpanel.getATVgraphic().setTree(tree);
                    this.atvpanel.getATVgraphic().setPropertiesForPainting(tree);
                    this.atvpanel.getATVcontrol().setCheckBoxes();
                    this.atvpanel.getATVcontrol().showWhole();
                }
            }
        }
    }

    ATVapplet getATVapplet() {
        return this.atvapplet;
    }

    ATVpanel getATVpanel() {
        return this.atvpanel;
    }

    protected Menu getFileMenu() {
        return this.file_jmenu;
    }

    private void help() {
        String string = "Click on nodes of the tree to:\n";
        string = String.valueOf(string) + "- Display and edit information of a node.\n";
        string = String.valueOf(string) + "   To edit information, box \"Editable\" needs to be checked.\n";
        string = String.valueOf(string) + "- Collapse and uncollapse subtrees.\n";
        string = String.valueOf(string) + "- Go to SWISS-PROT and display its entry for the corresponding sequence.\n";
        string = String.valueOf(string) + "   Only available in Applet version.\n";
        string = String.valueOf(string) + "   Seq names need to be proper SWISS-PROT names for this to work.\n";
        string = String.valueOf(string) + "- Place a root in the middle of the parent branch.\n";
        string = String.valueOf(string) + "- Display a subtree.\n";
        string = String.valueOf(string) + "   To go back to the parent tree, click on the root node of the subtree.\n";
        string = String.valueOf(string) + "- Swap the children of a node (a pure cosmetic operation).\n\n";
        string = String.valueOf(string) + "\"SaveAs\" \"Save\" save the (sub)tree which is currently shown in the frame.\n";
        string = String.valueOf(string) + "\"Print\" prints the (sub)tree which is currently shown in the frame.\n\n";
        string = String.valueOf(string) + "For more information: http://www.genetics.wustl.edu/eddy/atv/\n";
        string = String.valueOf(string) + "Email: zmasek@genetics.wustl.edu\n\n";
        string = String.valueOf(string) + "Remarks:\n";
        string = String.valueOf(string) + "- This software can deal with trees with an arbitrary number of \n";
        string = String.valueOf(string) + "   children per parent.\n";
        string = String.valueOf(string) + "- The Applet can only connect to network ports on the server.\n";
        string = String.valueOf(string) + "   E.g. \"http://www.genetics.wustl.edu/\".\n";
        string = String.valueOf(string) + "   The application can connect to any host.\n";
        string = String.valueOf(string) + "- \"Save\", \"SaveAs\", \"Print\", and \"Open\" are only available in the \n";
        string = String.valueOf(string) + "   application version.\n";
        string = String.valueOf(string) + "- Changes made to a subtree affect this subtree and its subtrees,\n";
        string = String.valueOf(string) + "   but not any of its parent tree(s).\n";
        string = String.valueOf(string) + "- This software is able to detect whether the numerical values in a NH tree \n";
        string = String.valueOf(string) + "   are likely to be bootstrap values instead of branch length values.\n";
        new Message((Frame)this, "ATV application (AWT Version)", string);
    }

    private void openURL() {
        this.d = new Dialog(this, "Open URL to read a NH/NHX tree", true);
        this.d.setLayout(new BorderLayout());
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        panel.setLayout(new FlowLayout(1, 5, 5));
        panel2.setLayout(new FlowLayout(1, 5, 5));
        panel.add(new Label("Please enter a complete URL. Must refer to same server as provided this Applet."));
        this.url_tf = new TextField(this.url_string, 60);
        panel.add(this.url_tf);
        Button button = new Button("Open ");
        Button button2 = new Button("Cancel");
        panel2.add(button);
        panel2.add(button2);
        this.d.add((Component)panel, "Center");
        this.d.add((Component)panel2, "South");
        ((Component)this.d).setSize(500, 130);
        this.d.addWindowListener(new 3());
        button.addActionListener(new 4());
        button2.addActionListener(new 5());
        this.url_tf.addActionListener(new 6());
        this.d.show();
    }

    private void removeRoot() {
        this.atvpanel.getATVgraphic().removeRoot();
    }

    private void removeRootTri() {
        this.atvpanel.getATVgraphic().removeRootTri();
    }

    private void switchColors() {
        this.atvpanel.getATVgraphic().switchColors();
    }

    private void viewAsNH() {
        if (this.atvpanel.getATVgraphic().getTree() == null) {
            return;
        }
        if (this.atvpanel.getATVgraphic().getTree().isEmpty()) {
            return;
        }
        String string = this.atvpanel.getATVgraphic().getTree().toNewHampshire(false);
        new Message((Frame)this, "ATV: Tree as NH", string);
    }

    private void viewAsNHX() {
        if (this.atvpanel.getATVgraphic().getTree() == null) {
            return;
        }
        if (this.atvpanel.getATVgraphic().getTree().isEmpty()) {
            return;
        }
        String string = this.atvpanel.getATVgraphic().getTree().toNewHampshireX();
        new Message((Frame)this, "ATV: Tree as NHX", string);
    }

    private final class 1
    extends WindowAdapter {
        /* synthetic */ 1() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            ATVappletFrame.this.close();
        }
    }

    private final class 2
    extends ComponentAdapter {
        /* synthetic */ 2() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            ATVappletFrame.this.atvpanel.getATVgraphic().setParametersForPainting(ATVappletFrame.this.atvpanel.getATVgraphic().getSize().width, ATVappletFrame.this.atvpanel.getATVgraphic().getSize().height);
        }
    }

    private final class 3
    extends WindowAdapter {
        /* synthetic */ 3() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            ATVappletFrame.this.d.dispose();
        }
    }

    private final class 4
    implements ActionListener {
        /* synthetic */ 4() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ATVappletFrame.this.doOpenURL(ATVappletFrame.this.url_tf.getText());
            ATVappletFrame.this.d.dispose();
        }
    }

    private final class 5
    implements ActionListener {
        /* synthetic */ 5() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ATVappletFrame.this.d.dispose();
        }
    }

    private final class 6
    implements ActionListener {
        /* synthetic */ 6() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ATVappletFrame.this.doOpenURL(ATVappletFrame.this.url_tf.getText());
            ATVappletFrame.this.d.dispose();
        }
    }

    private final class 7
    extends WindowAdapter {
        /* synthetic */ 7() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            ATVappletFrame.this.d.dispose();
        }
    }

    private final class 8
    implements ActionListener {
        /* synthetic */ 8() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ATVappletFrame.this.d.dispose();
        }
    }
}

