/*
 * Decompiled with CFR 0.152.
 */
package forester.tree;

import java.io.Serializable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class Node
implements Serializable {
    static final long serialVersionUID = -896584903030L;
    public static final double DISTANCE_DEFAULT = -99.0;
    public static final int BOOTSTRAP_DEFAULT = -99;
    public static final int TAXO_ID_DEFAULT = 0;
    public static final double DISTANCE_NULL = -100.0;
    private static int node_count;
    private int id;
    private int taxo_id = 0;
    private int bootstrap = -99;
    private int sum_ext_nodes;
    private int indicator;
    private int x;
    private int y;
    private boolean duplication = false;
    private String seq_name = "";
    private String ec_number = "";
    private String species = "";
    private String orig_seq_name = "";
    private double distance_parent = -99.0;
    private double lnL_on_parent_branch;
    private boolean lnL_on_parent_branch_assigned = false;
    private boolean significantly_worse = true;
    private double bl_of_seq_on_parent_branch = -99.0;
    private boolean duplication_or_spec_assigned = false;
    private boolean collapse = false;
    private Node next_ext_node;
    private Node prev_ext_node;
    private Node child1;
    private Node child2;
    private Node parent;
    private Node link;
    private Vector vector;

    public Node() {
    }

    public Node(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() >= 1) {
            if (!string.startsWith(":")) {
                this.setSeqName(stringTokenizer.nextToken());
                this.setOrigSeqName(this.getSeqName());
            }
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (string.startsWith("S=")) {
                    this.setSpecies(string.substring(2));
                    continue;
                }
                if (string.startsWith("E=")) {
                    this.setECnumber(string.substring(2));
                    continue;
                }
                if (string.startsWith("L=")) {
                    this.setLnLonParentBranch(Double.valueOf(string.substring(2)));
                    continue;
                }
                if (string.startsWith("Bp=")) {
                    this.setBlOfSeqOnParentBranch(Double.valueOf(string.substring(3)));
                    continue;
                }
                if (string.startsWith("D=")) {
                    if (string.charAt(2) == 'Y') {
                        this.setDuplication(true);
                        continue;
                    }
                    if (string.charAt(2) == 'N') {
                        this.setDuplication(false);
                        continue;
                    }
                    throw new Exception("Node( String ): Error in NHX format: :D=Y or :D=N");
                }
                if (string.startsWith("Sw=")) {
                    if (string.charAt(3) == 'Y') {
                        this.setSignificantlyWorse(true);
                        continue;
                    }
                    if (string.charAt(3) == 'N') {
                        this.setSignificantlyWorse(false);
                        continue;
                    }
                    throw new Exception("Node( String ): Error in NHX format: :Sw=Y or :Sw=N");
                }
                if (string.startsWith("B=")) {
                    this.setBootstrap(Integer.parseInt(string.substring(2)));
                    continue;
                }
                if (string.startsWith("T=")) {
                    this.setTaxonomyID(Integer.parseInt(string.substring(2)));
                    continue;
                }
                if (this.distance_parent != -99.0) {
                    throw new Exception("Node( String ): Error in NHX format: No more than one distance to parent.");
                }
                this.setDistanceToParent(Double.valueOf(string));
            }
        }
        this.setID(node_count);
        ++node_count;
        this.setSumExtNodes(1);
    }

    void addExtNode(String string) throws Exception {
        Node node = this.getLastExtNode();
        node.setNextExtNode(new Node(string));
        node.getNextExtNode().setPrevExtNode(node);
    }

    public boolean collapse() {
        return this.collapse;
    }

    public static boolean compareArraysOfNodes(Node[] nodeArray, Node[] nodeArray2) throws Exception {
        if (nodeArray.length != nodeArray2.length) {
            return false;
        }
        Node[] nodeArray3 = new Node[nodeArray2.length];
        int n = 0;
        while (n < nodeArray2.length) {
            nodeArray3[n] = nodeArray2[n].copyNodeData();
            ++n;
        }
        n = 0;
        while (n < nodeArray.length) {
            block5: {
                int n2 = 0;
                while (n2 < nodeArray3.length) {
                    if (!nodeArray[n].equals(nodeArray2[n2])) {
                        ++n2;
                        continue;
                    }
                    break block5;
                }
                return false;
            }
            nodeArray3[n2] = null;
            ++n;
        }
        return true;
    }

    public static boolean compareSeqNamesInArraysOfNodes(Node[] nodeArray, Node[] nodeArray2) throws Exception {
        if (nodeArray.length != nodeArray2.length) {
            return false;
        }
        int n = 0;
        while (n < nodeArray.length) {
            block4: {
                int n2 = 0;
                while (n2 < nodeArray2.length) {
                    if (!nodeArray[n].getSeqName().trim().equals(nodeArray2[n2].getSeqName().trim()) || nodeArray[n].getTaxonomyID() != nodeArray2[n2].getTaxonomyID()) {
                        ++n2;
                        continue;
                    }
                    break block4;
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    void connect(String string) throws Exception {
        Node node;
        Node node2 = this.getLastExtNode();
        Node node3 = node2.getRoot();
        while (node3 == (node = (node2 = node2.getPrevExtNode()).getRoot())) {
        }
        node3.setParent(new Node(string));
        node.setParent(node3.getParent());
        node3.getParent().setChild1(node);
        node3.getParent().setChild2(node3);
        node3.getParent().setSumExtNodes(node3.getSumExtNodes() + node.getSumExtNodes());
    }

    /*
     * Unable to fully structure code
     */
    public Node[] copyAllExtChildren() throws Exception {
        block4: {
            var1_1 = 1;
            var3_2 = this;
            var4_3 = this;
            if (!this.isExternal()) ** GOTO lbl8
            var5_4 = new Node[]{this.copyNodeData()};
            break block4;
lbl-1000:
            // 1 sources

            {
                var3_2 = var3_2.getChild1();
lbl8:
                // 2 sources

                ** while (!var3_2.isExternal())
            }
lbl9:
            // 2 sources

            while (!var4_3.isExternal()) {
                var4_3 = var4_3.getChild2();
            }
            var2_5 = var3_2;
            do {
                var2_5 = var2_5.getNextExtNode();
                ++var1_1;
            } while (var2_5 != var4_3);
            var5_4 = new Node[var1_1];
            var2_5 = var3_2;
            var1_1 = 0;
            while (var1_1 < var5_4.length) {
                var5_4[var1_1] = var2_5.copyNodeData();
                var2_5 = var2_5.getNextExtNode();
                ++var1_1;
            }
        }
        return var5_4;
    }

    public Node copyNodeData() {
        Node node = null;
        try {
            node = new Node("");
        }
        catch (Exception exception) {
            System.err.println("\nNode: copyNodeData(): Unexpected ");
            System.err.println("exception :" + exception);
            System.err.println("\nTerminating.");
            System.exit(-1);
        }
        --node_count;
        node.id = this.id;
        node.bootstrap = this.bootstrap;
        node.sum_ext_nodes = this.sum_ext_nodes;
        node.indicator = this.indicator;
        node.x = this.x;
        node.y = this.y;
        node.duplication = this.duplication;
        node.seq_name = this.seq_name;
        node.ec_number = this.ec_number;
        node.species = this.species;
        node.taxo_id = this.taxo_id;
        node.orig_seq_name = this.orig_seq_name;
        node.distance_parent = this.distance_parent;
        node.lnL_on_parent_branch = this.lnL_on_parent_branch;
        node.lnL_on_parent_branch_assigned = this.lnL_on_parent_branch_assigned;
        node.bl_of_seq_on_parent_branch = this.bl_of_seq_on_parent_branch;
        node.significantly_worse = this.significantly_worse;
        node.duplication_or_spec_assigned = this.duplication_or_spec_assigned;
        node.collapse = this.collapse;
        node.link = this.link;
        node.vector = this.vector;
        return node;
    }

    static Node copyTree(Node node) {
        if (node == null) {
            return null;
        }
        Node node2 = node.copyNodeData();
        node2.child1 = Node.copyTree(node.child1);
        node2.child2 = Node.copyTree(node.child2);
        return node2;
    }

    static void decreaseNodeCount() {
        --node_count;
    }

    public void deleteData() {
        this.setDistanceToParent(-99.0);
        this.setBootstrap(-99);
        this.duplication = false;
        this.seq_name = "";
        this.ec_number = "";
        this.species = "";
        this.orig_seq_name = "";
        this.lnL_on_parent_branch = 0.0;
        this.taxo_id = 0;
        this.significantly_worse = true;
        this.setBlOfSeqOnParentBranch(-99.0);
        this.lnL_on_parent_branch_assigned = false;
        this.duplication_or_spec_assigned = false;
        this.link = null;
        this.vector = null;
    }

    public boolean equals(Node node) {
        return node != null && this.getSeqName().trim().equals(node.getSeqName().trim()) && this.getSpecies().trim().equals(node.getSpecies().trim()) && this.getECnumber().trim().equals(node.getECnumber().trim()) && this.getTaxonomyID() == node.getTaxonomyID();
    }

    public Vector getAllChildren() {
        Vector<Node> vector = new Vector<Node>();
        if (this.isExternal()) {
            return null;
        }
        Node node = this;
        while (!node.isExternal()) {
            node = node.getChild1();
        }
        Node node2 = this;
        while (!node2.isExternal()) {
            node2 = node2.getChild2();
        }
        this.setIndicatorsToZero();
        do {
            Node node3 = node;
            do {
                if (node3.getIndicator() != 0) continue;
                node3.setIndicator(1);
                if (node3.isPseudoNode() || node3 == this) continue;
                vector.addElement(node3);
            } while ((node3 = node3.getParent()) != this);
        } while ((node = node.getNextExtNode()) != null && node.getPrevExtNode() != node2);
        vector.trimToSize();
        return vector;
    }

    public Vector getAllExternalChildren() {
        Vector<Node> vector = new Vector<Node>();
        if (this.isExternal()) {
            vector.addElement(this);
            vector.trimToSize();
            return vector;
        }
        Node node = this;
        while (!node.isExternal()) {
            node = node.getChild1();
        }
        Node node2 = this;
        while (!node2.isExternal()) {
            node2 = node2.getChild2();
        }
        do {
            vector.addElement(node);
        } while ((node = node.getNextExtNode()) != node2);
        vector.addElement(node);
        vector.trimToSize();
        return vector;
    }

    public double getBlOfSeqOnParentBranch() {
        return this.bl_of_seq_on_parent_branch;
    }

    public int getBootstrap() {
        return this.bootstrap;
    }

    public Node getChild1() {
        return this.child1;
    }

    public Node getChild2() {
        return this.child2;
    }

    public double getDistanceToParent() {
        return this.distance_parent;
    }

    public String getECnumber() {
        return this.ec_number;
    }

    public int getID() {
        return this.id;
    }

    public int getIndicator() {
        return this.indicator;
    }

    Node getLastExtNode() {
        Node node = this;
        while (!node.isExternal()) {
            node = node.getChild1();
        }
        while (node.getNextExtNode() != null) {
            node = node.getNextExtNode();
        }
        return node;
    }

    public Node getLink() {
        return this.link;
    }

    public double getLnLonParentBranch() {
        return this.lnL_on_parent_branch;
    }

    public Node getNextExtNode() {
        return this.next_ext_node;
    }

    public static int getNodeCount() {
        return node_count;
    }

    public String getOrigSeqName() {
        return this.orig_seq_name;
    }

    public Node getParent() {
        return this.parent;
    }

    public Node getPrevExtNode() {
        return this.prev_ext_node;
    }

    Node getRoot() {
        Node node = this;
        while (!node.isRoot()) {
            node = node.getParent();
        }
        return node;
    }

    public String getSeqName() {
        return this.seq_name;
    }

    public String getSpecies() {
        return this.species;
    }

    public int getSumExtNodes() {
        return this.sum_ext_nodes;
    }

    public int getTaxonomyID() {
        return this.taxo_id;
    }

    public Vector getVector() {
        return this.vector;
    }

    public int getXcoord() {
        return this.x;
    }

    public int getYcoord() {
        return this.y;
    }

    public static void increaseNodeCount() {
        ++node_count;
    }

    public boolean isChild1() {
        return this.getParent() != null && this.getParent().getChild2() != this;
    }

    public boolean isDuplication() {
        return this.duplication;
    }

    public boolean isDuplicationOrSpecAssigned() {
        return this.duplication_or_spec_assigned;
    }

    public boolean isExternal() {
        return this.getChild1() == null;
    }

    public boolean isLnLonParentBranchAssigned() {
        return this.lnL_on_parent_branch_assigned;
    }

    public boolean isPseudoNode() {
        return this.getDistanceToParent() == -100.0;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public void preorderPrint() {
        System.out.println(String.valueOf(this) + "\n");
        if (this.getChild1() != null) {
            this.getChild1().preorderPrint();
        }
        if (this.getChild2() != null) {
            this.getChild2().preorderPrint();
        }
    }

    public void setBlOfSeqOnParentBranch(double d) {
        if (d < 0.0 && d != -99.0) {
            this.bl_of_seq_on_parent_branch = 0.0;
            System.err.print("Node: setBlOfSeqOnParentBranch( double ): WARNING: Negative ");
            System.err.println("branch length has been replaced by branch length 0.0.");
            return;
        }
        this.bl_of_seq_on_parent_branch = d;
    }

    public void setBootstrap(int n) {
        if (n < 0 && n != -99) {
            this.bootstrap = 0;
            System.err.print("Node: setBootstrap( int ): WARNING: Negative ");
            System.err.println("bootstrap has been replaced by bootstrap 0!\n");
            return;
        }
        this.bootstrap = n;
    }

    public void setChild1(Node node) {
        this.child1 = node;
    }

    public void setChild2(Node node) {
        this.child2 = node;
    }

    public void setCollapse(boolean bl) {
        this.collapse = bl;
    }

    public void setDistanceToParent(double d) {
        if (d < 0.0 && d != -99.0 && d != -100.0) {
            this.distance_parent = 0.0;
            return;
        }
        this.distance_parent = d;
    }

    public void setDuplication(boolean bl) {
        this.duplication = bl;
        this.setDuplicationOrSpecAssigned(true);
    }

    public void setDuplicationOrSpecAssigned(boolean bl) {
        this.duplication_or_spec_assigned = bl;
    }

    public void setECnumber(String string) {
        this.ec_number = string;
    }

    public void setID(int n) {
        this.id = n;
    }

    public void setIndicator(int n) {
        this.indicator = n;
    }

    void setIndicatorsToZero() {
        Stack<Node> stack = new Stack<Node>();
        Node node = this;
        stack.push(node);
        while (!stack.empty()) {
            node = (Node)stack.pop();
            node.setIndicator(0);
            if (node.getChild1() != null) {
                stack.push(node.getChild1());
            }
            if (node.getChild2() == null) continue;
            stack.push(node.getChild2());
        }
    }

    public void setLink(Node node) {
        this.link = node;
    }

    public void setLnLonParentBranch(double d) {
        this.lnL_on_parent_branch = d;
        this.setLnLonParentBranchAssigned(true);
    }

    public void setLnLonParentBranchAssigned(boolean bl) {
        this.lnL_on_parent_branch_assigned = bl;
    }

    public void setNextExtNode(Node node) {
        this.next_ext_node = node;
    }

    public static void setNodeCount(int n) {
        node_count = n;
    }

    public void setOrigSeqName(String string) {
        this.orig_seq_name = string;
    }

    public void setParent(Node node) {
        this.parent = node;
    }

    void setParents() {
        if (this.isExternal()) {
            return;
        }
        Node node = this;
        Node node2 = null;
        boolean bl = false;
        this.setIndicatorsToZero();
        while (!bl) {
            if (node == this && this.getIndicator() == 2) {
                bl = true;
                continue;
            }
            if (node.getIndicator() == 0 && !node.isExternal()) {
                node.setParent(node2);
                node2 = node;
                node.setIndicator(1);
                node = node.getChild1();
                continue;
            }
            if (node.getIndicator() == 1 && !node.isExternal()) {
                node2 = node;
                node.setIndicator(2);
                node = node.getChild2();
                continue;
            }
            if (node.getIndicator() == 2 && !node.isExternal()) {
                node = node.getParent();
                continue;
            }
            if (!node.isExternal()) continue;
            node.setParent(node2);
            node = node2;
        }
    }

    public void setPrevExtNode(Node node) {
        this.prev_ext_node = node;
    }

    public void setSeqName(String string) {
        this.seq_name = string;
    }

    public void setSignificantlyWorse(boolean bl) {
        this.significantly_worse = bl;
    }

    public void setSpecies(String string) {
        this.species = string;
    }

    public void setSumExtNodes(int n) {
        this.sum_ext_nodes = n;
    }

    public void setTaxonomyID(int n) {
        this.taxo_id = n;
    }

    public void setVector(Vector vector) {
        this.vector = vector;
    }

    public void setXcoord(int n) {
        this.x = n;
    }

    public void setYcoord(int n) {
        this.y = n;
    }

    public boolean significantlyWorse() {
        return this.significantly_worse;
    }

    String toNewHampshireX() {
        String string = "";
        if (!this.getSeqName().equals("")) {
            string = String.valueOf(string) + this.getSeqName();
        }
        if (this.getDistanceToParent() >= 0.0) {
            string = String.valueOf(string) + ":" + this.getDistanceToParent();
        }
        if (!this.getSpecies().equals("")) {
            string = String.valueOf(string) + ":S=" + this.getSpecies();
        }
        if (this.getTaxonomyID() > 0) {
            string = String.valueOf(string) + ":T=" + this.getTaxonomyID();
        }
        if (!this.getECnumber().equals("")) {
            string = String.valueOf(string) + ":E=" + this.getECnumber();
        }
        if (this.isLnLonParentBranchAssigned()) {
            string = String.valueOf(string) + ":L=" + this.getLnLonParentBranch();
            string = this.significantlyWorse() ? String.valueOf(string) + ":Sw=Y" : String.valueOf(string) + ":Sw=N";
        }
        if (this.getBlOfSeqOnParentBranch() >= 0.0) {
            string = String.valueOf(string) + ":Bp=" + this.getBlOfSeqOnParentBranch();
        }
        if (!this.isExternal()) {
            if (this.isDuplicationOrSpecAssigned()) {
                string = this.isDuplication() ? String.valueOf(string) + ":D=Y" : String.valueOf(string) + ":D=N";
            }
            if (this.getBootstrap() >= 0) {
                string = String.valueOf(string) + ":B=" + this.getBootstrap();
            }
        }
        return string;
    }

    public String toString() {
        String string = "";
        string = !this.isPseudoNode() ? "\nSeq name                : " + this.getSeqName() : "\nSeq name                :  *pseudo node*";
        string = String.valueOf(string) + "\nEC number               : " + this.getECnumber();
        string = String.valueOf(string) + "\nSpecies                 : " + this.getSpecies();
        string = this.getTaxonomyID() > 0 ? String.valueOf(string) + "\nTaxonomy ID             : " + this.getTaxonomyID() : String.valueOf(string) + "\nTaxonomy ID             : n/a";
        string = !this.isPseudoNode() && this.getDistanceToParent() != -99.0 ? String.valueOf(string) + "\nDistance to parent      : " + this.getDistanceToParent() : String.valueOf(string) + "\nDistance to parent      : n/a";
        string = this.getBootstrap() != -99 ? String.valueOf(string) + "\nBootstrap value         : " + this.getBootstrap() : String.valueOf(string) + "\nBootstrap value         : n/a";
        string = this.isLnLonParentBranchAssigned() ? String.valueOf(string) + "\nlnL on parent branch    : " + this.getLnLonParentBranch() : String.valueOf(string) + "\nlnL on parent branch    : n/a";
        string = String.valueOf(string) + "\nL: Significantly worse  : " + this.significantlyWorse();
        string = this.getBlOfSeqOnParentBranch() != -99.0 ? String.valueOf(string) + "\nBl of seq on parent br  : " + this.getBlOfSeqOnParentBranch() : String.valueOf(string) + "\nBl of seq on parent br  : n/a";
        string = this.isDuplicationOrSpecAssigned() ? String.valueOf(string) + "\nDuplication             : " + this.isDuplication() : String.valueOf(string) + "\nDuplication             : n/a";
        string = String.valueOf(string) + "\nOrig seq name\t        : " + this.getOrigSeqName();
        string = String.valueOf(string) + "\nSum of ext nodes\t: " + this.getSumExtNodes();
        string = String.valueOf(string) + "\nID                      : " + this.getID();
        string = !this.isRoot() ? String.valueOf(string) + "\nID of parent            : " + this.getParent().getID() : String.valueOf(string) + "\nID of parent            : n/a (root or pseudo root)";
        if (!this.isExternal()) {
            string = String.valueOf(string) + "\nID of child1            : " + this.getChild1().getID();
            string = String.valueOf(string) + "\nID of child2            : " + this.getChild2().getID();
        } else {
            string = String.valueOf(string) + "\nID of child             : n/a (external node)";
        }
        string = String.valueOf(string) + "\n";
        return string;
    }
}

