/*
 * Decompiled with CFR 0.152.
 */
package forester.tree;

import forester.tree.Node;
import forester.tree.PreorderTreeIterator;
import forester.tree.Tree;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Random;

public class TreeHelper {
    public static boolean checkCommas(String string) {
        int n = 0;
        while (n <= string.length() - 2) {
            if (string.charAt(n) == '(' && string.charAt(n + 1) == ')' || string.charAt(n) != ',' && string.charAt(n) != '(' && string.charAt(n + 1) == '(' || string.charAt(n) == ',' && string.charAt(n + 1) == ',' || string.charAt(n) == '(' && string.charAt(n + 1) == ',' || string.charAt(n) == ',' && string.charAt(n + 1) == ')') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String checkForUnnessaryParentheses(String string, int n) {
        int n2 = 1;
        while (n2 <= n) {
            int n3 = 0;
            while (n3 <= string.length() - 1) {
                if (string.charAt(n3) == '(') {
                    int n4 = n3 + 1;
                    while (string.charAt(n4) != ',' && string.charAt(n4) != '(') {
                        if (string.charAt(n4) == ')') {
                            return "Error in NH/X: Unnecessary parentheses at positions " + n3 + " and " + n4 + ".";
                        }
                        ++n4;
                    }
                    if (string.charAt(n3 + 1) == '(') {
                        int n5 = 1;
                        int n6 = 2;
                        n4 = n3 + 2;
                        int n7 = n3 + 2;
                        int n8 = 1;
                        boolean bl = true;
                        while (n5 != 0) {
                            if (string.charAt(n4) == '(') {
                                ++n5;
                            }
                            if (string.charAt(n4) == ')') {
                                --n5;
                            }
                            ++n4;
                        }
                        int n9 = n4;
                        while (n9 <= string.length() - 1 && string.charAt(n9) != ')') {
                            if (string.charAt(n9) == ',' || string.charAt(n9) == '(') {
                                n8 = 1;
                                bl = false;
                                break;
                            }
                            ++n8;
                            ++n9;
                        }
                        if (bl) {
                            while (n6 != 0) {
                                if (string.charAt(n7) == '(') {
                                    ++n6;
                                }
                                if (string.charAt(n7) == ')') {
                                    --n6;
                                }
                                ++n7;
                            }
                            if (n4 == n7 - n8) {
                                return "Error in NH/X: Unnecessary parentheses at " + n3 + " and " + (n4 + n8 - 1) + ".";
                            }
                        }
                    }
                }
                ++n3;
            }
            ++n2;
        }
        return "";
    }

    public static String checkNHformat(String string) {
        String string2 = "";
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer = TreeHelper.removeWhiteSpace(stringBuffer);
        stringBuffer = TreeHelper.removeCstyleComments(stringBuffer);
        while (stringBuffer.length() >= 1 && stringBuffer.charAt(0) != '(' && stringBuffer.toString().indexOf("(") != -1) {
            stringBuffer = new StringBuffer(stringBuffer.toString().substring(1));
        }
        if (stringBuffer.length() >= 1 && stringBuffer.charAt(stringBuffer.length() - 1) == ';') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        if ((n = TreeHelper.countAndCheckParantheses(string = stringBuffer.toString())) <= -1) {
            return "Openparantheses != closeparantheses.";
        }
        if (!TreeHelper.checkCommas(string)) {
            return "Commas not properly set.";
        }
        string2 = TreeHelper.checkForUnnessaryParentheses(string, n);
        if (string2.length() >= 1) {
            return string2;
        }
        return "";
    }

    public static void cleanSpeciesNamesInExtNodes(Tree tree) {
        Node node = tree.getExtNode0();
        String string = "";
        int n = 0;
        while (node != null) {
            string = node.getSpecies().trim();
            if (string.length() > 0) {
                n = string.indexOf("/");
                if (n >= 0) {
                    string = string.substring(0, n);
                }
                if ((n = string.indexOf("_")) >= 0) {
                    string = string.substring(0, n);
                }
                if ((n = string.indexOf("-")) >= 0) {
                    string = string.substring(0, n);
                }
                if ((n = string.indexOf("\\")) >= 0) {
                    string = string.substring(0, n);
                }
                if ((n = string.indexOf(";")) >= 0) {
                    string = string.substring(0, n);
                }
                if ((n = string.indexOf(".")) >= 0) {
                    string = string.substring(0, n);
                }
                if (string.length() > 5) {
                    string = string.substring(0, 5);
                }
                string = string.toUpperCase();
                node.setSpecies(string);
            }
            node = node.getNextExtNode();
        }
    }

    public static int countAndCheckParantheses(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 <= string.length() - 1) {
            if (string.charAt(n3) == '(') {
                ++n;
            }
            if (string.charAt(n3) == ')') {
                ++n2;
            }
            ++n3;
        }
        if (n2 != n) {
            return -1;
        }
        return n;
    }

    public static Tree createBalancedTree(int n) {
        Tree tree = null;
        Tree tree2 = null;
        try {
            tree = new Tree("(:S=,:S=)");
            tree.setRooted(true);
            int n2 = 1;
            while (n2 < n) {
                tree2 = tree.copyTree();
                tree = tree.fuseTrees(tree.getRoot().getID(), tree2);
                ++n2;
            }
        }
        catch (Exception exception) {
            System.err.println("Unexpected exception during \"createBalancedTree\":");
            System.err.println(exception.toString());
            System.exit(-1);
        }
        return tree;
    }

    public static Tree createUnbalancedTree(int n) {
        Tree tree = null;
        try {
            tree = new Tree(":S=");
            tree.setRooted(true);
            int n2 = 1;
            while (n2 < n) {
                tree.addNodeAndConnect("", "");
                ++n2;
            }
            tree.setRoot(tree.getExtNode0().getRoot());
            tree.calculateMostBranchesPerExtNode();
            tree.calculateLongestDistance();
            tree.calculateNumberOfBranches();
        }
        catch (Exception exception) {
            System.err.println("Unexpected exception during \"createUnbalancedTree\":");
            System.err.println(exception.toString());
            System.exit(-1);
        }
        return tree;
    }

    public static void extractSpeciesNameFromSPseqName(Tree tree) {
        PreorderTreeIterator preorderTreeIterator = null;
        int n = 0;
        try {
            preorderTreeIterator = new PreorderTreeIterator(tree);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Could not create iterator. Terminating.");
            System.exit(-1);
        }
        String string = "";
        while (!preorderTreeIterator.isDone()) {
            if (preorderTreeIterator.currentNode().getSpecies().trim().length() < 1 && (n = (string = preorderTreeIterator.currentNode().getSeqName()).indexOf("_")) >= 0) {
                string.trim();
                string = string.substring(n + 1);
                n = string.indexOf("/");
                if (n >= 0) {
                    string = string.substring(0, n);
                }
                if ((n = string.indexOf("_")) >= 0) {
                    string = string.substring(0, n);
                }
                if ((n = string.indexOf("-")) >= 0) {
                    string = string.substring(0, n);
                }
                if ((n = string.indexOf("\\")) >= 0) {
                    string = string.substring(0, n);
                }
                if ((n = string.indexOf(";")) >= 0) {
                    string = string.substring(0, n);
                }
                if ((n = string.indexOf(".")) >= 0) {
                    string = string.substring(0, n);
                }
                if (string.length() > 5) {
                    string = string.substring(0, 5);
                }
                string = string.toUpperCase();
                preorderTreeIterator.currentNode().setSpecies(string);
            }
            preorderTreeIterator.next();
        }
    }

    public static void intervalNumberSpecies(Tree tree, int n) {
        if (tree == null || tree.isEmpty()) {
            return;
        }
        Node node = tree.getExtNode0();
        int n2 = 1;
        boolean bl = true;
        while (node != null) {
            if (bl) {
                node.setSpecies(String.valueOf(n2));
            } else {
                node.setSpecies(String.valueOf(n2 + n));
                ++n2;
            }
            bl = !bl;
            node = node.getNextExtNode();
        }
    }

    public static boolean isEmpty(StringBuffer stringBuffer) {
        return stringBuffer.length() < 1;
    }

    public static void numberSpeciesInDescOrder(Tree tree) {
        if (tree == null || tree.isEmpty()) {
            return;
        }
        Node node = tree.getExtNode0();
        int n = tree.getRoot().getSumExtNodes();
        while (node != null) {
            node.setSpecies(String.valueOf(n));
            --n;
            node = node.getNextExtNode();
        }
    }

    public static void numberSpeciesInOrder(Tree tree) {
        if (tree == null || tree.isEmpty()) {
            return;
        }
        Node node = tree.getExtNode0();
        int n = 1;
        while (node != null) {
            node.setSpecies(String.valueOf(n));
            ++n;
            node = node.getNextExtNode();
        }
    }

    public static void randomizeSpecies(int n, int n2, Tree tree) {
        if (tree == null || tree.isEmpty()) {
            return;
        }
        int n3 = Math.abs(n);
        int n4 = Math.abs(n2);
        Random random = new Random();
        Node node = tree.getExtNode0();
        while (node != null) {
            node.setSpecies(String.valueOf(Math.abs(random.nextInt()) % (n4 - n3 + 1) + n3));
            node = node.getNextExtNode();
        }
    }

    public static Tree[] readMultipleNHTrees(File file) throws Exception {
        int n = 0;
        int n2 = 0;
        String string = "";
        String string2 = "";
        Tree[] treeArray = null;
        if (!file.exists()) {
            throw new IOException(String.valueOf(file.getAbsolutePath()) + " does not exist.");
        }
        if (!file.isFile()) {
            throw new IOException(String.valueOf(file.getAbsolutePath()) + " is not a file.");
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.indexOf(";") == -1) continue;
            ++n;
        }
        bufferedReader.close();
        treeArray = new Tree[n];
        string = "";
        BufferedReader bufferedReader2 = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader2.readLine()) != null) {
            string2 = String.valueOf(string2) + string;
            if (string.indexOf(";") == -1) continue;
            treeArray[n2++] = new Tree(string2);
            string2 = "";
        }
        bufferedReader2.close();
        return treeArray;
    }

    public static Tree readNHtree(File file, boolean bl) throws Exception {
        String string = "";
        String string2 = "";
        String string3 = "";
        if (!file.exists()) {
            throw new IOException(String.valueOf(file.getAbsolutePath()) + " does not exist.");
        }
        if (!file.isFile()) {
            throw new IOException(String.valueOf(file.getAbsolutePath()) + " is not a file.");
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                string3 = String.valueOf(string3) + string2;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new Exception("readNHtree( File, boolean ): " + iOException);
        }
        if (bl && (string = TreeHelper.checkNHformat(string3)).length() >= 1) {
            throw new Exception("readNHtree( File, boolean ): " + string);
        }
        return new Tree(string3);
    }

    public static Tree readNHtree(URL uRL, boolean bl) throws Exception {
        String string = "";
        String string2 = "";
        String string3 = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string2 = bufferedReader.readLine()) != null) {
                string3 = String.valueOf(string3) + string2;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            throw new Exception("Tree: readNHtree( URL, boolean ): " + exception);
        }
        if (bl && (string = TreeHelper.checkNHformat(string3)).length() >= 1) {
            throw new Exception("readNHtree( URL, boolean ): " + string);
        }
        return new Tree(string3);
    }

    public static StringBuffer removeCstyleComments(StringBuffer stringBuffer) {
        int n = 0;
        while (n <= stringBuffer.length() - 2) {
            if (stringBuffer.charAt(n) == '/' && stringBuffer.charAt(n + 1) == '*') {
                int n2 = n;
                while (n <= stringBuffer.length() - 3 && (stringBuffer.charAt(n) != '*' || stringBuffer.charAt(n + 1) != '/')) {
                    ++n;
                }
                stringBuffer = new StringBuffer(String.valueOf(stringBuffer.toString().substring(0, n2)) + stringBuffer.toString().substring(n + 2));
                n = n2 - 1;
            }
            ++n;
        }
        return stringBuffer;
    }

    public static StringBuffer removeWhiteSpace(StringBuffer stringBuffer) {
        int n = 0;
        while (n <= stringBuffer.length() - 1) {
            if (stringBuffer.charAt(n) == ' ' || stringBuffer.charAt(n) == '\t' || stringBuffer.charAt(n) == '\n' || stringBuffer.charAt(n) == '\r') {
                stringBuffer = new StringBuffer(String.valueOf(stringBuffer.toString().substring(0, n)) + stringBuffer.toString().substring(n + 1));
                --n;
            }
            ++n;
        }
        return stringBuffer;
    }

    public static void writeNHtree(Tree tree, File file, boolean bl, boolean bl2, boolean bl3) throws Exception {
        if (tree.isEmpty()) {
            String string = "writeNHtree( Tree, File, boolean, boolean,";
            string = String.valueOf(string) + " boolean ): Tree must not be empty.";
            throw new Exception(string);
        }
        if (!(!file.exists() || bl2 && bl3)) {
            throw new Exception(String.valueOf(file.getAbsolutePath()) + " does already exist and is not allowed to be overwritten.");
        }
        if (file.exists() && !file.isFile()) {
            throw new Exception(String.valueOf(file.getAbsolutePath()) + " is not a file. Cannot be overwritten.");
        }
        String string = bl ? tree.toNewHampshireX() : tree.toNewHampshire(false);
        try {
            PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(file), true);
            printWriter.println(string);
            printWriter.close();
            return;
        }
        catch (Exception exception) {
            throw new Exception("writeNHtree( Tree, File, boolean, boolean, boolean ): " + exception);
        }
    }
}

