/*
 * Decompiled with CFR 0.152.
 */
package forester.atv;

import forester.atv.ATVgraphic;
import forester.atv.ATVmouseListener;
import forester.atv.ATVnodeFrame;
import forester.atv.ATVpanel_applet;
import forester.tree.Node;
import forester.tree.Tree;
import java.net.URL;

class ATVgraphic_applet
extends ATVgraphic {
    static final String SWISSPROT_URL_DE = "http://www.expasy.ch/cgi-bin/sprot-search-de?";
    static final String SWISSPROT_URL_AC = "http://www.expasy.ch/cgi-bin/sprot-search-ac?";
    static final int GO_TO_SWISSPROT = 2;
    private ATVpanel_applet atvpanel;

    ATVgraphic_applet(Tree tree, ATVpanel_applet aTVpanel_applet) {
        this.tree = tree;
        this.atvpanel = aTVpanel_applet;
        this.color_scheme = 1;
        this.setColors1();
        this.mediumFonts();
        this.setBackground(this.background_color);
        this.calculateLongestExtNodeInfo();
        this.addMouseListener(new ATVmouseListener(this));
        if (this.tree != null) {
            if (this.tree.getHighestLnL() != this.tree.getLowestLnL()) {
                this.setColorBranchesAccToLnL(true);
            }
            if (this.tree.getExtNode0() != null) {
                if (this.tree.getExtNode0().getDistanceToParent() == -99.0) {
                    this.setUseRealBranchLenghts(false);
                } else {
                    this.setUseRealBranchLenghts(true);
                }
                if (this.tree.getExtNode0().getParent() != null) {
                    if (this.tree.getExtNode0().getParent().getBootstrap() == -99) {
                        this.setWriteBootstrapValues(false);
                        return;
                    }
                    this.setWriteBootstrapValues(true);
                }
            }
        }
    }

    public void MouseClicked(int n, int n2) {
        Node node = this.findNode(n, n2);
        if (node != null) {
            if (this.action_when_node_clicked == 1) {
                this.collapse(node);
                return;
            }
            if (this.action_when_node_clicked == 2) {
                this.goToSwissProt(node);
                return;
            }
            if (this.action_when_node_clicked == 3) {
                this.reRoot(node);
                return;
            }
            if (this.action_when_node_clicked == 4) {
                this.subTree(node);
                return;
            }
            if (this.action_when_node_clicked == 5) {
                this.swap(node);
                return;
            }
            this.i = 0;
            while (this.atvnodeframes[this.i] != null) {
                ++this.i;
            }
            this.atvnodeframes[this.i] = new ATVnodeFrame(node, this, this.i);
        }
    }

    void collapse(Node node) {
        if (!node.isExternal()) {
            node.setCollapse(!node.collapse());
            this.tree.adjustNodeCount();
            this.tree.recalculateAndReset();
            this.resetPreferredSize();
            this.atvpanel.adjustJScrollPane();
            this.repaint();
        }
    }

    void goToSwissProt(Node node) {
        String string = node.getOrigSeqName().trim();
        URL uRL = null;
        int n = string.indexOf("/");
        if (n > 10 || string.length() < 3 || !node.isExternal()) {
            return;
        }
        if (n > 0) {
            string = string.substring(0, n);
        }
        string = (string = string.replace(' ', '_')).indexOf("_") != -1 ? SWISSPROT_URL_DE + string : SWISSPROT_URL_AC + string;
        try {
            uRL = new URL(string);
        }
        catch (Exception exception) {
            System.err.println("ATVgraphic_applet: goToSwissProt( Node ): Could not create URL from: " + string + ". Exception: " + exception);
            exception.printStackTrace();
        }
        if (uRL != null) {
            try {
                this.atvpanel.getATVappletFrame().getATVapplet().go(uRL);
                return;
            }
            catch (Exception exception) {
                System.err.println("ATVgraphic_applet: goToSwissProt( Node ): " + exception);
                exception.printStackTrace();
                return;
            }
        }
    }

    void reRoot(Node node) {
        try {
            this.tree.reRoot(node);
            this.tree.adjustNodeCount();
            this.tree.recalculateAndReset();
        }
        catch (Exception exception) {
            System.err.println("ATVgraphic: reRoot( node ): " + exception);
        }
        this.resetPreferredSize();
        this.atvpanel.adjustJScrollPane();
        this.repaint();
    }

    void subTree(Node node) {
        if (!node.isExternal() && !node.isRoot() && this.j <= 49) {
            try {
                this.trees[this.j++] = this.tree;
                this.tree = this.tree.subTree(node.getID());
            }
            catch (Exception exception) {
                System.err.println("ATVgraphic: subTree( Node ): " + exception);
            }
        } else if (node.isRoot() && this.j >= 1) {
            try {
                this.trees[this.j] = null;
                this.tree = this.trees[--this.j];
            }
            catch (Exception exception) {
                System.err.println("ATVgraphic: subTree( Node ): " + exception);
            }
        }
        this.atvpanel.getATVcontrol().setCheckBoxes();
        this.atvpanel.getATVcontrol().showWhole();
    }
}

