/*
 * Decompiled with CFR 0.152.
 */
package forester.tree;

import forester.tree.Node;
import forester.tree.PreorderTreeIterator;
import forester.tree.TreeHelper;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class Tree
implements Serializable {
    static final int MAX_LENGTH = 10;
    static final long serialVersionUID = -6847390332113L;
    private Node ext_node0;
    private Node root;
    private double highest_lnL;
    private double lowest_lnL;
    private double longest_distance;
    private int number_of_branches;
    private int external_nodes;
    private int number_of_duplications = -1;
    private int most_branches_per_ext_node;
    private boolean rooted = false;
    private boolean more_than_bin_nodes_in_NH = true;
    private String name = "";
    private Hashtable idhash;
    private int j;

    public Tree() {
        this.ext_node0 = null;
        this.setRoot(null);
    }

    public Tree(String string) throws Exception {
        this.idhash = null;
        this.setRooted(false);
        boolean bl = true;
        String string2 = new String(":" + -100.0);
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer = TreeHelper.removeWhiteSpace(stringBuffer);
        stringBuffer = TreeHelper.removeCstyleComments(stringBuffer);
        while (stringBuffer.length() >= 1 && stringBuffer.charAt(0) != '(' && stringBuffer.toString().indexOf("(") != -1) {
            stringBuffer = new StringBuffer(stringBuffer.toString().substring(1));
        }
        if (stringBuffer.length() >= 1 && stringBuffer.charAt(stringBuffer.length() - 1) == ';') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        if (stringBuffer.length() >= 1 && stringBuffer.charAt(stringBuffer.length() - 1) != ')') {
            this.setRooted(true);
        }
        if (TreeHelper.countAndCheckParantheses(string = stringBuffer.toString()) <= -1) {
            String string3 = "Tree: Tree( String ): Error in NHX format: ";
            string3 = String.valueOf(string3) + "open parantheses != close parantheses.";
            throw new Exception(string3);
        }
        if (!TreeHelper.checkCommas(string)) {
            String string4 = "Tree: Tree( String ): Error in NHX format: ";
            string4 = String.valueOf(string4) + "Commas not properly set.";
            throw new Exception(string4);
        }
        if (string.length() < 1) {
            this.ext_node0 = null;
            this.setRoot(null);
        } else if (string.indexOf("(") != -1) {
            String string5 = "";
            String string6 = "";
            String string7 = "";
            Stack<String> stack = new Stack<String>();
            int n = 0;
            while (n <= string.length() - 1) {
                block52: {
                    if (string.charAt(n) == ',') {
                        stack.push(",");
                    }
                    if (string.charAt(n) == '(') {
                        stack.push("(");
                    }
                    if (string.charAt(n) != ',' && string.charAt(n) != '(' && string.charAt(n) != ')') {
                        stringBuffer = new StringBuffer("");
                        while (n <= string.length() - 1 && string.charAt(n) != ')' && string.charAt(n) != ',') {
                            stringBuffer.append(string.charAt(n));
                            ++n;
                        }
                        --n;
                        stack.push(stringBuffer.toString());
                    }
                    if (string.charAt(n) == ')') {
                        String string8 = "";
                        if (n <= string.length() - 2 && string.charAt(n + 1) != ')' && string.charAt(n + 1) != ',') {
                            ++n;
                            stringBuffer = new StringBuffer("");
                            while (n <= string.length() - 1 && string.charAt(n) != ')' && string.charAt(n) != ',') {
                                stringBuffer.append(string.charAt(n));
                                ++n;
                            }
                            --n;
                            string8 = stringBuffer.toString();
                        }
                        bl = true;
                        while (true) {
                            string7 = stack.pop().toString();
                            if (stack.empty()) {
                                if (!this.isEmpty()) {
                                    this.getExtNode0().connect(string8);
                                }
                                break block52;
                            }
                            string6 = stack.pop().toString();
                            if (stack.empty()) {
                                if (string7.equals("(")) {
                                    if (!this.isEmpty()) {
                                        this.getExtNode0().connect(string8);
                                    }
                                    stack.push("(");
                                    continue;
                                }
                                if (string7.equals(",")) {
                                    if (!this.isEmpty()) {
                                        this.getExtNode0().connect(string8);
                                    }
                                } else {
                                    this.addNodeAndConnect(string7, string8);
                                }
                                break block52;
                            }
                            string5 = stack.peek().toString();
                            if (!string5.equals("(") && string6.equals(",") && !string7.equals(",")) {
                                if (bl && !string5.equals(",")) {
                                    if (this.getExtNode0() == null) {
                                        Node node;
                                        this.ext_node0 = node = new Node(string7);
                                    } else {
                                        this.getExtNode0().addExtNode(string7);
                                    }
                                    ++this.external_nodes;
                                    stack.push(",");
                                } else {
                                    this.addNodeAndConnect(string7, string2);
                                }
                                bl = false;
                                continue;
                            }
                            bl = false;
                            if (string5.equals(",") && !string6.equals(",") && !string6.equals("(") && string7.equals(",")) {
                                this.addNodeAndConnect(string6, string2);
                                continue;
                            }
                            if (!string5.equals("(") && string6.equals(",") && string7.equals(",")) {
                                if (!this.isEmpty()) {
                                    this.getExtNode0().connect(string2);
                                }
                                stack.push(",");
                                continue;
                            }
                            if (string5.equals("(") && string6.equals(",") && !string7.equals("(") && !string7.equals(",")) {
                                this.addNodeAndConnect(string7, string8);
                                stack.pop();
                                break block52;
                            }
                            if (string5.equals("(") && !string6.equals("(") && !string6.equals(",") && string7.equals(",")) {
                                this.addNodeAndConnect(string6, string8);
                                stack.pop();
                                break block52;
                            }
                            if (string5.equals("(") && string6.equals(",") && string7.equals(",")) {
                                if (!this.isEmpty()) {
                                    this.getExtNode0().connect(string2);
                                }
                                if (!this.isEmpty()) {
                                    this.getExtNode0().connect(string8);
                                }
                                stack.pop();
                                break block52;
                            }
                            if (string5.equals(",") && string6.equals("(") && !string7.equals("(") && !string7.equals(",")) {
                                this.addNodeAndConnect(string7, string8);
                                break block52;
                            }
                            if (string5.equals(",") && string6.equals("(") && string7.equals(",")) {
                                if (!this.isEmpty()) {
                                    this.getExtNode0().connect(string8);
                                }
                                break block52;
                            }
                            if (string5.equals("(") && string6.equals("(") && !string7.equals("(")) {
                                if (string7.equals(",")) {
                                    if (!this.isEmpty()) {
                                        this.getExtNode0().connect(string8);
                                    }
                                } else {
                                    this.addNodeAndConnect(string7, string8);
                                }
                                break block52;
                            }
                            if (string7.equals("(") && (string5.equals("(") && string6.equals(",") || string5.equals(",") && string6.equals("(") || string5.equals("(") && string6.equals("("))) break;
                        }
                        if (!this.isEmpty()) {
                            this.getExtNode0().connect(string8);
                        }
                        stack.push("(");
                    }
                }
                ++n;
            }
        } else {
            if (this.getExtNode0() == null) {
                Node node;
                this.ext_node0 = node = new Node(string);
            } else {
                this.getExtNode0().addExtNode(string);
            }
            ++this.external_nodes;
            this.setRooted(true);
        }
        if (!this.isEmpty()) {
            this.setRoot(this.getExtNode0().getRoot());
            if (!this.isRooted()) {
                this.getRoot().deleteData();
            }
            this.calculateMostBranchesPerExtNode();
            this.findHighestLnL();
            this.findLowestLnL();
            this.calculateLongestDistance();
            this.calculateNumberOfBranches();
            if (this.areBranchLenghtsBootstraps()) {
                this.moveBranchLenghtsToBootstrap();
            }
        }
    }

    private double addDist(double d, double d2) {
        if (d >= 0.0 && d2 >= 0.0) {
            return d + d2;
        }
        if (d >= 0.0) {
            return d;
        }
        if (d2 >= 0.0) {
            return d2;
        }
        if (d == -100.0 && d2 == -100.0) {
            return -100.0;
        }
        return -99.0;
    }

    private void addNode(String string) throws Exception {
        if (this.getExtNode0() == null) {
            Node node;
            this.ext_node0 = node = new Node(string);
        } else {
            this.getExtNode0().addExtNode(string);
        }
        ++this.external_nodes;
    }

    void addNodeAndConnect(String string, String string2) throws Exception {
        if (this.getExtNode0() == null) {
            throw new Exception("addNodeAndConnect( String, String ): Error: Cannot add and connect one node to empty tree.");
        }
        this.getExtNode0().addExtNode(string);
        this.getExtNode0().connect(string2);
        ++this.external_nodes;
    }

    /*
     * Unable to fully structure code
     */
    private void adjustExtNode0() {
        var1_1 = this.getRoot();
        if (var1_1 != null) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.getChild1();
lbl5:
            // 2 sources

            ** while (!var1_1.isExternal())
        }
lbl6:
        // 1 sources

        this.ext_node0 = var1_1;
    }

    public void adjustNodeCount() {
        Node node;
        if (this.isEmpty()) {
            return;
        }
        Node node2 = this.getExtNode0();
        do {
            node = node2;
            do {
                node.setSumExtNodes(0);
            } while ((node = node.getParent()) != null);
        } while ((node2 = node2.getNextExtNode()) != null);
        node2 = this.ext_node0;
        block2: do {
            node = node2;
            do {
                if (node.collapse()) {
                    if (node.getIndicator() != -1234) {
                        node.setIndicator(-1234);
                    } else {
                        node2 = node2.getNextExtNode();
                        continue block2;
                    }
                }
                node.setSumExtNodes(node.getSumExtNodes() + 1);
            } while ((node = node.getParent()) != null);
            node2 = node2.getNextExtNode();
        } while (node2 != null);
    }

    private void adjustReferencesInExtNodes() {
        if (this.isEmpty()) {
            return;
        }
        this.getRoot().setIndicatorsToZero();
        Node node = this.getRoot();
        Node node2 = null;
        if (this.getNumberOfExtNodes() <= 1) {
            return;
        }
        do {
            if (node.getIndicator() == 0 && !node.isExternal()) {
                node.setIndicator(1);
                node = node.getChild1();
            }
            if (node.getIndicator() == 1 && !node.isExternal()) {
                node.setIndicator(2);
                node = node.getChild2();
            }
            if (node.isExternal()) {
                node.setNextExtNode(null);
                node.setPrevExtNode(node2);
                if (node2 != null) {
                    node2.setNextExtNode(node);
                }
                node2 = node;
                node.setIndicator(2);
            }
            if (node.getIndicator() != 2) continue;
            node = node.getParent();
        } while (!node.isRoot() || node.getIndicator() != 2);
    }

    private boolean allowMoreThanBinaryNodesInNHoutput() {
        return this.more_than_bin_nodes_in_NH;
    }

    public void allowMoreThanBinaryNodesInNHoutput(boolean bl) {
        this.more_than_bin_nodes_in_NH = bl;
    }

    public boolean areBranchLenghtsBootstraps() {
        if (this.isEmpty()) {
            return false;
        }
        if (this.getNumberOfExtNodes() <= 1) {
            return false;
        }
        if (this.getRoot().getBootstrap() != -99) {
            return false;
        }
        Node node = this.getExtNode0();
        double d = 0.0;
        double d2 = 0.0;
        while (node != null) {
            d = node.getDistanceToParent();
            if (d <= 0.0 || d % 10.0 != 0.0) {
                return false;
            }
            if ((node = node.getNextExtNode()) == null) continue;
            d2 = node.getDistanceToParent();
            if (d2 <= 0.0 || d2 % 10.0 != 0.0) {
                return false;
            }
            if (d == d2) continue;
            return false;
        }
        return true;
    }

    void calculateLongestDistance() {
        if (this.isEmpty()) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        Node node = this.getExtNode0();
        while (node != null) {
            Node node2 = node;
            while (node2 != null) {
                if (!node2.isRoot() && node2.getDistanceToParent() > 0.0) {
                    if (node2.collapse()) {
                        d2 = 0.0;
                    }
                    d2 += node2.getDistanceToParent();
                }
                node2 = node2.getParent();
            }
            node = node.getNextExtNode();
            if (d2 > d) {
                d = d2;
            }
            d2 = 0.0;
        }
        if (this.root.getDistanceToParent() > 0.0) {
            d += this.root.getDistanceToParent();
        }
        this.longest_distance = d;
    }

    void calculateMostBranchesPerExtNode() {
        if (this.isEmpty()) {
            return;
        }
        int n = 0;
        int n2 = 0;
        Node node = this.getExtNode0();
        while (node != null) {
            Node node2 = node;
            while (node2 != null) {
                if (!(node2.isRoot() || node2.getParent().isPseudoNode() || node2.isPseudoNode())) {
                    n = n - node2.getSumExtNodes() + node2.getParent().getSumExtNodes();
                }
                node2 = node2.getParent();
            }
            node = node.getNextExtNode();
            if (n > n2) {
                n2 = n;
            }
            n = 0;
        }
        this.most_branches_per_ext_node = n2;
    }

    public void calculateNumberOfBranches() {
        int n;
        if (this.isEmpty()) {
            return;
        }
        if (this.isRooted()) {
            int n2;
            this.number_of_branches = n2 = 2 * this.getNumberOfExtNodes() - 1 - this.countBranchesWithDISTANCE_NULL();
            return;
        }
        if (!(this.getRoot().isExternal() || this.getRoot().getChild1().isPseudoNode() || this.getRoot().getChild2().isPseudoNode())) {
            int n3;
            this.number_of_branches = n3 = 2 * this.getNumberOfExtNodes() - 3 - this.countBranchesWithDISTANCE_NULL();
            return;
        }
        this.number_of_branches = n = 2 * this.getNumberOfExtNodes() - 2 - this.countBranchesWithDISTANCE_NULL();
    }

    private void connectInternal(String string) throws Exception {
        if (this.isEmpty()) {
            return;
        }
        this.getExtNode0().connect(string);
    }

    public Tree copyBranchLengthValuesFrom(Tree tree) throws Exception {
        Node node;
        if (this.isEmpty() || tree.isEmpty()) {
            String string = "Tree: copyBranchLengthValuesFrom( Tree ): ";
            string = String.valueOf(string) + "Tree(s) must not be empty.";
            throw new Exception(string);
        }
        int n = 0;
        Tree tree2 = this.copyTree();
        tree2.setIndicatorsToZero();
        tree.setIndicatorsToZero();
        Node node2 = tree2.getExtNode0();
        while (node2 != null) {
            node = node2;
            while (node != null) {
                if (!node.isExternal()) {
                    node.setDistanceToParent(-100.0);
                }
                node = node.getParent();
            }
            node2 = node2.getNextExtNode();
        }
        node2 = tree.getExtNode0();
        while (node2 != null) {
            node = node2;
            while (node != null) {
                if (node.getIndicator() == 0 && !node.isPseudoNode()) {
                    node.setIndicator(1);
                    Node[] nodeArray = node.copyAllExtChildren();
                    Node node3 = nodeArray[0];
                    ++n;
                    Node node4 = tree2.getExtNode0();
                    while (node4 != null) {
                        Node node5 = node4;
                        if (node3.equals(node4)) {
                            while (node5 != null) {
                                if (node5.getIndicator() != n && node5.getIndicator() != -1) {
                                    node5.setIndicator(n);
                                    if (nodeArray.length == node5.getSumExtNodes()) {
                                        Node[] nodeArray2 = node5.copyAllExtChildren();
                                        if (Node.compareArraysOfNodes(nodeArray, nodeArray2)) {
                                            node5.setIndicator(-1);
                                            node5.setDistanceToParent(node.getDistanceToParent());
                                        } else {
                                            String string = "Trees were ";
                                            string = String.valueOf(string) + "not identical.";
                                            throw new Exception(string);
                                        }
                                    }
                                }
                                node5 = node5.getParent();
                            }
                        }
                        node4 = node4.getNextExtNode();
                    }
                }
                node = node.getParent();
            }
            node2 = node2.getNextExtNode();
        }
        if (!tree.isRooted()) {
            tree2.setRooted(false);
        } else {
            tree2.setRooted(true);
        }
        tree2.recalculateAndReset();
        tree2.reassignIDs();
        return tree2;
    }

    public Tree copyTree() {
        Tree tree = new Tree();
        if (this.isEmpty()) {
            tree.delete();
            return tree;
        }
        tree.rooted = this.rooted;
        tree.highest_lnL = this.highest_lnL;
        tree.lowest_lnL = this.lowest_lnL;
        tree.longest_distance = this.longest_distance;
        tree.number_of_branches = this.number_of_branches;
        tree.external_nodes = this.external_nodes;
        tree.most_branches_per_ext_node = this.most_branches_per_ext_node;
        tree.number_of_duplications = this.number_of_duplications;
        tree.more_than_bin_nodes_in_NH = this.more_than_bin_nodes_in_NH;
        tree.name = new String(this.name);
        tree.root = Node.copyTree(this.root);
        tree.getRoot().setParents();
        tree.adjustExtNode0();
        tree.adjustReferencesInExtNodes();
        tree.setIndicatorsToZero();
        return tree;
    }

    private int countBranchesWithDISTANCE_NULL() {
        if (this.isEmpty()) {
            return -1;
        }
        int n = 0;
        PreorderTreeIterator preorderTreeIterator = null;
        try {
            preorderTreeIterator = new PreorderTreeIterator(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Tree: Unexpected failure.");
            System.exit(-1);
        }
        while (!preorderTreeIterator.isDone()) {
            if (preorderTreeIterator.currentNode().isPseudoNode()) {
                ++n;
            }
            preorderTreeIterator.next();
        }
        return n;
    }

    public void delete() {
        this.ext_node0 = null;
        this.setRoot(null);
        this.highest_lnL = 0.0;
        this.lowest_lnL = 0.0;
        this.longest_distance = 0.0;
        this.number_of_branches = 0;
        this.external_nodes = 0;
        this.most_branches_per_ext_node = 0;
        this.number_of_duplications = -1;
        this.name = "";
    }

    public void findHighestLnL() {
        if (this.isEmpty()) {
            return;
        }
        double d = this.getExtNode0().getLnLonParentBranch();
        PreorderTreeIterator preorderTreeIterator = null;
        try {
            preorderTreeIterator = new PreorderTreeIterator(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Tree: Unexpected failure.");
            System.exit(-1);
        }
        while (!preorderTreeIterator.isDone()) {
            if (preorderTreeIterator.currentNode().isLnLonParentBranchAssigned() && !preorderTreeIterator.currentNode().isPseudoNode() && preorderTreeIterator.currentNode().getLnLonParentBranch() > d) {
                d = preorderTreeIterator.currentNode().getLnLonParentBranch();
            }
            preorderTreeIterator.next();
        }
        this.highest_lnL = d;
    }

    public void findLowestLnL() {
        if (this.isEmpty()) {
            return;
        }
        double d = this.getExtNode0().getLnLonParentBranch();
        PreorderTreeIterator preorderTreeIterator = null;
        try {
            preorderTreeIterator = new PreorderTreeIterator(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Tree: Unexpected failure.");
            System.exit(-1);
        }
        while (!preorderTreeIterator.isDone()) {
            if (preorderTreeIterator.currentNode().isLnLonParentBranchAssigned() && !preorderTreeIterator.currentNode().isPseudoNode() && preorderTreeIterator.currentNode().getLnLonParentBranch() < d) {
                d = preorderTreeIterator.currentNode().getLnLonParentBranch();
            }
            preorderTreeIterator.next();
        }
        this.lowest_lnL = d;
    }

    public Tree[] fuseToAllBranches(Tree tree) throws Exception {
        Tree tree2 = this.copyTree();
        Tree tree3 = tree.copyTree();
        double d = 0.0;
        int n = 0;
        Tree[] treeArray = new Tree[tree2.getNumberOfBranches()];
        Node node = tree2.getExtNode0();
        tree2.setIndicatorsToZero();
        tree3.setIndicatorsToZero();
        if (!tree2.isRooted()) {
            tree2.getRoot().setIndicator(1);
            if (!(tree2.getRoot().isExternal() || tree2.getRoot().getChild1().isPseudoNode() || tree2.getRoot().getChild2().isPseudoNode())) {
                tree2.getRoot().getChild1().setIndicator(1);
            }
        }
        while (node != null) {
            Node node2 = node;
            while (node2 != null) {
                if (node2.getIndicator() == 0) {
                    while (!node2.isRoot() && node2.isPseudoNode()) {
                        node2.setIndicator(1);
                        node2 = node2.getParent();
                    }
                    if (node2.getIndicator() == 0) {
                        d = node2.getDistanceToParent();
                        if (d <= 0.0 && d != -99.0) {
                            d = 0.0;
                        } else if (d != -99.0) {
                            d /= 2.0;
                        }
                        node2.setIndicator(1);
                        treeArray[n] = tree2.fuseTrees(node2.getID(), d, tree3);
                        ++n;
                    }
                }
                node2 = node2.getParent();
            }
            node = node.getNextExtNode();
        }
        return treeArray;
    }

    public Tree fuseTrees(int n, double d, double d2, Tree tree) throws Exception {
        return this.fuseTrees(n, d, d2, tree, new Node(""));
    }

    public Tree fuseTrees(int n, double d, double d2, Tree tree, Node node) throws Exception {
        int n2;
        if (this.isEmpty() || tree.isEmpty()) {
            String string = "Tree: fuseTrees( int , double , double , Tree";
            string = String.valueOf(string) + " , Node ): Tree(s) must not be empty.";
            throw new Exception(string);
        }
        if (!tree.isRooted()) {
            String string = "fuseTrees( int, double, double, Tree, Node";
            string = String.valueOf(string) + " ): Cannot fuse an unrooted Tree to another Tree.";
            throw new Exception(string);
        }
        if (d2 < 0.0 && d2 != -99.0) {
            d2 = 0.0;
            System.err.print("fuseTrees( int, double, double, Tree, Node ): WARNING: ");
            System.err.println("Negative r has been replaced by 0.0.");
        }
        if (d < 0.0 && d != -99.0 && d != -100.0) {
            d = 0.0;
            System.err.print("fuseTrees( int, double, double, Tree, Node ): WARNING: ");
            System.err.println("Negative d has been replaced by 0.0.");
        }
        Tree tree2 = this.copyTree();
        tree = tree.copyTree();
        Node node2 = node.copyNodeData();
        Node node3 = tree2.getNode(n);
        if (node3.isPseudoNode()) {
            System.err.println("fuseTrees(int, double, double, Tree, Node ): WARNING: Attempted to fuse to a pseudo node.");
            d = -100.0;
            while (!node3.isRoot() && node3.getParent().isPseudoNode()) {
                node3 = node3.getParent();
            }
            if (node3.getParent().getChild1().isPseudoNode() && node3.getParent().getChild2().isPseudoNode()) {
                node3 = node3.getParent().getChild1();
            }
        }
        tree.getRoot().setDistanceToParent(d2);
        if (node3.isRoot() && tree2.isRooted()) {
            node2.setChild2(tree.getRoot());
            node2.setChild1(node3);
            tree2.setRoot(node2);
        } else {
            if (node3.isRoot() && !tree2.isRooted()) {
                if (node3.getChild1().isPseudoNode()) {
                    d = -100.0;
                    node3 = node3.getChild1();
                } else if (node3.getChild2().isPseudoNode()) {
                    d = -100.0;
                    node3 = node3.getChild2();
                } else {
                    String string = "Tree: fuseTrees( int, double, double, Tree, Node";
                    string = String.valueOf(string) + " ): Meaningless placement of tree to be fused.";
                    throw new Exception(string);
                }
            }
            Node node4 = node3.getParent();
            node2.setParent(node4);
            if (node4.getChild1() == node3) {
                node4.setChild1(node2);
                node2.setChild1(tree.getRoot());
                node2.setChild2(node3);
            } else {
                node4.setChild2(node2);
                node2.setChild2(tree.getRoot());
                node2.setChild1(node3);
            }
        }
        tree.setIndicatorsToZero();
        tree2.setIndicatorsToZero();
        tree.getRoot().setParent(node2);
        node3.setParent(node2);
        double d3 = node3.getDistanceToParent();
        if (d > d3 && d3 != -99.0 && d3 != -100.0) {
            node2.setDistanceToParent(d3);
            node3.setDistanceToParent(0.0);
            System.err.print("fuseTrees(int, double, double, Tree, Node ): WARNING: ");
            System.err.println("Distance d was larger than distance between Nodes 1 and 2.");
        } else if (d >= d3 && d3 == -99.0 || d == -99.0 || d == -100.0) {
            node2.setDistanceToParent(d);
        } else {
            node2.setDistanceToParent(d);
            node3.setDistanceToParent(d3 - d);
        }
        tree2.external_nodes = n2 = tree2.getNumberOfExtNodes() + tree.getNumberOfExtNodes();
        tree2.adjustExtNode0();
        tree2.adjustReferencesInExtNodes();
        tree2.adjustNodeCount();
        tree2.recalculateAndReset();
        tree2.reassignIDs();
        return tree2;
    }

    public Tree fuseTrees(int n, double d, Tree tree) throws Exception {
        return this.fuseTrees(n, d, tree.getRoot().getDistanceToParent(), tree, new Node(""));
    }

    public Tree fuseTrees(int n, double d, Tree tree, Node node) throws Exception {
        return this.fuseTrees(n, d, tree.getRoot().getDistanceToParent(), tree, node);
    }

    public Tree fuseTrees(int n, Tree tree) throws Exception {
        return this.fuseTrees(n, -99.0, tree.getRoot().getDistanceToParent(), tree, new Node(""));
    }

    public Tree fuseTrees(int n, Tree tree, Node node) throws Exception {
        return this.fuseTrees(n, -99.0, tree.getRoot().getDistanceToParent(), tree, node);
    }

    public Node getExtNode0() {
        return this.ext_node0;
    }

    public double getHighestLnL() {
        return this.highest_lnL;
    }

    /*
     * Unable to fully structure code
     */
    public Node getLastCommonAncestor(int var1_1, int var2_2) throws Exception {
        if (this.isEmpty()) {
            var3_3 = "Tree: getLastCommonAncestor( int, int ): ";
            var3_3 = String.valueOf(var3_3) + "Tree must not be empty.";
            throw new Exception(var3_3);
        }
        var5_5 = null;
        try {
            var3_4 = this.getNode(var1_1);
            var4_6 = this.getNode(var2_2);
            if (true) ** GOTO lbl22
        }
        catch (Exception v0) {
            var6_7 = "Tree: getLastCommonAncestor( int, int ): ";
            var6_7 = String.valueOf(var6_7) + "Node(s) not found.";
            throw new Exception(var6_7);
        }
        do {
            var5_5 = var4_6;
            while (!var5_5.isRoot()) {
                if (var5_5 == var3_4 && !var5_5.isPseudoNode()) {
                    return var5_5;
                }
                var5_5 = var5_5.getParent();
            }
            var3_4 = var3_4.getParent();
lbl22:
            // 2 sources

        } while (!var3_4.isRoot());
        if (var5_5 == var3_4 && !var5_5.isPseudoNode()) {
            return var5_5;
        }
        throw new Exception("getLastCommonAncestor: Unexpected error.");
    }

    public Node getLastCommonAncestor(String string, String string2) throws Exception {
        if (this.isEmpty()) {
            String string3 = "Tree: getLastCommonAncestor( String, String ): ";
            string3 = String.valueOf(string3) + "Tree must not be empty.";
            throw new Exception(string3);
        }
        string = string.trim();
        string2 = string2.trim();
        Vector vector = this.getNodes(string);
        Vector vector2 = this.getNodes(string2);
        if (vector == null || vector2 == null) {
            String string4 = "Tree: getLastCommonAncestor( String, String ): ";
            string4 = String.valueOf(string4) + "Node(s) which matching seq name(s) not found";
            throw new Exception(string4);
        }
        if (vector.size() != 1 || vector2.size() != 1) {
            String string5 = "Tree: getLastCommonAncestor( String, String ): ";
            string5 = String.valueOf(string5) + "Seq name(s) is (are) not unique.";
            throw new Exception(string5);
        }
        int n = ((Node)vector.firstElement()).getID();
        int n2 = ((Node)vector2.firstElement()).getID();
        return this.getLastCommonAncestor(n, n2);
    }

    public double getLongestDistance() {
        return this.longest_distance;
    }

    public double getLowestLnL() {
        return this.lowest_lnL;
    }

    public int getMostBranchesPerExtNode() {
        return this.most_branches_per_ext_node;
    }

    public String getName() {
        return this.name;
    }

    public Node getNode(int n) {
        if (this.isEmpty()) {
            return null;
        }
        if (this.idhash != null) {
            return (Node)this.idhash.get(new Integer(n));
        }
        Node node = this.getExtNode0();
        this.setIndicatorsToZero();
        while (node != null) {
            Node node2 = node;
            while (node2 != null) {
                if (node2.getIndicator() == 0) {
                    if (node2.getID() == n) {
                        return node2;
                    }
                    node2.setIndicator(1);
                }
                node2 = node2.getParent();
            }
            node = node.getNextExtNode();
        }
        System.err.println("getNode: Node not found.");
        return null;
    }

    public Vector getNodes(String string) throws Exception {
        if (this.isEmpty()) {
            String string2 = "Tree: getNodes( String ): ";
            string2 = String.valueOf(string2) + "Tree must not be empty.";
            throw new Exception(string2);
        }
        string = string.trim();
        Vector<Node> vector = new Vector<Node>();
        PreorderTreeIterator preorderTreeIterator = new PreorderTreeIterator(this);
        while (!preorderTreeIterator.isDone()) {
            if (preorderTreeIterator.currentNode().getSeqName().trim().equals(string)) {
                vector.addElement(preorderTreeIterator.currentNode());
            }
            preorderTreeIterator.next();
        }
        vector.trimToSize();
        return vector;
    }

    public Vector getNodesWithMatchingSpecies(String string) throws Exception {
        if (this.isEmpty()) {
            String string2 = "Tree: getNodes( String ): ";
            string2 = String.valueOf(string2) + "Tree must not be empty.";
            throw new Exception(string2);
        }
        string = string.trim();
        Vector<Node> vector = new Vector<Node>();
        PreorderTreeIterator preorderTreeIterator = new PreorderTreeIterator(this);
        while (!preorderTreeIterator.isDone()) {
            if (preorderTreeIterator.currentNode().getSpecies().trim().equals(string)) {
                vector.addElement(preorderTreeIterator.currentNode());
            }
            preorderTreeIterator.next();
        }
        vector.trimToSize();
        return vector;
    }

    public int getNumberOfBranches() {
        return this.number_of_branches;
    }

    public int getNumberOfDuplications() {
        return this.number_of_duplications;
    }

    public int getNumberOfExtNodes() {
        return this.external_nodes;
    }

    public Vector getPath(Node node, Node node2, boolean bl) throws Exception {
        if (this.isEmpty()) {
            return null;
        }
        if (!node.isExternal() || !node2.isExternal()) {
            String string = "Tree: getPath( Node, Node ): ";
            string = String.valueOf(string) + "Nodes must be external.";
            throw new Exception(string);
        }
        Vector<Integer> vector = new Vector<Integer>(50, 50);
        Tree tree = this.copyTree();
        if (this.getNumberOfExtNodes() < 2 || node == node2) {
            vector.addElement(new Integer(node.getID()));
            return vector;
        }
        try {
            tree.reRoot(node.getID());
            tree.adjustNodeCount();
            tree.recalculateAndReset();
        }
        catch (Exception exception) {
            throw new Exception("Tree: getPath( Node, Node ): " + exception);
        }
        node = tree.getNode(node.getID());
        node2 = tree.getNode(node2.getID());
        while (!node2.isRoot()) {
            if (bl || !this.getNode(node2.getID()).isPseudoNode()) {
                vector.addElement(new Integer(node2.getID()));
            }
            node2 = node2.getParent();
        }
        vector.addElement(new Integer(node.getID()));
        vector.trimToSize();
        return vector;
    }

    public Node getRoot() {
        return this.root;
    }

    public Vector getSiblings(Node node) throws Exception {
        if (this.isEmpty()) {
            String string = "Tree: getSiblings( Node ): ";
            string = String.valueOf(string) + "Tree must not be empty.";
            throw new Exception(string);
        }
        if (!node.isExternal()) {
            String string = "Tree: getSiblings( Node ): ";
            string = String.valueOf(string) + "This method only works for external nodes.";
            throw new Exception(string);
        }
        if (node.isRoot()) {
            String string = "Tree: getSiblings( Node ): ";
            string = String.valueOf(string) + "Root has no sibling.";
            throw new Exception(string);
        }
        if (node.isPseudoNode()) {
            String string = "Tree: getSiblings( Node ): ";
            string = String.valueOf(string) + "Attempt to get sibling of a pseudonode.";
            throw new Exception(string);
        }
        Node node2 = node;
        while ((node2 = node2.getParent()).isPseudoNode()) {
        }
        Vector vector = node2.getAllExternalChildren();
        if (!vector.removeElement(node)) {
            String string = "Tree: getSiblings( Node ): ";
            string = String.valueOf(string) + "Unexpected failure.";
            throw new Exception(string);
        }
        vector.trimToSize();
        return vector;
    }

    public void hashIDs() {
        this.idhash = null;
        if (this.isEmpty()) {
            return;
        }
        this.idhash = new Hashtable();
        Stack<Node> stack = new Stack<Node>();
        Node node = this.getRoot();
        stack.push(node);
        while (!stack.empty()) {
            node = (Node)stack.pop();
            this.idhash.put(new Integer(node.getID()), node);
            if (node.getChild1() != null) {
                stack.push(node.getChild1());
            }
            if (node.getChild2() == null) continue;
            stack.push(node.getChild2());
        }
    }

    public boolean isEmpty() {
        return this.getExtNode0() == null;
    }

    public boolean isRooted() {
        return this.rooted;
    }

    public void moveBranchLenghtsToBootstrap() throws Exception {
        if (this.isEmpty()) {
            String string = "Tree: moveBranchLenghtsToBootstrap(): ";
            string = String.valueOf(string) + "Tree must not be empty.";
            throw new Exception(string);
        }
        this.setIndicatorsToZero();
        Node node = this.getExtNode0();
        while (node != null) {
            Node node2 = node;
            while (node2 != null) {
                if (node2.getIndicator() == 0) {
                    if (node2.getDistanceToParent() > 0.0) {
                        if (!node2.isExternal()) {
                            node2.setBootstrap((int)node2.getDistanceToParent());
                        }
                        node2.setDistanceToParent(-99.0);
                    } else {
                        node2.setBootstrap(-99);
                    }
                    node2.setIndicator(1);
                }
                node2 = node2.getParent();
            }
            node = node.getNextExtNode();
        }
        this.recalculateAndReset();
    }

    public int preorderReID(int n) {
        if (this.isEmpty()) {
            return n;
        }
        Stack<Node> stack = new Stack<Node>();
        Node node = this.getRoot();
        stack.push(node);
        while (!stack.empty()) {
            node = (Node)stack.pop();
            node.setID(n++);
            if (node.getChild2() != null) {
                stack.push(node.getChild2());
            }
            if (node.getChild1() == null) continue;
            stack.push(node.getChild1());
        }
        return n;
    }

    public void printAllNodes() {
        if (this.isEmpty()) {
            return;
        }
        this.getRoot().preorderPrint();
    }

    public void printExtNodes() {
        if (this.isEmpty()) {
            return;
        }
        Node node = this.getExtNode0();
        while (node != null) {
            System.out.println(String.valueOf(node) + "\n");
            node = node.getNextExtNode();
        }
    }

    public void reRoot(int n) throws Exception {
        this.reRoot(this.getNode(n), "");
    }

    public void reRoot(int n, String string) throws Exception {
        this.reRoot(this.getNode(n), string);
    }

    public void reRoot(Node node) throws Exception {
        this.reRoot(node, "");
    }

    public void reRoot(Node node, String string) throws Exception {
        if (this.isEmpty()) {
            return;
        }
        Node node2 = node;
        Node node3 = null;
        if (node2.isPseudoNode()) {
            String string2 = "Tree: reRoot: ";
            string2 = String.valueOf(string2) + "Can not place root in >bin node.";
            throw new Exception(string2);
        }
        this.setRooted(true);
        if (node2.isRoot()) {
            return;
        }
        if (node2.getParent().isRoot()) {
            if (this.getRoot().getChild1().isPseudoNode() || this.getRoot().getChild2().isPseudoNode()) {
                if (this.getRoot().getChild1() == node2 && this.getRoot().getChild2().isPseudoNode()) {
                    node3 = this.getRoot().getChild2();
                }
                if (this.getRoot().getChild2() == node2 && this.getRoot().getChild1().isPseudoNode()) {
                    node3 = this.getRoot().getChild1();
                }
                if (node2.getDistanceToParent() == -99.0) {
                    node3.setDistanceToParent(-99.0);
                } else {
                    node3.setDistanceToParent(node2.getDistanceToParent() / 2.0);
                    node2.setDistanceToParent(node2.getDistanceToParent() / 2.0);
                }
                node3.setLnLonParentBranch(node2.getLnLonParentBranch());
                node3.setSignificantlyWorse(node2.significantlyWorse());
                node3.setLnLonParentBranchAssigned(node2.isLnLonParentBranchAssigned());
                node3.setBlOfSeqOnParentBranch(node2.getBlOfSeqOnParentBranch());
            }
            return;
        }
        Node node4 = node2.getParent();
        Node node5 = node4.getParent();
        Node node6 = new Node(string);
        node6.setParent(null);
        if (node4.getChild2() == node2) {
            node6.setChild1(node2);
            node6.setChild2(node4);
        } else {
            node6.setChild1(node4);
            node6.setChild2(node2);
        }
        double d = node5.getDistanceToParent();
        double d2 = node5.getLnLonParentBranch();
        boolean bl = node5.significantlyWorse();
        boolean bl2 = node5.isLnLonParentBranchAssigned();
        double d3 = node5.getBlOfSeqOnParentBranch();
        node5.setDistanceToParent(node4.getDistanceToParent());
        node5.setLnLonParentBranch(node4.getLnLonParentBranch());
        node5.setLnLonParentBranchAssigned(node4.isLnLonParentBranchAssigned());
        node5.setSignificantlyWorse(node4.significantlyWorse());
        node5.setBlOfSeqOnParentBranch(node4.getBlOfSeqOnParentBranch());
        node4.setLnLonParentBranch(node2.getLnLonParentBranch());
        node4.setLnLonParentBranchAssigned(node2.isLnLonParentBranchAssigned());
        node4.setSignificantlyWorse(node2.significantlyWorse());
        node4.setBlOfSeqOnParentBranch(node2.getBlOfSeqOnParentBranch());
        if (node2.getDistanceToParent() == -99.0) {
            node4.setDistanceToParent(-99.0);
        } else {
            node4.setDistanceToParent(node2.getDistanceToParent() / 2.0);
            node2.setDistanceToParent(node2.getDistanceToParent() / 2.0);
        }
        node2.setParent(node6);
        if (node4.getChild1() == node2) {
            node4.setChild1(node5);
        } else {
            node4.setChild2(node5);
        }
        node4.setParent(node6);
        while (!node5.isRoot()) {
            node2 = node4;
            node4 = node5;
            node5 = node5.getParent();
            if (node4.getChild1() == node2) {
                node4.setChild1(node5);
            } else {
                node4.setChild2(node5);
            }
            node4.setParent(node2);
            double d4 = node5.getDistanceToParent();
            double d5 = node5.getLnLonParentBranch();
            boolean bl3 = node5.significantlyWorse();
            boolean bl4 = node5.isLnLonParentBranchAssigned();
            double d6 = node5.getBlOfSeqOnParentBranch();
            node5.setDistanceToParent(d);
            node5.setLnLonParentBranch(d2);
            node5.setSignificantlyWorse(bl);
            node5.setLnLonParentBranchAssigned(bl2);
            node5.setBlOfSeqOnParentBranch(d3);
            d = d4;
            d2 = d5;
            bl = bl3;
            bl2 = bl4;
            d3 = d6;
        }
        node3 = node5.getChild1() == node4 ? node5.getChild2() : node5.getChild1();
        node3.setParent(node4);
        if (node5.getDistanceToParent() == -100.0 && node3.getDistanceToParent() == -100.0) {
            node3.setDistanceToParent(-100.0);
        } else if (!(node5.getDistanceToParent() != -99.0 && node5.getDistanceToParent() != -100.0 || node3.getDistanceToParent() != -99.0 && node3.getDistanceToParent() != -100.0)) {
            node3.setDistanceToParent(-99.0);
        } else {
            node3.setDistanceToParent((node5.getDistanceToParent() >= 0.0 ? node5.getDistanceToParent() : 0.0) + (node3.getDistanceToParent() >= 0.0 ? node3.getDistanceToParent() : 0.0));
        }
        if (node5.getDistanceToParent() != -100.0) {
            node3.setLnLonParentBranch(node5.getLnLonParentBranch());
            node3.setSignificantlyWorse(node5.significantlyWorse());
            node3.setLnLonParentBranchAssigned(node5.isLnLonParentBranchAssigned());
            node3.setBlOfSeqOnParentBranch(node5.getBlOfSeqOnParentBranch());
        }
        if (node4.getChild1() != node5) {
            node4.setChild2(node3);
        } else {
            node4.setChild1(node3);
        }
        this.setRoot(node6);
        this.adjustExtNode0();
        this.adjustReferencesInExtNodes();
    }

    private void reassignIDs() throws Exception {
        if (this.isEmpty()) {
            return;
        }
        PreorderTreeIterator preorderTreeIterator = null;
        try {
            preorderTreeIterator = new PreorderTreeIterator(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Tree: Unexpected failure.");
            System.exit(-1);
        }
        while (!preorderTreeIterator.isDone()) {
            Node.setNodeCount(Node.getNodeCount() + 1);
            preorderTreeIterator.currentNode().setID(Node.getNodeCount());
            preorderTreeIterator.next();
        }
    }

    public void recalculateAndReset() {
        int n;
        if (this.isEmpty()) {
            return;
        }
        this.setIndicatorsToZero();
        if (!this.isRooted()) {
            this.getRoot().deleteData();
        }
        this.calculateMostBranchesPerExtNode();
        this.findHighestLnL();
        this.findLowestLnL();
        this.calculateLongestDistance();
        this.calculateNumberOfBranches();
        this.external_nodes = n = this.getRoot().getSumExtNodes();
    }

    public void removeExtNode(Node node) {
        int n;
        Node node2;
        if (this.isEmpty()) {
            return;
        }
        if (this.getNumberOfExtNodes() == 1 && node == this.getExtNode0()) {
            this.ext_node0 = null;
            this.setRoot(null);
            this.highest_lnL = 0.0;
            this.lowest_lnL = 0.0;
            this.longest_distance = 0.0;
            this.number_of_branches = 0;
            this.external_nodes = 0;
            this.most_branches_per_ext_node = 0;
            this.number_of_duplications = -1;
            return;
        }
        Node node3 = null;
        node3 = node;
        if (node3 == this.getExtNode0()) {
            this.ext_node0 = node2 = node3.getNextExtNode();
            node3.getNextExtNode().setPrevExtNode(null);
        } else if (node3.getNextExtNode() == null) {
            node3.getPrevExtNode().setNextExtNode(null);
        } else {
            node3.getNextExtNode().setPrevExtNode(node3.getPrevExtNode());
            node3.getPrevExtNode().setNextExtNode(node3.getNextExtNode());
        }
        node2 = node3.getParent();
        if (node2.isRoot()) {
            if (node3.isChild1()) {
                this.setRoot(this.getRoot().getChild2());
                this.getRoot().setParent(null);
            } else {
                this.setRoot(this.getRoot().getChild1());
                this.getRoot().setParent(null);
            }
        } else {
            Node node4 = node3.getParent().getParent();
            if (node2.isChild1()) {
                if (node3.isChild1()) {
                    node2.getChild2().setDistanceToParent(this.addDist(node2.getDistanceToParent(), node2.getChild2().getDistanceToParent()));
                    node4.setChild1(node2.getChild2());
                    node2.getChild2().setParent(node4);
                } else {
                    node2.getChild1().setDistanceToParent(this.addDist(node2.getDistanceToParent(), node2.getChild1().getDistanceToParent()));
                    node4.setChild1(node2.getChild1());
                    node2.getChild1().setParent(node4);
                }
            } else if (node3.isChild1()) {
                node2.getChild2().setDistanceToParent(this.addDist(node2.getDistanceToParent(), node2.getChild2().getDistanceToParent()));
                node4.setChild2(node2.getChild2());
                node2.getChild2().setParent(node4);
            } else {
                node2.getChild1().setDistanceToParent(this.addDist(node2.getDistanceToParent(), node2.getChild1().getDistanceToParent()));
                node4.setChild2(node2.getChild1());
                node2.getChild1().setParent(node4);
            }
            while (node4 != this.getRoot()) {
                node4.setSumExtNodes(node4.getSumExtNodes() - 1);
                node4 = node4.getParent();
            }
            node4.setSumExtNodes(node4.getSumExtNodes() - 1);
        }
        this.number_of_branches = n = this.getNumberOfBranches() - 2;
        this.external_nodes = n = this.getNumberOfExtNodes() - 1;
    }

    private void setExtNode0(Node node) {
        this.ext_node0 = node;
    }

    private void setExtNodes(int n) {
        this.external_nodes = n;
    }

    private void setHighestLnL(double d) {
        this.highest_lnL = d;
    }

    public void setIndicatorsToZero() {
        if (this.isEmpty()) {
            return;
        }
        this.getRoot().setIndicatorsToZero();
    }

    private void setLongestDistance(double d) {
        this.longest_distance = d;
    }

    private void setLowestLnL(double d) {
        this.lowest_lnL = d;
    }

    private void setMostBranchesPerExtNode(int n) {
        this.most_branches_per_ext_node = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    private void setNumberOfBranches(int n) {
        this.number_of_branches = n;
    }

    public void setNumberOfDuplications(int n) {
        if (n < 0) {
            this.number_of_duplications = -1;
            return;
        }
        this.number_of_duplications = n;
    }

    void setRoot(Node node) {
        this.root = node;
    }

    public void setRooted(boolean bl) {
        this.rooted = bl;
    }

    private String stackToString(Stack stack) {
        String string = this.getNumberOfExtNodes() >= 2 ? "(" : "";
        while (!stack.empty()) {
            String string2 = stack.pop().toString();
            if (string2.startsWith("(") && string.endsWith(")")) {
                string = String.valueOf(string) + "," + string2;
                continue;
            }
            if (string2.startsWith("(") && !string.endsWith("(") && !string.endsWith(",")) {
                string = String.valueOf(string) + "," + string2;
                continue;
            }
            if (string2.startsWith(",") && string.endsWith("(")) {
                string = String.valueOf(string) + string2.substring(1);
                continue;
            }
            if (string2.startsWith(")") && string.endsWith(",")) {
                string = string.substring(0, string.length() - 1);
                string = String.valueOf(string) + string2;
                continue;
            }
            string = string2.startsWith(",") && string.endsWith(",") ? String.valueOf(string) + string2.substring(1) : String.valueOf(string) + string2;
        }
        if (string.endsWith(",")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((string = this.getNumberOfExtNodes() >= 2 ? String.valueOf(string) + ");" : String.valueOf(string) + ";").startsWith(",")) {
            string = string.substring(1);
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n <= stringBuffer.length() - 1) {
            if (stringBuffer.charAt(n) == '\t') {
                stringBuffer = new StringBuffer(String.valueOf(stringBuffer.toString().substring(0, n)) + stringBuffer.toString().substring(n + 1));
                --n;
            }
            ++n;
        }
        string = stringBuffer.toString();
        return string;
    }

    public Tree subTree(int n) throws Exception {
        int n2;
        if (this.isEmpty()) {
            return null;
        }
        Tree tree = this.copyTree();
        Node node = tree.getNode(n);
        if (node.isExternal()) {
            String string = "Tree: subTree( int ): ";
            string = String.valueOf(string) + "Can not get a sub tree from a external node.";
            throw new Exception(string);
        }
        node.setParent(null);
        node.setDistanceToParent(-99.0);
        tree.setRooted(true);
        tree.setRoot(node);
        tree.adjustExtNode0();
        tree.adjustReferencesInExtNodes();
        tree.adjustNodeCount();
        tree.recalculateAndReset();
        tree.external_nodes = n2 = tree.getRoot().getSumExtNodes();
        return tree;
    }

    public void swapChildren(int n) {
        this.swapChildren(this.getNode(n));
    }

    public void swapChildren(Node node) {
        if (this.isEmpty()) {
            return;
        }
        if (node.isExternal()) {
            return;
        }
        Node node2 = node.getChild1();
        node.setChild1(node.getChild2());
        node.setChild2(node2);
        this.adjustExtNode0();
        this.adjustReferencesInExtNodes();
        this.adjustNodeCount();
        this.recalculateAndReset();
    }

    public String toNewHampshire(boolean bl) {
        if (this.isEmpty()) {
            return "";
        }
        int n = 0;
        String string = "";
        String string2 = "";
        Stack<String> stack = new Stack<String>();
        Stack stack2 = new Stack();
        Node node = this.root;
        this.setIndicatorsToZero();
        do {
            if (!node.isExternal()) {
                if (node.getIndicator() == 0) {
                    node.setIndicator(1);
                    node = node.getChild1();
                }
                if (node.getIndicator() == 1) {
                    node.setIndicator(2);
                    node = node.getChild2();
                }
                if (node.getIndicator() != 2) continue;
                if (!(node.isPseudoNode() && (this.more_than_bin_nodes_in_NH || node.getParent().isRoot() || node.getParent().getChild1().isPseudoNode() && node.getParent().getChild2().isPseudoNode() && node.getParent().getChild1() != node))) {
                    n = 0;
                    while (n < 2 * node.getSumExtNodes() - 2) {
                        stack2.push(stack.pop());
                        if (stack2.peek().toString().equals("(") || stack2.peek().toString().equals(")")) continue;
                        ++n;
                    }
                    stack.push("(");
                    while (!stack2.empty()) {
                        stack.push((String)stack2.pop());
                    }
                    stack.push(")");
                }
                string = node.getDistanceToParent() >= 0.0 && !node.isPseudoNode() ? ":" + node.getDistanceToParent() + "," : (node.isPseudoNode() && !this.more_than_bin_nodes_in_NH && !node.getParent().isRoot() && (!node.getParent().getChild1().isPseudoNode() || !node.getParent().getChild2().isPseudoNode() || node.getParent().getChild1() == node) ? ":0.0," : ",");
                stack.push(string);
                node = node.getParent();
                continue;
            }
            if (bl && !node.getSeqName().equals("")) {
                String string3 = node.getSeqName();
                try {
                    if (string3.length() > 10) {
                        string3 = string3.substring(0, 11);
                    }
                    if (string3.indexOf(47) > 0) {
                        string3 = string3.substring(0, string3.indexOf(47));
                    }
                }
                catch (Exception exception) {
                    System.err.println("\ntoNewHampshire()Unexpected Exception.\n");
                }
                string = "," + string3;
            } else {
                string = !bl && !node.getSeqName().equals("") ? "," + node.getSeqName() : (!bl && !node.getSpecies().equals("") ? "," + node.getSpecies() : (!bl && !node.getECnumber().equals("") ? "," + node.getECnumber() : ",\t"));
            }
            if (node.getDistanceToParent() >= 0.0) {
                string = String.valueOf(string) + ":" + node.getDistanceToParent();
            }
            stack.push(string);
            if (!node.isRoot()) {
                node = node.getParent();
                continue;
            }
            node.setIndicator(2);
        } while (!node.isRoot() || node.getIndicator() != 2);
        while (!stack.empty()) {
            stack2.push(stack.pop());
        }
        string2 = this.stackToString(stack2);
        if (string2.indexOf("(") == -1) {
            return "";
        }
        return string2;
    }

    public String toNewHampshireX() {
        if (this.isEmpty()) {
            return "";
        }
        int n = 0;
        String string = "";
        String string2 = "";
        Stack<String> stack = new Stack<String>();
        Stack stack2 = new Stack();
        Node node = this.root;
        this.setIndicatorsToZero();
        do {
            if (!node.isExternal()) {
                if (node.getIndicator() == 0) {
                    node.setIndicator(1);
                    node = node.getChild1();
                }
                if (node.getIndicator() == 1) {
                    node.setIndicator(2);
                    node = node.getChild2();
                }
                if (node.getIndicator() != 2) continue;
                if (!(node.isPseudoNode() && (this.more_than_bin_nodes_in_NH || node.getParent().isRoot() || node.getParent().getChild1().isPseudoNode() && node.getParent().getChild2().isPseudoNode() && node.getParent().getChild1() != node))) {
                    n = 0;
                    while (n < 2 * node.getSumExtNodes() - 2) {
                        stack2.push(stack.pop());
                        if (stack2.peek().toString().equals("(") || stack2.peek().toString().equals(")")) continue;
                        ++n;
                    }
                    stack.push("(");
                    while (!stack2.empty()) {
                        stack.push((String)stack2.pop());
                    }
                    stack.push(")");
                }
                string = "";
                if (!node.isPseudoNode()) {
                    string = node.toNewHampshireX();
                } else if (!(!node.isPseudoNode() || this.more_than_bin_nodes_in_NH || node.getParent().isRoot() || node.getParent().getChild1().isPseudoNode() && node.getParent().getChild2().isPseudoNode() && node.getParent().getChild1() != node)) {
                    string = ":0.0";
                }
                if (string.length() >= 1) {
                    string = String.valueOf(string) + ",";
                }
                stack.push(string);
                node = node.getParent();
                continue;
            }
            string = ",";
            string = String.valueOf(string) + node.toNewHampshireX();
            stack.push(string);
            if (!node.isRoot()) {
                node = node.getParent();
                continue;
            }
            node.setIndicator(2);
        } while (!node.isRoot() || node.getIndicator() != 2);
        while (!stack.empty()) {
            stack2.push(stack.pop());
        }
        string2 = this.stackToString(stack2);
        if (!(this.getNumberOfExtNodes() < 2 || this.root.getSeqName().equals("") && this.root.getDistanceToParent() == 0.0 && this.root.getSpecies().equals("") && this.root.getECnumber().equals("") && !this.root.isLnLonParentBranchAssigned() && !this.root.isDuplicationOrSpecAssigned() && this.root.getBootstrap() == 0)) {
            string2 = string2.substring(0, string2.length() - 1);
            string2 = String.valueOf(string2) + node.toNewHampshireX();
            string2 = String.valueOf(string2) + ";";
        }
        return string2;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        return this.toNewHampshireX();
    }

    public void unRoot() {
        if (this.isEmpty()) {
            return;
        }
        this.setIndicatorsToZero();
        if (!this.isRooted() || this.getNumberOfExtNodes() <= 1) {
            return;
        }
        this.setRooted(false);
        this.recalculateAndReset();
    }

    public void unRootAndTrifurcate() {
        if (this.isEmpty()) {
            return;
        }
        this.unRoot();
        if (this.getNumberOfExtNodes() <= 2) {
            return;
        }
        double d = this.getRoot().getChild2().getDistanceToParent() + this.getRoot().getChild1().getDistanceToParent();
        if (this.getRoot().getChild2().isExternal()) {
            if (d >= 0.0) {
                this.getRoot().getChild2().setDistanceToParent(d);
            } else {
                this.getRoot().getChild2().setDistanceToParent(-99.0);
            }
            this.getRoot().getChild1().setDistanceToParent(-100.0);
        } else {
            if (d >= 0.0) {
                this.getRoot().getChild1().setDistanceToParent(d);
            } else {
                this.getRoot().getChild1().setDistanceToParent(-99.0);
            }
            this.getRoot().getChild2().setDistanceToParent(-100.0);
        }
        this.recalculateAndReset();
    }
}

