// ATVcontrol_applet.java
// Copyright (C) 1999-2000 Washington University School of Medicine
// and Howard Hughes Medical Institute
// All rights reserved


package forester.atv;

import forester.tree.*;


import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


/**

@author Christian Zmasek

@version 1.11 -- last modified: 06/27/00

*/
class ATVcontrol_applet extends ATVcontrol {


    JRadioButton go_to_swissprot;



    /**
 
    Constructor.

    */
    ATVcontrol_applet( ATVpanel ap ) {

        atvpanel = ap;
        
        setColors1();

        setBackground( background_color );

        setLayout( new GridLayout( 0, 1, 2, 2 ) );

        userealbl       = new JCheckBox( "Real branch lengths" );
        seqnameextnodes = new JCheckBox( "Seq. name ext. nodes" );
        seqnameintnodes = new JCheckBox( "Seq. name int. nodes" );
        speciesextnodes = new JCheckBox( "Species ext. nodes" );
        speciesintnodes = new JCheckBox( "Species int. nodes" );
        ecextnodes      = new JCheckBox( "EC ext. nodes" );
        ecintnodes      = new JCheckBox( "EC int. nodes" );
        writelnl        = new JCheckBox( "log L values" );
        writebl         = new JCheckBox( "Branch length values" );
        writebootstrap  = new JCheckBox( "Bootstrap values" );
        writed_s        = new JCheckBox( "Duplic. vs. spec." );
        colorbranches   = new JCheckBox( "Color accord. to log L" );
        drawpbranches   = new JCheckBox( "Seq-X branches" );
        writepbl        = new JCheckBox( "Seq-X branch lenghts" );
        editable        = new JCheckBox( "Editable" );

        addJCB( userealbl ) ;
        addJCB( seqnameextnodes );
        addJCB( seqnameintnodes );
        addJCB( speciesextnodes );
        addJCB( speciesintnodes );
        addJCB( ecextnodes );
        addJCB( ecintnodes );
        addJCB( writebl );
        addJCB( writebootstrap );
        addJCB( writed_s );
        addJCB( colorbranches );
        addJCB( writelnl );
        addJCB( drawpbranches );
        addJCB( writepbl );
        addJCB( editable );

        click_to = new JLabel( "Click on Node to:" );
        click_to.setFont( jcb_font );
        click_to.setForeground( jcb_text_color );
        click_to.setBackground( background_color );
        add( click_to );

        display_info    = new JRadioButton( "Display/Edit information" );
        collapse        = new JRadioButton( "Collapse/Uncollapse" );
        reroot          = new JRadioButton( "Root/Reroot" );
        go_to_swissprot = new JRadioButton( "Go to SWISS-PROT" );
        swap            = new JRadioButton( "Swap children" );
        subtree         = new JRadioButton( "Subtree/Parent tree" );

        group = new ButtonGroup();

        addJRB( display_info );
        addJRB( collapse );
        addJRB( go_to_swissprot );
        addJRB( reroot );
        addJRB( subtree );
        addJRB( swap );

        zoom_in_x  = new JButton( "Zoom in X" );
        zoom_in_y  = new JButton( "Zoom in Y" );
        zoom_out_x = new JButton( "Zoom out X" );
        zoom_out_y = new JButton( "Zoom out Y" );
        show_whole = new JButton( "Show whole" );

        addJB( zoom_in_x );
        addJB( zoom_out_x );
        addJB( zoom_in_y );
        addJB( zoom_out_y );
        addJB( show_whole );

        setCheckBoxes();


    }

    void setCheckBoxes() {
        ATVgraphic ag = atvpanel.getATVgraphic();
        if ( ag.getTree() != null ) {
            display_info.setSelected( true );
            if ( ag.useRealBranchLenghts()    ) { userealbl.setSelected( true ); }
            else {                                userealbl.setSelected( false ); }
            if ( ag.seqNameExtNodes()         ) { seqnameextnodes.setSelected( true ); }
            else {                                seqnameextnodes.setSelected( false ); }
            if ( ag.seqNameInternalNodes()    ) { seqnameintnodes.setSelected( true ); }
            else {                                seqnameintnodes.setSelected( false ); }
            if ( ag.speciesExtNodes()         ) { speciesextnodes.setSelected( true ); }
            else {                                speciesextnodes.setSelected( false ); }
            if ( ag.speciesInternalNodes()    ) { speciesintnodes.setSelected( true ); }
            else {                                speciesintnodes.setSelected( false ); }
            if ( ag.ECExtNodes()              ) { ecextnodes.setSelected( true ); }
            else {                                ecextnodes.setSelected( false ); }
            if ( ag.ECInternalNodes()         ) { ecintnodes.setSelected( true ); }
            else {                                ecintnodes.setSelected( false ); }
            if ( ag.writeLnLValues()          ) { writelnl.setSelected( true ); }
            else {                                writelnl.setSelected( false ); }
            if ( ag.writeBranchLengthValues() ) { writebl.setSelected( true ); }
            else {                                writebl.setSelected( false ); }
            if ( ag.writeBootstrapValues()    ) { writebootstrap.setSelected( true ); }
            else {                                writebootstrap.setSelected( false ); }
            if ( ag.writeDupSpec()            ) { writed_s.setSelected( true ); }
            else {                                writed_s.setSelected( false ); }
            if ( ag.colorBranchesAccToLnL()   ) { colorbranches.setSelected( true ); }
            else {                                colorbranches.setSelected( false ); }
            if ( ag.drawBlOfSeqOnParent()     ) { drawpbranches.setSelected( true ); }
            else {                                drawpbranches.setSelected( false ); }
            if ( ag.writeBlOfSeqOnParent()    ) { writepbl.setSelected( true ); }
            else {                                writepbl.setSelected( false ); }
            if ( ag.isEditable()              ) { editable.setSelected( true ); }
            else {                                editable.setSelected( false ); }
            if      ( atvpanel.getATVgraphic().getActionWhenNodeClicked()
            == ATVgraphic.SHOW_INFO ) {
                display_info.setSelected( true );
            }
            else if ( atvpanel.getATVgraphic().getActionWhenNodeClicked()
            == ATVgraphic.COLLAPSE ) {
                collapse.setSelected( true );
            }
            else if ( atvpanel.getATVgraphic().getActionWhenNodeClicked()
            == ATVgraphic_applet.GO_TO_SWISSPROT ) {
                go_to_swissprot.setSelected( true );
            }
            else if ( atvpanel.getATVgraphic().getActionWhenNodeClicked()
            == ATVgraphic.REROOT ) {
                reroot.setSelected( true );
            }
            else if ( atvpanel.getATVgraphic().getActionWhenNodeClicked()
            == ATVgraphic.SUBTREE ) {
                subtree.setSelected( true );
            }
            else if ( atvpanel.getATVgraphic().getActionWhenNodeClicked()
            == ATVgraphic.SWAP ) {
                swap.setSelected( true );
            }
        }
    }




    public void actionPerformed( ActionEvent e ) {
        ATVgraphic ag = atvpanel.getATVgraphic();
        if ( ag.getTree() != null ) {
            if   ( userealbl.isSelected() ) {
                ag.setUseRealBranchLenghts( true );
                ag.resetPreferredSize();
            }
            else {
                ag.setUseRealBranchLenghts( false );
                ag.resetPreferredSize();
            } 
            if   ( seqnameextnodes.isSelected() ) { ag.setSeqNameExtNodes( true ); }
            else                                  { ag.setSeqNameExtNodes( false ); }
            if   ( seqnameintnodes.isSelected() ) { ag.setSeqNameInternalNodes( true ); }
            else                                  { ag.setSeqNameInternalNodes( false ); }
            if   ( speciesextnodes.isSelected() ) { ag.setSpeciesExtNodes( true ); }
            else                                  { ag.setSpeciesExtNodes( false ); }
            if   ( speciesintnodes.isSelected() ) { ag.setSpeciesInternalNodes( true ); }
            else                                  { ag.setSpeciesInternalNodes( false ); }
            if   ( ecextnodes.isSelected() )      { ag.setECExtNodes( true ); }
            else                                  { ag.setECExtNodes( false ); }
            if   ( ecintnodes.isSelected() )      { ag.setECInternalNodes( true ); }
            else                                  { ag.setECInternalNodes( false ); }
            if   ( writelnl.isSelected() )        { ag.setWriteLnLValues( true ); }
            else                                  { ag.setWriteLnLValues( false ); }
            if   ( writebl.isSelected() )         { ag.setWriteBranchLengthValues( true ); }
            else                                  { ag.setWriteBranchLengthValues( false ); }
            if   ( writebootstrap.isSelected() )  { ag.setWriteBootstrapValues( true ); }
            else                                  { ag.setWriteBootstrapValues( false ); }
            if   ( writed_s.isSelected() )        { ag.setWriteDupSpec( true ); }
            else                                  { ag.setWriteDupSpec( false ); }
            if   ( colorbranches.isSelected() )   { ag.setColorBranchesAccToLnL( true ); }
            else                                  { ag.setColorBranchesAccToLnL( false ); }
            if   ( drawpbranches.isSelected() )   { ag.setDrawBlOfSeqOnParent( true ); }
            else                                  { ag.setDrawBlOfSeqOnParent( false ); }
            if   ( writepbl.isSelected() )        { ag.setWriteBlOfSeqOnParent( true ); }
            else                                  { ag.setWriteBlOfSeqOnParent( false ); }
            if   ( editable.isSelected() )        { ag.setEditable( true ); }
            else                                  { ag.setEditable( false ); }
            if   ( display_info.isSelected() ) {
                atvpanel.getATVgraphic().setActionWhenNodeClicked(
                ATVgraphic.SHOW_INFO );
            }
            if   ( collapse.isSelected() ) {
                atvpanel.getATVgraphic().setActionWhenNodeClicked(
                ATVgraphic.COLLAPSE );
            }
            if   ( reroot.isSelected() ) {
                atvpanel.getATVgraphic().setActionWhenNodeClicked(
                ATVgraphic.REROOT );
            }
            if   ( go_to_swissprot.isSelected() ) {
                atvpanel.getATVgraphic().setActionWhenNodeClicked(
                ATVgraphic_applet.GO_TO_SWISSPROT );
            }
            if   ( subtree.isSelected() ) {
                atvpanel.getATVgraphic().setActionWhenNodeClicked(
                ATVgraphic.SUBTREE );
            }
            if   ( swap.isSelected() ) {
                atvpanel.getATVgraphic().setActionWhenNodeClicked(
                ATVgraphic.SWAP );
            }

            if   (  e.getSource() == zoom_in_x ) {
                atvpanel.getATVgraphic().setXdistance(
                ( int ) ( atvpanel.getATVgraphic().getXdistance() * 1.05 ) + 1 );

                atvpanel.getATVgraphic().setXcorrectionFactor(
                atvpanel.getATVgraphic().getXcorrectionFactor() * 1.10 );
                atvpanel.getATVgraphic().resetPreferredSize();

            }
            if   (  e.getSource() == zoom_in_y ) {
                atvpanel.getATVgraphic().setYdistance(
                ( int ) ( atvpanel.getATVgraphic().getYdistance() * 1.05 ) + 1 );
                atvpanel.getATVgraphic().resetPreferredSize();

            }
            if   (  e.getSource() == zoom_out_x ) {
                atvpanel.getATVgraphic().setXdistance(
                ( int ) ( atvpanel.getATVgraphic().getXdistance() * 0.95 ) );

                atvpanel.getATVgraphic().setXcorrectionFactor(
                atvpanel.getATVgraphic().getXcorrectionFactor() * 0.90 );
                atvpanel.getATVgraphic().resetPreferredSize();

            }
            if   (  e.getSource() == zoom_out_y ) {
                atvpanel.getATVgraphic().setYdistance(
                ( int ) ( atvpanel.getATVgraphic().getYdistance() * 0.95 ) );
                atvpanel.getATVgraphic().resetPreferredSize();

            }
            if   (  e.getSource() == show_whole ) {
                showWhole();
            }
            atvpanel.adjustJScrollPane();
            atvpanel.getATVgraphic().repaint();
        }
    }

}


