// ATVcontrol_applet.java
// Copyright (C) 1999-2000 Washington University School of Medicine
// and Howard Hughes Medical Institute
// All rights reserved


// AWT version.


package forester.atv_awt;

import forester.tree.*;


import java.awt.*;
import java.awt.event.*;


/**

@author Christian Zmasek

@version AWT 1.00 -- last modified: 07/26/00

*/
class ATVcontrol_applet extends ATVcontrol {


    Checkbox go_to_swissprot;



    /**
 
    Constructor.

    */
    ATVcontrol_applet( ATVpanel ap ) {

        atvpanel = ap;
        
        setColors1();

        setBackground( background_color );

        setLayout( new GridLayout( 0, 1, 2, 2 ) );

        userealbl       = new Checkbox( "Real branch lengths" );
        seqnameextnodes = new Checkbox( "Seq. name ext. nodes" );
        seqnameintnodes = new Checkbox( "Seq. name int. nodes" );
        speciesextnodes = new Checkbox( "Species ext. nodes" );
        speciesintnodes = new Checkbox( "Species int. nodes" );
        ecextnodes      = new Checkbox( "EC ext. nodes" );
        ecintnodes      = new Checkbox( "EC int. nodes" );
        writelnl        = new Checkbox( "log L values" );
        writebl         = new Checkbox( "Branch length values" );
        writebootstrap  = new Checkbox( "Bootstrap values" );
        writed_s        = new Checkbox( "Duplic. vs. spec." );
        colorbranches   = new Checkbox( "Color accord. to log L" );
        drawpbranches   = new Checkbox( "Seq-X branches" );
        writepbl        = new Checkbox( "Seq-X branch lenghts" );
        editable        = new Checkbox( "Editable" );

        addCB( userealbl ) ;
        addCB( seqnameextnodes );
        addCB( seqnameintnodes );
        addCB( speciesextnodes );
        addCB( speciesintnodes );
        addCB( ecextnodes );
        addCB( ecintnodes );
        addCB( writebl );
        addCB( writebootstrap );
        addCB( writed_s );
        addCB( colorbranches );
        addCB( writelnl );
        addCB( drawpbranches );
        addCB( writepbl );
        addCB( editable );

        click_to = new Label( "Click on Node to:" );
        click_to.setFont( jcb_font );
        click_to.setForeground( jcb_text_color );
        click_to.setBackground( background_color );
        add( click_to );

        group = new CheckboxGroup();

        display_info    = new Checkbox( "Display/Edit information", group, true );
        collapse        = new Checkbox( "Collapse/Uncollapse", group, false );
        reroot          = new Checkbox( "Root/Reroot", group, false );
        go_to_swissprot = new Checkbox( "Go to SWISS-PROT", group, false );
        swap            = new Checkbox( "Swap children", group, false );
        subtree         = new Checkbox( "Subtree/Parent tree", group, false );

       
        addRB( display_info );
        addRB( collapse );
        addRB( go_to_swissprot );
        addRB( reroot );
        addRB( subtree );
        addRB( swap );

        zoom_in_x  = new Button( "Zoom in X" );
        zoom_in_y  = new Button( "Zoom in Y" );
        zoom_out_x = new Button( "Zoom out X" );
        zoom_out_y = new Button( "Zoom out Y" );
        show_whole = new Button( "Show whole" );

        addJB( zoom_in_x );
        addJB( zoom_out_x );
        addJB( zoom_in_y );
        addJB( zoom_out_y );
        addJB( show_whole );

        setCheckBoxes();


    }

    void setCheckBoxes() {
        ATVgraphic ag = atvpanel.getATVgraphic();
        if ( ag.getTree() != null ) {
            display_info.setState( true );
            if ( ag.useRealBranchLenghts()    ) { userealbl.setState( true ); }
            else {                                userealbl.setState( false ); }
            if ( ag.seqNameExtNodes()         ) { seqnameextnodes.setState( true ); }
            else {                                seqnameextnodes.setState( false ); }
            if ( ag.seqNameInternalNodes()    ) { seqnameintnodes.setState( true ); }
            else {                                seqnameintnodes.setState( false ); }
            if ( ag.speciesExtNodes()         ) { speciesextnodes.setState( true ); }
            else {                                speciesextnodes.setState( false ); }
            if ( ag.speciesInternalNodes()    ) { speciesintnodes.setState( true ); }
            else {                                speciesintnodes.setState( false ); }
            if ( ag.ECExtNodes()              ) { ecextnodes.setState( true ); }
            else {                                ecextnodes.setState( false ); }
            if ( ag.ECInternalNodes()         ) { ecintnodes.setState( true ); }
            else {                                ecintnodes.setState( false ); }
            if ( ag.writeLnLValues()          ) { writelnl.setState( true ); }
            else {                                writelnl.setState( false ); }
            if ( ag.writeBranchLengthValues() ) { writebl.setState( true ); }
            else {                                writebl.setState( false ); }
            if ( ag.writeBootstrapValues()    ) { writebootstrap.setState( true ); }
            else {                                writebootstrap.setState( false ); }
            if ( ag.writeDupSpec()            ) { writed_s.setState( true ); }
            else {                                writed_s.setState( false ); }
            if ( ag.colorBranchesAccToLnL()   ) { colorbranches.setState( true ); }
            else {                                colorbranches.setState( false ); }
            if ( ag.drawBlOfSeqOnParent()     ) { drawpbranches.setState( true ); }
            else {                                drawpbranches.setState( false ); }
            if ( ag.writeBlOfSeqOnParent()    ) { writepbl.setState( true ); }
            else {                                writepbl.setState( false ); }
            if ( ag.isEditable()              ) { editable.setState( true ); }
            else {                                editable.setState( false ); }
            if      ( atvpanel.getATVgraphic().getActionWhenNodeClicked()
            == ATVgraphic.SHOW_INFO ) {
                display_info.setState( true );
            }
            else if ( atvpanel.getATVgraphic().getActionWhenNodeClicked()
            == ATVgraphic.COLLAPSE ) {
                collapse.setState( true );
            }
            else if ( atvpanel.getATVgraphic().getActionWhenNodeClicked()
            == ATVgraphic_applet.GO_TO_SWISSPROT ) {
                go_to_swissprot.setState( true );
            }
            else if ( atvpanel.getATVgraphic().getActionWhenNodeClicked()
            == ATVgraphic.REROOT ) {
                reroot.setState( true );
            }
            else if ( atvpanel.getATVgraphic().getActionWhenNodeClicked()
            == ATVgraphic.SUBTREE ) {
                subtree.setState( true );
            }
            else if ( atvpanel.getATVgraphic().getActionWhenNodeClicked()
            == ATVgraphic.SWAP ) {
                swap.setState( true );
            }
        }
    }



    public void itemStateChanged( ItemEvent e ) {
        ATVgraphic ag = atvpanel.getATVgraphic();
        if ( ag.getTree() != null ) {
            if   ( userealbl.getState() ) {
                ag.setUseRealBranchLenghts( true );
                ag.resetPreferredSize();
            }
            else { 
                ag.setUseRealBranchLenghts( false );
                ag.resetPreferredSize();
            }
            if   ( seqnameextnodes.getState() ) { ag.setSeqNameExtNodes( true ); }
            else                                { ag.setSeqNameExtNodes( false ); }
            if   ( seqnameintnodes.getState() ) { ag.setSeqNameInternalNodes( true ); }
            else                                { ag.setSeqNameInternalNodes( false ); }
            if   ( speciesextnodes.getState() ) { ag.setSpeciesExtNodes( true ); }
            else                                { ag.setSpeciesExtNodes( false ); }
            if   ( speciesintnodes.getState() ) { ag.setSpeciesInternalNodes( true ); }
            else                                { ag.setSpeciesInternalNodes( false ); }
            if   ( ecextnodes.getState() )      { ag.setECExtNodes( true ); }
            else                                { ag.setECExtNodes( false ); }
            if   ( ecintnodes.getState() )      { ag.setECInternalNodes( true ); }
            else                                { ag.setECInternalNodes( false ); }
            if   ( writelnl.getState() )        { ag.setWriteLnLValues( true ); }
            else                                { ag.setWriteLnLValues( false ); }
            if   ( writebl.getState() )         { ag.setWriteBranchLengthValues( true ); }
            else                                { ag.setWriteBranchLengthValues( false ); }
            if   ( writebootstrap.getState() )  { ag.setWriteBootstrapValues( true ); }
            else                                { ag.setWriteBootstrapValues( false ); }
            if   ( writed_s.getState() )        { ag.setWriteDupSpec( true ); }
            else                                { ag.setWriteDupSpec( false ); }
            if   ( colorbranches.getState() )   { ag.setColorBranchesAccToLnL( true ); }
            else                                { ag.setColorBranchesAccToLnL( false ); }
            if   ( drawpbranches.getState() )   { ag.setDrawBlOfSeqOnParent( true ); }
            else                                { ag.setDrawBlOfSeqOnParent( false ); }
            if   ( writepbl.getState() )        { ag.setWriteBlOfSeqOnParent( true ); }
            else                                { ag.setWriteBlOfSeqOnParent( false ); }
            if   ( editable.getState() )        { ag.setEditable( true ); }
            else                                { ag.setEditable( false ); }
            if   ( display_info.getState() ) {
                atvpanel.getATVgraphic().setActionWhenNodeClicked(
                ATVgraphic.SHOW_INFO );
            }
            if   ( collapse.getState() ) {
                atvpanel.getATVgraphic().setActionWhenNodeClicked(
                ATVgraphic.COLLAPSE );
            }
            if   ( reroot.getState() ) {
                atvpanel.getATVgraphic().setActionWhenNodeClicked(
                ATVgraphic.REROOT );
            }
            if   ( go_to_swissprot.getState() ) {
                atvpanel.getATVgraphic().setActionWhenNodeClicked(
                ATVgraphic_applet.GO_TO_SWISSPROT );
            }
            if   ( subtree.getState() ) {
                atvpanel.getATVgraphic().setActionWhenNodeClicked(
                ATVgraphic.SUBTREE );
            }
            if   ( swap.getState() ) {
                atvpanel.getATVgraphic().setActionWhenNodeClicked(
                ATVgraphic.SWAP );
            }
        }        
        atvpanel.adjustJScrollPane();
        atvpanel.getATVgraphic().repaint();
        atvpanel.validate();
    }    

}


