.TH "hmmconvert" 1 "@RELEASEDATE@" "HMMER @RELEASE@" "HMMER Manual"

.SH NAME
.TP 
hmmconvert - convert between profile HMM file formats

.SH SYNOPSIS
.B hmmconvert
.I [options]
.I oldhmmfile
.I newhmmfile

.SH DESCRIPTION

.B hmmconvert
reads an HMM file from
.I oldhmmfile
in any HMMER format, and writes it to a new file
.I newhmmfile 
in a new format.
.I oldhmmfile 
and 
.I newhmmfile
must be different files; you can't reliably overwrite 
the old file.
By default, the new HMM file is written in HMMER 2
ASCII format. 

Available formats are HMMER 2 ASCII (default), HMMER 2 binary
.I (-b)
GCG profile 
.I (-p)
, and Compugen XSW extended profile 
.I (-P).

.SH OPTIONS

.TP
.B -a 
Convert to HMMER 2 ASCII file. This is the default, so this option
is unnecessary.

.TP 
.B -b 
Convert to HMMER 2 binary file. 

.TP
.B -h
Print brief help; includes version number and summary of
all options, including expert options.

.TP
.B -p
Convert to GCG profile .prf format.

.TP 
.B -A
Append mode; append to
.I newhmmfile
rather than creating a new file. 

.TP
.B -F
Force; if 
.I newhmmfile
already exists, and
.I -A 
is not being used to append to the file,
hmmconvert will refuse to clobber the existing
file unless 
.I -F 
is used.

.TP
.B -P
Convert the HMM to Compugen XSW extended profile format,
which is similar to GCG profile format but has two
extra columns for delete-open and delete-extend costs.
(I do not believe that Compugen publicly supports this
format; it may be undocumented.)

.SH SEE ALSO

.PP
Master man page, with full list of and guide to the individual man
pages: see 
.B hmmer(1).
.PP
A User guide and tutorial came with the distribution:
.B Userguide.ps
[Postscript] and/or
.B Userguide.pdf
[PDF].
.PP
Finally, all documentation is also available online via WWW: 
.B http://hmmer.wustl.edu/

.SH AUTHOR

This software and documentation is: 
.nf
@COPYRIGHT@
HMMER - Biological sequence analysis with profile HMMs
Copyright (C) 1992-1999 Washington University School of Medicine
All Rights Reserved

    This source code is distributed under the terms of the
    GNU General Public License. See the files COPYING and LICENSE
    for details.
.fi
See the file COPYING in your distribution for complete details.

.nf
Sean Eddy
HHMI/Dept. of Genetics
Washington Univ. School of Medicine
4566 Scott Ave.
St Louis, MO 63110 USA
Phone: 1-314-362-7666
FAX  : 1-314-362-7855
Email: eddy@genetics.wustl.edu
.fi


