.TH "shuffle" 1 "@RELEASEDATE@" "@PACKAGE@ @RELEASE@" "@PACKAGE@ Manual"

.SH NAME
.TP 
shuffle - randomize the sequences in a sequence file

.SH SYNOPSIS
.B shuffle
.I [options]
.I seqfile

.SH DESCRIPTION

.B shuffle
reads a sequence file
.I seqfile,
randomizes each sequence, and prints the randomized sequences
in FASTA format on standard output. The sequence names
are unchanged; this allows you to track down the source
of each randomized sequence if necessary.

.pp
The default is to simply shuffle each input sequence, preserving
monosymbol composition exactly. To shuffle
each sequence while preserving both its monosymbol and disymbol
composition exactly, use the
.I -d 
option.

.pp
The
.I -0
and 
.I -1
options allow you to generate sequences with the same
Markov properties as each input sequence. With
.I -0,
for each input sequence, 0th order Markov statistics
are collected (e.g. symbol composition), and a new
sequence is generated with the same composition.
With 
.I -1, 
the generated sequence has the same 1st order 
Markov properties as the input sequence (e.g.
the same disymbol frequencies). 

.pp
Note that the default and
.I -0,
or 
.I -d
and 
.I -1,
are similar; the shuffling algorithms preserve
composition exactly, while the Markov algorithms
only expect to generate a sequence of similar
composition on average.

.pp
Other shuffling algorithms are also available,
as documented below in the options.

.SH OPTIONS

.TP
.B -0
Calculate 0th order Markov frequencies of each input sequence
(e.g. residue composition); generate output sequence 
using the same 0th order Markov frequencies.

.TP
.B -1
Calculate 1st order Markov frequencies for each input
sequence (e.g. diresidue composition); generate output
sequence using the same 1st order Markov frequencies.
The first residue of the output sequence is always
the same as the first residue of the input sequence.

.TP
.B -d
Shuffle the input sequence while preserving both
monosymbol and disymbol composition exactly. Uses
an algorithm published by  S.F. Altschul and B.W. Erickson,
Mol. Biol. Evol. 2:526-538, 1985. 

.TP
.B -h
Print brief help; includes version number and summary of
all options, including expert options.

.TP
.B -l
Look only at the length of each input sequence; generate
an i.i.d. output protein sequence of that length,
using monoresidue frequencies typical of proteins
(taken from Swissprot 35).

.TP
.BI -n " <n>"
Make 
.I <n>
different randomizations of each input sequence in
.I seqfile, 
rather than the default of one.

.TP
.B -r
Generate the output sequence by reversing the
input sequence. (Therefore only one "randomization"
per input sequence is possible, so it's
not worth using 
.I -n
if you use reversal.)

.TP
.BI -t " <n>"
Truncate each input sequence to a fixed length of exactly
.I <n>
residues. If the input sequence is shorter than
.I <n>
it is discarded (therefore the output file may contain
fewer sequences than the input file). 
If the input sequence is longer than 
.I <n>
a contiguous subsequence is randomly chosen.

.TP
.BI -w " <n>"
Regionally shuffle each input sequence in window sizes of
.I <n>,
preserving local residue composition in each window.
Probably a better shuffling algorithm for biosequences
with nonstationary residue composition (e.g. composition
that is varying along the sequence, such as between
different isochores in human genome sequence).

.TP
.B -B
(Babelfish). Autodetect and read a sequence file format other than the
default (FASTA). Almost any common sequence file format is recognized
(including Genbank, EMBL, SWISS-PROT, PIR, and GCG unaligned sequence
formats, and Stockholm, GCG MSF, and Clustal alignment formats). See
the printed documentation for a complete list of supported formats.

.SH EXPERT OPTIONS

.TP
.BI --informat " <s>"
Specify that the sequence file is in format 
.I <s>,
rather than the default FASTA format.
Common examples include Genbank, EMBL, GCG, 
PIR, Stockholm, Clustal, MSF, or PHYLIP; 
see the printed documentation for a complete list
of accepted format names.
This option overrides the default expected format (FASTA)
and the 
.I -B
Babelfish autodetection option.

.TP
.B --nodesc
Do not output any sequence description in the output file,
only the sequence names.

.TP
.BI --seed " <s>"
Set the random number seed to 
.I <s>.
If you want reproducible results, use the same seed each time.
By default, 
.B shuffle 
uses a different seed each time, so does not generate
the same output in subsequent runs with the same input. 

.SH SEE ALSO

.PP
@SEEALSO@

.SH AUTHOR

@PACKAGE@ and its documentation is @COPYRIGHT@
HMMER - Biological sequence analysis with profile HMMs
Copyright (C) 1992-1999 Washington University School of Medicine
All Rights Reserved

    This source code is distributed under the terms of the
    GNU General Public License. See the files COPYING and LICENSE
    for details.
See COPYING in the source code distribution for more details, or contact me.

.nf
Sean Eddy
Dept. of Genetics
Washington Univ. School of Medicine
4566 Scott Ave.
St Louis, MO 63110 USA
Phone: 1-314-362-7666
FAX  : 1-314-362-7855
Email: eddy@genetics.wustl.edu
.fi


