.TH "sfetch" 1 "@RELEASEDATE@" "@PACKAGE@ @RELEASE@" "@PACKAGE@ Manual"

.SH NAME
.TP 
sfetch - get a sequence from a flatfile database.

.SH SYNOPSIS
.B sfetch
.I [options]
.I seqname

.SH DESCRIPTION

.B sfetch
retrieves the sequence named
.I seqname
from a sequence database.

.PP
Which database is used is controlled by the
.B -d 
and 
.B -D
options, or "little databases" and "big
databases".
The directory location of "big databases" can
be specified by environment variables,
such as $SWDIR for Swissprot, and $GBDIR
for Genbank (see
.B -D 
for complete list). 
A complete file path must be specified
for "little databases".
By default, if neither option is specified
and the name looks like a Swissprot identifier
(e.g. it has a _ character), the $SWDIR
environment variable is used to attempt
to retrieve the sequence 
.I seqname
from Swissprot.

.PP
A variety of other options are available which allow
retrieval of subsequences
.RI ( -f,-t );
retrieval by accession number instead of
by name 
.RI ( -a );
reformatting the extracted sequence into a variety
of other formats
.RI ( -F );
etc.

.PP
If the database has been GSI indexed, sequence
retrieval will be extremely efficient; else,
retrieval may be painfully slow (the entire
database may have to be read into memory to
find 
.IR seqname ).
GSI indexing
is recommended for all large or permanent 
databases. 

.pp
This program was originally named 
.B getseq,
and was renamed because it clashed with a GCG
program of the same name.

.SH OPTIONS

.TP
.B -a 
Interpret 
.I seqname
as an accession number, not an identifier.

.TP 
.BI -d " <seqfile>"
Retrieve the sequence from a sequence file named
.I <seqfile>.
If a GSI index 
.I <seqfile>.gsi
exists, it is used to speed up the retrieval.

.TP
.BI -f " <from>"
Extract a subsequence starting from position
.I <from>,
rather than from 1. See
.B -t.
If 
.I <from> 
is greater than
.I <to>
(as specified by the
.B -t
option), then the sequence is extracted as 
its reverse complement (it is assumed to be
nucleic acid sequence).

.TP
.B -h
Print brief help; includes version number and summary of
all options, including expert options.

.TP
.BI -o " <outfile>" 
Direct the output to a file named
.I <outfile>.
By default, output would go to stdout. 

.TP
.BI -r " <newname>"
Rename the sequence
.I <newname>
in the output after extraction. By default, the original
sequence identifier would be retained. Useful, for instance,
if retrieving a sequence fragment; the coordinates of
the fragment might be added to the name (this is what Pfam
does).

.TP
.BI -t " <to>"
Extract a subsequence that ends at position
.I <to>,
rather than at the end of the sequence. See
.B -f.
If 
.I <to> 
is less than
.I <from>
(as specified by the
.B -f
option), then the sequence is extracted as 
its reverse complement (it is assumed to be
nucleic acid sequence)

.TP
.B -B
(Babelfish). Autodetect and read a sequence file format other than the
default (FASTA). Almost any common sequence file format is recognized
(including Genbank, EMBL, SWISS-PROT, PIR, and GCG unaligned sequence
formats, and Stockholm, GCG MSF, and Clustal alignment formats). See
the printed documentation for a complete list of supported formats.


.TP
.BI -D " <database>"
Retrieve the sequence from the main sequence database
coded 
.I <database>. For each code, there is an environment
variable that specifies the directory path to that
database.
Recognized codes and their corresponding environment
variables are
.I -Dsw
(Swissprot, $SWDIR);
.I -Dpir
(PIR, $PIRDIR);
.I -Dem
(EMBL, $EMBLDIR);
.I -Dgb
(Genbank, $GBDIR);
.I -Dwp 
(Wormpep, $WORMDIR); and
.I -Dowl
(OWL, $OWLDIR).
Each database is read in its native flatfile format.

.TP
.BI -F " <format>"
Reformat the extracted sequence into a different format.
(By default, the sequence is extracted from the database
in the same format as the database.) Available formats
are
.B embl, fasta, genbank, gcg, strider, zuker, ig, pir, squid,
and
.B raw.

.SH EXPERT OPTIONS

.TP
.BI --informat " <s>"
Specify that the sequence file is in format 
.I <s>,
rather than the default FASTA format.
Common examples include Genbank, EMBL, GCG, 
PIR, Stockholm, Clustal, MSF, or PHYLIP; 
see the printed documentation for a complete list
of accepted format names.
This option overrides the default format (FASTA)
and the 
.I -B
Babelfish autodetection option.

.SH SEE ALSO

.PP
@SEEALSO@

.SH AUTHOR

@PACKAGE@ and its documentation is @COPYRIGHT@
HMMER - Biological sequence analysis with profile HMMs
Copyright (C) 1992-1999 Washington University School of Medicine
All Rights Reserved

    This source code is distributed under the terms of the
    GNU General Public License. See the files COPYING and LICENSE
    for details.
See COPYING in the source code distribution for more details, or contact me.

.nf
Sean Eddy
Dept. of Genetics
Washington Univ. School of Medicine
4566 Scott Ave.
St Louis, MO 63110 USA
Phone: 1-314-362-7666
FAX  : 1-314-362-7855
Email: eddy@genetics.wustl.edu
.fi


