.TH "hmmemit" 1 @RELEASEDATE@ "HMMER @RELEASE@" "HMMER Manual"

.SH NAME
.TP 
hmmemit - generate sequences from a profile HMM

.SH SYNOPSIS
.B hmmemit
.I [options]
.I hmmfile

.SH DESCRIPTION

.B hmmemit
reads an HMM file from
.I hmmfile
containing one or more HMMs,
and generates a number of sequences from each HMM;
or, if the
.B -c
option is selected, generate a single majority-rule consensus.
This can be useful for various applications in which one needs a simulation
of sequences consistent with a sequence family consensus. 

.pp
By default,
.B hmmemit
generates 10 sequences and outputs them in FASTA (unaligned) format.

.SH OPTIONS

.TP
.B -a
Write the generated sequences in an aligned format (SELEX) rather than
FASTA.

.TP
.B -c
Predict a single majority-rule consensus sequence instead of sampling
sequences from the HMM's probability distribution.  Highly conserved
residues (p >= 0.9 for DNA, p >= 0.5 for protein) are shown in upper
case; others are shown in lower case.  Some insert states may become
part of the majority rule consensus, because they are used in >= 50%
of generated sequences; when this happens, insert-generated residues
are simply shown as "x".

.TP
.B -h
Print brief help; includes version number and summary of
all options, including expert options.

.TP
.BI -n " <n>"
Generate
.I <n> 
sequences. Default is 10.

.TP
.BI -o " <f>"
Save the synthetic sequences to file
.I <f>
rather than writing them to stdout.

.TP
.B -q
Quiet; suppress all output except for the sequences themselves.
Useful for piping or directing the output.

.SH EXPERT OPTIONS

.TP
.BI --seed " <n>"
Set the random seed to
.I <n>,
where 
.I <n> 
is a positive integer. The default is to use 
.B time()
to generate a different seed for each run, which
means that two different runs of
.B hmmemit
on the same HMM will give slightly different
results.  You can use
this option to generate reproducible results.



.SH SEE ALSO

.PP
Master man page, with full list of and guide to the individual man
pages: see 
.B hmmer(1).
.PP
A User guide and tutorial came with the distribution:
.B Userguide.ps
[Postscript] and/or
.B Userguide.pdf
[PDF].
.PP
Finally, all documentation is also available online via WWW: 
.B http://hmmer.wustl.edu/

.SH AUTHOR

This software and documentation is: 
.nf
@COPYRIGHT@
HMMER - Biological sequence analysis with profile HMMs
Copyright (C) 1992-1999 Washington University School of Medicine
All Rights Reserved

    This source code is distributed under the terms of the
    GNU General Public License. See the files COPYING and LICENSE
    for details.
.fi
See the file COPYING in your distribution for complete details.

.nf
Sean Eddy
HHMI/Dept. of Genetics
Washington Univ. School of Medicine
4566 Scott Ave.
St Louis, MO 63110 USA
Phone: 1-314-362-7666
FAX  : 1-314-362-7855
Email: eddy@genetics.wustl.edu
.fi


