.TH "hmmbuild" 1 "@HMMER_DATE@" "HMMER @HMMER_VERSION@" "HMMER Manual"

.SH NAME
hmmbuild - construct profile HMM(s) from multiple sequence alignment(s)

.SH SYNOPSIS
.B hmmbuild
.I [options]
.I hmmfile
.I msafile


.SH DESCRIPTION

Build a profile HMM for 
each multiple sequence alignment in 
.I msafile,
and save it to a new file
.I hmmfile.



.SH OPTIONS

.TP
.B -h
Help; print a brief reminder of command line usage and all available
options.

.TP
.BI -n " <s>"
Name the new profile 
.I <s>.
The default is to use the name of the alignment (if one is present in 
the 
.I msafile,
or, failing that, the name of the
.I hmmfile.
If 
.I msafile
contains more than one alignment, 
.I -n
doesn't work, and every alignment must have a name 
annotated in the 
.I msafile
(as in Stockholm #=GF ID annotation).


.TP
.BI -o " <f>"
Direct the summary output to file
.I <f>,
rather than to
.I stdout.

.TP
.BI -O " <f>"
After each model is constructed, resave annotated, possibly modified
source alignments to a file
.I <f>
in Stockholm format.
The alignments are annotated with a reference annotation line
indicating which columns were assigned as consensus, and sequences are
annotated with what relative sequence weights were assigned. Some
residues of the alignment may have been shifted to accommodate
restrictions of the Plan7 profile architecture, which disallows
transitions between insert and delete states.


.SH OPTIONS FOR SPECIFYING THE ALPHABET

The alphabet type (amino, DNA, or RNA) is autodetected by default, by
looking at the composition of the
.I msafile.
Autodetection is normally quite reliable, but occasionally alphabet
type may be ambiguous and autodetection can fail (for instance, on
tiny toy alignments of just a few residues). To avoid this, or to
increase robustness in automated analysis pipelines, you may specify
the alphabet type of
.I msafile
with these options.

.TP
.B --amino
Specify that all sequences in 
.I msafile
are proteins.

.TP
.B --dna
Specify that all sequences in 
.I msafile
are DNAs.

.TP
.B --rna
Specify that all sequences in 
.I msafile
are RNAs.



.SH OPTIONS CONTROLLING PROFILE CONSTRUCTION 

These options control how consensus columns are defined in an alignment.

.TP
.B --fast 
Define consensus columns as those that have a fraction >= 
.B symfrac
of residues as opposed to gaps. (See below for the
.B --symfrac
option.) This is the default.

.TP
.B --hand
Define consensus columns in next profile using reference annotation to
the multiple alignment. 
This allows you to define any consensus columns you like.

.TP
.BI --symfrac " <x>"
Define the residue fraction threshold necessary to define a
consensus column when using the 
.B --fast 
option. The default is 0.5. The symbol fraction in each column
is calculated after taking relative sequence weighting into account,
and ignoring gap characters corresponding to ends of sequence
fragments
(as opposed to internal insertions/deletions).
Setting this to 1.0 means that every alignment column will be assigned
as consensus, which may be useful in some cases. Setting it to 0.0 is
a bad idea, because no columns will be assigned as consensus, and
you'll get a model of zero length.

.TP
.BI --fragthresh " <x>"
We only want to count terminal gaps as deletions if the aligned
sequence is known to be full-length, not if it is a fragment (for
instance, because only part of it was sequenced). HMMER uses a simple
rule to infer fragments: if the sequence length L is less than 
a fraction
.I <x> 
times the mean sequence length of all the sequences in the alignment,
then the sequence is handled as a fragment. The default is 0.5.



.SH OPTIONS CONTROLLING RELATIVE WEIGHTS

HMMER uses an ad hoc sequence weighting algorithm to downweight
closely related sequences and upweight distantly related ones. This
has the effect of making models less biased by uneven phylogenetic
representation. For example, two identical sequences would typically
each receive half the weight that one sequence would.  These options
control which algorithm gets used.

.TP
.B --wpb
Use the Henikoff position-based sequence weighting scheme [Henikoff
and Henikoff, J. Mol. Biol. 243:574, 1994].  This is the default.

.TP 
.B --wgsc 
Use the Gerstein/Sonnhammer/Chothia weighting algorithm [Gerstein et
al, J. Mol. Biol. 235:1067, 1994].

.TP 
.B --wblosum
Use the same clustering scheme that was used to weight data in
calculating BLOSUM subsitution matrices [Henikoff and Henikoff,
Proc. Natl. Acad. Sci 89:10915, 1992]. Sequences are single-linkage
clustered at an identity threshold (default 0.62; see
.I --wid)
and within each cluster of c sequences, each sequence gets relative
weight 1/c.

.TP
.B --wnone
No relative weights. All sequences are assigned uniform weight. 

.TP 
.BI --wid " <x>"
Sets the identity threshold used by single-linkage clustering when 
using 
.I --wblosum. 
Invalid with any other weighting scheme. Default is 0.62.




.SH OPTIONS CONTROLLING EFFECTIVE SEQUENCE NUMBER

After relative weights are determined, they are normalized to sum to a
total effective sequence number, 
.I eff_nseq. 
This number may be the actual number of sequences in the alignment,
but it is almost always smaller than that.
The default entropy weighting method 
.I (--eent)
reduces the effective sequence
number to reduce the information content (relative entropy, or average
expected score on true homologs) per consensus position. The target
relative entropy is controlled by a two-parameter function, where the
two parameters are settable with
.I --ere
and 
.I --esigma.

.TP
.B --eent
Adjust effective sequence number to achieve a specific relative entropy
per position (see
.I --ere).
This is the default.

.TP
.B --eclust
Set effective sequence number to the number of single-linkage clusters
at a specific identity threshold (see 
.I --eid).
This option is not recommended; it's for experiments evaluating
how much better
.B --eent
is.

.TP
.B --enone
Turn off effective sequence number determination and just use the
actual number of sequences. One reason you might want to do this is
to try to maximize the relative entropy/position of your model, which
may be useful for short models.

.TP
.BI --eset " <x>"
Explicitly set the effective sequence number for all models to 
.I <x>.

.TP
.BI --ere " <x>"
Set the minimum relative entropy/position target to 
.I <x>.
Requires
.B --eent. 
Default depends on the sequence alphabet; for protein
sequences, it is 0.59 bits/position.

.TP
.BI --esigma " <x>"
Sets the minimum relative entropy contributed by an entire
model alignment, over its whole length. This has the effect
of making short models have 
higher relative entropy per position than 
.I --ere 
alone would give. The default is 45.0 bits.

.TP
.BI --eid " <x>"
Sets the fractional pairwise identity cutoff used by 
single linkage clustering with the
.B --eclust 
option. The default is 0.62.


.SH OPTIONS CONTROLLING E-VALUE CALIBRATION

The location parameters for the expected score distributions for MSV
filter scores, Viterbi filter scores, and Forward scores require three
short random sequence simulations.

.TP
.BI --EmL " <n>"
Sets the sequence length in simulation that estimates the location
parameter mu for MSV filter E-values. Default is 200.

.TP
.BI --EmN " <n>"
Sets the number of sequences in simulation that estimates the location
parameter mu for MSV filter E-values. Default is 200.

.TP
.BI --EvL " <n>"
Sets the sequence length in simulation that estimates the location
parameter mu for Viterbi filter E-values. Default is 200.

.TP
.BI --EvN " <n>"
Sets the number of sequences in simulation that estimates the location
parameter mu for Viterbi filter E-values. Default is 200.

.TP
.BI --EfL " <n>"
Sets the sequence length in simulation that estimates the location
parameter tau for Forward E-values. Default is 100.

.TP
.BI --EfN " <n>"
Sets the number of sequences in simulation that estimates the location
parameter tau for Forward E-values. Default is 200.

.TP
.BI --Eft " <x>"
Sets the tail mass fraction to fit in the simulation that estimates
the location parameter tau for Forward evalues. Default is 0.04.


.SH OTHER OPTIONS

.TP
.B --mpi
Run as a parallel MPI program. Each alignment is assigned to a MPI
worker node for construction. (Therefore, the maximum parallelization 
cannot exceed the number of alignments in the input
.I msafile.)
This is useful when building large profile libraries. This option is
only available if optional MPI capability was enabled at compile-time.

.TP 
.BI --informat " <s>"
Declare that the input
.I msafile
is in format 
.I <s>.
Currently the accepted multiple alignment sequence file formats only
include Stockholm and SELEX. Default is to autodetect the format of
the file.

.TP 
.BI --seed " <n>"
Seed the random number generator with
.I <n>,
an integer >= 0. 
If 
.I <n> 
is nonzero, any stochastic simulations will be reproducible; the same
command will give the same results.
If 
.I <n>
is 0, the random number generator is seeded arbitrarily, and
stochastic simulations will vary from run to run of the same command.
The default seed is 42.

.B --laplace
Experimental only: use a Laplace +1 prior in place of the default
mixture Dirichlet prior.

.TP 
.B --stall
For debugging MPI parallelization: arrest program execution
immediately after start, and wait for a debugger to attach to the
running process and release the arrest.




.SH SEE ALSO 

See 
.B hmmer(1)
for a master man page with a list of all the individual man pages
for programs in the HMMER package.

.PP
For complete documentation, see the user guide that came with your
HMMER distribution (Userguide.pdf); or see the HMMER web page
(@HMMER_URL@).



.SH COPYRIGHT

.nf
@HMMER_COPYRIGHT@
@HMMER_LICENSE@
.fi

For additional information on copyright and licensing, see the file
called COPYRIGHT in your HMMER source distribution, or see the HMMER
web page 
(@HMMER_URL@).


.SH AUTHOR

.nf
Eddy/Rivas Laboratory
Janelia Farm Research Campus
19700 Helix Drive
Ashburn VA 20147 USA
http://eddylab.org
.fi

