.TH "sreformat" 1 "@RELEASEDATE@" "@PACKAGE@ @RELEASE@" "@PACKAGE@ Manual"

.SH NAME
.TP 
sreformat - convert sequence file to different format

.SH SYNOPSIS
.B sreformat
.I [options]
.I format
.I seqfile

.SH DESCRIPTION

.B sreformat
reads the sequence file
.I seqfile
in any supported format, reformats it
into a new format specified by 
.I format,
then prints the reformatted text.

.PP
Supported input formats include (but are not limited to) the unaligned
formats FASTA, Genbank, EMBL, SWISS-PROT, PIR, and GCG, and the
aligned formats Stockholm, Clustal, GCG MSF, and Phylip.

.PP
Available unaligned output file format codes 
include
.I fasta
(FASTA format);
.I embl
(EMBL/SWISSPROT format);
.I genbank
(Genbank format);
.I gcg
(GCG single sequence format);
.I gcgdata
(GCG flatfile database format);
.I strider
(MacStrider format);
.I zuker
(Zuker MFOLD format);
.I ig
(Intelligenetics format);
.I pir
(PIR/CODATA flatfile format);
.I squid
(an undocumented St. Louis format);
.I raw
(raw sequence, no other information).

.pp
The available aligned output file format
codes include
.I stockholm
(PFAM/Stockholm format);
.I msf
(GCG MSF format); 
.I a2m
(aligned FASTA format, called A2M by the UC Santa Cruz
HMM group);
.I PHYLIP
(Felsenstein's PHYLIP format); and
.I selex
(old SELEX/HMMER/Pfam annotated alignment format);

.pp
All thee codes are interpreted case-insensitively
(e.g. MSF, Msf, or msf all work).

.PP 
Unaligned format files cannot be reformatted to
aligned formats.
However, aligned formats can be reformatted
to unaligned formats -- gap characters are 
simply stripped out.

.PP
This program was originally named
.B reformat,
but that name clashes with a GCG program of the same name.

.SH OPTIONS

.TP
.B -a
Enable alignment reformatting. By default, sreformat expects
that the input file should be handled as an unaligned input
file (even if it is an alignment), and it will not allow you
to convert an unaligned file to an alignment (for obvious
reasons).
.pp
This may seem silly; surely if sreformat can autodetect and parse
alignment file formats as input, it can figure out when it's got an
alignment! There are two reasons.  One is just the historical
structure of the code. The other is that FASTA unaligned format and
A2M aligned format (aligned FASTA) are impossible to tell apart with
100% confidence.

.TP
.B -d 
DNA; convert U's to T's, to make sure a nucleic acid
sequence is shown as DNA not RNA. See
.B -r.

.TP
.B -h
Print brief help; includes version number and summary of
all options, including expert options.

.TP
.B -l
Lowercase; convert all sequence residues to lower case.
See
.B -u.

.TP
.B -r 
RNA; convert T's to U's, to make sure a nucleic acid
sequence is shown as RNA not DNA. See
.B -d.

.TP
.B -u
Uppercase; convert all sequence residues to upper case.
See
.B -l.

.TP
.B -x
For DNA sequences, convert non-IUPAC characters (such as X's) to N's.
This is for compatibility with benighted people who insist on using X
instead of the IUPAC ambiguity character N. (X is for ambiguity
in an amino acid residue). 
.pp
Warning: the code doesn't
check that you are actually giving it DNA. It simply 
literally just converts non-IUPAC DNA symbols to N. So 
if you accidentally give it protein sequence, it will
happily convert most every amino acid residue to an N.

.TP
.B -B
(Babelfish). Autodetect and read a sequence file format other than the
default (FASTA). Almost any common sequence file format is recognized
(including Genbank, EMBL, SWISS-PROT, PIR, and GCG unaligned sequence
formats, and Stockholm, GCG MSF, and Clustal alignment formats). See
the printed documentation for a complete list of supported formats.


.SH EXPERT OPTIONS

.TP
.BI --informat " <s>"
Specify that the sequence file is in format 
.I <s>,
rather than the default FASTA format.
Common examples include Genbank, EMBL, GCG, 
PIR, Stockholm, Clustal, MSF, or PHYLIP; 
see the printed documentation for a complete list
of accepted format names.
This option overrides the default format (FASTA)
and the 
.I -B
Babelfish autodetection option.

.TP
.B --mingap
If 
.I seqfile
is an alignment, remove any columns that contain 100% gap
characters, minimizing the overall length of the alignment.
(Often useful if you've extracted a subset of aligned
sequences from a larger alignment.)

.TP
.B --pfam
For SELEX alignment output format only, put the entire
alignment in one block (don't wrap into multiple blocks).
This is close to the format used internally by Pfam
in Stockholm and Cambridge.

.TP
.B --sam
Try to convert gap characters to UC Santa Cruz SAM style, where a .
means a gap in an insert column, and a - means a
deletion in a consensus/match column. This only
works for converting aligned file formats, and only
if the alignment already adheres to the SAM convention
of upper case for residues in consensus/match columns,
and lower case for residues in insert columns. This is
true, for instance, of all alignments produced by old
versions of HMMER. (HMMER2 produces alignments
that adhere to SAM's conventions even in gap character choice.)
This option was added to allow Pfam alignments to be
reformatted into something more suitable for profile HMM
construction using the UCSC SAM software.

.TP
.BI --samfrac " <x>"
Try to convert the alignment gap characters and
residue cases to UC Santa Cruz SAM style, where a .
means a gap in an insert column and a - means a
deletion in a consensus/match column, and 
upper case means match/consensus residues and
lower case means inserted resiudes. This will only
work for converting aligned file formats, but unlike the
.B --sam 
option, it will work regardless of whether the file adheres
to the upper/lower case residue convention. Instead, any 
column containing more than a fraction 
.I <x> 
of gap characters is interpreted as an insert column,
and all other columns are interpreted as match columns.
This option was added to allow Pfam alignments to be
reformatted into something more suitable for profile HMM
construction using the UCSC SAM software.

.SH SEE ALSO

.PP
@SEEALSO@

.SH AUTHOR

@PACKAGE@ and its documentation are @COPYRIGHT@
INFERNAL - inference of RNA secondary structure alignments
Copyright (C) 2002-2003 Washington University, Saint Louis 

    This source code is freely distributed under the terms of the
    GNU General Public License. See the files COPYRIGHT and LICENSE
    for details.
See COPYING in the source code distribution for more details, or contact me.

.nf
Sean Eddy
Dept. of Genetics
Washington Univ. School of Medicine
4566 Scott Ave.
St Louis, MO 63110 USA
Phone: 1-314-362-7666
FAX  : 1-314-362-7855
Email: eddy@genetics.wustl.edu
.fi


